/***************************************************************************
*
* GLee.c
* GLee (OpenGL Easy Extension library)        
* Version : 5.4
*
* Copyright (c)2009  Ben Woodhouse  All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions are 
* met:
* 1. Redistributions of source code must retain the above copyright
* notice, this list of conditions and the following disclaimer as
* the first lines of this file unmodified.
* 2. Redistributions in binary form must reproduce the above copyright
* notice, this list of conditions and the following disclaimer in the
* documentation and/or other materials provided with the distribution.
*
* THIS SOFTWARE IS PROVIDED BY BEN WOODHOUSE ``AS IS'' AND ANY EXPRESS OR
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
* IN NO EVENT SHALL BEN WOODHOUSE BE LIABLE FOR ANY DIRECT, INDIRECT,
* INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
* NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
* DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
* THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
* THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

* Web: http://elf-stone.com/glee.php
*
* [This file was automatically generated by GLeeGen 7.0
*
***************************************************************************/

#ifdef _MSC_VER
	#pragma optimize( "g", off )
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "GLee.h"

#if defined(__APPLE__) || defined(__APPLE_CC__)
	#include <Carbon/Carbon.h>
#endif

typedef GLuint(*GLEE_LINK_FUNCTION)(void);

GLboolean __GLeeInited=GL_FALSE;

#ifndef _WIN32
	#define __stdcall  /* nothing */
#endif 

void * __GLeeGetProcAddress(const char *extname)
{
#ifdef WIN32
	return (void*)wglGetProcAddress(extname);
#elif defined(__APPLE__) || defined(__APPLE_CC__)
    CFBundleRef bundle;
    CFURLRef bundleURL = CFURLCreateWithFileSystemPath(kCFAllocatorDefault, CFSTR("/System/Library/Frameworks/OpenGL.framework"), kCFURLPOSIXPathStyle, true);

    CFStringRef functionName = CFStringCreateWithCString(kCFAllocatorDefault, extname, kCFStringEncodingASCII);

    void *function;

    bundle = CFBundleCreate(kCFAllocatorDefault, bundleURL);
    assert(bundle != NULL);

    function = CFBundleGetFunctionPointerForName(bundle, functionName);

    CFRelease(bundleURL);
    CFRelease(functionName);
    CFRelease(bundle);

    return function;
#elif defined(HAVE_GLES)
    void *ret=NULL;
    return ret;
#else
	return (void*)glXGetProcAddressARB((const GLubyte *)extname);
#endif
}




/* Extension querying variables */

GLboolean _GLEE_VERSION_1_2 = GL_FALSE;
GLboolean _GLEE_ARB_imaging = GL_FALSE;
GLboolean _GLEE_VERSION_1_3 = GL_FALSE;
GLboolean _GLEE_VERSION_1_4 = GL_FALSE;
GLboolean _GLEE_VERSION_1_5 = GL_FALSE;
GLboolean _GLEE_VERSION_2_0 = GL_FALSE;
GLboolean _GLEE_VERSION_2_1 = GL_FALSE;
GLboolean _GLEE_VERSION_3_0 = GL_FALSE;
GLboolean _GLEE_ARB_multitexture = GL_FALSE;
GLboolean _GLEE_ARB_transpose_matrix = GL_FALSE;
GLboolean _GLEE_ARB_multisample = GL_FALSE;
GLboolean _GLEE_ARB_texture_env_add = GL_FALSE;
GLboolean _GLEE_ARB_texture_cube_map = GL_FALSE;
GLboolean _GLEE_ARB_texture_compression = GL_FALSE;
GLboolean _GLEE_ARB_texture_border_clamp = GL_FALSE;
GLboolean _GLEE_ARB_point_parameters = GL_FALSE;
GLboolean _GLEE_ARB_vertex_blend = GL_FALSE;
GLboolean _GLEE_ARB_matrix_palette = GL_FALSE;
GLboolean _GLEE_ARB_texture_env_combine = GL_FALSE;
GLboolean _GLEE_ARB_texture_env_crossbar = GL_FALSE;
GLboolean _GLEE_ARB_texture_env_dot3 = GL_FALSE;
GLboolean _GLEE_ARB_texture_mirrored_repeat = GL_FALSE;
GLboolean _GLEE_ARB_depth_texture = GL_FALSE;
GLboolean _GLEE_ARB_shadow = GL_FALSE;
GLboolean _GLEE_ARB_shadow_ambient = GL_FALSE;
GLboolean _GLEE_ARB_window_pos = GL_FALSE;
GLboolean _GLEE_ARB_vertex_program = GL_FALSE;
GLboolean _GLEE_ARB_fragment_program = GL_FALSE;
GLboolean _GLEE_ARB_vertex_buffer_object = GL_FALSE;
GLboolean _GLEE_ARB_occlusion_query = GL_FALSE;
GLboolean _GLEE_ARB_shader_objects = GL_FALSE;
GLboolean _GLEE_ARB_vertex_shader = GL_FALSE;
GLboolean _GLEE_ARB_fragment_shader = GL_FALSE;
GLboolean _GLEE_ARB_shading_language_100 = GL_FALSE;
GLboolean _GLEE_ARB_texture_non_power_of_two = GL_FALSE;
GLboolean _GLEE_ARB_point_sprite = GL_FALSE;
GLboolean _GLEE_ARB_fragment_program_shadow = GL_FALSE;
GLboolean _GLEE_ARB_draw_buffers = GL_FALSE;
GLboolean _GLEE_ARB_texture_rectangle = GL_FALSE;
GLboolean _GLEE_ARB_color_buffer_float = GL_FALSE;
GLboolean _GLEE_ARB_half_float_pixel = GL_FALSE;
GLboolean _GLEE_ARB_texture_float = GL_FALSE;
GLboolean _GLEE_ARB_pixel_buffer_object = GL_FALSE;
GLboolean _GLEE_ARB_depth_buffer_float = GL_FALSE;
GLboolean _GLEE_ARB_draw_instanced = GL_FALSE;
GLboolean _GLEE_ARB_framebuffer_object = GL_FALSE;
GLboolean _GLEE_ARB_framebuffer_sRGB = GL_FALSE;
GLboolean _GLEE_ARB_geometry_shader4 = GL_FALSE;
GLboolean _GLEE_ARB_half_float_vertex = GL_FALSE;
GLboolean _GLEE_ARB_instanced_arrays = GL_FALSE;
GLboolean _GLEE_ARB_map_buffer_range = GL_FALSE;
GLboolean _GLEE_ARB_texture_buffer_object = GL_FALSE;
GLboolean _GLEE_ARB_texture_compression_rgtc = GL_FALSE;
GLboolean _GLEE_ARB_texture_rg = GL_FALSE;
GLboolean _GLEE_ARB_vertex_array_object = GL_FALSE;
GLboolean _GLEE_EXT_abgr = GL_FALSE;
GLboolean _GLEE_EXT_blend_color = GL_FALSE;
GLboolean _GLEE_EXT_polygon_offset = GL_FALSE;
GLboolean _GLEE_EXT_texture = GL_FALSE;
GLboolean _GLEE_EXT_texture3D = GL_FALSE;
GLboolean _GLEE_SGIS_texture_filter4 = GL_FALSE;
GLboolean _GLEE_EXT_subtexture = GL_FALSE;
GLboolean _GLEE_EXT_copy_texture = GL_FALSE;
GLboolean _GLEE_EXT_histogram = GL_FALSE;
GLboolean _GLEE_EXT_convolution = GL_FALSE;
GLboolean _GLEE_SGI_color_matrix = GL_FALSE;
GLboolean _GLEE_SGI_color_table = GL_FALSE;
GLboolean _GLEE_SGIS_pixel_texture = GL_FALSE;
GLboolean _GLEE_SGIX_pixel_texture = GL_FALSE;
GLboolean _GLEE_SGIS_texture4D = GL_FALSE;
GLboolean _GLEE_SGI_texture_color_table = GL_FALSE;
GLboolean _GLEE_EXT_cmyka = GL_FALSE;
GLboolean _GLEE_EXT_texture_object = GL_FALSE;
GLboolean _GLEE_SGIS_detail_texture = GL_FALSE;
GLboolean _GLEE_SGIS_sharpen_texture = GL_FALSE;
GLboolean _GLEE_EXT_packed_pixels = GL_FALSE;
GLboolean _GLEE_SGIS_texture_lod = GL_FALSE;
GLboolean _GLEE_SGIS_multisample = GL_FALSE;
GLboolean _GLEE_EXT_rescale_normal = GL_FALSE;
GLboolean _GLEE_EXT_vertex_array = GL_FALSE;
GLboolean _GLEE_EXT_misc_attribute = GL_FALSE;
GLboolean _GLEE_SGIS_generate_mipmap = GL_FALSE;
GLboolean _GLEE_SGIX_clipmap = GL_FALSE;
GLboolean _GLEE_SGIX_shadow = GL_FALSE;
GLboolean _GLEE_SGIS_texture_edge_clamp = GL_FALSE;
GLboolean _GLEE_SGIS_texture_border_clamp = GL_FALSE;
GLboolean _GLEE_EXT_blend_minmax = GL_FALSE;
GLboolean _GLEE_EXT_blend_subtract = GL_FALSE;
GLboolean _GLEE_EXT_blend_logic_op = GL_FALSE;
GLboolean _GLEE_SGIX_interlace = GL_FALSE;
GLboolean _GLEE_SGIX_pixel_tiles = GL_FALSE;
GLboolean _GLEE_SGIS_texture_select = GL_FALSE;
GLboolean _GLEE_SGIX_sprite = GL_FALSE;
GLboolean _GLEE_SGIX_texture_multi_buffer = GL_FALSE;
GLboolean _GLEE_EXT_point_parameters = GL_FALSE;
GLboolean _GLEE_SGIS_point_parameters = GL_FALSE;
GLboolean _GLEE_SGIX_instruments = GL_FALSE;
GLboolean _GLEE_SGIX_texture_scale_bias = GL_FALSE;
GLboolean _GLEE_SGIX_framezoom = GL_FALSE;
GLboolean _GLEE_SGIX_tag_sample_buffer = GL_FALSE;
GLboolean _GLEE_FfdMaskSGIX = GL_FALSE;
GLboolean _GLEE_SGIX_polynomial_ffd = GL_FALSE;
GLboolean _GLEE_SGIX_reference_plane = GL_FALSE;
GLboolean _GLEE_SGIX_flush_raster = GL_FALSE;
GLboolean _GLEE_SGIX_depth_texture = GL_FALSE;
GLboolean _GLEE_SGIS_fog_function = GL_FALSE;
GLboolean _GLEE_SGIX_fog_offset = GL_FALSE;
GLboolean _GLEE_HP_image_transform = GL_FALSE;
GLboolean _GLEE_HP_convolution_border_modes = GL_FALSE;
GLboolean _GLEE_INGR_palette_buffer = GL_FALSE;
GLboolean _GLEE_SGIX_texture_add_env = GL_FALSE;
GLboolean _GLEE_EXT_color_subtable = GL_FALSE;
GLboolean _GLEE_PGI_vertex_hints = GL_FALSE;
GLboolean _GLEE_PGI_misc_hints = GL_FALSE;
GLboolean _GLEE_EXT_paletted_texture = GL_FALSE;
GLboolean _GLEE_EXT_clip_volume_hint = GL_FALSE;
GLboolean _GLEE_SGIX_list_priority = GL_FALSE;
GLboolean _GLEE_SGIX_ir_instrument1 = GL_FALSE;
GLboolean _GLEE_SGIX_calligraphic_fragment = GL_FALSE;
GLboolean _GLEE_SGIX_texture_lod_bias = GL_FALSE;
GLboolean _GLEE_SGIX_shadow_ambient = GL_FALSE;
GLboolean _GLEE_EXT_index_texture = GL_FALSE;
GLboolean _GLEE_EXT_index_material = GL_FALSE;
GLboolean _GLEE_EXT_index_func = GL_FALSE;
GLboolean _GLEE_EXT_index_array_formats = GL_FALSE;
GLboolean _GLEE_EXT_compiled_vertex_array = GL_FALSE;
GLboolean _GLEE_EXT_cull_vertex = GL_FALSE;
GLboolean _GLEE_SGIX_ycrcb = GL_FALSE;
GLboolean _GLEE_SGIX_fragment_lighting = GL_FALSE;
GLboolean _GLEE_IBM_rasterpos_clip = GL_FALSE;
GLboolean _GLEE_HP_texture_lighting = GL_FALSE;
GLboolean _GLEE_EXT_draw_range_elements = GL_FALSE;
GLboolean _GLEE_WIN_phong_shading = GL_FALSE;
GLboolean _GLEE_WIN_specular_fog = GL_FALSE;
GLboolean _GLEE_EXT_light_texture = GL_FALSE;
GLboolean _GLEE_SGIX_blend_alpha_minmax = GL_FALSE;
GLboolean _GLEE_SGIX_impact_pixel_texture = GL_FALSE;
GLboolean _GLEE_EXT_bgra = GL_FALSE;
GLboolean _GLEE_SGIX_async = GL_FALSE;
GLboolean _GLEE_SGIX_async_pixel = GL_FALSE;
GLboolean _GLEE_SGIX_async_histogram = GL_FALSE;
GLboolean _GLEE_INTEL_texture_scissor = GL_FALSE;
GLboolean _GLEE_INTEL_parallel_arrays = GL_FALSE;
GLboolean _GLEE_HP_occlusion_test = GL_FALSE;
GLboolean _GLEE_EXT_pixel_transform = GL_FALSE;
GLboolean _GLEE_EXT_pixel_transform_color_table = GL_FALSE;
GLboolean _GLEE_EXT_shared_texture_palette = GL_FALSE;
GLboolean _GLEE_EXT_separate_specular_color = GL_FALSE;
GLboolean _GLEE_EXT_secondary_color = GL_FALSE;
GLboolean _GLEE_EXT_texture_perturb_normal = GL_FALSE;
GLboolean _GLEE_EXT_multi_draw_arrays = GL_FALSE;
GLboolean _GLEE_EXT_fog_coord = GL_FALSE;
GLboolean _GLEE_REND_screen_coordinates = GL_FALSE;
GLboolean _GLEE_EXT_coordinate_frame = GL_FALSE;
GLboolean _GLEE_EXT_texture_env_combine = GL_FALSE;
GLboolean _GLEE_APPLE_specular_vector = GL_FALSE;
GLboolean _GLEE_APPLE_transform_hint = GL_FALSE;
GLboolean _GLEE_SGIX_fog_scale = GL_FALSE;
GLboolean _GLEE_SUNX_constant_data = GL_FALSE;
GLboolean _GLEE_SUN_global_alpha = GL_FALSE;
GLboolean _GLEE_SUN_triangle_list = GL_FALSE;
GLboolean _GLEE_SUN_vertex = GL_FALSE;
GLboolean _GLEE_EXT_blend_func_separate = GL_FALSE;
GLboolean _GLEE_INGR_color_clamp = GL_FALSE;
GLboolean _GLEE_INGR_interlace_read = GL_FALSE;
GLboolean _GLEE_EXT_stencil_wrap = GL_FALSE;
GLboolean _GLEE_EXT_422_pixels = GL_FALSE;
GLboolean _GLEE_NV_texgen_reflection = GL_FALSE;
GLboolean _GLEE_EXT_texture_cube_map = GL_FALSE;
GLboolean _GLEE_SUN_convolution_border_modes = GL_FALSE;
GLboolean _GLEE_EXT_texture_env_add = GL_FALSE;
GLboolean _GLEE_EXT_texture_lod_bias = GL_FALSE;
GLboolean _GLEE_EXT_texture_filter_anisotropic = GL_FALSE;
GLboolean _GLEE_EXT_vertex_weighting = GL_FALSE;
GLboolean _GLEE_NV_light_max_exponent = GL_FALSE;
GLboolean _GLEE_NV_vertex_array_range = GL_FALSE;
GLboolean _GLEE_NV_register_combiners = GL_FALSE;
GLboolean _GLEE_NV_fog_distance = GL_FALSE;
GLboolean _GLEE_NV_texgen_emboss = GL_FALSE;
GLboolean _GLEE_NV_blend_square = GL_FALSE;
GLboolean _GLEE_NV_texture_env_combine4 = GL_FALSE;
GLboolean _GLEE_MESA_resize_buffers = GL_FALSE;
GLboolean _GLEE_MESA_window_pos = GL_FALSE;
GLboolean _GLEE_EXT_texture_compression_s3tc = GL_FALSE;
GLboolean _GLEE_IBM_cull_vertex = GL_FALSE;
GLboolean _GLEE_IBM_multimode_draw_arrays = GL_FALSE;
GLboolean _GLEE_IBM_vertex_array_lists = GL_FALSE;
GLboolean _GLEE_SGIX_subsample = GL_FALSE;
GLboolean _GLEE_SGIX_ycrcb_subsample = GL_FALSE;
GLboolean _GLEE_SGIX_ycrcba = GL_FALSE;
GLboolean _GLEE_SGI_depth_pass_instrument = GL_FALSE;
GLboolean _GLEE_3DFX_texture_compression_FXT1 = GL_FALSE;
GLboolean _GLEE_3DFX_multisample = GL_FALSE;
GLboolean _GLEE_3DFX_tbuffer = GL_FALSE;
GLboolean _GLEE_EXT_multisample = GL_FALSE;
GLboolean _GLEE_SGIX_vertex_preclip = GL_FALSE;
GLboolean _GLEE_SGIX_convolution_accuracy = GL_FALSE;
GLboolean _GLEE_SGIX_resample = GL_FALSE;
GLboolean _GLEE_SGIS_point_line_texgen = GL_FALSE;
GLboolean _GLEE_SGIS_texture_color_mask = GL_FALSE;
GLboolean _GLEE_EXT_texture_env_dot3 = GL_FALSE;
GLboolean _GLEE_ATI_texture_mirror_once = GL_FALSE;
GLboolean _GLEE_NV_fence = GL_FALSE;
GLboolean _GLEE_IBM_texture_mirrored_repeat = GL_FALSE;
GLboolean _GLEE_NV_evaluators = GL_FALSE;
GLboolean _GLEE_NV_packed_depth_stencil = GL_FALSE;
GLboolean _GLEE_NV_register_combiners2 = GL_FALSE;
GLboolean _GLEE_NV_texture_compression_vtc = GL_FALSE;
GLboolean _GLEE_NV_texture_rectangle = GL_FALSE;
GLboolean _GLEE_NV_texture_shader = GL_FALSE;
GLboolean _GLEE_NV_texture_shader2 = GL_FALSE;
GLboolean _GLEE_NV_vertex_array_range2 = GL_FALSE;
GLboolean _GLEE_NV_vertex_program = GL_FALSE;
GLboolean _GLEE_SGIX_texture_coordinate_clamp = GL_FALSE;
GLboolean _GLEE_SGIX_scalebias_hint = GL_FALSE;
GLboolean _GLEE_OML_interlace = GL_FALSE;
GLboolean _GLEE_OML_subsample = GL_FALSE;
GLboolean _GLEE_OML_resample = GL_FALSE;
GLboolean _GLEE_NV_copy_depth_to_color = GL_FALSE;
GLboolean _GLEE_ATI_envmap_bumpmap = GL_FALSE;
GLboolean _GLEE_ATI_fragment_shader = GL_FALSE;
GLboolean _GLEE_ATI_pn_triangles = GL_FALSE;
GLboolean _GLEE_ATI_vertex_array_object = GL_FALSE;
GLboolean _GLEE_EXT_vertex_shader = GL_FALSE;
GLboolean _GLEE_ATI_vertex_streams = GL_FALSE;
GLboolean _GLEE_ATI_element_array = GL_FALSE;
GLboolean _GLEE_SUN_mesh_array = GL_FALSE;
GLboolean _GLEE_SUN_slice_accum = GL_FALSE;
GLboolean _GLEE_NV_multisample_filter_hint = GL_FALSE;
GLboolean _GLEE_NV_depth_clamp = GL_FALSE;
GLboolean _GLEE_NV_occlusion_query = GL_FALSE;
GLboolean _GLEE_NV_point_sprite = GL_FALSE;
GLboolean _GLEE_NV_texture_shader3 = GL_FALSE;
GLboolean _GLEE_NV_vertex_program1_1 = GL_FALSE;
GLboolean _GLEE_EXT_shadow_funcs = GL_FALSE;
GLboolean _GLEE_EXT_stencil_two_side = GL_FALSE;
GLboolean _GLEE_ATI_text_fragment_shader = GL_FALSE;
GLboolean _GLEE_APPLE_client_storage = GL_FALSE;
GLboolean _GLEE_APPLE_element_array = GL_FALSE;
GLboolean _GLEE_APPLE_fence = GL_FALSE;
GLboolean _GLEE_APPLE_vertex_array_object = GL_FALSE;
GLboolean _GLEE_APPLE_vertex_array_range = GL_FALSE;
GLboolean _GLEE_APPLE_ycbcr_422 = GL_FALSE;
GLboolean _GLEE_S3_s3tc = GL_FALSE;
GLboolean _GLEE_ATI_draw_buffers = GL_FALSE;
GLboolean _GLEE_ATI_pixel_format_float = GL_FALSE;
GLboolean _GLEE_ATI_texture_env_combine3 = GL_FALSE;
GLboolean _GLEE_ATI_texture_float = GL_FALSE;
GLboolean _GLEE_NV_float_buffer = GL_FALSE;
GLboolean _GLEE_NV_fragment_program = GL_FALSE;
GLboolean _GLEE_NV_half_float = GL_FALSE;
GLboolean _GLEE_NV_pixel_data_range = GL_FALSE;
GLboolean _GLEE_NV_primitive_restart = GL_FALSE;
GLboolean _GLEE_NV_texture_expand_normal = GL_FALSE;
GLboolean _GLEE_NV_vertex_program2 = GL_FALSE;
GLboolean _GLEE_ATI_map_object_buffer = GL_FALSE;
GLboolean _GLEE_ATI_separate_stencil = GL_FALSE;
GLboolean _GLEE_ATI_vertex_attrib_array_object = GL_FALSE;
GLboolean _GLEE_OES_read_format = GL_FALSE;
GLboolean _GLEE_EXT_depth_bounds_test = GL_FALSE;
GLboolean _GLEE_EXT_texture_mirror_clamp = GL_FALSE;
GLboolean _GLEE_EXT_blend_equation_separate = GL_FALSE;
GLboolean _GLEE_MESA_pack_invert = GL_FALSE;
GLboolean _GLEE_MESA_ycbcr_texture = GL_FALSE;
GLboolean _GLEE_EXT_pixel_buffer_object = GL_FALSE;
GLboolean _GLEE_NV_fragment_program_option = GL_FALSE;
GLboolean _GLEE_NV_fragment_program2 = GL_FALSE;
GLboolean _GLEE_NV_vertex_program2_option = GL_FALSE;
GLboolean _GLEE_NV_vertex_program3 = GL_FALSE;
GLboolean _GLEE_EXT_framebuffer_object = GL_FALSE;
GLboolean _GLEE_GREMEDY_string_marker = GL_FALSE;
GLboolean _GLEE_EXT_packed_depth_stencil = GL_FALSE;
GLboolean _GLEE_EXT_stencil_clear_tag = GL_FALSE;
GLboolean _GLEE_EXT_texture_sRGB = GL_FALSE;
GLboolean _GLEE_EXT_framebuffer_blit = GL_FALSE;
GLboolean _GLEE_EXT_framebuffer_multisample = GL_FALSE;
GLboolean _GLEE_MESAX_texture_stack = GL_FALSE;
GLboolean _GLEE_EXT_timer_query = GL_FALSE;
GLboolean _GLEE_EXT_gpu_program_parameters = GL_FALSE;
GLboolean _GLEE_APPLE_flush_buffer_range = GL_FALSE;
GLboolean _GLEE_EXT_gpu_shader4 = GL_FALSE;
GLboolean _GLEE_EXT_draw_instanced = GL_FALSE;
GLboolean _GLEE_EXT_packed_float = GL_FALSE;
GLboolean _GLEE_EXT_texture_array = GL_FALSE;
GLboolean _GLEE_EXT_texture_buffer_object = GL_FALSE;
GLboolean _GLEE_EXT_texture_compression_latc = GL_FALSE;
GLboolean _GLEE_EXT_texture_compression_rgtc = GL_FALSE;
GLboolean _GLEE_EXT_texture_shared_exponent = GL_FALSE;
GLboolean _GLEE_NV_depth_buffer_float = GL_FALSE;
GLboolean _GLEE_NV_framebuffer_multisample_coverage = GL_FALSE;
GLboolean _GLEE_EXT_framebuffer_sRGB = GL_FALSE;
GLboolean _GLEE_NV_geometry_shader4 = GL_FALSE;
GLboolean _GLEE_NV_parameter_buffer_object = GL_FALSE;
GLboolean _GLEE_EXT_draw_buffers2 = GL_FALSE;
GLboolean _GLEE_NV_transform_feedback = GL_FALSE;
GLboolean _GLEE_EXT_bindable_uniform = GL_FALSE;
GLboolean _GLEE_EXT_texture_integer = GL_FALSE;
GLboolean _GLEE_GREMEDY_frame_terminator = GL_FALSE;
GLboolean _GLEE_NV_conditional_render = GL_FALSE;
GLboolean _GLEE_NV_present_video = GL_FALSE;
GLboolean _GLEE_EXT_transform_feedback = GL_FALSE;
GLboolean _GLEE_EXT_direct_state_access = GL_FALSE;
GLboolean _GLEE_EXT_vertex_array_bgra = GL_FALSE;
GLboolean _GLEE_EXT_texture_swizzle = GL_FALSE;
GLboolean _GLEE_NV_explicit_multisample = GL_FALSE;
GLboolean _GLEE_NV_transform_feedback2 = GL_FALSE;
GLboolean _GLEE_SGIX_texture_select = GL_FALSE;
GLboolean _GLEE_INGR_blend_func_separate = GL_FALSE;
GLboolean _GLEE_SGIX_depth_pass_instrument = GL_FALSE;
GLboolean _GLEE_SGIX_igloo_interface = GL_FALSE;
GLboolean _GLEE_EXT_fragment_lighting = GL_FALSE;
GLboolean _GLEE_EXT_geometry_shader4 = GL_FALSE;
GLboolean _GLEE_EXT_scene_marker = GL_FALSE;
GLboolean _GLEE_EXT_texture_compression_dxt1 = GL_FALSE;
GLboolean _GLEE_EXT_texture_env = GL_FALSE;
GLboolean _GLEE_IBM_static_data = GL_FALSE;
GLboolean _GLEE_NV_gpu_program4 = GL_FALSE;
GLboolean _GLEE_OES_byte_coordinates = GL_FALSE;
GLboolean _GLEE_OES_compressed_paletted_texture = GL_FALSE;
GLboolean _GLEE_OES_single_precision = GL_FALSE;
GLboolean _GLEE_SGIX_pixel_texture_bits = GL_FALSE;
GLboolean _GLEE_SGIX_texture_range = GL_FALSE;

/*  GL Extension names */

char __GLeeGLExtensionNames[322][39]={
    "GL_VERSION_1_2",
    "GL_ARB_imaging",
    "GL_VERSION_1_3",
    "GL_VERSION_1_4",
    "GL_VERSION_1_5",
    "GL_VERSION_2_0",
    "GL_VERSION_2_1",
    "GL_VERSION_3_0",
    "GL_ARB_multitexture",
    "GL_ARB_transpose_matrix",
    "GL_ARB_multisample",
    "GL_ARB_texture_env_add",
    "GL_ARB_texture_cube_map",
    "GL_ARB_texture_compression",
    "GL_ARB_texture_border_clamp",
    "GL_ARB_point_parameters",
    "GL_ARB_vertex_blend",
    "GL_ARB_matrix_palette",
    "GL_ARB_texture_env_combine",
    "GL_ARB_texture_env_crossbar",
    "GL_ARB_texture_env_dot3",
    "GL_ARB_texture_mirrored_repeat",
    "GL_ARB_depth_texture",
    "GL_ARB_shadow",
    "GL_ARB_shadow_ambient",
    "GL_ARB_window_pos",
    "GL_ARB_vertex_program",
    "GL_ARB_fragment_program",
    "GL_ARB_vertex_buffer_object",
    "GL_ARB_occlusion_query",
    "GL_ARB_shader_objects",
    "GL_ARB_vertex_shader",
    "GL_ARB_fragment_shader",
    "GL_ARB_shading_language_100",
    "GL_ARB_texture_non_power_of_two",
    "GL_ARB_point_sprite",
    "GL_ARB_fragment_program_shadow",
    "GL_ARB_draw_buffers",
    "GL_ARB_texture_rectangle",
    "GL_ARB_color_buffer_float",
    "GL_ARB_half_float_pixel",
    "GL_ARB_texture_float",
    "GL_ARB_pixel_buffer_object",
    "GL_ARB_depth_buffer_float",
    "GL_ARB_draw_instanced",
    "GL_ARB_framebuffer_object",
    "GL_ARB_framebuffer_sRGB",
    "GL_ARB_geometry_shader4",
    "GL_ARB_half_float_vertex",
    "GL_ARB_instanced_arrays",
    "GL_ARB_map_buffer_range",
    "GL_ARB_texture_buffer_object",
    "GL_ARB_texture_compression_rgtc",
    "GL_ARB_texture_rg",
    "GL_ARB_vertex_array_object",
    "GL_EXT_abgr",
    "GL_EXT_blend_color",
    "GL_EXT_polygon_offset",
    "GL_EXT_texture",
    "GL_EXT_texture3D",
    "GL_SGIS_texture_filter4",
    "GL_EXT_subtexture",
    "GL_EXT_copy_texture",
    "GL_EXT_histogram",
    "GL_EXT_convolution",
    "GL_SGI_color_matrix",
    "GL_SGI_color_table",
    "GL_SGIS_pixel_texture",
    "GL_SGIX_pixel_texture",
    "GL_SGIS_texture4D",
    "GL_SGI_texture_color_table",
    "GL_EXT_cmyka",
    "GL_EXT_texture_object",
    "GL_SGIS_detail_texture",
    "GL_SGIS_sharpen_texture",
    "GL_EXT_packed_pixels",
    "GL_SGIS_texture_lod",
    "GL_SGIS_multisample",
    "GL_EXT_rescale_normal",
    "GL_EXT_vertex_array",
    "GL_EXT_misc_attribute",
    "GL_SGIS_generate_mipmap",
    "GL_SGIX_clipmap",
    "GL_SGIX_shadow",
    "GL_SGIS_texture_edge_clamp",
    "GL_SGIS_texture_border_clamp",
    "GL_EXT_blend_minmax",
    "GL_EXT_blend_subtract",
    "GL_EXT_blend_logic_op",
    "GL_SGIX_interlace",
    "GL_SGIX_pixel_tiles",
    "GL_SGIS_texture_select",
    "GL_SGIX_sprite",
    "GL_SGIX_texture_multi_buffer",
    "GL_EXT_point_parameters",
    "GL_SGIS_point_parameters",
    "GL_SGIX_instruments",
    "GL_SGIX_texture_scale_bias",
    "GL_SGIX_framezoom",
    "GL_SGIX_tag_sample_buffer",
    "GL_FfdMaskSGIX",
    "GL_SGIX_polynomial_ffd",
    "GL_SGIX_reference_plane",
    "GL_SGIX_flush_raster",
    "GL_SGIX_depth_texture",
    "GL_SGIS_fog_function",
    "GL_SGIX_fog_offset",
    "GL_HP_image_transform",
    "GL_HP_convolution_border_modes",
    "GL_INGR_palette_buffer",
    "GL_SGIX_texture_add_env",
    "GL_EXT_color_subtable",
    "GL_PGI_vertex_hints",
    "GL_PGI_misc_hints",
    "GL_EXT_paletted_texture",
    "GL_EXT_clip_volume_hint",
    "GL_SGIX_list_priority",
    "GL_SGIX_ir_instrument1",
    "GL_SGIX_calligraphic_fragment",
    "GL_SGIX_texture_lod_bias",
    "GL_SGIX_shadow_ambient",
    "GL_EXT_index_texture",
    "GL_EXT_index_material",
    "GL_EXT_index_func",
    "GL_EXT_index_array_formats",
    "GL_EXT_compiled_vertex_array",
    "GL_EXT_cull_vertex",
    "GL_SGIX_ycrcb",
    "GL_SGIX_fragment_lighting",
    "GL_IBM_rasterpos_clip",
    "GL_HP_texture_lighting",
    "GL_EXT_draw_range_elements",
    "GL_WIN_phong_shading",
    "GL_WIN_specular_fog",
    "GL_EXT_light_texture",
    "GL_SGIX_blend_alpha_minmax",
    "GL_SGIX_impact_pixel_texture",
    "GL_EXT_bgra",
    "GL_SGIX_async",
    "GL_SGIX_async_pixel",
    "GL_SGIX_async_histogram",
    "GL_INTEL_texture_scissor",
    "GL_INTEL_parallel_arrays",
    "GL_HP_occlusion_test",
    "GL_EXT_pixel_transform",
    "GL_EXT_pixel_transform_color_table",
    "GL_EXT_shared_texture_palette",
    "GL_EXT_separate_specular_color",
    "GL_EXT_secondary_color",
    "GL_EXT_texture_perturb_normal",
    "GL_EXT_multi_draw_arrays",
    "GL_EXT_fog_coord",
    "GL_REND_screen_coordinates",
    "GL_EXT_coordinate_frame",
    "GL_EXT_texture_env_combine",
    "GL_APPLE_specular_vector",
    "GL_APPLE_transform_hint",
    "GL_SGIX_fog_scale",
    "GL_SUNX_constant_data",
    "GL_SUN_global_alpha",
    "GL_SUN_triangle_list",
    "GL_SUN_vertex",
    "GL_EXT_blend_func_separate",
    "GL_INGR_color_clamp",
    "GL_INGR_interlace_read",
    "GL_EXT_stencil_wrap",
    "GL_EXT_422_pixels",
    "GL_NV_texgen_reflection",
    "GL_EXT_texture_cube_map",
    "GL_SUN_convolution_border_modes",
    "GL_EXT_texture_env_add",
    "GL_EXT_texture_lod_bias",
    "GL_EXT_texture_filter_anisotropic",
    "GL_EXT_vertex_weighting",
    "GL_NV_light_max_exponent",
    "GL_NV_vertex_array_range",
    "GL_NV_register_combiners",
    "GL_NV_fog_distance",
    "GL_NV_texgen_emboss",
    "GL_NV_blend_square",
    "GL_NV_texture_env_combine4",
    "GL_MESA_resize_buffers",
    "GL_MESA_window_pos",
    "GL_EXT_texture_compression_s3tc",
    "GL_IBM_cull_vertex",
    "GL_IBM_multimode_draw_arrays",
    "GL_IBM_vertex_array_lists",
    "GL_SGIX_subsample",
    "GL_SGIX_ycrcb_subsample",
    "GL_SGIX_ycrcba",
    "GL_SGI_depth_pass_instrument",
    "GL_3DFX_texture_compression_FXT1",
    "GL_3DFX_multisample",
    "GL_3DFX_tbuffer",
    "GL_EXT_multisample",
    "GL_SGIX_vertex_preclip",
    "GL_SGIX_convolution_accuracy",
    "GL_SGIX_resample",
    "GL_SGIS_point_line_texgen",
    "GL_SGIS_texture_color_mask",
    "GL_EXT_texture_env_dot3",
    "GL_ATI_texture_mirror_once",
    "GL_NV_fence",
    "GL_IBM_texture_mirrored_repeat",
    "GL_NV_evaluators",
    "GL_NV_packed_depth_stencil",
    "GL_NV_register_combiners2",
    "GL_NV_texture_compression_vtc",
    "GL_NV_texture_rectangle",
    "GL_NV_texture_shader",
    "GL_NV_texture_shader2",
    "GL_NV_vertex_array_range2",
    "GL_NV_vertex_program",
    "GL_SGIX_texture_coordinate_clamp",
    "GL_SGIX_scalebias_hint",
    "GL_OML_interlace",
    "GL_OML_subsample",
    "GL_OML_resample",
    "GL_NV_copy_depth_to_color",
    "GL_ATI_envmap_bumpmap",
    "GL_ATI_fragment_shader",
    "GL_ATI_pn_triangles",
    "GL_ATI_vertex_array_object",
    "GL_EXT_vertex_shader",
    "GL_ATI_vertex_streams",
    "GL_ATI_element_array",
    "GL_SUN_mesh_array",
    "GL_SUN_slice_accum",
    "GL_NV_multisample_filter_hint",
    "GL_NV_depth_clamp",
    "GL_NV_occlusion_query",
    "GL_NV_point_sprite",
    "GL_NV_texture_shader3",
    "GL_NV_vertex_program1_1",
    "GL_EXT_shadow_funcs",
    "GL_EXT_stencil_two_side",
    "GL_ATI_text_fragment_shader",
    "GL_APPLE_client_storage",
    "GL_APPLE_element_array",
    "GL_APPLE_fence",
    "GL_APPLE_vertex_array_object",
    "GL_APPLE_vertex_array_range",
    "GL_APPLE_ycbcr_422",
    "GL_S3_s3tc",
    "GL_ATI_draw_buffers",
    "GL_ATI_pixel_format_float",
    "GL_ATI_texture_env_combine3",
    "GL_ATI_texture_float",
    "GL_NV_float_buffer",
    "GL_NV_fragment_program",
    "GL_NV_half_float",
    "GL_NV_pixel_data_range",
    "GL_NV_primitive_restart",
    "GL_NV_texture_expand_normal",
    "GL_NV_vertex_program2",
    "GL_ATI_map_object_buffer",
    "GL_ATI_separate_stencil",
    "GL_ATI_vertex_attrib_array_object",
    "GL_OES_read_format",
    "GL_EXT_depth_bounds_test",
    "GL_EXT_texture_mirror_clamp",
    "GL_EXT_blend_equation_separate",
    "GL_MESA_pack_invert",
    "GL_MESA_ycbcr_texture",
    "GL_EXT_pixel_buffer_object",
    "GL_NV_fragment_program_option",
    "GL_NV_fragment_program2",
    "GL_NV_vertex_program2_option",
    "GL_NV_vertex_program3",
    "GL_EXT_framebuffer_object",
    "GL_GREMEDY_string_marker",
    "GL_EXT_packed_depth_stencil",
    "GL_EXT_stencil_clear_tag",
    "GL_EXT_texture_sRGB",
    "GL_EXT_framebuffer_blit",
    "GL_EXT_framebuffer_multisample",
    "GL_MESAX_texture_stack",
    "GL_EXT_timer_query",
    "GL_EXT_gpu_program_parameters",
    "GL_APPLE_flush_buffer_range",
    "GL_EXT_gpu_shader4",
    "GL_EXT_draw_instanced",
    "GL_EXT_packed_float",
    "GL_EXT_texture_array",
    "GL_EXT_texture_buffer_object",
    "GL_EXT_texture_compression_latc",
    "GL_EXT_texture_compression_rgtc",
    "GL_EXT_texture_shared_exponent",
    "GL_NV_depth_buffer_float",
    "GL_NV_framebuffer_multisample_coverage",
    "GL_EXT_framebuffer_sRGB",
    "GL_NV_geometry_shader4",
    "GL_NV_parameter_buffer_object",
    "GL_EXT_draw_buffers2",
    "GL_NV_transform_feedback",
    "GL_EXT_bindable_uniform",
    "GL_EXT_texture_integer",
    "GL_GREMEDY_frame_terminator",
    "GL_NV_conditional_render",
    "GL_NV_present_video",
    "GL_EXT_transform_feedback",
    "GL_EXT_direct_state_access",
    "GL_EXT_vertex_array_bgra",
    "GL_EXT_texture_swizzle",
    "GL_NV_explicit_multisample",
    "GL_NV_transform_feedback2",
    "GL_SGIX_texture_select",
    "GL_INGR_blend_func_separate",
    "GL_SGIX_depth_pass_instrument",
    "GL_SGIX_igloo_interface",
    "GL_EXT_fragment_lighting",
    "GL_EXT_geometry_shader4",
    "GL_EXT_scene_marker",
    "GL_EXT_texture_compression_dxt1",
    "GL_EXT_texture_env",
    "GL_IBM_static_data",
    "GL_NV_gpu_program4",
    "GL_OES_byte_coordinates",
    "GL_OES_compressed_paletted_texture",
    "GL_OES_single_precision",
    "GL_SGIX_pixel_texture_bits",
    "GL_SGIX_texture_range"
};
int __GLeeGLNumExtensions=322;

/* GL_VERSION_1_2 */

#ifdef __GLEE_GL_VERSION_1_2
#ifndef GLEE_C_DEFINED_glBlendColor
#define GLEE_C_DEFINED_glBlendColor
  void __stdcall GLee_Lazy_glBlendColor(GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha)  {if (GLeeInit()) glBlendColor(red, green, blue, alpha);}
  GLEEPFNGLBLENDCOLORPROC GLeeFuncPtr_glBlendColor=GLee_Lazy_glBlendColor;
#endif
#ifndef GLEE_C_DEFINED_glBlendEquation
#define GLEE_C_DEFINED_glBlendEquation
  void __stdcall GLee_Lazy_glBlendEquation(GLenum mode)  {if (GLeeInit()) glBlendEquation(mode);}
  GLEEPFNGLBLENDEQUATIONPROC GLeeFuncPtr_glBlendEquation=GLee_Lazy_glBlendEquation;
#endif
#ifndef GLEE_C_DEFINED_glDrawRangeElements
#define GLEE_C_DEFINED_glDrawRangeElements
  void __stdcall GLee_Lazy_glDrawRangeElements(GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const GLvoid * indices)  {if (GLeeInit()) glDrawRangeElements(mode, start, end, count, type, indices);}
  GLEEPFNGLDRAWRANGEELEMENTSPROC GLeeFuncPtr_glDrawRangeElements=GLee_Lazy_glDrawRangeElements;
#endif
#ifndef GLEE_C_DEFINED_glColorTable
#define GLEE_C_DEFINED_glColorTable
  void __stdcall GLee_Lazy_glColorTable(GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const GLvoid * table)  {if (GLeeInit()) glColorTable(target, internalformat, width, format, type, table);}
  GLEEPFNGLCOLORTABLEPROC GLeeFuncPtr_glColorTable=GLee_Lazy_glColorTable;
#endif
#ifndef GLEE_C_DEFINED_glColorTableParameterfv
#define GLEE_C_DEFINED_glColorTableParameterfv
  void __stdcall GLee_Lazy_glColorTableParameterfv(GLenum target, GLenum pname, const GLfloat * params)  {if (GLeeInit()) glColorTableParameterfv(target, pname, params);}
  GLEEPFNGLCOLORTABLEPARAMETERFVPROC GLeeFuncPtr_glColorTableParameterfv=GLee_Lazy_glColorTableParameterfv;
#endif
#ifndef GLEE_C_DEFINED_glColorTableParameteriv
#define GLEE_C_DEFINED_glColorTableParameteriv
  void __stdcall GLee_Lazy_glColorTableParameteriv(GLenum target, GLenum pname, const GLint * params)  {if (GLeeInit()) glColorTableParameteriv(target, pname, params);}
  GLEEPFNGLCOLORTABLEPARAMETERIVPROC GLeeFuncPtr_glColorTableParameteriv=GLee_Lazy_glColorTableParameteriv;
#endif
#ifndef GLEE_C_DEFINED_glCopyColorTable
#define GLEE_C_DEFINED_glCopyColorTable
  void __stdcall GLee_Lazy_glCopyColorTable(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width)  {if (GLeeInit()) glCopyColorTable(target, internalformat, x, y, width);}
  GLEEPFNGLCOPYCOLORTABLEPROC GLeeFuncPtr_glCopyColorTable=GLee_Lazy_glCopyColorTable;
#endif
#ifndef GLEE_C_DEFINED_glGetColorTable
#define GLEE_C_DEFINED_glGetColorTable
  void __stdcall GLee_Lazy_glGetColorTable(GLenum target, GLenum format, GLenum type, GLvoid * table)  {if (GLeeInit()) glGetColorTable(target, format, type, table);}
  GLEEPFNGLGETCOLORTABLEPROC GLeeFuncPtr_glGetColorTable=GLee_Lazy_glGetColorTable;
#endif
#ifndef GLEE_C_DEFINED_glGetColorTableParameterfv
#define GLEE_C_DEFINED_glGetColorTableParameterfv
  void __stdcall GLee_Lazy_glGetColorTableParameterfv(GLenum target, GLenum pname, GLfloat * params)  {if (GLeeInit()) glGetColorTableParameterfv(target, pname, params);}
  GLEEPFNGLGETCOLORTABLEPARAMETERFVPROC GLeeFuncPtr_glGetColorTableParameterfv=GLee_Lazy_glGetColorTableParameterfv;
#endif
#ifndef GLEE_C_DEFINED_glGetColorTableParameteriv
#define GLEE_C_DEFINED_glGetColorTableParameteriv
  void __stdcall GLee_Lazy_glGetColorTableParameteriv(GLenum target, GLenum pname, GLint * params)  {if (GLeeInit()) glGetColorTableParameteriv(target, pname, params);}
  GLEEPFNGLGETCOLORTABLEPARAMETERIVPROC GLeeFuncPtr_glGetColorTableParameteriv=GLee_Lazy_glGetColorTableParameteriv;
#endif
#ifndef GLEE_C_DEFINED_glColorSubTable
#define GLEE_C_DEFINED_glColorSubTable
  void __stdcall GLee_Lazy_glColorSubTable(GLenum target, GLsizei start, GLsizei count, GLenum format, GLenum type, const GLvoid * data)  {if (GLeeInit()) glColorSubTable(target, start, count, format, type, data);}
  GLEEPFNGLCOLORSUBTABLEPROC GLeeFuncPtr_glColorSubTable=GLee_Lazy_glColorSubTable;
#endif
#ifndef GLEE_C_DEFINED_glCopyColorSubTable
#define GLEE_C_DEFINED_glCopyColorSubTable
  void __stdcall GLee_Lazy_glCopyColorSubTable(GLenum target, GLsizei start, GLint x, GLint y, GLsizei width)  {if (GLeeInit()) glCopyColorSubTable(target, start, x, y, width);}
  GLEEPFNGLCOPYCOLORSUBTABLEPROC GLeeFuncPtr_glCopyColorSubTable=GLee_Lazy_glCopyColorSubTable;
#endif
#ifndef GLEE_C_DEFINED_glConvolutionFilter1D
#define GLEE_C_DEFINED_glConvolutionFilter1D
  void __stdcall GLee_Lazy_glConvolutionFilter1D(GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const GLvoid * image)  {if (GLeeInit()) glConvolutionFilter1D(target, internalformat, width, format, type, image);}
  GLEEPFNGLCONVOLUTIONFILTER1DPROC GLeeFuncPtr_glConvolutionFilter1D=GLee_Lazy_glConvolutionFilter1D;
#endif
#ifndef GLEE_C_DEFINED_glConvolutionFilter2D
#define GLEE_C_DEFINED_glConvolutionFilter2D
  void __stdcall GLee_Lazy_glConvolutionFilter2D(GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid * image)  {if (GLeeInit()) glConvolutionFilter2D(target, internalformat, width, height, format, type, image);}
  GLEEPFNGLCONVOLUTIONFILTER2DPROC GLeeFuncPtr_glConvolutionFilter2D=GLee_Lazy_glConvolutionFilter2D;
#endif
#ifndef GLEE_C_DEFINED_glConvolutionParameterf
#define GLEE_C_DEFINED_glConvolutionParameterf
  void __stdcall GLee_Lazy_glConvolutionParameterf(GLenum target, GLenum pname, GLfloat params)  {if (GLeeInit()) glConvolutionParameterf(target, pname, params);}
  GLEEPFNGLCONVOLUTIONPARAMETERFPROC GLeeFuncPtr_glConvolutionParameterf=GLee_Lazy_glConvolutionParameterf;
#endif
#ifndef GLEE_C_DEFINED_glConvolutionParameterfv
#define GLEE_C_DEFINED_glConvolutionParameterfv
  void __stdcall GLee_Lazy_glConvolutionParameterfv(GLenum target, GLenum pname, const GLfloat * params)  {if (GLeeInit()) glConvolutionParameterfv(target, pname, params);}
  GLEEPFNGLCONVOLUTIONPARAMETERFVPROC GLeeFuncPtr_glConvolutionParameterfv=GLee_Lazy_glConvolutionParameterfv;
#endif
#ifndef GLEE_C_DEFINED_glConvolutionParameteri
#define GLEE_C_DEFINED_glConvolutionParameteri
  void __stdcall GLee_Lazy_glConvolutionParameteri(GLenum target, GLenum pname, GLint params)  {if (GLeeInit()) glConvolutionParameteri(target, pname, params);}
  GLEEPFNGLCONVOLUTIONPARAMETERIPROC GLeeFuncPtr_glConvolutionParameteri=GLee_Lazy_glConvolutionParameteri;
#endif
#ifndef GLEE_C_DEFINED_glConvolutionParameteriv
#define GLEE_C_DEFINED_glConvolutionParameteriv
  void __stdcall GLee_Lazy_glConvolutionParameteriv(GLenum target, GLenum pname, const GLint * params)  {if (GLeeInit()) glConvolutionParameteriv(target, pname, params);}
  GLEEPFNGLCONVOLUTIONPARAMETERIVPROC GLeeFuncPtr_glConvolutionParameteriv=GLee_Lazy_glConvolutionParameteriv;
#endif
#ifndef GLEE_C_DEFINED_glCopyConvolutionFilter1D
#define GLEE_C_DEFINED_glCopyConvolutionFilter1D
  void __stdcall GLee_Lazy_glCopyConvolutionFilter1D(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width)  {if (GLeeInit()) glCopyConvolutionFilter1D(target, internalformat, x, y, width);}
  GLEEPFNGLCOPYCONVOLUTIONFILTER1DPROC GLeeFuncPtr_glCopyConvolutionFilter1D=GLee_Lazy_glCopyConvolutionFilter1D;
#endif
#ifndef GLEE_C_DEFINED_glCopyConvolutionFilter2D
#define GLEE_C_DEFINED_glCopyConvolutionFilter2D
  void __stdcall GLee_Lazy_glCopyConvolutionFilter2D(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height)  {if (GLeeInit()) glCopyConvolutionFilter2D(target, internalformat, x, y, width, height);}
  GLEEPFNGLCOPYCONVOLUTIONFILTER2DPROC GLeeFuncPtr_glCopyConvolutionFilter2D=GLee_Lazy_glCopyConvolutionFilter2D;
#endif
#ifndef GLEE_C_DEFINED_glGetConvolutionFilter
#define GLEE_C_DEFINED_glGetConvolutionFilter
  void __stdcall GLee_Lazy_glGetConvolutionFilter(GLenum target, GLenum format, GLenum type, GLvoid * image)  {if (GLeeInit()) glGetConvolutionFilter(target, format, type, image);}
  GLEEPFNGLGETCONVOLUTIONFILTERPROC GLeeFuncPtr_glGetConvolutionFilter=GLee_Lazy_glGetConvolutionFilter;
#endif
#ifndef GLEE_C_DEFINED_glGetConvolutionParameterfv
#define GLEE_C_DEFINED_glGetConvolutionParameterfv
  void __stdcall GLee_Lazy_glGetConvolutionParameterfv(GLenum target, GLenum pname, GLfloat * params)  {if (GLeeInit()) glGetConvolutionParameterfv(target, pname, params);}
  GLEEPFNGLGETCONVOLUTIONPARAMETERFVPROC GLeeFuncPtr_glGetConvolutionParameterfv=GLee_Lazy_glGetConvolutionParameterfv;
#endif
#ifndef GLEE_C_DEFINED_glGetConvolutionParameteriv
#define GLEE_C_DEFINED_glGetConvolutionParameteriv
  void __stdcall GLee_Lazy_glGetConvolutionParameteriv(GLenum target, GLenum pname, GLint * params)  {if (GLeeInit()) glGetConvolutionParameteriv(target, pname, params);}
  GLEEPFNGLGETCONVOLUTIONPARAMETERIVPROC GLeeFuncPtr_glGetConvolutionParameteriv=GLee_Lazy_glGetConvolutionParameteriv;
#endif
#ifndef GLEE_C_DEFINED_glGetSeparableFilter
#define GLEE_C_DEFINED_glGetSeparableFilter
  void __stdcall GLee_Lazy_glGetSeparableFilter(GLenum target, GLenum format, GLenum type, GLvoid * row, GLvoid * column, GLvoid * span)  {if (GLeeInit()) glGetSeparableFilter(target, format, type, row, column, span);}
  GLEEPFNGLGETSEPARABLEFILTERPROC GLeeFuncPtr_glGetSeparableFilter=GLee_Lazy_glGetSeparableFilter;
#endif
#ifndef GLEE_C_DEFINED_glSeparableFilter2D
#define GLEE_C_DEFINED_glSeparableFilter2D
  void __stdcall GLee_Lazy_glSeparableFilter2D(GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid * row, const GLvoid * column)  {if (GLeeInit()) glSeparableFilter2D(target, internalformat, width, height, format, type, row, column);}
  GLEEPFNGLSEPARABLEFILTER2DPROC GLeeFuncPtr_glSeparableFilter2D=GLee_Lazy_glSeparableFilter2D;
#endif
#ifndef GLEE_C_DEFINED_glGetHistogram
#define GLEE_C_DEFINED_glGetHistogram
  void __stdcall GLee_Lazy_glGetHistogram(GLenum target, GLboolean reset, GLenum format, GLenum type, GLvoid * values)  {if (GLeeInit()) glGetHistogram(target, reset, format, type, values);}
  GLEEPFNGLGETHISTOGRAMPROC GLeeFuncPtr_glGetHistogram=GLee_Lazy_glGetHistogram;
#endif
#ifndef GLEE_C_DEFINED_glGetHistogramParameterfv
#define GLEE_C_DEFINED_glGetHistogramParameterfv
  void __stdcall GLee_Lazy_glGetHistogramParameterfv(GLenum target, GLenum pname, GLfloat * params)  {if (GLeeInit()) glGetHistogramParameterfv(target, pname, params);}
  GLEEPFNGLGETHISTOGRAMPARAMETERFVPROC GLeeFuncPtr_glGetHistogramParameterfv=GLee_Lazy_glGetHistogramParameterfv;
#endif
#ifndef GLEE_C_DEFINED_glGetHistogramParameteriv
#define GLEE_C_DEFINED_glGetHistogramParameteriv
  void __stdcall GLee_Lazy_glGetHistogramParameteriv(GLenum target, GLenum pname, GLint * params)  {if (GLeeInit()) glGetHistogramParameteriv(target, pname, params);}
  GLEEPFNGLGETHISTOGRAMPARAMETERIVPROC GLeeFuncPtr_glGetHistogramParameteriv=GLee_Lazy_glGetHistogramParameteriv;
#endif
#ifndef GLEE_C_DEFINED_glGetMinmax
#define GLEE_C_DEFINED_glGetMinmax
  void __stdcall GLee_Lazy_glGetMinmax(GLenum target, GLboolean reset, GLenum format, GLenum type, GLvoid * values)  {if (GLeeInit()) glGetMinmax(target, reset, format, type, values);}
  GLEEPFNGLGETMINMAXPROC GLeeFuncPtr_glGetMinmax=GLee_Lazy_glGetMinmax;
#endif
#ifndef GLEE_C_DEFINED_glGetMinmaxParameterfv
#define GLEE_C_DEFINED_glGetMinmaxParameterfv
  void __stdcall GLee_Lazy_glGetMinmaxParameterfv(GLenum target, GLenum pname, GLfloat * params)  {if (GLeeInit()) glGetMinmaxParameterfv(target, pname, params);}
  GLEEPFNGLGETMINMAXPARAMETERFVPROC GLeeFuncPtr_glGetMinmaxParameterfv=GLee_Lazy_glGetMinmaxParameterfv;
#endif
#ifndef GLEE_C_DEFINED_glGetMinmaxParameteriv
#define GLEE_C_DEFINED_glGetMinmaxParameteriv
  void __stdcall GLee_Lazy_glGetMinmaxParameteriv(GLenum target, GLenum pname, GLint * params)  {if (GLeeInit()) glGetMinmaxParameteriv(target, pname, params);}
  GLEEPFNGLGETMINMAXPARAMETERIVPROC GLeeFuncPtr_glGetMinmaxParameteriv=GLee_Lazy_glGetMinmaxParameteriv;
#endif
#ifndef GLEE_C_DEFINED_glHistogram
#define GLEE_C_DEFINED_glHistogram
  void __stdcall GLee_Lazy_glHistogram(GLenum target, GLsizei width, GLenum internalformat, GLboolean sink)  {if (GLeeInit()) glHistogram(target, width, internalformat, sink);}
  GLEEPFNGLHISTOGRAMPROC GLeeFuncPtr_glHistogram=GLee_Lazy_glHistogram;
#endif
#ifndef GLEE_C_DEFINED_glMinmax
#define GLEE_C_DEFINED_glMinmax
  void __stdcall GLee_Lazy_glMinmax(GLenum target, GLenum internalformat, GLboolean sink)  {if (GLeeInit()) glMinmax(target, internalformat, sink);}
  GLEEPFNGLMINMAXPROC GLeeFuncPtr_glMinmax=GLee_Lazy_glMinmax;
#endif
#ifndef GLEE_C_DEFINED_glResetHistogram
#define GLEE_C_DEFINED_glResetHistogram
  void __stdcall GLee_Lazy_glResetHistogram(GLenum target)  {if (GLeeInit()) glResetHistogram(target);}
  GLEEPFNGLRESETHISTOGRAMPROC GLeeFuncPtr_glResetHistogram=GLee_Lazy_glResetHistogram;
#endif
#ifndef GLEE_C_DEFINED_glResetMinmax
#define GLEE_C_DEFINED_glResetMinmax
  void __stdcall GLee_Lazy_glResetMinmax(GLenum target)  {if (GLeeInit()) glResetMinmax(target);}
  GLEEPFNGLRESETMINMAXPROC GLeeFuncPtr_glResetMinmax=GLee_Lazy_glResetMinmax;
#endif
#ifndef GLEE_C_DEFINED_glTexImage3D
#define GLEE_C_DEFINED_glTexImage3D
  void __stdcall GLee_Lazy_glTexImage3D(GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid * pixels)  {if (GLeeInit()) glTexImage3D(target, level, internalformat, width, height, depth, border, format, type, pixels);}
  GLEEPFNGLTEXIMAGE3DPROC GLeeFuncPtr_glTexImage3D=GLee_Lazy_glTexImage3D;
#endif
#ifndef GLEE_C_DEFINED_glTexSubImage3D
#define GLEE_C_DEFINED_glTexSubImage3D
  void __stdcall GLee_Lazy_glTexSubImage3D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid * pixels)  {if (GLeeInit()) glTexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels);}
  GLEEPFNGLTEXSUBIMAGE3DPROC GLeeFuncPtr_glTexSubImage3D=GLee_Lazy_glTexSubImage3D;
#endif
#ifndef GLEE_C_DEFINED_glCopyTexSubImage3D
#define GLEE_C_DEFINED_glCopyTexSubImage3D
  void __stdcall GLee_Lazy_glCopyTexSubImage3D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height)  {if (GLeeInit()) glCopyTexSubImage3D(target, level, xoffset, yoffset, zoffset, x, y, width, height);}
  GLEEPFNGLCOPYTEXSUBIMAGE3DPROC GLeeFuncPtr_glCopyTexSubImage3D=GLee_Lazy_glCopyTexSubImage3D;
#endif
#endif 

/* GL_ARB_imaging */

#ifdef __GLEE_GL_ARB_imaging
#endif 

/* GL_VERSION_1_3 */

#ifdef __GLEE_GL_VERSION_1_3
#ifndef GLEE_C_DEFINED_glActiveTexture
#define GLEE_C_DEFINED_glActiveTexture
  void __stdcall GLee_Lazy_glActiveTexture(GLenum texture)  {if (GLeeInit()) glActiveTexture(texture);}
  GLEEPFNGLACTIVETEXTUREPROC GLeeFuncPtr_glActiveTexture=GLee_Lazy_glActiveTexture;
#endif
#ifndef GLEE_C_DEFINED_glClientActiveTexture
#define GLEE_C_DEFINED_glClientActiveTexture
  void __stdcall GLee_Lazy_glClientActiveTexture(GLenum texture)  {if (GLeeInit()) glClientActiveTexture(texture);}
  GLEEPFNGLCLIENTACTIVETEXTUREPROC GLeeFuncPtr_glClientActiveTexture=GLee_Lazy_glClientActiveTexture;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord1d
#define GLEE_C_DEFINED_glMultiTexCoord1d
  void __stdcall GLee_Lazy_glMultiTexCoord1d(GLenum target, GLdouble s)  {if (GLeeInit()) glMultiTexCoord1d(target, s);}
  GLEEPFNGLMULTITEXCOORD1DPROC GLeeFuncPtr_glMultiTexCoord1d=GLee_Lazy_glMultiTexCoord1d;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord1dv
#define GLEE_C_DEFINED_glMultiTexCoord1dv
  void __stdcall GLee_Lazy_glMultiTexCoord1dv(GLenum target, const GLdouble * v)  {if (GLeeInit()) glMultiTexCoord1dv(target, v);}
  GLEEPFNGLMULTITEXCOORD1DVPROC GLeeFuncPtr_glMultiTexCoord1dv=GLee_Lazy_glMultiTexCoord1dv;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord1f
#define GLEE_C_DEFINED_glMultiTexCoord1f
  void __stdcall GLee_Lazy_glMultiTexCoord1f(GLenum target, GLfloat s)  {if (GLeeInit()) glMultiTexCoord1f(target, s);}
  GLEEPFNGLMULTITEXCOORD1FPROC GLeeFuncPtr_glMultiTexCoord1f=GLee_Lazy_glMultiTexCoord1f;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord1fv
#define GLEE_C_DEFINED_glMultiTexCoord1fv
  void __stdcall GLee_Lazy_glMultiTexCoord1fv(GLenum target, const GLfloat * v)  {if (GLeeInit()) glMultiTexCoord1fv(target, v);}
  GLEEPFNGLMULTITEXCOORD1FVPROC GLeeFuncPtr_glMultiTexCoord1fv=GLee_Lazy_glMultiTexCoord1fv;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord1i
#define GLEE_C_DEFINED_glMultiTexCoord1i
  void __stdcall GLee_Lazy_glMultiTexCoord1i(GLenum target, GLint s)  {if (GLeeInit()) glMultiTexCoord1i(target, s);}
  GLEEPFNGLMULTITEXCOORD1IPROC GLeeFuncPtr_glMultiTexCoord1i=GLee_Lazy_glMultiTexCoord1i;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord1iv
#define GLEE_C_DEFINED_glMultiTexCoord1iv
  void __stdcall GLee_Lazy_glMultiTexCoord1iv(GLenum target, const GLint * v)  {if (GLeeInit()) glMultiTexCoord1iv(target, v);}
  GLEEPFNGLMULTITEXCOORD1IVPROC GLeeFuncPtr_glMultiTexCoord1iv=GLee_Lazy_glMultiTexCoord1iv;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord1s
#define GLEE_C_DEFINED_glMultiTexCoord1s
  void __stdcall GLee_Lazy_glMultiTexCoord1s(GLenum target, GLshort s)  {if (GLeeInit()) glMultiTexCoord1s(target, s);}
  GLEEPFNGLMULTITEXCOORD1SPROC GLeeFuncPtr_glMultiTexCoord1s=GLee_Lazy_glMultiTexCoord1s;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord1sv
#define GLEE_C_DEFINED_glMultiTexCoord1sv
  void __stdcall GLee_Lazy_glMultiTexCoord1sv(GLenum target, const GLshort * v)  {if (GLeeInit()) glMultiTexCoord1sv(target, v);}
  GLEEPFNGLMULTITEXCOORD1SVPROC GLeeFuncPtr_glMultiTexCoord1sv=GLee_Lazy_glMultiTexCoord1sv;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord2d
#define GLEE_C_DEFINED_glMultiTexCoord2d
  void __stdcall GLee_Lazy_glMultiTexCoord2d(GLenum target, GLdouble s, GLdouble t)  {if (GLeeInit()) glMultiTexCoord2d(target, s, t);}
  GLEEPFNGLMULTITEXCOORD2DPROC GLeeFuncPtr_glMultiTexCoord2d=GLee_Lazy_glMultiTexCoord2d;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord2dv
#define GLEE_C_DEFINED_glMultiTexCoord2dv
  void __stdcall GLee_Lazy_glMultiTexCoord2dv(GLenum target, const GLdouble * v)  {if (GLeeInit()) glMultiTexCoord2dv(target, v);}
  GLEEPFNGLMULTITEXCOORD2DVPROC GLeeFuncPtr_glMultiTexCoord2dv=GLee_Lazy_glMultiTexCoord2dv;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord2f
#define GLEE_C_DEFINED_glMultiTexCoord2f
  void __stdcall GLee_Lazy_glMultiTexCoord2f(GLenum target, GLfloat s, GLfloat t)  {if (GLeeInit()) glMultiTexCoord2f(target, s, t);}
  GLEEPFNGLMULTITEXCOORD2FPROC GLeeFuncPtr_glMultiTexCoord2f=GLee_Lazy_glMultiTexCoord2f;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord2fv
#define GLEE_C_DEFINED_glMultiTexCoord2fv
  void __stdcall GLee_Lazy_glMultiTexCoord2fv(GLenum target, const GLfloat * v)  {if (GLeeInit()) glMultiTexCoord2fv(target, v);}
  GLEEPFNGLMULTITEXCOORD2FVPROC GLeeFuncPtr_glMultiTexCoord2fv=GLee_Lazy_glMultiTexCoord2fv;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord2i
#define GLEE_C_DEFINED_glMultiTexCoord2i
  void __stdcall GLee_Lazy_glMultiTexCoord2i(GLenum target, GLint s, GLint t)  {if (GLeeInit()) glMultiTexCoord2i(target, s, t);}
  GLEEPFNGLMULTITEXCOORD2IPROC GLeeFuncPtr_glMultiTexCoord2i=GLee_Lazy_glMultiTexCoord2i;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord2iv
#define GLEE_C_DEFINED_glMultiTexCoord2iv
  void __stdcall GLee_Lazy_glMultiTexCoord2iv(GLenum target, const GLint * v)  {if (GLeeInit()) glMultiTexCoord2iv(target, v);}
  GLEEPFNGLMULTITEXCOORD2IVPROC GLeeFuncPtr_glMultiTexCoord2iv=GLee_Lazy_glMultiTexCoord2iv;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord2s
#define GLEE_C_DEFINED_glMultiTexCoord2s
  void __stdcall GLee_Lazy_glMultiTexCoord2s(GLenum target, GLshort s, GLshort t)  {if (GLeeInit()) glMultiTexCoord2s(target, s, t);}
  GLEEPFNGLMULTITEXCOORD2SPROC GLeeFuncPtr_glMultiTexCoord2s=GLee_Lazy_glMultiTexCoord2s;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord2sv
#define GLEE_C_DEFINED_glMultiTexCoord2sv
  void __stdcall GLee_Lazy_glMultiTexCoord2sv(GLenum target, const GLshort * v)  {if (GLeeInit()) glMultiTexCoord2sv(target, v);}
  GLEEPFNGLMULTITEXCOORD2SVPROC GLeeFuncPtr_glMultiTexCoord2sv=GLee_Lazy_glMultiTexCoord2sv;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord3d
#define GLEE_C_DEFINED_glMultiTexCoord3d
  void __stdcall GLee_Lazy_glMultiTexCoord3d(GLenum target, GLdouble s, GLdouble t, GLdouble r)  {if (GLeeInit()) glMultiTexCoord3d(target, s, t, r);}
  GLEEPFNGLMULTITEXCOORD3DPROC GLeeFuncPtr_glMultiTexCoord3d=GLee_Lazy_glMultiTexCoord3d;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord3dv
#define GLEE_C_DEFINED_glMultiTexCoord3dv
  void __stdcall GLee_Lazy_glMultiTexCoord3dv(GLenum target, const GLdouble * v)  {if (GLeeInit()) glMultiTexCoord3dv(target, v);}
  GLEEPFNGLMULTITEXCOORD3DVPROC GLeeFuncPtr_glMultiTexCoord3dv=GLee_Lazy_glMultiTexCoord3dv;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord3f
#define GLEE_C_DEFINED_glMultiTexCoord3f
  void __stdcall GLee_Lazy_glMultiTexCoord3f(GLenum target, GLfloat s, GLfloat t, GLfloat r)  {if (GLeeInit()) glMultiTexCoord3f(target, s, t, r);}
  GLEEPFNGLMULTITEXCOORD3FPROC GLeeFuncPtr_glMultiTexCoord3f=GLee_Lazy_glMultiTexCoord3f;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord3fv
#define GLEE_C_DEFINED_glMultiTexCoord3fv
  void __stdcall GLee_Lazy_glMultiTexCoord3fv(GLenum target, const GLfloat * v)  {if (GLeeInit()) glMultiTexCoord3fv(target, v);}
  GLEEPFNGLMULTITEXCOORD3FVPROC GLeeFuncPtr_glMultiTexCoord3fv=GLee_Lazy_glMultiTexCoord3fv;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord3i
#define GLEE_C_DEFINED_glMultiTexCoord3i
  void __stdcall GLee_Lazy_glMultiTexCoord3i(GLenum target, GLint s, GLint t, GLint r)  {if (GLeeInit()) glMultiTexCoord3i(target, s, t, r);}
  GLEEPFNGLMULTITEXCOORD3IPROC GLeeFuncPtr_glMultiTexCoord3i=GLee_Lazy_glMultiTexCoord3i;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord3iv
#define GLEE_C_DEFINED_glMultiTexCoord3iv
  void __stdcall GLee_Lazy_glMultiTexCoord3iv(GLenum target, const GLint * v)  {if (GLeeInit()) glMultiTexCoord3iv(target, v);}
  GLEEPFNGLMULTITEXCOORD3IVPROC GLeeFuncPtr_glMultiTexCoord3iv=GLee_Lazy_glMultiTexCoord3iv;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord3s
#define GLEE_C_DEFINED_glMultiTexCoord3s
  void __stdcall GLee_Lazy_glMultiTexCoord3s(GLenum target, GLshort s, GLshort t, GLshort r)  {if (GLeeInit()) glMultiTexCoord3s(target, s, t, r);}
  GLEEPFNGLMULTITEXCOORD3SPROC GLeeFuncPtr_glMultiTexCoord3s=GLee_Lazy_glMultiTexCoord3s;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord3sv
#define GLEE_C_DEFINED_glMultiTexCoord3sv
  void __stdcall GLee_Lazy_glMultiTexCoord3sv(GLenum target, const GLshort * v)  {if (GLeeInit()) glMultiTexCoord3sv(target, v);}
  GLEEPFNGLMULTITEXCOORD3SVPROC GLeeFuncPtr_glMultiTexCoord3sv=GLee_Lazy_glMultiTexCoord3sv;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord4d
#define GLEE_C_DEFINED_glMultiTexCoord4d
  void __stdcall GLee_Lazy_glMultiTexCoord4d(GLenum target, GLdouble s, GLdouble t, GLdouble r, GLdouble q)  {if (GLeeInit()) glMultiTexCoord4d(target, s, t, r, q);}
  GLEEPFNGLMULTITEXCOORD4DPROC GLeeFuncPtr_glMultiTexCoord4d=GLee_Lazy_glMultiTexCoord4d;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord4dv
#define GLEE_C_DEFINED_glMultiTexCoord4dv
  void __stdcall GLee_Lazy_glMultiTexCoord4dv(GLenum target, const GLdouble * v)  {if (GLeeInit()) glMultiTexCoord4dv(target, v);}
  GLEEPFNGLMULTITEXCOORD4DVPROC GLeeFuncPtr_glMultiTexCoord4dv=GLee_Lazy_glMultiTexCoord4dv;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord4f
#define GLEE_C_DEFINED_glMultiTexCoord4f
  void __stdcall GLee_Lazy_glMultiTexCoord4f(GLenum target, GLfloat s, GLfloat t, GLfloat r, GLfloat q)  {if (GLeeInit()) glMultiTexCoord4f(target, s, t, r, q);}
  GLEEPFNGLMULTITEXCOORD4FPROC GLeeFuncPtr_glMultiTexCoord4f=GLee_Lazy_glMultiTexCoord4f;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord4fv
#define GLEE_C_DEFINED_glMultiTexCoord4fv
  void __stdcall GLee_Lazy_glMultiTexCoord4fv(GLenum target, const GLfloat * v)  {if (GLeeInit()) glMultiTexCoord4fv(target, v);}
  GLEEPFNGLMULTITEXCOORD4FVPROC GLeeFuncPtr_glMultiTexCoord4fv=GLee_Lazy_glMultiTexCoord4fv;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord4i
#define GLEE_C_DEFINED_glMultiTexCoord4i
  void __stdcall GLee_Lazy_glMultiTexCoord4i(GLenum target, GLint s, GLint t, GLint r, GLint q)  {if (GLeeInit()) glMultiTexCoord4i(target, s, t, r, q);}
  GLEEPFNGLMULTITEXCOORD4IPROC GLeeFuncPtr_glMultiTexCoord4i=GLee_Lazy_glMultiTexCoord4i;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord4iv
#define GLEE_C_DEFINED_glMultiTexCoord4iv
  void __stdcall GLee_Lazy_glMultiTexCoord4iv(GLenum target, const GLint * v)  {if (GLeeInit()) glMultiTexCoord4iv(target, v);}
  GLEEPFNGLMULTITEXCOORD4IVPROC GLeeFuncPtr_glMultiTexCoord4iv=GLee_Lazy_glMultiTexCoord4iv;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord4s
#define GLEE_C_DEFINED_glMultiTexCoord4s
  void __stdcall GLee_Lazy_glMultiTexCoord4s(GLenum target, GLshort s, GLshort t, GLshort r, GLshort q)  {if (GLeeInit()) glMultiTexCoord4s(target, s, t, r, q);}
  GLEEPFNGLMULTITEXCOORD4SPROC GLeeFuncPtr_glMultiTexCoord4s=GLee_Lazy_glMultiTexCoord4s;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord4sv
#define GLEE_C_DEFINED_glMultiTexCoord4sv
  void __stdcall GLee_Lazy_glMultiTexCoord4sv(GLenum target, const GLshort * v)  {if (GLeeInit()) glMultiTexCoord4sv(target, v);}
  GLEEPFNGLMULTITEXCOORD4SVPROC GLeeFuncPtr_glMultiTexCoord4sv=GLee_Lazy_glMultiTexCoord4sv;
#endif
#ifndef GLEE_C_DEFINED_glLoadTransposeMatrixf
#define GLEE_C_DEFINED_glLoadTransposeMatrixf
  void __stdcall GLee_Lazy_glLoadTransposeMatrixf(const GLfloat * m)  {if (GLeeInit()) glLoadTransposeMatrixf(m);}
  GLEEPFNGLLOADTRANSPOSEMATRIXFPROC GLeeFuncPtr_glLoadTransposeMatrixf=GLee_Lazy_glLoadTransposeMatrixf;
#endif
#ifndef GLEE_C_DEFINED_glLoadTransposeMatrixd
#define GLEE_C_DEFINED_glLoadTransposeMatrixd
  void __stdcall GLee_Lazy_glLoadTransposeMatrixd(const GLdouble * m)  {if (GLeeInit()) glLoadTransposeMatrixd(m);}
  GLEEPFNGLLOADTRANSPOSEMATRIXDPROC GLeeFuncPtr_glLoadTransposeMatrixd=GLee_Lazy_glLoadTransposeMatrixd;
#endif
#ifndef GLEE_C_DEFINED_glMultTransposeMatrixf
#define GLEE_C_DEFINED_glMultTransposeMatrixf
  void __stdcall GLee_Lazy_glMultTransposeMatrixf(const GLfloat * m)  {if (GLeeInit()) glMultTransposeMatrixf(m);}
  GLEEPFNGLMULTTRANSPOSEMATRIXFPROC GLeeFuncPtr_glMultTransposeMatrixf=GLee_Lazy_glMultTransposeMatrixf;
#endif
#ifndef GLEE_C_DEFINED_glMultTransposeMatrixd
#define GLEE_C_DEFINED_glMultTransposeMatrixd
  void __stdcall GLee_Lazy_glMultTransposeMatrixd(const GLdouble * m)  {if (GLeeInit()) glMultTransposeMatrixd(m);}
  GLEEPFNGLMULTTRANSPOSEMATRIXDPROC GLeeFuncPtr_glMultTransposeMatrixd=GLee_Lazy_glMultTransposeMatrixd;
#endif
#ifndef GLEE_C_DEFINED_glSampleCoverage
#define GLEE_C_DEFINED_glSampleCoverage
  void __stdcall GLee_Lazy_glSampleCoverage(GLclampf value, GLboolean invert)  {if (GLeeInit()) glSampleCoverage(value, invert);}
  GLEEPFNGLSAMPLECOVERAGEPROC GLeeFuncPtr_glSampleCoverage=GLee_Lazy_glSampleCoverage;
#endif
#ifndef GLEE_C_DEFINED_glCompressedTexImage3D
#define GLEE_C_DEFINED_glCompressedTexImage3D
  void __stdcall GLee_Lazy_glCompressedTexImage3D(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const GLvoid * data)  {if (GLeeInit()) glCompressedTexImage3D(target, level, internalformat, width, height, depth, border, imageSize, data);}
  GLEEPFNGLCOMPRESSEDTEXIMAGE3DPROC GLeeFuncPtr_glCompressedTexImage3D=GLee_Lazy_glCompressedTexImage3D;
#endif
#ifndef GLEE_C_DEFINED_glCompressedTexImage2D
#define GLEE_C_DEFINED_glCompressedTexImage2D
  void __stdcall GLee_Lazy_glCompressedTexImage2D(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const GLvoid * data)  {if (GLeeInit()) glCompressedTexImage2D(target, level, internalformat, width, height, border, imageSize, data);}
  GLEEPFNGLCOMPRESSEDTEXIMAGE2DPROC GLeeFuncPtr_glCompressedTexImage2D=GLee_Lazy_glCompressedTexImage2D;
#endif
#ifndef GLEE_C_DEFINED_glCompressedTexImage1D
#define GLEE_C_DEFINED_glCompressedTexImage1D
  void __stdcall GLee_Lazy_glCompressedTexImage1D(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const GLvoid * data)  {if (GLeeInit()) glCompressedTexImage1D(target, level, internalformat, width, border, imageSize, data);}
  GLEEPFNGLCOMPRESSEDTEXIMAGE1DPROC GLeeFuncPtr_glCompressedTexImage1D=GLee_Lazy_glCompressedTexImage1D;
#endif
#ifndef GLEE_C_DEFINED_glCompressedTexSubImage3D
#define GLEE_C_DEFINED_glCompressedTexSubImage3D
  void __stdcall GLee_Lazy_glCompressedTexSubImage3D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const GLvoid * data)  {if (GLeeInit()) glCompressedTexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data);}
  GLEEPFNGLCOMPRESSEDTEXSUBIMAGE3DPROC GLeeFuncPtr_glCompressedTexSubImage3D=GLee_Lazy_glCompressedTexSubImage3D;
#endif
#ifndef GLEE_C_DEFINED_glCompressedTexSubImage2D
#define GLEE_C_DEFINED_glCompressedTexSubImage2D
  void __stdcall GLee_Lazy_glCompressedTexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const GLvoid * data)  {if (GLeeInit()) glCompressedTexSubImage2D(target, level, xoffset, yoffset, width, height, format, imageSize, data);}
  GLEEPFNGLCOMPRESSEDTEXSUBIMAGE2DPROC GLeeFuncPtr_glCompressedTexSubImage2D=GLee_Lazy_glCompressedTexSubImage2D;
#endif
#ifndef GLEE_C_DEFINED_glCompressedTexSubImage1D
#define GLEE_C_DEFINED_glCompressedTexSubImage1D
  void __stdcall GLee_Lazy_glCompressedTexSubImage1D(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const GLvoid * data)  {if (GLeeInit()) glCompressedTexSubImage1D(target, level, xoffset, width, format, imageSize, data);}
  GLEEPFNGLCOMPRESSEDTEXSUBIMAGE1DPROC GLeeFuncPtr_glCompressedTexSubImage1D=GLee_Lazy_glCompressedTexSubImage1D;
#endif
#ifndef GLEE_C_DEFINED_glGetCompressedTexImage
#define GLEE_C_DEFINED_glGetCompressedTexImage
  void __stdcall GLee_Lazy_glGetCompressedTexImage(GLenum target, GLint level, GLvoid * img)  {if (GLeeInit()) glGetCompressedTexImage(target, level, img);}
  GLEEPFNGLGETCOMPRESSEDTEXIMAGEPROC GLeeFuncPtr_glGetCompressedTexImage=GLee_Lazy_glGetCompressedTexImage;
#endif
#endif 

/* GL_VERSION_1_4 */

#ifdef __GLEE_GL_VERSION_1_4
#ifndef GLEE_C_DEFINED_glBlendFuncSeparate
#define GLEE_C_DEFINED_glBlendFuncSeparate
  void __stdcall GLee_Lazy_glBlendFuncSeparate(GLenum sfactorRGB, GLenum dfactorRGB, GLenum sfactorAlpha, GLenum dfactorAlpha)  {if (GLeeInit()) glBlendFuncSeparate(sfactorRGB, dfactorRGB, sfactorAlpha, dfactorAlpha);}
  GLEEPFNGLBLENDFUNCSEPARATEPROC GLeeFuncPtr_glBlendFuncSeparate=GLee_Lazy_glBlendFuncSeparate;
#endif
#ifndef GLEE_C_DEFINED_glFogCoordf
#define GLEE_C_DEFINED_glFogCoordf
  void __stdcall GLee_Lazy_glFogCoordf(GLfloat coord)  {if (GLeeInit()) glFogCoordf(coord);}
  GLEEPFNGLFOGCOORDFPROC GLeeFuncPtr_glFogCoordf=GLee_Lazy_glFogCoordf;
#endif
#ifndef GLEE_C_DEFINED_glFogCoordfv
#define GLEE_C_DEFINED_glFogCoordfv
  void __stdcall GLee_Lazy_glFogCoordfv(const GLfloat * coord)  {if (GLeeInit()) glFogCoordfv(coord);}
  GLEEPFNGLFOGCOORDFVPROC GLeeFuncPtr_glFogCoordfv=GLee_Lazy_glFogCoordfv;
#endif
#ifndef GLEE_C_DEFINED_glFogCoordd
#define GLEE_C_DEFINED_glFogCoordd
  void __stdcall GLee_Lazy_glFogCoordd(GLdouble coord)  {if (GLeeInit()) glFogCoordd(coord);}
  GLEEPFNGLFOGCOORDDPROC GLeeFuncPtr_glFogCoordd=GLee_Lazy_glFogCoordd;
#endif
#ifndef GLEE_C_DEFINED_glFogCoorddv
#define GLEE_C_DEFINED_glFogCoorddv
  void __stdcall GLee_Lazy_glFogCoorddv(const GLdouble * coord)  {if (GLeeInit()) glFogCoorddv(coord);}
  GLEEPFNGLFOGCOORDDVPROC GLeeFuncPtr_glFogCoorddv=GLee_Lazy_glFogCoorddv;
#endif
#ifndef GLEE_C_DEFINED_glFogCoordPointer
#define GLEE_C_DEFINED_glFogCoordPointer
  void __stdcall GLee_Lazy_glFogCoordPointer(GLenum type, GLsizei stride, const GLvoid * pointer)  {if (GLeeInit()) glFogCoordPointer(type, stride, pointer);}
  GLEEPFNGLFOGCOORDPOINTERPROC GLeeFuncPtr_glFogCoordPointer=GLee_Lazy_glFogCoordPointer;
#endif
#ifndef GLEE_C_DEFINED_glMultiDrawArrays
#define GLEE_C_DEFINED_glMultiDrawArrays
  void __stdcall GLee_Lazy_glMultiDrawArrays(GLenum mode, GLint * first, GLsizei * count, GLsizei primcount)  {if (GLeeInit()) glMultiDrawArrays(mode, first, count, primcount);}
  GLEEPFNGLMULTIDRAWARRAYSPROC GLeeFuncPtr_glMultiDrawArrays=GLee_Lazy_glMultiDrawArrays;
#endif
#ifndef GLEE_C_DEFINED_glMultiDrawElements
#define GLEE_C_DEFINED_glMultiDrawElements
  void __stdcall GLee_Lazy_glMultiDrawElements(GLenum mode, const GLsizei * count, GLenum type, const GLvoid* * indices, GLsizei primcount)  {if (GLeeInit()) glMultiDrawElements(mode, count, type, indices, primcount);}
  GLEEPFNGLMULTIDRAWELEMENTSPROC GLeeFuncPtr_glMultiDrawElements=GLee_Lazy_glMultiDrawElements;
#endif
#ifndef GLEE_C_DEFINED_glPointParameterf
#define GLEE_C_DEFINED_glPointParameterf
  void __stdcall GLee_Lazy_glPointParameterf(GLenum pname, GLfloat param)  {if (GLeeInit()) glPointParameterf(pname, param);}
  GLEEPFNGLPOINTPARAMETERFPROC GLeeFuncPtr_glPointParameterf=GLee_Lazy_glPointParameterf;
#endif
#ifndef GLEE_C_DEFINED_glPointParameterfv
#define GLEE_C_DEFINED_glPointParameterfv
  void __stdcall GLee_Lazy_glPointParameterfv(GLenum pname, const GLfloat * params)  {if (GLeeInit()) glPointParameterfv(pname, params);}
  GLEEPFNGLPOINTPARAMETERFVPROC GLeeFuncPtr_glPointParameterfv=GLee_Lazy_glPointParameterfv;
#endif
#ifndef GLEE_C_DEFINED_glPointParameteri
#define GLEE_C_DEFINED_glPointParameteri
  void __stdcall GLee_Lazy_glPointParameteri(GLenum pname, GLint param)  {if (GLeeInit()) glPointParameteri(pname, param);}
  GLEEPFNGLPOINTPARAMETERIPROC GLeeFuncPtr_glPointParameteri=GLee_Lazy_glPointParameteri;
#endif
#ifndef GLEE_C_DEFINED_glPointParameteriv
#define GLEE_C_DEFINED_glPointParameteriv
  void __stdcall GLee_Lazy_glPointParameteriv(GLenum pname, const GLint * params)  {if (GLeeInit()) glPointParameteriv(pname, params);}
  GLEEPFNGLPOINTPARAMETERIVPROC GLeeFuncPtr_glPointParameteriv=GLee_Lazy_glPointParameteriv;
#endif
#ifndef GLEE_C_DEFINED_glSecondaryColor3b
#define GLEE_C_DEFINED_glSecondaryColor3b
  void __stdcall GLee_Lazy_glSecondaryColor3b(GLbyte red, GLbyte green, GLbyte blue)  {if (GLeeInit()) glSecondaryColor3b(red, green, blue);}
  GLEEPFNGLSECONDARYCOLOR3BPROC GLeeFuncPtr_glSecondaryColor3b=GLee_Lazy_glSecondaryColor3b;
#endif
#ifndef GLEE_C_DEFINED_glSecondaryColor3bv
#define GLEE_C_DEFINED_glSecondaryColor3bv
  void __stdcall GLee_Lazy_glSecondaryColor3bv(const GLbyte * v)  {if (GLeeInit()) glSecondaryColor3bv(v);}
  GLEEPFNGLSECONDARYCOLOR3BVPROC GLeeFuncPtr_glSecondaryColor3bv=GLee_Lazy_glSecondaryColor3bv;
#endif
#ifndef GLEE_C_DEFINED_glSecondaryColor3d
#define GLEE_C_DEFINED_glSecondaryColor3d
  void __stdcall GLee_Lazy_glSecondaryColor3d(GLdouble red, GLdouble green, GLdouble blue)  {if (GLeeInit()) glSecondaryColor3d(red, green, blue);}
  GLEEPFNGLSECONDARYCOLOR3DPROC GLeeFuncPtr_glSecondaryColor3d=GLee_Lazy_glSecondaryColor3d;
#endif
#ifndef GLEE_C_DEFINED_glSecondaryColor3dv
#define GLEE_C_DEFINED_glSecondaryColor3dv
  void __stdcall GLee_Lazy_glSecondaryColor3dv(const GLdouble * v)  {if (GLeeInit()) glSecondaryColor3dv(v);}
  GLEEPFNGLSECONDARYCOLOR3DVPROC GLeeFuncPtr_glSecondaryColor3dv=GLee_Lazy_glSecondaryColor3dv;
#endif
#ifndef GLEE_C_DEFINED_glSecondaryColor3f
#define GLEE_C_DEFINED_glSecondaryColor3f
  void __stdcall GLee_Lazy_glSecondaryColor3f(GLfloat red, GLfloat green, GLfloat blue)  {if (GLeeInit()) glSecondaryColor3f(red, green, blue);}
  GLEEPFNGLSECONDARYCOLOR3FPROC GLeeFuncPtr_glSecondaryColor3f=GLee_Lazy_glSecondaryColor3f;
#endif
#ifndef GLEE_C_DEFINED_glSecondaryColor3fv
#define GLEE_C_DEFINED_glSecondaryColor3fv
  void __stdcall GLee_Lazy_glSecondaryColor3fv(const GLfloat * v)  {if (GLeeInit()) glSecondaryColor3fv(v);}
  GLEEPFNGLSECONDARYCOLOR3FVPROC GLeeFuncPtr_glSecondaryColor3fv=GLee_Lazy_glSecondaryColor3fv;
#endif
#ifndef GLEE_C_DEFINED_glSecondaryColor3i
#define GLEE_C_DEFINED_glSecondaryColor3i
  void __stdcall GLee_Lazy_glSecondaryColor3i(GLint red, GLint green, GLint blue)  {if (GLeeInit()) glSecondaryColor3i(red, green, blue);}
  GLEEPFNGLSECONDARYCOLOR3IPROC GLeeFuncPtr_glSecondaryColor3i=GLee_Lazy_glSecondaryColor3i;
#endif
#ifndef GLEE_C_DEFINED_glSecondaryColor3iv
#define GLEE_C_DEFINED_glSecondaryColor3iv
  void __stdcall GLee_Lazy_glSecondaryColor3iv(const GLint * v)  {if (GLeeInit()) glSecondaryColor3iv(v);}
  GLEEPFNGLSECONDARYCOLOR3IVPROC GLeeFuncPtr_glSecondaryColor3iv=GLee_Lazy_glSecondaryColor3iv;
#endif
#ifndef GLEE_C_DEFINED_glSecondaryColor3s
#define GLEE_C_DEFINED_glSecondaryColor3s
  void __stdcall GLee_Lazy_glSecondaryColor3s(GLshort red, GLshort green, GLshort blue)  {if (GLeeInit()) glSecondaryColor3s(red, green, blue);}
  GLEEPFNGLSECONDARYCOLOR3SPROC GLeeFuncPtr_glSecondaryColor3s=GLee_Lazy_glSecondaryColor3s;
#endif
#ifndef GLEE_C_DEFINED_glSecondaryColor3sv
#define GLEE_C_DEFINED_glSecondaryColor3sv
  void __stdcall GLee_Lazy_glSecondaryColor3sv(const GLshort * v)  {if (GLeeInit()) glSecondaryColor3sv(v);}
  GLEEPFNGLSECONDARYCOLOR3SVPROC GLeeFuncPtr_glSecondaryColor3sv=GLee_Lazy_glSecondaryColor3sv;
#endif
#ifndef GLEE_C_DEFINED_glSecondaryColor3ub
#define GLEE_C_DEFINED_glSecondaryColor3ub
  void __stdcall GLee_Lazy_glSecondaryColor3ub(GLubyte red, GLubyte green, GLubyte blue)  {if (GLeeInit()) glSecondaryColor3ub(red, green, blue);}
  GLEEPFNGLSECONDARYCOLOR3UBPROC GLeeFuncPtr_glSecondaryColor3ub=GLee_Lazy_glSecondaryColor3ub;
#endif
#ifndef GLEE_C_DEFINED_glSecondaryColor3ubv
#define GLEE_C_DEFINED_glSecondaryColor3ubv
  void __stdcall GLee_Lazy_glSecondaryColor3ubv(const GLubyte * v)  {if (GLeeInit()) glSecondaryColor3ubv(v);}
  GLEEPFNGLSECONDARYCOLOR3UBVPROC GLeeFuncPtr_glSecondaryColor3ubv=GLee_Lazy_glSecondaryColor3ubv;
#endif
#ifndef GLEE_C_DEFINED_glSecondaryColor3ui
#define GLEE_C_DEFINED_glSecondaryColor3ui
  void __stdcall GLee_Lazy_glSecondaryColor3ui(GLuint red, GLuint green, GLuint blue)  {if (GLeeInit()) glSecondaryColor3ui(red, green, blue);}
  GLEEPFNGLSECONDARYCOLOR3UIPROC GLeeFuncPtr_glSecondaryColor3ui=GLee_Lazy_glSecondaryColor3ui;
#endif
#ifndef GLEE_C_DEFINED_glSecondaryColor3uiv
#define GLEE_C_DEFINED_glSecondaryColor3uiv
  void __stdcall GLee_Lazy_glSecondaryColor3uiv(const GLuint * v)  {if (GLeeInit()) glSecondaryColor3uiv(v);}
  GLEEPFNGLSECONDARYCOLOR3UIVPROC GLeeFuncPtr_glSecondaryColor3uiv=GLee_Lazy_glSecondaryColor3uiv;
#endif
#ifndef GLEE_C_DEFINED_glSecondaryColor3us
#define GLEE_C_DEFINED_glSecondaryColor3us
  void __stdcall GLee_Lazy_glSecondaryColor3us(GLushort red, GLushort green, GLushort blue)  {if (GLeeInit()) glSecondaryColor3us(red, green, blue);}
  GLEEPFNGLSECONDARYCOLOR3USPROC GLeeFuncPtr_glSecondaryColor3us=GLee_Lazy_glSecondaryColor3us;
#endif
#ifndef GLEE_C_DEFINED_glSecondaryColor3usv
#define GLEE_C_DEFINED_glSecondaryColor3usv
  void __stdcall GLee_Lazy_glSecondaryColor3usv(const GLushort * v)  {if (GLeeInit()) glSecondaryColor3usv(v);}
  GLEEPFNGLSECONDARYCOLOR3USVPROC GLeeFuncPtr_glSecondaryColor3usv=GLee_Lazy_glSecondaryColor3usv;
#endif
#ifndef GLEE_C_DEFINED_glSecondaryColorPointer
#define GLEE_C_DEFINED_glSecondaryColorPointer
  void __stdcall GLee_Lazy_glSecondaryColorPointer(GLint size, GLenum type, GLsizei stride, const GLvoid * pointer)  {if (GLeeInit()) glSecondaryColorPointer(size, type, stride, pointer);}
  GLEEPFNGLSECONDARYCOLORPOINTERPROC GLeeFuncPtr_glSecondaryColorPointer=GLee_Lazy_glSecondaryColorPointer;
#endif
#ifndef GLEE_C_DEFINED_glWindowPos2d
#define GLEE_C_DEFINED_glWindowPos2d
  void __stdcall GLee_Lazy_glWindowPos2d(GLdouble x, GLdouble y)  {if (GLeeInit()) glWindowPos2d(x, y);}
  GLEEPFNGLWINDOWPOS2DPROC GLeeFuncPtr_glWindowPos2d=GLee_Lazy_glWindowPos2d;
#endif
#ifndef GLEE_C_DEFINED_glWindowPos2dv
#define GLEE_C_DEFINED_glWindowPos2dv
  void __stdcall GLee_Lazy_glWindowPos2dv(const GLdouble * v)  {if (GLeeInit()) glWindowPos2dv(v);}
  GLEEPFNGLWINDOWPOS2DVPROC GLeeFuncPtr_glWindowPos2dv=GLee_Lazy_glWindowPos2dv;
#endif
#ifndef GLEE_C_DEFINED_glWindowPos2f
#define GLEE_C_DEFINED_glWindowPos2f
  void __stdcall GLee_Lazy_glWindowPos2f(GLfloat x, GLfloat y)  {if (GLeeInit()) glWindowPos2f(x, y);}
  GLEEPFNGLWINDOWPOS2FPROC GLeeFuncPtr_glWindowPos2f=GLee_Lazy_glWindowPos2f;
#endif
#ifndef GLEE_C_DEFINED_glWindowPos2fv
#define GLEE_C_DEFINED_glWindowPos2fv
  void __stdcall GLee_Lazy_glWindowPos2fv(const GLfloat * v)  {if (GLeeInit()) glWindowPos2fv(v);}
  GLEEPFNGLWINDOWPOS2FVPROC GLeeFuncPtr_glWindowPos2fv=GLee_Lazy_glWindowPos2fv;
#endif
#ifndef GLEE_C_DEFINED_glWindowPos2i
#define GLEE_C_DEFINED_glWindowPos2i
  void __stdcall GLee_Lazy_glWindowPos2i(GLint x, GLint y)  {if (GLeeInit()) glWindowPos2i(x, y);}
  GLEEPFNGLWINDOWPOS2IPROC GLeeFuncPtr_glWindowPos2i=GLee_Lazy_glWindowPos2i;
#endif
#ifndef GLEE_C_DEFINED_glWindowPos2iv
#define GLEE_C_DEFINED_glWindowPos2iv
  void __stdcall GLee_Lazy_glWindowPos2iv(const GLint * v)  {if (GLeeInit()) glWindowPos2iv(v);}
  GLEEPFNGLWINDOWPOS2IVPROC GLeeFuncPtr_glWindowPos2iv=GLee_Lazy_glWindowPos2iv;
#endif
#ifndef GLEE_C_DEFINED_glWindowPos2s
#define GLEE_C_DEFINED_glWindowPos2s
  void __stdcall GLee_Lazy_glWindowPos2s(GLshort x, GLshort y)  {if (GLeeInit()) glWindowPos2s(x, y);}
  GLEEPFNGLWINDOWPOS2SPROC GLeeFuncPtr_glWindowPos2s=GLee_Lazy_glWindowPos2s;
#endif
#ifndef GLEE_C_DEFINED_glWindowPos2sv
#define GLEE_C_DEFINED_glWindowPos2sv
  void __stdcall GLee_Lazy_glWindowPos2sv(const GLshort * v)  {if (GLeeInit()) glWindowPos2sv(v);}
  GLEEPFNGLWINDOWPOS2SVPROC GLeeFuncPtr_glWindowPos2sv=GLee_Lazy_glWindowPos2sv;
#endif
#ifndef GLEE_C_DEFINED_glWindowPos3d
#define GLEE_C_DEFINED_glWindowPos3d
  void __stdcall GLee_Lazy_glWindowPos3d(GLdouble x, GLdouble y, GLdouble z)  {if (GLeeInit()) glWindowPos3d(x, y, z);}
  GLEEPFNGLWINDOWPOS3DPROC GLeeFuncPtr_glWindowPos3d=GLee_Lazy_glWindowPos3d;
#endif
#ifndef GLEE_C_DEFINED_glWindowPos3dv
#define GLEE_C_DEFINED_glWindowPos3dv
  void __stdcall GLee_Lazy_glWindowPos3dv(const GLdouble * v)  {if (GLeeInit()) glWindowPos3dv(v);}
  GLEEPFNGLWINDOWPOS3DVPROC GLeeFuncPtr_glWindowPos3dv=GLee_Lazy_glWindowPos3dv;
#endif
#ifndef GLEE_C_DEFINED_glWindowPos3f
#define GLEE_C_DEFINED_glWindowPos3f
  void __stdcall GLee_Lazy_glWindowPos3f(GLfloat x, GLfloat y, GLfloat z)  {if (GLeeInit()) glWindowPos3f(x, y, z);}
  GLEEPFNGLWINDOWPOS3FPROC GLeeFuncPtr_glWindowPos3f=GLee_Lazy_glWindowPos3f;
#endif
#ifndef GLEE_C_DEFINED_glWindowPos3fv
#define GLEE_C_DEFINED_glWindowPos3fv
  void __stdcall GLee_Lazy_glWindowPos3fv(const GLfloat * v)  {if (GLeeInit()) glWindowPos3fv(v);}
  GLEEPFNGLWINDOWPOS3FVPROC GLeeFuncPtr_glWindowPos3fv=GLee_Lazy_glWindowPos3fv;
#endif
#ifndef GLEE_C_DEFINED_glWindowPos3i
#define GLEE_C_DEFINED_glWindowPos3i
  void __stdcall GLee_Lazy_glWindowPos3i(GLint x, GLint y, GLint z)  {if (GLeeInit()) glWindowPos3i(x, y, z);}
  GLEEPFNGLWINDOWPOS3IPROC GLeeFuncPtr_glWindowPos3i=GLee_Lazy_glWindowPos3i;
#endif
#ifndef GLEE_C_DEFINED_glWindowPos3iv
#define GLEE_C_DEFINED_glWindowPos3iv
  void __stdcall GLee_Lazy_glWindowPos3iv(const GLint * v)  {if (GLeeInit()) glWindowPos3iv(v);}
  GLEEPFNGLWINDOWPOS3IVPROC GLeeFuncPtr_glWindowPos3iv=GLee_Lazy_glWindowPos3iv;
#endif
#ifndef GLEE_C_DEFINED_glWindowPos3s
#define GLEE_C_DEFINED_glWindowPos3s
  void __stdcall GLee_Lazy_glWindowPos3s(GLshort x, GLshort y, GLshort z)  {if (GLeeInit()) glWindowPos3s(x, y, z);}
  GLEEPFNGLWINDOWPOS3SPROC GLeeFuncPtr_glWindowPos3s=GLee_Lazy_glWindowPos3s;
#endif
#ifndef GLEE_C_DEFINED_glWindowPos3sv
#define GLEE_C_DEFINED_glWindowPos3sv
  void __stdcall GLee_Lazy_glWindowPos3sv(const GLshort * v)  {if (GLeeInit()) glWindowPos3sv(v);}
  GLEEPFNGLWINDOWPOS3SVPROC GLeeFuncPtr_glWindowPos3sv=GLee_Lazy_glWindowPos3sv;
#endif
#endif 

/* GL_VERSION_1_5 */

#ifdef __GLEE_GL_VERSION_1_5
#ifndef GLEE_C_DEFINED_glGenQueries
#define GLEE_C_DEFINED_glGenQueries
  void __stdcall GLee_Lazy_glGenQueries(GLsizei n, GLuint * ids)  {if (GLeeInit()) glGenQueries(n, ids);}
  GLEEPFNGLGENQUERIESPROC GLeeFuncPtr_glGenQueries=GLee_Lazy_glGenQueries;
#endif
#ifndef GLEE_C_DEFINED_glDeleteQueries
#define GLEE_C_DEFINED_glDeleteQueries
  void __stdcall GLee_Lazy_glDeleteQueries(GLsizei n, const GLuint * ids)  {if (GLeeInit()) glDeleteQueries(n, ids);}
  GLEEPFNGLDELETEQUERIESPROC GLeeFuncPtr_glDeleteQueries=GLee_Lazy_glDeleteQueries;
#endif
#ifndef GLEE_C_DEFINED_glIsQuery
#define GLEE_C_DEFINED_glIsQuery
  GLboolean __stdcall GLee_Lazy_glIsQuery(GLuint id)  {if (GLeeInit()) return glIsQuery(id); return (GLboolean)0;}
  GLEEPFNGLISQUERYPROC GLeeFuncPtr_glIsQuery=GLee_Lazy_glIsQuery;
#endif
#ifndef GLEE_C_DEFINED_glBeginQuery
#define GLEE_C_DEFINED_glBeginQuery
  void __stdcall GLee_Lazy_glBeginQuery(GLenum target, GLuint id)  {if (GLeeInit()) glBeginQuery(target, id);}
  GLEEPFNGLBEGINQUERYPROC GLeeFuncPtr_glBeginQuery=GLee_Lazy_glBeginQuery;
#endif
#ifndef GLEE_C_DEFINED_glEndQuery
#define GLEE_C_DEFINED_glEndQuery
  void __stdcall GLee_Lazy_glEndQuery(GLenum target)  {if (GLeeInit()) glEndQuery(target);}
  GLEEPFNGLENDQUERYPROC GLeeFuncPtr_glEndQuery=GLee_Lazy_glEndQuery;
#endif
#ifndef GLEE_C_DEFINED_glGetQueryiv
#define GLEE_C_DEFINED_glGetQueryiv
  void __stdcall GLee_Lazy_glGetQueryiv(GLenum target, GLenum pname, GLint * params)  {if (GLeeInit()) glGetQueryiv(target, pname, params);}
  GLEEPFNGLGETQUERYIVPROC GLeeFuncPtr_glGetQueryiv=GLee_Lazy_glGetQueryiv;
#endif
#ifndef GLEE_C_DEFINED_glGetQueryObjectiv
#define GLEE_C_DEFINED_glGetQueryObjectiv
  void __stdcall GLee_Lazy_glGetQueryObjectiv(GLuint id, GLenum pname, GLint * params)  {if (GLeeInit()) glGetQueryObjectiv(id, pname, params);}
  GLEEPFNGLGETQUERYOBJECTIVPROC GLeeFuncPtr_glGetQueryObjectiv=GLee_Lazy_glGetQueryObjectiv;
#endif
#ifndef GLEE_C_DEFINED_glGetQueryObjectuiv
#define GLEE_C_DEFINED_glGetQueryObjectuiv
  void __stdcall GLee_Lazy_glGetQueryObjectuiv(GLuint id, GLenum pname, GLuint * params)  {if (GLeeInit()) glGetQueryObjectuiv(id, pname, params);}
  GLEEPFNGLGETQUERYOBJECTUIVPROC GLeeFuncPtr_glGetQueryObjectuiv=GLee_Lazy_glGetQueryObjectuiv;
#endif
#ifndef GLEE_C_DEFINED_glBindBuffer
#define GLEE_C_DEFINED_glBindBuffer
  void __stdcall GLee_Lazy_glBindBuffer(GLenum target, GLuint buffer)  {if (GLeeInit()) glBindBuffer(target, buffer);}
  GLEEPFNGLBINDBUFFERPROC GLeeFuncPtr_glBindBuffer=GLee_Lazy_glBindBuffer;
#endif
#ifndef GLEE_C_DEFINED_glDeleteBuffers
#define GLEE_C_DEFINED_glDeleteBuffers
  void __stdcall GLee_Lazy_glDeleteBuffers(GLsizei n, const GLuint * buffers)  {if (GLeeInit()) glDeleteBuffers(n, buffers);}
  GLEEPFNGLDELETEBUFFERSPROC GLeeFuncPtr_glDeleteBuffers=GLee_Lazy_glDeleteBuffers;
#endif
#ifndef GLEE_C_DEFINED_glGenBuffers
#define GLEE_C_DEFINED_glGenBuffers
  void __stdcall GLee_Lazy_glGenBuffers(GLsizei n, GLuint * buffers)  {if (GLeeInit()) glGenBuffers(n, buffers);}
  GLEEPFNGLGENBUFFERSPROC GLeeFuncPtr_glGenBuffers=GLee_Lazy_glGenBuffers;
#endif
#ifndef GLEE_C_DEFINED_glIsBuffer
#define GLEE_C_DEFINED_glIsBuffer
  GLboolean __stdcall GLee_Lazy_glIsBuffer(GLuint buffer)  {if (GLeeInit()) return glIsBuffer(buffer); return (GLboolean)0;}
  GLEEPFNGLISBUFFERPROC GLeeFuncPtr_glIsBuffer=GLee_Lazy_glIsBuffer;
#endif
#ifndef GLEE_C_DEFINED_glBufferData
#define GLEE_C_DEFINED_glBufferData
  void __stdcall GLee_Lazy_glBufferData(GLenum target, GLsizeiptr size, const GLvoid * data, GLenum usage)  {if (GLeeInit()) glBufferData(target, size, data, usage);}
  GLEEPFNGLBUFFERDATAPROC GLeeFuncPtr_glBufferData=GLee_Lazy_glBufferData;
#endif
#ifndef GLEE_C_DEFINED_glBufferSubData
#define GLEE_C_DEFINED_glBufferSubData
  void __stdcall GLee_Lazy_glBufferSubData(GLenum target, GLintptr offset, GLsizeiptr size, const GLvoid * data)  {if (GLeeInit()) glBufferSubData(target, offset, size, data);}
  GLEEPFNGLBUFFERSUBDATAPROC GLeeFuncPtr_glBufferSubData=GLee_Lazy_glBufferSubData;
#endif
#ifndef GLEE_C_DEFINED_glGetBufferSubData
#define GLEE_C_DEFINED_glGetBufferSubData
  void __stdcall GLee_Lazy_glGetBufferSubData(GLenum target, GLintptr offset, GLsizeiptr size, GLvoid * data)  {if (GLeeInit()) glGetBufferSubData(target, offset, size, data);}
  GLEEPFNGLGETBUFFERSUBDATAPROC GLeeFuncPtr_glGetBufferSubData=GLee_Lazy_glGetBufferSubData;
#endif
#ifndef GLEE_C_DEFINED_glMapBuffer
#define GLEE_C_DEFINED_glMapBuffer
  GLvoid* __stdcall GLee_Lazy_glMapBuffer(GLenum target, GLenum access)  {if (GLeeInit()) return glMapBuffer(target, access); return (GLvoid*)0;}
  GLEEPFNGLMAPBUFFERPROC GLeeFuncPtr_glMapBuffer=GLee_Lazy_glMapBuffer;
#endif
#ifndef GLEE_C_DEFINED_glUnmapBuffer
#define GLEE_C_DEFINED_glUnmapBuffer
  GLboolean __stdcall GLee_Lazy_glUnmapBuffer(GLenum target)  {if (GLeeInit()) return glUnmapBuffer(target); return (GLboolean)0;}
  GLEEPFNGLUNMAPBUFFERPROC GLeeFuncPtr_glUnmapBuffer=GLee_Lazy_glUnmapBuffer;
#endif
#ifndef GLEE_C_DEFINED_glGetBufferParameteriv
#define GLEE_C_DEFINED_glGetBufferParameteriv
  void __stdcall GLee_Lazy_glGetBufferParameteriv(GLenum target, GLenum pname, GLint * params)  {if (GLeeInit()) glGetBufferParameteriv(target, pname, params);}
  GLEEPFNGLGETBUFFERPARAMETERIVPROC GLeeFuncPtr_glGetBufferParameteriv=GLee_Lazy_glGetBufferParameteriv;
#endif
#ifndef GLEE_C_DEFINED_glGetBufferPointerv
#define GLEE_C_DEFINED_glGetBufferPointerv
  void __stdcall GLee_Lazy_glGetBufferPointerv(GLenum target, GLenum pname, GLvoid* * params)  {if (GLeeInit()) glGetBufferPointerv(target, pname, params);}
  GLEEPFNGLGETBUFFERPOINTERVPROC GLeeFuncPtr_glGetBufferPointerv=GLee_Lazy_glGetBufferPointerv;
#endif
#endif 

/* GL_VERSION_2_0 */

#ifdef __GLEE_GL_VERSION_2_0
#ifndef GLEE_C_DEFINED_glBlendEquationSeparate
#define GLEE_C_DEFINED_glBlendEquationSeparate
  void __stdcall GLee_Lazy_glBlendEquationSeparate(GLenum modeRGB, GLenum modeAlpha)  {if (GLeeInit()) glBlendEquationSeparate(modeRGB, modeAlpha);}
  GLEEPFNGLBLENDEQUATIONSEPARATEPROC GLeeFuncPtr_glBlendEquationSeparate=GLee_Lazy_glBlendEquationSeparate;
#endif
#ifndef GLEE_C_DEFINED_glDrawBuffers
#define GLEE_C_DEFINED_glDrawBuffers
  void __stdcall GLee_Lazy_glDrawBuffers(GLsizei n, const GLenum * bufs)  {if (GLeeInit()) glDrawBuffers(n, bufs);}
  GLEEPFNGLDRAWBUFFERSPROC GLeeFuncPtr_glDrawBuffers=GLee_Lazy_glDrawBuffers;
#endif
#ifndef GLEE_C_DEFINED_glStencilOpSeparate
#define GLEE_C_DEFINED_glStencilOpSeparate
  void __stdcall GLee_Lazy_glStencilOpSeparate(GLenum face, GLenum sfail, GLenum dpfail, GLenum dppass)  {if (GLeeInit()) glStencilOpSeparate(face, sfail, dpfail, dppass);}
  GLEEPFNGLSTENCILOPSEPARATEPROC GLeeFuncPtr_glStencilOpSeparate=GLee_Lazy_glStencilOpSeparate;
#endif
#ifndef GLEE_C_DEFINED_glStencilFuncSeparate
#define GLEE_C_DEFINED_glStencilFuncSeparate
  void __stdcall GLee_Lazy_glStencilFuncSeparate(GLenum frontfunc, GLenum backfunc, GLint ref, GLuint mask)  {if (GLeeInit()) glStencilFuncSeparate(frontfunc, backfunc, ref, mask);}
  GLEEPFNGLSTENCILFUNCSEPARATEPROC GLeeFuncPtr_glStencilFuncSeparate=GLee_Lazy_glStencilFuncSeparate;
#endif
#ifndef GLEE_C_DEFINED_glStencilMaskSeparate
#define GLEE_C_DEFINED_glStencilMaskSeparate
  void __stdcall GLee_Lazy_glStencilMaskSeparate(GLenum face, GLuint mask)  {if (GLeeInit()) glStencilMaskSeparate(face, mask);}
  GLEEPFNGLSTENCILMASKSEPARATEPROC GLeeFuncPtr_glStencilMaskSeparate=GLee_Lazy_glStencilMaskSeparate;
#endif
#ifndef GLEE_C_DEFINED_glAttachShader
#define GLEE_C_DEFINED_glAttachShader
  void __stdcall GLee_Lazy_glAttachShader(GLuint program, GLuint shader)  {if (GLeeInit()) glAttachShader(program, shader);}
  GLEEPFNGLATTACHSHADERPROC GLeeFuncPtr_glAttachShader=GLee_Lazy_glAttachShader;
#endif
#ifndef GLEE_C_DEFINED_glBindAttribLocation
#define GLEE_C_DEFINED_glBindAttribLocation
  void __stdcall GLee_Lazy_glBindAttribLocation(GLuint program, GLuint index, const GLchar * name)  {if (GLeeInit()) glBindAttribLocation(program, index, name);}
  GLEEPFNGLBINDATTRIBLOCATIONPROC GLeeFuncPtr_glBindAttribLocation=GLee_Lazy_glBindAttribLocation;
#endif
#ifndef GLEE_C_DEFINED_glCompileShader
#define GLEE_C_DEFINED_glCompileShader
  void __stdcall GLee_Lazy_glCompileShader(GLuint shader)  {if (GLeeInit()) glCompileShader(shader);}
  GLEEPFNGLCOMPILESHADERPROC GLeeFuncPtr_glCompileShader=GLee_Lazy_glCompileShader;
#endif
#ifndef GLEE_C_DEFINED_glCreateProgram
#define GLEE_C_DEFINED_glCreateProgram
  GLuint __stdcall GLee_Lazy_glCreateProgram(void)  {if (GLeeInit()) return glCreateProgram(); return (GLuint)0;}
  GLEEPFNGLCREATEPROGRAMPROC GLeeFuncPtr_glCreateProgram=GLee_Lazy_glCreateProgram;
#endif
#ifndef GLEE_C_DEFINED_glCreateShader
#define GLEE_C_DEFINED_glCreateShader
  GLuint __stdcall GLee_Lazy_glCreateShader(GLenum type)  {if (GLeeInit()) return glCreateShader(type); return (GLuint)0;}
  GLEEPFNGLCREATESHADERPROC GLeeFuncPtr_glCreateShader=GLee_Lazy_glCreateShader;
#endif
#ifndef GLEE_C_DEFINED_glDeleteProgram
#define GLEE_C_DEFINED_glDeleteProgram
  void __stdcall GLee_Lazy_glDeleteProgram(GLuint program)  {if (GLeeInit()) glDeleteProgram(program);}
  GLEEPFNGLDELETEPROGRAMPROC GLeeFuncPtr_glDeleteProgram=GLee_Lazy_glDeleteProgram;
#endif
#ifndef GLEE_C_DEFINED_glDeleteShader
#define GLEE_C_DEFINED_glDeleteShader
  void __stdcall GLee_Lazy_glDeleteShader(GLuint shader)  {if (GLeeInit()) glDeleteShader(shader);}
  GLEEPFNGLDELETESHADERPROC GLeeFuncPtr_glDeleteShader=GLee_Lazy_glDeleteShader;
#endif
#ifndef GLEE_C_DEFINED_glDetachShader
#define GLEE_C_DEFINED_glDetachShader
  void __stdcall GLee_Lazy_glDetachShader(GLuint program, GLuint shader)  {if (GLeeInit()) glDetachShader(program, shader);}
  GLEEPFNGLDETACHSHADERPROC GLeeFuncPtr_glDetachShader=GLee_Lazy_glDetachShader;
#endif
#ifndef GLEE_C_DEFINED_glDisableVertexAttribArray
#define GLEE_C_DEFINED_glDisableVertexAttribArray
  void __stdcall GLee_Lazy_glDisableVertexAttribArray(GLuint index)  {if (GLeeInit()) glDisableVertexAttribArray(index);}
  GLEEPFNGLDISABLEVERTEXATTRIBARRAYPROC GLeeFuncPtr_glDisableVertexAttribArray=GLee_Lazy_glDisableVertexAttribArray;
#endif
#ifndef GLEE_C_DEFINED_glEnableVertexAttribArray
#define GLEE_C_DEFINED_glEnableVertexAttribArray
  void __stdcall GLee_Lazy_glEnableVertexAttribArray(GLuint index)  {if (GLeeInit()) glEnableVertexAttribArray(index);}
  GLEEPFNGLENABLEVERTEXATTRIBARRAYPROC GLeeFuncPtr_glEnableVertexAttribArray=GLee_Lazy_glEnableVertexAttribArray;
#endif
#ifndef GLEE_C_DEFINED_glGetActiveAttrib
#define GLEE_C_DEFINED_glGetActiveAttrib
  void __stdcall GLee_Lazy_glGetActiveAttrib(GLuint program, GLuint index, GLsizei bufSize, GLsizei * length, GLint * size, GLenum * type, GLchar * name)  {if (GLeeInit()) glGetActiveAttrib(program, index, bufSize, length, size, type, name);}
  GLEEPFNGLGETACTIVEATTRIBPROC GLeeFuncPtr_glGetActiveAttrib=GLee_Lazy_glGetActiveAttrib;
#endif
#ifndef GLEE_C_DEFINED_glGetActiveUniform
#define GLEE_C_DEFINED_glGetActiveUniform
  void __stdcall GLee_Lazy_glGetActiveUniform(GLuint program, GLuint index, GLsizei bufSize, GLsizei * length, GLint * size, GLenum * type, GLchar * name)  {if (GLeeInit()) glGetActiveUniform(program, index, bufSize, length, size, type, name);}
  GLEEPFNGLGETACTIVEUNIFORMPROC GLeeFuncPtr_glGetActiveUniform=GLee_Lazy_glGetActiveUniform;
#endif
#ifndef GLEE_C_DEFINED_glGetAttachedShaders
#define GLEE_C_DEFINED_glGetAttachedShaders
  void __stdcall GLee_Lazy_glGetAttachedShaders(GLuint program, GLsizei maxCount, GLsizei * count, GLuint * obj)  {if (GLeeInit()) glGetAttachedShaders(program, maxCount, count, obj);}
  GLEEPFNGLGETATTACHEDSHADERSPROC GLeeFuncPtr_glGetAttachedShaders=GLee_Lazy_glGetAttachedShaders;
#endif
#ifndef GLEE_C_DEFINED_glGetAttribLocation
#define GLEE_C_DEFINED_glGetAttribLocation
  GLint __stdcall GLee_Lazy_glGetAttribLocation(GLuint program, const GLchar * name)  {if (GLeeInit()) return glGetAttribLocation(program, name); return (GLint)0;}
  GLEEPFNGLGETATTRIBLOCATIONPROC GLeeFuncPtr_glGetAttribLocation=GLee_Lazy_glGetAttribLocation;
#endif
#ifndef GLEE_C_DEFINED_glGetProgramiv
#define GLEE_C_DEFINED_glGetProgramiv
  void __stdcall GLee_Lazy_glGetProgramiv(GLuint program, GLenum pname, GLint * params)  {if (GLeeInit()) glGetProgramiv(program, pname, params);}
  GLEEPFNGLGETPROGRAMIVPROC GLeeFuncPtr_glGetProgramiv=GLee_Lazy_glGetProgramiv;
#endif
#ifndef GLEE_C_DEFINED_glGetProgramInfoLog
#define GLEE_C_DEFINED_glGetProgramInfoLog
  void __stdcall GLee_Lazy_glGetProgramInfoLog(GLuint program, GLsizei bufSize, GLsizei * length, GLchar * infoLog)  {if (GLeeInit()) glGetProgramInfoLog(program, bufSize, length, infoLog);}
  GLEEPFNGLGETPROGRAMINFOLOGPROC GLeeFuncPtr_glGetProgramInfoLog=GLee_Lazy_glGetProgramInfoLog;
#endif
#ifndef GLEE_C_DEFINED_glGetShaderiv
#define GLEE_C_DEFINED_glGetShaderiv
  void __stdcall GLee_Lazy_glGetShaderiv(GLuint shader, GLenum pname, GLint * params)  {if (GLeeInit()) glGetShaderiv(shader, pname, params);}
  GLEEPFNGLGETSHADERIVPROC GLeeFuncPtr_glGetShaderiv=GLee_Lazy_glGetShaderiv;
#endif
#ifndef GLEE_C_DEFINED_glGetShaderInfoLog
#define GLEE_C_DEFINED_glGetShaderInfoLog
  void __stdcall GLee_Lazy_glGetShaderInfoLog(GLuint shader, GLsizei bufSize, GLsizei * length, GLchar * infoLog)  {if (GLeeInit()) glGetShaderInfoLog(shader, bufSize, length, infoLog);}
  GLEEPFNGLGETSHADERINFOLOGPROC GLeeFuncPtr_glGetShaderInfoLog=GLee_Lazy_glGetShaderInfoLog;
#endif
#ifndef GLEE_C_DEFINED_glGetShaderSource
#define GLEE_C_DEFINED_glGetShaderSource
  void __stdcall GLee_Lazy_glGetShaderSource(GLuint shader, GLsizei bufSize, GLsizei * length, GLchar * source)  {if (GLeeInit()) glGetShaderSource(shader, bufSize, length, source);}
  GLEEPFNGLGETSHADERSOURCEPROC GLeeFuncPtr_glGetShaderSource=GLee_Lazy_glGetShaderSource;
#endif
#ifndef GLEE_C_DEFINED_glGetUniformLocation
#define GLEE_C_DEFINED_glGetUniformLocation
  GLint __stdcall GLee_Lazy_glGetUniformLocation(GLuint program, const GLchar * name)  {if (GLeeInit()) return glGetUniformLocation(program, name); return (GLint)0;}
  GLEEPFNGLGETUNIFORMLOCATIONPROC GLeeFuncPtr_glGetUniformLocation=GLee_Lazy_glGetUniformLocation;
#endif
#ifndef GLEE_C_DEFINED_glGetUniformfv
#define GLEE_C_DEFINED_glGetUniformfv
  void __stdcall GLee_Lazy_glGetUniformfv(GLuint program, GLint location, GLfloat * params)  {if (GLeeInit()) glGetUniformfv(program, location, params);}
  GLEEPFNGLGETUNIFORMFVPROC GLeeFuncPtr_glGetUniformfv=GLee_Lazy_glGetUniformfv;
#endif
#ifndef GLEE_C_DEFINED_glGetUniformiv
#define GLEE_C_DEFINED_glGetUniformiv
  void __stdcall GLee_Lazy_glGetUniformiv(GLuint program, GLint location, GLint * params)  {if (GLeeInit()) glGetUniformiv(program, location, params);}
  GLEEPFNGLGETUNIFORMIVPROC GLeeFuncPtr_glGetUniformiv=GLee_Lazy_glGetUniformiv;
#endif
#ifndef GLEE_C_DEFINED_glGetVertexAttribdv
#define GLEE_C_DEFINED_glGetVertexAttribdv
  void __stdcall GLee_Lazy_glGetVertexAttribdv(GLuint index, GLenum pname, GLdouble * params)  {if (GLeeInit()) glGetVertexAttribdv(index, pname, params);}
  GLEEPFNGLGETVERTEXATTRIBDVPROC GLeeFuncPtr_glGetVertexAttribdv=GLee_Lazy_glGetVertexAttribdv;
#endif
#ifndef GLEE_C_DEFINED_glGetVertexAttribfv
#define GLEE_C_DEFINED_glGetVertexAttribfv
  void __stdcall GLee_Lazy_glGetVertexAttribfv(GLuint index, GLenum pname, GLfloat * params)  {if (GLeeInit()) glGetVertexAttribfv(index, pname, params);}
  GLEEPFNGLGETVERTEXATTRIBFVPROC GLeeFuncPtr_glGetVertexAttribfv=GLee_Lazy_glGetVertexAttribfv;
#endif
#ifndef GLEE_C_DEFINED_glGetVertexAttribiv
#define GLEE_C_DEFINED_glGetVertexAttribiv
  void __stdcall GLee_Lazy_glGetVertexAttribiv(GLuint index, GLenum pname, GLint * params)  {if (GLeeInit()) glGetVertexAttribiv(index, pname, params);}
  GLEEPFNGLGETVERTEXATTRIBIVPROC GLeeFuncPtr_glGetVertexAttribiv=GLee_Lazy_glGetVertexAttribiv;
#endif
#ifndef GLEE_C_DEFINED_glGetVertexAttribPointerv
#define GLEE_C_DEFINED_glGetVertexAttribPointerv
  void __stdcall GLee_Lazy_glGetVertexAttribPointerv(GLuint index, GLenum pname, GLvoid* * pointer)  {if (GLeeInit()) glGetVertexAttribPointerv(index, pname, pointer);}
  GLEEPFNGLGETVERTEXATTRIBPOINTERVPROC GLeeFuncPtr_glGetVertexAttribPointerv=GLee_Lazy_glGetVertexAttribPointerv;
#endif
#ifndef GLEE_C_DEFINED_glIsProgram
#define GLEE_C_DEFINED_glIsProgram
  GLboolean __stdcall GLee_Lazy_glIsProgram(GLuint program)  {if (GLeeInit()) return glIsProgram(program); return (GLboolean)0;}
  GLEEPFNGLISPROGRAMPROC GLeeFuncPtr_glIsProgram=GLee_Lazy_glIsProgram;
#endif
#ifndef GLEE_C_DEFINED_glIsShader
#define GLEE_C_DEFINED_glIsShader
  GLboolean __stdcall GLee_Lazy_glIsShader(GLuint shader)  {if (GLeeInit()) return glIsShader(shader); return (GLboolean)0;}
  GLEEPFNGLISSHADERPROC GLeeFuncPtr_glIsShader=GLee_Lazy_glIsShader;
#endif
#ifndef GLEE_C_DEFINED_glLinkProgram
#define GLEE_C_DEFINED_glLinkProgram
  void __stdcall GLee_Lazy_glLinkProgram(GLuint program)  {if (GLeeInit()) glLinkProgram(program);}
  GLEEPFNGLLINKPROGRAMPROC GLeeFuncPtr_glLinkProgram=GLee_Lazy_glLinkProgram;
#endif
#ifndef GLEE_C_DEFINED_glShaderSource
#define GLEE_C_DEFINED_glShaderSource
  void __stdcall GLee_Lazy_glShaderSource(GLuint shader, GLsizei count, const GLchar* * string, const GLint * length)  {if (GLeeInit()) glShaderSource(shader, count, string, length);}
  GLEEPFNGLSHADERSOURCEPROC GLeeFuncPtr_glShaderSource=GLee_Lazy_glShaderSource;
#endif
#ifndef GLEE_C_DEFINED_glUseProgram
#define GLEE_C_DEFINED_glUseProgram
  void __stdcall GLee_Lazy_glUseProgram(GLuint program)  {if (GLeeInit()) glUseProgram(program);}
  GLEEPFNGLUSEPROGRAMPROC GLeeFuncPtr_glUseProgram=GLee_Lazy_glUseProgram;
#endif
#ifndef GLEE_C_DEFINED_glUniform1f
#define GLEE_C_DEFINED_glUniform1f
  void __stdcall GLee_Lazy_glUniform1f(GLint location, GLfloat v0)  {if (GLeeInit()) glUniform1f(location, v0);}
  GLEEPFNGLUNIFORM1FPROC GLeeFuncPtr_glUniform1f=GLee_Lazy_glUniform1f;
#endif
#ifndef GLEE_C_DEFINED_glUniform2f
#define GLEE_C_DEFINED_glUniform2f
  void __stdcall GLee_Lazy_glUniform2f(GLint location, GLfloat v0, GLfloat v1)  {if (GLeeInit()) glUniform2f(location, v0, v1);}
  GLEEPFNGLUNIFORM2FPROC GLeeFuncPtr_glUniform2f=GLee_Lazy_glUniform2f;
#endif
#ifndef GLEE_C_DEFINED_glUniform3f
#define GLEE_C_DEFINED_glUniform3f
  void __stdcall GLee_Lazy_glUniform3f(GLint location, GLfloat v0, GLfloat v1, GLfloat v2)  {if (GLeeInit()) glUniform3f(location, v0, v1, v2);}
  GLEEPFNGLUNIFORM3FPROC GLeeFuncPtr_glUniform3f=GLee_Lazy_glUniform3f;
#endif
#ifndef GLEE_C_DEFINED_glUniform4f
#define GLEE_C_DEFINED_glUniform4f
  void __stdcall GLee_Lazy_glUniform4f(GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3)  {if (GLeeInit()) glUniform4f(location, v0, v1, v2, v3);}
  GLEEPFNGLUNIFORM4FPROC GLeeFuncPtr_glUniform4f=GLee_Lazy_glUniform4f;
#endif
#ifndef GLEE_C_DEFINED_glUniform1i
#define GLEE_C_DEFINED_glUniform1i
  void __stdcall GLee_Lazy_glUniform1i(GLint location, GLint v0)  {if (GLeeInit()) glUniform1i(location, v0);}
  GLEEPFNGLUNIFORM1IPROC GLeeFuncPtr_glUniform1i=GLee_Lazy_glUniform1i;
#endif
#ifndef GLEE_C_DEFINED_glUniform2i
#define GLEE_C_DEFINED_glUniform2i
  void __stdcall GLee_Lazy_glUniform2i(GLint location, GLint v0, GLint v1)  {if (GLeeInit()) glUniform2i(location, v0, v1);}
  GLEEPFNGLUNIFORM2IPROC GLeeFuncPtr_glUniform2i=GLee_Lazy_glUniform2i;
#endif
#ifndef GLEE_C_DEFINED_glUniform3i
#define GLEE_C_DEFINED_glUniform3i
  void __stdcall GLee_Lazy_glUniform3i(GLint location, GLint v0, GLint v1, GLint v2)  {if (GLeeInit()) glUniform3i(location, v0, v1, v2);}
  GLEEPFNGLUNIFORM3IPROC GLeeFuncPtr_glUniform3i=GLee_Lazy_glUniform3i;
#endif
#ifndef GLEE_C_DEFINED_glUniform4i
#define GLEE_C_DEFINED_glUniform4i
  void __stdcall GLee_Lazy_glUniform4i(GLint location, GLint v0, GLint v1, GLint v2, GLint v3)  {if (GLeeInit()) glUniform4i(location, v0, v1, v2, v3);}
  GLEEPFNGLUNIFORM4IPROC GLeeFuncPtr_glUniform4i=GLee_Lazy_glUniform4i;
#endif
#ifndef GLEE_C_DEFINED_glUniform1fv
#define GLEE_C_DEFINED_glUniform1fv
  void __stdcall GLee_Lazy_glUniform1fv(GLint location, GLsizei count, const GLfloat * value)  {if (GLeeInit()) glUniform1fv(location, count, value);}
  GLEEPFNGLUNIFORM1FVPROC GLeeFuncPtr_glUniform1fv=GLee_Lazy_glUniform1fv;
#endif
#ifndef GLEE_C_DEFINED_glUniform2fv
#define GLEE_C_DEFINED_glUniform2fv
  void __stdcall GLee_Lazy_glUniform2fv(GLint location, GLsizei count, const GLfloat * value)  {if (GLeeInit()) glUniform2fv(location, count, value);}
  GLEEPFNGLUNIFORM2FVPROC GLeeFuncPtr_glUniform2fv=GLee_Lazy_glUniform2fv;
#endif
#ifndef GLEE_C_DEFINED_glUniform3fv
#define GLEE_C_DEFINED_glUniform3fv
  void __stdcall GLee_Lazy_glUniform3fv(GLint location, GLsizei count, const GLfloat * value)  {if (GLeeInit()) glUniform3fv(location, count, value);}
  GLEEPFNGLUNIFORM3FVPROC GLeeFuncPtr_glUniform3fv=GLee_Lazy_glUniform3fv;
#endif
#ifndef GLEE_C_DEFINED_glUniform4fv
#define GLEE_C_DEFINED_glUniform4fv
  void __stdcall GLee_Lazy_glUniform4fv(GLint location, GLsizei count, const GLfloat * value)  {if (GLeeInit()) glUniform4fv(location, count, value);}
  GLEEPFNGLUNIFORM4FVPROC GLeeFuncPtr_glUniform4fv=GLee_Lazy_glUniform4fv;
#endif
#ifndef GLEE_C_DEFINED_glUniform1iv
#define GLEE_C_DEFINED_glUniform1iv
  void __stdcall GLee_Lazy_glUniform1iv(GLint location, GLsizei count, const GLint * value)  {if (GLeeInit()) glUniform1iv(location, count, value);}
  GLEEPFNGLUNIFORM1IVPROC GLeeFuncPtr_glUniform1iv=GLee_Lazy_glUniform1iv;
#endif
#ifndef GLEE_C_DEFINED_glUniform2iv
#define GLEE_C_DEFINED_glUniform2iv
  void __stdcall GLee_Lazy_glUniform2iv(GLint location, GLsizei count, const GLint * value)  {if (GLeeInit()) glUniform2iv(location, count, value);}
  GLEEPFNGLUNIFORM2IVPROC GLeeFuncPtr_glUniform2iv=GLee_Lazy_glUniform2iv;
#endif
#ifndef GLEE_C_DEFINED_glUniform3iv
#define GLEE_C_DEFINED_glUniform3iv
  void __stdcall GLee_Lazy_glUniform3iv(GLint location, GLsizei count, const GLint * value)  {if (GLeeInit()) glUniform3iv(location, count, value);}
  GLEEPFNGLUNIFORM3IVPROC GLeeFuncPtr_glUniform3iv=GLee_Lazy_glUniform3iv;
#endif
#ifndef GLEE_C_DEFINED_glUniform4iv
#define GLEE_C_DEFINED_glUniform4iv
  void __stdcall GLee_Lazy_glUniform4iv(GLint location, GLsizei count, const GLint * value)  {if (GLeeInit()) glUniform4iv(location, count, value);}
  GLEEPFNGLUNIFORM4IVPROC GLeeFuncPtr_glUniform4iv=GLee_Lazy_glUniform4iv;
#endif
#ifndef GLEE_C_DEFINED_glUniformMatrix2fv
#define GLEE_C_DEFINED_glUniformMatrix2fv
  void __stdcall GLee_Lazy_glUniformMatrix2fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value)  {if (GLeeInit()) glUniformMatrix2fv(location, count, transpose, value);}
  GLEEPFNGLUNIFORMMATRIX2FVPROC GLeeFuncPtr_glUniformMatrix2fv=GLee_Lazy_glUniformMatrix2fv;
#endif
#ifndef GLEE_C_DEFINED_glUniformMatrix3fv
#define GLEE_C_DEFINED_glUniformMatrix3fv
  void __stdcall GLee_Lazy_glUniformMatrix3fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value)  {if (GLeeInit()) glUniformMatrix3fv(location, count, transpose, value);}
  GLEEPFNGLUNIFORMMATRIX3FVPROC GLeeFuncPtr_glUniformMatrix3fv=GLee_Lazy_glUniformMatrix3fv;
#endif
#ifndef GLEE_C_DEFINED_glUniformMatrix4fv
#define GLEE_C_DEFINED_glUniformMatrix4fv
  void __stdcall GLee_Lazy_glUniformMatrix4fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value)  {if (GLeeInit()) glUniformMatrix4fv(location, count, transpose, value);}
  GLEEPFNGLUNIFORMMATRIX4FVPROC GLeeFuncPtr_glUniformMatrix4fv=GLee_Lazy_glUniformMatrix4fv;
#endif
#ifndef GLEE_C_DEFINED_glValidateProgram
#define GLEE_C_DEFINED_glValidateProgram
  void __stdcall GLee_Lazy_glValidateProgram(GLuint program)  {if (GLeeInit()) glValidateProgram(program);}
  GLEEPFNGLVALIDATEPROGRAMPROC GLeeFuncPtr_glValidateProgram=GLee_Lazy_glValidateProgram;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib1d
#define GLEE_C_DEFINED_glVertexAttrib1d
  void __stdcall GLee_Lazy_glVertexAttrib1d(GLuint index, GLdouble x)  {if (GLeeInit()) glVertexAttrib1d(index, x);}
  GLEEPFNGLVERTEXATTRIB1DPROC GLeeFuncPtr_glVertexAttrib1d=GLee_Lazy_glVertexAttrib1d;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib1dv
#define GLEE_C_DEFINED_glVertexAttrib1dv
  void __stdcall GLee_Lazy_glVertexAttrib1dv(GLuint index, const GLdouble * v)  {if (GLeeInit()) glVertexAttrib1dv(index, v);}
  GLEEPFNGLVERTEXATTRIB1DVPROC GLeeFuncPtr_glVertexAttrib1dv=GLee_Lazy_glVertexAttrib1dv;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib1f
#define GLEE_C_DEFINED_glVertexAttrib1f
  void __stdcall GLee_Lazy_glVertexAttrib1f(GLuint index, GLfloat x)  {if (GLeeInit()) glVertexAttrib1f(index, x);}
  GLEEPFNGLVERTEXATTRIB1FPROC GLeeFuncPtr_glVertexAttrib1f=GLee_Lazy_glVertexAttrib1f;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib1fv
#define GLEE_C_DEFINED_glVertexAttrib1fv
  void __stdcall GLee_Lazy_glVertexAttrib1fv(GLuint index, const GLfloat * v)  {if (GLeeInit()) glVertexAttrib1fv(index, v);}
  GLEEPFNGLVERTEXATTRIB1FVPROC GLeeFuncPtr_glVertexAttrib1fv=GLee_Lazy_glVertexAttrib1fv;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib1s
#define GLEE_C_DEFINED_glVertexAttrib1s
  void __stdcall GLee_Lazy_glVertexAttrib1s(GLuint index, GLshort x)  {if (GLeeInit()) glVertexAttrib1s(index, x);}
  GLEEPFNGLVERTEXATTRIB1SPROC GLeeFuncPtr_glVertexAttrib1s=GLee_Lazy_glVertexAttrib1s;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib1sv
#define GLEE_C_DEFINED_glVertexAttrib1sv
  void __stdcall GLee_Lazy_glVertexAttrib1sv(GLuint index, const GLshort * v)  {if (GLeeInit()) glVertexAttrib1sv(index, v);}
  GLEEPFNGLVERTEXATTRIB1SVPROC GLeeFuncPtr_glVertexAttrib1sv=GLee_Lazy_glVertexAttrib1sv;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib2d
#define GLEE_C_DEFINED_glVertexAttrib2d
  void __stdcall GLee_Lazy_glVertexAttrib2d(GLuint index, GLdouble x, GLdouble y)  {if (GLeeInit()) glVertexAttrib2d(index, x, y);}
  GLEEPFNGLVERTEXATTRIB2DPROC GLeeFuncPtr_glVertexAttrib2d=GLee_Lazy_glVertexAttrib2d;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib2dv
#define GLEE_C_DEFINED_glVertexAttrib2dv
  void __stdcall GLee_Lazy_glVertexAttrib2dv(GLuint index, const GLdouble * v)  {if (GLeeInit()) glVertexAttrib2dv(index, v);}
  GLEEPFNGLVERTEXATTRIB2DVPROC GLeeFuncPtr_glVertexAttrib2dv=GLee_Lazy_glVertexAttrib2dv;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib2f
#define GLEE_C_DEFINED_glVertexAttrib2f
  void __stdcall GLee_Lazy_glVertexAttrib2f(GLuint index, GLfloat x, GLfloat y)  {if (GLeeInit()) glVertexAttrib2f(index, x, y);}
  GLEEPFNGLVERTEXATTRIB2FPROC GLeeFuncPtr_glVertexAttrib2f=GLee_Lazy_glVertexAttrib2f;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib2fv
#define GLEE_C_DEFINED_glVertexAttrib2fv
  void __stdcall GLee_Lazy_glVertexAttrib2fv(GLuint index, const GLfloat * v)  {if (GLeeInit()) glVertexAttrib2fv(index, v);}
  GLEEPFNGLVERTEXATTRIB2FVPROC GLeeFuncPtr_glVertexAttrib2fv=GLee_Lazy_glVertexAttrib2fv;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib2s
#define GLEE_C_DEFINED_glVertexAttrib2s
  void __stdcall GLee_Lazy_glVertexAttrib2s(GLuint index, GLshort x, GLshort y)  {if (GLeeInit()) glVertexAttrib2s(index, x, y);}
  GLEEPFNGLVERTEXATTRIB2SPROC GLeeFuncPtr_glVertexAttrib2s=GLee_Lazy_glVertexAttrib2s;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib2sv
#define GLEE_C_DEFINED_glVertexAttrib2sv
  void __stdcall GLee_Lazy_glVertexAttrib2sv(GLuint index, const GLshort * v)  {if (GLeeInit()) glVertexAttrib2sv(index, v);}
  GLEEPFNGLVERTEXATTRIB2SVPROC GLeeFuncPtr_glVertexAttrib2sv=GLee_Lazy_glVertexAttrib2sv;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib3d
#define GLEE_C_DEFINED_glVertexAttrib3d
  void __stdcall GLee_Lazy_glVertexAttrib3d(GLuint index, GLdouble x, GLdouble y, GLdouble z)  {if (GLeeInit()) glVertexAttrib3d(index, x, y, z);}
  GLEEPFNGLVERTEXATTRIB3DPROC GLeeFuncPtr_glVertexAttrib3d=GLee_Lazy_glVertexAttrib3d;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib3dv
#define GLEE_C_DEFINED_glVertexAttrib3dv
  void __stdcall GLee_Lazy_glVertexAttrib3dv(GLuint index, const GLdouble * v)  {if (GLeeInit()) glVertexAttrib3dv(index, v);}
  GLEEPFNGLVERTEXATTRIB3DVPROC GLeeFuncPtr_glVertexAttrib3dv=GLee_Lazy_glVertexAttrib3dv;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib3f
#define GLEE_C_DEFINED_glVertexAttrib3f
  void __stdcall GLee_Lazy_glVertexAttrib3f(GLuint index, GLfloat x, GLfloat y, GLfloat z)  {if (GLeeInit()) glVertexAttrib3f(index, x, y, z);}
  GLEEPFNGLVERTEXATTRIB3FPROC GLeeFuncPtr_glVertexAttrib3f=GLee_Lazy_glVertexAttrib3f;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib3fv
#define GLEE_C_DEFINED_glVertexAttrib3fv
  void __stdcall GLee_Lazy_glVertexAttrib3fv(GLuint index, const GLfloat * v)  {if (GLeeInit()) glVertexAttrib3fv(index, v);}
  GLEEPFNGLVERTEXATTRIB3FVPROC GLeeFuncPtr_glVertexAttrib3fv=GLee_Lazy_glVertexAttrib3fv;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib3s
#define GLEE_C_DEFINED_glVertexAttrib3s
  void __stdcall GLee_Lazy_glVertexAttrib3s(GLuint index, GLshort x, GLshort y, GLshort z)  {if (GLeeInit()) glVertexAttrib3s(index, x, y, z);}
  GLEEPFNGLVERTEXATTRIB3SPROC GLeeFuncPtr_glVertexAttrib3s=GLee_Lazy_glVertexAttrib3s;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib3sv
#define GLEE_C_DEFINED_glVertexAttrib3sv
  void __stdcall GLee_Lazy_glVertexAttrib3sv(GLuint index, const GLshort * v)  {if (GLeeInit()) glVertexAttrib3sv(index, v);}
  GLEEPFNGLVERTEXATTRIB3SVPROC GLeeFuncPtr_glVertexAttrib3sv=GLee_Lazy_glVertexAttrib3sv;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib4Nbv
#define GLEE_C_DEFINED_glVertexAttrib4Nbv
  void __stdcall GLee_Lazy_glVertexAttrib4Nbv(GLuint index, const GLbyte * v)  {if (GLeeInit()) glVertexAttrib4Nbv(index, v);}
  GLEEPFNGLVERTEXATTRIB4NBVPROC GLeeFuncPtr_glVertexAttrib4Nbv=GLee_Lazy_glVertexAttrib4Nbv;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib4Niv
#define GLEE_C_DEFINED_glVertexAttrib4Niv
  void __stdcall GLee_Lazy_glVertexAttrib4Niv(GLuint index, const GLint * v)  {if (GLeeInit()) glVertexAttrib4Niv(index, v);}
  GLEEPFNGLVERTEXATTRIB4NIVPROC GLeeFuncPtr_glVertexAttrib4Niv=GLee_Lazy_glVertexAttrib4Niv;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib4Nsv
#define GLEE_C_DEFINED_glVertexAttrib4Nsv
  void __stdcall GLee_Lazy_glVertexAttrib4Nsv(GLuint index, const GLshort * v)  {if (GLeeInit()) glVertexAttrib4Nsv(index, v);}
  GLEEPFNGLVERTEXATTRIB4NSVPROC GLeeFuncPtr_glVertexAttrib4Nsv=GLee_Lazy_glVertexAttrib4Nsv;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib4Nub
#define GLEE_C_DEFINED_glVertexAttrib4Nub
  void __stdcall GLee_Lazy_glVertexAttrib4Nub(GLuint index, GLubyte x, GLubyte y, GLubyte z, GLubyte w)  {if (GLeeInit()) glVertexAttrib4Nub(index, x, y, z, w);}
  GLEEPFNGLVERTEXATTRIB4NUBPROC GLeeFuncPtr_glVertexAttrib4Nub=GLee_Lazy_glVertexAttrib4Nub;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib4Nubv
#define GLEE_C_DEFINED_glVertexAttrib4Nubv
  void __stdcall GLee_Lazy_glVertexAttrib4Nubv(GLuint index, const GLubyte * v)  {if (GLeeInit()) glVertexAttrib4Nubv(index, v);}
  GLEEPFNGLVERTEXATTRIB4NUBVPROC GLeeFuncPtr_glVertexAttrib4Nubv=GLee_Lazy_glVertexAttrib4Nubv;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib4Nuiv
#define GLEE_C_DEFINED_glVertexAttrib4Nuiv
  void __stdcall GLee_Lazy_glVertexAttrib4Nuiv(GLuint index, const GLuint * v)  {if (GLeeInit()) glVertexAttrib4Nuiv(index, v);}
  GLEEPFNGLVERTEXATTRIB4NUIVPROC GLeeFuncPtr_glVertexAttrib4Nuiv=GLee_Lazy_glVertexAttrib4Nuiv;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib4Nusv
#define GLEE_C_DEFINED_glVertexAttrib4Nusv
  void __stdcall GLee_Lazy_glVertexAttrib4Nusv(GLuint index, const GLushort * v)  {if (GLeeInit()) glVertexAttrib4Nusv(index, v);}
  GLEEPFNGLVERTEXATTRIB4NUSVPROC GLeeFuncPtr_glVertexAttrib4Nusv=GLee_Lazy_glVertexAttrib4Nusv;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib4bv
#define GLEE_C_DEFINED_glVertexAttrib4bv
  void __stdcall GLee_Lazy_glVertexAttrib4bv(GLuint index, const GLbyte * v)  {if (GLeeInit()) glVertexAttrib4bv(index, v);}
  GLEEPFNGLVERTEXATTRIB4BVPROC GLeeFuncPtr_glVertexAttrib4bv=GLee_Lazy_glVertexAttrib4bv;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib4d
#define GLEE_C_DEFINED_glVertexAttrib4d
  void __stdcall GLee_Lazy_glVertexAttrib4d(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w)  {if (GLeeInit()) glVertexAttrib4d(index, x, y, z, w);}
  GLEEPFNGLVERTEXATTRIB4DPROC GLeeFuncPtr_glVertexAttrib4d=GLee_Lazy_glVertexAttrib4d;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib4dv
#define GLEE_C_DEFINED_glVertexAttrib4dv
  void __stdcall GLee_Lazy_glVertexAttrib4dv(GLuint index, const GLdouble * v)  {if (GLeeInit()) glVertexAttrib4dv(index, v);}
  GLEEPFNGLVERTEXATTRIB4DVPROC GLeeFuncPtr_glVertexAttrib4dv=GLee_Lazy_glVertexAttrib4dv;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib4f
#define GLEE_C_DEFINED_glVertexAttrib4f
  void __stdcall GLee_Lazy_glVertexAttrib4f(GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w)  {if (GLeeInit()) glVertexAttrib4f(index, x, y, z, w);}
  GLEEPFNGLVERTEXATTRIB4FPROC GLeeFuncPtr_glVertexAttrib4f=GLee_Lazy_glVertexAttrib4f;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib4fv
#define GLEE_C_DEFINED_glVertexAttrib4fv
  void __stdcall GLee_Lazy_glVertexAttrib4fv(GLuint index, const GLfloat * v)  {if (GLeeInit()) glVertexAttrib4fv(index, v);}
  GLEEPFNGLVERTEXATTRIB4FVPROC GLeeFuncPtr_glVertexAttrib4fv=GLee_Lazy_glVertexAttrib4fv;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib4iv
#define GLEE_C_DEFINED_glVertexAttrib4iv
  void __stdcall GLee_Lazy_glVertexAttrib4iv(GLuint index, const GLint * v)  {if (GLeeInit()) glVertexAttrib4iv(index, v);}
  GLEEPFNGLVERTEXATTRIB4IVPROC GLeeFuncPtr_glVertexAttrib4iv=GLee_Lazy_glVertexAttrib4iv;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib4s
#define GLEE_C_DEFINED_glVertexAttrib4s
  void __stdcall GLee_Lazy_glVertexAttrib4s(GLuint index, GLshort x, GLshort y, GLshort z, GLshort w)  {if (GLeeInit()) glVertexAttrib4s(index, x, y, z, w);}
  GLEEPFNGLVERTEXATTRIB4SPROC GLeeFuncPtr_glVertexAttrib4s=GLee_Lazy_glVertexAttrib4s;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib4sv
#define GLEE_C_DEFINED_glVertexAttrib4sv
  void __stdcall GLee_Lazy_glVertexAttrib4sv(GLuint index, const GLshort * v)  {if (GLeeInit()) glVertexAttrib4sv(index, v);}
  GLEEPFNGLVERTEXATTRIB4SVPROC GLeeFuncPtr_glVertexAttrib4sv=GLee_Lazy_glVertexAttrib4sv;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib4ubv
#define GLEE_C_DEFINED_glVertexAttrib4ubv
  void __stdcall GLee_Lazy_glVertexAttrib4ubv(GLuint index, const GLubyte * v)  {if (GLeeInit()) glVertexAttrib4ubv(index, v);}
  GLEEPFNGLVERTEXATTRIB4UBVPROC GLeeFuncPtr_glVertexAttrib4ubv=GLee_Lazy_glVertexAttrib4ubv;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib4uiv
#define GLEE_C_DEFINED_glVertexAttrib4uiv
  void __stdcall GLee_Lazy_glVertexAttrib4uiv(GLuint index, const GLuint * v)  {if (GLeeInit()) glVertexAttrib4uiv(index, v);}
  GLEEPFNGLVERTEXATTRIB4UIVPROC GLeeFuncPtr_glVertexAttrib4uiv=GLee_Lazy_glVertexAttrib4uiv;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib4usv
#define GLEE_C_DEFINED_glVertexAttrib4usv
  void __stdcall GLee_Lazy_glVertexAttrib4usv(GLuint index, const GLushort * v)  {if (GLeeInit()) glVertexAttrib4usv(index, v);}
  GLEEPFNGLVERTEXATTRIB4USVPROC GLeeFuncPtr_glVertexAttrib4usv=GLee_Lazy_glVertexAttrib4usv;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttribPointer
#define GLEE_C_DEFINED_glVertexAttribPointer
  void __stdcall GLee_Lazy_glVertexAttribPointer(GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, const GLvoid * pointer)  {if (GLeeInit()) glVertexAttribPointer(index, size, type, normalized, stride, pointer);}
  GLEEPFNGLVERTEXATTRIBPOINTERPROC GLeeFuncPtr_glVertexAttribPointer=GLee_Lazy_glVertexAttribPointer;
#endif
#endif 

/* GL_VERSION_2_1 */

#ifdef __GLEE_GL_VERSION_2_1
#ifndef GLEE_C_DEFINED_glUniformMatrix2x3fv
#define GLEE_C_DEFINED_glUniformMatrix2x3fv
  void __stdcall GLee_Lazy_glUniformMatrix2x3fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value)  {if (GLeeInit()) glUniformMatrix2x3fv(location, count, transpose, value);}
  GLEEPFNGLUNIFORMMATRIX2X3FVPROC GLeeFuncPtr_glUniformMatrix2x3fv=GLee_Lazy_glUniformMatrix2x3fv;
#endif
#ifndef GLEE_C_DEFINED_glUniformMatrix3x2fv
#define GLEE_C_DEFINED_glUniformMatrix3x2fv
  void __stdcall GLee_Lazy_glUniformMatrix3x2fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value)  {if (GLeeInit()) glUniformMatrix3x2fv(location, count, transpose, value);}
  GLEEPFNGLUNIFORMMATRIX3X2FVPROC GLeeFuncPtr_glUniformMatrix3x2fv=GLee_Lazy_glUniformMatrix3x2fv;
#endif
#ifndef GLEE_C_DEFINED_glUniformMatrix2x4fv
#define GLEE_C_DEFINED_glUniformMatrix2x4fv
  void __stdcall GLee_Lazy_glUniformMatrix2x4fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value)  {if (GLeeInit()) glUniformMatrix2x4fv(location, count, transpose, value);}
  GLEEPFNGLUNIFORMMATRIX2X4FVPROC GLeeFuncPtr_glUniformMatrix2x4fv=GLee_Lazy_glUniformMatrix2x4fv;
#endif
#ifndef GLEE_C_DEFINED_glUniformMatrix4x2fv
#define GLEE_C_DEFINED_glUniformMatrix4x2fv
  void __stdcall GLee_Lazy_glUniformMatrix4x2fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value)  {if (GLeeInit()) glUniformMatrix4x2fv(location, count, transpose, value);}
  GLEEPFNGLUNIFORMMATRIX4X2FVPROC GLeeFuncPtr_glUniformMatrix4x2fv=GLee_Lazy_glUniformMatrix4x2fv;
#endif
#ifndef GLEE_C_DEFINED_glUniformMatrix3x4fv
#define GLEE_C_DEFINED_glUniformMatrix3x4fv
  void __stdcall GLee_Lazy_glUniformMatrix3x4fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value)  {if (GLeeInit()) glUniformMatrix3x4fv(location, count, transpose, value);}
  GLEEPFNGLUNIFORMMATRIX3X4FVPROC GLeeFuncPtr_glUniformMatrix3x4fv=GLee_Lazy_glUniformMatrix3x4fv;
#endif
#ifndef GLEE_C_DEFINED_glUniformMatrix4x3fv
#define GLEE_C_DEFINED_glUniformMatrix4x3fv
  void __stdcall GLee_Lazy_glUniformMatrix4x3fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value)  {if (GLeeInit()) glUniformMatrix4x3fv(location, count, transpose, value);}
  GLEEPFNGLUNIFORMMATRIX4X3FVPROC GLeeFuncPtr_glUniformMatrix4x3fv=GLee_Lazy_glUniformMatrix4x3fv;
#endif
#endif 

/* GL_VERSION_3_0 */

#ifdef __GLEE_GL_VERSION_3_0
#ifndef GLEE_C_DEFINED_glColorMaski
#define GLEE_C_DEFINED_glColorMaski
  void __stdcall GLee_Lazy_glColorMaski(GLuint index, GLboolean r, GLboolean g, GLboolean b, GLboolean a)  {if (GLeeInit()) glColorMaski(index, r, g, b, a);}
  GLEEPFNGLCOLORMASKIPROC GLeeFuncPtr_glColorMaski=GLee_Lazy_glColorMaski;
#endif
#ifndef GLEE_C_DEFINED_glGetBooleani_v
#define GLEE_C_DEFINED_glGetBooleani_v
  void __stdcall GLee_Lazy_glGetBooleani_v(GLenum target, GLuint index, GLboolean * data)  {if (GLeeInit()) glGetBooleani_v(target, index, data);}
  GLEEPFNGLGETBOOLEANI_VPROC GLeeFuncPtr_glGetBooleani_v=GLee_Lazy_glGetBooleani_v;
#endif
#ifndef GLEE_C_DEFINED_glGetIntegeri_v
#define GLEE_C_DEFINED_glGetIntegeri_v
  void __stdcall GLee_Lazy_glGetIntegeri_v(GLenum target, GLuint index, GLint * data)  {if (GLeeInit()) glGetIntegeri_v(target, index, data);}
  GLEEPFNGLGETINTEGERI_VPROC GLeeFuncPtr_glGetIntegeri_v=GLee_Lazy_glGetIntegeri_v;
#endif
#ifndef GLEE_C_DEFINED_glEnablei
#define GLEE_C_DEFINED_glEnablei
  void __stdcall GLee_Lazy_glEnablei(GLenum target, GLuint index)  {if (GLeeInit()) glEnablei(target, index);}
  GLEEPFNGLENABLEIPROC GLeeFuncPtr_glEnablei=GLee_Lazy_glEnablei;
#endif
#ifndef GLEE_C_DEFINED_glDisablei
#define GLEE_C_DEFINED_glDisablei
  void __stdcall GLee_Lazy_glDisablei(GLenum target, GLuint index)  {if (GLeeInit()) glDisablei(target, index);}
  GLEEPFNGLDISABLEIPROC GLeeFuncPtr_glDisablei=GLee_Lazy_glDisablei;
#endif
#ifndef GLEE_C_DEFINED_glIsEnabledi
#define GLEE_C_DEFINED_glIsEnabledi
  GLboolean __stdcall GLee_Lazy_glIsEnabledi(GLenum target, GLuint index)  {if (GLeeInit()) return glIsEnabledi(target, index); return (GLboolean)0;}
  GLEEPFNGLISENABLEDIPROC GLeeFuncPtr_glIsEnabledi=GLee_Lazy_glIsEnabledi;
#endif
#ifndef GLEE_C_DEFINED_glBeginTransformFeedback
#define GLEE_C_DEFINED_glBeginTransformFeedback
  void __stdcall GLee_Lazy_glBeginTransformFeedback(GLenum primitiveMode)  {if (GLeeInit()) glBeginTransformFeedback(primitiveMode);}
  GLEEPFNGLBEGINTRANSFORMFEEDBACKPROC GLeeFuncPtr_glBeginTransformFeedback=GLee_Lazy_glBeginTransformFeedback;
#endif
#ifndef GLEE_C_DEFINED_glEndTransformFeedback
#define GLEE_C_DEFINED_glEndTransformFeedback
  void __stdcall GLee_Lazy_glEndTransformFeedback(void)  {if (GLeeInit()) glEndTransformFeedback();}
  GLEEPFNGLENDTRANSFORMFEEDBACKPROC GLeeFuncPtr_glEndTransformFeedback=GLee_Lazy_glEndTransformFeedback;
#endif
#ifndef GLEE_C_DEFINED_glBindBufferRange
#define GLEE_C_DEFINED_glBindBufferRange
  void __stdcall GLee_Lazy_glBindBufferRange(GLenum target, GLuint index, GLuint buffer, GLintptr offset, GLsizeiptr size)  {if (GLeeInit()) glBindBufferRange(target, index, buffer, offset, size);}
  GLEEPFNGLBINDBUFFERRANGEPROC GLeeFuncPtr_glBindBufferRange=GLee_Lazy_glBindBufferRange;
#endif
#ifndef GLEE_C_DEFINED_glBindBufferBase
#define GLEE_C_DEFINED_glBindBufferBase
  void __stdcall GLee_Lazy_glBindBufferBase(GLenum target, GLuint index, GLuint buffer)  {if (GLeeInit()) glBindBufferBase(target, index, buffer);}
  GLEEPFNGLBINDBUFFERBASEPROC GLeeFuncPtr_glBindBufferBase=GLee_Lazy_glBindBufferBase;
#endif
#ifndef GLEE_C_DEFINED_glTransformFeedbackVaryings
#define GLEE_C_DEFINED_glTransformFeedbackVaryings
  void __stdcall GLee_Lazy_glTransformFeedbackVaryings(GLuint program, GLsizei count, const GLint * locations, GLenum bufferMode)  {if (GLeeInit()) glTransformFeedbackVaryings(program, count, locations, bufferMode);}
  GLEEPFNGLTRANSFORMFEEDBACKVARYINGSPROC GLeeFuncPtr_glTransformFeedbackVaryings=GLee_Lazy_glTransformFeedbackVaryings;
#endif
#ifndef GLEE_C_DEFINED_glGetTransformFeedbackVarying
#define GLEE_C_DEFINED_glGetTransformFeedbackVarying
  void __stdcall GLee_Lazy_glGetTransformFeedbackVarying(GLuint program, GLuint index, GLint * location)  {if (GLeeInit()) glGetTransformFeedbackVarying(program, index, location);}
  GLEEPFNGLGETTRANSFORMFEEDBACKVARYINGPROC GLeeFuncPtr_glGetTransformFeedbackVarying=GLee_Lazy_glGetTransformFeedbackVarying;
#endif
#ifndef GLEE_C_DEFINED_glClampColor
#define GLEE_C_DEFINED_glClampColor
  void __stdcall GLee_Lazy_glClampColor(GLenum target, GLenum clamp)  {if (GLeeInit()) glClampColor(target, clamp);}
  GLEEPFNGLCLAMPCOLORPROC GLeeFuncPtr_glClampColor=GLee_Lazy_glClampColor;
#endif
#ifndef GLEE_C_DEFINED_glBeginConditionalRender
#define GLEE_C_DEFINED_glBeginConditionalRender
  void __stdcall GLee_Lazy_glBeginConditionalRender(GLuint id, GLenum mode)  {if (GLeeInit()) glBeginConditionalRender(id, mode);}
  GLEEPFNGLBEGINCONDITIONALRENDERPROC GLeeFuncPtr_glBeginConditionalRender=GLee_Lazy_glBeginConditionalRender;
#endif
#ifndef GLEE_C_DEFINED_glEndConditionalRender
#define GLEE_C_DEFINED_glEndConditionalRender
  void __stdcall GLee_Lazy_glEndConditionalRender(void)  {if (GLeeInit()) glEndConditionalRender();}
  GLEEPFNGLENDCONDITIONALRENDERPROC GLeeFuncPtr_glEndConditionalRender=GLee_Lazy_glEndConditionalRender;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttribI1i
#define GLEE_C_DEFINED_glVertexAttribI1i
  void __stdcall GLee_Lazy_glVertexAttribI1i(GLuint index, GLint x)  {if (GLeeInit()) glVertexAttribI1i(index, x);}
  GLEEPFNGLVERTEXATTRIBI1IPROC GLeeFuncPtr_glVertexAttribI1i=GLee_Lazy_glVertexAttribI1i;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttribI2i
#define GLEE_C_DEFINED_glVertexAttribI2i
  void __stdcall GLee_Lazy_glVertexAttribI2i(GLuint index, GLint x, GLint y)  {if (GLeeInit()) glVertexAttribI2i(index, x, y);}
  GLEEPFNGLVERTEXATTRIBI2IPROC GLeeFuncPtr_glVertexAttribI2i=GLee_Lazy_glVertexAttribI2i;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttribI3i
#define GLEE_C_DEFINED_glVertexAttribI3i
  void __stdcall GLee_Lazy_glVertexAttribI3i(GLuint index, GLint x, GLint y, GLint z)  {if (GLeeInit()) glVertexAttribI3i(index, x, y, z);}
  GLEEPFNGLVERTEXATTRIBI3IPROC GLeeFuncPtr_glVertexAttribI3i=GLee_Lazy_glVertexAttribI3i;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttribI4i
#define GLEE_C_DEFINED_glVertexAttribI4i
  void __stdcall GLee_Lazy_glVertexAttribI4i(GLuint index, GLint x, GLint y, GLint z, GLint w)  {if (GLeeInit()) glVertexAttribI4i(index, x, y, z, w);}
  GLEEPFNGLVERTEXATTRIBI4IPROC GLeeFuncPtr_glVertexAttribI4i=GLee_Lazy_glVertexAttribI4i;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttribI1ui
#define GLEE_C_DEFINED_glVertexAttribI1ui
  void __stdcall GLee_Lazy_glVertexAttribI1ui(GLuint index, GLuint x)  {if (GLeeInit()) glVertexAttribI1ui(index, x);}
  GLEEPFNGLVERTEXATTRIBI1UIPROC GLeeFuncPtr_glVertexAttribI1ui=GLee_Lazy_glVertexAttribI1ui;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttribI2ui
#define GLEE_C_DEFINED_glVertexAttribI2ui
  void __stdcall GLee_Lazy_glVertexAttribI2ui(GLuint index, GLuint x, GLuint y)  {if (GLeeInit()) glVertexAttribI2ui(index, x, y);}
  GLEEPFNGLVERTEXATTRIBI2UIPROC GLeeFuncPtr_glVertexAttribI2ui=GLee_Lazy_glVertexAttribI2ui;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttribI3ui
#define GLEE_C_DEFINED_glVertexAttribI3ui
  void __stdcall GLee_Lazy_glVertexAttribI3ui(GLuint index, GLuint x, GLuint y, GLuint z)  {if (GLeeInit()) glVertexAttribI3ui(index, x, y, z);}
  GLEEPFNGLVERTEXATTRIBI3UIPROC GLeeFuncPtr_glVertexAttribI3ui=GLee_Lazy_glVertexAttribI3ui;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttribI4ui
#define GLEE_C_DEFINED_glVertexAttribI4ui
  void __stdcall GLee_Lazy_glVertexAttribI4ui(GLuint index, GLuint x, GLuint y, GLuint z, GLuint w)  {if (GLeeInit()) glVertexAttribI4ui(index, x, y, z, w);}
  GLEEPFNGLVERTEXATTRIBI4UIPROC GLeeFuncPtr_glVertexAttribI4ui=GLee_Lazy_glVertexAttribI4ui;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttribI1iv
#define GLEE_C_DEFINED_glVertexAttribI1iv
  void __stdcall GLee_Lazy_glVertexAttribI1iv(GLuint index, const GLint * v)  {if (GLeeInit()) glVertexAttribI1iv(index, v);}
  GLEEPFNGLVERTEXATTRIBI1IVPROC GLeeFuncPtr_glVertexAttribI1iv=GLee_Lazy_glVertexAttribI1iv;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttribI2iv
#define GLEE_C_DEFINED_glVertexAttribI2iv
  void __stdcall GLee_Lazy_glVertexAttribI2iv(GLuint index, const GLint * v)  {if (GLeeInit()) glVertexAttribI2iv(index, v);}
  GLEEPFNGLVERTEXATTRIBI2IVPROC GLeeFuncPtr_glVertexAttribI2iv=GLee_Lazy_glVertexAttribI2iv;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttribI3iv
#define GLEE_C_DEFINED_glVertexAttribI3iv
  void __stdcall GLee_Lazy_glVertexAttribI3iv(GLuint index, const GLint * v)  {if (GLeeInit()) glVertexAttribI3iv(index, v);}
  GLEEPFNGLVERTEXATTRIBI3IVPROC GLeeFuncPtr_glVertexAttribI3iv=GLee_Lazy_glVertexAttribI3iv;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttribI4iv
#define GLEE_C_DEFINED_glVertexAttribI4iv
  void __stdcall GLee_Lazy_glVertexAttribI4iv(GLuint index, const GLint * v)  {if (GLeeInit()) glVertexAttribI4iv(index, v);}
  GLEEPFNGLVERTEXATTRIBI4IVPROC GLeeFuncPtr_glVertexAttribI4iv=GLee_Lazy_glVertexAttribI4iv;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttribI1uiv
#define GLEE_C_DEFINED_glVertexAttribI1uiv
  void __stdcall GLee_Lazy_glVertexAttribI1uiv(GLuint index, const GLuint * v)  {if (GLeeInit()) glVertexAttribI1uiv(index, v);}
  GLEEPFNGLVERTEXATTRIBI1UIVPROC GLeeFuncPtr_glVertexAttribI1uiv=GLee_Lazy_glVertexAttribI1uiv;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttribI2uiv
#define GLEE_C_DEFINED_glVertexAttribI2uiv
  void __stdcall GLee_Lazy_glVertexAttribI2uiv(GLuint index, const GLuint * v)  {if (GLeeInit()) glVertexAttribI2uiv(index, v);}
  GLEEPFNGLVERTEXATTRIBI2UIVPROC GLeeFuncPtr_glVertexAttribI2uiv=GLee_Lazy_glVertexAttribI2uiv;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttribI3uiv
#define GLEE_C_DEFINED_glVertexAttribI3uiv
  void __stdcall GLee_Lazy_glVertexAttribI3uiv(GLuint index, const GLuint * v)  {if (GLeeInit()) glVertexAttribI3uiv(index, v);}
  GLEEPFNGLVERTEXATTRIBI3UIVPROC GLeeFuncPtr_glVertexAttribI3uiv=GLee_Lazy_glVertexAttribI3uiv;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttribI4uiv
#define GLEE_C_DEFINED_glVertexAttribI4uiv
  void __stdcall GLee_Lazy_glVertexAttribI4uiv(GLuint index, const GLuint * v)  {if (GLeeInit()) glVertexAttribI4uiv(index, v);}
  GLEEPFNGLVERTEXATTRIBI4UIVPROC GLeeFuncPtr_glVertexAttribI4uiv=GLee_Lazy_glVertexAttribI4uiv;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttribI4bv
#define GLEE_C_DEFINED_glVertexAttribI4bv
  void __stdcall GLee_Lazy_glVertexAttribI4bv(GLuint index, const GLbyte * v)  {if (GLeeInit()) glVertexAttribI4bv(index, v);}
  GLEEPFNGLVERTEXATTRIBI4BVPROC GLeeFuncPtr_glVertexAttribI4bv=GLee_Lazy_glVertexAttribI4bv;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttribI4sv
#define GLEE_C_DEFINED_glVertexAttribI4sv
  void __stdcall GLee_Lazy_glVertexAttribI4sv(GLuint index, const GLshort * v)  {if (GLeeInit()) glVertexAttribI4sv(index, v);}
  GLEEPFNGLVERTEXATTRIBI4SVPROC GLeeFuncPtr_glVertexAttribI4sv=GLee_Lazy_glVertexAttribI4sv;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttribI4ubv
#define GLEE_C_DEFINED_glVertexAttribI4ubv
  void __stdcall GLee_Lazy_glVertexAttribI4ubv(GLuint index, const GLubyte * v)  {if (GLeeInit()) glVertexAttribI4ubv(index, v);}
  GLEEPFNGLVERTEXATTRIBI4UBVPROC GLeeFuncPtr_glVertexAttribI4ubv=GLee_Lazy_glVertexAttribI4ubv;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttribI4usv
#define GLEE_C_DEFINED_glVertexAttribI4usv
  void __stdcall GLee_Lazy_glVertexAttribI4usv(GLuint index, const GLushort * v)  {if (GLeeInit()) glVertexAttribI4usv(index, v);}
  GLEEPFNGLVERTEXATTRIBI4USVPROC GLeeFuncPtr_glVertexAttribI4usv=GLee_Lazy_glVertexAttribI4usv;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttribIPointer
#define GLEE_C_DEFINED_glVertexAttribIPointer
  void __stdcall GLee_Lazy_glVertexAttribIPointer(GLuint index, GLint size, GLenum type, GLsizei stride, const GLvoid * pointer)  {if (GLeeInit()) glVertexAttribIPointer(index, size, type, stride, pointer);}
  GLEEPFNGLVERTEXATTRIBIPOINTERPROC GLeeFuncPtr_glVertexAttribIPointer=GLee_Lazy_glVertexAttribIPointer;
#endif
#ifndef GLEE_C_DEFINED_glGetVertexAttribIiv
#define GLEE_C_DEFINED_glGetVertexAttribIiv
  void __stdcall GLee_Lazy_glGetVertexAttribIiv(GLuint index, GLenum pname, GLint * params)  {if (GLeeInit()) glGetVertexAttribIiv(index, pname, params);}
  GLEEPFNGLGETVERTEXATTRIBIIVPROC GLeeFuncPtr_glGetVertexAttribIiv=GLee_Lazy_glGetVertexAttribIiv;
#endif
#ifndef GLEE_C_DEFINED_glGetVertexAttribIuiv
#define GLEE_C_DEFINED_glGetVertexAttribIuiv
  void __stdcall GLee_Lazy_glGetVertexAttribIuiv(GLuint index, GLenum pname, GLuint * params)  {if (GLeeInit()) glGetVertexAttribIuiv(index, pname, params);}
  GLEEPFNGLGETVERTEXATTRIBIUIVPROC GLeeFuncPtr_glGetVertexAttribIuiv=GLee_Lazy_glGetVertexAttribIuiv;
#endif
#ifndef GLEE_C_DEFINED_glGetUniformuiv
#define GLEE_C_DEFINED_glGetUniformuiv
  void __stdcall GLee_Lazy_glGetUniformuiv(GLuint program, GLint location, GLuint * params)  {if (GLeeInit()) glGetUniformuiv(program, location, params);}
  GLEEPFNGLGETUNIFORMUIVPROC GLeeFuncPtr_glGetUniformuiv=GLee_Lazy_glGetUniformuiv;
#endif
#ifndef GLEE_C_DEFINED_glBindFragDataLocation
#define GLEE_C_DEFINED_glBindFragDataLocation
  void __stdcall GLee_Lazy_glBindFragDataLocation(GLuint program, GLuint color, const GLchar * name)  {if (GLeeInit()) glBindFragDataLocation(program, color, name);}
  GLEEPFNGLBINDFRAGDATALOCATIONPROC GLeeFuncPtr_glBindFragDataLocation=GLee_Lazy_glBindFragDataLocation;
#endif
#ifndef GLEE_C_DEFINED_glGetFragDataLocation
#define GLEE_C_DEFINED_glGetFragDataLocation
  GLint __stdcall GLee_Lazy_glGetFragDataLocation(GLuint program, const GLchar * name)  {if (GLeeInit()) return glGetFragDataLocation(program, name); return (GLint)0;}
  GLEEPFNGLGETFRAGDATALOCATIONPROC GLeeFuncPtr_glGetFragDataLocation=GLee_Lazy_glGetFragDataLocation;
#endif
#ifndef GLEE_C_DEFINED_glUniform1ui
#define GLEE_C_DEFINED_glUniform1ui
  void __stdcall GLee_Lazy_glUniform1ui(GLint location, GLuint v0)  {if (GLeeInit()) glUniform1ui(location, v0);}
  GLEEPFNGLUNIFORM1UIPROC GLeeFuncPtr_glUniform1ui=GLee_Lazy_glUniform1ui;
#endif
#ifndef GLEE_C_DEFINED_glUniform2ui
#define GLEE_C_DEFINED_glUniform2ui
  void __stdcall GLee_Lazy_glUniform2ui(GLint location, GLuint v0, GLuint v1)  {if (GLeeInit()) glUniform2ui(location, v0, v1);}
  GLEEPFNGLUNIFORM2UIPROC GLeeFuncPtr_glUniform2ui=GLee_Lazy_glUniform2ui;
#endif
#ifndef GLEE_C_DEFINED_glUniform3ui
#define GLEE_C_DEFINED_glUniform3ui
  void __stdcall GLee_Lazy_glUniform3ui(GLint location, GLuint v0, GLuint v1, GLuint v2)  {if (GLeeInit()) glUniform3ui(location, v0, v1, v2);}
  GLEEPFNGLUNIFORM3UIPROC GLeeFuncPtr_glUniform3ui=GLee_Lazy_glUniform3ui;
#endif
#ifndef GLEE_C_DEFINED_glUniform4ui
#define GLEE_C_DEFINED_glUniform4ui
  void __stdcall GLee_Lazy_glUniform4ui(GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3)  {if (GLeeInit()) glUniform4ui(location, v0, v1, v2, v3);}
  GLEEPFNGLUNIFORM4UIPROC GLeeFuncPtr_glUniform4ui=GLee_Lazy_glUniform4ui;
#endif
#ifndef GLEE_C_DEFINED_glUniform1uiv
#define GLEE_C_DEFINED_glUniform1uiv
  void __stdcall GLee_Lazy_glUniform1uiv(GLint location, GLsizei count, const GLuint * value)  {if (GLeeInit()) glUniform1uiv(location, count, value);}
  GLEEPFNGLUNIFORM1UIVPROC GLeeFuncPtr_glUniform1uiv=GLee_Lazy_glUniform1uiv;
#endif
#ifndef GLEE_C_DEFINED_glUniform2uiv
#define GLEE_C_DEFINED_glUniform2uiv
  void __stdcall GLee_Lazy_glUniform2uiv(GLint location, GLsizei count, const GLuint * value)  {if (GLeeInit()) glUniform2uiv(location, count, value);}
  GLEEPFNGLUNIFORM2UIVPROC GLeeFuncPtr_glUniform2uiv=GLee_Lazy_glUniform2uiv;
#endif
#ifndef GLEE_C_DEFINED_glUniform3uiv
#define GLEE_C_DEFINED_glUniform3uiv
  void __stdcall GLee_Lazy_glUniform3uiv(GLint location, GLsizei count, const GLuint * value)  {if (GLeeInit()) glUniform3uiv(location, count, value);}
  GLEEPFNGLUNIFORM3UIVPROC GLeeFuncPtr_glUniform3uiv=GLee_Lazy_glUniform3uiv;
#endif
#ifndef GLEE_C_DEFINED_glUniform4uiv
#define GLEE_C_DEFINED_glUniform4uiv
  void __stdcall GLee_Lazy_glUniform4uiv(GLint location, GLsizei count, const GLuint * value)  {if (GLeeInit()) glUniform4uiv(location, count, value);}
  GLEEPFNGLUNIFORM4UIVPROC GLeeFuncPtr_glUniform4uiv=GLee_Lazy_glUniform4uiv;
#endif
#ifndef GLEE_C_DEFINED_glTexParameterIiv
#define GLEE_C_DEFINED_glTexParameterIiv
  void __stdcall GLee_Lazy_glTexParameterIiv(GLenum target, GLenum pname, const GLint * params)  {if (GLeeInit()) glTexParameterIiv(target, pname, params);}
  GLEEPFNGLTEXPARAMETERIIVPROC GLeeFuncPtr_glTexParameterIiv=GLee_Lazy_glTexParameterIiv;
#endif
#ifndef GLEE_C_DEFINED_glTexParameterIuiv
#define GLEE_C_DEFINED_glTexParameterIuiv
  void __stdcall GLee_Lazy_glTexParameterIuiv(GLenum target, GLenum pname, const GLuint * params)  {if (GLeeInit()) glTexParameterIuiv(target, pname, params);}
  GLEEPFNGLTEXPARAMETERIUIVPROC GLeeFuncPtr_glTexParameterIuiv=GLee_Lazy_glTexParameterIuiv;
#endif
#ifndef GLEE_C_DEFINED_glGetTexParameterIiv
#define GLEE_C_DEFINED_glGetTexParameterIiv
  void __stdcall GLee_Lazy_glGetTexParameterIiv(GLenum target, GLenum pname, GLint * params)  {if (GLeeInit()) glGetTexParameterIiv(target, pname, params);}
  GLEEPFNGLGETTEXPARAMETERIIVPROC GLeeFuncPtr_glGetTexParameterIiv=GLee_Lazy_glGetTexParameterIiv;
#endif
#ifndef GLEE_C_DEFINED_glGetTexParameterIuiv
#define GLEE_C_DEFINED_glGetTexParameterIuiv
  void __stdcall GLee_Lazy_glGetTexParameterIuiv(GLenum target, GLenum pname, GLuint * params)  {if (GLeeInit()) glGetTexParameterIuiv(target, pname, params);}
  GLEEPFNGLGETTEXPARAMETERIUIVPROC GLeeFuncPtr_glGetTexParameterIuiv=GLee_Lazy_glGetTexParameterIuiv;
#endif
#ifndef GLEE_C_DEFINED_glClearBufferiv
#define GLEE_C_DEFINED_glClearBufferiv
  void __stdcall GLee_Lazy_glClearBufferiv(GLenum buffer, GLint drawbuffer, const GLint * value)  {if (GLeeInit()) glClearBufferiv(buffer, drawbuffer, value);}
  GLEEPFNGLCLEARBUFFERIVPROC GLeeFuncPtr_glClearBufferiv=GLee_Lazy_glClearBufferiv;
#endif
#ifndef GLEE_C_DEFINED_glClearBufferuiv
#define GLEE_C_DEFINED_glClearBufferuiv
  void __stdcall GLee_Lazy_glClearBufferuiv(GLenum buffer, GLint drawbuffer, const GLuint * value)  {if (GLeeInit()) glClearBufferuiv(buffer, drawbuffer, value);}
  GLEEPFNGLCLEARBUFFERUIVPROC GLeeFuncPtr_glClearBufferuiv=GLee_Lazy_glClearBufferuiv;
#endif
#ifndef GLEE_C_DEFINED_glClearBufferfv
#define GLEE_C_DEFINED_glClearBufferfv
  void __stdcall GLee_Lazy_glClearBufferfv(GLenum buffer, GLint drawbuffer, const GLfloat * value)  {if (GLeeInit()) glClearBufferfv(buffer, drawbuffer, value);}
  GLEEPFNGLCLEARBUFFERFVPROC GLeeFuncPtr_glClearBufferfv=GLee_Lazy_glClearBufferfv;
#endif
#ifndef GLEE_C_DEFINED_glClearBufferfi
#define GLEE_C_DEFINED_glClearBufferfi
  void __stdcall GLee_Lazy_glClearBufferfi(GLenum buffer, GLint drawbuffer, GLfloat depth, GLint stencil)  {if (GLeeInit()) glClearBufferfi(buffer, drawbuffer, depth, stencil);}
  GLEEPFNGLCLEARBUFFERFIPROC GLeeFuncPtr_glClearBufferfi=GLee_Lazy_glClearBufferfi;
#endif
#ifndef GLEE_C_DEFINED_glGetStringi
#define GLEE_C_DEFINED_glGetStringi
  const GLubyte * __stdcall GLee_Lazy_glGetStringi(GLenum name, GLuint index)  {if (GLeeInit()) return glGetStringi(name, index); return (const GLubyte *)0;}
  GLEEPFNGLGETSTRINGIPROC GLeeFuncPtr_glGetStringi=GLee_Lazy_glGetStringi;
#endif
#endif 

/* GL_ARB_multitexture */

#ifdef __GLEE_GL_ARB_multitexture
#ifndef GLEE_C_DEFINED_glActiveTextureARB
#define GLEE_C_DEFINED_glActiveTextureARB
  void __stdcall GLee_Lazy_glActiveTextureARB(GLenum texture)  {if (GLeeInit()) glActiveTextureARB(texture);}
  GLEEPFNGLACTIVETEXTUREARBPROC GLeeFuncPtr_glActiveTextureARB=GLee_Lazy_glActiveTextureARB;
#endif
#ifndef GLEE_C_DEFINED_glClientActiveTextureARB
#define GLEE_C_DEFINED_glClientActiveTextureARB
  void __stdcall GLee_Lazy_glClientActiveTextureARB(GLenum texture)  {if (GLeeInit()) glClientActiveTextureARB(texture);}
  GLEEPFNGLCLIENTACTIVETEXTUREARBPROC GLeeFuncPtr_glClientActiveTextureARB=GLee_Lazy_glClientActiveTextureARB;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord1dARB
#define GLEE_C_DEFINED_glMultiTexCoord1dARB
  void __stdcall GLee_Lazy_glMultiTexCoord1dARB(GLenum target, GLdouble s)  {if (GLeeInit()) glMultiTexCoord1dARB(target, s);}
  GLEEPFNGLMULTITEXCOORD1DARBPROC GLeeFuncPtr_glMultiTexCoord1dARB=GLee_Lazy_glMultiTexCoord1dARB;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord1dvARB
#define GLEE_C_DEFINED_glMultiTexCoord1dvARB
  void __stdcall GLee_Lazy_glMultiTexCoord1dvARB(GLenum target, const GLdouble * v)  {if (GLeeInit()) glMultiTexCoord1dvARB(target, v);}
  GLEEPFNGLMULTITEXCOORD1DVARBPROC GLeeFuncPtr_glMultiTexCoord1dvARB=GLee_Lazy_glMultiTexCoord1dvARB;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord1fARB
#define GLEE_C_DEFINED_glMultiTexCoord1fARB
  void __stdcall GLee_Lazy_glMultiTexCoord1fARB(GLenum target, GLfloat s)  {if (GLeeInit()) glMultiTexCoord1fARB(target, s);}
  GLEEPFNGLMULTITEXCOORD1FARBPROC GLeeFuncPtr_glMultiTexCoord1fARB=GLee_Lazy_glMultiTexCoord1fARB;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord1fvARB
#define GLEE_C_DEFINED_glMultiTexCoord1fvARB
  void __stdcall GLee_Lazy_glMultiTexCoord1fvARB(GLenum target, const GLfloat * v)  {if (GLeeInit()) glMultiTexCoord1fvARB(target, v);}
  GLEEPFNGLMULTITEXCOORD1FVARBPROC GLeeFuncPtr_glMultiTexCoord1fvARB=GLee_Lazy_glMultiTexCoord1fvARB;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord1iARB
#define GLEE_C_DEFINED_glMultiTexCoord1iARB
  void __stdcall GLee_Lazy_glMultiTexCoord1iARB(GLenum target, GLint s)  {if (GLeeInit()) glMultiTexCoord1iARB(target, s);}
  GLEEPFNGLMULTITEXCOORD1IARBPROC GLeeFuncPtr_glMultiTexCoord1iARB=GLee_Lazy_glMultiTexCoord1iARB;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord1ivARB
#define GLEE_C_DEFINED_glMultiTexCoord1ivARB
  void __stdcall GLee_Lazy_glMultiTexCoord1ivARB(GLenum target, const GLint * v)  {if (GLeeInit()) glMultiTexCoord1ivARB(target, v);}
  GLEEPFNGLMULTITEXCOORD1IVARBPROC GLeeFuncPtr_glMultiTexCoord1ivARB=GLee_Lazy_glMultiTexCoord1ivARB;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord1sARB
#define GLEE_C_DEFINED_glMultiTexCoord1sARB
  void __stdcall GLee_Lazy_glMultiTexCoord1sARB(GLenum target, GLshort s)  {if (GLeeInit()) glMultiTexCoord1sARB(target, s);}
  GLEEPFNGLMULTITEXCOORD1SARBPROC GLeeFuncPtr_glMultiTexCoord1sARB=GLee_Lazy_glMultiTexCoord1sARB;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord1svARB
#define GLEE_C_DEFINED_glMultiTexCoord1svARB
  void __stdcall GLee_Lazy_glMultiTexCoord1svARB(GLenum target, const GLshort * v)  {if (GLeeInit()) glMultiTexCoord1svARB(target, v);}
  GLEEPFNGLMULTITEXCOORD1SVARBPROC GLeeFuncPtr_glMultiTexCoord1svARB=GLee_Lazy_glMultiTexCoord1svARB;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord2dARB
#define GLEE_C_DEFINED_glMultiTexCoord2dARB
  void __stdcall GLee_Lazy_glMultiTexCoord2dARB(GLenum target, GLdouble s, GLdouble t)  {if (GLeeInit()) glMultiTexCoord2dARB(target, s, t);}
  GLEEPFNGLMULTITEXCOORD2DARBPROC GLeeFuncPtr_glMultiTexCoord2dARB=GLee_Lazy_glMultiTexCoord2dARB;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord2dvARB
#define GLEE_C_DEFINED_glMultiTexCoord2dvARB
  void __stdcall GLee_Lazy_glMultiTexCoord2dvARB(GLenum target, const GLdouble * v)  {if (GLeeInit()) glMultiTexCoord2dvARB(target, v);}
  GLEEPFNGLMULTITEXCOORD2DVARBPROC GLeeFuncPtr_glMultiTexCoord2dvARB=GLee_Lazy_glMultiTexCoord2dvARB;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord2fARB
#define GLEE_C_DEFINED_glMultiTexCoord2fARB
  void __stdcall GLee_Lazy_glMultiTexCoord2fARB(GLenum target, GLfloat s, GLfloat t)  {if (GLeeInit()) glMultiTexCoord2fARB(target, s, t);}
  GLEEPFNGLMULTITEXCOORD2FARBPROC GLeeFuncPtr_glMultiTexCoord2fARB=GLee_Lazy_glMultiTexCoord2fARB;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord2fvARB
#define GLEE_C_DEFINED_glMultiTexCoord2fvARB
  void __stdcall GLee_Lazy_glMultiTexCoord2fvARB(GLenum target, const GLfloat * v)  {if (GLeeInit()) glMultiTexCoord2fvARB(target, v);}
  GLEEPFNGLMULTITEXCOORD2FVARBPROC GLeeFuncPtr_glMultiTexCoord2fvARB=GLee_Lazy_glMultiTexCoord2fvARB;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord2iARB
#define GLEE_C_DEFINED_glMultiTexCoord2iARB
  void __stdcall GLee_Lazy_glMultiTexCoord2iARB(GLenum target, GLint s, GLint t)  {if (GLeeInit()) glMultiTexCoord2iARB(target, s, t);}
  GLEEPFNGLMULTITEXCOORD2IARBPROC GLeeFuncPtr_glMultiTexCoord2iARB=GLee_Lazy_glMultiTexCoord2iARB;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord2ivARB
#define GLEE_C_DEFINED_glMultiTexCoord2ivARB
  void __stdcall GLee_Lazy_glMultiTexCoord2ivARB(GLenum target, const GLint * v)  {if (GLeeInit()) glMultiTexCoord2ivARB(target, v);}
  GLEEPFNGLMULTITEXCOORD2IVARBPROC GLeeFuncPtr_glMultiTexCoord2ivARB=GLee_Lazy_glMultiTexCoord2ivARB;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord2sARB
#define GLEE_C_DEFINED_glMultiTexCoord2sARB
  void __stdcall GLee_Lazy_glMultiTexCoord2sARB(GLenum target, GLshort s, GLshort t)  {if (GLeeInit()) glMultiTexCoord2sARB(target, s, t);}
  GLEEPFNGLMULTITEXCOORD2SARBPROC GLeeFuncPtr_glMultiTexCoord2sARB=GLee_Lazy_glMultiTexCoord2sARB;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord2svARB
#define GLEE_C_DEFINED_glMultiTexCoord2svARB
  void __stdcall GLee_Lazy_glMultiTexCoord2svARB(GLenum target, const GLshort * v)  {if (GLeeInit()) glMultiTexCoord2svARB(target, v);}
  GLEEPFNGLMULTITEXCOORD2SVARBPROC GLeeFuncPtr_glMultiTexCoord2svARB=GLee_Lazy_glMultiTexCoord2svARB;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord3dARB
#define GLEE_C_DEFINED_glMultiTexCoord3dARB
  void __stdcall GLee_Lazy_glMultiTexCoord3dARB(GLenum target, GLdouble s, GLdouble t, GLdouble r)  {if (GLeeInit()) glMultiTexCoord3dARB(target, s, t, r);}
  GLEEPFNGLMULTITEXCOORD3DARBPROC GLeeFuncPtr_glMultiTexCoord3dARB=GLee_Lazy_glMultiTexCoord3dARB;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord3dvARB
#define GLEE_C_DEFINED_glMultiTexCoord3dvARB
  void __stdcall GLee_Lazy_glMultiTexCoord3dvARB(GLenum target, const GLdouble * v)  {if (GLeeInit()) glMultiTexCoord3dvARB(target, v);}
  GLEEPFNGLMULTITEXCOORD3DVARBPROC GLeeFuncPtr_glMultiTexCoord3dvARB=GLee_Lazy_glMultiTexCoord3dvARB;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord3fARB
#define GLEE_C_DEFINED_glMultiTexCoord3fARB
  void __stdcall GLee_Lazy_glMultiTexCoord3fARB(GLenum target, GLfloat s, GLfloat t, GLfloat r)  {if (GLeeInit()) glMultiTexCoord3fARB(target, s, t, r);}
  GLEEPFNGLMULTITEXCOORD3FARBPROC GLeeFuncPtr_glMultiTexCoord3fARB=GLee_Lazy_glMultiTexCoord3fARB;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord3fvARB
#define GLEE_C_DEFINED_glMultiTexCoord3fvARB
  void __stdcall GLee_Lazy_glMultiTexCoord3fvARB(GLenum target, const GLfloat * v)  {if (GLeeInit()) glMultiTexCoord3fvARB(target, v);}
  GLEEPFNGLMULTITEXCOORD3FVARBPROC GLeeFuncPtr_glMultiTexCoord3fvARB=GLee_Lazy_glMultiTexCoord3fvARB;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord3iARB
#define GLEE_C_DEFINED_glMultiTexCoord3iARB
  void __stdcall GLee_Lazy_glMultiTexCoord3iARB(GLenum target, GLint s, GLint t, GLint r)  {if (GLeeInit()) glMultiTexCoord3iARB(target, s, t, r);}
  GLEEPFNGLMULTITEXCOORD3IARBPROC GLeeFuncPtr_glMultiTexCoord3iARB=GLee_Lazy_glMultiTexCoord3iARB;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord3ivARB
#define GLEE_C_DEFINED_glMultiTexCoord3ivARB
  void __stdcall GLee_Lazy_glMultiTexCoord3ivARB(GLenum target, const GLint * v)  {if (GLeeInit()) glMultiTexCoord3ivARB(target, v);}
  GLEEPFNGLMULTITEXCOORD3IVARBPROC GLeeFuncPtr_glMultiTexCoord3ivARB=GLee_Lazy_glMultiTexCoord3ivARB;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord3sARB
#define GLEE_C_DEFINED_glMultiTexCoord3sARB
  void __stdcall GLee_Lazy_glMultiTexCoord3sARB(GLenum target, GLshort s, GLshort t, GLshort r)  {if (GLeeInit()) glMultiTexCoord3sARB(target, s, t, r);}
  GLEEPFNGLMULTITEXCOORD3SARBPROC GLeeFuncPtr_glMultiTexCoord3sARB=GLee_Lazy_glMultiTexCoord3sARB;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord3svARB
#define GLEE_C_DEFINED_glMultiTexCoord3svARB
  void __stdcall GLee_Lazy_glMultiTexCoord3svARB(GLenum target, const GLshort * v)  {if (GLeeInit()) glMultiTexCoord3svARB(target, v);}
  GLEEPFNGLMULTITEXCOORD3SVARBPROC GLeeFuncPtr_glMultiTexCoord3svARB=GLee_Lazy_glMultiTexCoord3svARB;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord4dARB
#define GLEE_C_DEFINED_glMultiTexCoord4dARB
  void __stdcall GLee_Lazy_glMultiTexCoord4dARB(GLenum target, GLdouble s, GLdouble t, GLdouble r, GLdouble q)  {if (GLeeInit()) glMultiTexCoord4dARB(target, s, t, r, q);}
  GLEEPFNGLMULTITEXCOORD4DARBPROC GLeeFuncPtr_glMultiTexCoord4dARB=GLee_Lazy_glMultiTexCoord4dARB;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord4dvARB
#define GLEE_C_DEFINED_glMultiTexCoord4dvARB
  void __stdcall GLee_Lazy_glMultiTexCoord4dvARB(GLenum target, const GLdouble * v)  {if (GLeeInit()) glMultiTexCoord4dvARB(target, v);}
  GLEEPFNGLMULTITEXCOORD4DVARBPROC GLeeFuncPtr_glMultiTexCoord4dvARB=GLee_Lazy_glMultiTexCoord4dvARB;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord4fARB
#define GLEE_C_DEFINED_glMultiTexCoord4fARB
  void __stdcall GLee_Lazy_glMultiTexCoord4fARB(GLenum target, GLfloat s, GLfloat t, GLfloat r, GLfloat q)  {if (GLeeInit()) glMultiTexCoord4fARB(target, s, t, r, q);}
  GLEEPFNGLMULTITEXCOORD4FARBPROC GLeeFuncPtr_glMultiTexCoord4fARB=GLee_Lazy_glMultiTexCoord4fARB;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord4fvARB
#define GLEE_C_DEFINED_glMultiTexCoord4fvARB
  void __stdcall GLee_Lazy_glMultiTexCoord4fvARB(GLenum target, const GLfloat * v)  {if (GLeeInit()) glMultiTexCoord4fvARB(target, v);}
  GLEEPFNGLMULTITEXCOORD4FVARBPROC GLeeFuncPtr_glMultiTexCoord4fvARB=GLee_Lazy_glMultiTexCoord4fvARB;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord4iARB
#define GLEE_C_DEFINED_glMultiTexCoord4iARB
  void __stdcall GLee_Lazy_glMultiTexCoord4iARB(GLenum target, GLint s, GLint t, GLint r, GLint q)  {if (GLeeInit()) glMultiTexCoord4iARB(target, s, t, r, q);}
  GLEEPFNGLMULTITEXCOORD4IARBPROC GLeeFuncPtr_glMultiTexCoord4iARB=GLee_Lazy_glMultiTexCoord4iARB;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord4ivARB
#define GLEE_C_DEFINED_glMultiTexCoord4ivARB
  void __stdcall GLee_Lazy_glMultiTexCoord4ivARB(GLenum target, const GLint * v)  {if (GLeeInit()) glMultiTexCoord4ivARB(target, v);}
  GLEEPFNGLMULTITEXCOORD4IVARBPROC GLeeFuncPtr_glMultiTexCoord4ivARB=GLee_Lazy_glMultiTexCoord4ivARB;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord4sARB
#define GLEE_C_DEFINED_glMultiTexCoord4sARB
  void __stdcall GLee_Lazy_glMultiTexCoord4sARB(GLenum target, GLshort s, GLshort t, GLshort r, GLshort q)  {if (GLeeInit()) glMultiTexCoord4sARB(target, s, t, r, q);}
  GLEEPFNGLMULTITEXCOORD4SARBPROC GLeeFuncPtr_glMultiTexCoord4sARB=GLee_Lazy_glMultiTexCoord4sARB;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord4svARB
#define GLEE_C_DEFINED_glMultiTexCoord4svARB
  void __stdcall GLee_Lazy_glMultiTexCoord4svARB(GLenum target, const GLshort * v)  {if (GLeeInit()) glMultiTexCoord4svARB(target, v);}
  GLEEPFNGLMULTITEXCOORD4SVARBPROC GLeeFuncPtr_glMultiTexCoord4svARB=GLee_Lazy_glMultiTexCoord4svARB;
#endif
#endif 

/* GL_ARB_transpose_matrix */

#ifdef __GLEE_GL_ARB_transpose_matrix
#ifndef GLEE_C_DEFINED_glLoadTransposeMatrixfARB
#define GLEE_C_DEFINED_glLoadTransposeMatrixfARB
  void __stdcall GLee_Lazy_glLoadTransposeMatrixfARB(const GLfloat * m)  {if (GLeeInit()) glLoadTransposeMatrixfARB(m);}
  GLEEPFNGLLOADTRANSPOSEMATRIXFARBPROC GLeeFuncPtr_glLoadTransposeMatrixfARB=GLee_Lazy_glLoadTransposeMatrixfARB;
#endif
#ifndef GLEE_C_DEFINED_glLoadTransposeMatrixdARB
#define GLEE_C_DEFINED_glLoadTransposeMatrixdARB
  void __stdcall GLee_Lazy_glLoadTransposeMatrixdARB(const GLdouble * m)  {if (GLeeInit()) glLoadTransposeMatrixdARB(m);}
  GLEEPFNGLLOADTRANSPOSEMATRIXDARBPROC GLeeFuncPtr_glLoadTransposeMatrixdARB=GLee_Lazy_glLoadTransposeMatrixdARB;
#endif
#ifndef GLEE_C_DEFINED_glMultTransposeMatrixfARB
#define GLEE_C_DEFINED_glMultTransposeMatrixfARB
  void __stdcall GLee_Lazy_glMultTransposeMatrixfARB(const GLfloat * m)  {if (GLeeInit()) glMultTransposeMatrixfARB(m);}
  GLEEPFNGLMULTTRANSPOSEMATRIXFARBPROC GLeeFuncPtr_glMultTransposeMatrixfARB=GLee_Lazy_glMultTransposeMatrixfARB;
#endif
#ifndef GLEE_C_DEFINED_glMultTransposeMatrixdARB
#define GLEE_C_DEFINED_glMultTransposeMatrixdARB
  void __stdcall GLee_Lazy_glMultTransposeMatrixdARB(const GLdouble * m)  {if (GLeeInit()) glMultTransposeMatrixdARB(m);}
  GLEEPFNGLMULTTRANSPOSEMATRIXDARBPROC GLeeFuncPtr_glMultTransposeMatrixdARB=GLee_Lazy_glMultTransposeMatrixdARB;
#endif
#endif 

/* GL_ARB_multisample */

#ifdef __GLEE_GL_ARB_multisample
#ifndef GLEE_C_DEFINED_glSampleCoverageARB
#define GLEE_C_DEFINED_glSampleCoverageARB
  void __stdcall GLee_Lazy_glSampleCoverageARB(GLclampf value, GLboolean invert)  {if (GLeeInit()) glSampleCoverageARB(value, invert);}
  GLEEPFNGLSAMPLECOVERAGEARBPROC GLeeFuncPtr_glSampleCoverageARB=GLee_Lazy_glSampleCoverageARB;
#endif
#endif 

/* GL_ARB_texture_env_add */

#ifdef __GLEE_GL_ARB_texture_env_add
#endif 

/* GL_ARB_texture_cube_map */

#ifdef __GLEE_GL_ARB_texture_cube_map
#endif 

/* GL_ARB_texture_compression */

#ifdef __GLEE_GL_ARB_texture_compression
#ifndef GLEE_C_DEFINED_glCompressedTexImage3DARB
#define GLEE_C_DEFINED_glCompressedTexImage3DARB
  void __stdcall GLee_Lazy_glCompressedTexImage3DARB(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const GLvoid * data)  {if (GLeeInit()) glCompressedTexImage3DARB(target, level, internalformat, width, height, depth, border, imageSize, data);}
  GLEEPFNGLCOMPRESSEDTEXIMAGE3DARBPROC GLeeFuncPtr_glCompressedTexImage3DARB=GLee_Lazy_glCompressedTexImage3DARB;
#endif
#ifndef GLEE_C_DEFINED_glCompressedTexImage2DARB
#define GLEE_C_DEFINED_glCompressedTexImage2DARB
  void __stdcall GLee_Lazy_glCompressedTexImage2DARB(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const GLvoid * data)  {if (GLeeInit()) glCompressedTexImage2DARB(target, level, internalformat, width, height, border, imageSize, data);}
  GLEEPFNGLCOMPRESSEDTEXIMAGE2DARBPROC GLeeFuncPtr_glCompressedTexImage2DARB=GLee_Lazy_glCompressedTexImage2DARB;
#endif
#ifndef GLEE_C_DEFINED_glCompressedTexImage1DARB
#define GLEE_C_DEFINED_glCompressedTexImage1DARB
  void __stdcall GLee_Lazy_glCompressedTexImage1DARB(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const GLvoid * data)  {if (GLeeInit()) glCompressedTexImage1DARB(target, level, internalformat, width, border, imageSize, data);}
  GLEEPFNGLCOMPRESSEDTEXIMAGE1DARBPROC GLeeFuncPtr_glCompressedTexImage1DARB=GLee_Lazy_glCompressedTexImage1DARB;
#endif
#ifndef GLEE_C_DEFINED_glCompressedTexSubImage3DARB
#define GLEE_C_DEFINED_glCompressedTexSubImage3DARB
  void __stdcall GLee_Lazy_glCompressedTexSubImage3DARB(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const GLvoid * data)  {if (GLeeInit()) glCompressedTexSubImage3DARB(target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data);}
  GLEEPFNGLCOMPRESSEDTEXSUBIMAGE3DARBPROC GLeeFuncPtr_glCompressedTexSubImage3DARB=GLee_Lazy_glCompressedTexSubImage3DARB;
#endif
#ifndef GLEE_C_DEFINED_glCompressedTexSubImage2DARB
#define GLEE_C_DEFINED_glCompressedTexSubImage2DARB
  void __stdcall GLee_Lazy_glCompressedTexSubImage2DARB(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const GLvoid * data)  {if (GLeeInit()) glCompressedTexSubImage2DARB(target, level, xoffset, yoffset, width, height, format, imageSize, data);}
  GLEEPFNGLCOMPRESSEDTEXSUBIMAGE2DARBPROC GLeeFuncPtr_glCompressedTexSubImage2DARB=GLee_Lazy_glCompressedTexSubImage2DARB;
#endif
#ifndef GLEE_C_DEFINED_glCompressedTexSubImage1DARB
#define GLEE_C_DEFINED_glCompressedTexSubImage1DARB
  void __stdcall GLee_Lazy_glCompressedTexSubImage1DARB(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const GLvoid * data)  {if (GLeeInit()) glCompressedTexSubImage1DARB(target, level, xoffset, width, format, imageSize, data);}
  GLEEPFNGLCOMPRESSEDTEXSUBIMAGE1DARBPROC GLeeFuncPtr_glCompressedTexSubImage1DARB=GLee_Lazy_glCompressedTexSubImage1DARB;
#endif
#ifndef GLEE_C_DEFINED_glGetCompressedTexImageARB
#define GLEE_C_DEFINED_glGetCompressedTexImageARB
  void __stdcall GLee_Lazy_glGetCompressedTexImageARB(GLenum target, GLint level, GLvoid * img)  {if (GLeeInit()) glGetCompressedTexImageARB(target, level, img);}
  GLEEPFNGLGETCOMPRESSEDTEXIMAGEARBPROC GLeeFuncPtr_glGetCompressedTexImageARB=GLee_Lazy_glGetCompressedTexImageARB;
#endif
#endif 

/* GL_ARB_texture_border_clamp */

#ifdef __GLEE_GL_ARB_texture_border_clamp
#endif 

/* GL_ARB_point_parameters */

#ifdef __GLEE_GL_ARB_point_parameters
#ifndef GLEE_C_DEFINED_glPointParameterfARB
#define GLEE_C_DEFINED_glPointParameterfARB
  void __stdcall GLee_Lazy_glPointParameterfARB(GLenum pname, GLfloat param)  {if (GLeeInit()) glPointParameterfARB(pname, param);}
  GLEEPFNGLPOINTPARAMETERFARBPROC GLeeFuncPtr_glPointParameterfARB=GLee_Lazy_glPointParameterfARB;
#endif
#ifndef GLEE_C_DEFINED_glPointParameterfvARB
#define GLEE_C_DEFINED_glPointParameterfvARB
  void __stdcall GLee_Lazy_glPointParameterfvARB(GLenum pname, const GLfloat * params)  {if (GLeeInit()) glPointParameterfvARB(pname, params);}
  GLEEPFNGLPOINTPARAMETERFVARBPROC GLeeFuncPtr_glPointParameterfvARB=GLee_Lazy_glPointParameterfvARB;
#endif
#endif 

/* GL_ARB_vertex_blend */

#ifdef __GLEE_GL_ARB_vertex_blend
#ifndef GLEE_C_DEFINED_glWeightbvARB
#define GLEE_C_DEFINED_glWeightbvARB
  void __stdcall GLee_Lazy_glWeightbvARB(GLint size, const GLbyte * weights)  {if (GLeeInit()) glWeightbvARB(size, weights);}
  GLEEPFNGLWEIGHTBVARBPROC GLeeFuncPtr_glWeightbvARB=GLee_Lazy_glWeightbvARB;
#endif
#ifndef GLEE_C_DEFINED_glWeightsvARB
#define GLEE_C_DEFINED_glWeightsvARB
  void __stdcall GLee_Lazy_glWeightsvARB(GLint size, const GLshort * weights)  {if (GLeeInit()) glWeightsvARB(size, weights);}
  GLEEPFNGLWEIGHTSVARBPROC GLeeFuncPtr_glWeightsvARB=GLee_Lazy_glWeightsvARB;
#endif
#ifndef GLEE_C_DEFINED_glWeightivARB
#define GLEE_C_DEFINED_glWeightivARB
  void __stdcall GLee_Lazy_glWeightivARB(GLint size, const GLint * weights)  {if (GLeeInit()) glWeightivARB(size, weights);}
  GLEEPFNGLWEIGHTIVARBPROC GLeeFuncPtr_glWeightivARB=GLee_Lazy_glWeightivARB;
#endif
#ifndef GLEE_C_DEFINED_glWeightfvARB
#define GLEE_C_DEFINED_glWeightfvARB
  void __stdcall GLee_Lazy_glWeightfvARB(GLint size, const GLfloat * weights)  {if (GLeeInit()) glWeightfvARB(size, weights);}
  GLEEPFNGLWEIGHTFVARBPROC GLeeFuncPtr_glWeightfvARB=GLee_Lazy_glWeightfvARB;
#endif
#ifndef GLEE_C_DEFINED_glWeightdvARB
#define GLEE_C_DEFINED_glWeightdvARB
  void __stdcall GLee_Lazy_glWeightdvARB(GLint size, const GLdouble * weights)  {if (GLeeInit()) glWeightdvARB(size, weights);}
  GLEEPFNGLWEIGHTDVARBPROC GLeeFuncPtr_glWeightdvARB=GLee_Lazy_glWeightdvARB;
#endif
#ifndef GLEE_C_DEFINED_glWeightubvARB
#define GLEE_C_DEFINED_glWeightubvARB
  void __stdcall GLee_Lazy_glWeightubvARB(GLint size, const GLubyte * weights)  {if (GLeeInit()) glWeightubvARB(size, weights);}
  GLEEPFNGLWEIGHTUBVARBPROC GLeeFuncPtr_glWeightubvARB=GLee_Lazy_glWeightubvARB;
#endif
#ifndef GLEE_C_DEFINED_glWeightusvARB
#define GLEE_C_DEFINED_glWeightusvARB
  void __stdcall GLee_Lazy_glWeightusvARB(GLint size, const GLushort * weights)  {if (GLeeInit()) glWeightusvARB(size, weights);}
  GLEEPFNGLWEIGHTUSVARBPROC GLeeFuncPtr_glWeightusvARB=GLee_Lazy_glWeightusvARB;
#endif
#ifndef GLEE_C_DEFINED_glWeightuivARB
#define GLEE_C_DEFINED_glWeightuivARB
  void __stdcall GLee_Lazy_glWeightuivARB(GLint size, const GLuint * weights)  {if (GLeeInit()) glWeightuivARB(size, weights);}
  GLEEPFNGLWEIGHTUIVARBPROC GLeeFuncPtr_glWeightuivARB=GLee_Lazy_glWeightuivARB;
#endif
#ifndef GLEE_C_DEFINED_glWeightPointerARB
#define GLEE_C_DEFINED_glWeightPointerARB
  void __stdcall GLee_Lazy_glWeightPointerARB(GLint size, GLenum type, GLsizei stride, const GLvoid * pointer)  {if (GLeeInit()) glWeightPointerARB(size, type, stride, pointer);}
  GLEEPFNGLWEIGHTPOINTERARBPROC GLeeFuncPtr_glWeightPointerARB=GLee_Lazy_glWeightPointerARB;
#endif
#ifndef GLEE_C_DEFINED_glVertexBlendARB
#define GLEE_C_DEFINED_glVertexBlendARB
  void __stdcall GLee_Lazy_glVertexBlendARB(GLint count)  {if (GLeeInit()) glVertexBlendARB(count);}
  GLEEPFNGLVERTEXBLENDARBPROC GLeeFuncPtr_glVertexBlendARB=GLee_Lazy_glVertexBlendARB;
#endif
#endif 

/* GL_ARB_matrix_palette */

#ifdef __GLEE_GL_ARB_matrix_palette
#ifndef GLEE_C_DEFINED_glCurrentPaletteMatrixARB
#define GLEE_C_DEFINED_glCurrentPaletteMatrixARB
  void __stdcall GLee_Lazy_glCurrentPaletteMatrixARB(GLint index)  {if (GLeeInit()) glCurrentPaletteMatrixARB(index);}
  GLEEPFNGLCURRENTPALETTEMATRIXARBPROC GLeeFuncPtr_glCurrentPaletteMatrixARB=GLee_Lazy_glCurrentPaletteMatrixARB;
#endif
#ifndef GLEE_C_DEFINED_glMatrixIndexubvARB
#define GLEE_C_DEFINED_glMatrixIndexubvARB
  void __stdcall GLee_Lazy_glMatrixIndexubvARB(GLint size, const GLubyte * indices)  {if (GLeeInit()) glMatrixIndexubvARB(size, indices);}
  GLEEPFNGLMATRIXINDEXUBVARBPROC GLeeFuncPtr_glMatrixIndexubvARB=GLee_Lazy_glMatrixIndexubvARB;
#endif
#ifndef GLEE_C_DEFINED_glMatrixIndexusvARB
#define GLEE_C_DEFINED_glMatrixIndexusvARB
  void __stdcall GLee_Lazy_glMatrixIndexusvARB(GLint size, const GLushort * indices)  {if (GLeeInit()) glMatrixIndexusvARB(size, indices);}
  GLEEPFNGLMATRIXINDEXUSVARBPROC GLeeFuncPtr_glMatrixIndexusvARB=GLee_Lazy_glMatrixIndexusvARB;
#endif
#ifndef GLEE_C_DEFINED_glMatrixIndexuivARB
#define GLEE_C_DEFINED_glMatrixIndexuivARB
  void __stdcall GLee_Lazy_glMatrixIndexuivARB(GLint size, const GLuint * indices)  {if (GLeeInit()) glMatrixIndexuivARB(size, indices);}
  GLEEPFNGLMATRIXINDEXUIVARBPROC GLeeFuncPtr_glMatrixIndexuivARB=GLee_Lazy_glMatrixIndexuivARB;
#endif
#ifndef GLEE_C_DEFINED_glMatrixIndexPointerARB
#define GLEE_C_DEFINED_glMatrixIndexPointerARB
  void __stdcall GLee_Lazy_glMatrixIndexPointerARB(GLint size, GLenum type, GLsizei stride, const GLvoid * pointer)  {if (GLeeInit()) glMatrixIndexPointerARB(size, type, stride, pointer);}
  GLEEPFNGLMATRIXINDEXPOINTERARBPROC GLeeFuncPtr_glMatrixIndexPointerARB=GLee_Lazy_glMatrixIndexPointerARB;
#endif
#endif 

/* GL_ARB_texture_env_combine */

#ifdef __GLEE_GL_ARB_texture_env_combine
#endif 

/* GL_ARB_texture_env_crossbar */

#ifdef __GLEE_GL_ARB_texture_env_crossbar
#endif 

/* GL_ARB_texture_env_dot3 */

#ifdef __GLEE_GL_ARB_texture_env_dot3
#endif 

/* GL_ARB_texture_mirrored_repeat */

#ifdef __GLEE_GL_ARB_texture_mirrored_repeat
#endif 

/* GL_ARB_depth_texture */

#ifdef __GLEE_GL_ARB_depth_texture
#endif 

/* GL_ARB_shadow */

#ifdef __GLEE_GL_ARB_shadow
#endif 

/* GL_ARB_shadow_ambient */

#ifdef __GLEE_GL_ARB_shadow_ambient
#endif 

/* GL_ARB_window_pos */

#ifdef __GLEE_GL_ARB_window_pos
#ifndef GLEE_C_DEFINED_glWindowPos2dARB
#define GLEE_C_DEFINED_glWindowPos2dARB
  void __stdcall GLee_Lazy_glWindowPos2dARB(GLdouble x, GLdouble y)  {if (GLeeInit()) glWindowPos2dARB(x, y);}
  GLEEPFNGLWINDOWPOS2DARBPROC GLeeFuncPtr_glWindowPos2dARB=GLee_Lazy_glWindowPos2dARB;
#endif
#ifndef GLEE_C_DEFINED_glWindowPos2dvARB
#define GLEE_C_DEFINED_glWindowPos2dvARB
  void __stdcall GLee_Lazy_glWindowPos2dvARB(const GLdouble * v)  {if (GLeeInit()) glWindowPos2dvARB(v);}
  GLEEPFNGLWINDOWPOS2DVARBPROC GLeeFuncPtr_glWindowPos2dvARB=GLee_Lazy_glWindowPos2dvARB;
#endif
#ifndef GLEE_C_DEFINED_glWindowPos2fARB
#define GLEE_C_DEFINED_glWindowPos2fARB
  void __stdcall GLee_Lazy_glWindowPos2fARB(GLfloat x, GLfloat y)  {if (GLeeInit()) glWindowPos2fARB(x, y);}
  GLEEPFNGLWINDOWPOS2FARBPROC GLeeFuncPtr_glWindowPos2fARB=GLee_Lazy_glWindowPos2fARB;
#endif
#ifndef GLEE_C_DEFINED_glWindowPos2fvARB
#define GLEE_C_DEFINED_glWindowPos2fvARB
  void __stdcall GLee_Lazy_glWindowPos2fvARB(const GLfloat * v)  {if (GLeeInit()) glWindowPos2fvARB(v);}
  GLEEPFNGLWINDOWPOS2FVARBPROC GLeeFuncPtr_glWindowPos2fvARB=GLee_Lazy_glWindowPos2fvARB;
#endif
#ifndef GLEE_C_DEFINED_glWindowPos2iARB
#define GLEE_C_DEFINED_glWindowPos2iARB
  void __stdcall GLee_Lazy_glWindowPos2iARB(GLint x, GLint y)  {if (GLeeInit()) glWindowPos2iARB(x, y);}
  GLEEPFNGLWINDOWPOS2IARBPROC GLeeFuncPtr_glWindowPos2iARB=GLee_Lazy_glWindowPos2iARB;
#endif
#ifndef GLEE_C_DEFINED_glWindowPos2ivARB
#define GLEE_C_DEFINED_glWindowPos2ivARB
  void __stdcall GLee_Lazy_glWindowPos2ivARB(const GLint * v)  {if (GLeeInit()) glWindowPos2ivARB(v);}
  GLEEPFNGLWINDOWPOS2IVARBPROC GLeeFuncPtr_glWindowPos2ivARB=GLee_Lazy_glWindowPos2ivARB;
#endif
#ifndef GLEE_C_DEFINED_glWindowPos2sARB
#define GLEE_C_DEFINED_glWindowPos2sARB
  void __stdcall GLee_Lazy_glWindowPos2sARB(GLshort x, GLshort y)  {if (GLeeInit()) glWindowPos2sARB(x, y);}
  GLEEPFNGLWINDOWPOS2SARBPROC GLeeFuncPtr_glWindowPos2sARB=GLee_Lazy_glWindowPos2sARB;
#endif
#ifndef GLEE_C_DEFINED_glWindowPos2svARB
#define GLEE_C_DEFINED_glWindowPos2svARB
  void __stdcall GLee_Lazy_glWindowPos2svARB(const GLshort * v)  {if (GLeeInit()) glWindowPos2svARB(v);}
  GLEEPFNGLWINDOWPOS2SVARBPROC GLeeFuncPtr_glWindowPos2svARB=GLee_Lazy_glWindowPos2svARB;
#endif
#ifndef GLEE_C_DEFINED_glWindowPos3dARB
#define GLEE_C_DEFINED_glWindowPos3dARB
  void __stdcall GLee_Lazy_glWindowPos3dARB(GLdouble x, GLdouble y, GLdouble z)  {if (GLeeInit()) glWindowPos3dARB(x, y, z);}
  GLEEPFNGLWINDOWPOS3DARBPROC GLeeFuncPtr_glWindowPos3dARB=GLee_Lazy_glWindowPos3dARB;
#endif
#ifndef GLEE_C_DEFINED_glWindowPos3dvARB
#define GLEE_C_DEFINED_glWindowPos3dvARB
  void __stdcall GLee_Lazy_glWindowPos3dvARB(const GLdouble * v)  {if (GLeeInit()) glWindowPos3dvARB(v);}
  GLEEPFNGLWINDOWPOS3DVARBPROC GLeeFuncPtr_glWindowPos3dvARB=GLee_Lazy_glWindowPos3dvARB;
#endif
#ifndef GLEE_C_DEFINED_glWindowPos3fARB
#define GLEE_C_DEFINED_glWindowPos3fARB
  void __stdcall GLee_Lazy_glWindowPos3fARB(GLfloat x, GLfloat y, GLfloat z)  {if (GLeeInit()) glWindowPos3fARB(x, y, z);}
  GLEEPFNGLWINDOWPOS3FARBPROC GLeeFuncPtr_glWindowPos3fARB=GLee_Lazy_glWindowPos3fARB;
#endif
#ifndef GLEE_C_DEFINED_glWindowPos3fvARB
#define GLEE_C_DEFINED_glWindowPos3fvARB
  void __stdcall GLee_Lazy_glWindowPos3fvARB(const GLfloat * v)  {if (GLeeInit()) glWindowPos3fvARB(v);}
  GLEEPFNGLWINDOWPOS3FVARBPROC GLeeFuncPtr_glWindowPos3fvARB=GLee_Lazy_glWindowPos3fvARB;
#endif
#ifndef GLEE_C_DEFINED_glWindowPos3iARB
#define GLEE_C_DEFINED_glWindowPos3iARB
  void __stdcall GLee_Lazy_glWindowPos3iARB(GLint x, GLint y, GLint z)  {if (GLeeInit()) glWindowPos3iARB(x, y, z);}
  GLEEPFNGLWINDOWPOS3IARBPROC GLeeFuncPtr_glWindowPos3iARB=GLee_Lazy_glWindowPos3iARB;
#endif
#ifndef GLEE_C_DEFINED_glWindowPos3ivARB
#define GLEE_C_DEFINED_glWindowPos3ivARB
  void __stdcall GLee_Lazy_glWindowPos3ivARB(const GLint * v)  {if (GLeeInit()) glWindowPos3ivARB(v);}
  GLEEPFNGLWINDOWPOS3IVARBPROC GLeeFuncPtr_glWindowPos3ivARB=GLee_Lazy_glWindowPos3ivARB;
#endif
#ifndef GLEE_C_DEFINED_glWindowPos3sARB
#define GLEE_C_DEFINED_glWindowPos3sARB
  void __stdcall GLee_Lazy_glWindowPos3sARB(GLshort x, GLshort y, GLshort z)  {if (GLeeInit()) glWindowPos3sARB(x, y, z);}
  GLEEPFNGLWINDOWPOS3SARBPROC GLeeFuncPtr_glWindowPos3sARB=GLee_Lazy_glWindowPos3sARB;
#endif
#ifndef GLEE_C_DEFINED_glWindowPos3svARB
#define GLEE_C_DEFINED_glWindowPos3svARB
  void __stdcall GLee_Lazy_glWindowPos3svARB(const GLshort * v)  {if (GLeeInit()) glWindowPos3svARB(v);}
  GLEEPFNGLWINDOWPOS3SVARBPROC GLeeFuncPtr_glWindowPos3svARB=GLee_Lazy_glWindowPos3svARB;
#endif
#endif 

/* GL_ARB_vertex_program */

#ifdef __GLEE_GL_ARB_vertex_program
#ifndef GLEE_C_DEFINED_glVertexAttrib1dARB
#define GLEE_C_DEFINED_glVertexAttrib1dARB
  void __stdcall GLee_Lazy_glVertexAttrib1dARB(GLuint index, GLdouble x)  {if (GLeeInit()) glVertexAttrib1dARB(index, x);}
  GLEEPFNGLVERTEXATTRIB1DARBPROC GLeeFuncPtr_glVertexAttrib1dARB=GLee_Lazy_glVertexAttrib1dARB;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib1dvARB
#define GLEE_C_DEFINED_glVertexAttrib1dvARB
  void __stdcall GLee_Lazy_glVertexAttrib1dvARB(GLuint index, const GLdouble * v)  {if (GLeeInit()) glVertexAttrib1dvARB(index, v);}
  GLEEPFNGLVERTEXATTRIB1DVARBPROC GLeeFuncPtr_glVertexAttrib1dvARB=GLee_Lazy_glVertexAttrib1dvARB;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib1fARB
#define GLEE_C_DEFINED_glVertexAttrib1fARB
  void __stdcall GLee_Lazy_glVertexAttrib1fARB(GLuint index, GLfloat x)  {if (GLeeInit()) glVertexAttrib1fARB(index, x);}
  GLEEPFNGLVERTEXATTRIB1FARBPROC GLeeFuncPtr_glVertexAttrib1fARB=GLee_Lazy_glVertexAttrib1fARB;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib1fvARB
#define GLEE_C_DEFINED_glVertexAttrib1fvARB
  void __stdcall GLee_Lazy_glVertexAttrib1fvARB(GLuint index, const GLfloat * v)  {if (GLeeInit()) glVertexAttrib1fvARB(index, v);}
  GLEEPFNGLVERTEXATTRIB1FVARBPROC GLeeFuncPtr_glVertexAttrib1fvARB=GLee_Lazy_glVertexAttrib1fvARB;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib1sARB
#define GLEE_C_DEFINED_glVertexAttrib1sARB
  void __stdcall GLee_Lazy_glVertexAttrib1sARB(GLuint index, GLshort x)  {if (GLeeInit()) glVertexAttrib1sARB(index, x);}
  GLEEPFNGLVERTEXATTRIB1SARBPROC GLeeFuncPtr_glVertexAttrib1sARB=GLee_Lazy_glVertexAttrib1sARB;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib1svARB
#define GLEE_C_DEFINED_glVertexAttrib1svARB
  void __stdcall GLee_Lazy_glVertexAttrib1svARB(GLuint index, const GLshort * v)  {if (GLeeInit()) glVertexAttrib1svARB(index, v);}
  GLEEPFNGLVERTEXATTRIB1SVARBPROC GLeeFuncPtr_glVertexAttrib1svARB=GLee_Lazy_glVertexAttrib1svARB;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib2dARB
#define GLEE_C_DEFINED_glVertexAttrib2dARB
  void __stdcall GLee_Lazy_glVertexAttrib2dARB(GLuint index, GLdouble x, GLdouble y)  {if (GLeeInit()) glVertexAttrib2dARB(index, x, y);}
  GLEEPFNGLVERTEXATTRIB2DARBPROC GLeeFuncPtr_glVertexAttrib2dARB=GLee_Lazy_glVertexAttrib2dARB;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib2dvARB
#define GLEE_C_DEFINED_glVertexAttrib2dvARB
  void __stdcall GLee_Lazy_glVertexAttrib2dvARB(GLuint index, const GLdouble * v)  {if (GLeeInit()) glVertexAttrib2dvARB(index, v);}
  GLEEPFNGLVERTEXATTRIB2DVARBPROC GLeeFuncPtr_glVertexAttrib2dvARB=GLee_Lazy_glVertexAttrib2dvARB;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib2fARB
#define GLEE_C_DEFINED_glVertexAttrib2fARB
  void __stdcall GLee_Lazy_glVertexAttrib2fARB(GLuint index, GLfloat x, GLfloat y)  {if (GLeeInit()) glVertexAttrib2fARB(index, x, y);}
  GLEEPFNGLVERTEXATTRIB2FARBPROC GLeeFuncPtr_glVertexAttrib2fARB=GLee_Lazy_glVertexAttrib2fARB;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib2fvARB
#define GLEE_C_DEFINED_glVertexAttrib2fvARB
  void __stdcall GLee_Lazy_glVertexAttrib2fvARB(GLuint index, const GLfloat * v)  {if (GLeeInit()) glVertexAttrib2fvARB(index, v);}
  GLEEPFNGLVERTEXATTRIB2FVARBPROC GLeeFuncPtr_glVertexAttrib2fvARB=GLee_Lazy_glVertexAttrib2fvARB;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib2sARB
#define GLEE_C_DEFINED_glVertexAttrib2sARB
  void __stdcall GLee_Lazy_glVertexAttrib2sARB(GLuint index, GLshort x, GLshort y)  {if (GLeeInit()) glVertexAttrib2sARB(index, x, y);}
  GLEEPFNGLVERTEXATTRIB2SARBPROC GLeeFuncPtr_glVertexAttrib2sARB=GLee_Lazy_glVertexAttrib2sARB;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib2svARB
#define GLEE_C_DEFINED_glVertexAttrib2svARB
  void __stdcall GLee_Lazy_glVertexAttrib2svARB(GLuint index, const GLshort * v)  {if (GLeeInit()) glVertexAttrib2svARB(index, v);}
  GLEEPFNGLVERTEXATTRIB2SVARBPROC GLeeFuncPtr_glVertexAttrib2svARB=GLee_Lazy_glVertexAttrib2svARB;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib3dARB
#define GLEE_C_DEFINED_glVertexAttrib3dARB
  void __stdcall GLee_Lazy_glVertexAttrib3dARB(GLuint index, GLdouble x, GLdouble y, GLdouble z)  {if (GLeeInit()) glVertexAttrib3dARB(index, x, y, z);}
  GLEEPFNGLVERTEXATTRIB3DARBPROC GLeeFuncPtr_glVertexAttrib3dARB=GLee_Lazy_glVertexAttrib3dARB;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib3dvARB
#define GLEE_C_DEFINED_glVertexAttrib3dvARB
  void __stdcall GLee_Lazy_glVertexAttrib3dvARB(GLuint index, const GLdouble * v)  {if (GLeeInit()) glVertexAttrib3dvARB(index, v);}
  GLEEPFNGLVERTEXATTRIB3DVARBPROC GLeeFuncPtr_glVertexAttrib3dvARB=GLee_Lazy_glVertexAttrib3dvARB;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib3fARB
#define GLEE_C_DEFINED_glVertexAttrib3fARB
  void __stdcall GLee_Lazy_glVertexAttrib3fARB(GLuint index, GLfloat x, GLfloat y, GLfloat z)  {if (GLeeInit()) glVertexAttrib3fARB(index, x, y, z);}
  GLEEPFNGLVERTEXATTRIB3FARBPROC GLeeFuncPtr_glVertexAttrib3fARB=GLee_Lazy_glVertexAttrib3fARB;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib3fvARB
#define GLEE_C_DEFINED_glVertexAttrib3fvARB
  void __stdcall GLee_Lazy_glVertexAttrib3fvARB(GLuint index, const GLfloat * v)  {if (GLeeInit()) glVertexAttrib3fvARB(index, v);}
  GLEEPFNGLVERTEXATTRIB3FVARBPROC GLeeFuncPtr_glVertexAttrib3fvARB=GLee_Lazy_glVertexAttrib3fvARB;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib3sARB
#define GLEE_C_DEFINED_glVertexAttrib3sARB
  void __stdcall GLee_Lazy_glVertexAttrib3sARB(GLuint index, GLshort x, GLshort y, GLshort z)  {if (GLeeInit()) glVertexAttrib3sARB(index, x, y, z);}
  GLEEPFNGLVERTEXATTRIB3SARBPROC GLeeFuncPtr_glVertexAttrib3sARB=GLee_Lazy_glVertexAttrib3sARB;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib3svARB
#define GLEE_C_DEFINED_glVertexAttrib3svARB
  void __stdcall GLee_Lazy_glVertexAttrib3svARB(GLuint index, const GLshort * v)  {if (GLeeInit()) glVertexAttrib3svARB(index, v);}
  GLEEPFNGLVERTEXATTRIB3SVARBPROC GLeeFuncPtr_glVertexAttrib3svARB=GLee_Lazy_glVertexAttrib3svARB;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib4NbvARB
#define GLEE_C_DEFINED_glVertexAttrib4NbvARB
  void __stdcall GLee_Lazy_glVertexAttrib4NbvARB(GLuint index, const GLbyte * v)  {if (GLeeInit()) glVertexAttrib4NbvARB(index, v);}
  GLEEPFNGLVERTEXATTRIB4NBVARBPROC GLeeFuncPtr_glVertexAttrib4NbvARB=GLee_Lazy_glVertexAttrib4NbvARB;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib4NivARB
#define GLEE_C_DEFINED_glVertexAttrib4NivARB
  void __stdcall GLee_Lazy_glVertexAttrib4NivARB(GLuint index, const GLint * v)  {if (GLeeInit()) glVertexAttrib4NivARB(index, v);}
  GLEEPFNGLVERTEXATTRIB4NIVARBPROC GLeeFuncPtr_glVertexAttrib4NivARB=GLee_Lazy_glVertexAttrib4NivARB;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib4NsvARB
#define GLEE_C_DEFINED_glVertexAttrib4NsvARB
  void __stdcall GLee_Lazy_glVertexAttrib4NsvARB(GLuint index, const GLshort * v)  {if (GLeeInit()) glVertexAttrib4NsvARB(index, v);}
  GLEEPFNGLVERTEXATTRIB4NSVARBPROC GLeeFuncPtr_glVertexAttrib4NsvARB=GLee_Lazy_glVertexAttrib4NsvARB;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib4NubARB
#define GLEE_C_DEFINED_glVertexAttrib4NubARB
  void __stdcall GLee_Lazy_glVertexAttrib4NubARB(GLuint index, GLubyte x, GLubyte y, GLubyte z, GLubyte w)  {if (GLeeInit()) glVertexAttrib4NubARB(index, x, y, z, w);}
  GLEEPFNGLVERTEXATTRIB4NUBARBPROC GLeeFuncPtr_glVertexAttrib4NubARB=GLee_Lazy_glVertexAttrib4NubARB;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib4NubvARB
#define GLEE_C_DEFINED_glVertexAttrib4NubvARB
  void __stdcall GLee_Lazy_glVertexAttrib4NubvARB(GLuint index, const GLubyte * v)  {if (GLeeInit()) glVertexAttrib4NubvARB(index, v);}
  GLEEPFNGLVERTEXATTRIB4NUBVARBPROC GLeeFuncPtr_glVertexAttrib4NubvARB=GLee_Lazy_glVertexAttrib4NubvARB;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib4NuivARB
#define GLEE_C_DEFINED_glVertexAttrib4NuivARB
  void __stdcall GLee_Lazy_glVertexAttrib4NuivARB(GLuint index, const GLuint * v)  {if (GLeeInit()) glVertexAttrib4NuivARB(index, v);}
  GLEEPFNGLVERTEXATTRIB4NUIVARBPROC GLeeFuncPtr_glVertexAttrib4NuivARB=GLee_Lazy_glVertexAttrib4NuivARB;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib4NusvARB
#define GLEE_C_DEFINED_glVertexAttrib4NusvARB
  void __stdcall GLee_Lazy_glVertexAttrib4NusvARB(GLuint index, const GLushort * v)  {if (GLeeInit()) glVertexAttrib4NusvARB(index, v);}
  GLEEPFNGLVERTEXATTRIB4NUSVARBPROC GLeeFuncPtr_glVertexAttrib4NusvARB=GLee_Lazy_glVertexAttrib4NusvARB;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib4bvARB
#define GLEE_C_DEFINED_glVertexAttrib4bvARB
  void __stdcall GLee_Lazy_glVertexAttrib4bvARB(GLuint index, const GLbyte * v)  {if (GLeeInit()) glVertexAttrib4bvARB(index, v);}
  GLEEPFNGLVERTEXATTRIB4BVARBPROC GLeeFuncPtr_glVertexAttrib4bvARB=GLee_Lazy_glVertexAttrib4bvARB;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib4dARB
#define GLEE_C_DEFINED_glVertexAttrib4dARB
  void __stdcall GLee_Lazy_glVertexAttrib4dARB(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w)  {if (GLeeInit()) glVertexAttrib4dARB(index, x, y, z, w);}
  GLEEPFNGLVERTEXATTRIB4DARBPROC GLeeFuncPtr_glVertexAttrib4dARB=GLee_Lazy_glVertexAttrib4dARB;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib4dvARB
#define GLEE_C_DEFINED_glVertexAttrib4dvARB
  void __stdcall GLee_Lazy_glVertexAttrib4dvARB(GLuint index, const GLdouble * v)  {if (GLeeInit()) glVertexAttrib4dvARB(index, v);}
  GLEEPFNGLVERTEXATTRIB4DVARBPROC GLeeFuncPtr_glVertexAttrib4dvARB=GLee_Lazy_glVertexAttrib4dvARB;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib4fARB
#define GLEE_C_DEFINED_glVertexAttrib4fARB
  void __stdcall GLee_Lazy_glVertexAttrib4fARB(GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w)  {if (GLeeInit()) glVertexAttrib4fARB(index, x, y, z, w);}
  GLEEPFNGLVERTEXATTRIB4FARBPROC GLeeFuncPtr_glVertexAttrib4fARB=GLee_Lazy_glVertexAttrib4fARB;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib4fvARB
#define GLEE_C_DEFINED_glVertexAttrib4fvARB
  void __stdcall GLee_Lazy_glVertexAttrib4fvARB(GLuint index, const GLfloat * v)  {if (GLeeInit()) glVertexAttrib4fvARB(index, v);}
  GLEEPFNGLVERTEXATTRIB4FVARBPROC GLeeFuncPtr_glVertexAttrib4fvARB=GLee_Lazy_glVertexAttrib4fvARB;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib4ivARB
#define GLEE_C_DEFINED_glVertexAttrib4ivARB
  void __stdcall GLee_Lazy_glVertexAttrib4ivARB(GLuint index, const GLint * v)  {if (GLeeInit()) glVertexAttrib4ivARB(index, v);}
  GLEEPFNGLVERTEXATTRIB4IVARBPROC GLeeFuncPtr_glVertexAttrib4ivARB=GLee_Lazy_glVertexAttrib4ivARB;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib4sARB
#define GLEE_C_DEFINED_glVertexAttrib4sARB
  void __stdcall GLee_Lazy_glVertexAttrib4sARB(GLuint index, GLshort x, GLshort y, GLshort z, GLshort w)  {if (GLeeInit()) glVertexAttrib4sARB(index, x, y, z, w);}
  GLEEPFNGLVERTEXATTRIB4SARBPROC GLeeFuncPtr_glVertexAttrib4sARB=GLee_Lazy_glVertexAttrib4sARB;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib4svARB
#define GLEE_C_DEFINED_glVertexAttrib4svARB
  void __stdcall GLee_Lazy_glVertexAttrib4svARB(GLuint index, const GLshort * v)  {if (GLeeInit()) glVertexAttrib4svARB(index, v);}
  GLEEPFNGLVERTEXATTRIB4SVARBPROC GLeeFuncPtr_glVertexAttrib4svARB=GLee_Lazy_glVertexAttrib4svARB;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib4ubvARB
#define GLEE_C_DEFINED_glVertexAttrib4ubvARB
  void __stdcall GLee_Lazy_glVertexAttrib4ubvARB(GLuint index, const GLubyte * v)  {if (GLeeInit()) glVertexAttrib4ubvARB(index, v);}
  GLEEPFNGLVERTEXATTRIB4UBVARBPROC GLeeFuncPtr_glVertexAttrib4ubvARB=GLee_Lazy_glVertexAttrib4ubvARB;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib4uivARB
#define GLEE_C_DEFINED_glVertexAttrib4uivARB
  void __stdcall GLee_Lazy_glVertexAttrib4uivARB(GLuint index, const GLuint * v)  {if (GLeeInit()) glVertexAttrib4uivARB(index, v);}
  GLEEPFNGLVERTEXATTRIB4UIVARBPROC GLeeFuncPtr_glVertexAttrib4uivARB=GLee_Lazy_glVertexAttrib4uivARB;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib4usvARB
#define GLEE_C_DEFINED_glVertexAttrib4usvARB
  void __stdcall GLee_Lazy_glVertexAttrib4usvARB(GLuint index, const GLushort * v)  {if (GLeeInit()) glVertexAttrib4usvARB(index, v);}
  GLEEPFNGLVERTEXATTRIB4USVARBPROC GLeeFuncPtr_glVertexAttrib4usvARB=GLee_Lazy_glVertexAttrib4usvARB;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttribPointerARB
#define GLEE_C_DEFINED_glVertexAttribPointerARB
  void __stdcall GLee_Lazy_glVertexAttribPointerARB(GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, const GLvoid * pointer)  {if (GLeeInit()) glVertexAttribPointerARB(index, size, type, normalized, stride, pointer);}
  GLEEPFNGLVERTEXATTRIBPOINTERARBPROC GLeeFuncPtr_glVertexAttribPointerARB=GLee_Lazy_glVertexAttribPointerARB;
#endif
#ifndef GLEE_C_DEFINED_glEnableVertexAttribArrayARB
#define GLEE_C_DEFINED_glEnableVertexAttribArrayARB
  void __stdcall GLee_Lazy_glEnableVertexAttribArrayARB(GLuint index)  {if (GLeeInit()) glEnableVertexAttribArrayARB(index);}
  GLEEPFNGLENABLEVERTEXATTRIBARRAYARBPROC GLeeFuncPtr_glEnableVertexAttribArrayARB=GLee_Lazy_glEnableVertexAttribArrayARB;
#endif
#ifndef GLEE_C_DEFINED_glDisableVertexAttribArrayARB
#define GLEE_C_DEFINED_glDisableVertexAttribArrayARB
  void __stdcall GLee_Lazy_glDisableVertexAttribArrayARB(GLuint index)  {if (GLeeInit()) glDisableVertexAttribArrayARB(index);}
  GLEEPFNGLDISABLEVERTEXATTRIBARRAYARBPROC GLeeFuncPtr_glDisableVertexAttribArrayARB=GLee_Lazy_glDisableVertexAttribArrayARB;
#endif
#ifndef GLEE_C_DEFINED_glProgramStringARB
#define GLEE_C_DEFINED_glProgramStringARB
  void __stdcall GLee_Lazy_glProgramStringARB(GLenum target, GLenum format, GLsizei len, const GLvoid * string)  {if (GLeeInit()) glProgramStringARB(target, format, len, string);}
  GLEEPFNGLPROGRAMSTRINGARBPROC GLeeFuncPtr_glProgramStringARB=GLee_Lazy_glProgramStringARB;
#endif
#ifndef GLEE_C_DEFINED_glBindProgramARB
#define GLEE_C_DEFINED_glBindProgramARB
  void __stdcall GLee_Lazy_glBindProgramARB(GLenum target, GLuint program)  {if (GLeeInit()) glBindProgramARB(target, program);}
  GLEEPFNGLBINDPROGRAMARBPROC GLeeFuncPtr_glBindProgramARB=GLee_Lazy_glBindProgramARB;
#endif
#ifndef GLEE_C_DEFINED_glDeleteProgramsARB
#define GLEE_C_DEFINED_glDeleteProgramsARB
  void __stdcall GLee_Lazy_glDeleteProgramsARB(GLsizei n, const GLuint * programs)  {if (GLeeInit()) glDeleteProgramsARB(n, programs);}
  GLEEPFNGLDELETEPROGRAMSARBPROC GLeeFuncPtr_glDeleteProgramsARB=GLee_Lazy_glDeleteProgramsARB;
#endif
#ifndef GLEE_C_DEFINED_glGenProgramsARB
#define GLEE_C_DEFINED_glGenProgramsARB
  void __stdcall GLee_Lazy_glGenProgramsARB(GLsizei n, GLuint * programs)  {if (GLeeInit()) glGenProgramsARB(n, programs);}
  GLEEPFNGLGENPROGRAMSARBPROC GLeeFuncPtr_glGenProgramsARB=GLee_Lazy_glGenProgramsARB;
#endif
#ifndef GLEE_C_DEFINED_glProgramEnvParameter4dARB
#define GLEE_C_DEFINED_glProgramEnvParameter4dARB
  void __stdcall GLee_Lazy_glProgramEnvParameter4dARB(GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w)  {if (GLeeInit()) glProgramEnvParameter4dARB(target, index, x, y, z, w);}
  GLEEPFNGLPROGRAMENVPARAMETER4DARBPROC GLeeFuncPtr_glProgramEnvParameter4dARB=GLee_Lazy_glProgramEnvParameter4dARB;
#endif
#ifndef GLEE_C_DEFINED_glProgramEnvParameter4dvARB
#define GLEE_C_DEFINED_glProgramEnvParameter4dvARB
  void __stdcall GLee_Lazy_glProgramEnvParameter4dvARB(GLenum target, GLuint index, const GLdouble * params)  {if (GLeeInit()) glProgramEnvParameter4dvARB(target, index, params);}
  GLEEPFNGLPROGRAMENVPARAMETER4DVARBPROC GLeeFuncPtr_glProgramEnvParameter4dvARB=GLee_Lazy_glProgramEnvParameter4dvARB;
#endif
#ifndef GLEE_C_DEFINED_glProgramEnvParameter4fARB
#define GLEE_C_DEFINED_glProgramEnvParameter4fARB
  void __stdcall GLee_Lazy_glProgramEnvParameter4fARB(GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w)  {if (GLeeInit()) glProgramEnvParameter4fARB(target, index, x, y, z, w);}
  GLEEPFNGLPROGRAMENVPARAMETER4FARBPROC GLeeFuncPtr_glProgramEnvParameter4fARB=GLee_Lazy_glProgramEnvParameter4fARB;
#endif
#ifndef GLEE_C_DEFINED_glProgramEnvParameter4fvARB
#define GLEE_C_DEFINED_glProgramEnvParameter4fvARB
  void __stdcall GLee_Lazy_glProgramEnvParameter4fvARB(GLenum target, GLuint index, const GLfloat * params)  {if (GLeeInit()) glProgramEnvParameter4fvARB(target, index, params);}
  GLEEPFNGLPROGRAMENVPARAMETER4FVARBPROC GLeeFuncPtr_glProgramEnvParameter4fvARB=GLee_Lazy_glProgramEnvParameter4fvARB;
#endif
#ifndef GLEE_C_DEFINED_glProgramLocalParameter4dARB
#define GLEE_C_DEFINED_glProgramLocalParameter4dARB
  void __stdcall GLee_Lazy_glProgramLocalParameter4dARB(GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w)  {if (GLeeInit()) glProgramLocalParameter4dARB(target, index, x, y, z, w);}
  GLEEPFNGLPROGRAMLOCALPARAMETER4DARBPROC GLeeFuncPtr_glProgramLocalParameter4dARB=GLee_Lazy_glProgramLocalParameter4dARB;
#endif
#ifndef GLEE_C_DEFINED_glProgramLocalParameter4dvARB
#define GLEE_C_DEFINED_glProgramLocalParameter4dvARB
  void __stdcall GLee_Lazy_glProgramLocalParameter4dvARB(GLenum target, GLuint index, const GLdouble * params)  {if (GLeeInit()) glProgramLocalParameter4dvARB(target, index, params);}
  GLEEPFNGLPROGRAMLOCALPARAMETER4DVARBPROC GLeeFuncPtr_glProgramLocalParameter4dvARB=GLee_Lazy_glProgramLocalParameter4dvARB;
#endif
#ifndef GLEE_C_DEFINED_glProgramLocalParameter4fARB
#define GLEE_C_DEFINED_glProgramLocalParameter4fARB
  void __stdcall GLee_Lazy_glProgramLocalParameter4fARB(GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w)  {if (GLeeInit()) glProgramLocalParameter4fARB(target, index, x, y, z, w);}
  GLEEPFNGLPROGRAMLOCALPARAMETER4FARBPROC GLeeFuncPtr_glProgramLocalParameter4fARB=GLee_Lazy_glProgramLocalParameter4fARB;
#endif
#ifndef GLEE_C_DEFINED_glProgramLocalParameter4fvARB
#define GLEE_C_DEFINED_glProgramLocalParameter4fvARB
  void __stdcall GLee_Lazy_glProgramLocalParameter4fvARB(GLenum target, GLuint index, const GLfloat * params)  {if (GLeeInit()) glProgramLocalParameter4fvARB(target, index, params);}
  GLEEPFNGLPROGRAMLOCALPARAMETER4FVARBPROC GLeeFuncPtr_glProgramLocalParameter4fvARB=GLee_Lazy_glProgramLocalParameter4fvARB;
#endif
#ifndef GLEE_C_DEFINED_glGetProgramEnvParameterdvARB
#define GLEE_C_DEFINED_glGetProgramEnvParameterdvARB
  void __stdcall GLee_Lazy_glGetProgramEnvParameterdvARB(GLenum target, GLuint index, GLdouble * params)  {if (GLeeInit()) glGetProgramEnvParameterdvARB(target, index, params);}
  GLEEPFNGLGETPROGRAMENVPARAMETERDVARBPROC GLeeFuncPtr_glGetProgramEnvParameterdvARB=GLee_Lazy_glGetProgramEnvParameterdvARB;
#endif
#ifndef GLEE_C_DEFINED_glGetProgramEnvParameterfvARB
#define GLEE_C_DEFINED_glGetProgramEnvParameterfvARB
  void __stdcall GLee_Lazy_glGetProgramEnvParameterfvARB(GLenum target, GLuint index, GLfloat * params)  {if (GLeeInit()) glGetProgramEnvParameterfvARB(target, index, params);}
  GLEEPFNGLGETPROGRAMENVPARAMETERFVARBPROC GLeeFuncPtr_glGetProgramEnvParameterfvARB=GLee_Lazy_glGetProgramEnvParameterfvARB;
#endif
#ifndef GLEE_C_DEFINED_glGetProgramLocalParameterdvARB
#define GLEE_C_DEFINED_glGetProgramLocalParameterdvARB
  void __stdcall GLee_Lazy_glGetProgramLocalParameterdvARB(GLenum target, GLuint index, GLdouble * params)  {if (GLeeInit()) glGetProgramLocalParameterdvARB(target, index, params);}
  GLEEPFNGLGETPROGRAMLOCALPARAMETERDVARBPROC GLeeFuncPtr_glGetProgramLocalParameterdvARB=GLee_Lazy_glGetProgramLocalParameterdvARB;
#endif
#ifndef GLEE_C_DEFINED_glGetProgramLocalParameterfvARB
#define GLEE_C_DEFINED_glGetProgramLocalParameterfvARB
  void __stdcall GLee_Lazy_glGetProgramLocalParameterfvARB(GLenum target, GLuint index, GLfloat * params)  {if (GLeeInit()) glGetProgramLocalParameterfvARB(target, index, params);}
  GLEEPFNGLGETPROGRAMLOCALPARAMETERFVARBPROC GLeeFuncPtr_glGetProgramLocalParameterfvARB=GLee_Lazy_glGetProgramLocalParameterfvARB;
#endif
#ifndef GLEE_C_DEFINED_glGetProgramivARB
#define GLEE_C_DEFINED_glGetProgramivARB
  void __stdcall GLee_Lazy_glGetProgramivARB(GLenum target, GLenum pname, GLint * params)  {if (GLeeInit()) glGetProgramivARB(target, pname, params);}
  GLEEPFNGLGETPROGRAMIVARBPROC GLeeFuncPtr_glGetProgramivARB=GLee_Lazy_glGetProgramivARB;
#endif
#ifndef GLEE_C_DEFINED_glGetProgramStringARB
#define GLEE_C_DEFINED_glGetProgramStringARB
  void __stdcall GLee_Lazy_glGetProgramStringARB(GLenum target, GLenum pname, GLvoid * string)  {if (GLeeInit()) glGetProgramStringARB(target, pname, string);}
  GLEEPFNGLGETPROGRAMSTRINGARBPROC GLeeFuncPtr_glGetProgramStringARB=GLee_Lazy_glGetProgramStringARB;
#endif
#ifndef GLEE_C_DEFINED_glGetVertexAttribdvARB
#define GLEE_C_DEFINED_glGetVertexAttribdvARB
  void __stdcall GLee_Lazy_glGetVertexAttribdvARB(GLuint index, GLenum pname, GLdouble * params)  {if (GLeeInit()) glGetVertexAttribdvARB(index, pname, params);}
  GLEEPFNGLGETVERTEXATTRIBDVARBPROC GLeeFuncPtr_glGetVertexAttribdvARB=GLee_Lazy_glGetVertexAttribdvARB;
#endif
#ifndef GLEE_C_DEFINED_glGetVertexAttribfvARB
#define GLEE_C_DEFINED_glGetVertexAttribfvARB
  void __stdcall GLee_Lazy_glGetVertexAttribfvARB(GLuint index, GLenum pname, GLfloat * params)  {if (GLeeInit()) glGetVertexAttribfvARB(index, pname, params);}
  GLEEPFNGLGETVERTEXATTRIBFVARBPROC GLeeFuncPtr_glGetVertexAttribfvARB=GLee_Lazy_glGetVertexAttribfvARB;
#endif
#ifndef GLEE_C_DEFINED_glGetVertexAttribivARB
#define GLEE_C_DEFINED_glGetVertexAttribivARB
  void __stdcall GLee_Lazy_glGetVertexAttribivARB(GLuint index, GLenum pname, GLint * params)  {if (GLeeInit()) glGetVertexAttribivARB(index, pname, params);}
  GLEEPFNGLGETVERTEXATTRIBIVARBPROC GLeeFuncPtr_glGetVertexAttribivARB=GLee_Lazy_glGetVertexAttribivARB;
#endif
#ifndef GLEE_C_DEFINED_glGetVertexAttribPointervARB
#define GLEE_C_DEFINED_glGetVertexAttribPointervARB
  void __stdcall GLee_Lazy_glGetVertexAttribPointervARB(GLuint index, GLenum pname, GLvoid* * pointer)  {if (GLeeInit()) glGetVertexAttribPointervARB(index, pname, pointer);}
  GLEEPFNGLGETVERTEXATTRIBPOINTERVARBPROC GLeeFuncPtr_glGetVertexAttribPointervARB=GLee_Lazy_glGetVertexAttribPointervARB;
#endif
#ifndef GLEE_C_DEFINED_glIsProgramARB
#define GLEE_C_DEFINED_glIsProgramARB
  GLboolean __stdcall GLee_Lazy_glIsProgramARB(GLuint program)  {if (GLeeInit()) return glIsProgramARB(program); return (GLboolean)0;}
  GLEEPFNGLISPROGRAMARBPROC GLeeFuncPtr_glIsProgramARB=GLee_Lazy_glIsProgramARB;
#endif
#endif 

/* GL_ARB_fragment_program */

#ifdef __GLEE_GL_ARB_fragment_program
#endif 

/* GL_ARB_vertex_buffer_object */

#ifdef __GLEE_GL_ARB_vertex_buffer_object
#ifndef GLEE_C_DEFINED_glBindBufferARB
#define GLEE_C_DEFINED_glBindBufferARB
  void __stdcall GLee_Lazy_glBindBufferARB(GLenum target, GLuint buffer)  {if (GLeeInit()) glBindBufferARB(target, buffer);}
  GLEEPFNGLBINDBUFFERARBPROC GLeeFuncPtr_glBindBufferARB=GLee_Lazy_glBindBufferARB;
#endif
#ifndef GLEE_C_DEFINED_glDeleteBuffersARB
#define GLEE_C_DEFINED_glDeleteBuffersARB
  void __stdcall GLee_Lazy_glDeleteBuffersARB(GLsizei n, const GLuint * buffers)  {if (GLeeInit()) glDeleteBuffersARB(n, buffers);}
  GLEEPFNGLDELETEBUFFERSARBPROC GLeeFuncPtr_glDeleteBuffersARB=GLee_Lazy_glDeleteBuffersARB;
#endif
#ifndef GLEE_C_DEFINED_glGenBuffersARB
#define GLEE_C_DEFINED_glGenBuffersARB
  void __stdcall GLee_Lazy_glGenBuffersARB(GLsizei n, GLuint * buffers)  {if (GLeeInit()) glGenBuffersARB(n, buffers);}
  GLEEPFNGLGENBUFFERSARBPROC GLeeFuncPtr_glGenBuffersARB=GLee_Lazy_glGenBuffersARB;
#endif
#ifndef GLEE_C_DEFINED_glIsBufferARB
#define GLEE_C_DEFINED_glIsBufferARB
  GLboolean __stdcall GLee_Lazy_glIsBufferARB(GLuint buffer)  {if (GLeeInit()) return glIsBufferARB(buffer); return (GLboolean)0;}
  GLEEPFNGLISBUFFERARBPROC GLeeFuncPtr_glIsBufferARB=GLee_Lazy_glIsBufferARB;
#endif
#ifndef GLEE_C_DEFINED_glBufferDataARB
#define GLEE_C_DEFINED_glBufferDataARB
  void __stdcall GLee_Lazy_glBufferDataARB(GLenum target, GLsizeiptrARB size, const GLvoid * data, GLenum usage)  {if (GLeeInit()) glBufferDataARB(target, size, data, usage);}
  GLEEPFNGLBUFFERDATAARBPROC GLeeFuncPtr_glBufferDataARB=GLee_Lazy_glBufferDataARB;
#endif
#ifndef GLEE_C_DEFINED_glBufferSubDataARB
#define GLEE_C_DEFINED_glBufferSubDataARB
  void __stdcall GLee_Lazy_glBufferSubDataARB(GLenum target, GLintptrARB offset, GLsizeiptrARB size, const GLvoid * data)  {if (GLeeInit()) glBufferSubDataARB(target, offset, size, data);}
  GLEEPFNGLBUFFERSUBDATAARBPROC GLeeFuncPtr_glBufferSubDataARB=GLee_Lazy_glBufferSubDataARB;
#endif
#ifndef GLEE_C_DEFINED_glGetBufferSubDataARB
#define GLEE_C_DEFINED_glGetBufferSubDataARB
  void __stdcall GLee_Lazy_glGetBufferSubDataARB(GLenum target, GLintptrARB offset, GLsizeiptrARB size, GLvoid * data)  {if (GLeeInit()) glGetBufferSubDataARB(target, offset, size, data);}
  GLEEPFNGLGETBUFFERSUBDATAARBPROC GLeeFuncPtr_glGetBufferSubDataARB=GLee_Lazy_glGetBufferSubDataARB;
#endif
#ifndef GLEE_C_DEFINED_glMapBufferARB
#define GLEE_C_DEFINED_glMapBufferARB
  GLvoid* __stdcall GLee_Lazy_glMapBufferARB(GLenum target, GLenum access)  {if (GLeeInit()) return glMapBufferARB(target, access); return (GLvoid*)0;}
  GLEEPFNGLMAPBUFFERARBPROC GLeeFuncPtr_glMapBufferARB=GLee_Lazy_glMapBufferARB;
#endif
#ifndef GLEE_C_DEFINED_glUnmapBufferARB
#define GLEE_C_DEFINED_glUnmapBufferARB
  GLboolean __stdcall GLee_Lazy_glUnmapBufferARB(GLenum target)  {if (GLeeInit()) return glUnmapBufferARB(target); return (GLboolean)0;}
  GLEEPFNGLUNMAPBUFFERARBPROC GLeeFuncPtr_glUnmapBufferARB=GLee_Lazy_glUnmapBufferARB;
#endif
#ifndef GLEE_C_DEFINED_glGetBufferParameterivARB
#define GLEE_C_DEFINED_glGetBufferParameterivARB
  void __stdcall GLee_Lazy_glGetBufferParameterivARB(GLenum target, GLenum pname, GLint * params)  {if (GLeeInit()) glGetBufferParameterivARB(target, pname, params);}
  GLEEPFNGLGETBUFFERPARAMETERIVARBPROC GLeeFuncPtr_glGetBufferParameterivARB=GLee_Lazy_glGetBufferParameterivARB;
#endif
#ifndef GLEE_C_DEFINED_glGetBufferPointervARB
#define GLEE_C_DEFINED_glGetBufferPointervARB
  void __stdcall GLee_Lazy_glGetBufferPointervARB(GLenum target, GLenum pname, GLvoid* * params)  {if (GLeeInit()) glGetBufferPointervARB(target, pname, params);}
  GLEEPFNGLGETBUFFERPOINTERVARBPROC GLeeFuncPtr_glGetBufferPointervARB=GLee_Lazy_glGetBufferPointervARB;
#endif
#endif 

/* GL_ARB_occlusion_query */

#ifdef __GLEE_GL_ARB_occlusion_query
#ifndef GLEE_C_DEFINED_glGenQueriesARB
#define GLEE_C_DEFINED_glGenQueriesARB
  void __stdcall GLee_Lazy_glGenQueriesARB(GLsizei n, GLuint * ids)  {if (GLeeInit()) glGenQueriesARB(n, ids);}
  GLEEPFNGLGENQUERIESARBPROC GLeeFuncPtr_glGenQueriesARB=GLee_Lazy_glGenQueriesARB;
#endif
#ifndef GLEE_C_DEFINED_glDeleteQueriesARB
#define GLEE_C_DEFINED_glDeleteQueriesARB
  void __stdcall GLee_Lazy_glDeleteQueriesARB(GLsizei n, const GLuint * ids)  {if (GLeeInit()) glDeleteQueriesARB(n, ids);}
  GLEEPFNGLDELETEQUERIESARBPROC GLeeFuncPtr_glDeleteQueriesARB=GLee_Lazy_glDeleteQueriesARB;
#endif
#ifndef GLEE_C_DEFINED_glIsQueryARB
#define GLEE_C_DEFINED_glIsQueryARB
  GLboolean __stdcall GLee_Lazy_glIsQueryARB(GLuint id)  {if (GLeeInit()) return glIsQueryARB(id); return (GLboolean)0;}
  GLEEPFNGLISQUERYARBPROC GLeeFuncPtr_glIsQueryARB=GLee_Lazy_glIsQueryARB;
#endif
#ifndef GLEE_C_DEFINED_glBeginQueryARB
#define GLEE_C_DEFINED_glBeginQueryARB
  void __stdcall GLee_Lazy_glBeginQueryARB(GLenum target, GLuint id)  {if (GLeeInit()) glBeginQueryARB(target, id);}
  GLEEPFNGLBEGINQUERYARBPROC GLeeFuncPtr_glBeginQueryARB=GLee_Lazy_glBeginQueryARB;
#endif
#ifndef GLEE_C_DEFINED_glEndQueryARB
#define GLEE_C_DEFINED_glEndQueryARB
  void __stdcall GLee_Lazy_glEndQueryARB(GLenum target)  {if (GLeeInit()) glEndQueryARB(target);}
  GLEEPFNGLENDQUERYARBPROC GLeeFuncPtr_glEndQueryARB=GLee_Lazy_glEndQueryARB;
#endif
#ifndef GLEE_C_DEFINED_glGetQueryivARB
#define GLEE_C_DEFINED_glGetQueryivARB
  void __stdcall GLee_Lazy_glGetQueryivARB(GLenum target, GLenum pname, GLint * params)  {if (GLeeInit()) glGetQueryivARB(target, pname, params);}
  GLEEPFNGLGETQUERYIVARBPROC GLeeFuncPtr_glGetQueryivARB=GLee_Lazy_glGetQueryivARB;
#endif
#ifndef GLEE_C_DEFINED_glGetQueryObjectivARB
#define GLEE_C_DEFINED_glGetQueryObjectivARB
  void __stdcall GLee_Lazy_glGetQueryObjectivARB(GLuint id, GLenum pname, GLint * params)  {if (GLeeInit()) glGetQueryObjectivARB(id, pname, params);}
  GLEEPFNGLGETQUERYOBJECTIVARBPROC GLeeFuncPtr_glGetQueryObjectivARB=GLee_Lazy_glGetQueryObjectivARB;
#endif
#ifndef GLEE_C_DEFINED_glGetQueryObjectuivARB
#define GLEE_C_DEFINED_glGetQueryObjectuivARB
  void __stdcall GLee_Lazy_glGetQueryObjectuivARB(GLuint id, GLenum pname, GLuint * params)  {if (GLeeInit()) glGetQueryObjectuivARB(id, pname, params);}
  GLEEPFNGLGETQUERYOBJECTUIVARBPROC GLeeFuncPtr_glGetQueryObjectuivARB=GLee_Lazy_glGetQueryObjectuivARB;
#endif
#endif 

/* GL_ARB_shader_objects */

#ifdef __GLEE_GL_ARB_shader_objects
#ifndef GLEE_C_DEFINED_glDeleteObjectARB
#define GLEE_C_DEFINED_glDeleteObjectARB
  void __stdcall GLee_Lazy_glDeleteObjectARB(GLhandleARB obj)  {if (GLeeInit()) glDeleteObjectARB(obj);}
  GLEEPFNGLDELETEOBJECTARBPROC GLeeFuncPtr_glDeleteObjectARB=GLee_Lazy_glDeleteObjectARB;
#endif
#ifndef GLEE_C_DEFINED_glGetHandleARB
#define GLEE_C_DEFINED_glGetHandleARB
  GLhandleARB __stdcall GLee_Lazy_glGetHandleARB(GLenum pname)  {if (GLeeInit()) return glGetHandleARB(pname); return (GLhandleARB)0;}
  GLEEPFNGLGETHANDLEARBPROC GLeeFuncPtr_glGetHandleARB=GLee_Lazy_glGetHandleARB;
#endif
#ifndef GLEE_C_DEFINED_glDetachObjectARB
#define GLEE_C_DEFINED_glDetachObjectARB
  void __stdcall GLee_Lazy_glDetachObjectARB(GLhandleARB containerObj, GLhandleARB attachedObj)  {if (GLeeInit()) glDetachObjectARB(containerObj, attachedObj);}
  GLEEPFNGLDETACHOBJECTARBPROC GLeeFuncPtr_glDetachObjectARB=GLee_Lazy_glDetachObjectARB;
#endif
#ifndef GLEE_C_DEFINED_glCreateShaderObjectARB
#define GLEE_C_DEFINED_glCreateShaderObjectARB
  GLhandleARB __stdcall GLee_Lazy_glCreateShaderObjectARB(GLenum shaderType)  {if (GLeeInit()) return glCreateShaderObjectARB(shaderType); return (GLhandleARB)0;}
  GLEEPFNGLCREATESHADEROBJECTARBPROC GLeeFuncPtr_glCreateShaderObjectARB=GLee_Lazy_glCreateShaderObjectARB;
#endif
#ifndef GLEE_C_DEFINED_glShaderSourceARB
#define GLEE_C_DEFINED_glShaderSourceARB
  void __stdcall GLee_Lazy_glShaderSourceARB(GLhandleARB shaderObj, GLsizei count, const GLcharARB* * string, const GLint * length)  {if (GLeeInit()) glShaderSourceARB(shaderObj, count, string, length);}
  GLEEPFNGLSHADERSOURCEARBPROC GLeeFuncPtr_glShaderSourceARB=GLee_Lazy_glShaderSourceARB;
#endif
#ifndef GLEE_C_DEFINED_glCompileShaderARB
#define GLEE_C_DEFINED_glCompileShaderARB
  void __stdcall GLee_Lazy_glCompileShaderARB(GLhandleARB shaderObj)  {if (GLeeInit()) glCompileShaderARB(shaderObj);}
  GLEEPFNGLCOMPILESHADERARBPROC GLeeFuncPtr_glCompileShaderARB=GLee_Lazy_glCompileShaderARB;
#endif
#ifndef GLEE_C_DEFINED_glCreateProgramObjectARB
#define GLEE_C_DEFINED_glCreateProgramObjectARB
  GLhandleARB __stdcall GLee_Lazy_glCreateProgramObjectARB(void)  {if (GLeeInit()) return glCreateProgramObjectARB(); return (GLhandleARB)0;}
  GLEEPFNGLCREATEPROGRAMOBJECTARBPROC GLeeFuncPtr_glCreateProgramObjectARB=GLee_Lazy_glCreateProgramObjectARB;
#endif
#ifndef GLEE_C_DEFINED_glAttachObjectARB
#define GLEE_C_DEFINED_glAttachObjectARB
  void __stdcall GLee_Lazy_glAttachObjectARB(GLhandleARB containerObj, GLhandleARB obj)  {if (GLeeInit()) glAttachObjectARB(containerObj, obj);}
  GLEEPFNGLATTACHOBJECTARBPROC GLeeFuncPtr_glAttachObjectARB=GLee_Lazy_glAttachObjectARB;
#endif
#ifndef GLEE_C_DEFINED_glLinkProgramARB
#define GLEE_C_DEFINED_glLinkProgramARB
  void __stdcall GLee_Lazy_glLinkProgramARB(GLhandleARB programObj)  {if (GLeeInit()) glLinkProgramARB(programObj);}
  GLEEPFNGLLINKPROGRAMARBPROC GLeeFuncPtr_glLinkProgramARB=GLee_Lazy_glLinkProgramARB;
#endif
#ifndef GLEE_C_DEFINED_glUseProgramObjectARB
#define GLEE_C_DEFINED_glUseProgramObjectARB
  void __stdcall GLee_Lazy_glUseProgramObjectARB(GLhandleARB programObj)  {if (GLeeInit()) glUseProgramObjectARB(programObj);}
  GLEEPFNGLUSEPROGRAMOBJECTARBPROC GLeeFuncPtr_glUseProgramObjectARB=GLee_Lazy_glUseProgramObjectARB;
#endif
#ifndef GLEE_C_DEFINED_glValidateProgramARB
#define GLEE_C_DEFINED_glValidateProgramARB
  void __stdcall GLee_Lazy_glValidateProgramARB(GLhandleARB programObj)  {if (GLeeInit()) glValidateProgramARB(programObj);}
  GLEEPFNGLVALIDATEPROGRAMARBPROC GLeeFuncPtr_glValidateProgramARB=GLee_Lazy_glValidateProgramARB;
#endif
#ifndef GLEE_C_DEFINED_glUniform1fARB
#define GLEE_C_DEFINED_glUniform1fARB
  void __stdcall GLee_Lazy_glUniform1fARB(GLint location, GLfloat v0)  {if (GLeeInit()) glUniform1fARB(location, v0);}
  GLEEPFNGLUNIFORM1FARBPROC GLeeFuncPtr_glUniform1fARB=GLee_Lazy_glUniform1fARB;
#endif
#ifndef GLEE_C_DEFINED_glUniform2fARB
#define GLEE_C_DEFINED_glUniform2fARB
  void __stdcall GLee_Lazy_glUniform2fARB(GLint location, GLfloat v0, GLfloat v1)  {if (GLeeInit()) glUniform2fARB(location, v0, v1);}
  GLEEPFNGLUNIFORM2FARBPROC GLeeFuncPtr_glUniform2fARB=GLee_Lazy_glUniform2fARB;
#endif
#ifndef GLEE_C_DEFINED_glUniform3fARB
#define GLEE_C_DEFINED_glUniform3fARB
  void __stdcall GLee_Lazy_glUniform3fARB(GLint location, GLfloat v0, GLfloat v1, GLfloat v2)  {if (GLeeInit()) glUniform3fARB(location, v0, v1, v2);}
  GLEEPFNGLUNIFORM3FARBPROC GLeeFuncPtr_glUniform3fARB=GLee_Lazy_glUniform3fARB;
#endif
#ifndef GLEE_C_DEFINED_glUniform4fARB
#define GLEE_C_DEFINED_glUniform4fARB
  void __stdcall GLee_Lazy_glUniform4fARB(GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3)  {if (GLeeInit()) glUniform4fARB(location, v0, v1, v2, v3);}
  GLEEPFNGLUNIFORM4FARBPROC GLeeFuncPtr_glUniform4fARB=GLee_Lazy_glUniform4fARB;
#endif
#ifndef GLEE_C_DEFINED_glUniform1iARB
#define GLEE_C_DEFINED_glUniform1iARB
  void __stdcall GLee_Lazy_glUniform1iARB(GLint location, GLint v0)  {if (GLeeInit()) glUniform1iARB(location, v0);}
  GLEEPFNGLUNIFORM1IARBPROC GLeeFuncPtr_glUniform1iARB=GLee_Lazy_glUniform1iARB;
#endif
#ifndef GLEE_C_DEFINED_glUniform2iARB
#define GLEE_C_DEFINED_glUniform2iARB
  void __stdcall GLee_Lazy_glUniform2iARB(GLint location, GLint v0, GLint v1)  {if (GLeeInit()) glUniform2iARB(location, v0, v1);}
  GLEEPFNGLUNIFORM2IARBPROC GLeeFuncPtr_glUniform2iARB=GLee_Lazy_glUniform2iARB;
#endif
#ifndef GLEE_C_DEFINED_glUniform3iARB
#define GLEE_C_DEFINED_glUniform3iARB
  void __stdcall GLee_Lazy_glUniform3iARB(GLint location, GLint v0, GLint v1, GLint v2)  {if (GLeeInit()) glUniform3iARB(location, v0, v1, v2);}
  GLEEPFNGLUNIFORM3IARBPROC GLeeFuncPtr_glUniform3iARB=GLee_Lazy_glUniform3iARB;
#endif
#ifndef GLEE_C_DEFINED_glUniform4iARB
#define GLEE_C_DEFINED_glUniform4iARB
  void __stdcall GLee_Lazy_glUniform4iARB(GLint location, GLint v0, GLint v1, GLint v2, GLint v3)  {if (GLeeInit()) glUniform4iARB(location, v0, v1, v2, v3);}
  GLEEPFNGLUNIFORM4IARBPROC GLeeFuncPtr_glUniform4iARB=GLee_Lazy_glUniform4iARB;
#endif
#ifndef GLEE_C_DEFINED_glUniform1fvARB
#define GLEE_C_DEFINED_glUniform1fvARB
  void __stdcall GLee_Lazy_glUniform1fvARB(GLint location, GLsizei count, const GLfloat * value)  {if (GLeeInit()) glUniform1fvARB(location, count, value);}
  GLEEPFNGLUNIFORM1FVARBPROC GLeeFuncPtr_glUniform1fvARB=GLee_Lazy_glUniform1fvARB;
#endif
#ifndef GLEE_C_DEFINED_glUniform2fvARB
#define GLEE_C_DEFINED_glUniform2fvARB
  void __stdcall GLee_Lazy_glUniform2fvARB(GLint location, GLsizei count, const GLfloat * value)  {if (GLeeInit()) glUniform2fvARB(location, count, value);}
  GLEEPFNGLUNIFORM2FVARBPROC GLeeFuncPtr_glUniform2fvARB=GLee_Lazy_glUniform2fvARB;
#endif
#ifndef GLEE_C_DEFINED_glUniform3fvARB
#define GLEE_C_DEFINED_glUniform3fvARB
  void __stdcall GLee_Lazy_glUniform3fvARB(GLint location, GLsizei count, const GLfloat * value)  {if (GLeeInit()) glUniform3fvARB(location, count, value);}
  GLEEPFNGLUNIFORM3FVARBPROC GLeeFuncPtr_glUniform3fvARB=GLee_Lazy_glUniform3fvARB;
#endif
#ifndef GLEE_C_DEFINED_glUniform4fvARB
#define GLEE_C_DEFINED_glUniform4fvARB
  void __stdcall GLee_Lazy_glUniform4fvARB(GLint location, GLsizei count, const GLfloat * value)  {if (GLeeInit()) glUniform4fvARB(location, count, value);}
  GLEEPFNGLUNIFORM4FVARBPROC GLeeFuncPtr_glUniform4fvARB=GLee_Lazy_glUniform4fvARB;
#endif
#ifndef GLEE_C_DEFINED_glUniform1ivARB
#define GLEE_C_DEFINED_glUniform1ivARB
  void __stdcall GLee_Lazy_glUniform1ivARB(GLint location, GLsizei count, const GLint * value)  {if (GLeeInit()) glUniform1ivARB(location, count, value);}
  GLEEPFNGLUNIFORM1IVARBPROC GLeeFuncPtr_glUniform1ivARB=GLee_Lazy_glUniform1ivARB;
#endif
#ifndef GLEE_C_DEFINED_glUniform2ivARB
#define GLEE_C_DEFINED_glUniform2ivARB
  void __stdcall GLee_Lazy_glUniform2ivARB(GLint location, GLsizei count, const GLint * value)  {if (GLeeInit()) glUniform2ivARB(location, count, value);}
  GLEEPFNGLUNIFORM2IVARBPROC GLeeFuncPtr_glUniform2ivARB=GLee_Lazy_glUniform2ivARB;
#endif
#ifndef GLEE_C_DEFINED_glUniform3ivARB
#define GLEE_C_DEFINED_glUniform3ivARB
  void __stdcall GLee_Lazy_glUniform3ivARB(GLint location, GLsizei count, const GLint * value)  {if (GLeeInit()) glUniform3ivARB(location, count, value);}
  GLEEPFNGLUNIFORM3IVARBPROC GLeeFuncPtr_glUniform3ivARB=GLee_Lazy_glUniform3ivARB;
#endif
#ifndef GLEE_C_DEFINED_glUniform4ivARB
#define GLEE_C_DEFINED_glUniform4ivARB
  void __stdcall GLee_Lazy_glUniform4ivARB(GLint location, GLsizei count, const GLint * value)  {if (GLeeInit()) glUniform4ivARB(location, count, value);}
  GLEEPFNGLUNIFORM4IVARBPROC GLeeFuncPtr_glUniform4ivARB=GLee_Lazy_glUniform4ivARB;
#endif
#ifndef GLEE_C_DEFINED_glUniformMatrix2fvARB
#define GLEE_C_DEFINED_glUniformMatrix2fvARB
  void __stdcall GLee_Lazy_glUniformMatrix2fvARB(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value)  {if (GLeeInit()) glUniformMatrix2fvARB(location, count, transpose, value);}
  GLEEPFNGLUNIFORMMATRIX2FVARBPROC GLeeFuncPtr_glUniformMatrix2fvARB=GLee_Lazy_glUniformMatrix2fvARB;
#endif
#ifndef GLEE_C_DEFINED_glUniformMatrix3fvARB
#define GLEE_C_DEFINED_glUniformMatrix3fvARB
  void __stdcall GLee_Lazy_glUniformMatrix3fvARB(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value)  {if (GLeeInit()) glUniformMatrix3fvARB(location, count, transpose, value);}
  GLEEPFNGLUNIFORMMATRIX3FVARBPROC GLeeFuncPtr_glUniformMatrix3fvARB=GLee_Lazy_glUniformMatrix3fvARB;
#endif
#ifndef GLEE_C_DEFINED_glUniformMatrix4fvARB
#define GLEE_C_DEFINED_glUniformMatrix4fvARB
  void __stdcall GLee_Lazy_glUniformMatrix4fvARB(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value)  {if (GLeeInit()) glUniformMatrix4fvARB(location, count, transpose, value);}
  GLEEPFNGLUNIFORMMATRIX4FVARBPROC GLeeFuncPtr_glUniformMatrix4fvARB=GLee_Lazy_glUniformMatrix4fvARB;
#endif
#ifndef GLEE_C_DEFINED_glGetObjectParameterfvARB
#define GLEE_C_DEFINED_glGetObjectParameterfvARB
  void __stdcall GLee_Lazy_glGetObjectParameterfvARB(GLhandleARB obj, GLenum pname, GLfloat * params)  {if (GLeeInit()) glGetObjectParameterfvARB(obj, pname, params);}
  GLEEPFNGLGETOBJECTPARAMETERFVARBPROC GLeeFuncPtr_glGetObjectParameterfvARB=GLee_Lazy_glGetObjectParameterfvARB;
#endif
#ifndef GLEE_C_DEFINED_glGetObjectParameterivARB
#define GLEE_C_DEFINED_glGetObjectParameterivARB
  void __stdcall GLee_Lazy_glGetObjectParameterivARB(GLhandleARB obj, GLenum pname, GLint * params)  {if (GLeeInit()) glGetObjectParameterivARB(obj, pname, params);}
  GLEEPFNGLGETOBJECTPARAMETERIVARBPROC GLeeFuncPtr_glGetObjectParameterivARB=GLee_Lazy_glGetObjectParameterivARB;
#endif
#ifndef GLEE_C_DEFINED_glGetInfoLogARB
#define GLEE_C_DEFINED_glGetInfoLogARB
  void __stdcall GLee_Lazy_glGetInfoLogARB(GLhandleARB obj, GLsizei maxLength, GLsizei * length, GLcharARB * infoLog)  {if (GLeeInit()) glGetInfoLogARB(obj, maxLength, length, infoLog);}
  GLEEPFNGLGETINFOLOGARBPROC GLeeFuncPtr_glGetInfoLogARB=GLee_Lazy_glGetInfoLogARB;
#endif
#ifndef GLEE_C_DEFINED_glGetAttachedObjectsARB
#define GLEE_C_DEFINED_glGetAttachedObjectsARB
  void __stdcall GLee_Lazy_glGetAttachedObjectsARB(GLhandleARB containerObj, GLsizei maxCount, GLsizei * count, GLhandleARB * obj)  {if (GLeeInit()) glGetAttachedObjectsARB(containerObj, maxCount, count, obj);}
  GLEEPFNGLGETATTACHEDOBJECTSARBPROC GLeeFuncPtr_glGetAttachedObjectsARB=GLee_Lazy_glGetAttachedObjectsARB;
#endif
#ifndef GLEE_C_DEFINED_glGetUniformLocationARB
#define GLEE_C_DEFINED_glGetUniformLocationARB
  GLint __stdcall GLee_Lazy_glGetUniformLocationARB(GLhandleARB programObj, const GLcharARB * name)  {if (GLeeInit()) return glGetUniformLocationARB(programObj, name); return (GLint)0;}
  GLEEPFNGLGETUNIFORMLOCATIONARBPROC GLeeFuncPtr_glGetUniformLocationARB=GLee_Lazy_glGetUniformLocationARB;
#endif
#ifndef GLEE_C_DEFINED_glGetActiveUniformARB
#define GLEE_C_DEFINED_glGetActiveUniformARB
  void __stdcall GLee_Lazy_glGetActiveUniformARB(GLhandleARB programObj, GLuint index, GLsizei maxLength, GLsizei * length, GLint * size, GLenum * type, GLcharARB * name)  {if (GLeeInit()) glGetActiveUniformARB(programObj, index, maxLength, length, size, type, name);}
  GLEEPFNGLGETACTIVEUNIFORMARBPROC GLeeFuncPtr_glGetActiveUniformARB=GLee_Lazy_glGetActiveUniformARB;
#endif
#ifndef GLEE_C_DEFINED_glGetUniformfvARB
#define GLEE_C_DEFINED_glGetUniformfvARB
  void __stdcall GLee_Lazy_glGetUniformfvARB(GLhandleARB programObj, GLint location, GLfloat * params)  {if (GLeeInit()) glGetUniformfvARB(programObj, location, params);}
  GLEEPFNGLGETUNIFORMFVARBPROC GLeeFuncPtr_glGetUniformfvARB=GLee_Lazy_glGetUniformfvARB;
#endif
#ifndef GLEE_C_DEFINED_glGetUniformivARB
#define GLEE_C_DEFINED_glGetUniformivARB
  void __stdcall GLee_Lazy_glGetUniformivARB(GLhandleARB programObj, GLint location, GLint * params)  {if (GLeeInit()) glGetUniformivARB(programObj, location, params);}
  GLEEPFNGLGETUNIFORMIVARBPROC GLeeFuncPtr_glGetUniformivARB=GLee_Lazy_glGetUniformivARB;
#endif
#ifndef GLEE_C_DEFINED_glGetShaderSourceARB
#define GLEE_C_DEFINED_glGetShaderSourceARB
  void __stdcall GLee_Lazy_glGetShaderSourceARB(GLhandleARB obj, GLsizei maxLength, GLsizei * length, GLcharARB * source)  {if (GLeeInit()) glGetShaderSourceARB(obj, maxLength, length, source);}
  GLEEPFNGLGETSHADERSOURCEARBPROC GLeeFuncPtr_glGetShaderSourceARB=GLee_Lazy_glGetShaderSourceARB;
#endif
#endif 

/* GL_ARB_vertex_shader */

#ifdef __GLEE_GL_ARB_vertex_shader
#ifndef GLEE_C_DEFINED_glBindAttribLocationARB
#define GLEE_C_DEFINED_glBindAttribLocationARB
  void __stdcall GLee_Lazy_glBindAttribLocationARB(GLhandleARB programObj, GLuint index, const GLcharARB * name)  {if (GLeeInit()) glBindAttribLocationARB(programObj, index, name);}
  GLEEPFNGLBINDATTRIBLOCATIONARBPROC GLeeFuncPtr_glBindAttribLocationARB=GLee_Lazy_glBindAttribLocationARB;
#endif
#ifndef GLEE_C_DEFINED_glGetActiveAttribARB
#define GLEE_C_DEFINED_glGetActiveAttribARB
  void __stdcall GLee_Lazy_glGetActiveAttribARB(GLhandleARB programObj, GLuint index, GLsizei maxLength, GLsizei * length, GLint * size, GLenum * type, GLcharARB * name)  {if (GLeeInit()) glGetActiveAttribARB(programObj, index, maxLength, length, size, type, name);}
  GLEEPFNGLGETACTIVEATTRIBARBPROC GLeeFuncPtr_glGetActiveAttribARB=GLee_Lazy_glGetActiveAttribARB;
#endif
#ifndef GLEE_C_DEFINED_glGetAttribLocationARB
#define GLEE_C_DEFINED_glGetAttribLocationARB
  GLint __stdcall GLee_Lazy_glGetAttribLocationARB(GLhandleARB programObj, const GLcharARB * name)  {if (GLeeInit()) return glGetAttribLocationARB(programObj, name); return (GLint)0;}
  GLEEPFNGLGETATTRIBLOCATIONARBPROC GLeeFuncPtr_glGetAttribLocationARB=GLee_Lazy_glGetAttribLocationARB;
#endif
#endif 

/* GL_ARB_fragment_shader */

#ifdef __GLEE_GL_ARB_fragment_shader
#endif 

/* GL_ARB_shading_language_100 */

#ifdef __GLEE_GL_ARB_shading_language_100
#endif 

/* GL_ARB_texture_non_power_of_two */

#ifdef __GLEE_GL_ARB_texture_non_power_of_two
#endif 

/* GL_ARB_point_sprite */

#ifdef __GLEE_GL_ARB_point_sprite
#endif 

/* GL_ARB_fragment_program_shadow */

#ifdef __GLEE_GL_ARB_fragment_program_shadow
#endif 

/* GL_ARB_draw_buffers */

#ifdef __GLEE_GL_ARB_draw_buffers
#ifndef GLEE_C_DEFINED_glDrawBuffersARB
#define GLEE_C_DEFINED_glDrawBuffersARB
  void __stdcall GLee_Lazy_glDrawBuffersARB(GLsizei n, const GLenum * bufs)  {if (GLeeInit()) glDrawBuffersARB(n, bufs);}
  GLEEPFNGLDRAWBUFFERSARBPROC GLeeFuncPtr_glDrawBuffersARB=GLee_Lazy_glDrawBuffersARB;
#endif
#endif 

/* GL_ARB_texture_rectangle */

#ifdef __GLEE_GL_ARB_texture_rectangle
#endif 

/* GL_ARB_color_buffer_float */

#ifdef __GLEE_GL_ARB_color_buffer_float
#ifndef GLEE_C_DEFINED_glClampColorARB
#define GLEE_C_DEFINED_glClampColorARB
  void __stdcall GLee_Lazy_glClampColorARB(GLenum target, GLenum clamp)  {if (GLeeInit()) glClampColorARB(target, clamp);}
  GLEEPFNGLCLAMPCOLORARBPROC GLeeFuncPtr_glClampColorARB=GLee_Lazy_glClampColorARB;
#endif
#endif 

/* GL_ARB_half_float_pixel */

#ifdef __GLEE_GL_ARB_half_float_pixel
#endif 

/* GL_ARB_texture_float */

#ifdef __GLEE_GL_ARB_texture_float
#endif 

/* GL_ARB_pixel_buffer_object */

#ifdef __GLEE_GL_ARB_pixel_buffer_object
#endif 

/* GL_ARB_depth_buffer_float */

#ifdef __GLEE_GL_ARB_depth_buffer_float
#endif 

/* GL_ARB_draw_instanced */

#ifdef __GLEE_GL_ARB_draw_instanced
#ifndef GLEE_C_DEFINED_glDrawArraysInstancedARB
#define GLEE_C_DEFINED_glDrawArraysInstancedARB
  void __stdcall GLee_Lazy_glDrawArraysInstancedARB(GLenum mode, GLint first, GLsizei count, GLsizei primcount)  {if (GLeeInit()) glDrawArraysInstancedARB(mode, first, count, primcount);}
  GLEEPFNGLDRAWARRAYSINSTANCEDARBPROC GLeeFuncPtr_glDrawArraysInstancedARB=GLee_Lazy_glDrawArraysInstancedARB;
#endif
#ifndef GLEE_C_DEFINED_glDrawElementsInstancedARB
#define GLEE_C_DEFINED_glDrawElementsInstancedARB
  void __stdcall GLee_Lazy_glDrawElementsInstancedARB(GLenum mode, GLsizei count, GLenum type, const GLvoid * indices, GLsizei primcount)  {if (GLeeInit()) glDrawElementsInstancedARB(mode, count, type, indices, primcount);}
  GLEEPFNGLDRAWELEMENTSINSTANCEDARBPROC GLeeFuncPtr_glDrawElementsInstancedARB=GLee_Lazy_glDrawElementsInstancedARB;
#endif
#endif 

/* GL_ARB_framebuffer_object */

#ifdef __GLEE_GL_ARB_framebuffer_object
#ifndef GLEE_C_DEFINED_glIsRenderbuffer
#define GLEE_C_DEFINED_glIsRenderbuffer
  GLboolean __stdcall GLee_Lazy_glIsRenderbuffer(GLuint renderbuffer)  {if (GLeeInit()) return glIsRenderbuffer(renderbuffer); return (GLboolean)0;}
  GLEEPFNGLISRENDERBUFFERPROC GLeeFuncPtr_glIsRenderbuffer=GLee_Lazy_glIsRenderbuffer;
#endif
#ifndef GLEE_C_DEFINED_glBindRenderbuffer
#define GLEE_C_DEFINED_glBindRenderbuffer
  void __stdcall GLee_Lazy_glBindRenderbuffer(GLenum target, GLuint renderbuffer)  {if (GLeeInit()) glBindRenderbuffer(target, renderbuffer);}
  GLEEPFNGLBINDRENDERBUFFERPROC GLeeFuncPtr_glBindRenderbuffer=GLee_Lazy_glBindRenderbuffer;
#endif
#ifndef GLEE_C_DEFINED_glDeleteRenderbuffers
#define GLEE_C_DEFINED_glDeleteRenderbuffers
  void __stdcall GLee_Lazy_glDeleteRenderbuffers(GLsizei n, const GLuint * renderbuffers)  {if (GLeeInit()) glDeleteRenderbuffers(n, renderbuffers);}
  GLEEPFNGLDELETERENDERBUFFERSPROC GLeeFuncPtr_glDeleteRenderbuffers=GLee_Lazy_glDeleteRenderbuffers;
#endif
#ifndef GLEE_C_DEFINED_glGenRenderbuffers
#define GLEE_C_DEFINED_glGenRenderbuffers
  void __stdcall GLee_Lazy_glGenRenderbuffers(GLsizei n, GLuint * renderbuffers)  {if (GLeeInit()) glGenRenderbuffers(n, renderbuffers);}
  GLEEPFNGLGENRENDERBUFFERSPROC GLeeFuncPtr_glGenRenderbuffers=GLee_Lazy_glGenRenderbuffers;
#endif
#ifndef GLEE_C_DEFINED_glRenderbufferStorage
#define GLEE_C_DEFINED_glRenderbufferStorage
  void __stdcall GLee_Lazy_glRenderbufferStorage(GLenum target, GLenum internalformat, GLsizei width, GLsizei height)  {if (GLeeInit()) glRenderbufferStorage(target, internalformat, width, height);}
  GLEEPFNGLRENDERBUFFERSTORAGEPROC GLeeFuncPtr_glRenderbufferStorage=GLee_Lazy_glRenderbufferStorage;
#endif
#ifndef GLEE_C_DEFINED_glGetRenderbufferParameteriv
#define GLEE_C_DEFINED_glGetRenderbufferParameteriv
  void __stdcall GLee_Lazy_glGetRenderbufferParameteriv(GLenum target, GLenum pname, GLint * params)  {if (GLeeInit()) glGetRenderbufferParameteriv(target, pname, params);}
  GLEEPFNGLGETRENDERBUFFERPARAMETERIVPROC GLeeFuncPtr_glGetRenderbufferParameteriv=GLee_Lazy_glGetRenderbufferParameteriv;
#endif
#ifndef GLEE_C_DEFINED_glIsFramebuffer
#define GLEE_C_DEFINED_glIsFramebuffer
  GLboolean __stdcall GLee_Lazy_glIsFramebuffer(GLuint framebuffer)  {if (GLeeInit()) return glIsFramebuffer(framebuffer); return (GLboolean)0;}
  GLEEPFNGLISFRAMEBUFFERPROC GLeeFuncPtr_glIsFramebuffer=GLee_Lazy_glIsFramebuffer;
#endif
#ifndef GLEE_C_DEFINED_glBindFramebuffer
#define GLEE_C_DEFINED_glBindFramebuffer
  void __stdcall GLee_Lazy_glBindFramebuffer(GLenum target, GLuint framebuffer)  {if (GLeeInit()) glBindFramebuffer(target, framebuffer);}
  GLEEPFNGLBINDFRAMEBUFFERPROC GLeeFuncPtr_glBindFramebuffer=GLee_Lazy_glBindFramebuffer;
#endif
#ifndef GLEE_C_DEFINED_glDeleteFramebuffers
#define GLEE_C_DEFINED_glDeleteFramebuffers
  void __stdcall GLee_Lazy_glDeleteFramebuffers(GLsizei n, const GLuint * framebuffers)  {if (GLeeInit()) glDeleteFramebuffers(n, framebuffers);}
  GLEEPFNGLDELETEFRAMEBUFFERSPROC GLeeFuncPtr_glDeleteFramebuffers=GLee_Lazy_glDeleteFramebuffers;
#endif
#ifndef GLEE_C_DEFINED_glGenFramebuffers
#define GLEE_C_DEFINED_glGenFramebuffers
  void __stdcall GLee_Lazy_glGenFramebuffers(GLsizei n, GLuint * framebuffers)  {if (GLeeInit()) glGenFramebuffers(n, framebuffers);}
  GLEEPFNGLGENFRAMEBUFFERSPROC GLeeFuncPtr_glGenFramebuffers=GLee_Lazy_glGenFramebuffers;
#endif
#ifndef GLEE_C_DEFINED_glCheckFramebufferStatus
#define GLEE_C_DEFINED_glCheckFramebufferStatus
  GLenum __stdcall GLee_Lazy_glCheckFramebufferStatus(GLenum target)  {if (GLeeInit()) return glCheckFramebufferStatus(target); return (GLenum)0;}
  GLEEPFNGLCHECKFRAMEBUFFERSTATUSPROC GLeeFuncPtr_glCheckFramebufferStatus=GLee_Lazy_glCheckFramebufferStatus;
#endif
#ifndef GLEE_C_DEFINED_glFramebufferTexture1D
#define GLEE_C_DEFINED_glFramebufferTexture1D
  void __stdcall GLee_Lazy_glFramebufferTexture1D(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level)  {if (GLeeInit()) glFramebufferTexture1D(target, attachment, textarget, texture, level);}
  GLEEPFNGLFRAMEBUFFERTEXTURE1DPROC GLeeFuncPtr_glFramebufferTexture1D=GLee_Lazy_glFramebufferTexture1D;
#endif
#ifndef GLEE_C_DEFINED_glFramebufferTexture2D
#define GLEE_C_DEFINED_glFramebufferTexture2D
  void __stdcall GLee_Lazy_glFramebufferTexture2D(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level)  {if (GLeeInit()) glFramebufferTexture2D(target, attachment, textarget, texture, level);}
  GLEEPFNGLFRAMEBUFFERTEXTURE2DPROC GLeeFuncPtr_glFramebufferTexture2D=GLee_Lazy_glFramebufferTexture2D;
#endif
#ifndef GLEE_C_DEFINED_glFramebufferTexture3D
#define GLEE_C_DEFINED_glFramebufferTexture3D
  void __stdcall GLee_Lazy_glFramebufferTexture3D(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset)  {if (GLeeInit()) glFramebufferTexture3D(target, attachment, textarget, texture, level, zoffset);}
  GLEEPFNGLFRAMEBUFFERTEXTURE3DPROC GLeeFuncPtr_glFramebufferTexture3D=GLee_Lazy_glFramebufferTexture3D;
#endif
#ifndef GLEE_C_DEFINED_glFramebufferRenderbuffer
#define GLEE_C_DEFINED_glFramebufferRenderbuffer
  void __stdcall GLee_Lazy_glFramebufferRenderbuffer(GLenum target, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer)  {if (GLeeInit()) glFramebufferRenderbuffer(target, attachment, renderbuffertarget, renderbuffer);}
  GLEEPFNGLFRAMEBUFFERRENDERBUFFERPROC GLeeFuncPtr_glFramebufferRenderbuffer=GLee_Lazy_glFramebufferRenderbuffer;
#endif
#ifndef GLEE_C_DEFINED_glGetFramebufferAttachmentParameteriv
#define GLEE_C_DEFINED_glGetFramebufferAttachmentParameteriv
  void __stdcall GLee_Lazy_glGetFramebufferAttachmentParameteriv(GLenum target, GLenum attachment, GLenum pname, GLint * params)  {if (GLeeInit()) glGetFramebufferAttachmentParameteriv(target, attachment, pname, params);}
  GLEEPFNGLGETFRAMEBUFFERATTACHMENTPARAMETERIVPROC GLeeFuncPtr_glGetFramebufferAttachmentParameteriv=GLee_Lazy_glGetFramebufferAttachmentParameteriv;
#endif
#ifndef GLEE_C_DEFINED_glGenerateMipmap
#define GLEE_C_DEFINED_glGenerateMipmap
  void __stdcall GLee_Lazy_glGenerateMipmap(GLenum target)  {if (GLeeInit()) glGenerateMipmap(target);}
  GLEEPFNGLGENERATEMIPMAPPROC GLeeFuncPtr_glGenerateMipmap=GLee_Lazy_glGenerateMipmap;
#endif
#ifndef GLEE_C_DEFINED_glBlitFramebuffer
#define GLEE_C_DEFINED_glBlitFramebuffer
  void __stdcall GLee_Lazy_glBlitFramebuffer(GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter)  {if (GLeeInit()) glBlitFramebuffer(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter);}
  GLEEPFNGLBLITFRAMEBUFFERPROC GLeeFuncPtr_glBlitFramebuffer=GLee_Lazy_glBlitFramebuffer;
#endif
#ifndef GLEE_C_DEFINED_glRenderbufferStorageMultisample
#define GLEE_C_DEFINED_glRenderbufferStorageMultisample
  void __stdcall GLee_Lazy_glRenderbufferStorageMultisample(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height)  {if (GLeeInit()) glRenderbufferStorageMultisample(target, samples, internalformat, width, height);}
  GLEEPFNGLRENDERBUFFERSTORAGEMULTISAMPLEPROC GLeeFuncPtr_glRenderbufferStorageMultisample=GLee_Lazy_glRenderbufferStorageMultisample;
#endif
#ifndef GLEE_C_DEFINED_glFramebufferTextureLayer
#define GLEE_C_DEFINED_glFramebufferTextureLayer
  void __stdcall GLee_Lazy_glFramebufferTextureLayer(GLenum target, GLenum attachment, GLuint texture, GLint level, GLint layer)  {if (GLeeInit()) glFramebufferTextureLayer(target, attachment, texture, level, layer);}
  GLEEPFNGLFRAMEBUFFERTEXTURELAYERPROC GLeeFuncPtr_glFramebufferTextureLayer=GLee_Lazy_glFramebufferTextureLayer;
#endif
#endif 

/* GL_ARB_framebuffer_sRGB */

#ifdef __GLEE_GL_ARB_framebuffer_sRGB
#endif 

/* GL_ARB_geometry_shader4 */

#ifdef __GLEE_GL_ARB_geometry_shader4
#ifndef GLEE_C_DEFINED_glProgramParameteriARB
#define GLEE_C_DEFINED_glProgramParameteriARB
  void __stdcall GLee_Lazy_glProgramParameteriARB(GLuint program, GLenum pname, GLint value)  {if (GLeeInit()) glProgramParameteriARB(program, pname, value);}
  GLEEPFNGLPROGRAMPARAMETERIARBPROC GLeeFuncPtr_glProgramParameteriARB=GLee_Lazy_glProgramParameteriARB;
#endif
#ifndef GLEE_C_DEFINED_glFramebufferTextureARB
#define GLEE_C_DEFINED_glFramebufferTextureARB
  void __stdcall GLee_Lazy_glFramebufferTextureARB(GLenum target, GLenum attachment, GLuint texture, GLint level)  {if (GLeeInit()) glFramebufferTextureARB(target, attachment, texture, level);}
  GLEEPFNGLFRAMEBUFFERTEXTUREARBPROC GLeeFuncPtr_glFramebufferTextureARB=GLee_Lazy_glFramebufferTextureARB;
#endif
#ifndef GLEE_C_DEFINED_glFramebufferTextureLayerARB
#define GLEE_C_DEFINED_glFramebufferTextureLayerARB
  void __stdcall GLee_Lazy_glFramebufferTextureLayerARB(GLenum target, GLenum attachment, GLuint texture, GLint level, GLint layer)  {if (GLeeInit()) glFramebufferTextureLayerARB(target, attachment, texture, level, layer);}
  GLEEPFNGLFRAMEBUFFERTEXTURELAYERARBPROC GLeeFuncPtr_glFramebufferTextureLayerARB=GLee_Lazy_glFramebufferTextureLayerARB;
#endif
#ifndef GLEE_C_DEFINED_glFramebufferTextureFaceARB
#define GLEE_C_DEFINED_glFramebufferTextureFaceARB
  void __stdcall GLee_Lazy_glFramebufferTextureFaceARB(GLenum target, GLenum attachment, GLuint texture, GLint level, GLenum face)  {if (GLeeInit()) glFramebufferTextureFaceARB(target, attachment, texture, level, face);}
  GLEEPFNGLFRAMEBUFFERTEXTUREFACEARBPROC GLeeFuncPtr_glFramebufferTextureFaceARB=GLee_Lazy_glFramebufferTextureFaceARB;
#endif
#endif 

/* GL_ARB_half_float_vertex */

#ifdef __GLEE_GL_ARB_half_float_vertex
#endif 

/* GL_ARB_instanced_arrays */

#ifdef __GLEE_GL_ARB_instanced_arrays
#ifndef GLEE_C_DEFINED_glVertexAttribDivisor
#define GLEE_C_DEFINED_glVertexAttribDivisor
  void __stdcall GLee_Lazy_glVertexAttribDivisor(GLuint index, GLuint divisor)  {if (GLeeInit()) glVertexAttribDivisor(index, divisor);}
  GLEEPFNGLVERTEXATTRIBDIVISORPROC GLeeFuncPtr_glVertexAttribDivisor=GLee_Lazy_glVertexAttribDivisor;
#endif
#endif 

/* GL_ARB_map_buffer_range */

#ifdef __GLEE_GL_ARB_map_buffer_range
#ifndef GLEE_C_DEFINED_glMapBufferRange
#define GLEE_C_DEFINED_glMapBufferRange
  void __stdcall GLee_Lazy_glMapBufferRange(GLenum target, GLintptr offset, GLsizeiptr length, GLbitfield access)  {if (GLeeInit()) glMapBufferRange(target, offset, length, access);}
  GLEEPFNGLMAPBUFFERRANGEPROC GLeeFuncPtr_glMapBufferRange=GLee_Lazy_glMapBufferRange;
#endif
#ifndef GLEE_C_DEFINED_glFlushMappedBufferRange
#define GLEE_C_DEFINED_glFlushMappedBufferRange
  void __stdcall GLee_Lazy_glFlushMappedBufferRange(GLenum target, GLintptr offset, GLsizeiptr length)  {if (GLeeInit()) glFlushMappedBufferRange(target, offset, length);}
  GLEEPFNGLFLUSHMAPPEDBUFFERRANGEPROC GLeeFuncPtr_glFlushMappedBufferRange=GLee_Lazy_glFlushMappedBufferRange;
#endif
#endif 

/* GL_ARB_texture_buffer_object */

#ifdef __GLEE_GL_ARB_texture_buffer_object
#ifndef GLEE_C_DEFINED_glTexBufferARB
#define GLEE_C_DEFINED_glTexBufferARB
  void __stdcall GLee_Lazy_glTexBufferARB(GLenum target, GLenum internalformat, GLuint buffer)  {if (GLeeInit()) glTexBufferARB(target, internalformat, buffer);}
  GLEEPFNGLTEXBUFFERARBPROC GLeeFuncPtr_glTexBufferARB=GLee_Lazy_glTexBufferARB;
#endif
#endif 

/* GL_ARB_texture_compression_rgtc */

#ifdef __GLEE_GL_ARB_texture_compression_rgtc
#endif 

/* GL_ARB_texture_rg */

#ifdef __GLEE_GL_ARB_texture_rg
#endif 

/* GL_ARB_vertex_array_object */

#ifdef __GLEE_GL_ARB_vertex_array_object
#ifndef GLEE_C_DEFINED_glBindVertexArray
#define GLEE_C_DEFINED_glBindVertexArray
  void __stdcall GLee_Lazy_glBindVertexArray(GLuint array)  {if (GLeeInit()) glBindVertexArray(array);}
  GLEEPFNGLBINDVERTEXARRAYPROC GLeeFuncPtr_glBindVertexArray=GLee_Lazy_glBindVertexArray;
#endif
#ifndef GLEE_C_DEFINED_glDeleteVertexArrays
#define GLEE_C_DEFINED_glDeleteVertexArrays
  void __stdcall GLee_Lazy_glDeleteVertexArrays(GLsizei n, const GLuint * arrays)  {if (GLeeInit()) glDeleteVertexArrays(n, arrays);}
  GLEEPFNGLDELETEVERTEXARRAYSPROC GLeeFuncPtr_glDeleteVertexArrays=GLee_Lazy_glDeleteVertexArrays;
#endif
#ifndef GLEE_C_DEFINED_glGenVertexArrays
#define GLEE_C_DEFINED_glGenVertexArrays
  void __stdcall GLee_Lazy_glGenVertexArrays(GLsizei n, GLuint * arrays)  {if (GLeeInit()) glGenVertexArrays(n, arrays);}
  GLEEPFNGLGENVERTEXARRAYSPROC GLeeFuncPtr_glGenVertexArrays=GLee_Lazy_glGenVertexArrays;
#endif
#ifndef GLEE_C_DEFINED_glIsVertexArray
#define GLEE_C_DEFINED_glIsVertexArray
  GLboolean __stdcall GLee_Lazy_glIsVertexArray(GLuint array)  {if (GLeeInit()) return glIsVertexArray(array); return (GLboolean)0;}
  GLEEPFNGLISVERTEXARRAYPROC GLeeFuncPtr_glIsVertexArray=GLee_Lazy_glIsVertexArray;
#endif
#endif 

/* GL_EXT_abgr */

#ifdef __GLEE_GL_EXT_abgr
#endif 

/* GL_EXT_blend_color */

#ifdef __GLEE_GL_EXT_blend_color
#ifndef GLEE_C_DEFINED_glBlendColorEXT
#define GLEE_C_DEFINED_glBlendColorEXT
  void __stdcall GLee_Lazy_glBlendColorEXT(GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha)  {if (GLeeInit()) glBlendColorEXT(red, green, blue, alpha);}
  GLEEPFNGLBLENDCOLOREXTPROC GLeeFuncPtr_glBlendColorEXT=GLee_Lazy_glBlendColorEXT;
#endif
#endif 

/* GL_EXT_polygon_offset */

#ifdef __GLEE_GL_EXT_polygon_offset
#ifndef GLEE_C_DEFINED_glPolygonOffsetEXT
#define GLEE_C_DEFINED_glPolygonOffsetEXT
  void __stdcall GLee_Lazy_glPolygonOffsetEXT(GLfloat factor, GLfloat bias)  {if (GLeeInit()) glPolygonOffsetEXT(factor, bias);}
  GLEEPFNGLPOLYGONOFFSETEXTPROC GLeeFuncPtr_glPolygonOffsetEXT=GLee_Lazy_glPolygonOffsetEXT;
#endif
#endif 

/* GL_EXT_texture */

#ifdef __GLEE_GL_EXT_texture
#endif 

/* GL_EXT_texture3D */

#ifdef __GLEE_GL_EXT_texture3D
#ifndef GLEE_C_DEFINED_glTexImage3DEXT
#define GLEE_C_DEFINED_glTexImage3DEXT
  void __stdcall GLee_Lazy_glTexImage3DEXT(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid * pixels)  {if (GLeeInit()) glTexImage3DEXT(target, level, internalformat, width, height, depth, border, format, type, pixels);}
  GLEEPFNGLTEXIMAGE3DEXTPROC GLeeFuncPtr_glTexImage3DEXT=GLee_Lazy_glTexImage3DEXT;
#endif
#ifndef GLEE_C_DEFINED_glTexSubImage3DEXT
#define GLEE_C_DEFINED_glTexSubImage3DEXT
  void __stdcall GLee_Lazy_glTexSubImage3DEXT(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid * pixels)  {if (GLeeInit()) glTexSubImage3DEXT(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels);}
  GLEEPFNGLTEXSUBIMAGE3DEXTPROC GLeeFuncPtr_glTexSubImage3DEXT=GLee_Lazy_glTexSubImage3DEXT;
#endif
#endif 

/* GL_SGIS_texture_filter4 */

#ifdef __GLEE_GL_SGIS_texture_filter4
#ifndef GLEE_C_DEFINED_glGetTexFilterFuncSGIS
#define GLEE_C_DEFINED_glGetTexFilterFuncSGIS
  void __stdcall GLee_Lazy_glGetTexFilterFuncSGIS(GLenum target, GLenum filter, GLfloat * weights)  {if (GLeeInit()) glGetTexFilterFuncSGIS(target, filter, weights);}
  GLEEPFNGLGETTEXFILTERFUNCSGISPROC GLeeFuncPtr_glGetTexFilterFuncSGIS=GLee_Lazy_glGetTexFilterFuncSGIS;
#endif
#ifndef GLEE_C_DEFINED_glTexFilterFuncSGIS
#define GLEE_C_DEFINED_glTexFilterFuncSGIS
  void __stdcall GLee_Lazy_glTexFilterFuncSGIS(GLenum target, GLenum filter, GLsizei n, const GLfloat * weights)  {if (GLeeInit()) glTexFilterFuncSGIS(target, filter, n, weights);}
  GLEEPFNGLTEXFILTERFUNCSGISPROC GLeeFuncPtr_glTexFilterFuncSGIS=GLee_Lazy_glTexFilterFuncSGIS;
#endif
#endif 

/* GL_EXT_subtexture */

#ifdef __GLEE_GL_EXT_subtexture
#ifndef GLEE_C_DEFINED_glTexSubImage1DEXT
#define GLEE_C_DEFINED_glTexSubImage1DEXT
  void __stdcall GLee_Lazy_glTexSubImage1DEXT(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid * pixels)  {if (GLeeInit()) glTexSubImage1DEXT(target, level, xoffset, width, format, type, pixels);}
  GLEEPFNGLTEXSUBIMAGE1DEXTPROC GLeeFuncPtr_glTexSubImage1DEXT=GLee_Lazy_glTexSubImage1DEXT;
#endif
#ifndef GLEE_C_DEFINED_glTexSubImage2DEXT
#define GLEE_C_DEFINED_glTexSubImage2DEXT
  void __stdcall GLee_Lazy_glTexSubImage2DEXT(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid * pixels)  {if (GLeeInit()) glTexSubImage2DEXT(target, level, xoffset, yoffset, width, height, format, type, pixels);}
  GLEEPFNGLTEXSUBIMAGE2DEXTPROC GLeeFuncPtr_glTexSubImage2DEXT=GLee_Lazy_glTexSubImage2DEXT;
#endif
#endif 

/* GL_EXT_copy_texture */

#ifdef __GLEE_GL_EXT_copy_texture
#ifndef GLEE_C_DEFINED_glCopyTexImage1DEXT
#define GLEE_C_DEFINED_glCopyTexImage1DEXT
  void __stdcall GLee_Lazy_glCopyTexImage1DEXT(GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border)  {if (GLeeInit()) glCopyTexImage1DEXT(target, level, internalformat, x, y, width, border);}
  GLEEPFNGLCOPYTEXIMAGE1DEXTPROC GLeeFuncPtr_glCopyTexImage1DEXT=GLee_Lazy_glCopyTexImage1DEXT;
#endif
#ifndef GLEE_C_DEFINED_glCopyTexImage2DEXT
#define GLEE_C_DEFINED_glCopyTexImage2DEXT
  void __stdcall GLee_Lazy_glCopyTexImage2DEXT(GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border)  {if (GLeeInit()) glCopyTexImage2DEXT(target, level, internalformat, x, y, width, height, border);}
  GLEEPFNGLCOPYTEXIMAGE2DEXTPROC GLeeFuncPtr_glCopyTexImage2DEXT=GLee_Lazy_glCopyTexImage2DEXT;
#endif
#ifndef GLEE_C_DEFINED_glCopyTexSubImage1DEXT
#define GLEE_C_DEFINED_glCopyTexSubImage1DEXT
  void __stdcall GLee_Lazy_glCopyTexSubImage1DEXT(GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width)  {if (GLeeInit()) glCopyTexSubImage1DEXT(target, level, xoffset, x, y, width);}
  GLEEPFNGLCOPYTEXSUBIMAGE1DEXTPROC GLeeFuncPtr_glCopyTexSubImage1DEXT=GLee_Lazy_glCopyTexSubImage1DEXT;
#endif
#ifndef GLEE_C_DEFINED_glCopyTexSubImage2DEXT
#define GLEE_C_DEFINED_glCopyTexSubImage2DEXT
  void __stdcall GLee_Lazy_glCopyTexSubImage2DEXT(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height)  {if (GLeeInit()) glCopyTexSubImage2DEXT(target, level, xoffset, yoffset, x, y, width, height);}
  GLEEPFNGLCOPYTEXSUBIMAGE2DEXTPROC GLeeFuncPtr_glCopyTexSubImage2DEXT=GLee_Lazy_glCopyTexSubImage2DEXT;
#endif
#ifndef GLEE_C_DEFINED_glCopyTexSubImage3DEXT
#define GLEE_C_DEFINED_glCopyTexSubImage3DEXT
  void __stdcall GLee_Lazy_glCopyTexSubImage3DEXT(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height)  {if (GLeeInit()) glCopyTexSubImage3DEXT(target, level, xoffset, yoffset, zoffset, x, y, width, height);}
  GLEEPFNGLCOPYTEXSUBIMAGE3DEXTPROC GLeeFuncPtr_glCopyTexSubImage3DEXT=GLee_Lazy_glCopyTexSubImage3DEXT;
#endif
#endif 

/* GL_EXT_histogram */

#ifdef __GLEE_GL_EXT_histogram
#ifndef GLEE_C_DEFINED_glGetHistogramEXT
#define GLEE_C_DEFINED_glGetHistogramEXT
  void __stdcall GLee_Lazy_glGetHistogramEXT(GLenum target, GLboolean reset, GLenum format, GLenum type, GLvoid * values)  {if (GLeeInit()) glGetHistogramEXT(target, reset, format, type, values);}
  GLEEPFNGLGETHISTOGRAMEXTPROC GLeeFuncPtr_glGetHistogramEXT=GLee_Lazy_glGetHistogramEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetHistogramParameterfvEXT
#define GLEE_C_DEFINED_glGetHistogramParameterfvEXT
  void __stdcall GLee_Lazy_glGetHistogramParameterfvEXT(GLenum target, GLenum pname, GLfloat * params)  {if (GLeeInit()) glGetHistogramParameterfvEXT(target, pname, params);}
  GLEEPFNGLGETHISTOGRAMPARAMETERFVEXTPROC GLeeFuncPtr_glGetHistogramParameterfvEXT=GLee_Lazy_glGetHistogramParameterfvEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetHistogramParameterivEXT
#define GLEE_C_DEFINED_glGetHistogramParameterivEXT
  void __stdcall GLee_Lazy_glGetHistogramParameterivEXT(GLenum target, GLenum pname, GLint * params)  {if (GLeeInit()) glGetHistogramParameterivEXT(target, pname, params);}
  GLEEPFNGLGETHISTOGRAMPARAMETERIVEXTPROC GLeeFuncPtr_glGetHistogramParameterivEXT=GLee_Lazy_glGetHistogramParameterivEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetMinmaxEXT
#define GLEE_C_DEFINED_glGetMinmaxEXT
  void __stdcall GLee_Lazy_glGetMinmaxEXT(GLenum target, GLboolean reset, GLenum format, GLenum type, GLvoid * values)  {if (GLeeInit()) glGetMinmaxEXT(target, reset, format, type, values);}
  GLEEPFNGLGETMINMAXEXTPROC GLeeFuncPtr_glGetMinmaxEXT=GLee_Lazy_glGetMinmaxEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetMinmaxParameterfvEXT
#define GLEE_C_DEFINED_glGetMinmaxParameterfvEXT
  void __stdcall GLee_Lazy_glGetMinmaxParameterfvEXT(GLenum target, GLenum pname, GLfloat * params)  {if (GLeeInit()) glGetMinmaxParameterfvEXT(target, pname, params);}
  GLEEPFNGLGETMINMAXPARAMETERFVEXTPROC GLeeFuncPtr_glGetMinmaxParameterfvEXT=GLee_Lazy_glGetMinmaxParameterfvEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetMinmaxParameterivEXT
#define GLEE_C_DEFINED_glGetMinmaxParameterivEXT
  void __stdcall GLee_Lazy_glGetMinmaxParameterivEXT(GLenum target, GLenum pname, GLint * params)  {if (GLeeInit()) glGetMinmaxParameterivEXT(target, pname, params);}
  GLEEPFNGLGETMINMAXPARAMETERIVEXTPROC GLeeFuncPtr_glGetMinmaxParameterivEXT=GLee_Lazy_glGetMinmaxParameterivEXT;
#endif
#ifndef GLEE_C_DEFINED_glHistogramEXT
#define GLEE_C_DEFINED_glHistogramEXT
  void __stdcall GLee_Lazy_glHistogramEXT(GLenum target, GLsizei width, GLenum internalformat, GLboolean sink)  {if (GLeeInit()) glHistogramEXT(target, width, internalformat, sink);}
  GLEEPFNGLHISTOGRAMEXTPROC GLeeFuncPtr_glHistogramEXT=GLee_Lazy_glHistogramEXT;
#endif
#ifndef GLEE_C_DEFINED_glMinmaxEXT
#define GLEE_C_DEFINED_glMinmaxEXT
  void __stdcall GLee_Lazy_glMinmaxEXT(GLenum target, GLenum internalformat, GLboolean sink)  {if (GLeeInit()) glMinmaxEXT(target, internalformat, sink);}
  GLEEPFNGLMINMAXEXTPROC GLeeFuncPtr_glMinmaxEXT=GLee_Lazy_glMinmaxEXT;
#endif
#ifndef GLEE_C_DEFINED_glResetHistogramEXT
#define GLEE_C_DEFINED_glResetHistogramEXT
  void __stdcall GLee_Lazy_glResetHistogramEXT(GLenum target)  {if (GLeeInit()) glResetHistogramEXT(target);}
  GLEEPFNGLRESETHISTOGRAMEXTPROC GLeeFuncPtr_glResetHistogramEXT=GLee_Lazy_glResetHistogramEXT;
#endif
#ifndef GLEE_C_DEFINED_glResetMinmaxEXT
#define GLEE_C_DEFINED_glResetMinmaxEXT
  void __stdcall GLee_Lazy_glResetMinmaxEXT(GLenum target)  {if (GLeeInit()) glResetMinmaxEXT(target);}
  GLEEPFNGLRESETMINMAXEXTPROC GLeeFuncPtr_glResetMinmaxEXT=GLee_Lazy_glResetMinmaxEXT;
#endif
#endif 

/* GL_EXT_convolution */

#ifdef __GLEE_GL_EXT_convolution
#ifndef GLEE_C_DEFINED_glConvolutionFilter1DEXT
#define GLEE_C_DEFINED_glConvolutionFilter1DEXT
  void __stdcall GLee_Lazy_glConvolutionFilter1DEXT(GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const GLvoid * image)  {if (GLeeInit()) glConvolutionFilter1DEXT(target, internalformat, width, format, type, image);}
  GLEEPFNGLCONVOLUTIONFILTER1DEXTPROC GLeeFuncPtr_glConvolutionFilter1DEXT=GLee_Lazy_glConvolutionFilter1DEXT;
#endif
#ifndef GLEE_C_DEFINED_glConvolutionFilter2DEXT
#define GLEE_C_DEFINED_glConvolutionFilter2DEXT
  void __stdcall GLee_Lazy_glConvolutionFilter2DEXT(GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid * image)  {if (GLeeInit()) glConvolutionFilter2DEXT(target, internalformat, width, height, format, type, image);}
  GLEEPFNGLCONVOLUTIONFILTER2DEXTPROC GLeeFuncPtr_glConvolutionFilter2DEXT=GLee_Lazy_glConvolutionFilter2DEXT;
#endif
#ifndef GLEE_C_DEFINED_glConvolutionParameterfEXT
#define GLEE_C_DEFINED_glConvolutionParameterfEXT
  void __stdcall GLee_Lazy_glConvolutionParameterfEXT(GLenum target, GLenum pname, GLfloat params)  {if (GLeeInit()) glConvolutionParameterfEXT(target, pname, params);}
  GLEEPFNGLCONVOLUTIONPARAMETERFEXTPROC GLeeFuncPtr_glConvolutionParameterfEXT=GLee_Lazy_glConvolutionParameterfEXT;
#endif
#ifndef GLEE_C_DEFINED_glConvolutionParameterfvEXT
#define GLEE_C_DEFINED_glConvolutionParameterfvEXT
  void __stdcall GLee_Lazy_glConvolutionParameterfvEXT(GLenum target, GLenum pname, const GLfloat * params)  {if (GLeeInit()) glConvolutionParameterfvEXT(target, pname, params);}
  GLEEPFNGLCONVOLUTIONPARAMETERFVEXTPROC GLeeFuncPtr_glConvolutionParameterfvEXT=GLee_Lazy_glConvolutionParameterfvEXT;
#endif
#ifndef GLEE_C_DEFINED_glConvolutionParameteriEXT
#define GLEE_C_DEFINED_glConvolutionParameteriEXT
  void __stdcall GLee_Lazy_glConvolutionParameteriEXT(GLenum target, GLenum pname, GLint params)  {if (GLeeInit()) glConvolutionParameteriEXT(target, pname, params);}
  GLEEPFNGLCONVOLUTIONPARAMETERIEXTPROC GLeeFuncPtr_glConvolutionParameteriEXT=GLee_Lazy_glConvolutionParameteriEXT;
#endif
#ifndef GLEE_C_DEFINED_glConvolutionParameterivEXT
#define GLEE_C_DEFINED_glConvolutionParameterivEXT
  void __stdcall GLee_Lazy_glConvolutionParameterivEXT(GLenum target, GLenum pname, const GLint * params)  {if (GLeeInit()) glConvolutionParameterivEXT(target, pname, params);}
  GLEEPFNGLCONVOLUTIONPARAMETERIVEXTPROC GLeeFuncPtr_glConvolutionParameterivEXT=GLee_Lazy_glConvolutionParameterivEXT;
#endif
#ifndef GLEE_C_DEFINED_glCopyConvolutionFilter1DEXT
#define GLEE_C_DEFINED_glCopyConvolutionFilter1DEXT
  void __stdcall GLee_Lazy_glCopyConvolutionFilter1DEXT(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width)  {if (GLeeInit()) glCopyConvolutionFilter1DEXT(target, internalformat, x, y, width);}
  GLEEPFNGLCOPYCONVOLUTIONFILTER1DEXTPROC GLeeFuncPtr_glCopyConvolutionFilter1DEXT=GLee_Lazy_glCopyConvolutionFilter1DEXT;
#endif
#ifndef GLEE_C_DEFINED_glCopyConvolutionFilter2DEXT
#define GLEE_C_DEFINED_glCopyConvolutionFilter2DEXT
  void __stdcall GLee_Lazy_glCopyConvolutionFilter2DEXT(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height)  {if (GLeeInit()) glCopyConvolutionFilter2DEXT(target, internalformat, x, y, width, height);}
  GLEEPFNGLCOPYCONVOLUTIONFILTER2DEXTPROC GLeeFuncPtr_glCopyConvolutionFilter2DEXT=GLee_Lazy_glCopyConvolutionFilter2DEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetConvolutionFilterEXT
#define GLEE_C_DEFINED_glGetConvolutionFilterEXT
  void __stdcall GLee_Lazy_glGetConvolutionFilterEXT(GLenum target, GLenum format, GLenum type, GLvoid * image)  {if (GLeeInit()) glGetConvolutionFilterEXT(target, format, type, image);}
  GLEEPFNGLGETCONVOLUTIONFILTEREXTPROC GLeeFuncPtr_glGetConvolutionFilterEXT=GLee_Lazy_glGetConvolutionFilterEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetConvolutionParameterfvEXT
#define GLEE_C_DEFINED_glGetConvolutionParameterfvEXT
  void __stdcall GLee_Lazy_glGetConvolutionParameterfvEXT(GLenum target, GLenum pname, GLfloat * params)  {if (GLeeInit()) glGetConvolutionParameterfvEXT(target, pname, params);}
  GLEEPFNGLGETCONVOLUTIONPARAMETERFVEXTPROC GLeeFuncPtr_glGetConvolutionParameterfvEXT=GLee_Lazy_glGetConvolutionParameterfvEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetConvolutionParameterivEXT
#define GLEE_C_DEFINED_glGetConvolutionParameterivEXT
  void __stdcall GLee_Lazy_glGetConvolutionParameterivEXT(GLenum target, GLenum pname, GLint * params)  {if (GLeeInit()) glGetConvolutionParameterivEXT(target, pname, params);}
  GLEEPFNGLGETCONVOLUTIONPARAMETERIVEXTPROC GLeeFuncPtr_glGetConvolutionParameterivEXT=GLee_Lazy_glGetConvolutionParameterivEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetSeparableFilterEXT
#define GLEE_C_DEFINED_glGetSeparableFilterEXT
  void __stdcall GLee_Lazy_glGetSeparableFilterEXT(GLenum target, GLenum format, GLenum type, GLvoid * row, GLvoid * column, GLvoid * span)  {if (GLeeInit()) glGetSeparableFilterEXT(target, format, type, row, column, span);}
  GLEEPFNGLGETSEPARABLEFILTEREXTPROC GLeeFuncPtr_glGetSeparableFilterEXT=GLee_Lazy_glGetSeparableFilterEXT;
#endif
#ifndef GLEE_C_DEFINED_glSeparableFilter2DEXT
#define GLEE_C_DEFINED_glSeparableFilter2DEXT
  void __stdcall GLee_Lazy_glSeparableFilter2DEXT(GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid * row, const GLvoid * column)  {if (GLeeInit()) glSeparableFilter2DEXT(target, internalformat, width, height, format, type, row, column);}
  GLEEPFNGLSEPARABLEFILTER2DEXTPROC GLeeFuncPtr_glSeparableFilter2DEXT=GLee_Lazy_glSeparableFilter2DEXT;
#endif
#endif 

/* GL_SGI_color_matrix */

#ifdef __GLEE_GL_SGI_color_matrix
#endif 

/* GL_SGI_color_table */

#ifdef __GLEE_GL_SGI_color_table
#ifndef GLEE_C_DEFINED_glColorTableSGI
#define GLEE_C_DEFINED_glColorTableSGI
  void __stdcall GLee_Lazy_glColorTableSGI(GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const GLvoid * table)  {if (GLeeInit()) glColorTableSGI(target, internalformat, width, format, type, table);}
  GLEEPFNGLCOLORTABLESGIPROC GLeeFuncPtr_glColorTableSGI=GLee_Lazy_glColorTableSGI;
#endif
#ifndef GLEE_C_DEFINED_glColorTableParameterfvSGI
#define GLEE_C_DEFINED_glColorTableParameterfvSGI
  void __stdcall GLee_Lazy_glColorTableParameterfvSGI(GLenum target, GLenum pname, const GLfloat * params)  {if (GLeeInit()) glColorTableParameterfvSGI(target, pname, params);}
  GLEEPFNGLCOLORTABLEPARAMETERFVSGIPROC GLeeFuncPtr_glColorTableParameterfvSGI=GLee_Lazy_glColorTableParameterfvSGI;
#endif
#ifndef GLEE_C_DEFINED_glColorTableParameterivSGI
#define GLEE_C_DEFINED_glColorTableParameterivSGI
  void __stdcall GLee_Lazy_glColorTableParameterivSGI(GLenum target, GLenum pname, const GLint * params)  {if (GLeeInit()) glColorTableParameterivSGI(target, pname, params);}
  GLEEPFNGLCOLORTABLEPARAMETERIVSGIPROC GLeeFuncPtr_glColorTableParameterivSGI=GLee_Lazy_glColorTableParameterivSGI;
#endif
#ifndef GLEE_C_DEFINED_glCopyColorTableSGI
#define GLEE_C_DEFINED_glCopyColorTableSGI
  void __stdcall GLee_Lazy_glCopyColorTableSGI(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width)  {if (GLeeInit()) glCopyColorTableSGI(target, internalformat, x, y, width);}
  GLEEPFNGLCOPYCOLORTABLESGIPROC GLeeFuncPtr_glCopyColorTableSGI=GLee_Lazy_glCopyColorTableSGI;
#endif
#ifndef GLEE_C_DEFINED_glGetColorTableSGI
#define GLEE_C_DEFINED_glGetColorTableSGI
  void __stdcall GLee_Lazy_glGetColorTableSGI(GLenum target, GLenum format, GLenum type, GLvoid * table)  {if (GLeeInit()) glGetColorTableSGI(target, format, type, table);}
  GLEEPFNGLGETCOLORTABLESGIPROC GLeeFuncPtr_glGetColorTableSGI=GLee_Lazy_glGetColorTableSGI;
#endif
#ifndef GLEE_C_DEFINED_glGetColorTableParameterfvSGI
#define GLEE_C_DEFINED_glGetColorTableParameterfvSGI
  void __stdcall GLee_Lazy_glGetColorTableParameterfvSGI(GLenum target, GLenum pname, GLfloat * params)  {if (GLeeInit()) glGetColorTableParameterfvSGI(target, pname, params);}
  GLEEPFNGLGETCOLORTABLEPARAMETERFVSGIPROC GLeeFuncPtr_glGetColorTableParameterfvSGI=GLee_Lazy_glGetColorTableParameterfvSGI;
#endif
#ifndef GLEE_C_DEFINED_glGetColorTableParameterivSGI
#define GLEE_C_DEFINED_glGetColorTableParameterivSGI
  void __stdcall GLee_Lazy_glGetColorTableParameterivSGI(GLenum target, GLenum pname, GLint * params)  {if (GLeeInit()) glGetColorTableParameterivSGI(target, pname, params);}
  GLEEPFNGLGETCOLORTABLEPARAMETERIVSGIPROC GLeeFuncPtr_glGetColorTableParameterivSGI=GLee_Lazy_glGetColorTableParameterivSGI;
#endif
#endif 

/* GL_SGIS_pixel_texture */

#ifdef __GLEE_GL_SGIS_pixel_texture
#ifndef GLEE_C_DEFINED_glPixelTexGenParameteriSGIS
#define GLEE_C_DEFINED_glPixelTexGenParameteriSGIS
  void __stdcall GLee_Lazy_glPixelTexGenParameteriSGIS(GLenum pname, GLint param)  {if (GLeeInit()) glPixelTexGenParameteriSGIS(pname, param);}
  GLEEPFNGLPIXELTEXGENPARAMETERISGISPROC GLeeFuncPtr_glPixelTexGenParameteriSGIS=GLee_Lazy_glPixelTexGenParameteriSGIS;
#endif
#ifndef GLEE_C_DEFINED_glPixelTexGenParameterivSGIS
#define GLEE_C_DEFINED_glPixelTexGenParameterivSGIS
  void __stdcall GLee_Lazy_glPixelTexGenParameterivSGIS(GLenum pname, const GLint * params)  {if (GLeeInit()) glPixelTexGenParameterivSGIS(pname, params);}
  GLEEPFNGLPIXELTEXGENPARAMETERIVSGISPROC GLeeFuncPtr_glPixelTexGenParameterivSGIS=GLee_Lazy_glPixelTexGenParameterivSGIS;
#endif
#ifndef GLEE_C_DEFINED_glPixelTexGenParameterfSGIS
#define GLEE_C_DEFINED_glPixelTexGenParameterfSGIS
  void __stdcall GLee_Lazy_glPixelTexGenParameterfSGIS(GLenum pname, GLfloat param)  {if (GLeeInit()) glPixelTexGenParameterfSGIS(pname, param);}
  GLEEPFNGLPIXELTEXGENPARAMETERFSGISPROC GLeeFuncPtr_glPixelTexGenParameterfSGIS=GLee_Lazy_glPixelTexGenParameterfSGIS;
#endif
#ifndef GLEE_C_DEFINED_glPixelTexGenParameterfvSGIS
#define GLEE_C_DEFINED_glPixelTexGenParameterfvSGIS
  void __stdcall GLee_Lazy_glPixelTexGenParameterfvSGIS(GLenum pname, const GLfloat * params)  {if (GLeeInit()) glPixelTexGenParameterfvSGIS(pname, params);}
  GLEEPFNGLPIXELTEXGENPARAMETERFVSGISPROC GLeeFuncPtr_glPixelTexGenParameterfvSGIS=GLee_Lazy_glPixelTexGenParameterfvSGIS;
#endif
#ifndef GLEE_C_DEFINED_glGetPixelTexGenParameterivSGIS
#define GLEE_C_DEFINED_glGetPixelTexGenParameterivSGIS
  void __stdcall GLee_Lazy_glGetPixelTexGenParameterivSGIS(GLenum pname, GLint * params)  {if (GLeeInit()) glGetPixelTexGenParameterivSGIS(pname, params);}
  GLEEPFNGLGETPIXELTEXGENPARAMETERIVSGISPROC GLeeFuncPtr_glGetPixelTexGenParameterivSGIS=GLee_Lazy_glGetPixelTexGenParameterivSGIS;
#endif
#ifndef GLEE_C_DEFINED_glGetPixelTexGenParameterfvSGIS
#define GLEE_C_DEFINED_glGetPixelTexGenParameterfvSGIS
  void __stdcall GLee_Lazy_glGetPixelTexGenParameterfvSGIS(GLenum pname, GLfloat * params)  {if (GLeeInit()) glGetPixelTexGenParameterfvSGIS(pname, params);}
  GLEEPFNGLGETPIXELTEXGENPARAMETERFVSGISPROC GLeeFuncPtr_glGetPixelTexGenParameterfvSGIS=GLee_Lazy_glGetPixelTexGenParameterfvSGIS;
#endif
#endif 

/* GL_SGIX_pixel_texture */

#ifdef __GLEE_GL_SGIX_pixel_texture
#ifndef GLEE_C_DEFINED_glPixelTexGenSGIX
#define GLEE_C_DEFINED_glPixelTexGenSGIX
  void __stdcall GLee_Lazy_glPixelTexGenSGIX(GLenum mode)  {if (GLeeInit()) glPixelTexGenSGIX(mode);}
  GLEEPFNGLPIXELTEXGENSGIXPROC GLeeFuncPtr_glPixelTexGenSGIX=GLee_Lazy_glPixelTexGenSGIX;
#endif
#endif 

/* GL_SGIS_texture4D */

#ifdef __GLEE_GL_SGIS_texture4D
#ifndef GLEE_C_DEFINED_glTexImage4DSGIS
#define GLEE_C_DEFINED_glTexImage4DSGIS
  void __stdcall GLee_Lazy_glTexImage4DSGIS(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLsizei size4d, GLint border, GLenum format, GLenum type, const GLvoid * pixels)  {if (GLeeInit()) glTexImage4DSGIS(target, level, internalformat, width, height, depth, size4d, border, format, type, pixels);}
  GLEEPFNGLTEXIMAGE4DSGISPROC GLeeFuncPtr_glTexImage4DSGIS=GLee_Lazy_glTexImage4DSGIS;
#endif
#ifndef GLEE_C_DEFINED_glTexSubImage4DSGIS
#define GLEE_C_DEFINED_glTexSubImage4DSGIS
  void __stdcall GLee_Lazy_glTexSubImage4DSGIS(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint woffset, GLsizei width, GLsizei height, GLsizei depth, GLsizei size4d, GLenum format, GLenum type, const GLvoid * pixels)  {if (GLeeInit()) glTexSubImage4DSGIS(target, level, xoffset, yoffset, zoffset, woffset, width, height, depth, size4d, format, type, pixels);}
  GLEEPFNGLTEXSUBIMAGE4DSGISPROC GLeeFuncPtr_glTexSubImage4DSGIS=GLee_Lazy_glTexSubImage4DSGIS;
#endif
#endif 

/* GL_SGI_texture_color_table */

#ifdef __GLEE_GL_SGI_texture_color_table
#endif 

/* GL_EXT_cmyka */

#ifdef __GLEE_GL_EXT_cmyka
#endif 

/* GL_EXT_texture_object */

#ifdef __GLEE_GL_EXT_texture_object
#ifndef GLEE_C_DEFINED_glAreTexturesResidentEXT
#define GLEE_C_DEFINED_glAreTexturesResidentEXT
  GLboolean __stdcall GLee_Lazy_glAreTexturesResidentEXT(GLsizei n, const GLuint * textures, GLboolean * residences)  {if (GLeeInit()) return glAreTexturesResidentEXT(n, textures, residences); return (GLboolean)0;}
  GLEEPFNGLARETEXTURESRESIDENTEXTPROC GLeeFuncPtr_glAreTexturesResidentEXT=GLee_Lazy_glAreTexturesResidentEXT;
#endif
#ifndef GLEE_C_DEFINED_glBindTextureEXT
#define GLEE_C_DEFINED_glBindTextureEXT
  void __stdcall GLee_Lazy_glBindTextureEXT(GLenum target, GLuint texture)  {if (GLeeInit()) glBindTextureEXT(target, texture);}
  GLEEPFNGLBINDTEXTUREEXTPROC GLeeFuncPtr_glBindTextureEXT=GLee_Lazy_glBindTextureEXT;
#endif
#ifndef GLEE_C_DEFINED_glDeleteTexturesEXT
#define GLEE_C_DEFINED_glDeleteTexturesEXT
  void __stdcall GLee_Lazy_glDeleteTexturesEXT(GLsizei n, const GLuint * textures)  {if (GLeeInit()) glDeleteTexturesEXT(n, textures);}
  GLEEPFNGLDELETETEXTURESEXTPROC GLeeFuncPtr_glDeleteTexturesEXT=GLee_Lazy_glDeleteTexturesEXT;
#endif
#ifndef GLEE_C_DEFINED_glGenTexturesEXT
#define GLEE_C_DEFINED_glGenTexturesEXT
  void __stdcall GLee_Lazy_glGenTexturesEXT(GLsizei n, GLuint * textures)  {if (GLeeInit()) glGenTexturesEXT(n, textures);}
  GLEEPFNGLGENTEXTURESEXTPROC GLeeFuncPtr_glGenTexturesEXT=GLee_Lazy_glGenTexturesEXT;
#endif
#ifndef GLEE_C_DEFINED_glIsTextureEXT
#define GLEE_C_DEFINED_glIsTextureEXT
  GLboolean __stdcall GLee_Lazy_glIsTextureEXT(GLuint texture)  {if (GLeeInit()) return glIsTextureEXT(texture); return (GLboolean)0;}
  GLEEPFNGLISTEXTUREEXTPROC GLeeFuncPtr_glIsTextureEXT=GLee_Lazy_glIsTextureEXT;
#endif
#ifndef GLEE_C_DEFINED_glPrioritizeTexturesEXT
#define GLEE_C_DEFINED_glPrioritizeTexturesEXT
  void __stdcall GLee_Lazy_glPrioritizeTexturesEXT(GLsizei n, const GLuint * textures, const GLclampf * priorities)  {if (GLeeInit()) glPrioritizeTexturesEXT(n, textures, priorities);}
  GLEEPFNGLPRIORITIZETEXTURESEXTPROC GLeeFuncPtr_glPrioritizeTexturesEXT=GLee_Lazy_glPrioritizeTexturesEXT;
#endif
#endif 

/* GL_SGIS_detail_texture */

#ifdef __GLEE_GL_SGIS_detail_texture
#ifndef GLEE_C_DEFINED_glDetailTexFuncSGIS
#define GLEE_C_DEFINED_glDetailTexFuncSGIS
  void __stdcall GLee_Lazy_glDetailTexFuncSGIS(GLenum target, GLsizei n, const GLfloat * points)  {if (GLeeInit()) glDetailTexFuncSGIS(target, n, points);}
  GLEEPFNGLDETAILTEXFUNCSGISPROC GLeeFuncPtr_glDetailTexFuncSGIS=GLee_Lazy_glDetailTexFuncSGIS;
#endif
#ifndef GLEE_C_DEFINED_glGetDetailTexFuncSGIS
#define GLEE_C_DEFINED_glGetDetailTexFuncSGIS
  void __stdcall GLee_Lazy_glGetDetailTexFuncSGIS(GLenum target, GLfloat * points)  {if (GLeeInit()) glGetDetailTexFuncSGIS(target, points);}
  GLEEPFNGLGETDETAILTEXFUNCSGISPROC GLeeFuncPtr_glGetDetailTexFuncSGIS=GLee_Lazy_glGetDetailTexFuncSGIS;
#endif
#endif 

/* GL_SGIS_sharpen_texture */

#ifdef __GLEE_GL_SGIS_sharpen_texture
#ifndef GLEE_C_DEFINED_glSharpenTexFuncSGIS
#define GLEE_C_DEFINED_glSharpenTexFuncSGIS
  void __stdcall GLee_Lazy_glSharpenTexFuncSGIS(GLenum target, GLsizei n, const GLfloat * points)  {if (GLeeInit()) glSharpenTexFuncSGIS(target, n, points);}
  GLEEPFNGLSHARPENTEXFUNCSGISPROC GLeeFuncPtr_glSharpenTexFuncSGIS=GLee_Lazy_glSharpenTexFuncSGIS;
#endif
#ifndef GLEE_C_DEFINED_glGetSharpenTexFuncSGIS
#define GLEE_C_DEFINED_glGetSharpenTexFuncSGIS
  void __stdcall GLee_Lazy_glGetSharpenTexFuncSGIS(GLenum target, GLfloat * points)  {if (GLeeInit()) glGetSharpenTexFuncSGIS(target, points);}
  GLEEPFNGLGETSHARPENTEXFUNCSGISPROC GLeeFuncPtr_glGetSharpenTexFuncSGIS=GLee_Lazy_glGetSharpenTexFuncSGIS;
#endif
#endif 

/* GL_EXT_packed_pixels */

#ifdef __GLEE_GL_EXT_packed_pixels
#endif 

/* GL_SGIS_texture_lod */

#ifdef __GLEE_GL_SGIS_texture_lod
#endif 

/* GL_SGIS_multisample */

#ifdef __GLEE_GL_SGIS_multisample
#ifndef GLEE_C_DEFINED_glSampleMaskSGIS
#define GLEE_C_DEFINED_glSampleMaskSGIS
  void __stdcall GLee_Lazy_glSampleMaskSGIS(GLclampf value, GLboolean invert)  {if (GLeeInit()) glSampleMaskSGIS(value, invert);}
  GLEEPFNGLSAMPLEMASKSGISPROC GLeeFuncPtr_glSampleMaskSGIS=GLee_Lazy_glSampleMaskSGIS;
#endif
#ifndef GLEE_C_DEFINED_glSamplePatternSGIS
#define GLEE_C_DEFINED_glSamplePatternSGIS
  void __stdcall GLee_Lazy_glSamplePatternSGIS(GLenum pattern)  {if (GLeeInit()) glSamplePatternSGIS(pattern);}
  GLEEPFNGLSAMPLEPATTERNSGISPROC GLeeFuncPtr_glSamplePatternSGIS=GLee_Lazy_glSamplePatternSGIS;
#endif
#endif 

/* GL_EXT_rescale_normal */

#ifdef __GLEE_GL_EXT_rescale_normal
#endif 

/* GL_EXT_vertex_array */

#ifdef __GLEE_GL_EXT_vertex_array
#ifndef GLEE_C_DEFINED_glArrayElementEXT
#define GLEE_C_DEFINED_glArrayElementEXT
  void __stdcall GLee_Lazy_glArrayElementEXT(GLint i)  {if (GLeeInit()) glArrayElementEXT(i);}
  GLEEPFNGLARRAYELEMENTEXTPROC GLeeFuncPtr_glArrayElementEXT=GLee_Lazy_glArrayElementEXT;
#endif
#ifndef GLEE_C_DEFINED_glColorPointerEXT
#define GLEE_C_DEFINED_glColorPointerEXT
  void __stdcall GLee_Lazy_glColorPointerEXT(GLint size, GLenum type, GLsizei stride, GLsizei count, const GLvoid * pointer)  {if (GLeeInit()) glColorPointerEXT(size, type, stride, count, pointer);}
  GLEEPFNGLCOLORPOINTEREXTPROC GLeeFuncPtr_glColorPointerEXT=GLee_Lazy_glColorPointerEXT;
#endif
#ifndef GLEE_C_DEFINED_glDrawArraysEXT
#define GLEE_C_DEFINED_glDrawArraysEXT
  void __stdcall GLee_Lazy_glDrawArraysEXT(GLenum mode, GLint first, GLsizei count)  {if (GLeeInit()) glDrawArraysEXT(mode, first, count);}
  GLEEPFNGLDRAWARRAYSEXTPROC GLeeFuncPtr_glDrawArraysEXT=GLee_Lazy_glDrawArraysEXT;
#endif
#ifndef GLEE_C_DEFINED_glEdgeFlagPointerEXT
#define GLEE_C_DEFINED_glEdgeFlagPointerEXT
  void __stdcall GLee_Lazy_glEdgeFlagPointerEXT(GLsizei stride, GLsizei count, const GLboolean * pointer)  {if (GLeeInit()) glEdgeFlagPointerEXT(stride, count, pointer);}
  GLEEPFNGLEDGEFLAGPOINTEREXTPROC GLeeFuncPtr_glEdgeFlagPointerEXT=GLee_Lazy_glEdgeFlagPointerEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetPointervEXT
#define GLEE_C_DEFINED_glGetPointervEXT
  void __stdcall GLee_Lazy_glGetPointervEXT(GLenum pname, GLvoid* * params)  {if (GLeeInit()) glGetPointervEXT(pname, params);}
  GLEEPFNGLGETPOINTERVEXTPROC GLeeFuncPtr_glGetPointervEXT=GLee_Lazy_glGetPointervEXT;
#endif
#ifndef GLEE_C_DEFINED_glIndexPointerEXT
#define GLEE_C_DEFINED_glIndexPointerEXT
  void __stdcall GLee_Lazy_glIndexPointerEXT(GLenum type, GLsizei stride, GLsizei count, const GLvoid * pointer)  {if (GLeeInit()) glIndexPointerEXT(type, stride, count, pointer);}
  GLEEPFNGLINDEXPOINTEREXTPROC GLeeFuncPtr_glIndexPointerEXT=GLee_Lazy_glIndexPointerEXT;
#endif
#ifndef GLEE_C_DEFINED_glNormalPointerEXT
#define GLEE_C_DEFINED_glNormalPointerEXT
  void __stdcall GLee_Lazy_glNormalPointerEXT(GLenum type, GLsizei stride, GLsizei count, const GLvoid * pointer)  {if (GLeeInit()) glNormalPointerEXT(type, stride, count, pointer);}
  GLEEPFNGLNORMALPOINTEREXTPROC GLeeFuncPtr_glNormalPointerEXT=GLee_Lazy_glNormalPointerEXT;
#endif
#ifndef GLEE_C_DEFINED_glTexCoordPointerEXT
#define GLEE_C_DEFINED_glTexCoordPointerEXT
  void __stdcall GLee_Lazy_glTexCoordPointerEXT(GLint size, GLenum type, GLsizei stride, GLsizei count, const GLvoid * pointer)  {if (GLeeInit()) glTexCoordPointerEXT(size, type, stride, count, pointer);}
  GLEEPFNGLTEXCOORDPOINTEREXTPROC GLeeFuncPtr_glTexCoordPointerEXT=GLee_Lazy_glTexCoordPointerEXT;
#endif
#ifndef GLEE_C_DEFINED_glVertexPointerEXT
#define GLEE_C_DEFINED_glVertexPointerEXT
  void __stdcall GLee_Lazy_glVertexPointerEXT(GLint size, GLenum type, GLsizei stride, GLsizei count, const GLvoid * pointer)  {if (GLeeInit()) glVertexPointerEXT(size, type, stride, count, pointer);}
  GLEEPFNGLVERTEXPOINTEREXTPROC GLeeFuncPtr_glVertexPointerEXT=GLee_Lazy_glVertexPointerEXT;
#endif
#endif 

/* GL_EXT_misc_attribute */

#ifdef __GLEE_GL_EXT_misc_attribute
#endif 

/* GL_SGIS_generate_mipmap */

#ifdef __GLEE_GL_SGIS_generate_mipmap
#endif 

/* GL_SGIX_clipmap */

#ifdef __GLEE_GL_SGIX_clipmap
#endif 

/* GL_SGIX_shadow */

#ifdef __GLEE_GL_SGIX_shadow
#endif 

/* GL_SGIS_texture_edge_clamp */

#ifdef __GLEE_GL_SGIS_texture_edge_clamp
#endif 

/* GL_SGIS_texture_border_clamp */

#ifdef __GLEE_GL_SGIS_texture_border_clamp
#endif 

/* GL_EXT_blend_minmax */

#ifdef __GLEE_GL_EXT_blend_minmax
#ifndef GLEE_C_DEFINED_glBlendEquationEXT
#define GLEE_C_DEFINED_glBlendEquationEXT
  void __stdcall GLee_Lazy_glBlendEquationEXT(GLenum mode)  {if (GLeeInit()) glBlendEquationEXT(mode);}
  GLEEPFNGLBLENDEQUATIONEXTPROC GLeeFuncPtr_glBlendEquationEXT=GLee_Lazy_glBlendEquationEXT;
#endif
#endif 

/* GL_EXT_blend_subtract */

#ifdef __GLEE_GL_EXT_blend_subtract
#endif 

/* GL_EXT_blend_logic_op */

#ifdef __GLEE_GL_EXT_blend_logic_op
#endif 

/* GL_SGIX_interlace */

#ifdef __GLEE_GL_SGIX_interlace
#endif 

/* GL_SGIX_pixel_tiles */

#ifdef __GLEE_GL_SGIX_pixel_tiles
#endif 

/* GL_SGIS_texture_select */

#ifdef __GLEE_GL_SGIS_texture_select
#endif 

/* GL_SGIX_sprite */

#ifdef __GLEE_GL_SGIX_sprite
#ifndef GLEE_C_DEFINED_glSpriteParameterfSGIX
#define GLEE_C_DEFINED_glSpriteParameterfSGIX
  void __stdcall GLee_Lazy_glSpriteParameterfSGIX(GLenum pname, GLfloat param)  {if (GLeeInit()) glSpriteParameterfSGIX(pname, param);}
  GLEEPFNGLSPRITEPARAMETERFSGIXPROC GLeeFuncPtr_glSpriteParameterfSGIX=GLee_Lazy_glSpriteParameterfSGIX;
#endif
#ifndef GLEE_C_DEFINED_glSpriteParameterfvSGIX
#define GLEE_C_DEFINED_glSpriteParameterfvSGIX
  void __stdcall GLee_Lazy_glSpriteParameterfvSGIX(GLenum pname, const GLfloat * params)  {if (GLeeInit()) glSpriteParameterfvSGIX(pname, params);}
  GLEEPFNGLSPRITEPARAMETERFVSGIXPROC GLeeFuncPtr_glSpriteParameterfvSGIX=GLee_Lazy_glSpriteParameterfvSGIX;
#endif
#ifndef GLEE_C_DEFINED_glSpriteParameteriSGIX
#define GLEE_C_DEFINED_glSpriteParameteriSGIX
  void __stdcall GLee_Lazy_glSpriteParameteriSGIX(GLenum pname, GLint param)  {if (GLeeInit()) glSpriteParameteriSGIX(pname, param);}
  GLEEPFNGLSPRITEPARAMETERISGIXPROC GLeeFuncPtr_glSpriteParameteriSGIX=GLee_Lazy_glSpriteParameteriSGIX;
#endif
#ifndef GLEE_C_DEFINED_glSpriteParameterivSGIX
#define GLEE_C_DEFINED_glSpriteParameterivSGIX
  void __stdcall GLee_Lazy_glSpriteParameterivSGIX(GLenum pname, const GLint * params)  {if (GLeeInit()) glSpriteParameterivSGIX(pname, params);}
  GLEEPFNGLSPRITEPARAMETERIVSGIXPROC GLeeFuncPtr_glSpriteParameterivSGIX=GLee_Lazy_glSpriteParameterivSGIX;
#endif
#endif 

/* GL_SGIX_texture_multi_buffer */

#ifdef __GLEE_GL_SGIX_texture_multi_buffer
#endif 

/* GL_EXT_point_parameters */

#ifdef __GLEE_GL_EXT_point_parameters
#ifndef GLEE_C_DEFINED_glPointParameterfEXT
#define GLEE_C_DEFINED_glPointParameterfEXT
  void __stdcall GLee_Lazy_glPointParameterfEXT(GLenum pname, GLfloat param)  {if (GLeeInit()) glPointParameterfEXT(pname, param);}
  GLEEPFNGLPOINTPARAMETERFEXTPROC GLeeFuncPtr_glPointParameterfEXT=GLee_Lazy_glPointParameterfEXT;
#endif
#ifndef GLEE_C_DEFINED_glPointParameterfvEXT
#define GLEE_C_DEFINED_glPointParameterfvEXT
  void __stdcall GLee_Lazy_glPointParameterfvEXT(GLenum pname, const GLfloat * params)  {if (GLeeInit()) glPointParameterfvEXT(pname, params);}
  GLEEPFNGLPOINTPARAMETERFVEXTPROC GLeeFuncPtr_glPointParameterfvEXT=GLee_Lazy_glPointParameterfvEXT;
#endif
#endif 

/* GL_SGIS_point_parameters */

#ifdef __GLEE_GL_SGIS_point_parameters
#ifndef GLEE_C_DEFINED_glPointParameterfSGIS
#define GLEE_C_DEFINED_glPointParameterfSGIS
  void __stdcall GLee_Lazy_glPointParameterfSGIS(GLenum pname, GLfloat param)  {if (GLeeInit()) glPointParameterfSGIS(pname, param);}
  GLEEPFNGLPOINTPARAMETERFSGISPROC GLeeFuncPtr_glPointParameterfSGIS=GLee_Lazy_glPointParameterfSGIS;
#endif
#ifndef GLEE_C_DEFINED_glPointParameterfvSGIS
#define GLEE_C_DEFINED_glPointParameterfvSGIS
  void __stdcall GLee_Lazy_glPointParameterfvSGIS(GLenum pname, const GLfloat * params)  {if (GLeeInit()) glPointParameterfvSGIS(pname, params);}
  GLEEPFNGLPOINTPARAMETERFVSGISPROC GLeeFuncPtr_glPointParameterfvSGIS=GLee_Lazy_glPointParameterfvSGIS;
#endif
#endif 

/* GL_SGIX_instruments */

#ifdef __GLEE_GL_SGIX_instruments
#ifndef GLEE_C_DEFINED_glGetInstrumentsSGIX
#define GLEE_C_DEFINED_glGetInstrumentsSGIX
  GLint __stdcall GLee_Lazy_glGetInstrumentsSGIX(void)  {if (GLeeInit()) return glGetInstrumentsSGIX(); return (GLint)0;}
  GLEEPFNGLGETINSTRUMENTSSGIXPROC GLeeFuncPtr_glGetInstrumentsSGIX=GLee_Lazy_glGetInstrumentsSGIX;
#endif
#ifndef GLEE_C_DEFINED_glInstrumentsBufferSGIX
#define GLEE_C_DEFINED_glInstrumentsBufferSGIX
  void __stdcall GLee_Lazy_glInstrumentsBufferSGIX(GLsizei size, GLint * buffer)  {if (GLeeInit()) glInstrumentsBufferSGIX(size, buffer);}
  GLEEPFNGLINSTRUMENTSBUFFERSGIXPROC GLeeFuncPtr_glInstrumentsBufferSGIX=GLee_Lazy_glInstrumentsBufferSGIX;
#endif
#ifndef GLEE_C_DEFINED_glPollInstrumentsSGIX
#define GLEE_C_DEFINED_glPollInstrumentsSGIX
  GLint __stdcall GLee_Lazy_glPollInstrumentsSGIX(GLint * marker_p)  {if (GLeeInit()) return glPollInstrumentsSGIX(marker_p); return (GLint)0;}
  GLEEPFNGLPOLLINSTRUMENTSSGIXPROC GLeeFuncPtr_glPollInstrumentsSGIX=GLee_Lazy_glPollInstrumentsSGIX;
#endif
#ifndef GLEE_C_DEFINED_glReadInstrumentsSGIX
#define GLEE_C_DEFINED_glReadInstrumentsSGIX
  void __stdcall GLee_Lazy_glReadInstrumentsSGIX(GLint marker)  {if (GLeeInit()) glReadInstrumentsSGIX(marker);}
  GLEEPFNGLREADINSTRUMENTSSGIXPROC GLeeFuncPtr_glReadInstrumentsSGIX=GLee_Lazy_glReadInstrumentsSGIX;
#endif
#ifndef GLEE_C_DEFINED_glStartInstrumentsSGIX
#define GLEE_C_DEFINED_glStartInstrumentsSGIX
  void __stdcall GLee_Lazy_glStartInstrumentsSGIX(void)  {if (GLeeInit()) glStartInstrumentsSGIX();}
  GLEEPFNGLSTARTINSTRUMENTSSGIXPROC GLeeFuncPtr_glStartInstrumentsSGIX=GLee_Lazy_glStartInstrumentsSGIX;
#endif
#ifndef GLEE_C_DEFINED_glStopInstrumentsSGIX
#define GLEE_C_DEFINED_glStopInstrumentsSGIX
  void __stdcall GLee_Lazy_glStopInstrumentsSGIX(GLint marker)  {if (GLeeInit()) glStopInstrumentsSGIX(marker);}
  GLEEPFNGLSTOPINSTRUMENTSSGIXPROC GLeeFuncPtr_glStopInstrumentsSGIX=GLee_Lazy_glStopInstrumentsSGIX;
#endif
#endif 

/* GL_SGIX_texture_scale_bias */

#ifdef __GLEE_GL_SGIX_texture_scale_bias
#endif 

/* GL_SGIX_framezoom */

#ifdef __GLEE_GL_SGIX_framezoom
#ifndef GLEE_C_DEFINED_glFrameZoomSGIX
#define GLEE_C_DEFINED_glFrameZoomSGIX
  void __stdcall GLee_Lazy_glFrameZoomSGIX(GLint factor)  {if (GLeeInit()) glFrameZoomSGIX(factor);}
  GLEEPFNGLFRAMEZOOMSGIXPROC GLeeFuncPtr_glFrameZoomSGIX=GLee_Lazy_glFrameZoomSGIX;
#endif
#endif 

/* GL_SGIX_tag_sample_buffer */

#ifdef __GLEE_GL_SGIX_tag_sample_buffer
#ifndef GLEE_C_DEFINED_glTagSampleBufferSGIX
#define GLEE_C_DEFINED_glTagSampleBufferSGIX
  void __stdcall GLee_Lazy_glTagSampleBufferSGIX(void)  {if (GLeeInit()) glTagSampleBufferSGIX();}
  GLEEPFNGLTAGSAMPLEBUFFERSGIXPROC GLeeFuncPtr_glTagSampleBufferSGIX=GLee_Lazy_glTagSampleBufferSGIX;
#endif
#endif 

/* GL_FfdMaskSGIX */

#ifdef __GLEE_GL_FfdMaskSGIX
#endif 

/* GL_SGIX_polynomial_ffd */

#ifdef __GLEE_GL_SGIX_polynomial_ffd
#ifndef GLEE_C_DEFINED_glDeformationMap3dSGIX
#define GLEE_C_DEFINED_glDeformationMap3dSGIX
  void __stdcall GLee_Lazy_glDeformationMap3dSGIX(GLenum target, GLdouble u1, GLdouble u2, GLint ustride, GLint uorder, GLdouble v1, GLdouble v2, GLint vstride, GLint vorder, GLdouble w1, GLdouble w2, GLint wstride, GLint worder, const GLdouble * points)  {if (GLeeInit()) glDeformationMap3dSGIX(target, u1, u2, ustride, uorder, v1, v2, vstride, vorder, w1, w2, wstride, worder, points);}
  GLEEPFNGLDEFORMATIONMAP3DSGIXPROC GLeeFuncPtr_glDeformationMap3dSGIX=GLee_Lazy_glDeformationMap3dSGIX;
#endif
#ifndef GLEE_C_DEFINED_glDeformationMap3fSGIX
#define GLEE_C_DEFINED_glDeformationMap3fSGIX
  void __stdcall GLee_Lazy_glDeformationMap3fSGIX(GLenum target, GLfloat u1, GLfloat u2, GLint ustride, GLint uorder, GLfloat v1, GLfloat v2, GLint vstride, GLint vorder, GLfloat w1, GLfloat w2, GLint wstride, GLint worder, const GLfloat * points)  {if (GLeeInit()) glDeformationMap3fSGIX(target, u1, u2, ustride, uorder, v1, v2, vstride, vorder, w1, w2, wstride, worder, points);}
  GLEEPFNGLDEFORMATIONMAP3FSGIXPROC GLeeFuncPtr_glDeformationMap3fSGIX=GLee_Lazy_glDeformationMap3fSGIX;
#endif
#ifndef GLEE_C_DEFINED_glDeformSGIX
#define GLEE_C_DEFINED_glDeformSGIX
  void __stdcall GLee_Lazy_glDeformSGIX(GLbitfield mask)  {if (GLeeInit()) glDeformSGIX(mask);}
  GLEEPFNGLDEFORMSGIXPROC GLeeFuncPtr_glDeformSGIX=GLee_Lazy_glDeformSGIX;
#endif
#ifndef GLEE_C_DEFINED_glLoadIdentityDeformationMapSGIX
#define GLEE_C_DEFINED_glLoadIdentityDeformationMapSGIX
  void __stdcall GLee_Lazy_glLoadIdentityDeformationMapSGIX(GLbitfield mask)  {if (GLeeInit()) glLoadIdentityDeformationMapSGIX(mask);}
  GLEEPFNGLLOADIDENTITYDEFORMATIONMAPSGIXPROC GLeeFuncPtr_glLoadIdentityDeformationMapSGIX=GLee_Lazy_glLoadIdentityDeformationMapSGIX;
#endif
#endif 

/* GL_SGIX_reference_plane */

#ifdef __GLEE_GL_SGIX_reference_plane
#ifndef GLEE_C_DEFINED_glReferencePlaneSGIX
#define GLEE_C_DEFINED_glReferencePlaneSGIX
  void __stdcall GLee_Lazy_glReferencePlaneSGIX(const GLdouble * equation)  {if (GLeeInit()) glReferencePlaneSGIX(equation);}
  GLEEPFNGLREFERENCEPLANESGIXPROC GLeeFuncPtr_glReferencePlaneSGIX=GLee_Lazy_glReferencePlaneSGIX;
#endif
#endif 

/* GL_SGIX_flush_raster */

#ifdef __GLEE_GL_SGIX_flush_raster
#ifndef GLEE_C_DEFINED_glFlushRasterSGIX
#define GLEE_C_DEFINED_glFlushRasterSGIX
  void __stdcall GLee_Lazy_glFlushRasterSGIX(void)  {if (GLeeInit()) glFlushRasterSGIX();}
  GLEEPFNGLFLUSHRASTERSGIXPROC GLeeFuncPtr_glFlushRasterSGIX=GLee_Lazy_glFlushRasterSGIX;
#endif
#endif 

/* GL_SGIX_depth_texture */

#ifdef __GLEE_GL_SGIX_depth_texture
#endif 

/* GL_SGIS_fog_function */

#ifdef __GLEE_GL_SGIS_fog_function
#ifndef GLEE_C_DEFINED_glFogFuncSGIS
#define GLEE_C_DEFINED_glFogFuncSGIS
  void __stdcall GLee_Lazy_glFogFuncSGIS(GLsizei n, const GLfloat * points)  {if (GLeeInit()) glFogFuncSGIS(n, points);}
  GLEEPFNGLFOGFUNCSGISPROC GLeeFuncPtr_glFogFuncSGIS=GLee_Lazy_glFogFuncSGIS;
#endif
#ifndef GLEE_C_DEFINED_glGetFogFuncSGIS
#define GLEE_C_DEFINED_glGetFogFuncSGIS
  void __stdcall GLee_Lazy_glGetFogFuncSGIS(GLfloat * points)  {if (GLeeInit()) glGetFogFuncSGIS(points);}
  GLEEPFNGLGETFOGFUNCSGISPROC GLeeFuncPtr_glGetFogFuncSGIS=GLee_Lazy_glGetFogFuncSGIS;
#endif
#endif 

/* GL_SGIX_fog_offset */

#ifdef __GLEE_GL_SGIX_fog_offset
#endif 

/* GL_HP_image_transform */

#ifdef __GLEE_GL_HP_image_transform
#ifndef GLEE_C_DEFINED_glImageTransformParameteriHP
#define GLEE_C_DEFINED_glImageTransformParameteriHP
  void __stdcall GLee_Lazy_glImageTransformParameteriHP(GLenum target, GLenum pname, GLint param)  {if (GLeeInit()) glImageTransformParameteriHP(target, pname, param);}
  GLEEPFNGLIMAGETRANSFORMPARAMETERIHPPROC GLeeFuncPtr_glImageTransformParameteriHP=GLee_Lazy_glImageTransformParameteriHP;
#endif
#ifndef GLEE_C_DEFINED_glImageTransformParameterfHP
#define GLEE_C_DEFINED_glImageTransformParameterfHP
  void __stdcall GLee_Lazy_glImageTransformParameterfHP(GLenum target, GLenum pname, GLfloat param)  {if (GLeeInit()) glImageTransformParameterfHP(target, pname, param);}
  GLEEPFNGLIMAGETRANSFORMPARAMETERFHPPROC GLeeFuncPtr_glImageTransformParameterfHP=GLee_Lazy_glImageTransformParameterfHP;
#endif
#ifndef GLEE_C_DEFINED_glImageTransformParameterivHP
#define GLEE_C_DEFINED_glImageTransformParameterivHP
  void __stdcall GLee_Lazy_glImageTransformParameterivHP(GLenum target, GLenum pname, const GLint * params)  {if (GLeeInit()) glImageTransformParameterivHP(target, pname, params);}
  GLEEPFNGLIMAGETRANSFORMPARAMETERIVHPPROC GLeeFuncPtr_glImageTransformParameterivHP=GLee_Lazy_glImageTransformParameterivHP;
#endif
#ifndef GLEE_C_DEFINED_glImageTransformParameterfvHP
#define GLEE_C_DEFINED_glImageTransformParameterfvHP
  void __stdcall GLee_Lazy_glImageTransformParameterfvHP(GLenum target, GLenum pname, const GLfloat * params)  {if (GLeeInit()) glImageTransformParameterfvHP(target, pname, params);}
  GLEEPFNGLIMAGETRANSFORMPARAMETERFVHPPROC GLeeFuncPtr_glImageTransformParameterfvHP=GLee_Lazy_glImageTransformParameterfvHP;
#endif
#ifndef GLEE_C_DEFINED_glGetImageTransformParameterivHP
#define GLEE_C_DEFINED_glGetImageTransformParameterivHP
  void __stdcall GLee_Lazy_glGetImageTransformParameterivHP(GLenum target, GLenum pname, GLint * params)  {if (GLeeInit()) glGetImageTransformParameterivHP(target, pname, params);}
  GLEEPFNGLGETIMAGETRANSFORMPARAMETERIVHPPROC GLeeFuncPtr_glGetImageTransformParameterivHP=GLee_Lazy_glGetImageTransformParameterivHP;
#endif
#ifndef GLEE_C_DEFINED_glGetImageTransformParameterfvHP
#define GLEE_C_DEFINED_glGetImageTransformParameterfvHP
  void __stdcall GLee_Lazy_glGetImageTransformParameterfvHP(GLenum target, GLenum pname, GLfloat * params)  {if (GLeeInit()) glGetImageTransformParameterfvHP(target, pname, params);}
  GLEEPFNGLGETIMAGETRANSFORMPARAMETERFVHPPROC GLeeFuncPtr_glGetImageTransformParameterfvHP=GLee_Lazy_glGetImageTransformParameterfvHP;
#endif
#endif 

/* GL_HP_convolution_border_modes */

#ifdef __GLEE_GL_HP_convolution_border_modes
#endif 

/* GL_INGR_palette_buffer */

#ifdef __GLEE_GL_INGR_palette_buffer
#endif 

/* GL_SGIX_texture_add_env */

#ifdef __GLEE_GL_SGIX_texture_add_env
#endif 

/* GL_EXT_color_subtable */

#ifdef __GLEE_GL_EXT_color_subtable
#ifndef GLEE_C_DEFINED_glColorSubTableEXT
#define GLEE_C_DEFINED_glColorSubTableEXT
  void __stdcall GLee_Lazy_glColorSubTableEXT(GLenum target, GLsizei start, GLsizei count, GLenum format, GLenum type, const GLvoid * data)  {if (GLeeInit()) glColorSubTableEXT(target, start, count, format, type, data);}
  GLEEPFNGLCOLORSUBTABLEEXTPROC GLeeFuncPtr_glColorSubTableEXT=GLee_Lazy_glColorSubTableEXT;
#endif
#ifndef GLEE_C_DEFINED_glCopyColorSubTableEXT
#define GLEE_C_DEFINED_glCopyColorSubTableEXT
  void __stdcall GLee_Lazy_glCopyColorSubTableEXT(GLenum target, GLsizei start, GLint x, GLint y, GLsizei width)  {if (GLeeInit()) glCopyColorSubTableEXT(target, start, x, y, width);}
  GLEEPFNGLCOPYCOLORSUBTABLEEXTPROC GLeeFuncPtr_glCopyColorSubTableEXT=GLee_Lazy_glCopyColorSubTableEXT;
#endif
#endif 

/* GL_PGI_vertex_hints */

#ifdef __GLEE_GL_PGI_vertex_hints
#endif 

/* GL_PGI_misc_hints */

#ifdef __GLEE_GL_PGI_misc_hints
#ifndef GLEE_C_DEFINED_glHintPGI
#define GLEE_C_DEFINED_glHintPGI
  void __stdcall GLee_Lazy_glHintPGI(GLenum target, GLint mode)  {if (GLeeInit()) glHintPGI(target, mode);}
  GLEEPFNGLHINTPGIPROC GLeeFuncPtr_glHintPGI=GLee_Lazy_glHintPGI;
#endif
#endif 

/* GL_EXT_paletted_texture */

#ifdef __GLEE_GL_EXT_paletted_texture
#ifndef GLEE_C_DEFINED_glColorTableEXT
#define GLEE_C_DEFINED_glColorTableEXT
  void __stdcall GLee_Lazy_glColorTableEXT(GLenum target, GLenum internalFormat, GLsizei width, GLenum format, GLenum type, const GLvoid * table)  {if (GLeeInit()) glColorTableEXT(target, internalFormat, width, format, type, table);}
  GLEEPFNGLCOLORTABLEEXTPROC GLeeFuncPtr_glColorTableEXT=GLee_Lazy_glColorTableEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetColorTableEXT
#define GLEE_C_DEFINED_glGetColorTableEXT
  void __stdcall GLee_Lazy_glGetColorTableEXT(GLenum target, GLenum format, GLenum type, GLvoid * data)  {if (GLeeInit()) glGetColorTableEXT(target, format, type, data);}
  GLEEPFNGLGETCOLORTABLEEXTPROC GLeeFuncPtr_glGetColorTableEXT=GLee_Lazy_glGetColorTableEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetColorTableParameterivEXT
#define GLEE_C_DEFINED_glGetColorTableParameterivEXT
  void __stdcall GLee_Lazy_glGetColorTableParameterivEXT(GLenum target, GLenum pname, GLint * params)  {if (GLeeInit()) glGetColorTableParameterivEXT(target, pname, params);}
  GLEEPFNGLGETCOLORTABLEPARAMETERIVEXTPROC GLeeFuncPtr_glGetColorTableParameterivEXT=GLee_Lazy_glGetColorTableParameterivEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetColorTableParameterfvEXT
#define GLEE_C_DEFINED_glGetColorTableParameterfvEXT
  void __stdcall GLee_Lazy_glGetColorTableParameterfvEXT(GLenum target, GLenum pname, GLfloat * params)  {if (GLeeInit()) glGetColorTableParameterfvEXT(target, pname, params);}
  GLEEPFNGLGETCOLORTABLEPARAMETERFVEXTPROC GLeeFuncPtr_glGetColorTableParameterfvEXT=GLee_Lazy_glGetColorTableParameterfvEXT;
#endif
#endif 

/* GL_EXT_clip_volume_hint */

#ifdef __GLEE_GL_EXT_clip_volume_hint
#endif 

/* GL_SGIX_list_priority */

#ifdef __GLEE_GL_SGIX_list_priority
#ifndef GLEE_C_DEFINED_glGetListParameterfvSGIX
#define GLEE_C_DEFINED_glGetListParameterfvSGIX
  void __stdcall GLee_Lazy_glGetListParameterfvSGIX(GLuint list, GLenum pname, GLfloat * params)  {if (GLeeInit()) glGetListParameterfvSGIX(list, pname, params);}
  GLEEPFNGLGETLISTPARAMETERFVSGIXPROC GLeeFuncPtr_glGetListParameterfvSGIX=GLee_Lazy_glGetListParameterfvSGIX;
#endif
#ifndef GLEE_C_DEFINED_glGetListParameterivSGIX
#define GLEE_C_DEFINED_glGetListParameterivSGIX
  void __stdcall GLee_Lazy_glGetListParameterivSGIX(GLuint list, GLenum pname, GLint * params)  {if (GLeeInit()) glGetListParameterivSGIX(list, pname, params);}
  GLEEPFNGLGETLISTPARAMETERIVSGIXPROC GLeeFuncPtr_glGetListParameterivSGIX=GLee_Lazy_glGetListParameterivSGIX;
#endif
#ifndef GLEE_C_DEFINED_glListParameterfSGIX
#define GLEE_C_DEFINED_glListParameterfSGIX
  void __stdcall GLee_Lazy_glListParameterfSGIX(GLuint list, GLenum pname, GLfloat param)  {if (GLeeInit()) glListParameterfSGIX(list, pname, param);}
  GLEEPFNGLLISTPARAMETERFSGIXPROC GLeeFuncPtr_glListParameterfSGIX=GLee_Lazy_glListParameterfSGIX;
#endif
#ifndef GLEE_C_DEFINED_glListParameterfvSGIX
#define GLEE_C_DEFINED_glListParameterfvSGIX
  void __stdcall GLee_Lazy_glListParameterfvSGIX(GLuint list, GLenum pname, const GLfloat * params)  {if (GLeeInit()) glListParameterfvSGIX(list, pname, params);}
  GLEEPFNGLLISTPARAMETERFVSGIXPROC GLeeFuncPtr_glListParameterfvSGIX=GLee_Lazy_glListParameterfvSGIX;
#endif
#ifndef GLEE_C_DEFINED_glListParameteriSGIX
#define GLEE_C_DEFINED_glListParameteriSGIX
  void __stdcall GLee_Lazy_glListParameteriSGIX(GLuint list, GLenum pname, GLint param)  {if (GLeeInit()) glListParameteriSGIX(list, pname, param);}
  GLEEPFNGLLISTPARAMETERISGIXPROC GLeeFuncPtr_glListParameteriSGIX=GLee_Lazy_glListParameteriSGIX;
#endif
#ifndef GLEE_C_DEFINED_glListParameterivSGIX
#define GLEE_C_DEFINED_glListParameterivSGIX
  void __stdcall GLee_Lazy_glListParameterivSGIX(GLuint list, GLenum pname, const GLint * params)  {if (GLeeInit()) glListParameterivSGIX(list, pname, params);}
  GLEEPFNGLLISTPARAMETERIVSGIXPROC GLeeFuncPtr_glListParameterivSGIX=GLee_Lazy_glListParameterivSGIX;
#endif
#endif 

/* GL_SGIX_ir_instrument1 */

#ifdef __GLEE_GL_SGIX_ir_instrument1
#endif 

/* GL_SGIX_calligraphic_fragment */

#ifdef __GLEE_GL_SGIX_calligraphic_fragment
#endif 

/* GL_SGIX_texture_lod_bias */

#ifdef __GLEE_GL_SGIX_texture_lod_bias
#endif 

/* GL_SGIX_shadow_ambient */

#ifdef __GLEE_GL_SGIX_shadow_ambient
#endif 

/* GL_EXT_index_texture */

#ifdef __GLEE_GL_EXT_index_texture
#endif 

/* GL_EXT_index_material */

#ifdef __GLEE_GL_EXT_index_material
#ifndef GLEE_C_DEFINED_glIndexMaterialEXT
#define GLEE_C_DEFINED_glIndexMaterialEXT
  void __stdcall GLee_Lazy_glIndexMaterialEXT(GLenum face, GLenum mode)  {if (GLeeInit()) glIndexMaterialEXT(face, mode);}
  GLEEPFNGLINDEXMATERIALEXTPROC GLeeFuncPtr_glIndexMaterialEXT=GLee_Lazy_glIndexMaterialEXT;
#endif
#endif 

/* GL_EXT_index_func */

#ifdef __GLEE_GL_EXT_index_func
#ifndef GLEE_C_DEFINED_glIndexFuncEXT
#define GLEE_C_DEFINED_glIndexFuncEXT
  void __stdcall GLee_Lazy_glIndexFuncEXT(GLenum func, GLclampf ref)  {if (GLeeInit()) glIndexFuncEXT(func, ref);}
  GLEEPFNGLINDEXFUNCEXTPROC GLeeFuncPtr_glIndexFuncEXT=GLee_Lazy_glIndexFuncEXT;
#endif
#endif 

/* GL_EXT_index_array_formats */

#ifdef __GLEE_GL_EXT_index_array_formats
#endif 

/* GL_EXT_compiled_vertex_array */

#ifdef __GLEE_GL_EXT_compiled_vertex_array
#ifndef GLEE_C_DEFINED_glLockArraysEXT
#define GLEE_C_DEFINED_glLockArraysEXT
  void __stdcall GLee_Lazy_glLockArraysEXT(GLint first, GLsizei count)  {if (GLeeInit()) glLockArraysEXT(first, count);}
  GLEEPFNGLLOCKARRAYSEXTPROC GLeeFuncPtr_glLockArraysEXT=GLee_Lazy_glLockArraysEXT;
#endif
#ifndef GLEE_C_DEFINED_glUnlockArraysEXT
#define GLEE_C_DEFINED_glUnlockArraysEXT
  void __stdcall GLee_Lazy_glUnlockArraysEXT(void)  {if (GLeeInit()) glUnlockArraysEXT();}
  GLEEPFNGLUNLOCKARRAYSEXTPROC GLeeFuncPtr_glUnlockArraysEXT=GLee_Lazy_glUnlockArraysEXT;
#endif
#endif 

/* GL_EXT_cull_vertex */

#ifdef __GLEE_GL_EXT_cull_vertex
#ifndef GLEE_C_DEFINED_glCullParameterdvEXT
#define GLEE_C_DEFINED_glCullParameterdvEXT
  void __stdcall GLee_Lazy_glCullParameterdvEXT(GLenum pname, GLdouble * params)  {if (GLeeInit()) glCullParameterdvEXT(pname, params);}
  GLEEPFNGLCULLPARAMETERDVEXTPROC GLeeFuncPtr_glCullParameterdvEXT=GLee_Lazy_glCullParameterdvEXT;
#endif
#ifndef GLEE_C_DEFINED_glCullParameterfvEXT
#define GLEE_C_DEFINED_glCullParameterfvEXT
  void __stdcall GLee_Lazy_glCullParameterfvEXT(GLenum pname, GLfloat * params)  {if (GLeeInit()) glCullParameterfvEXT(pname, params);}
  GLEEPFNGLCULLPARAMETERFVEXTPROC GLeeFuncPtr_glCullParameterfvEXT=GLee_Lazy_glCullParameterfvEXT;
#endif
#endif 

/* GL_SGIX_ycrcb */

#ifdef __GLEE_GL_SGIX_ycrcb
#endif 

/* GL_SGIX_fragment_lighting */

#ifdef __GLEE_GL_SGIX_fragment_lighting
#ifndef GLEE_C_DEFINED_glFragmentColorMaterialSGIX
#define GLEE_C_DEFINED_glFragmentColorMaterialSGIX
  void __stdcall GLee_Lazy_glFragmentColorMaterialSGIX(GLenum face, GLenum mode)  {if (GLeeInit()) glFragmentColorMaterialSGIX(face, mode);}
  GLEEPFNGLFRAGMENTCOLORMATERIALSGIXPROC GLeeFuncPtr_glFragmentColorMaterialSGIX=GLee_Lazy_glFragmentColorMaterialSGIX;
#endif
#ifndef GLEE_C_DEFINED_glFragmentLightfSGIX
#define GLEE_C_DEFINED_glFragmentLightfSGIX
  void __stdcall GLee_Lazy_glFragmentLightfSGIX(GLenum light, GLenum pname, GLfloat param)  {if (GLeeInit()) glFragmentLightfSGIX(light, pname, param);}
  GLEEPFNGLFRAGMENTLIGHTFSGIXPROC GLeeFuncPtr_glFragmentLightfSGIX=GLee_Lazy_glFragmentLightfSGIX;
#endif
#ifndef GLEE_C_DEFINED_glFragmentLightfvSGIX
#define GLEE_C_DEFINED_glFragmentLightfvSGIX
  void __stdcall GLee_Lazy_glFragmentLightfvSGIX(GLenum light, GLenum pname, const GLfloat * params)  {if (GLeeInit()) glFragmentLightfvSGIX(light, pname, params);}
  GLEEPFNGLFRAGMENTLIGHTFVSGIXPROC GLeeFuncPtr_glFragmentLightfvSGIX=GLee_Lazy_glFragmentLightfvSGIX;
#endif
#ifndef GLEE_C_DEFINED_glFragmentLightiSGIX
#define GLEE_C_DEFINED_glFragmentLightiSGIX
  void __stdcall GLee_Lazy_glFragmentLightiSGIX(GLenum light, GLenum pname, GLint param)  {if (GLeeInit()) glFragmentLightiSGIX(light, pname, param);}
  GLEEPFNGLFRAGMENTLIGHTISGIXPROC GLeeFuncPtr_glFragmentLightiSGIX=GLee_Lazy_glFragmentLightiSGIX;
#endif
#ifndef GLEE_C_DEFINED_glFragmentLightivSGIX
#define GLEE_C_DEFINED_glFragmentLightivSGIX
  void __stdcall GLee_Lazy_glFragmentLightivSGIX(GLenum light, GLenum pname, const GLint * params)  {if (GLeeInit()) glFragmentLightivSGIX(light, pname, params);}
  GLEEPFNGLFRAGMENTLIGHTIVSGIXPROC GLeeFuncPtr_glFragmentLightivSGIX=GLee_Lazy_glFragmentLightivSGIX;
#endif
#ifndef GLEE_C_DEFINED_glFragmentLightModelfSGIX
#define GLEE_C_DEFINED_glFragmentLightModelfSGIX
  void __stdcall GLee_Lazy_glFragmentLightModelfSGIX(GLenum pname, GLfloat param)  {if (GLeeInit()) glFragmentLightModelfSGIX(pname, param);}
  GLEEPFNGLFRAGMENTLIGHTMODELFSGIXPROC GLeeFuncPtr_glFragmentLightModelfSGIX=GLee_Lazy_glFragmentLightModelfSGIX;
#endif
#ifndef GLEE_C_DEFINED_glFragmentLightModelfvSGIX
#define GLEE_C_DEFINED_glFragmentLightModelfvSGIX
  void __stdcall GLee_Lazy_glFragmentLightModelfvSGIX(GLenum pname, const GLfloat * params)  {if (GLeeInit()) glFragmentLightModelfvSGIX(pname, params);}
  GLEEPFNGLFRAGMENTLIGHTMODELFVSGIXPROC GLeeFuncPtr_glFragmentLightModelfvSGIX=GLee_Lazy_glFragmentLightModelfvSGIX;
#endif
#ifndef GLEE_C_DEFINED_glFragmentLightModeliSGIX
#define GLEE_C_DEFINED_glFragmentLightModeliSGIX
  void __stdcall GLee_Lazy_glFragmentLightModeliSGIX(GLenum pname, GLint param)  {if (GLeeInit()) glFragmentLightModeliSGIX(pname, param);}
  GLEEPFNGLFRAGMENTLIGHTMODELISGIXPROC GLeeFuncPtr_glFragmentLightModeliSGIX=GLee_Lazy_glFragmentLightModeliSGIX;
#endif
#ifndef GLEE_C_DEFINED_glFragmentLightModelivSGIX
#define GLEE_C_DEFINED_glFragmentLightModelivSGIX
  void __stdcall GLee_Lazy_glFragmentLightModelivSGIX(GLenum pname, const GLint * params)  {if (GLeeInit()) glFragmentLightModelivSGIX(pname, params);}
  GLEEPFNGLFRAGMENTLIGHTMODELIVSGIXPROC GLeeFuncPtr_glFragmentLightModelivSGIX=GLee_Lazy_glFragmentLightModelivSGIX;
#endif
#ifndef GLEE_C_DEFINED_glFragmentMaterialfSGIX
#define GLEE_C_DEFINED_glFragmentMaterialfSGIX
  void __stdcall GLee_Lazy_glFragmentMaterialfSGIX(GLenum face, GLenum pname, GLfloat param)  {if (GLeeInit()) glFragmentMaterialfSGIX(face, pname, param);}
  GLEEPFNGLFRAGMENTMATERIALFSGIXPROC GLeeFuncPtr_glFragmentMaterialfSGIX=GLee_Lazy_glFragmentMaterialfSGIX;
#endif
#ifndef GLEE_C_DEFINED_glFragmentMaterialfvSGIX
#define GLEE_C_DEFINED_glFragmentMaterialfvSGIX
  void __stdcall GLee_Lazy_glFragmentMaterialfvSGIX(GLenum face, GLenum pname, const GLfloat * params)  {if (GLeeInit()) glFragmentMaterialfvSGIX(face, pname, params);}
  GLEEPFNGLFRAGMENTMATERIALFVSGIXPROC GLeeFuncPtr_glFragmentMaterialfvSGIX=GLee_Lazy_glFragmentMaterialfvSGIX;
#endif
#ifndef GLEE_C_DEFINED_glFragmentMaterialiSGIX
#define GLEE_C_DEFINED_glFragmentMaterialiSGIX
  void __stdcall GLee_Lazy_glFragmentMaterialiSGIX(GLenum face, GLenum pname, GLint param)  {if (GLeeInit()) glFragmentMaterialiSGIX(face, pname, param);}
  GLEEPFNGLFRAGMENTMATERIALISGIXPROC GLeeFuncPtr_glFragmentMaterialiSGIX=GLee_Lazy_glFragmentMaterialiSGIX;
#endif
#ifndef GLEE_C_DEFINED_glFragmentMaterialivSGIX
#define GLEE_C_DEFINED_glFragmentMaterialivSGIX
  void __stdcall GLee_Lazy_glFragmentMaterialivSGIX(GLenum face, GLenum pname, const GLint * params)  {if (GLeeInit()) glFragmentMaterialivSGIX(face, pname, params);}
  GLEEPFNGLFRAGMENTMATERIALIVSGIXPROC GLeeFuncPtr_glFragmentMaterialivSGIX=GLee_Lazy_glFragmentMaterialivSGIX;
#endif
#ifndef GLEE_C_DEFINED_glGetFragmentLightfvSGIX
#define GLEE_C_DEFINED_glGetFragmentLightfvSGIX
  void __stdcall GLee_Lazy_glGetFragmentLightfvSGIX(GLenum light, GLenum pname, GLfloat * params)  {if (GLeeInit()) glGetFragmentLightfvSGIX(light, pname, params);}
  GLEEPFNGLGETFRAGMENTLIGHTFVSGIXPROC GLeeFuncPtr_glGetFragmentLightfvSGIX=GLee_Lazy_glGetFragmentLightfvSGIX;
#endif
#ifndef GLEE_C_DEFINED_glGetFragmentLightivSGIX
#define GLEE_C_DEFINED_glGetFragmentLightivSGIX
  void __stdcall GLee_Lazy_glGetFragmentLightivSGIX(GLenum light, GLenum pname, GLint * params)  {if (GLeeInit()) glGetFragmentLightivSGIX(light, pname, params);}
  GLEEPFNGLGETFRAGMENTLIGHTIVSGIXPROC GLeeFuncPtr_glGetFragmentLightivSGIX=GLee_Lazy_glGetFragmentLightivSGIX;
#endif
#ifndef GLEE_C_DEFINED_glGetFragmentMaterialfvSGIX
#define GLEE_C_DEFINED_glGetFragmentMaterialfvSGIX
  void __stdcall GLee_Lazy_glGetFragmentMaterialfvSGIX(GLenum face, GLenum pname, GLfloat * params)  {if (GLeeInit()) glGetFragmentMaterialfvSGIX(face, pname, params);}
  GLEEPFNGLGETFRAGMENTMATERIALFVSGIXPROC GLeeFuncPtr_glGetFragmentMaterialfvSGIX=GLee_Lazy_glGetFragmentMaterialfvSGIX;
#endif
#ifndef GLEE_C_DEFINED_glGetFragmentMaterialivSGIX
#define GLEE_C_DEFINED_glGetFragmentMaterialivSGIX
  void __stdcall GLee_Lazy_glGetFragmentMaterialivSGIX(GLenum face, GLenum pname, GLint * params)  {if (GLeeInit()) glGetFragmentMaterialivSGIX(face, pname, params);}
  GLEEPFNGLGETFRAGMENTMATERIALIVSGIXPROC GLeeFuncPtr_glGetFragmentMaterialivSGIX=GLee_Lazy_glGetFragmentMaterialivSGIX;
#endif
#ifndef GLEE_C_DEFINED_glLightEnviSGIX
#define GLEE_C_DEFINED_glLightEnviSGIX
  void __stdcall GLee_Lazy_glLightEnviSGIX(GLenum pname, GLint param)  {if (GLeeInit()) glLightEnviSGIX(pname, param);}
  GLEEPFNGLLIGHTENVISGIXPROC GLeeFuncPtr_glLightEnviSGIX=GLee_Lazy_glLightEnviSGIX;
#endif
#endif 

/* GL_IBM_rasterpos_clip */

#ifdef __GLEE_GL_IBM_rasterpos_clip
#endif 

/* GL_HP_texture_lighting */

#ifdef __GLEE_GL_HP_texture_lighting
#endif 

/* GL_EXT_draw_range_elements */

#ifdef __GLEE_GL_EXT_draw_range_elements
#ifndef GLEE_C_DEFINED_glDrawRangeElementsEXT
#define GLEE_C_DEFINED_glDrawRangeElementsEXT
  void __stdcall GLee_Lazy_glDrawRangeElementsEXT(GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const GLvoid * indices)  {if (GLeeInit()) glDrawRangeElementsEXT(mode, start, end, count, type, indices);}
  GLEEPFNGLDRAWRANGEELEMENTSEXTPROC GLeeFuncPtr_glDrawRangeElementsEXT=GLee_Lazy_glDrawRangeElementsEXT;
#endif
#endif 

/* GL_WIN_phong_shading */

#ifdef __GLEE_GL_WIN_phong_shading
#endif 

/* GL_WIN_specular_fog */

#ifdef __GLEE_GL_WIN_specular_fog
#endif 

/* GL_EXT_light_texture */

#ifdef __GLEE_GL_EXT_light_texture
#ifndef GLEE_C_DEFINED_glApplyTextureEXT
#define GLEE_C_DEFINED_glApplyTextureEXT
  void __stdcall GLee_Lazy_glApplyTextureEXT(GLenum mode)  {if (GLeeInit()) glApplyTextureEXT(mode);}
  GLEEPFNGLAPPLYTEXTUREEXTPROC GLeeFuncPtr_glApplyTextureEXT=GLee_Lazy_glApplyTextureEXT;
#endif
#ifndef GLEE_C_DEFINED_glTextureLightEXT
#define GLEE_C_DEFINED_glTextureLightEXT
  void __stdcall GLee_Lazy_glTextureLightEXT(GLenum pname)  {if (GLeeInit()) glTextureLightEXT(pname);}
  GLEEPFNGLTEXTURELIGHTEXTPROC GLeeFuncPtr_glTextureLightEXT=GLee_Lazy_glTextureLightEXT;
#endif
#ifndef GLEE_C_DEFINED_glTextureMaterialEXT
#define GLEE_C_DEFINED_glTextureMaterialEXT
  void __stdcall GLee_Lazy_glTextureMaterialEXT(GLenum face, GLenum mode)  {if (GLeeInit()) glTextureMaterialEXT(face, mode);}
  GLEEPFNGLTEXTUREMATERIALEXTPROC GLeeFuncPtr_glTextureMaterialEXT=GLee_Lazy_glTextureMaterialEXT;
#endif
#endif 

/* GL_SGIX_blend_alpha_minmax */

#ifdef __GLEE_GL_SGIX_blend_alpha_minmax
#endif 

/* GL_SGIX_impact_pixel_texture */

#ifdef __GLEE_GL_SGIX_impact_pixel_texture
#endif 

/* GL_EXT_bgra */

#ifdef __GLEE_GL_EXT_bgra
#endif 

/* GL_SGIX_async */

#ifdef __GLEE_GL_SGIX_async
#ifndef GLEE_C_DEFINED_glAsyncMarkerSGIX
#define GLEE_C_DEFINED_glAsyncMarkerSGIX
  void __stdcall GLee_Lazy_glAsyncMarkerSGIX(GLuint marker)  {if (GLeeInit()) glAsyncMarkerSGIX(marker);}
  GLEEPFNGLASYNCMARKERSGIXPROC GLeeFuncPtr_glAsyncMarkerSGIX=GLee_Lazy_glAsyncMarkerSGIX;
#endif
#ifndef GLEE_C_DEFINED_glFinishAsyncSGIX
#define GLEE_C_DEFINED_glFinishAsyncSGIX
  GLint __stdcall GLee_Lazy_glFinishAsyncSGIX(GLuint * markerp)  {if (GLeeInit()) return glFinishAsyncSGIX(markerp); return (GLint)0;}
  GLEEPFNGLFINISHASYNCSGIXPROC GLeeFuncPtr_glFinishAsyncSGIX=GLee_Lazy_glFinishAsyncSGIX;
#endif
#ifndef GLEE_C_DEFINED_glPollAsyncSGIX
#define GLEE_C_DEFINED_glPollAsyncSGIX
  GLint __stdcall GLee_Lazy_glPollAsyncSGIX(GLuint * markerp)  {if (GLeeInit()) return glPollAsyncSGIX(markerp); return (GLint)0;}
  GLEEPFNGLPOLLASYNCSGIXPROC GLeeFuncPtr_glPollAsyncSGIX=GLee_Lazy_glPollAsyncSGIX;
#endif
#ifndef GLEE_C_DEFINED_glGenAsyncMarkersSGIX
#define GLEE_C_DEFINED_glGenAsyncMarkersSGIX
  GLuint __stdcall GLee_Lazy_glGenAsyncMarkersSGIX(GLsizei range)  {if (GLeeInit()) return glGenAsyncMarkersSGIX(range); return (GLuint)0;}
  GLEEPFNGLGENASYNCMARKERSSGIXPROC GLeeFuncPtr_glGenAsyncMarkersSGIX=GLee_Lazy_glGenAsyncMarkersSGIX;
#endif
#ifndef GLEE_C_DEFINED_glDeleteAsyncMarkersSGIX
#define GLEE_C_DEFINED_glDeleteAsyncMarkersSGIX
  void __stdcall GLee_Lazy_glDeleteAsyncMarkersSGIX(GLuint marker, GLsizei range)  {if (GLeeInit()) glDeleteAsyncMarkersSGIX(marker, range);}
  GLEEPFNGLDELETEASYNCMARKERSSGIXPROC GLeeFuncPtr_glDeleteAsyncMarkersSGIX=GLee_Lazy_glDeleteAsyncMarkersSGIX;
#endif
#ifndef GLEE_C_DEFINED_glIsAsyncMarkerSGIX
#define GLEE_C_DEFINED_glIsAsyncMarkerSGIX
  GLboolean __stdcall GLee_Lazy_glIsAsyncMarkerSGIX(GLuint marker)  {if (GLeeInit()) return glIsAsyncMarkerSGIX(marker); return (GLboolean)0;}
  GLEEPFNGLISASYNCMARKERSGIXPROC GLeeFuncPtr_glIsAsyncMarkerSGIX=GLee_Lazy_glIsAsyncMarkerSGIX;
#endif
#endif 

/* GL_SGIX_async_pixel */

#ifdef __GLEE_GL_SGIX_async_pixel
#endif 

/* GL_SGIX_async_histogram */

#ifdef __GLEE_GL_SGIX_async_histogram
#endif 

/* GL_INTEL_texture_scissor */

#ifdef __GLEE_GL_INTEL_texture_scissor
#endif 

/* GL_INTEL_parallel_arrays */

#ifdef __GLEE_GL_INTEL_parallel_arrays
#ifndef GLEE_C_DEFINED_glVertexPointervINTEL
#define GLEE_C_DEFINED_glVertexPointervINTEL
  void __stdcall GLee_Lazy_glVertexPointervINTEL(GLint size, GLenum type, const GLvoid* * pointer)  {if (GLeeInit()) glVertexPointervINTEL(size, type, pointer);}
  GLEEPFNGLVERTEXPOINTERVINTELPROC GLeeFuncPtr_glVertexPointervINTEL=GLee_Lazy_glVertexPointervINTEL;
#endif
#ifndef GLEE_C_DEFINED_glNormalPointervINTEL
#define GLEE_C_DEFINED_glNormalPointervINTEL
  void __stdcall GLee_Lazy_glNormalPointervINTEL(GLenum type, const GLvoid* * pointer)  {if (GLeeInit()) glNormalPointervINTEL(type, pointer);}
  GLEEPFNGLNORMALPOINTERVINTELPROC GLeeFuncPtr_glNormalPointervINTEL=GLee_Lazy_glNormalPointervINTEL;
#endif
#ifndef GLEE_C_DEFINED_glColorPointervINTEL
#define GLEE_C_DEFINED_glColorPointervINTEL
  void __stdcall GLee_Lazy_glColorPointervINTEL(GLint size, GLenum type, const GLvoid* * pointer)  {if (GLeeInit()) glColorPointervINTEL(size, type, pointer);}
  GLEEPFNGLCOLORPOINTERVINTELPROC GLeeFuncPtr_glColorPointervINTEL=GLee_Lazy_glColorPointervINTEL;
#endif
#ifndef GLEE_C_DEFINED_glTexCoordPointervINTEL
#define GLEE_C_DEFINED_glTexCoordPointervINTEL
  void __stdcall GLee_Lazy_glTexCoordPointervINTEL(GLint size, GLenum type, const GLvoid* * pointer)  {if (GLeeInit()) glTexCoordPointervINTEL(size, type, pointer);}
  GLEEPFNGLTEXCOORDPOINTERVINTELPROC GLeeFuncPtr_glTexCoordPointervINTEL=GLee_Lazy_glTexCoordPointervINTEL;
#endif
#endif 

/* GL_HP_occlusion_test */

#ifdef __GLEE_GL_HP_occlusion_test
#endif 

/* GL_EXT_pixel_transform */

#ifdef __GLEE_GL_EXT_pixel_transform
#ifndef GLEE_C_DEFINED_glPixelTransformParameteriEXT
#define GLEE_C_DEFINED_glPixelTransformParameteriEXT
  void __stdcall GLee_Lazy_glPixelTransformParameteriEXT(GLenum target, GLenum pname, GLint param)  {if (GLeeInit()) glPixelTransformParameteriEXT(target, pname, param);}
  GLEEPFNGLPIXELTRANSFORMPARAMETERIEXTPROC GLeeFuncPtr_glPixelTransformParameteriEXT=GLee_Lazy_glPixelTransformParameteriEXT;
#endif
#ifndef GLEE_C_DEFINED_glPixelTransformParameterfEXT
#define GLEE_C_DEFINED_glPixelTransformParameterfEXT
  void __stdcall GLee_Lazy_glPixelTransformParameterfEXT(GLenum target, GLenum pname, GLfloat param)  {if (GLeeInit()) glPixelTransformParameterfEXT(target, pname, param);}
  GLEEPFNGLPIXELTRANSFORMPARAMETERFEXTPROC GLeeFuncPtr_glPixelTransformParameterfEXT=GLee_Lazy_glPixelTransformParameterfEXT;
#endif
#ifndef GLEE_C_DEFINED_glPixelTransformParameterivEXT
#define GLEE_C_DEFINED_glPixelTransformParameterivEXT
  void __stdcall GLee_Lazy_glPixelTransformParameterivEXT(GLenum target, GLenum pname, const GLint * params)  {if (GLeeInit()) glPixelTransformParameterivEXT(target, pname, params);}
  GLEEPFNGLPIXELTRANSFORMPARAMETERIVEXTPROC GLeeFuncPtr_glPixelTransformParameterivEXT=GLee_Lazy_glPixelTransformParameterivEXT;
#endif
#ifndef GLEE_C_DEFINED_glPixelTransformParameterfvEXT
#define GLEE_C_DEFINED_glPixelTransformParameterfvEXT
  void __stdcall GLee_Lazy_glPixelTransformParameterfvEXT(GLenum target, GLenum pname, const GLfloat * params)  {if (GLeeInit()) glPixelTransformParameterfvEXT(target, pname, params);}
  GLEEPFNGLPIXELTRANSFORMPARAMETERFVEXTPROC GLeeFuncPtr_glPixelTransformParameterfvEXT=GLee_Lazy_glPixelTransformParameterfvEXT;
#endif
#endif 

/* GL_EXT_pixel_transform_color_table */

#ifdef __GLEE_GL_EXT_pixel_transform_color_table
#endif 

/* GL_EXT_shared_texture_palette */

#ifdef __GLEE_GL_EXT_shared_texture_palette
#endif 

/* GL_EXT_separate_specular_color */

#ifdef __GLEE_GL_EXT_separate_specular_color
#endif 

/* GL_EXT_secondary_color */

#ifdef __GLEE_GL_EXT_secondary_color
#ifndef GLEE_C_DEFINED_glSecondaryColor3bEXT
#define GLEE_C_DEFINED_glSecondaryColor3bEXT
  void __stdcall GLee_Lazy_glSecondaryColor3bEXT(GLbyte red, GLbyte green, GLbyte blue)  {if (GLeeInit()) glSecondaryColor3bEXT(red, green, blue);}
  GLEEPFNGLSECONDARYCOLOR3BEXTPROC GLeeFuncPtr_glSecondaryColor3bEXT=GLee_Lazy_glSecondaryColor3bEXT;
#endif
#ifndef GLEE_C_DEFINED_glSecondaryColor3bvEXT
#define GLEE_C_DEFINED_glSecondaryColor3bvEXT
  void __stdcall GLee_Lazy_glSecondaryColor3bvEXT(const GLbyte * v)  {if (GLeeInit()) glSecondaryColor3bvEXT(v);}
  GLEEPFNGLSECONDARYCOLOR3BVEXTPROC GLeeFuncPtr_glSecondaryColor3bvEXT=GLee_Lazy_glSecondaryColor3bvEXT;
#endif
#ifndef GLEE_C_DEFINED_glSecondaryColor3dEXT
#define GLEE_C_DEFINED_glSecondaryColor3dEXT
  void __stdcall GLee_Lazy_glSecondaryColor3dEXT(GLdouble red, GLdouble green, GLdouble blue)  {if (GLeeInit()) glSecondaryColor3dEXT(red, green, blue);}
  GLEEPFNGLSECONDARYCOLOR3DEXTPROC GLeeFuncPtr_glSecondaryColor3dEXT=GLee_Lazy_glSecondaryColor3dEXT;
#endif
#ifndef GLEE_C_DEFINED_glSecondaryColor3dvEXT
#define GLEE_C_DEFINED_glSecondaryColor3dvEXT
  void __stdcall GLee_Lazy_glSecondaryColor3dvEXT(const GLdouble * v)  {if (GLeeInit()) glSecondaryColor3dvEXT(v);}
  GLEEPFNGLSECONDARYCOLOR3DVEXTPROC GLeeFuncPtr_glSecondaryColor3dvEXT=GLee_Lazy_glSecondaryColor3dvEXT;
#endif
#ifndef GLEE_C_DEFINED_glSecondaryColor3fEXT
#define GLEE_C_DEFINED_glSecondaryColor3fEXT
  void __stdcall GLee_Lazy_glSecondaryColor3fEXT(GLfloat red, GLfloat green, GLfloat blue)  {if (GLeeInit()) glSecondaryColor3fEXT(red, green, blue);}
  GLEEPFNGLSECONDARYCOLOR3FEXTPROC GLeeFuncPtr_glSecondaryColor3fEXT=GLee_Lazy_glSecondaryColor3fEXT;
#endif
#ifndef GLEE_C_DEFINED_glSecondaryColor3fvEXT
#define GLEE_C_DEFINED_glSecondaryColor3fvEXT
  void __stdcall GLee_Lazy_glSecondaryColor3fvEXT(const GLfloat * v)  {if (GLeeInit()) glSecondaryColor3fvEXT(v);}
  GLEEPFNGLSECONDARYCOLOR3FVEXTPROC GLeeFuncPtr_glSecondaryColor3fvEXT=GLee_Lazy_glSecondaryColor3fvEXT;
#endif
#ifndef GLEE_C_DEFINED_glSecondaryColor3iEXT
#define GLEE_C_DEFINED_glSecondaryColor3iEXT
  void __stdcall GLee_Lazy_glSecondaryColor3iEXT(GLint red, GLint green, GLint blue)  {if (GLeeInit()) glSecondaryColor3iEXT(red, green, blue);}
  GLEEPFNGLSECONDARYCOLOR3IEXTPROC GLeeFuncPtr_glSecondaryColor3iEXT=GLee_Lazy_glSecondaryColor3iEXT;
#endif
#ifndef GLEE_C_DEFINED_glSecondaryColor3ivEXT
#define GLEE_C_DEFINED_glSecondaryColor3ivEXT
  void __stdcall GLee_Lazy_glSecondaryColor3ivEXT(const GLint * v)  {if (GLeeInit()) glSecondaryColor3ivEXT(v);}
  GLEEPFNGLSECONDARYCOLOR3IVEXTPROC GLeeFuncPtr_glSecondaryColor3ivEXT=GLee_Lazy_glSecondaryColor3ivEXT;
#endif
#ifndef GLEE_C_DEFINED_glSecondaryColor3sEXT
#define GLEE_C_DEFINED_glSecondaryColor3sEXT
  void __stdcall GLee_Lazy_glSecondaryColor3sEXT(GLshort red, GLshort green, GLshort blue)  {if (GLeeInit()) glSecondaryColor3sEXT(red, green, blue);}
  GLEEPFNGLSECONDARYCOLOR3SEXTPROC GLeeFuncPtr_glSecondaryColor3sEXT=GLee_Lazy_glSecondaryColor3sEXT;
#endif
#ifndef GLEE_C_DEFINED_glSecondaryColor3svEXT
#define GLEE_C_DEFINED_glSecondaryColor3svEXT
  void __stdcall GLee_Lazy_glSecondaryColor3svEXT(const GLshort * v)  {if (GLeeInit()) glSecondaryColor3svEXT(v);}
  GLEEPFNGLSECONDARYCOLOR3SVEXTPROC GLeeFuncPtr_glSecondaryColor3svEXT=GLee_Lazy_glSecondaryColor3svEXT;
#endif
#ifndef GLEE_C_DEFINED_glSecondaryColor3ubEXT
#define GLEE_C_DEFINED_glSecondaryColor3ubEXT
  void __stdcall GLee_Lazy_glSecondaryColor3ubEXT(GLubyte red, GLubyte green, GLubyte blue)  {if (GLeeInit()) glSecondaryColor3ubEXT(red, green, blue);}
  GLEEPFNGLSECONDARYCOLOR3UBEXTPROC GLeeFuncPtr_glSecondaryColor3ubEXT=GLee_Lazy_glSecondaryColor3ubEXT;
#endif
#ifndef GLEE_C_DEFINED_glSecondaryColor3ubvEXT
#define GLEE_C_DEFINED_glSecondaryColor3ubvEXT
  void __stdcall GLee_Lazy_glSecondaryColor3ubvEXT(const GLubyte * v)  {if (GLeeInit()) glSecondaryColor3ubvEXT(v);}
  GLEEPFNGLSECONDARYCOLOR3UBVEXTPROC GLeeFuncPtr_glSecondaryColor3ubvEXT=GLee_Lazy_glSecondaryColor3ubvEXT;
#endif
#ifndef GLEE_C_DEFINED_glSecondaryColor3uiEXT
#define GLEE_C_DEFINED_glSecondaryColor3uiEXT
  void __stdcall GLee_Lazy_glSecondaryColor3uiEXT(GLuint red, GLuint green, GLuint blue)  {if (GLeeInit()) glSecondaryColor3uiEXT(red, green, blue);}
  GLEEPFNGLSECONDARYCOLOR3UIEXTPROC GLeeFuncPtr_glSecondaryColor3uiEXT=GLee_Lazy_glSecondaryColor3uiEXT;
#endif
#ifndef GLEE_C_DEFINED_glSecondaryColor3uivEXT
#define GLEE_C_DEFINED_glSecondaryColor3uivEXT
  void __stdcall GLee_Lazy_glSecondaryColor3uivEXT(const GLuint * v)  {if (GLeeInit()) glSecondaryColor3uivEXT(v);}
  GLEEPFNGLSECONDARYCOLOR3UIVEXTPROC GLeeFuncPtr_glSecondaryColor3uivEXT=GLee_Lazy_glSecondaryColor3uivEXT;
#endif
#ifndef GLEE_C_DEFINED_glSecondaryColor3usEXT
#define GLEE_C_DEFINED_glSecondaryColor3usEXT
  void __stdcall GLee_Lazy_glSecondaryColor3usEXT(GLushort red, GLushort green, GLushort blue)  {if (GLeeInit()) glSecondaryColor3usEXT(red, green, blue);}
  GLEEPFNGLSECONDARYCOLOR3USEXTPROC GLeeFuncPtr_glSecondaryColor3usEXT=GLee_Lazy_glSecondaryColor3usEXT;
#endif
#ifndef GLEE_C_DEFINED_glSecondaryColor3usvEXT
#define GLEE_C_DEFINED_glSecondaryColor3usvEXT
  void __stdcall GLee_Lazy_glSecondaryColor3usvEXT(const GLushort * v)  {if (GLeeInit()) glSecondaryColor3usvEXT(v);}
  GLEEPFNGLSECONDARYCOLOR3USVEXTPROC GLeeFuncPtr_glSecondaryColor3usvEXT=GLee_Lazy_glSecondaryColor3usvEXT;
#endif
#ifndef GLEE_C_DEFINED_glSecondaryColorPointerEXT
#define GLEE_C_DEFINED_glSecondaryColorPointerEXT
  void __stdcall GLee_Lazy_glSecondaryColorPointerEXT(GLint size, GLenum type, GLsizei stride, const GLvoid * pointer)  {if (GLeeInit()) glSecondaryColorPointerEXT(size, type, stride, pointer);}
  GLEEPFNGLSECONDARYCOLORPOINTEREXTPROC GLeeFuncPtr_glSecondaryColorPointerEXT=GLee_Lazy_glSecondaryColorPointerEXT;
#endif
#endif 

/* GL_EXT_texture_perturb_normal */

#ifdef __GLEE_GL_EXT_texture_perturb_normal
#ifndef GLEE_C_DEFINED_glTextureNormalEXT
#define GLEE_C_DEFINED_glTextureNormalEXT
  void __stdcall GLee_Lazy_glTextureNormalEXT(GLenum mode)  {if (GLeeInit()) glTextureNormalEXT(mode);}
  GLEEPFNGLTEXTURENORMALEXTPROC GLeeFuncPtr_glTextureNormalEXT=GLee_Lazy_glTextureNormalEXT;
#endif
#endif 

/* GL_EXT_multi_draw_arrays */

#ifdef __GLEE_GL_EXT_multi_draw_arrays
#ifndef GLEE_C_DEFINED_glMultiDrawArraysEXT
#define GLEE_C_DEFINED_glMultiDrawArraysEXT
  void __stdcall GLee_Lazy_glMultiDrawArraysEXT(GLenum mode, GLint * first, GLsizei * count, GLsizei primcount)  {if (GLeeInit()) glMultiDrawArraysEXT(mode, first, count, primcount);}
  GLEEPFNGLMULTIDRAWARRAYSEXTPROC GLeeFuncPtr_glMultiDrawArraysEXT=GLee_Lazy_glMultiDrawArraysEXT;
#endif
#ifndef GLEE_C_DEFINED_glMultiDrawElementsEXT
#define GLEE_C_DEFINED_glMultiDrawElementsEXT
  void __stdcall GLee_Lazy_glMultiDrawElementsEXT(GLenum mode, const GLsizei * count, GLenum type, const GLvoid* * indices, GLsizei primcount)  {if (GLeeInit()) glMultiDrawElementsEXT(mode, count, type, indices, primcount);}
  GLEEPFNGLMULTIDRAWELEMENTSEXTPROC GLeeFuncPtr_glMultiDrawElementsEXT=GLee_Lazy_glMultiDrawElementsEXT;
#endif
#endif 

/* GL_EXT_fog_coord */

#ifdef __GLEE_GL_EXT_fog_coord
#ifndef GLEE_C_DEFINED_glFogCoordfEXT
#define GLEE_C_DEFINED_glFogCoordfEXT
  void __stdcall GLee_Lazy_glFogCoordfEXT(GLfloat coord)  {if (GLeeInit()) glFogCoordfEXT(coord);}
  GLEEPFNGLFOGCOORDFEXTPROC GLeeFuncPtr_glFogCoordfEXT=GLee_Lazy_glFogCoordfEXT;
#endif
#ifndef GLEE_C_DEFINED_glFogCoordfvEXT
#define GLEE_C_DEFINED_glFogCoordfvEXT
  void __stdcall GLee_Lazy_glFogCoordfvEXT(const GLfloat * coord)  {if (GLeeInit()) glFogCoordfvEXT(coord);}
  GLEEPFNGLFOGCOORDFVEXTPROC GLeeFuncPtr_glFogCoordfvEXT=GLee_Lazy_glFogCoordfvEXT;
#endif
#ifndef GLEE_C_DEFINED_glFogCoorddEXT
#define GLEE_C_DEFINED_glFogCoorddEXT
  void __stdcall GLee_Lazy_glFogCoorddEXT(GLdouble coord)  {if (GLeeInit()) glFogCoorddEXT(coord);}
  GLEEPFNGLFOGCOORDDEXTPROC GLeeFuncPtr_glFogCoorddEXT=GLee_Lazy_glFogCoorddEXT;
#endif
#ifndef GLEE_C_DEFINED_glFogCoorddvEXT
#define GLEE_C_DEFINED_glFogCoorddvEXT
  void __stdcall GLee_Lazy_glFogCoorddvEXT(const GLdouble * coord)  {if (GLeeInit()) glFogCoorddvEXT(coord);}
  GLEEPFNGLFOGCOORDDVEXTPROC GLeeFuncPtr_glFogCoorddvEXT=GLee_Lazy_glFogCoorddvEXT;
#endif
#ifndef GLEE_C_DEFINED_glFogCoordPointerEXT
#define GLEE_C_DEFINED_glFogCoordPointerEXT
  void __stdcall GLee_Lazy_glFogCoordPointerEXT(GLenum type, GLsizei stride, const GLvoid * pointer)  {if (GLeeInit()) glFogCoordPointerEXT(type, stride, pointer);}
  GLEEPFNGLFOGCOORDPOINTEREXTPROC GLeeFuncPtr_glFogCoordPointerEXT=GLee_Lazy_glFogCoordPointerEXT;
#endif
#endif 

/* GL_REND_screen_coordinates */

#ifdef __GLEE_GL_REND_screen_coordinates
#endif 

/* GL_EXT_coordinate_frame */

#ifdef __GLEE_GL_EXT_coordinate_frame
#ifndef GLEE_C_DEFINED_glTangent3bEXT
#define GLEE_C_DEFINED_glTangent3bEXT
  void __stdcall GLee_Lazy_glTangent3bEXT(GLbyte tx, GLbyte ty, GLbyte tz)  {if (GLeeInit()) glTangent3bEXT(tx, ty, tz);}
  GLEEPFNGLTANGENT3BEXTPROC GLeeFuncPtr_glTangent3bEXT=GLee_Lazy_glTangent3bEXT;
#endif
#ifndef GLEE_C_DEFINED_glTangent3bvEXT
#define GLEE_C_DEFINED_glTangent3bvEXT
  void __stdcall GLee_Lazy_glTangent3bvEXT(const GLbyte * v)  {if (GLeeInit()) glTangent3bvEXT(v);}
  GLEEPFNGLTANGENT3BVEXTPROC GLeeFuncPtr_glTangent3bvEXT=GLee_Lazy_glTangent3bvEXT;
#endif
#ifndef GLEE_C_DEFINED_glTangent3dEXT
#define GLEE_C_DEFINED_glTangent3dEXT
  void __stdcall GLee_Lazy_glTangent3dEXT(GLdouble tx, GLdouble ty, GLdouble tz)  {if (GLeeInit()) glTangent3dEXT(tx, ty, tz);}
  GLEEPFNGLTANGENT3DEXTPROC GLeeFuncPtr_glTangent3dEXT=GLee_Lazy_glTangent3dEXT;
#endif
#ifndef GLEE_C_DEFINED_glTangent3dvEXT
#define GLEE_C_DEFINED_glTangent3dvEXT
  void __stdcall GLee_Lazy_glTangent3dvEXT(const GLdouble * v)  {if (GLeeInit()) glTangent3dvEXT(v);}
  GLEEPFNGLTANGENT3DVEXTPROC GLeeFuncPtr_glTangent3dvEXT=GLee_Lazy_glTangent3dvEXT;
#endif
#ifndef GLEE_C_DEFINED_glTangent3fEXT
#define GLEE_C_DEFINED_glTangent3fEXT
  void __stdcall GLee_Lazy_glTangent3fEXT(GLfloat tx, GLfloat ty, GLfloat tz)  {if (GLeeInit()) glTangent3fEXT(tx, ty, tz);}
  GLEEPFNGLTANGENT3FEXTPROC GLeeFuncPtr_glTangent3fEXT=GLee_Lazy_glTangent3fEXT;
#endif
#ifndef GLEE_C_DEFINED_glTangent3fvEXT
#define GLEE_C_DEFINED_glTangent3fvEXT
  void __stdcall GLee_Lazy_glTangent3fvEXT(const GLfloat * v)  {if (GLeeInit()) glTangent3fvEXT(v);}
  GLEEPFNGLTANGENT3FVEXTPROC GLeeFuncPtr_glTangent3fvEXT=GLee_Lazy_glTangent3fvEXT;
#endif
#ifndef GLEE_C_DEFINED_glTangent3iEXT
#define GLEE_C_DEFINED_glTangent3iEXT
  void __stdcall GLee_Lazy_glTangent3iEXT(GLint tx, GLint ty, GLint tz)  {if (GLeeInit()) glTangent3iEXT(tx, ty, tz);}
  GLEEPFNGLTANGENT3IEXTPROC GLeeFuncPtr_glTangent3iEXT=GLee_Lazy_glTangent3iEXT;
#endif
#ifndef GLEE_C_DEFINED_glTangent3ivEXT
#define GLEE_C_DEFINED_glTangent3ivEXT
  void __stdcall GLee_Lazy_glTangent3ivEXT(const GLint * v)  {if (GLeeInit()) glTangent3ivEXT(v);}
  GLEEPFNGLTANGENT3IVEXTPROC GLeeFuncPtr_glTangent3ivEXT=GLee_Lazy_glTangent3ivEXT;
#endif
#ifndef GLEE_C_DEFINED_glTangent3sEXT
#define GLEE_C_DEFINED_glTangent3sEXT
  void __stdcall GLee_Lazy_glTangent3sEXT(GLshort tx, GLshort ty, GLshort tz)  {if (GLeeInit()) glTangent3sEXT(tx, ty, tz);}
  GLEEPFNGLTANGENT3SEXTPROC GLeeFuncPtr_glTangent3sEXT=GLee_Lazy_glTangent3sEXT;
#endif
#ifndef GLEE_C_DEFINED_glTangent3svEXT
#define GLEE_C_DEFINED_glTangent3svEXT
  void __stdcall GLee_Lazy_glTangent3svEXT(const GLshort * v)  {if (GLeeInit()) glTangent3svEXT(v);}
  GLEEPFNGLTANGENT3SVEXTPROC GLeeFuncPtr_glTangent3svEXT=GLee_Lazy_glTangent3svEXT;
#endif
#ifndef GLEE_C_DEFINED_glBinormal3bEXT
#define GLEE_C_DEFINED_glBinormal3bEXT
  void __stdcall GLee_Lazy_glBinormal3bEXT(GLbyte bx, GLbyte by, GLbyte bz)  {if (GLeeInit()) glBinormal3bEXT(bx, by, bz);}
  GLEEPFNGLBINORMAL3BEXTPROC GLeeFuncPtr_glBinormal3bEXT=GLee_Lazy_glBinormal3bEXT;
#endif
#ifndef GLEE_C_DEFINED_glBinormal3bvEXT
#define GLEE_C_DEFINED_glBinormal3bvEXT
  void __stdcall GLee_Lazy_glBinormal3bvEXT(const GLbyte * v)  {if (GLeeInit()) glBinormal3bvEXT(v);}
  GLEEPFNGLBINORMAL3BVEXTPROC GLeeFuncPtr_glBinormal3bvEXT=GLee_Lazy_glBinormal3bvEXT;
#endif
#ifndef GLEE_C_DEFINED_glBinormal3dEXT
#define GLEE_C_DEFINED_glBinormal3dEXT
  void __stdcall GLee_Lazy_glBinormal3dEXT(GLdouble bx, GLdouble by, GLdouble bz)  {if (GLeeInit()) glBinormal3dEXT(bx, by, bz);}
  GLEEPFNGLBINORMAL3DEXTPROC GLeeFuncPtr_glBinormal3dEXT=GLee_Lazy_glBinormal3dEXT;
#endif
#ifndef GLEE_C_DEFINED_glBinormal3dvEXT
#define GLEE_C_DEFINED_glBinormal3dvEXT
  void __stdcall GLee_Lazy_glBinormal3dvEXT(const GLdouble * v)  {if (GLeeInit()) glBinormal3dvEXT(v);}
  GLEEPFNGLBINORMAL3DVEXTPROC GLeeFuncPtr_glBinormal3dvEXT=GLee_Lazy_glBinormal3dvEXT;
#endif
#ifndef GLEE_C_DEFINED_glBinormal3fEXT
#define GLEE_C_DEFINED_glBinormal3fEXT
  void __stdcall GLee_Lazy_glBinormal3fEXT(GLfloat bx, GLfloat by, GLfloat bz)  {if (GLeeInit()) glBinormal3fEXT(bx, by, bz);}
  GLEEPFNGLBINORMAL3FEXTPROC GLeeFuncPtr_glBinormal3fEXT=GLee_Lazy_glBinormal3fEXT;
#endif
#ifndef GLEE_C_DEFINED_glBinormal3fvEXT
#define GLEE_C_DEFINED_glBinormal3fvEXT
  void __stdcall GLee_Lazy_glBinormal3fvEXT(const GLfloat * v)  {if (GLeeInit()) glBinormal3fvEXT(v);}
  GLEEPFNGLBINORMAL3FVEXTPROC GLeeFuncPtr_glBinormal3fvEXT=GLee_Lazy_glBinormal3fvEXT;
#endif
#ifndef GLEE_C_DEFINED_glBinormal3iEXT
#define GLEE_C_DEFINED_glBinormal3iEXT
  void __stdcall GLee_Lazy_glBinormal3iEXT(GLint bx, GLint by, GLint bz)  {if (GLeeInit()) glBinormal3iEXT(bx, by, bz);}
  GLEEPFNGLBINORMAL3IEXTPROC GLeeFuncPtr_glBinormal3iEXT=GLee_Lazy_glBinormal3iEXT;
#endif
#ifndef GLEE_C_DEFINED_glBinormal3ivEXT
#define GLEE_C_DEFINED_glBinormal3ivEXT
  void __stdcall GLee_Lazy_glBinormal3ivEXT(const GLint * v)  {if (GLeeInit()) glBinormal3ivEXT(v);}
  GLEEPFNGLBINORMAL3IVEXTPROC GLeeFuncPtr_glBinormal3ivEXT=GLee_Lazy_glBinormal3ivEXT;
#endif
#ifndef GLEE_C_DEFINED_glBinormal3sEXT
#define GLEE_C_DEFINED_glBinormal3sEXT
  void __stdcall GLee_Lazy_glBinormal3sEXT(GLshort bx, GLshort by, GLshort bz)  {if (GLeeInit()) glBinormal3sEXT(bx, by, bz);}
  GLEEPFNGLBINORMAL3SEXTPROC GLeeFuncPtr_glBinormal3sEXT=GLee_Lazy_glBinormal3sEXT;
#endif
#ifndef GLEE_C_DEFINED_glBinormal3svEXT
#define GLEE_C_DEFINED_glBinormal3svEXT
  void __stdcall GLee_Lazy_glBinormal3svEXT(const GLshort * v)  {if (GLeeInit()) glBinormal3svEXT(v);}
  GLEEPFNGLBINORMAL3SVEXTPROC GLeeFuncPtr_glBinormal3svEXT=GLee_Lazy_glBinormal3svEXT;
#endif
#ifndef GLEE_C_DEFINED_glTangentPointerEXT
#define GLEE_C_DEFINED_glTangentPointerEXT
  void __stdcall GLee_Lazy_glTangentPointerEXT(GLenum type, GLsizei stride, const GLvoid * pointer)  {if (GLeeInit()) glTangentPointerEXT(type, stride, pointer);}
  GLEEPFNGLTANGENTPOINTEREXTPROC GLeeFuncPtr_glTangentPointerEXT=GLee_Lazy_glTangentPointerEXT;
#endif
#ifndef GLEE_C_DEFINED_glBinormalPointerEXT
#define GLEE_C_DEFINED_glBinormalPointerEXT
  void __stdcall GLee_Lazy_glBinormalPointerEXT(GLenum type, GLsizei stride, const GLvoid * pointer)  {if (GLeeInit()) glBinormalPointerEXT(type, stride, pointer);}
  GLEEPFNGLBINORMALPOINTEREXTPROC GLeeFuncPtr_glBinormalPointerEXT=GLee_Lazy_glBinormalPointerEXT;
#endif
#endif 

/* GL_EXT_texture_env_combine */

#ifdef __GLEE_GL_EXT_texture_env_combine
#endif 

/* GL_APPLE_specular_vector */

#ifdef __GLEE_GL_APPLE_specular_vector
#endif 

/* GL_APPLE_transform_hint */

#ifdef __GLEE_GL_APPLE_transform_hint
#endif 

/* GL_SGIX_fog_scale */

#ifdef __GLEE_GL_SGIX_fog_scale
#endif 

/* GL_SUNX_constant_data */

#ifdef __GLEE_GL_SUNX_constant_data
#ifndef GLEE_C_DEFINED_glFinishTextureSUNX
#define GLEE_C_DEFINED_glFinishTextureSUNX
  void __stdcall GLee_Lazy_glFinishTextureSUNX(void)  {if (GLeeInit()) glFinishTextureSUNX();}
  GLEEPFNGLFINISHTEXTURESUNXPROC GLeeFuncPtr_glFinishTextureSUNX=GLee_Lazy_glFinishTextureSUNX;
#endif
#endif 

/* GL_SUN_global_alpha */

#ifdef __GLEE_GL_SUN_global_alpha
#ifndef GLEE_C_DEFINED_glGlobalAlphaFactorbSUN
#define GLEE_C_DEFINED_glGlobalAlphaFactorbSUN
  void __stdcall GLee_Lazy_glGlobalAlphaFactorbSUN(GLbyte factor)  {if (GLeeInit()) glGlobalAlphaFactorbSUN(factor);}
  GLEEPFNGLGLOBALALPHAFACTORBSUNPROC GLeeFuncPtr_glGlobalAlphaFactorbSUN=GLee_Lazy_glGlobalAlphaFactorbSUN;
#endif
#ifndef GLEE_C_DEFINED_glGlobalAlphaFactorsSUN
#define GLEE_C_DEFINED_glGlobalAlphaFactorsSUN
  void __stdcall GLee_Lazy_glGlobalAlphaFactorsSUN(GLshort factor)  {if (GLeeInit()) glGlobalAlphaFactorsSUN(factor);}
  GLEEPFNGLGLOBALALPHAFACTORSSUNPROC GLeeFuncPtr_glGlobalAlphaFactorsSUN=GLee_Lazy_glGlobalAlphaFactorsSUN;
#endif
#ifndef GLEE_C_DEFINED_glGlobalAlphaFactoriSUN
#define GLEE_C_DEFINED_glGlobalAlphaFactoriSUN
  void __stdcall GLee_Lazy_glGlobalAlphaFactoriSUN(GLint factor)  {if (GLeeInit()) glGlobalAlphaFactoriSUN(factor);}
  GLEEPFNGLGLOBALALPHAFACTORISUNPROC GLeeFuncPtr_glGlobalAlphaFactoriSUN=GLee_Lazy_glGlobalAlphaFactoriSUN;
#endif
#ifndef GLEE_C_DEFINED_glGlobalAlphaFactorfSUN
#define GLEE_C_DEFINED_glGlobalAlphaFactorfSUN
  void __stdcall GLee_Lazy_glGlobalAlphaFactorfSUN(GLfloat factor)  {if (GLeeInit()) glGlobalAlphaFactorfSUN(factor);}
  GLEEPFNGLGLOBALALPHAFACTORFSUNPROC GLeeFuncPtr_glGlobalAlphaFactorfSUN=GLee_Lazy_glGlobalAlphaFactorfSUN;
#endif
#ifndef GLEE_C_DEFINED_glGlobalAlphaFactordSUN
#define GLEE_C_DEFINED_glGlobalAlphaFactordSUN
  void __stdcall GLee_Lazy_glGlobalAlphaFactordSUN(GLdouble factor)  {if (GLeeInit()) glGlobalAlphaFactordSUN(factor);}
  GLEEPFNGLGLOBALALPHAFACTORDSUNPROC GLeeFuncPtr_glGlobalAlphaFactordSUN=GLee_Lazy_glGlobalAlphaFactordSUN;
#endif
#ifndef GLEE_C_DEFINED_glGlobalAlphaFactorubSUN
#define GLEE_C_DEFINED_glGlobalAlphaFactorubSUN
  void __stdcall GLee_Lazy_glGlobalAlphaFactorubSUN(GLubyte factor)  {if (GLeeInit()) glGlobalAlphaFactorubSUN(factor);}
  GLEEPFNGLGLOBALALPHAFACTORUBSUNPROC GLeeFuncPtr_glGlobalAlphaFactorubSUN=GLee_Lazy_glGlobalAlphaFactorubSUN;
#endif
#ifndef GLEE_C_DEFINED_glGlobalAlphaFactorusSUN
#define GLEE_C_DEFINED_glGlobalAlphaFactorusSUN
  void __stdcall GLee_Lazy_glGlobalAlphaFactorusSUN(GLushort factor)  {if (GLeeInit()) glGlobalAlphaFactorusSUN(factor);}
  GLEEPFNGLGLOBALALPHAFACTORUSSUNPROC GLeeFuncPtr_glGlobalAlphaFactorusSUN=GLee_Lazy_glGlobalAlphaFactorusSUN;
#endif
#ifndef GLEE_C_DEFINED_glGlobalAlphaFactoruiSUN
#define GLEE_C_DEFINED_glGlobalAlphaFactoruiSUN
  void __stdcall GLee_Lazy_glGlobalAlphaFactoruiSUN(GLuint factor)  {if (GLeeInit()) glGlobalAlphaFactoruiSUN(factor);}
  GLEEPFNGLGLOBALALPHAFACTORUISUNPROC GLeeFuncPtr_glGlobalAlphaFactoruiSUN=GLee_Lazy_glGlobalAlphaFactoruiSUN;
#endif
#endif 

/* GL_SUN_triangle_list */

#ifdef __GLEE_GL_SUN_triangle_list
#ifndef GLEE_C_DEFINED_glReplacementCodeuiSUN
#define GLEE_C_DEFINED_glReplacementCodeuiSUN
  void __stdcall GLee_Lazy_glReplacementCodeuiSUN(GLuint code)  {if (GLeeInit()) glReplacementCodeuiSUN(code);}
  GLEEPFNGLREPLACEMENTCODEUISUNPROC GLeeFuncPtr_glReplacementCodeuiSUN=GLee_Lazy_glReplacementCodeuiSUN;
#endif
#ifndef GLEE_C_DEFINED_glReplacementCodeusSUN
#define GLEE_C_DEFINED_glReplacementCodeusSUN
  void __stdcall GLee_Lazy_glReplacementCodeusSUN(GLushort code)  {if (GLeeInit()) glReplacementCodeusSUN(code);}
  GLEEPFNGLREPLACEMENTCODEUSSUNPROC GLeeFuncPtr_glReplacementCodeusSUN=GLee_Lazy_glReplacementCodeusSUN;
#endif
#ifndef GLEE_C_DEFINED_glReplacementCodeubSUN
#define GLEE_C_DEFINED_glReplacementCodeubSUN
  void __stdcall GLee_Lazy_glReplacementCodeubSUN(GLubyte code)  {if (GLeeInit()) glReplacementCodeubSUN(code);}
  GLEEPFNGLREPLACEMENTCODEUBSUNPROC GLeeFuncPtr_glReplacementCodeubSUN=GLee_Lazy_glReplacementCodeubSUN;
#endif
#ifndef GLEE_C_DEFINED_glReplacementCodeuivSUN
#define GLEE_C_DEFINED_glReplacementCodeuivSUN
  void __stdcall GLee_Lazy_glReplacementCodeuivSUN(const GLuint * code)  {if (GLeeInit()) glReplacementCodeuivSUN(code);}
  GLEEPFNGLREPLACEMENTCODEUIVSUNPROC GLeeFuncPtr_glReplacementCodeuivSUN=GLee_Lazy_glReplacementCodeuivSUN;
#endif
#ifndef GLEE_C_DEFINED_glReplacementCodeusvSUN
#define GLEE_C_DEFINED_glReplacementCodeusvSUN
  void __stdcall GLee_Lazy_glReplacementCodeusvSUN(const GLushort * code)  {if (GLeeInit()) glReplacementCodeusvSUN(code);}
  GLEEPFNGLREPLACEMENTCODEUSVSUNPROC GLeeFuncPtr_glReplacementCodeusvSUN=GLee_Lazy_glReplacementCodeusvSUN;
#endif
#ifndef GLEE_C_DEFINED_glReplacementCodeubvSUN
#define GLEE_C_DEFINED_glReplacementCodeubvSUN
  void __stdcall GLee_Lazy_glReplacementCodeubvSUN(const GLubyte * code)  {if (GLeeInit()) glReplacementCodeubvSUN(code);}
  GLEEPFNGLREPLACEMENTCODEUBVSUNPROC GLeeFuncPtr_glReplacementCodeubvSUN=GLee_Lazy_glReplacementCodeubvSUN;
#endif
#ifndef GLEE_C_DEFINED_glReplacementCodePointerSUN
#define GLEE_C_DEFINED_glReplacementCodePointerSUN
  void __stdcall GLee_Lazy_glReplacementCodePointerSUN(GLenum type, GLsizei stride, const GLvoid* * pointer)  {if (GLeeInit()) glReplacementCodePointerSUN(type, stride, pointer);}
  GLEEPFNGLREPLACEMENTCODEPOINTERSUNPROC GLeeFuncPtr_glReplacementCodePointerSUN=GLee_Lazy_glReplacementCodePointerSUN;
#endif
#endif 

/* GL_SUN_vertex */

#ifdef __GLEE_GL_SUN_vertex
#ifndef GLEE_C_DEFINED_glColor4ubVertex2fSUN
#define GLEE_C_DEFINED_glColor4ubVertex2fSUN
  void __stdcall GLee_Lazy_glColor4ubVertex2fSUN(GLubyte r, GLubyte g, GLubyte b, GLubyte a, GLfloat x, GLfloat y)  {if (GLeeInit()) glColor4ubVertex2fSUN(r, g, b, a, x, y);}
  GLEEPFNGLCOLOR4UBVERTEX2FSUNPROC GLeeFuncPtr_glColor4ubVertex2fSUN=GLee_Lazy_glColor4ubVertex2fSUN;
#endif
#ifndef GLEE_C_DEFINED_glColor4ubVertex2fvSUN
#define GLEE_C_DEFINED_glColor4ubVertex2fvSUN
  void __stdcall GLee_Lazy_glColor4ubVertex2fvSUN(const GLubyte * c, const GLfloat * v)  {if (GLeeInit()) glColor4ubVertex2fvSUN(c, v);}
  GLEEPFNGLCOLOR4UBVERTEX2FVSUNPROC GLeeFuncPtr_glColor4ubVertex2fvSUN=GLee_Lazy_glColor4ubVertex2fvSUN;
#endif
#ifndef GLEE_C_DEFINED_glColor4ubVertex3fSUN
#define GLEE_C_DEFINED_glColor4ubVertex3fSUN
  void __stdcall GLee_Lazy_glColor4ubVertex3fSUN(GLubyte r, GLubyte g, GLubyte b, GLubyte a, GLfloat x, GLfloat y, GLfloat z)  {if (GLeeInit()) glColor4ubVertex3fSUN(r, g, b, a, x, y, z);}
  GLEEPFNGLCOLOR4UBVERTEX3FSUNPROC GLeeFuncPtr_glColor4ubVertex3fSUN=GLee_Lazy_glColor4ubVertex3fSUN;
#endif
#ifndef GLEE_C_DEFINED_glColor4ubVertex3fvSUN
#define GLEE_C_DEFINED_glColor4ubVertex3fvSUN
  void __stdcall GLee_Lazy_glColor4ubVertex3fvSUN(const GLubyte * c, const GLfloat * v)  {if (GLeeInit()) glColor4ubVertex3fvSUN(c, v);}
  GLEEPFNGLCOLOR4UBVERTEX3FVSUNPROC GLeeFuncPtr_glColor4ubVertex3fvSUN=GLee_Lazy_glColor4ubVertex3fvSUN;
#endif
#ifndef GLEE_C_DEFINED_glColor3fVertex3fSUN
#define GLEE_C_DEFINED_glColor3fVertex3fSUN
  void __stdcall GLee_Lazy_glColor3fVertex3fSUN(GLfloat r, GLfloat g, GLfloat b, GLfloat x, GLfloat y, GLfloat z)  {if (GLeeInit()) glColor3fVertex3fSUN(r, g, b, x, y, z);}
  GLEEPFNGLCOLOR3FVERTEX3FSUNPROC GLeeFuncPtr_glColor3fVertex3fSUN=GLee_Lazy_glColor3fVertex3fSUN;
#endif
#ifndef GLEE_C_DEFINED_glColor3fVertex3fvSUN
#define GLEE_C_DEFINED_glColor3fVertex3fvSUN
  void __stdcall GLee_Lazy_glColor3fVertex3fvSUN(const GLfloat * c, const GLfloat * v)  {if (GLeeInit()) glColor3fVertex3fvSUN(c, v);}
  GLEEPFNGLCOLOR3FVERTEX3FVSUNPROC GLeeFuncPtr_glColor3fVertex3fvSUN=GLee_Lazy_glColor3fVertex3fvSUN;
#endif
#ifndef GLEE_C_DEFINED_glNormal3fVertex3fSUN
#define GLEE_C_DEFINED_glNormal3fVertex3fSUN
  void __stdcall GLee_Lazy_glNormal3fVertex3fSUN(GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z)  {if (GLeeInit()) glNormal3fVertex3fSUN(nx, ny, nz, x, y, z);}
  GLEEPFNGLNORMAL3FVERTEX3FSUNPROC GLeeFuncPtr_glNormal3fVertex3fSUN=GLee_Lazy_glNormal3fVertex3fSUN;
#endif
#ifndef GLEE_C_DEFINED_glNormal3fVertex3fvSUN
#define GLEE_C_DEFINED_glNormal3fVertex3fvSUN
  void __stdcall GLee_Lazy_glNormal3fVertex3fvSUN(const GLfloat * n, const GLfloat * v)  {if (GLeeInit()) glNormal3fVertex3fvSUN(n, v);}
  GLEEPFNGLNORMAL3FVERTEX3FVSUNPROC GLeeFuncPtr_glNormal3fVertex3fvSUN=GLee_Lazy_glNormal3fVertex3fvSUN;
#endif
#ifndef GLEE_C_DEFINED_glColor4fNormal3fVertex3fSUN
#define GLEE_C_DEFINED_glColor4fNormal3fVertex3fSUN
  void __stdcall GLee_Lazy_glColor4fNormal3fVertex3fSUN(GLfloat r, GLfloat g, GLfloat b, GLfloat a, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z)  {if (GLeeInit()) glColor4fNormal3fVertex3fSUN(r, g, b, a, nx, ny, nz, x, y, z);}
  GLEEPFNGLCOLOR4FNORMAL3FVERTEX3FSUNPROC GLeeFuncPtr_glColor4fNormal3fVertex3fSUN=GLee_Lazy_glColor4fNormal3fVertex3fSUN;
#endif
#ifndef GLEE_C_DEFINED_glColor4fNormal3fVertex3fvSUN
#define GLEE_C_DEFINED_glColor4fNormal3fVertex3fvSUN
  void __stdcall GLee_Lazy_glColor4fNormal3fVertex3fvSUN(const GLfloat * c, const GLfloat * n, const GLfloat * v)  {if (GLeeInit()) glColor4fNormal3fVertex3fvSUN(c, n, v);}
  GLEEPFNGLCOLOR4FNORMAL3FVERTEX3FVSUNPROC GLeeFuncPtr_glColor4fNormal3fVertex3fvSUN=GLee_Lazy_glColor4fNormal3fVertex3fvSUN;
#endif
#ifndef GLEE_C_DEFINED_glTexCoord2fVertex3fSUN
#define GLEE_C_DEFINED_glTexCoord2fVertex3fSUN
  void __stdcall GLee_Lazy_glTexCoord2fVertex3fSUN(GLfloat s, GLfloat t, GLfloat x, GLfloat y, GLfloat z)  {if (GLeeInit()) glTexCoord2fVertex3fSUN(s, t, x, y, z);}
  GLEEPFNGLTEXCOORD2FVERTEX3FSUNPROC GLeeFuncPtr_glTexCoord2fVertex3fSUN=GLee_Lazy_glTexCoord2fVertex3fSUN;
#endif
#ifndef GLEE_C_DEFINED_glTexCoord2fVertex3fvSUN
#define GLEE_C_DEFINED_glTexCoord2fVertex3fvSUN
  void __stdcall GLee_Lazy_glTexCoord2fVertex3fvSUN(const GLfloat * tc, const GLfloat * v)  {if (GLeeInit()) glTexCoord2fVertex3fvSUN(tc, v);}
  GLEEPFNGLTEXCOORD2FVERTEX3FVSUNPROC GLeeFuncPtr_glTexCoord2fVertex3fvSUN=GLee_Lazy_glTexCoord2fVertex3fvSUN;
#endif
#ifndef GLEE_C_DEFINED_glTexCoord4fVertex4fSUN
#define GLEE_C_DEFINED_glTexCoord4fVertex4fSUN
  void __stdcall GLee_Lazy_glTexCoord4fVertex4fSUN(GLfloat s, GLfloat t, GLfloat p, GLfloat q, GLfloat x, GLfloat y, GLfloat z, GLfloat w)  {if (GLeeInit()) glTexCoord4fVertex4fSUN(s, t, p, q, x, y, z, w);}
  GLEEPFNGLTEXCOORD4FVERTEX4FSUNPROC GLeeFuncPtr_glTexCoord4fVertex4fSUN=GLee_Lazy_glTexCoord4fVertex4fSUN;
#endif
#ifndef GLEE_C_DEFINED_glTexCoord4fVertex4fvSUN
#define GLEE_C_DEFINED_glTexCoord4fVertex4fvSUN
  void __stdcall GLee_Lazy_glTexCoord4fVertex4fvSUN(const GLfloat * tc, const GLfloat * v)  {if (GLeeInit()) glTexCoord4fVertex4fvSUN(tc, v);}
  GLEEPFNGLTEXCOORD4FVERTEX4FVSUNPROC GLeeFuncPtr_glTexCoord4fVertex4fvSUN=GLee_Lazy_glTexCoord4fVertex4fvSUN;
#endif
#ifndef GLEE_C_DEFINED_glTexCoord2fColor4ubVertex3fSUN
#define GLEE_C_DEFINED_glTexCoord2fColor4ubVertex3fSUN
  void __stdcall GLee_Lazy_glTexCoord2fColor4ubVertex3fSUN(GLfloat s, GLfloat t, GLubyte r, GLubyte g, GLubyte b, GLubyte a, GLfloat x, GLfloat y, GLfloat z)  {if (GLeeInit()) glTexCoord2fColor4ubVertex3fSUN(s, t, r, g, b, a, x, y, z);}
  GLEEPFNGLTEXCOORD2FCOLOR4UBVERTEX3FSUNPROC GLeeFuncPtr_glTexCoord2fColor4ubVertex3fSUN=GLee_Lazy_glTexCoord2fColor4ubVertex3fSUN;
#endif
#ifndef GLEE_C_DEFINED_glTexCoord2fColor4ubVertex3fvSUN
#define GLEE_C_DEFINED_glTexCoord2fColor4ubVertex3fvSUN
  void __stdcall GLee_Lazy_glTexCoord2fColor4ubVertex3fvSUN(const GLfloat * tc, const GLubyte * c, const GLfloat * v)  {if (GLeeInit()) glTexCoord2fColor4ubVertex3fvSUN(tc, c, v);}
  GLEEPFNGLTEXCOORD2FCOLOR4UBVERTEX3FVSUNPROC GLeeFuncPtr_glTexCoord2fColor4ubVertex3fvSUN=GLee_Lazy_glTexCoord2fColor4ubVertex3fvSUN;
#endif
#ifndef GLEE_C_DEFINED_glTexCoord2fColor3fVertex3fSUN
#define GLEE_C_DEFINED_glTexCoord2fColor3fVertex3fSUN
  void __stdcall GLee_Lazy_glTexCoord2fColor3fVertex3fSUN(GLfloat s, GLfloat t, GLfloat r, GLfloat g, GLfloat b, GLfloat x, GLfloat y, GLfloat z)  {if (GLeeInit()) glTexCoord2fColor3fVertex3fSUN(s, t, r, g, b, x, y, z);}
  GLEEPFNGLTEXCOORD2FCOLOR3FVERTEX3FSUNPROC GLeeFuncPtr_glTexCoord2fColor3fVertex3fSUN=GLee_Lazy_glTexCoord2fColor3fVertex3fSUN;
#endif
#ifndef GLEE_C_DEFINED_glTexCoord2fColor3fVertex3fvSUN
#define GLEE_C_DEFINED_glTexCoord2fColor3fVertex3fvSUN
  void __stdcall GLee_Lazy_glTexCoord2fColor3fVertex3fvSUN(const GLfloat * tc, const GLfloat * c, const GLfloat * v)  {if (GLeeInit()) glTexCoord2fColor3fVertex3fvSUN(tc, c, v);}
  GLEEPFNGLTEXCOORD2FCOLOR3FVERTEX3FVSUNPROC GLeeFuncPtr_glTexCoord2fColor3fVertex3fvSUN=GLee_Lazy_glTexCoord2fColor3fVertex3fvSUN;
#endif
#ifndef GLEE_C_DEFINED_glTexCoord2fNormal3fVertex3fSUN
#define GLEE_C_DEFINED_glTexCoord2fNormal3fVertex3fSUN
  void __stdcall GLee_Lazy_glTexCoord2fNormal3fVertex3fSUN(GLfloat s, GLfloat t, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z)  {if (GLeeInit()) glTexCoord2fNormal3fVertex3fSUN(s, t, nx, ny, nz, x, y, z);}
  GLEEPFNGLTEXCOORD2FNORMAL3FVERTEX3FSUNPROC GLeeFuncPtr_glTexCoord2fNormal3fVertex3fSUN=GLee_Lazy_glTexCoord2fNormal3fVertex3fSUN;
#endif
#ifndef GLEE_C_DEFINED_glTexCoord2fNormal3fVertex3fvSUN
#define GLEE_C_DEFINED_glTexCoord2fNormal3fVertex3fvSUN
  void __stdcall GLee_Lazy_glTexCoord2fNormal3fVertex3fvSUN(const GLfloat * tc, const GLfloat * n, const GLfloat * v)  {if (GLeeInit()) glTexCoord2fNormal3fVertex3fvSUN(tc, n, v);}
  GLEEPFNGLTEXCOORD2FNORMAL3FVERTEX3FVSUNPROC GLeeFuncPtr_glTexCoord2fNormal3fVertex3fvSUN=GLee_Lazy_glTexCoord2fNormal3fVertex3fvSUN;
#endif
#ifndef GLEE_C_DEFINED_glTexCoord2fColor4fNormal3fVertex3fSUN
#define GLEE_C_DEFINED_glTexCoord2fColor4fNormal3fVertex3fSUN
  void __stdcall GLee_Lazy_glTexCoord2fColor4fNormal3fVertex3fSUN(GLfloat s, GLfloat t, GLfloat r, GLfloat g, GLfloat b, GLfloat a, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z)  {if (GLeeInit()) glTexCoord2fColor4fNormal3fVertex3fSUN(s, t, r, g, b, a, nx, ny, nz, x, y, z);}
  GLEEPFNGLTEXCOORD2FCOLOR4FNORMAL3FVERTEX3FSUNPROC GLeeFuncPtr_glTexCoord2fColor4fNormal3fVertex3fSUN=GLee_Lazy_glTexCoord2fColor4fNormal3fVertex3fSUN;
#endif
#ifndef GLEE_C_DEFINED_glTexCoord2fColor4fNormal3fVertex3fvSUN
#define GLEE_C_DEFINED_glTexCoord2fColor4fNormal3fVertex3fvSUN
  void __stdcall GLee_Lazy_glTexCoord2fColor4fNormal3fVertex3fvSUN(const GLfloat * tc, const GLfloat * c, const GLfloat * n, const GLfloat * v)  {if (GLeeInit()) glTexCoord2fColor4fNormal3fVertex3fvSUN(tc, c, n, v);}
  GLEEPFNGLTEXCOORD2FCOLOR4FNORMAL3FVERTEX3FVSUNPROC GLeeFuncPtr_glTexCoord2fColor4fNormal3fVertex3fvSUN=GLee_Lazy_glTexCoord2fColor4fNormal3fVertex3fvSUN;
#endif
#ifndef GLEE_C_DEFINED_glTexCoord4fColor4fNormal3fVertex4fSUN
#define GLEE_C_DEFINED_glTexCoord4fColor4fNormal3fVertex4fSUN
  void __stdcall GLee_Lazy_glTexCoord4fColor4fNormal3fVertex4fSUN(GLfloat s, GLfloat t, GLfloat p, GLfloat q, GLfloat r, GLfloat g, GLfloat b, GLfloat a, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z, GLfloat w)  {if (GLeeInit()) glTexCoord4fColor4fNormal3fVertex4fSUN(s, t, p, q, r, g, b, a, nx, ny, nz, x, y, z, w);}
  GLEEPFNGLTEXCOORD4FCOLOR4FNORMAL3FVERTEX4FSUNPROC GLeeFuncPtr_glTexCoord4fColor4fNormal3fVertex4fSUN=GLee_Lazy_glTexCoord4fColor4fNormal3fVertex4fSUN;
#endif
#ifndef GLEE_C_DEFINED_glTexCoord4fColor4fNormal3fVertex4fvSUN
#define GLEE_C_DEFINED_glTexCoord4fColor4fNormal3fVertex4fvSUN
  void __stdcall GLee_Lazy_glTexCoord4fColor4fNormal3fVertex4fvSUN(const GLfloat * tc, const GLfloat * c, const GLfloat * n, const GLfloat * v)  {if (GLeeInit()) glTexCoord4fColor4fNormal3fVertex4fvSUN(tc, c, n, v);}
  GLEEPFNGLTEXCOORD4FCOLOR4FNORMAL3FVERTEX4FVSUNPROC GLeeFuncPtr_glTexCoord4fColor4fNormal3fVertex4fvSUN=GLee_Lazy_glTexCoord4fColor4fNormal3fVertex4fvSUN;
#endif
#ifndef GLEE_C_DEFINED_glReplacementCodeuiVertex3fSUN
#define GLEE_C_DEFINED_glReplacementCodeuiVertex3fSUN
  void __stdcall GLee_Lazy_glReplacementCodeuiVertex3fSUN(GLuint rc, GLfloat x, GLfloat y, GLfloat z)  {if (GLeeInit()) glReplacementCodeuiVertex3fSUN(rc, x, y, z);}
  GLEEPFNGLREPLACEMENTCODEUIVERTEX3FSUNPROC GLeeFuncPtr_glReplacementCodeuiVertex3fSUN=GLee_Lazy_glReplacementCodeuiVertex3fSUN;
#endif
#ifndef GLEE_C_DEFINED_glReplacementCodeuiVertex3fvSUN
#define GLEE_C_DEFINED_glReplacementCodeuiVertex3fvSUN
  void __stdcall GLee_Lazy_glReplacementCodeuiVertex3fvSUN(const GLuint * rc, const GLfloat * v)  {if (GLeeInit()) glReplacementCodeuiVertex3fvSUN(rc, v);}
  GLEEPFNGLREPLACEMENTCODEUIVERTEX3FVSUNPROC GLeeFuncPtr_glReplacementCodeuiVertex3fvSUN=GLee_Lazy_glReplacementCodeuiVertex3fvSUN;
#endif
#ifndef GLEE_C_DEFINED_glReplacementCodeuiColor4ubVertex3fSUN
#define GLEE_C_DEFINED_glReplacementCodeuiColor4ubVertex3fSUN
  void __stdcall GLee_Lazy_glReplacementCodeuiColor4ubVertex3fSUN(GLuint rc, GLubyte r, GLubyte g, GLubyte b, GLubyte a, GLfloat x, GLfloat y, GLfloat z)  {if (GLeeInit()) glReplacementCodeuiColor4ubVertex3fSUN(rc, r, g, b, a, x, y, z);}
  GLEEPFNGLREPLACEMENTCODEUICOLOR4UBVERTEX3FSUNPROC GLeeFuncPtr_glReplacementCodeuiColor4ubVertex3fSUN=GLee_Lazy_glReplacementCodeuiColor4ubVertex3fSUN;
#endif
#ifndef GLEE_C_DEFINED_glReplacementCodeuiColor4ubVertex3fvSUN
#define GLEE_C_DEFINED_glReplacementCodeuiColor4ubVertex3fvSUN
  void __stdcall GLee_Lazy_glReplacementCodeuiColor4ubVertex3fvSUN(const GLuint * rc, const GLubyte * c, const GLfloat * v)  {if (GLeeInit()) glReplacementCodeuiColor4ubVertex3fvSUN(rc, c, v);}
  GLEEPFNGLREPLACEMENTCODEUICOLOR4UBVERTEX3FVSUNPROC GLeeFuncPtr_glReplacementCodeuiColor4ubVertex3fvSUN=GLee_Lazy_glReplacementCodeuiColor4ubVertex3fvSUN;
#endif
#ifndef GLEE_C_DEFINED_glReplacementCodeuiColor3fVertex3fSUN
#define GLEE_C_DEFINED_glReplacementCodeuiColor3fVertex3fSUN
  void __stdcall GLee_Lazy_glReplacementCodeuiColor3fVertex3fSUN(GLuint rc, GLfloat r, GLfloat g, GLfloat b, GLfloat x, GLfloat y, GLfloat z)  {if (GLeeInit()) glReplacementCodeuiColor3fVertex3fSUN(rc, r, g, b, x, y, z);}
  GLEEPFNGLREPLACEMENTCODEUICOLOR3FVERTEX3FSUNPROC GLeeFuncPtr_glReplacementCodeuiColor3fVertex3fSUN=GLee_Lazy_glReplacementCodeuiColor3fVertex3fSUN;
#endif
#ifndef GLEE_C_DEFINED_glReplacementCodeuiColor3fVertex3fvSUN
#define GLEE_C_DEFINED_glReplacementCodeuiColor3fVertex3fvSUN
  void __stdcall GLee_Lazy_glReplacementCodeuiColor3fVertex3fvSUN(const GLuint * rc, const GLfloat * c, const GLfloat * v)  {if (GLeeInit()) glReplacementCodeuiColor3fVertex3fvSUN(rc, c, v);}
  GLEEPFNGLREPLACEMENTCODEUICOLOR3FVERTEX3FVSUNPROC GLeeFuncPtr_glReplacementCodeuiColor3fVertex3fvSUN=GLee_Lazy_glReplacementCodeuiColor3fVertex3fvSUN;
#endif
#ifndef GLEE_C_DEFINED_glReplacementCodeuiNormal3fVertex3fSUN
#define GLEE_C_DEFINED_glReplacementCodeuiNormal3fVertex3fSUN
  void __stdcall GLee_Lazy_glReplacementCodeuiNormal3fVertex3fSUN(GLuint rc, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z)  {if (GLeeInit()) glReplacementCodeuiNormal3fVertex3fSUN(rc, nx, ny, nz, x, y, z);}
  GLEEPFNGLREPLACEMENTCODEUINORMAL3FVERTEX3FSUNPROC GLeeFuncPtr_glReplacementCodeuiNormal3fVertex3fSUN=GLee_Lazy_glReplacementCodeuiNormal3fVertex3fSUN;
#endif
#ifndef GLEE_C_DEFINED_glReplacementCodeuiNormal3fVertex3fvSUN
#define GLEE_C_DEFINED_glReplacementCodeuiNormal3fVertex3fvSUN
  void __stdcall GLee_Lazy_glReplacementCodeuiNormal3fVertex3fvSUN(const GLuint * rc, const GLfloat * n, const GLfloat * v)  {if (GLeeInit()) glReplacementCodeuiNormal3fVertex3fvSUN(rc, n, v);}
  GLEEPFNGLREPLACEMENTCODEUINORMAL3FVERTEX3FVSUNPROC GLeeFuncPtr_glReplacementCodeuiNormal3fVertex3fvSUN=GLee_Lazy_glReplacementCodeuiNormal3fVertex3fvSUN;
#endif
#ifndef GLEE_C_DEFINED_glReplacementCodeuiColor4fNormal3fVertex3fSUN
#define GLEE_C_DEFINED_glReplacementCodeuiColor4fNormal3fVertex3fSUN
  void __stdcall GLee_Lazy_glReplacementCodeuiColor4fNormal3fVertex3fSUN(GLuint rc, GLfloat r, GLfloat g, GLfloat b, GLfloat a, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z)  {if (GLeeInit()) glReplacementCodeuiColor4fNormal3fVertex3fSUN(rc, r, g, b, a, nx, ny, nz, x, y, z);}
  GLEEPFNGLREPLACEMENTCODEUICOLOR4FNORMAL3FVERTEX3FSUNPROC GLeeFuncPtr_glReplacementCodeuiColor4fNormal3fVertex3fSUN=GLee_Lazy_glReplacementCodeuiColor4fNormal3fVertex3fSUN;
#endif
#ifndef GLEE_C_DEFINED_glReplacementCodeuiColor4fNormal3fVertex3fvSUN
#define GLEE_C_DEFINED_glReplacementCodeuiColor4fNormal3fVertex3fvSUN
  void __stdcall GLee_Lazy_glReplacementCodeuiColor4fNormal3fVertex3fvSUN(const GLuint * rc, const GLfloat * c, const GLfloat * n, const GLfloat * v)  {if (GLeeInit()) glReplacementCodeuiColor4fNormal3fVertex3fvSUN(rc, c, n, v);}
  GLEEPFNGLREPLACEMENTCODEUICOLOR4FNORMAL3FVERTEX3FVSUNPROC GLeeFuncPtr_glReplacementCodeuiColor4fNormal3fVertex3fvSUN=GLee_Lazy_glReplacementCodeuiColor4fNormal3fVertex3fvSUN;
#endif
#ifndef GLEE_C_DEFINED_glReplacementCodeuiTexCoord2fVertex3fSUN
#define GLEE_C_DEFINED_glReplacementCodeuiTexCoord2fVertex3fSUN
  void __stdcall GLee_Lazy_glReplacementCodeuiTexCoord2fVertex3fSUN(GLuint rc, GLfloat s, GLfloat t, GLfloat x, GLfloat y, GLfloat z)  {if (GLeeInit()) glReplacementCodeuiTexCoord2fVertex3fSUN(rc, s, t, x, y, z);}
  GLEEPFNGLREPLACEMENTCODEUITEXCOORD2FVERTEX3FSUNPROC GLeeFuncPtr_glReplacementCodeuiTexCoord2fVertex3fSUN=GLee_Lazy_glReplacementCodeuiTexCoord2fVertex3fSUN;
#endif
#ifndef GLEE_C_DEFINED_glReplacementCodeuiTexCoord2fVertex3fvSUN
#define GLEE_C_DEFINED_glReplacementCodeuiTexCoord2fVertex3fvSUN
  void __stdcall GLee_Lazy_glReplacementCodeuiTexCoord2fVertex3fvSUN(const GLuint * rc, const GLfloat * tc, const GLfloat * v)  {if (GLeeInit()) glReplacementCodeuiTexCoord2fVertex3fvSUN(rc, tc, v);}
  GLEEPFNGLREPLACEMENTCODEUITEXCOORD2FVERTEX3FVSUNPROC GLeeFuncPtr_glReplacementCodeuiTexCoord2fVertex3fvSUN=GLee_Lazy_glReplacementCodeuiTexCoord2fVertex3fvSUN;
#endif
#ifndef GLEE_C_DEFINED_glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN
#define GLEE_C_DEFINED_glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN
  void __stdcall GLee_Lazy_glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN(GLuint rc, GLfloat s, GLfloat t, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z)  {if (GLeeInit()) glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN(rc, s, t, nx, ny, nz, x, y, z);}
  GLEEPFNGLREPLACEMENTCODEUITEXCOORD2FNORMAL3FVERTEX3FSUNPROC GLeeFuncPtr_glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN=GLee_Lazy_glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN;
#endif
#ifndef GLEE_C_DEFINED_glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN
#define GLEE_C_DEFINED_glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN
  void __stdcall GLee_Lazy_glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN(const GLuint * rc, const GLfloat * tc, const GLfloat * n, const GLfloat * v)  {if (GLeeInit()) glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN(rc, tc, n, v);}
  GLEEPFNGLREPLACEMENTCODEUITEXCOORD2FNORMAL3FVERTEX3FVSUNPROC GLeeFuncPtr_glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN=GLee_Lazy_glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN;
#endif
#ifndef GLEE_C_DEFINED_glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN
#define GLEE_C_DEFINED_glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN
  void __stdcall GLee_Lazy_glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN(GLuint rc, GLfloat s, GLfloat t, GLfloat r, GLfloat g, GLfloat b, GLfloat a, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z)  {if (GLeeInit()) glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN(rc, s, t, r, g, b, a, nx, ny, nz, x, y, z);}
  GLEEPFNGLREPLACEMENTCODEUITEXCOORD2FCOLOR4FNORMAL3FVERTEX3FSUNPROC GLeeFuncPtr_glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN=GLee_Lazy_glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN;
#endif
#ifndef GLEE_C_DEFINED_glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN
#define GLEE_C_DEFINED_glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN
  void __stdcall GLee_Lazy_glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN(const GLuint * rc, const GLfloat * tc, const GLfloat * c, const GLfloat * n, const GLfloat * v)  {if (GLeeInit()) glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN(rc, tc, c, n, v);}
  GLEEPFNGLREPLACEMENTCODEUITEXCOORD2FCOLOR4FNORMAL3FVERTEX3FVSUNPROC GLeeFuncPtr_glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN=GLee_Lazy_glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN;
#endif
#endif 

/* GL_EXT_blend_func_separate */

#ifdef __GLEE_GL_EXT_blend_func_separate
#ifndef GLEE_C_DEFINED_glBlendFuncSeparateEXT
#define GLEE_C_DEFINED_glBlendFuncSeparateEXT
  void __stdcall GLee_Lazy_glBlendFuncSeparateEXT(GLenum sfactorRGB, GLenum dfactorRGB, GLenum sfactorAlpha, GLenum dfactorAlpha)  {if (GLeeInit()) glBlendFuncSeparateEXT(sfactorRGB, dfactorRGB, sfactorAlpha, dfactorAlpha);}
  GLEEPFNGLBLENDFUNCSEPARATEEXTPROC GLeeFuncPtr_glBlendFuncSeparateEXT=GLee_Lazy_glBlendFuncSeparateEXT;
#endif
#endif 

/* GL_INGR_color_clamp */

#ifdef __GLEE_GL_INGR_color_clamp
#endif 

/* GL_INGR_interlace_read */

#ifdef __GLEE_GL_INGR_interlace_read
#endif 

/* GL_EXT_stencil_wrap */

#ifdef __GLEE_GL_EXT_stencil_wrap
#endif 

/* GL_EXT_422_pixels */

#ifdef __GLEE_GL_EXT_422_pixels
#endif 

/* GL_NV_texgen_reflection */

#ifdef __GLEE_GL_NV_texgen_reflection
#endif 

/* GL_EXT_texture_cube_map */

#ifdef __GLEE_GL_EXT_texture_cube_map
#endif 

/* GL_SUN_convolution_border_modes */

#ifdef __GLEE_GL_SUN_convolution_border_modes
#endif 

/* GL_EXT_texture_env_add */

#ifdef __GLEE_GL_EXT_texture_env_add
#endif 

/* GL_EXT_texture_lod_bias */

#ifdef __GLEE_GL_EXT_texture_lod_bias
#endif 

/* GL_EXT_texture_filter_anisotropic */

#ifdef __GLEE_GL_EXT_texture_filter_anisotropic
#endif 

/* GL_EXT_vertex_weighting */

#ifdef __GLEE_GL_EXT_vertex_weighting
#ifndef GLEE_C_DEFINED_glVertexWeightfEXT
#define GLEE_C_DEFINED_glVertexWeightfEXT
  void __stdcall GLee_Lazy_glVertexWeightfEXT(GLfloat weight)  {if (GLeeInit()) glVertexWeightfEXT(weight);}
  GLEEPFNGLVERTEXWEIGHTFEXTPROC GLeeFuncPtr_glVertexWeightfEXT=GLee_Lazy_glVertexWeightfEXT;
#endif
#ifndef GLEE_C_DEFINED_glVertexWeightfvEXT
#define GLEE_C_DEFINED_glVertexWeightfvEXT
  void __stdcall GLee_Lazy_glVertexWeightfvEXT(const GLfloat * weight)  {if (GLeeInit()) glVertexWeightfvEXT(weight);}
  GLEEPFNGLVERTEXWEIGHTFVEXTPROC GLeeFuncPtr_glVertexWeightfvEXT=GLee_Lazy_glVertexWeightfvEXT;
#endif
#ifndef GLEE_C_DEFINED_glVertexWeightPointerEXT
#define GLEE_C_DEFINED_glVertexWeightPointerEXT
  void __stdcall GLee_Lazy_glVertexWeightPointerEXT(GLsizei size, GLenum type, GLsizei stride, const GLvoid * pointer)  {if (GLeeInit()) glVertexWeightPointerEXT(size, type, stride, pointer);}
  GLEEPFNGLVERTEXWEIGHTPOINTEREXTPROC GLeeFuncPtr_glVertexWeightPointerEXT=GLee_Lazy_glVertexWeightPointerEXT;
#endif
#endif 

/* GL_NV_light_max_exponent */

#ifdef __GLEE_GL_NV_light_max_exponent
#endif 

/* GL_NV_vertex_array_range */

#ifdef __GLEE_GL_NV_vertex_array_range
#ifndef GLEE_C_DEFINED_glFlushVertexArrayRangeNV
#define GLEE_C_DEFINED_glFlushVertexArrayRangeNV
  void __stdcall GLee_Lazy_glFlushVertexArrayRangeNV(void)  {if (GLeeInit()) glFlushVertexArrayRangeNV();}
  GLEEPFNGLFLUSHVERTEXARRAYRANGENVPROC GLeeFuncPtr_glFlushVertexArrayRangeNV=GLee_Lazy_glFlushVertexArrayRangeNV;
#endif
#ifndef GLEE_C_DEFINED_glVertexArrayRangeNV
#define GLEE_C_DEFINED_glVertexArrayRangeNV
  void __stdcall GLee_Lazy_glVertexArrayRangeNV(GLsizei length, const GLvoid * pointer)  {if (GLeeInit()) glVertexArrayRangeNV(length, pointer);}
  GLEEPFNGLVERTEXARRAYRANGENVPROC GLeeFuncPtr_glVertexArrayRangeNV=GLee_Lazy_glVertexArrayRangeNV;
#endif
#endif 

/* GL_NV_register_combiners */

#ifdef __GLEE_GL_NV_register_combiners
#ifndef GLEE_C_DEFINED_glCombinerParameterfvNV
#define GLEE_C_DEFINED_glCombinerParameterfvNV
  void __stdcall GLee_Lazy_glCombinerParameterfvNV(GLenum pname, const GLfloat * params)  {if (GLeeInit()) glCombinerParameterfvNV(pname, params);}
  GLEEPFNGLCOMBINERPARAMETERFVNVPROC GLeeFuncPtr_glCombinerParameterfvNV=GLee_Lazy_glCombinerParameterfvNV;
#endif
#ifndef GLEE_C_DEFINED_glCombinerParameterfNV
#define GLEE_C_DEFINED_glCombinerParameterfNV
  void __stdcall GLee_Lazy_glCombinerParameterfNV(GLenum pname, GLfloat param)  {if (GLeeInit()) glCombinerParameterfNV(pname, param);}
  GLEEPFNGLCOMBINERPARAMETERFNVPROC GLeeFuncPtr_glCombinerParameterfNV=GLee_Lazy_glCombinerParameterfNV;
#endif
#ifndef GLEE_C_DEFINED_glCombinerParameterivNV
#define GLEE_C_DEFINED_glCombinerParameterivNV
  void __stdcall GLee_Lazy_glCombinerParameterivNV(GLenum pname, const GLint * params)  {if (GLeeInit()) glCombinerParameterivNV(pname, params);}
  GLEEPFNGLCOMBINERPARAMETERIVNVPROC GLeeFuncPtr_glCombinerParameterivNV=GLee_Lazy_glCombinerParameterivNV;
#endif
#ifndef GLEE_C_DEFINED_glCombinerParameteriNV
#define GLEE_C_DEFINED_glCombinerParameteriNV
  void __stdcall GLee_Lazy_glCombinerParameteriNV(GLenum pname, GLint param)  {if (GLeeInit()) glCombinerParameteriNV(pname, param);}
  GLEEPFNGLCOMBINERPARAMETERINVPROC GLeeFuncPtr_glCombinerParameteriNV=GLee_Lazy_glCombinerParameteriNV;
#endif
#ifndef GLEE_C_DEFINED_glCombinerInputNV
#define GLEE_C_DEFINED_glCombinerInputNV
  void __stdcall GLee_Lazy_glCombinerInputNV(GLenum stage, GLenum portion, GLenum variable, GLenum input, GLenum mapping, GLenum componentUsage)  {if (GLeeInit()) glCombinerInputNV(stage, portion, variable, input, mapping, componentUsage);}
  GLEEPFNGLCOMBINERINPUTNVPROC GLeeFuncPtr_glCombinerInputNV=GLee_Lazy_glCombinerInputNV;
#endif
#ifndef GLEE_C_DEFINED_glCombinerOutputNV
#define GLEE_C_DEFINED_glCombinerOutputNV
  void __stdcall GLee_Lazy_glCombinerOutputNV(GLenum stage, GLenum portion, GLenum abOutput, GLenum cdOutput, GLenum sumOutput, GLenum scale, GLenum bias, GLboolean abDotProduct, GLboolean cdDotProduct, GLboolean muxSum)  {if (GLeeInit()) glCombinerOutputNV(stage, portion, abOutput, cdOutput, sumOutput, scale, bias, abDotProduct, cdDotProduct, muxSum);}
  GLEEPFNGLCOMBINEROUTPUTNVPROC GLeeFuncPtr_glCombinerOutputNV=GLee_Lazy_glCombinerOutputNV;
#endif
#ifndef GLEE_C_DEFINED_glFinalCombinerInputNV
#define GLEE_C_DEFINED_glFinalCombinerInputNV
  void __stdcall GLee_Lazy_glFinalCombinerInputNV(GLenum variable, GLenum input, GLenum mapping, GLenum componentUsage)  {if (GLeeInit()) glFinalCombinerInputNV(variable, input, mapping, componentUsage);}
  GLEEPFNGLFINALCOMBINERINPUTNVPROC GLeeFuncPtr_glFinalCombinerInputNV=GLee_Lazy_glFinalCombinerInputNV;
#endif
#ifndef GLEE_C_DEFINED_glGetCombinerInputParameterfvNV
#define GLEE_C_DEFINED_glGetCombinerInputParameterfvNV
  void __stdcall GLee_Lazy_glGetCombinerInputParameterfvNV(GLenum stage, GLenum portion, GLenum variable, GLenum pname, GLfloat * params)  {if (GLeeInit()) glGetCombinerInputParameterfvNV(stage, portion, variable, pname, params);}
  GLEEPFNGLGETCOMBINERINPUTPARAMETERFVNVPROC GLeeFuncPtr_glGetCombinerInputParameterfvNV=GLee_Lazy_glGetCombinerInputParameterfvNV;
#endif
#ifndef GLEE_C_DEFINED_glGetCombinerInputParameterivNV
#define GLEE_C_DEFINED_glGetCombinerInputParameterivNV
  void __stdcall GLee_Lazy_glGetCombinerInputParameterivNV(GLenum stage, GLenum portion, GLenum variable, GLenum pname, GLint * params)  {if (GLeeInit()) glGetCombinerInputParameterivNV(stage, portion, variable, pname, params);}
  GLEEPFNGLGETCOMBINERINPUTPARAMETERIVNVPROC GLeeFuncPtr_glGetCombinerInputParameterivNV=GLee_Lazy_glGetCombinerInputParameterivNV;
#endif
#ifndef GLEE_C_DEFINED_glGetCombinerOutputParameterfvNV
#define GLEE_C_DEFINED_glGetCombinerOutputParameterfvNV
  void __stdcall GLee_Lazy_glGetCombinerOutputParameterfvNV(GLenum stage, GLenum portion, GLenum pname, GLfloat * params)  {if (GLeeInit()) glGetCombinerOutputParameterfvNV(stage, portion, pname, params);}
  GLEEPFNGLGETCOMBINEROUTPUTPARAMETERFVNVPROC GLeeFuncPtr_glGetCombinerOutputParameterfvNV=GLee_Lazy_glGetCombinerOutputParameterfvNV;
#endif
#ifndef GLEE_C_DEFINED_glGetCombinerOutputParameterivNV
#define GLEE_C_DEFINED_glGetCombinerOutputParameterivNV
  void __stdcall GLee_Lazy_glGetCombinerOutputParameterivNV(GLenum stage, GLenum portion, GLenum pname, GLint * params)  {if (GLeeInit()) glGetCombinerOutputParameterivNV(stage, portion, pname, params);}
  GLEEPFNGLGETCOMBINEROUTPUTPARAMETERIVNVPROC GLeeFuncPtr_glGetCombinerOutputParameterivNV=GLee_Lazy_glGetCombinerOutputParameterivNV;
#endif
#ifndef GLEE_C_DEFINED_glGetFinalCombinerInputParameterfvNV
#define GLEE_C_DEFINED_glGetFinalCombinerInputParameterfvNV
  void __stdcall GLee_Lazy_glGetFinalCombinerInputParameterfvNV(GLenum variable, GLenum pname, GLfloat * params)  {if (GLeeInit()) glGetFinalCombinerInputParameterfvNV(variable, pname, params);}
  GLEEPFNGLGETFINALCOMBINERINPUTPARAMETERFVNVPROC GLeeFuncPtr_glGetFinalCombinerInputParameterfvNV=GLee_Lazy_glGetFinalCombinerInputParameterfvNV;
#endif
#ifndef GLEE_C_DEFINED_glGetFinalCombinerInputParameterivNV
#define GLEE_C_DEFINED_glGetFinalCombinerInputParameterivNV
  void __stdcall GLee_Lazy_glGetFinalCombinerInputParameterivNV(GLenum variable, GLenum pname, GLint * params)  {if (GLeeInit()) glGetFinalCombinerInputParameterivNV(variable, pname, params);}
  GLEEPFNGLGETFINALCOMBINERINPUTPARAMETERIVNVPROC GLeeFuncPtr_glGetFinalCombinerInputParameterivNV=GLee_Lazy_glGetFinalCombinerInputParameterivNV;
#endif
#endif 

/* GL_NV_fog_distance */

#ifdef __GLEE_GL_NV_fog_distance
#endif 

/* GL_NV_texgen_emboss */

#ifdef __GLEE_GL_NV_texgen_emboss
#endif 

/* GL_NV_blend_square */

#ifdef __GLEE_GL_NV_blend_square
#endif 

/* GL_NV_texture_env_combine4 */

#ifdef __GLEE_GL_NV_texture_env_combine4
#endif 

/* GL_MESA_resize_buffers */

#ifdef __GLEE_GL_MESA_resize_buffers
#ifndef GLEE_C_DEFINED_glResizeBuffersMESA
#define GLEE_C_DEFINED_glResizeBuffersMESA
  void __stdcall GLee_Lazy_glResizeBuffersMESA(void)  {if (GLeeInit()) glResizeBuffersMESA();}
  GLEEPFNGLRESIZEBUFFERSMESAPROC GLeeFuncPtr_glResizeBuffersMESA=GLee_Lazy_glResizeBuffersMESA;
#endif
#endif 

/* GL_MESA_window_pos */

#ifdef __GLEE_GL_MESA_window_pos
#ifndef GLEE_C_DEFINED_glWindowPos2dMESA
#define GLEE_C_DEFINED_glWindowPos2dMESA
  void __stdcall GLee_Lazy_glWindowPos2dMESA(GLdouble x, GLdouble y)  {if (GLeeInit()) glWindowPos2dMESA(x, y);}
  GLEEPFNGLWINDOWPOS2DMESAPROC GLeeFuncPtr_glWindowPos2dMESA=GLee_Lazy_glWindowPos2dMESA;
#endif
#ifndef GLEE_C_DEFINED_glWindowPos2dvMESA
#define GLEE_C_DEFINED_glWindowPos2dvMESA
  void __stdcall GLee_Lazy_glWindowPos2dvMESA(const GLdouble * v)  {if (GLeeInit()) glWindowPos2dvMESA(v);}
  GLEEPFNGLWINDOWPOS2DVMESAPROC GLeeFuncPtr_glWindowPos2dvMESA=GLee_Lazy_glWindowPos2dvMESA;
#endif
#ifndef GLEE_C_DEFINED_glWindowPos2fMESA
#define GLEE_C_DEFINED_glWindowPos2fMESA
  void __stdcall GLee_Lazy_glWindowPos2fMESA(GLfloat x, GLfloat y)  {if (GLeeInit()) glWindowPos2fMESA(x, y);}
  GLEEPFNGLWINDOWPOS2FMESAPROC GLeeFuncPtr_glWindowPos2fMESA=GLee_Lazy_glWindowPos2fMESA;
#endif
#ifndef GLEE_C_DEFINED_glWindowPos2fvMESA
#define GLEE_C_DEFINED_glWindowPos2fvMESA
  void __stdcall GLee_Lazy_glWindowPos2fvMESA(const GLfloat * v)  {if (GLeeInit()) glWindowPos2fvMESA(v);}
  GLEEPFNGLWINDOWPOS2FVMESAPROC GLeeFuncPtr_glWindowPos2fvMESA=GLee_Lazy_glWindowPos2fvMESA;
#endif
#ifndef GLEE_C_DEFINED_glWindowPos2iMESA
#define GLEE_C_DEFINED_glWindowPos2iMESA
  void __stdcall GLee_Lazy_glWindowPos2iMESA(GLint x, GLint y)  {if (GLeeInit()) glWindowPos2iMESA(x, y);}
  GLEEPFNGLWINDOWPOS2IMESAPROC GLeeFuncPtr_glWindowPos2iMESA=GLee_Lazy_glWindowPos2iMESA;
#endif
#ifndef GLEE_C_DEFINED_glWindowPos2ivMESA
#define GLEE_C_DEFINED_glWindowPos2ivMESA
  void __stdcall GLee_Lazy_glWindowPos2ivMESA(const GLint * v)  {if (GLeeInit()) glWindowPos2ivMESA(v);}
  GLEEPFNGLWINDOWPOS2IVMESAPROC GLeeFuncPtr_glWindowPos2ivMESA=GLee_Lazy_glWindowPos2ivMESA;
#endif
#ifndef GLEE_C_DEFINED_glWindowPos2sMESA
#define GLEE_C_DEFINED_glWindowPos2sMESA
  void __stdcall GLee_Lazy_glWindowPos2sMESA(GLshort x, GLshort y)  {if (GLeeInit()) glWindowPos2sMESA(x, y);}
  GLEEPFNGLWINDOWPOS2SMESAPROC GLeeFuncPtr_glWindowPos2sMESA=GLee_Lazy_glWindowPos2sMESA;
#endif
#ifndef GLEE_C_DEFINED_glWindowPos2svMESA
#define GLEE_C_DEFINED_glWindowPos2svMESA
  void __stdcall GLee_Lazy_glWindowPos2svMESA(const GLshort * v)  {if (GLeeInit()) glWindowPos2svMESA(v);}
  GLEEPFNGLWINDOWPOS2SVMESAPROC GLeeFuncPtr_glWindowPos2svMESA=GLee_Lazy_glWindowPos2svMESA;
#endif
#ifndef GLEE_C_DEFINED_glWindowPos3dMESA
#define GLEE_C_DEFINED_glWindowPos3dMESA
  void __stdcall GLee_Lazy_glWindowPos3dMESA(GLdouble x, GLdouble y, GLdouble z)  {if (GLeeInit()) glWindowPos3dMESA(x, y, z);}
  GLEEPFNGLWINDOWPOS3DMESAPROC GLeeFuncPtr_glWindowPos3dMESA=GLee_Lazy_glWindowPos3dMESA;
#endif
#ifndef GLEE_C_DEFINED_glWindowPos3dvMESA
#define GLEE_C_DEFINED_glWindowPos3dvMESA
  void __stdcall GLee_Lazy_glWindowPos3dvMESA(const GLdouble * v)  {if (GLeeInit()) glWindowPos3dvMESA(v);}
  GLEEPFNGLWINDOWPOS3DVMESAPROC GLeeFuncPtr_glWindowPos3dvMESA=GLee_Lazy_glWindowPos3dvMESA;
#endif
#ifndef GLEE_C_DEFINED_glWindowPos3fMESA
#define GLEE_C_DEFINED_glWindowPos3fMESA
  void __stdcall GLee_Lazy_glWindowPos3fMESA(GLfloat x, GLfloat y, GLfloat z)  {if (GLeeInit()) glWindowPos3fMESA(x, y, z);}
  GLEEPFNGLWINDOWPOS3FMESAPROC GLeeFuncPtr_glWindowPos3fMESA=GLee_Lazy_glWindowPos3fMESA;
#endif
#ifndef GLEE_C_DEFINED_glWindowPos3fvMESA
#define GLEE_C_DEFINED_glWindowPos3fvMESA
  void __stdcall GLee_Lazy_glWindowPos3fvMESA(const GLfloat * v)  {if (GLeeInit()) glWindowPos3fvMESA(v);}
  GLEEPFNGLWINDOWPOS3FVMESAPROC GLeeFuncPtr_glWindowPos3fvMESA=GLee_Lazy_glWindowPos3fvMESA;
#endif
#ifndef GLEE_C_DEFINED_glWindowPos3iMESA
#define GLEE_C_DEFINED_glWindowPos3iMESA
  void __stdcall GLee_Lazy_glWindowPos3iMESA(GLint x, GLint y, GLint z)  {if (GLeeInit()) glWindowPos3iMESA(x, y, z);}
  GLEEPFNGLWINDOWPOS3IMESAPROC GLeeFuncPtr_glWindowPos3iMESA=GLee_Lazy_glWindowPos3iMESA;
#endif
#ifndef GLEE_C_DEFINED_glWindowPos3ivMESA
#define GLEE_C_DEFINED_glWindowPos3ivMESA
  void __stdcall GLee_Lazy_glWindowPos3ivMESA(const GLint * v)  {if (GLeeInit()) glWindowPos3ivMESA(v);}
  GLEEPFNGLWINDOWPOS3IVMESAPROC GLeeFuncPtr_glWindowPos3ivMESA=GLee_Lazy_glWindowPos3ivMESA;
#endif
#ifndef GLEE_C_DEFINED_glWindowPos3sMESA
#define GLEE_C_DEFINED_glWindowPos3sMESA
  void __stdcall GLee_Lazy_glWindowPos3sMESA(GLshort x, GLshort y, GLshort z)  {if (GLeeInit()) glWindowPos3sMESA(x, y, z);}
  GLEEPFNGLWINDOWPOS3SMESAPROC GLeeFuncPtr_glWindowPos3sMESA=GLee_Lazy_glWindowPos3sMESA;
#endif
#ifndef GLEE_C_DEFINED_glWindowPos3svMESA
#define GLEE_C_DEFINED_glWindowPos3svMESA
  void __stdcall GLee_Lazy_glWindowPos3svMESA(const GLshort * v)  {if (GLeeInit()) glWindowPos3svMESA(v);}
  GLEEPFNGLWINDOWPOS3SVMESAPROC GLeeFuncPtr_glWindowPos3svMESA=GLee_Lazy_glWindowPos3svMESA;
#endif
#ifndef GLEE_C_DEFINED_glWindowPos4dMESA
#define GLEE_C_DEFINED_glWindowPos4dMESA
  void __stdcall GLee_Lazy_glWindowPos4dMESA(GLdouble x, GLdouble y, GLdouble z, GLdouble w)  {if (GLeeInit()) glWindowPos4dMESA(x, y, z, w);}
  GLEEPFNGLWINDOWPOS4DMESAPROC GLeeFuncPtr_glWindowPos4dMESA=GLee_Lazy_glWindowPos4dMESA;
#endif
#ifndef GLEE_C_DEFINED_glWindowPos4dvMESA
#define GLEE_C_DEFINED_glWindowPos4dvMESA
  void __stdcall GLee_Lazy_glWindowPos4dvMESA(const GLdouble * v)  {if (GLeeInit()) glWindowPos4dvMESA(v);}
  GLEEPFNGLWINDOWPOS4DVMESAPROC GLeeFuncPtr_glWindowPos4dvMESA=GLee_Lazy_glWindowPos4dvMESA;
#endif
#ifndef GLEE_C_DEFINED_glWindowPos4fMESA
#define GLEE_C_DEFINED_glWindowPos4fMESA
  void __stdcall GLee_Lazy_glWindowPos4fMESA(GLfloat x, GLfloat y, GLfloat z, GLfloat w)  {if (GLeeInit()) glWindowPos4fMESA(x, y, z, w);}
  GLEEPFNGLWINDOWPOS4FMESAPROC GLeeFuncPtr_glWindowPos4fMESA=GLee_Lazy_glWindowPos4fMESA;
#endif
#ifndef GLEE_C_DEFINED_glWindowPos4fvMESA
#define GLEE_C_DEFINED_glWindowPos4fvMESA
  void __stdcall GLee_Lazy_glWindowPos4fvMESA(const GLfloat * v)  {if (GLeeInit()) glWindowPos4fvMESA(v);}
  GLEEPFNGLWINDOWPOS4FVMESAPROC GLeeFuncPtr_glWindowPos4fvMESA=GLee_Lazy_glWindowPos4fvMESA;
#endif
#ifndef GLEE_C_DEFINED_glWindowPos4iMESA
#define GLEE_C_DEFINED_glWindowPos4iMESA
  void __stdcall GLee_Lazy_glWindowPos4iMESA(GLint x, GLint y, GLint z, GLint w)  {if (GLeeInit()) glWindowPos4iMESA(x, y, z, w);}
  GLEEPFNGLWINDOWPOS4IMESAPROC GLeeFuncPtr_glWindowPos4iMESA=GLee_Lazy_glWindowPos4iMESA;
#endif
#ifndef GLEE_C_DEFINED_glWindowPos4ivMESA
#define GLEE_C_DEFINED_glWindowPos4ivMESA
  void __stdcall GLee_Lazy_glWindowPos4ivMESA(const GLint * v)  {if (GLeeInit()) glWindowPos4ivMESA(v);}
  GLEEPFNGLWINDOWPOS4IVMESAPROC GLeeFuncPtr_glWindowPos4ivMESA=GLee_Lazy_glWindowPos4ivMESA;
#endif
#ifndef GLEE_C_DEFINED_glWindowPos4sMESA
#define GLEE_C_DEFINED_glWindowPos4sMESA
  void __stdcall GLee_Lazy_glWindowPos4sMESA(GLshort x, GLshort y, GLshort z, GLshort w)  {if (GLeeInit()) glWindowPos4sMESA(x, y, z, w);}
  GLEEPFNGLWINDOWPOS4SMESAPROC GLeeFuncPtr_glWindowPos4sMESA=GLee_Lazy_glWindowPos4sMESA;
#endif
#ifndef GLEE_C_DEFINED_glWindowPos4svMESA
#define GLEE_C_DEFINED_glWindowPos4svMESA
  void __stdcall GLee_Lazy_glWindowPos4svMESA(const GLshort * v)  {if (GLeeInit()) glWindowPos4svMESA(v);}
  GLEEPFNGLWINDOWPOS4SVMESAPROC GLeeFuncPtr_glWindowPos4svMESA=GLee_Lazy_glWindowPos4svMESA;
#endif
#endif 

/* GL_EXT_texture_compression_s3tc */

#ifdef __GLEE_GL_EXT_texture_compression_s3tc
#endif 

/* GL_IBM_cull_vertex */

#ifdef __GLEE_GL_IBM_cull_vertex
#endif 

/* GL_IBM_multimode_draw_arrays */

#ifdef __GLEE_GL_IBM_multimode_draw_arrays
#ifndef GLEE_C_DEFINED_glMultiModeDrawArraysIBM
#define GLEE_C_DEFINED_glMultiModeDrawArraysIBM
  void __stdcall GLee_Lazy_glMultiModeDrawArraysIBM(const GLenum * mode, const GLint * first, const GLsizei * count, GLsizei primcount, GLint modestride)  {if (GLeeInit()) glMultiModeDrawArraysIBM(mode, first, count, primcount, modestride);}
  GLEEPFNGLMULTIMODEDRAWARRAYSIBMPROC GLeeFuncPtr_glMultiModeDrawArraysIBM=GLee_Lazy_glMultiModeDrawArraysIBM;
#endif
#ifndef GLEE_C_DEFINED_glMultiModeDrawElementsIBM
#define GLEE_C_DEFINED_glMultiModeDrawElementsIBM
  void __stdcall GLee_Lazy_glMultiModeDrawElementsIBM(const GLenum * mode, const GLsizei * count, GLenum type, const GLvoid* const * indices, GLsizei primcount, GLint modestride)  {if (GLeeInit()) glMultiModeDrawElementsIBM(mode, count, type, indices, primcount, modestride);}
  GLEEPFNGLMULTIMODEDRAWELEMENTSIBMPROC GLeeFuncPtr_glMultiModeDrawElementsIBM=GLee_Lazy_glMultiModeDrawElementsIBM;
#endif
#endif 

/* GL_IBM_vertex_array_lists */

#ifdef __GLEE_GL_IBM_vertex_array_lists
#ifndef GLEE_C_DEFINED_glColorPointerListIBM
#define GLEE_C_DEFINED_glColorPointerListIBM
  void __stdcall GLee_Lazy_glColorPointerListIBM(GLint size, GLenum type, GLint stride, const GLvoid* * pointer, GLint ptrstride)  {if (GLeeInit()) glColorPointerListIBM(size, type, stride, pointer, ptrstride);}
  GLEEPFNGLCOLORPOINTERLISTIBMPROC GLeeFuncPtr_glColorPointerListIBM=GLee_Lazy_glColorPointerListIBM;
#endif
#ifndef GLEE_C_DEFINED_glSecondaryColorPointerListIBM
#define GLEE_C_DEFINED_glSecondaryColorPointerListIBM
  void __stdcall GLee_Lazy_glSecondaryColorPointerListIBM(GLint size, GLenum type, GLint stride, const GLvoid* * pointer, GLint ptrstride)  {if (GLeeInit()) glSecondaryColorPointerListIBM(size, type, stride, pointer, ptrstride);}
  GLEEPFNGLSECONDARYCOLORPOINTERLISTIBMPROC GLeeFuncPtr_glSecondaryColorPointerListIBM=GLee_Lazy_glSecondaryColorPointerListIBM;
#endif
#ifndef GLEE_C_DEFINED_glEdgeFlagPointerListIBM
#define GLEE_C_DEFINED_glEdgeFlagPointerListIBM
  void __stdcall GLee_Lazy_glEdgeFlagPointerListIBM(GLint stride, const GLboolean* * pointer, GLint ptrstride)  {if (GLeeInit()) glEdgeFlagPointerListIBM(stride, pointer, ptrstride);}
  GLEEPFNGLEDGEFLAGPOINTERLISTIBMPROC GLeeFuncPtr_glEdgeFlagPointerListIBM=GLee_Lazy_glEdgeFlagPointerListIBM;
#endif
#ifndef GLEE_C_DEFINED_glFogCoordPointerListIBM
#define GLEE_C_DEFINED_glFogCoordPointerListIBM
  void __stdcall GLee_Lazy_glFogCoordPointerListIBM(GLenum type, GLint stride, const GLvoid* * pointer, GLint ptrstride)  {if (GLeeInit()) glFogCoordPointerListIBM(type, stride, pointer, ptrstride);}
  GLEEPFNGLFOGCOORDPOINTERLISTIBMPROC GLeeFuncPtr_glFogCoordPointerListIBM=GLee_Lazy_glFogCoordPointerListIBM;
#endif
#ifndef GLEE_C_DEFINED_glIndexPointerListIBM
#define GLEE_C_DEFINED_glIndexPointerListIBM
  void __stdcall GLee_Lazy_glIndexPointerListIBM(GLenum type, GLint stride, const GLvoid* * pointer, GLint ptrstride)  {if (GLeeInit()) glIndexPointerListIBM(type, stride, pointer, ptrstride);}
  GLEEPFNGLINDEXPOINTERLISTIBMPROC GLeeFuncPtr_glIndexPointerListIBM=GLee_Lazy_glIndexPointerListIBM;
#endif
#ifndef GLEE_C_DEFINED_glNormalPointerListIBM
#define GLEE_C_DEFINED_glNormalPointerListIBM
  void __stdcall GLee_Lazy_glNormalPointerListIBM(GLenum type, GLint stride, const GLvoid* * pointer, GLint ptrstride)  {if (GLeeInit()) glNormalPointerListIBM(type, stride, pointer, ptrstride);}
  GLEEPFNGLNORMALPOINTERLISTIBMPROC GLeeFuncPtr_glNormalPointerListIBM=GLee_Lazy_glNormalPointerListIBM;
#endif
#ifndef GLEE_C_DEFINED_glTexCoordPointerListIBM
#define GLEE_C_DEFINED_glTexCoordPointerListIBM
  void __stdcall GLee_Lazy_glTexCoordPointerListIBM(GLint size, GLenum type, GLint stride, const GLvoid* * pointer, GLint ptrstride)  {if (GLeeInit()) glTexCoordPointerListIBM(size, type, stride, pointer, ptrstride);}
  GLEEPFNGLTEXCOORDPOINTERLISTIBMPROC GLeeFuncPtr_glTexCoordPointerListIBM=GLee_Lazy_glTexCoordPointerListIBM;
#endif
#ifndef GLEE_C_DEFINED_glVertexPointerListIBM
#define GLEE_C_DEFINED_glVertexPointerListIBM
  void __stdcall GLee_Lazy_glVertexPointerListIBM(GLint size, GLenum type, GLint stride, const GLvoid* * pointer, GLint ptrstride)  {if (GLeeInit()) glVertexPointerListIBM(size, type, stride, pointer, ptrstride);}
  GLEEPFNGLVERTEXPOINTERLISTIBMPROC GLeeFuncPtr_glVertexPointerListIBM=GLee_Lazy_glVertexPointerListIBM;
#endif
#endif 

/* GL_SGIX_subsample */

#ifdef __GLEE_GL_SGIX_subsample
#endif 

/* GL_SGIX_ycrcb_subsample */

#ifdef __GLEE_GL_SGIX_ycrcb_subsample
#endif 

/* GL_SGIX_ycrcba */

#ifdef __GLEE_GL_SGIX_ycrcba
#endif 

/* GL_SGI_depth_pass_instrument */

#ifdef __GLEE_GL_SGI_depth_pass_instrument
#endif 

/* GL_3DFX_texture_compression_FXT1 */

#ifdef __GLEE_GL_3DFX_texture_compression_FXT1
#endif 

/* GL_3DFX_multisample */

#ifdef __GLEE_GL_3DFX_multisample
#endif 

/* GL_3DFX_tbuffer */

#ifdef __GLEE_GL_3DFX_tbuffer
#ifndef GLEE_C_DEFINED_glTbufferMask3DFX
#define GLEE_C_DEFINED_glTbufferMask3DFX
  void __stdcall GLee_Lazy_glTbufferMask3DFX(GLuint mask)  {if (GLeeInit()) glTbufferMask3DFX(mask);}
  GLEEPFNGLTBUFFERMASK3DFXPROC GLeeFuncPtr_glTbufferMask3DFX=GLee_Lazy_glTbufferMask3DFX;
#endif
#endif 

/* GL_EXT_multisample */

#ifdef __GLEE_GL_EXT_multisample
#ifndef GLEE_C_DEFINED_glSampleMaskEXT
#define GLEE_C_DEFINED_glSampleMaskEXT
  void __stdcall GLee_Lazy_glSampleMaskEXT(GLclampf value, GLboolean invert)  {if (GLeeInit()) glSampleMaskEXT(value, invert);}
  GLEEPFNGLSAMPLEMASKEXTPROC GLeeFuncPtr_glSampleMaskEXT=GLee_Lazy_glSampleMaskEXT;
#endif
#ifndef GLEE_C_DEFINED_glSamplePatternEXT
#define GLEE_C_DEFINED_glSamplePatternEXT
  void __stdcall GLee_Lazy_glSamplePatternEXT(GLenum pattern)  {if (GLeeInit()) glSamplePatternEXT(pattern);}
  GLEEPFNGLSAMPLEPATTERNEXTPROC GLeeFuncPtr_glSamplePatternEXT=GLee_Lazy_glSamplePatternEXT;
#endif
#endif 

/* GL_SGIX_vertex_preclip */

#ifdef __GLEE_GL_SGIX_vertex_preclip
#endif 

/* GL_SGIX_convolution_accuracy */

#ifdef __GLEE_GL_SGIX_convolution_accuracy
#endif 

/* GL_SGIX_resample */

#ifdef __GLEE_GL_SGIX_resample
#endif 

/* GL_SGIS_point_line_texgen */

#ifdef __GLEE_GL_SGIS_point_line_texgen
#endif 

/* GL_SGIS_texture_color_mask */

#ifdef __GLEE_GL_SGIS_texture_color_mask
#ifndef GLEE_C_DEFINED_glTextureColorMaskSGIS
#define GLEE_C_DEFINED_glTextureColorMaskSGIS
  void __stdcall GLee_Lazy_glTextureColorMaskSGIS(GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha)  {if (GLeeInit()) glTextureColorMaskSGIS(red, green, blue, alpha);}
  GLEEPFNGLTEXTURECOLORMASKSGISPROC GLeeFuncPtr_glTextureColorMaskSGIS=GLee_Lazy_glTextureColorMaskSGIS;
#endif
#endif 

/* GL_EXT_texture_env_dot3 */

#ifdef __GLEE_GL_EXT_texture_env_dot3
#endif 

/* GL_ATI_texture_mirror_once */

#ifdef __GLEE_GL_ATI_texture_mirror_once
#endif 

/* GL_NV_fence */

#ifdef __GLEE_GL_NV_fence
#ifndef GLEE_C_DEFINED_glDeleteFencesNV
#define GLEE_C_DEFINED_glDeleteFencesNV
  void __stdcall GLee_Lazy_glDeleteFencesNV(GLsizei n, const GLuint * fences)  {if (GLeeInit()) glDeleteFencesNV(n, fences);}
  GLEEPFNGLDELETEFENCESNVPROC GLeeFuncPtr_glDeleteFencesNV=GLee_Lazy_glDeleteFencesNV;
#endif
#ifndef GLEE_C_DEFINED_glGenFencesNV
#define GLEE_C_DEFINED_glGenFencesNV
  void __stdcall GLee_Lazy_glGenFencesNV(GLsizei n, GLuint * fences)  {if (GLeeInit()) glGenFencesNV(n, fences);}
  GLEEPFNGLGENFENCESNVPROC GLeeFuncPtr_glGenFencesNV=GLee_Lazy_glGenFencesNV;
#endif
#ifndef GLEE_C_DEFINED_glIsFenceNV
#define GLEE_C_DEFINED_glIsFenceNV
  GLboolean __stdcall GLee_Lazy_glIsFenceNV(GLuint fence)  {if (GLeeInit()) return glIsFenceNV(fence); return (GLboolean)0;}
  GLEEPFNGLISFENCENVPROC GLeeFuncPtr_glIsFenceNV=GLee_Lazy_glIsFenceNV;
#endif
#ifndef GLEE_C_DEFINED_glTestFenceNV
#define GLEE_C_DEFINED_glTestFenceNV
  GLboolean __stdcall GLee_Lazy_glTestFenceNV(GLuint fence)  {if (GLeeInit()) return glTestFenceNV(fence); return (GLboolean)0;}
  GLEEPFNGLTESTFENCENVPROC GLeeFuncPtr_glTestFenceNV=GLee_Lazy_glTestFenceNV;
#endif
#ifndef GLEE_C_DEFINED_glGetFenceivNV
#define GLEE_C_DEFINED_glGetFenceivNV
  void __stdcall GLee_Lazy_glGetFenceivNV(GLuint fence, GLenum pname, GLint * params)  {if (GLeeInit()) glGetFenceivNV(fence, pname, params);}
  GLEEPFNGLGETFENCEIVNVPROC GLeeFuncPtr_glGetFenceivNV=GLee_Lazy_glGetFenceivNV;
#endif
#ifndef GLEE_C_DEFINED_glFinishFenceNV
#define GLEE_C_DEFINED_glFinishFenceNV
  void __stdcall GLee_Lazy_glFinishFenceNV(GLuint fence)  {if (GLeeInit()) glFinishFenceNV(fence);}
  GLEEPFNGLFINISHFENCENVPROC GLeeFuncPtr_glFinishFenceNV=GLee_Lazy_glFinishFenceNV;
#endif
#ifndef GLEE_C_DEFINED_glSetFenceNV
#define GLEE_C_DEFINED_glSetFenceNV
  void __stdcall GLee_Lazy_glSetFenceNV(GLuint fence, GLenum condition)  {if (GLeeInit()) glSetFenceNV(fence, condition);}
  GLEEPFNGLSETFENCENVPROC GLeeFuncPtr_glSetFenceNV=GLee_Lazy_glSetFenceNV;
#endif
#endif 

/* GL_IBM_texture_mirrored_repeat */

#ifdef __GLEE_GL_IBM_texture_mirrored_repeat
#endif 

/* GL_NV_evaluators */

#ifdef __GLEE_GL_NV_evaluators
#ifndef GLEE_C_DEFINED_glMapControlPointsNV
#define GLEE_C_DEFINED_glMapControlPointsNV
  void __stdcall GLee_Lazy_glMapControlPointsNV(GLenum target, GLuint index, GLenum type, GLsizei ustride, GLsizei vstride, GLint uorder, GLint vorder, GLboolean packed, const GLvoid * points)  {if (GLeeInit()) glMapControlPointsNV(target, index, type, ustride, vstride, uorder, vorder, packed, points);}
  GLEEPFNGLMAPCONTROLPOINTSNVPROC GLeeFuncPtr_glMapControlPointsNV=GLee_Lazy_glMapControlPointsNV;
#endif
#ifndef GLEE_C_DEFINED_glMapParameterivNV
#define GLEE_C_DEFINED_glMapParameterivNV
  void __stdcall GLee_Lazy_glMapParameterivNV(GLenum target, GLenum pname, const GLint * params)  {if (GLeeInit()) glMapParameterivNV(target, pname, params);}
  GLEEPFNGLMAPPARAMETERIVNVPROC GLeeFuncPtr_glMapParameterivNV=GLee_Lazy_glMapParameterivNV;
#endif
#ifndef GLEE_C_DEFINED_glMapParameterfvNV
#define GLEE_C_DEFINED_glMapParameterfvNV
  void __stdcall GLee_Lazy_glMapParameterfvNV(GLenum target, GLenum pname, const GLfloat * params)  {if (GLeeInit()) glMapParameterfvNV(target, pname, params);}
  GLEEPFNGLMAPPARAMETERFVNVPROC GLeeFuncPtr_glMapParameterfvNV=GLee_Lazy_glMapParameterfvNV;
#endif
#ifndef GLEE_C_DEFINED_glGetMapControlPointsNV
#define GLEE_C_DEFINED_glGetMapControlPointsNV
  void __stdcall GLee_Lazy_glGetMapControlPointsNV(GLenum target, GLuint index, GLenum type, GLsizei ustride, GLsizei vstride, GLboolean packed, GLvoid * points)  {if (GLeeInit()) glGetMapControlPointsNV(target, index, type, ustride, vstride, packed, points);}
  GLEEPFNGLGETMAPCONTROLPOINTSNVPROC GLeeFuncPtr_glGetMapControlPointsNV=GLee_Lazy_glGetMapControlPointsNV;
#endif
#ifndef GLEE_C_DEFINED_glGetMapParameterivNV
#define GLEE_C_DEFINED_glGetMapParameterivNV
  void __stdcall GLee_Lazy_glGetMapParameterivNV(GLenum target, GLenum pname, GLint * params)  {if (GLeeInit()) glGetMapParameterivNV(target, pname, params);}
  GLEEPFNGLGETMAPPARAMETERIVNVPROC GLeeFuncPtr_glGetMapParameterivNV=GLee_Lazy_glGetMapParameterivNV;
#endif
#ifndef GLEE_C_DEFINED_glGetMapParameterfvNV
#define GLEE_C_DEFINED_glGetMapParameterfvNV
  void __stdcall GLee_Lazy_glGetMapParameterfvNV(GLenum target, GLenum pname, GLfloat * params)  {if (GLeeInit()) glGetMapParameterfvNV(target, pname, params);}
  GLEEPFNGLGETMAPPARAMETERFVNVPROC GLeeFuncPtr_glGetMapParameterfvNV=GLee_Lazy_glGetMapParameterfvNV;
#endif
#ifndef GLEE_C_DEFINED_glGetMapAttribParameterivNV
#define GLEE_C_DEFINED_glGetMapAttribParameterivNV
  void __stdcall GLee_Lazy_glGetMapAttribParameterivNV(GLenum target, GLuint index, GLenum pname, GLint * params)  {if (GLeeInit()) glGetMapAttribParameterivNV(target, index, pname, params);}
  GLEEPFNGLGETMAPATTRIBPARAMETERIVNVPROC GLeeFuncPtr_glGetMapAttribParameterivNV=GLee_Lazy_glGetMapAttribParameterivNV;
#endif
#ifndef GLEE_C_DEFINED_glGetMapAttribParameterfvNV
#define GLEE_C_DEFINED_glGetMapAttribParameterfvNV
  void __stdcall GLee_Lazy_glGetMapAttribParameterfvNV(GLenum target, GLuint index, GLenum pname, GLfloat * params)  {if (GLeeInit()) glGetMapAttribParameterfvNV(target, index, pname, params);}
  GLEEPFNGLGETMAPATTRIBPARAMETERFVNVPROC GLeeFuncPtr_glGetMapAttribParameterfvNV=GLee_Lazy_glGetMapAttribParameterfvNV;
#endif
#ifndef GLEE_C_DEFINED_glEvalMapsNV
#define GLEE_C_DEFINED_glEvalMapsNV
  void __stdcall GLee_Lazy_glEvalMapsNV(GLenum target, GLenum mode)  {if (GLeeInit()) glEvalMapsNV(target, mode);}
  GLEEPFNGLEVALMAPSNVPROC GLeeFuncPtr_glEvalMapsNV=GLee_Lazy_glEvalMapsNV;
#endif
#endif 

/* GL_NV_packed_depth_stencil */

#ifdef __GLEE_GL_NV_packed_depth_stencil
#endif 

/* GL_NV_register_combiners2 */

#ifdef __GLEE_GL_NV_register_combiners2
#ifndef GLEE_C_DEFINED_glCombinerStageParameterfvNV
#define GLEE_C_DEFINED_glCombinerStageParameterfvNV
  void __stdcall GLee_Lazy_glCombinerStageParameterfvNV(GLenum stage, GLenum pname, const GLfloat * params)  {if (GLeeInit()) glCombinerStageParameterfvNV(stage, pname, params);}
  GLEEPFNGLCOMBINERSTAGEPARAMETERFVNVPROC GLeeFuncPtr_glCombinerStageParameterfvNV=GLee_Lazy_glCombinerStageParameterfvNV;
#endif
#ifndef GLEE_C_DEFINED_glGetCombinerStageParameterfvNV
#define GLEE_C_DEFINED_glGetCombinerStageParameterfvNV
  void __stdcall GLee_Lazy_glGetCombinerStageParameterfvNV(GLenum stage, GLenum pname, GLfloat * params)  {if (GLeeInit()) glGetCombinerStageParameterfvNV(stage, pname, params);}
  GLEEPFNGLGETCOMBINERSTAGEPARAMETERFVNVPROC GLeeFuncPtr_glGetCombinerStageParameterfvNV=GLee_Lazy_glGetCombinerStageParameterfvNV;
#endif
#endif 

/* GL_NV_texture_compression_vtc */

#ifdef __GLEE_GL_NV_texture_compression_vtc
#endif 

/* GL_NV_texture_rectangle */

#ifdef __GLEE_GL_NV_texture_rectangle
#endif 

/* GL_NV_texture_shader */

#ifdef __GLEE_GL_NV_texture_shader
#endif 

/* GL_NV_texture_shader2 */

#ifdef __GLEE_GL_NV_texture_shader2
#endif 

/* GL_NV_vertex_array_range2 */

#ifdef __GLEE_GL_NV_vertex_array_range2
#endif 

/* GL_NV_vertex_program */

#ifdef __GLEE_GL_NV_vertex_program
#ifndef GLEE_C_DEFINED_glAreProgramsResidentNV
#define GLEE_C_DEFINED_glAreProgramsResidentNV
  GLboolean __stdcall GLee_Lazy_glAreProgramsResidentNV(GLsizei n, const GLuint * programs, GLboolean * residences)  {if (GLeeInit()) return glAreProgramsResidentNV(n, programs, residences); return (GLboolean)0;}
  GLEEPFNGLAREPROGRAMSRESIDENTNVPROC GLeeFuncPtr_glAreProgramsResidentNV=GLee_Lazy_glAreProgramsResidentNV;
#endif
#ifndef GLEE_C_DEFINED_glBindProgramNV
#define GLEE_C_DEFINED_glBindProgramNV
  void __stdcall GLee_Lazy_glBindProgramNV(GLenum target, GLuint id)  {if (GLeeInit()) glBindProgramNV(target, id);}
  GLEEPFNGLBINDPROGRAMNVPROC GLeeFuncPtr_glBindProgramNV=GLee_Lazy_glBindProgramNV;
#endif
#ifndef GLEE_C_DEFINED_glDeleteProgramsNV
#define GLEE_C_DEFINED_glDeleteProgramsNV
  void __stdcall GLee_Lazy_glDeleteProgramsNV(GLsizei n, const GLuint * programs)  {if (GLeeInit()) glDeleteProgramsNV(n, programs);}
  GLEEPFNGLDELETEPROGRAMSNVPROC GLeeFuncPtr_glDeleteProgramsNV=GLee_Lazy_glDeleteProgramsNV;
#endif
#ifndef GLEE_C_DEFINED_glExecuteProgramNV
#define GLEE_C_DEFINED_glExecuteProgramNV
  void __stdcall GLee_Lazy_glExecuteProgramNV(GLenum target, GLuint id, const GLfloat * params)  {if (GLeeInit()) glExecuteProgramNV(target, id, params);}
  GLEEPFNGLEXECUTEPROGRAMNVPROC GLeeFuncPtr_glExecuteProgramNV=GLee_Lazy_glExecuteProgramNV;
#endif
#ifndef GLEE_C_DEFINED_glGenProgramsNV
#define GLEE_C_DEFINED_glGenProgramsNV
  void __stdcall GLee_Lazy_glGenProgramsNV(GLsizei n, GLuint * programs)  {if (GLeeInit()) glGenProgramsNV(n, programs);}
  GLEEPFNGLGENPROGRAMSNVPROC GLeeFuncPtr_glGenProgramsNV=GLee_Lazy_glGenProgramsNV;
#endif
#ifndef GLEE_C_DEFINED_glGetProgramParameterdvNV
#define GLEE_C_DEFINED_glGetProgramParameterdvNV
  void __stdcall GLee_Lazy_glGetProgramParameterdvNV(GLenum target, GLuint index, GLenum pname, GLdouble * params)  {if (GLeeInit()) glGetProgramParameterdvNV(target, index, pname, params);}
  GLEEPFNGLGETPROGRAMPARAMETERDVNVPROC GLeeFuncPtr_glGetProgramParameterdvNV=GLee_Lazy_glGetProgramParameterdvNV;
#endif
#ifndef GLEE_C_DEFINED_glGetProgramParameterfvNV
#define GLEE_C_DEFINED_glGetProgramParameterfvNV
  void __stdcall GLee_Lazy_glGetProgramParameterfvNV(GLenum target, GLuint index, GLenum pname, GLfloat * params)  {if (GLeeInit()) glGetProgramParameterfvNV(target, index, pname, params);}
  GLEEPFNGLGETPROGRAMPARAMETERFVNVPROC GLeeFuncPtr_glGetProgramParameterfvNV=GLee_Lazy_glGetProgramParameterfvNV;
#endif
#ifndef GLEE_C_DEFINED_glGetProgramivNV
#define GLEE_C_DEFINED_glGetProgramivNV
  void __stdcall GLee_Lazy_glGetProgramivNV(GLuint id, GLenum pname, GLint * params)  {if (GLeeInit()) glGetProgramivNV(id, pname, params);}
  GLEEPFNGLGETPROGRAMIVNVPROC GLeeFuncPtr_glGetProgramivNV=GLee_Lazy_glGetProgramivNV;
#endif
#ifndef GLEE_C_DEFINED_glGetProgramStringNV
#define GLEE_C_DEFINED_glGetProgramStringNV
  void __stdcall GLee_Lazy_glGetProgramStringNV(GLuint id, GLenum pname, GLubyte * program)  {if (GLeeInit()) glGetProgramStringNV(id, pname, program);}
  GLEEPFNGLGETPROGRAMSTRINGNVPROC GLeeFuncPtr_glGetProgramStringNV=GLee_Lazy_glGetProgramStringNV;
#endif
#ifndef GLEE_C_DEFINED_glGetTrackMatrixivNV
#define GLEE_C_DEFINED_glGetTrackMatrixivNV
  void __stdcall GLee_Lazy_glGetTrackMatrixivNV(GLenum target, GLuint address, GLenum pname, GLint * params)  {if (GLeeInit()) glGetTrackMatrixivNV(target, address, pname, params);}
  GLEEPFNGLGETTRACKMATRIXIVNVPROC GLeeFuncPtr_glGetTrackMatrixivNV=GLee_Lazy_glGetTrackMatrixivNV;
#endif
#ifndef GLEE_C_DEFINED_glGetVertexAttribdvNV
#define GLEE_C_DEFINED_glGetVertexAttribdvNV
  void __stdcall GLee_Lazy_glGetVertexAttribdvNV(GLuint index, GLenum pname, GLdouble * params)  {if (GLeeInit()) glGetVertexAttribdvNV(index, pname, params);}
  GLEEPFNGLGETVERTEXATTRIBDVNVPROC GLeeFuncPtr_glGetVertexAttribdvNV=GLee_Lazy_glGetVertexAttribdvNV;
#endif
#ifndef GLEE_C_DEFINED_glGetVertexAttribfvNV
#define GLEE_C_DEFINED_glGetVertexAttribfvNV
  void __stdcall GLee_Lazy_glGetVertexAttribfvNV(GLuint index, GLenum pname, GLfloat * params)  {if (GLeeInit()) glGetVertexAttribfvNV(index, pname, params);}
  GLEEPFNGLGETVERTEXATTRIBFVNVPROC GLeeFuncPtr_glGetVertexAttribfvNV=GLee_Lazy_glGetVertexAttribfvNV;
#endif
#ifndef GLEE_C_DEFINED_glGetVertexAttribivNV
#define GLEE_C_DEFINED_glGetVertexAttribivNV
  void __stdcall GLee_Lazy_glGetVertexAttribivNV(GLuint index, GLenum pname, GLint * params)  {if (GLeeInit()) glGetVertexAttribivNV(index, pname, params);}
  GLEEPFNGLGETVERTEXATTRIBIVNVPROC GLeeFuncPtr_glGetVertexAttribivNV=GLee_Lazy_glGetVertexAttribivNV;
#endif
#ifndef GLEE_C_DEFINED_glGetVertexAttribPointervNV
#define GLEE_C_DEFINED_glGetVertexAttribPointervNV
  void __stdcall GLee_Lazy_glGetVertexAttribPointervNV(GLuint index, GLenum pname, GLvoid* * pointer)  {if (GLeeInit()) glGetVertexAttribPointervNV(index, pname, pointer);}
  GLEEPFNGLGETVERTEXATTRIBPOINTERVNVPROC GLeeFuncPtr_glGetVertexAttribPointervNV=GLee_Lazy_glGetVertexAttribPointervNV;
#endif
#ifndef GLEE_C_DEFINED_glIsProgramNV
#define GLEE_C_DEFINED_glIsProgramNV
  GLboolean __stdcall GLee_Lazy_glIsProgramNV(GLuint id)  {if (GLeeInit()) return glIsProgramNV(id); return (GLboolean)0;}
  GLEEPFNGLISPROGRAMNVPROC GLeeFuncPtr_glIsProgramNV=GLee_Lazy_glIsProgramNV;
#endif
#ifndef GLEE_C_DEFINED_glLoadProgramNV
#define GLEE_C_DEFINED_glLoadProgramNV
  void __stdcall GLee_Lazy_glLoadProgramNV(GLenum target, GLuint id, GLsizei len, const GLubyte * program)  {if (GLeeInit()) glLoadProgramNV(target, id, len, program);}
  GLEEPFNGLLOADPROGRAMNVPROC GLeeFuncPtr_glLoadProgramNV=GLee_Lazy_glLoadProgramNV;
#endif
#ifndef GLEE_C_DEFINED_glProgramParameter4dNV
#define GLEE_C_DEFINED_glProgramParameter4dNV
  void __stdcall GLee_Lazy_glProgramParameter4dNV(GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w)  {if (GLeeInit()) glProgramParameter4dNV(target, index, x, y, z, w);}
  GLEEPFNGLPROGRAMPARAMETER4DNVPROC GLeeFuncPtr_glProgramParameter4dNV=GLee_Lazy_glProgramParameter4dNV;
#endif
#ifndef GLEE_C_DEFINED_glProgramParameter4dvNV
#define GLEE_C_DEFINED_glProgramParameter4dvNV
  void __stdcall GLee_Lazy_glProgramParameter4dvNV(GLenum target, GLuint index, const GLdouble * v)  {if (GLeeInit()) glProgramParameter4dvNV(target, index, v);}
  GLEEPFNGLPROGRAMPARAMETER4DVNVPROC GLeeFuncPtr_glProgramParameter4dvNV=GLee_Lazy_glProgramParameter4dvNV;
#endif
#ifndef GLEE_C_DEFINED_glProgramParameter4fNV
#define GLEE_C_DEFINED_glProgramParameter4fNV
  void __stdcall GLee_Lazy_glProgramParameter4fNV(GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w)  {if (GLeeInit()) glProgramParameter4fNV(target, index, x, y, z, w);}
  GLEEPFNGLPROGRAMPARAMETER4FNVPROC GLeeFuncPtr_glProgramParameter4fNV=GLee_Lazy_glProgramParameter4fNV;
#endif
#ifndef GLEE_C_DEFINED_glProgramParameter4fvNV
#define GLEE_C_DEFINED_glProgramParameter4fvNV
  void __stdcall GLee_Lazy_glProgramParameter4fvNV(GLenum target, GLuint index, const GLfloat * v)  {if (GLeeInit()) glProgramParameter4fvNV(target, index, v);}
  GLEEPFNGLPROGRAMPARAMETER4FVNVPROC GLeeFuncPtr_glProgramParameter4fvNV=GLee_Lazy_glProgramParameter4fvNV;
#endif
#ifndef GLEE_C_DEFINED_glProgramParameters4dvNV
#define GLEE_C_DEFINED_glProgramParameters4dvNV
  void __stdcall GLee_Lazy_glProgramParameters4dvNV(GLenum target, GLuint index, GLuint count, const GLdouble * v)  {if (GLeeInit()) glProgramParameters4dvNV(target, index, count, v);}
  GLEEPFNGLPROGRAMPARAMETERS4DVNVPROC GLeeFuncPtr_glProgramParameters4dvNV=GLee_Lazy_glProgramParameters4dvNV;
#endif
#ifndef GLEE_C_DEFINED_glProgramParameters4fvNV
#define GLEE_C_DEFINED_glProgramParameters4fvNV
  void __stdcall GLee_Lazy_glProgramParameters4fvNV(GLenum target, GLuint index, GLuint count, const GLfloat * v)  {if (GLeeInit()) glProgramParameters4fvNV(target, index, count, v);}
  GLEEPFNGLPROGRAMPARAMETERS4FVNVPROC GLeeFuncPtr_glProgramParameters4fvNV=GLee_Lazy_glProgramParameters4fvNV;
#endif
#ifndef GLEE_C_DEFINED_glRequestResidentProgramsNV
#define GLEE_C_DEFINED_glRequestResidentProgramsNV
  void __stdcall GLee_Lazy_glRequestResidentProgramsNV(GLsizei n, const GLuint * programs)  {if (GLeeInit()) glRequestResidentProgramsNV(n, programs);}
  GLEEPFNGLREQUESTRESIDENTPROGRAMSNVPROC GLeeFuncPtr_glRequestResidentProgramsNV=GLee_Lazy_glRequestResidentProgramsNV;
#endif
#ifndef GLEE_C_DEFINED_glTrackMatrixNV
#define GLEE_C_DEFINED_glTrackMatrixNV
  void __stdcall GLee_Lazy_glTrackMatrixNV(GLenum target, GLuint address, GLenum matrix, GLenum transform)  {if (GLeeInit()) glTrackMatrixNV(target, address, matrix, transform);}
  GLEEPFNGLTRACKMATRIXNVPROC GLeeFuncPtr_glTrackMatrixNV=GLee_Lazy_glTrackMatrixNV;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttribPointerNV
#define GLEE_C_DEFINED_glVertexAttribPointerNV
  void __stdcall GLee_Lazy_glVertexAttribPointerNV(GLuint index, GLint fsize, GLenum type, GLsizei stride, const GLvoid * pointer)  {if (GLeeInit()) glVertexAttribPointerNV(index, fsize, type, stride, pointer);}
  GLEEPFNGLVERTEXATTRIBPOINTERNVPROC GLeeFuncPtr_glVertexAttribPointerNV=GLee_Lazy_glVertexAttribPointerNV;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib1dNV
#define GLEE_C_DEFINED_glVertexAttrib1dNV
  void __stdcall GLee_Lazy_glVertexAttrib1dNV(GLuint index, GLdouble x)  {if (GLeeInit()) glVertexAttrib1dNV(index, x);}
  GLEEPFNGLVERTEXATTRIB1DNVPROC GLeeFuncPtr_glVertexAttrib1dNV=GLee_Lazy_glVertexAttrib1dNV;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib1dvNV
#define GLEE_C_DEFINED_glVertexAttrib1dvNV
  void __stdcall GLee_Lazy_glVertexAttrib1dvNV(GLuint index, const GLdouble * v)  {if (GLeeInit()) glVertexAttrib1dvNV(index, v);}
  GLEEPFNGLVERTEXATTRIB1DVNVPROC GLeeFuncPtr_glVertexAttrib1dvNV=GLee_Lazy_glVertexAttrib1dvNV;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib1fNV
#define GLEE_C_DEFINED_glVertexAttrib1fNV
  void __stdcall GLee_Lazy_glVertexAttrib1fNV(GLuint index, GLfloat x)  {if (GLeeInit()) glVertexAttrib1fNV(index, x);}
  GLEEPFNGLVERTEXATTRIB1FNVPROC GLeeFuncPtr_glVertexAttrib1fNV=GLee_Lazy_glVertexAttrib1fNV;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib1fvNV
#define GLEE_C_DEFINED_glVertexAttrib1fvNV
  void __stdcall GLee_Lazy_glVertexAttrib1fvNV(GLuint index, const GLfloat * v)  {if (GLeeInit()) glVertexAttrib1fvNV(index, v);}
  GLEEPFNGLVERTEXATTRIB1FVNVPROC GLeeFuncPtr_glVertexAttrib1fvNV=GLee_Lazy_glVertexAttrib1fvNV;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib1sNV
#define GLEE_C_DEFINED_glVertexAttrib1sNV
  void __stdcall GLee_Lazy_glVertexAttrib1sNV(GLuint index, GLshort x)  {if (GLeeInit()) glVertexAttrib1sNV(index, x);}
  GLEEPFNGLVERTEXATTRIB1SNVPROC GLeeFuncPtr_glVertexAttrib1sNV=GLee_Lazy_glVertexAttrib1sNV;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib1svNV
#define GLEE_C_DEFINED_glVertexAttrib1svNV
  void __stdcall GLee_Lazy_glVertexAttrib1svNV(GLuint index, const GLshort * v)  {if (GLeeInit()) glVertexAttrib1svNV(index, v);}
  GLEEPFNGLVERTEXATTRIB1SVNVPROC GLeeFuncPtr_glVertexAttrib1svNV=GLee_Lazy_glVertexAttrib1svNV;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib2dNV
#define GLEE_C_DEFINED_glVertexAttrib2dNV
  void __stdcall GLee_Lazy_glVertexAttrib2dNV(GLuint index, GLdouble x, GLdouble y)  {if (GLeeInit()) glVertexAttrib2dNV(index, x, y);}
  GLEEPFNGLVERTEXATTRIB2DNVPROC GLeeFuncPtr_glVertexAttrib2dNV=GLee_Lazy_glVertexAttrib2dNV;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib2dvNV
#define GLEE_C_DEFINED_glVertexAttrib2dvNV
  void __stdcall GLee_Lazy_glVertexAttrib2dvNV(GLuint index, const GLdouble * v)  {if (GLeeInit()) glVertexAttrib2dvNV(index, v);}
  GLEEPFNGLVERTEXATTRIB2DVNVPROC GLeeFuncPtr_glVertexAttrib2dvNV=GLee_Lazy_glVertexAttrib2dvNV;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib2fNV
#define GLEE_C_DEFINED_glVertexAttrib2fNV
  void __stdcall GLee_Lazy_glVertexAttrib2fNV(GLuint index, GLfloat x, GLfloat y)  {if (GLeeInit()) glVertexAttrib2fNV(index, x, y);}
  GLEEPFNGLVERTEXATTRIB2FNVPROC GLeeFuncPtr_glVertexAttrib2fNV=GLee_Lazy_glVertexAttrib2fNV;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib2fvNV
#define GLEE_C_DEFINED_glVertexAttrib2fvNV
  void __stdcall GLee_Lazy_glVertexAttrib2fvNV(GLuint index, const GLfloat * v)  {if (GLeeInit()) glVertexAttrib2fvNV(index, v);}
  GLEEPFNGLVERTEXATTRIB2FVNVPROC GLeeFuncPtr_glVertexAttrib2fvNV=GLee_Lazy_glVertexAttrib2fvNV;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib2sNV
#define GLEE_C_DEFINED_glVertexAttrib2sNV
  void __stdcall GLee_Lazy_glVertexAttrib2sNV(GLuint index, GLshort x, GLshort y)  {if (GLeeInit()) glVertexAttrib2sNV(index, x, y);}
  GLEEPFNGLVERTEXATTRIB2SNVPROC GLeeFuncPtr_glVertexAttrib2sNV=GLee_Lazy_glVertexAttrib2sNV;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib2svNV
#define GLEE_C_DEFINED_glVertexAttrib2svNV
  void __stdcall GLee_Lazy_glVertexAttrib2svNV(GLuint index, const GLshort * v)  {if (GLeeInit()) glVertexAttrib2svNV(index, v);}
  GLEEPFNGLVERTEXATTRIB2SVNVPROC GLeeFuncPtr_glVertexAttrib2svNV=GLee_Lazy_glVertexAttrib2svNV;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib3dNV
#define GLEE_C_DEFINED_glVertexAttrib3dNV
  void __stdcall GLee_Lazy_glVertexAttrib3dNV(GLuint index, GLdouble x, GLdouble y, GLdouble z)  {if (GLeeInit()) glVertexAttrib3dNV(index, x, y, z);}
  GLEEPFNGLVERTEXATTRIB3DNVPROC GLeeFuncPtr_glVertexAttrib3dNV=GLee_Lazy_glVertexAttrib3dNV;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib3dvNV
#define GLEE_C_DEFINED_glVertexAttrib3dvNV
  void __stdcall GLee_Lazy_glVertexAttrib3dvNV(GLuint index, const GLdouble * v)  {if (GLeeInit()) glVertexAttrib3dvNV(index, v);}
  GLEEPFNGLVERTEXATTRIB3DVNVPROC GLeeFuncPtr_glVertexAttrib3dvNV=GLee_Lazy_glVertexAttrib3dvNV;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib3fNV
#define GLEE_C_DEFINED_glVertexAttrib3fNV
  void __stdcall GLee_Lazy_glVertexAttrib3fNV(GLuint index, GLfloat x, GLfloat y, GLfloat z)  {if (GLeeInit()) glVertexAttrib3fNV(index, x, y, z);}
  GLEEPFNGLVERTEXATTRIB3FNVPROC GLeeFuncPtr_glVertexAttrib3fNV=GLee_Lazy_glVertexAttrib3fNV;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib3fvNV
#define GLEE_C_DEFINED_glVertexAttrib3fvNV
  void __stdcall GLee_Lazy_glVertexAttrib3fvNV(GLuint index, const GLfloat * v)  {if (GLeeInit()) glVertexAttrib3fvNV(index, v);}
  GLEEPFNGLVERTEXATTRIB3FVNVPROC GLeeFuncPtr_glVertexAttrib3fvNV=GLee_Lazy_glVertexAttrib3fvNV;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib3sNV
#define GLEE_C_DEFINED_glVertexAttrib3sNV
  void __stdcall GLee_Lazy_glVertexAttrib3sNV(GLuint index, GLshort x, GLshort y, GLshort z)  {if (GLeeInit()) glVertexAttrib3sNV(index, x, y, z);}
  GLEEPFNGLVERTEXATTRIB3SNVPROC GLeeFuncPtr_glVertexAttrib3sNV=GLee_Lazy_glVertexAttrib3sNV;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib3svNV
#define GLEE_C_DEFINED_glVertexAttrib3svNV
  void __stdcall GLee_Lazy_glVertexAttrib3svNV(GLuint index, const GLshort * v)  {if (GLeeInit()) glVertexAttrib3svNV(index, v);}
  GLEEPFNGLVERTEXATTRIB3SVNVPROC GLeeFuncPtr_glVertexAttrib3svNV=GLee_Lazy_glVertexAttrib3svNV;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib4dNV
#define GLEE_C_DEFINED_glVertexAttrib4dNV
  void __stdcall GLee_Lazy_glVertexAttrib4dNV(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w)  {if (GLeeInit()) glVertexAttrib4dNV(index, x, y, z, w);}
  GLEEPFNGLVERTEXATTRIB4DNVPROC GLeeFuncPtr_glVertexAttrib4dNV=GLee_Lazy_glVertexAttrib4dNV;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib4dvNV
#define GLEE_C_DEFINED_glVertexAttrib4dvNV
  void __stdcall GLee_Lazy_glVertexAttrib4dvNV(GLuint index, const GLdouble * v)  {if (GLeeInit()) glVertexAttrib4dvNV(index, v);}
  GLEEPFNGLVERTEXATTRIB4DVNVPROC GLeeFuncPtr_glVertexAttrib4dvNV=GLee_Lazy_glVertexAttrib4dvNV;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib4fNV
#define GLEE_C_DEFINED_glVertexAttrib4fNV
  void __stdcall GLee_Lazy_glVertexAttrib4fNV(GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w)  {if (GLeeInit()) glVertexAttrib4fNV(index, x, y, z, w);}
  GLEEPFNGLVERTEXATTRIB4FNVPROC GLeeFuncPtr_glVertexAttrib4fNV=GLee_Lazy_glVertexAttrib4fNV;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib4fvNV
#define GLEE_C_DEFINED_glVertexAttrib4fvNV
  void __stdcall GLee_Lazy_glVertexAttrib4fvNV(GLuint index, const GLfloat * v)  {if (GLeeInit()) glVertexAttrib4fvNV(index, v);}
  GLEEPFNGLVERTEXATTRIB4FVNVPROC GLeeFuncPtr_glVertexAttrib4fvNV=GLee_Lazy_glVertexAttrib4fvNV;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib4sNV
#define GLEE_C_DEFINED_glVertexAttrib4sNV
  void __stdcall GLee_Lazy_glVertexAttrib4sNV(GLuint index, GLshort x, GLshort y, GLshort z, GLshort w)  {if (GLeeInit()) glVertexAttrib4sNV(index, x, y, z, w);}
  GLEEPFNGLVERTEXATTRIB4SNVPROC GLeeFuncPtr_glVertexAttrib4sNV=GLee_Lazy_glVertexAttrib4sNV;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib4svNV
#define GLEE_C_DEFINED_glVertexAttrib4svNV
  void __stdcall GLee_Lazy_glVertexAttrib4svNV(GLuint index, const GLshort * v)  {if (GLeeInit()) glVertexAttrib4svNV(index, v);}
  GLEEPFNGLVERTEXATTRIB4SVNVPROC GLeeFuncPtr_glVertexAttrib4svNV=GLee_Lazy_glVertexAttrib4svNV;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib4ubNV
#define GLEE_C_DEFINED_glVertexAttrib4ubNV
  void __stdcall GLee_Lazy_glVertexAttrib4ubNV(GLuint index, GLubyte x, GLubyte y, GLubyte z, GLubyte w)  {if (GLeeInit()) glVertexAttrib4ubNV(index, x, y, z, w);}
  GLEEPFNGLVERTEXATTRIB4UBNVPROC GLeeFuncPtr_glVertexAttrib4ubNV=GLee_Lazy_glVertexAttrib4ubNV;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib4ubvNV
#define GLEE_C_DEFINED_glVertexAttrib4ubvNV
  void __stdcall GLee_Lazy_glVertexAttrib4ubvNV(GLuint index, const GLubyte * v)  {if (GLeeInit()) glVertexAttrib4ubvNV(index, v);}
  GLEEPFNGLVERTEXATTRIB4UBVNVPROC GLeeFuncPtr_glVertexAttrib4ubvNV=GLee_Lazy_glVertexAttrib4ubvNV;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttribs1dvNV
#define GLEE_C_DEFINED_glVertexAttribs1dvNV
  void __stdcall GLee_Lazy_glVertexAttribs1dvNV(GLuint index, GLsizei count, const GLdouble * v)  {if (GLeeInit()) glVertexAttribs1dvNV(index, count, v);}
  GLEEPFNGLVERTEXATTRIBS1DVNVPROC GLeeFuncPtr_glVertexAttribs1dvNV=GLee_Lazy_glVertexAttribs1dvNV;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttribs1fvNV
#define GLEE_C_DEFINED_glVertexAttribs1fvNV
  void __stdcall GLee_Lazy_glVertexAttribs1fvNV(GLuint index, GLsizei count, const GLfloat * v)  {if (GLeeInit()) glVertexAttribs1fvNV(index, count, v);}
  GLEEPFNGLVERTEXATTRIBS1FVNVPROC GLeeFuncPtr_glVertexAttribs1fvNV=GLee_Lazy_glVertexAttribs1fvNV;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttribs1svNV
#define GLEE_C_DEFINED_glVertexAttribs1svNV
  void __stdcall GLee_Lazy_glVertexAttribs1svNV(GLuint index, GLsizei count, const GLshort * v)  {if (GLeeInit()) glVertexAttribs1svNV(index, count, v);}
  GLEEPFNGLVERTEXATTRIBS1SVNVPROC GLeeFuncPtr_glVertexAttribs1svNV=GLee_Lazy_glVertexAttribs1svNV;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttribs2dvNV
#define GLEE_C_DEFINED_glVertexAttribs2dvNV
  void __stdcall GLee_Lazy_glVertexAttribs2dvNV(GLuint index, GLsizei count, const GLdouble * v)  {if (GLeeInit()) glVertexAttribs2dvNV(index, count, v);}
  GLEEPFNGLVERTEXATTRIBS2DVNVPROC GLeeFuncPtr_glVertexAttribs2dvNV=GLee_Lazy_glVertexAttribs2dvNV;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttribs2fvNV
#define GLEE_C_DEFINED_glVertexAttribs2fvNV
  void __stdcall GLee_Lazy_glVertexAttribs2fvNV(GLuint index, GLsizei count, const GLfloat * v)  {if (GLeeInit()) glVertexAttribs2fvNV(index, count, v);}
  GLEEPFNGLVERTEXATTRIBS2FVNVPROC GLeeFuncPtr_glVertexAttribs2fvNV=GLee_Lazy_glVertexAttribs2fvNV;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttribs2svNV
#define GLEE_C_DEFINED_glVertexAttribs2svNV
  void __stdcall GLee_Lazy_glVertexAttribs2svNV(GLuint index, GLsizei count, const GLshort * v)  {if (GLeeInit()) glVertexAttribs2svNV(index, count, v);}
  GLEEPFNGLVERTEXATTRIBS2SVNVPROC GLeeFuncPtr_glVertexAttribs2svNV=GLee_Lazy_glVertexAttribs2svNV;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttribs3dvNV
#define GLEE_C_DEFINED_glVertexAttribs3dvNV
  void __stdcall GLee_Lazy_glVertexAttribs3dvNV(GLuint index, GLsizei count, const GLdouble * v)  {if (GLeeInit()) glVertexAttribs3dvNV(index, count, v);}
  GLEEPFNGLVERTEXATTRIBS3DVNVPROC GLeeFuncPtr_glVertexAttribs3dvNV=GLee_Lazy_glVertexAttribs3dvNV;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttribs3fvNV
#define GLEE_C_DEFINED_glVertexAttribs3fvNV
  void __stdcall GLee_Lazy_glVertexAttribs3fvNV(GLuint index, GLsizei count, const GLfloat * v)  {if (GLeeInit()) glVertexAttribs3fvNV(index, count, v);}
  GLEEPFNGLVERTEXATTRIBS3FVNVPROC GLeeFuncPtr_glVertexAttribs3fvNV=GLee_Lazy_glVertexAttribs3fvNV;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttribs3svNV
#define GLEE_C_DEFINED_glVertexAttribs3svNV
  void __stdcall GLee_Lazy_glVertexAttribs3svNV(GLuint index, GLsizei count, const GLshort * v)  {if (GLeeInit()) glVertexAttribs3svNV(index, count, v);}
  GLEEPFNGLVERTEXATTRIBS3SVNVPROC GLeeFuncPtr_glVertexAttribs3svNV=GLee_Lazy_glVertexAttribs3svNV;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttribs4dvNV
#define GLEE_C_DEFINED_glVertexAttribs4dvNV
  void __stdcall GLee_Lazy_glVertexAttribs4dvNV(GLuint index, GLsizei count, const GLdouble * v)  {if (GLeeInit()) glVertexAttribs4dvNV(index, count, v);}
  GLEEPFNGLVERTEXATTRIBS4DVNVPROC GLeeFuncPtr_glVertexAttribs4dvNV=GLee_Lazy_glVertexAttribs4dvNV;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttribs4fvNV
#define GLEE_C_DEFINED_glVertexAttribs4fvNV
  void __stdcall GLee_Lazy_glVertexAttribs4fvNV(GLuint index, GLsizei count, const GLfloat * v)  {if (GLeeInit()) glVertexAttribs4fvNV(index, count, v);}
  GLEEPFNGLVERTEXATTRIBS4FVNVPROC GLeeFuncPtr_glVertexAttribs4fvNV=GLee_Lazy_glVertexAttribs4fvNV;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttribs4svNV
#define GLEE_C_DEFINED_glVertexAttribs4svNV
  void __stdcall GLee_Lazy_glVertexAttribs4svNV(GLuint index, GLsizei count, const GLshort * v)  {if (GLeeInit()) glVertexAttribs4svNV(index, count, v);}
  GLEEPFNGLVERTEXATTRIBS4SVNVPROC GLeeFuncPtr_glVertexAttribs4svNV=GLee_Lazy_glVertexAttribs4svNV;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttribs4ubvNV
#define GLEE_C_DEFINED_glVertexAttribs4ubvNV
  void __stdcall GLee_Lazy_glVertexAttribs4ubvNV(GLuint index, GLsizei count, const GLubyte * v)  {if (GLeeInit()) glVertexAttribs4ubvNV(index, count, v);}
  GLEEPFNGLVERTEXATTRIBS4UBVNVPROC GLeeFuncPtr_glVertexAttribs4ubvNV=GLee_Lazy_glVertexAttribs4ubvNV;
#endif
#endif 

/* GL_SGIX_texture_coordinate_clamp */

#ifdef __GLEE_GL_SGIX_texture_coordinate_clamp
#endif 

/* GL_SGIX_scalebias_hint */

#ifdef __GLEE_GL_SGIX_scalebias_hint
#endif 

/* GL_OML_interlace */

#ifdef __GLEE_GL_OML_interlace
#endif 

/* GL_OML_subsample */

#ifdef __GLEE_GL_OML_subsample
#endif 

/* GL_OML_resample */

#ifdef __GLEE_GL_OML_resample
#endif 

/* GL_NV_copy_depth_to_color */

#ifdef __GLEE_GL_NV_copy_depth_to_color
#endif 

/* GL_ATI_envmap_bumpmap */

#ifdef __GLEE_GL_ATI_envmap_bumpmap
#ifndef GLEE_C_DEFINED_glTexBumpParameterivATI
#define GLEE_C_DEFINED_glTexBumpParameterivATI
  void __stdcall GLee_Lazy_glTexBumpParameterivATI(GLenum pname, const GLint * param)  {if (GLeeInit()) glTexBumpParameterivATI(pname, param);}
  GLEEPFNGLTEXBUMPPARAMETERIVATIPROC GLeeFuncPtr_glTexBumpParameterivATI=GLee_Lazy_glTexBumpParameterivATI;
#endif
#ifndef GLEE_C_DEFINED_glTexBumpParameterfvATI
#define GLEE_C_DEFINED_glTexBumpParameterfvATI
  void __stdcall GLee_Lazy_glTexBumpParameterfvATI(GLenum pname, const GLfloat * param)  {if (GLeeInit()) glTexBumpParameterfvATI(pname, param);}
  GLEEPFNGLTEXBUMPPARAMETERFVATIPROC GLeeFuncPtr_glTexBumpParameterfvATI=GLee_Lazy_glTexBumpParameterfvATI;
#endif
#ifndef GLEE_C_DEFINED_glGetTexBumpParameterivATI
#define GLEE_C_DEFINED_glGetTexBumpParameterivATI
  void __stdcall GLee_Lazy_glGetTexBumpParameterivATI(GLenum pname, GLint * param)  {if (GLeeInit()) glGetTexBumpParameterivATI(pname, param);}
  GLEEPFNGLGETTEXBUMPPARAMETERIVATIPROC GLeeFuncPtr_glGetTexBumpParameterivATI=GLee_Lazy_glGetTexBumpParameterivATI;
#endif
#ifndef GLEE_C_DEFINED_glGetTexBumpParameterfvATI
#define GLEE_C_DEFINED_glGetTexBumpParameterfvATI
  void __stdcall GLee_Lazy_glGetTexBumpParameterfvATI(GLenum pname, GLfloat * param)  {if (GLeeInit()) glGetTexBumpParameterfvATI(pname, param);}
  GLEEPFNGLGETTEXBUMPPARAMETERFVATIPROC GLeeFuncPtr_glGetTexBumpParameterfvATI=GLee_Lazy_glGetTexBumpParameterfvATI;
#endif
#endif 

/* GL_ATI_fragment_shader */

#ifdef __GLEE_GL_ATI_fragment_shader
#ifndef GLEE_C_DEFINED_glGenFragmentShadersATI
#define GLEE_C_DEFINED_glGenFragmentShadersATI
  GLuint __stdcall GLee_Lazy_glGenFragmentShadersATI(GLuint range)  {if (GLeeInit()) return glGenFragmentShadersATI(range); return (GLuint)0;}
  GLEEPFNGLGENFRAGMENTSHADERSATIPROC GLeeFuncPtr_glGenFragmentShadersATI=GLee_Lazy_glGenFragmentShadersATI;
#endif
#ifndef GLEE_C_DEFINED_glBindFragmentShaderATI
#define GLEE_C_DEFINED_glBindFragmentShaderATI
  void __stdcall GLee_Lazy_glBindFragmentShaderATI(GLuint id)  {if (GLeeInit()) glBindFragmentShaderATI(id);}
  GLEEPFNGLBINDFRAGMENTSHADERATIPROC GLeeFuncPtr_glBindFragmentShaderATI=GLee_Lazy_glBindFragmentShaderATI;
#endif
#ifndef GLEE_C_DEFINED_glDeleteFragmentShaderATI
#define GLEE_C_DEFINED_glDeleteFragmentShaderATI
  void __stdcall GLee_Lazy_glDeleteFragmentShaderATI(GLuint id)  {if (GLeeInit()) glDeleteFragmentShaderATI(id);}
  GLEEPFNGLDELETEFRAGMENTSHADERATIPROC GLeeFuncPtr_glDeleteFragmentShaderATI=GLee_Lazy_glDeleteFragmentShaderATI;
#endif
#ifndef GLEE_C_DEFINED_glBeginFragmentShaderATI
#define GLEE_C_DEFINED_glBeginFragmentShaderATI
  void __stdcall GLee_Lazy_glBeginFragmentShaderATI(void)  {if (GLeeInit()) glBeginFragmentShaderATI();}
  GLEEPFNGLBEGINFRAGMENTSHADERATIPROC GLeeFuncPtr_glBeginFragmentShaderATI=GLee_Lazy_glBeginFragmentShaderATI;
#endif
#ifndef GLEE_C_DEFINED_glEndFragmentShaderATI
#define GLEE_C_DEFINED_glEndFragmentShaderATI
  void __stdcall GLee_Lazy_glEndFragmentShaderATI(void)  {if (GLeeInit()) glEndFragmentShaderATI();}
  GLEEPFNGLENDFRAGMENTSHADERATIPROC GLeeFuncPtr_glEndFragmentShaderATI=GLee_Lazy_glEndFragmentShaderATI;
#endif
#ifndef GLEE_C_DEFINED_glPassTexCoordATI
#define GLEE_C_DEFINED_glPassTexCoordATI
  void __stdcall GLee_Lazy_glPassTexCoordATI(GLuint dst, GLuint coord, GLenum swizzle)  {if (GLeeInit()) glPassTexCoordATI(dst, coord, swizzle);}
  GLEEPFNGLPASSTEXCOORDATIPROC GLeeFuncPtr_glPassTexCoordATI=GLee_Lazy_glPassTexCoordATI;
#endif
#ifndef GLEE_C_DEFINED_glSampleMapATI
#define GLEE_C_DEFINED_glSampleMapATI
  void __stdcall GLee_Lazy_glSampleMapATI(GLuint dst, GLuint interp, GLenum swizzle)  {if (GLeeInit()) glSampleMapATI(dst, interp, swizzle);}
  GLEEPFNGLSAMPLEMAPATIPROC GLeeFuncPtr_glSampleMapATI=GLee_Lazy_glSampleMapATI;
#endif
#ifndef GLEE_C_DEFINED_glColorFragmentOp1ATI
#define GLEE_C_DEFINED_glColorFragmentOp1ATI
  void __stdcall GLee_Lazy_glColorFragmentOp1ATI(GLenum op, GLuint dst, GLuint dstMask, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod)  {if (GLeeInit()) glColorFragmentOp1ATI(op, dst, dstMask, dstMod, arg1, arg1Rep, arg1Mod);}
  GLEEPFNGLCOLORFRAGMENTOP1ATIPROC GLeeFuncPtr_glColorFragmentOp1ATI=GLee_Lazy_glColorFragmentOp1ATI;
#endif
#ifndef GLEE_C_DEFINED_glColorFragmentOp2ATI
#define GLEE_C_DEFINED_glColorFragmentOp2ATI
  void __stdcall GLee_Lazy_glColorFragmentOp2ATI(GLenum op, GLuint dst, GLuint dstMask, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod, GLuint arg2, GLuint arg2Rep, GLuint arg2Mod)  {if (GLeeInit()) glColorFragmentOp2ATI(op, dst, dstMask, dstMod, arg1, arg1Rep, arg1Mod, arg2, arg2Rep, arg2Mod);}
  GLEEPFNGLCOLORFRAGMENTOP2ATIPROC GLeeFuncPtr_glColorFragmentOp2ATI=GLee_Lazy_glColorFragmentOp2ATI;
#endif
#ifndef GLEE_C_DEFINED_glColorFragmentOp3ATI
#define GLEE_C_DEFINED_glColorFragmentOp3ATI
  void __stdcall GLee_Lazy_glColorFragmentOp3ATI(GLenum op, GLuint dst, GLuint dstMask, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod, GLuint arg2, GLuint arg2Rep, GLuint arg2Mod, GLuint arg3, GLuint arg3Rep, GLuint arg3Mod)  {if (GLeeInit()) glColorFragmentOp3ATI(op, dst, dstMask, dstMod, arg1, arg1Rep, arg1Mod, arg2, arg2Rep, arg2Mod, arg3, arg3Rep, arg3Mod);}
  GLEEPFNGLCOLORFRAGMENTOP3ATIPROC GLeeFuncPtr_glColorFragmentOp3ATI=GLee_Lazy_glColorFragmentOp3ATI;
#endif
#ifndef GLEE_C_DEFINED_glAlphaFragmentOp1ATI
#define GLEE_C_DEFINED_glAlphaFragmentOp1ATI
  void __stdcall GLee_Lazy_glAlphaFragmentOp1ATI(GLenum op, GLuint dst, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod)  {if (GLeeInit()) glAlphaFragmentOp1ATI(op, dst, dstMod, arg1, arg1Rep, arg1Mod);}
  GLEEPFNGLALPHAFRAGMENTOP1ATIPROC GLeeFuncPtr_glAlphaFragmentOp1ATI=GLee_Lazy_glAlphaFragmentOp1ATI;
#endif
#ifndef GLEE_C_DEFINED_glAlphaFragmentOp2ATI
#define GLEE_C_DEFINED_glAlphaFragmentOp2ATI
  void __stdcall GLee_Lazy_glAlphaFragmentOp2ATI(GLenum op, GLuint dst, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod, GLuint arg2, GLuint arg2Rep, GLuint arg2Mod)  {if (GLeeInit()) glAlphaFragmentOp2ATI(op, dst, dstMod, arg1, arg1Rep, arg1Mod, arg2, arg2Rep, arg2Mod);}
  GLEEPFNGLALPHAFRAGMENTOP2ATIPROC GLeeFuncPtr_glAlphaFragmentOp2ATI=GLee_Lazy_glAlphaFragmentOp2ATI;
#endif
#ifndef GLEE_C_DEFINED_glAlphaFragmentOp3ATI
#define GLEE_C_DEFINED_glAlphaFragmentOp3ATI
  void __stdcall GLee_Lazy_glAlphaFragmentOp3ATI(GLenum op, GLuint dst, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod, GLuint arg2, GLuint arg2Rep, GLuint arg2Mod, GLuint arg3, GLuint arg3Rep, GLuint arg3Mod)  {if (GLeeInit()) glAlphaFragmentOp3ATI(op, dst, dstMod, arg1, arg1Rep, arg1Mod, arg2, arg2Rep, arg2Mod, arg3, arg3Rep, arg3Mod);}
  GLEEPFNGLALPHAFRAGMENTOP3ATIPROC GLeeFuncPtr_glAlphaFragmentOp3ATI=GLee_Lazy_glAlphaFragmentOp3ATI;
#endif
#ifndef GLEE_C_DEFINED_glSetFragmentShaderConstantATI
#define GLEE_C_DEFINED_glSetFragmentShaderConstantATI
  void __stdcall GLee_Lazy_glSetFragmentShaderConstantATI(GLuint dst, const GLfloat * value)  {if (GLeeInit()) glSetFragmentShaderConstantATI(dst, value);}
  GLEEPFNGLSETFRAGMENTSHADERCONSTANTATIPROC GLeeFuncPtr_glSetFragmentShaderConstantATI=GLee_Lazy_glSetFragmentShaderConstantATI;
#endif
#endif 

/* GL_ATI_pn_triangles */

#ifdef __GLEE_GL_ATI_pn_triangles
#ifndef GLEE_C_DEFINED_glPNTrianglesiATI
#define GLEE_C_DEFINED_glPNTrianglesiATI
  void __stdcall GLee_Lazy_glPNTrianglesiATI(GLenum pname, GLint param)  {if (GLeeInit()) glPNTrianglesiATI(pname, param);}
  GLEEPFNGLPNTRIANGLESIATIPROC GLeeFuncPtr_glPNTrianglesiATI=GLee_Lazy_glPNTrianglesiATI;
#endif
#ifndef GLEE_C_DEFINED_glPNTrianglesfATI
#define GLEE_C_DEFINED_glPNTrianglesfATI
  void __stdcall GLee_Lazy_glPNTrianglesfATI(GLenum pname, GLfloat param)  {if (GLeeInit()) glPNTrianglesfATI(pname, param);}
  GLEEPFNGLPNTRIANGLESFATIPROC GLeeFuncPtr_glPNTrianglesfATI=GLee_Lazy_glPNTrianglesfATI;
#endif
#endif 

/* GL_ATI_vertex_array_object */

#ifdef __GLEE_GL_ATI_vertex_array_object
#ifndef GLEE_C_DEFINED_glNewObjectBufferATI
#define GLEE_C_DEFINED_glNewObjectBufferATI
  GLuint __stdcall GLee_Lazy_glNewObjectBufferATI(GLsizei size, const GLvoid * pointer, GLenum usage)  {if (GLeeInit()) return glNewObjectBufferATI(size, pointer, usage); return (GLuint)0;}
  GLEEPFNGLNEWOBJECTBUFFERATIPROC GLeeFuncPtr_glNewObjectBufferATI=GLee_Lazy_glNewObjectBufferATI;
#endif
#ifndef GLEE_C_DEFINED_glIsObjectBufferATI
#define GLEE_C_DEFINED_glIsObjectBufferATI
  GLboolean __stdcall GLee_Lazy_glIsObjectBufferATI(GLuint buffer)  {if (GLeeInit()) return glIsObjectBufferATI(buffer); return (GLboolean)0;}
  GLEEPFNGLISOBJECTBUFFERATIPROC GLeeFuncPtr_glIsObjectBufferATI=GLee_Lazy_glIsObjectBufferATI;
#endif
#ifndef GLEE_C_DEFINED_glUpdateObjectBufferATI
#define GLEE_C_DEFINED_glUpdateObjectBufferATI
  void __stdcall GLee_Lazy_glUpdateObjectBufferATI(GLuint buffer, GLuint offset, GLsizei size, const GLvoid * pointer, GLenum preserve)  {if (GLeeInit()) glUpdateObjectBufferATI(buffer, offset, size, pointer, preserve);}
  GLEEPFNGLUPDATEOBJECTBUFFERATIPROC GLeeFuncPtr_glUpdateObjectBufferATI=GLee_Lazy_glUpdateObjectBufferATI;
#endif
#ifndef GLEE_C_DEFINED_glGetObjectBufferfvATI
#define GLEE_C_DEFINED_glGetObjectBufferfvATI
  void __stdcall GLee_Lazy_glGetObjectBufferfvATI(GLuint buffer, GLenum pname, GLfloat * params)  {if (GLeeInit()) glGetObjectBufferfvATI(buffer, pname, params);}
  GLEEPFNGLGETOBJECTBUFFERFVATIPROC GLeeFuncPtr_glGetObjectBufferfvATI=GLee_Lazy_glGetObjectBufferfvATI;
#endif
#ifndef GLEE_C_DEFINED_glGetObjectBufferivATI
#define GLEE_C_DEFINED_glGetObjectBufferivATI
  void __stdcall GLee_Lazy_glGetObjectBufferivATI(GLuint buffer, GLenum pname, GLint * params)  {if (GLeeInit()) glGetObjectBufferivATI(buffer, pname, params);}
  GLEEPFNGLGETOBJECTBUFFERIVATIPROC GLeeFuncPtr_glGetObjectBufferivATI=GLee_Lazy_glGetObjectBufferivATI;
#endif
#ifndef GLEE_C_DEFINED_glFreeObjectBufferATI
#define GLEE_C_DEFINED_glFreeObjectBufferATI
  void __stdcall GLee_Lazy_glFreeObjectBufferATI(GLuint buffer)  {if (GLeeInit()) glFreeObjectBufferATI(buffer);}
  GLEEPFNGLFREEOBJECTBUFFERATIPROC GLeeFuncPtr_glFreeObjectBufferATI=GLee_Lazy_glFreeObjectBufferATI;
#endif
#ifndef GLEE_C_DEFINED_glArrayObjectATI
#define GLEE_C_DEFINED_glArrayObjectATI
  void __stdcall GLee_Lazy_glArrayObjectATI(GLenum array, GLint size, GLenum type, GLsizei stride, GLuint buffer, GLuint offset)  {if (GLeeInit()) glArrayObjectATI(array, size, type, stride, buffer, offset);}
  GLEEPFNGLARRAYOBJECTATIPROC GLeeFuncPtr_glArrayObjectATI=GLee_Lazy_glArrayObjectATI;
#endif
#ifndef GLEE_C_DEFINED_glGetArrayObjectfvATI
#define GLEE_C_DEFINED_glGetArrayObjectfvATI
  void __stdcall GLee_Lazy_glGetArrayObjectfvATI(GLenum array, GLenum pname, GLfloat * params)  {if (GLeeInit()) glGetArrayObjectfvATI(array, pname, params);}
  GLEEPFNGLGETARRAYOBJECTFVATIPROC GLeeFuncPtr_glGetArrayObjectfvATI=GLee_Lazy_glGetArrayObjectfvATI;
#endif
#ifndef GLEE_C_DEFINED_glGetArrayObjectivATI
#define GLEE_C_DEFINED_glGetArrayObjectivATI
  void __stdcall GLee_Lazy_glGetArrayObjectivATI(GLenum array, GLenum pname, GLint * params)  {if (GLeeInit()) glGetArrayObjectivATI(array, pname, params);}
  GLEEPFNGLGETARRAYOBJECTIVATIPROC GLeeFuncPtr_glGetArrayObjectivATI=GLee_Lazy_glGetArrayObjectivATI;
#endif
#ifndef GLEE_C_DEFINED_glVariantArrayObjectATI
#define GLEE_C_DEFINED_glVariantArrayObjectATI
  void __stdcall GLee_Lazy_glVariantArrayObjectATI(GLuint id, GLenum type, GLsizei stride, GLuint buffer, GLuint offset)  {if (GLeeInit()) glVariantArrayObjectATI(id, type, stride, buffer, offset);}
  GLEEPFNGLVARIANTARRAYOBJECTATIPROC GLeeFuncPtr_glVariantArrayObjectATI=GLee_Lazy_glVariantArrayObjectATI;
#endif
#ifndef GLEE_C_DEFINED_glGetVariantArrayObjectfvATI
#define GLEE_C_DEFINED_glGetVariantArrayObjectfvATI
  void __stdcall GLee_Lazy_glGetVariantArrayObjectfvATI(GLuint id, GLenum pname, GLfloat * params)  {if (GLeeInit()) glGetVariantArrayObjectfvATI(id, pname, params);}
  GLEEPFNGLGETVARIANTARRAYOBJECTFVATIPROC GLeeFuncPtr_glGetVariantArrayObjectfvATI=GLee_Lazy_glGetVariantArrayObjectfvATI;
#endif
#ifndef GLEE_C_DEFINED_glGetVariantArrayObjectivATI
#define GLEE_C_DEFINED_glGetVariantArrayObjectivATI
  void __stdcall GLee_Lazy_glGetVariantArrayObjectivATI(GLuint id, GLenum pname, GLint * params)  {if (GLeeInit()) glGetVariantArrayObjectivATI(id, pname, params);}
  GLEEPFNGLGETVARIANTARRAYOBJECTIVATIPROC GLeeFuncPtr_glGetVariantArrayObjectivATI=GLee_Lazy_glGetVariantArrayObjectivATI;
#endif
#endif 

/* GL_EXT_vertex_shader */

#ifdef __GLEE_GL_EXT_vertex_shader
#ifndef GLEE_C_DEFINED_glBeginVertexShaderEXT
#define GLEE_C_DEFINED_glBeginVertexShaderEXT
  void __stdcall GLee_Lazy_glBeginVertexShaderEXT(void)  {if (GLeeInit()) glBeginVertexShaderEXT();}
  GLEEPFNGLBEGINVERTEXSHADEREXTPROC GLeeFuncPtr_glBeginVertexShaderEXT=GLee_Lazy_glBeginVertexShaderEXT;
#endif
#ifndef GLEE_C_DEFINED_glEndVertexShaderEXT
#define GLEE_C_DEFINED_glEndVertexShaderEXT
  void __stdcall GLee_Lazy_glEndVertexShaderEXT(void)  {if (GLeeInit()) glEndVertexShaderEXT();}
  GLEEPFNGLENDVERTEXSHADEREXTPROC GLeeFuncPtr_glEndVertexShaderEXT=GLee_Lazy_glEndVertexShaderEXT;
#endif
#ifndef GLEE_C_DEFINED_glBindVertexShaderEXT
#define GLEE_C_DEFINED_glBindVertexShaderEXT
  void __stdcall GLee_Lazy_glBindVertexShaderEXT(GLuint id)  {if (GLeeInit()) glBindVertexShaderEXT(id);}
  GLEEPFNGLBINDVERTEXSHADEREXTPROC GLeeFuncPtr_glBindVertexShaderEXT=GLee_Lazy_glBindVertexShaderEXT;
#endif
#ifndef GLEE_C_DEFINED_glGenVertexShadersEXT
#define GLEE_C_DEFINED_glGenVertexShadersEXT
  GLuint __stdcall GLee_Lazy_glGenVertexShadersEXT(GLuint range)  {if (GLeeInit()) return glGenVertexShadersEXT(range); return (GLuint)0;}
  GLEEPFNGLGENVERTEXSHADERSEXTPROC GLeeFuncPtr_glGenVertexShadersEXT=GLee_Lazy_glGenVertexShadersEXT;
#endif
#ifndef GLEE_C_DEFINED_glDeleteVertexShaderEXT
#define GLEE_C_DEFINED_glDeleteVertexShaderEXT
  void __stdcall GLee_Lazy_glDeleteVertexShaderEXT(GLuint id)  {if (GLeeInit()) glDeleteVertexShaderEXT(id);}
  GLEEPFNGLDELETEVERTEXSHADEREXTPROC GLeeFuncPtr_glDeleteVertexShaderEXT=GLee_Lazy_glDeleteVertexShaderEXT;
#endif
#ifndef GLEE_C_DEFINED_glShaderOp1EXT
#define GLEE_C_DEFINED_glShaderOp1EXT
  void __stdcall GLee_Lazy_glShaderOp1EXT(GLenum op, GLuint res, GLuint arg1)  {if (GLeeInit()) glShaderOp1EXT(op, res, arg1);}
  GLEEPFNGLSHADEROP1EXTPROC GLeeFuncPtr_glShaderOp1EXT=GLee_Lazy_glShaderOp1EXT;
#endif
#ifndef GLEE_C_DEFINED_glShaderOp2EXT
#define GLEE_C_DEFINED_glShaderOp2EXT
  void __stdcall GLee_Lazy_glShaderOp2EXT(GLenum op, GLuint res, GLuint arg1, GLuint arg2)  {if (GLeeInit()) glShaderOp2EXT(op, res, arg1, arg2);}
  GLEEPFNGLSHADEROP2EXTPROC GLeeFuncPtr_glShaderOp2EXT=GLee_Lazy_glShaderOp2EXT;
#endif
#ifndef GLEE_C_DEFINED_glShaderOp3EXT
#define GLEE_C_DEFINED_glShaderOp3EXT
  void __stdcall GLee_Lazy_glShaderOp3EXT(GLenum op, GLuint res, GLuint arg1, GLuint arg2, GLuint arg3)  {if (GLeeInit()) glShaderOp3EXT(op, res, arg1, arg2, arg3);}
  GLEEPFNGLSHADEROP3EXTPROC GLeeFuncPtr_glShaderOp3EXT=GLee_Lazy_glShaderOp3EXT;
#endif
#ifndef GLEE_C_DEFINED_glSwizzleEXT
#define GLEE_C_DEFINED_glSwizzleEXT
  void __stdcall GLee_Lazy_glSwizzleEXT(GLuint res, GLuint in, GLenum outX, GLenum outY, GLenum outZ, GLenum outW)  {if (GLeeInit()) glSwizzleEXT(res, in, outX, outY, outZ, outW);}
  GLEEPFNGLSWIZZLEEXTPROC GLeeFuncPtr_glSwizzleEXT=GLee_Lazy_glSwizzleEXT;
#endif
#ifndef GLEE_C_DEFINED_glWriteMaskEXT
#define GLEE_C_DEFINED_glWriteMaskEXT
  void __stdcall GLee_Lazy_glWriteMaskEXT(GLuint res, GLuint in, GLenum outX, GLenum outY, GLenum outZ, GLenum outW)  {if (GLeeInit()) glWriteMaskEXT(res, in, outX, outY, outZ, outW);}
  GLEEPFNGLWRITEMASKEXTPROC GLeeFuncPtr_glWriteMaskEXT=GLee_Lazy_glWriteMaskEXT;
#endif
#ifndef GLEE_C_DEFINED_glInsertComponentEXT
#define GLEE_C_DEFINED_glInsertComponentEXT
  void __stdcall GLee_Lazy_glInsertComponentEXT(GLuint res, GLuint src, GLuint num)  {if (GLeeInit()) glInsertComponentEXT(res, src, num);}
  GLEEPFNGLINSERTCOMPONENTEXTPROC GLeeFuncPtr_glInsertComponentEXT=GLee_Lazy_glInsertComponentEXT;
#endif
#ifndef GLEE_C_DEFINED_glExtractComponentEXT
#define GLEE_C_DEFINED_glExtractComponentEXT
  void __stdcall GLee_Lazy_glExtractComponentEXT(GLuint res, GLuint src, GLuint num)  {if (GLeeInit()) glExtractComponentEXT(res, src, num);}
  GLEEPFNGLEXTRACTCOMPONENTEXTPROC GLeeFuncPtr_glExtractComponentEXT=GLee_Lazy_glExtractComponentEXT;
#endif
#ifndef GLEE_C_DEFINED_glGenSymbolsEXT
#define GLEE_C_DEFINED_glGenSymbolsEXT
  GLuint __stdcall GLee_Lazy_glGenSymbolsEXT(GLenum datatype, GLenum storagetype, GLenum range, GLuint components)  {if (GLeeInit()) return glGenSymbolsEXT(datatype, storagetype, range, components); return (GLuint)0;}
  GLEEPFNGLGENSYMBOLSEXTPROC GLeeFuncPtr_glGenSymbolsEXT=GLee_Lazy_glGenSymbolsEXT;
#endif
#ifndef GLEE_C_DEFINED_glSetInvariantEXT
#define GLEE_C_DEFINED_glSetInvariantEXT
  void __stdcall GLee_Lazy_glSetInvariantEXT(GLuint id, GLenum type, const GLvoid * addr)  {if (GLeeInit()) glSetInvariantEXT(id, type, addr);}
  GLEEPFNGLSETINVARIANTEXTPROC GLeeFuncPtr_glSetInvariantEXT=GLee_Lazy_glSetInvariantEXT;
#endif
#ifndef GLEE_C_DEFINED_glSetLocalConstantEXT
#define GLEE_C_DEFINED_glSetLocalConstantEXT
  void __stdcall GLee_Lazy_glSetLocalConstantEXT(GLuint id, GLenum type, const GLvoid * addr)  {if (GLeeInit()) glSetLocalConstantEXT(id, type, addr);}
  GLEEPFNGLSETLOCALCONSTANTEXTPROC GLeeFuncPtr_glSetLocalConstantEXT=GLee_Lazy_glSetLocalConstantEXT;
#endif
#ifndef GLEE_C_DEFINED_glVariantbvEXT
#define GLEE_C_DEFINED_glVariantbvEXT
  void __stdcall GLee_Lazy_glVariantbvEXT(GLuint id, const GLbyte * addr)  {if (GLeeInit()) glVariantbvEXT(id, addr);}
  GLEEPFNGLVARIANTBVEXTPROC GLeeFuncPtr_glVariantbvEXT=GLee_Lazy_glVariantbvEXT;
#endif
#ifndef GLEE_C_DEFINED_glVariantsvEXT
#define GLEE_C_DEFINED_glVariantsvEXT
  void __stdcall GLee_Lazy_glVariantsvEXT(GLuint id, const GLshort * addr)  {if (GLeeInit()) glVariantsvEXT(id, addr);}
  GLEEPFNGLVARIANTSVEXTPROC GLeeFuncPtr_glVariantsvEXT=GLee_Lazy_glVariantsvEXT;
#endif
#ifndef GLEE_C_DEFINED_glVariantivEXT
#define GLEE_C_DEFINED_glVariantivEXT
  void __stdcall GLee_Lazy_glVariantivEXT(GLuint id, const GLint * addr)  {if (GLeeInit()) glVariantivEXT(id, addr);}
  GLEEPFNGLVARIANTIVEXTPROC GLeeFuncPtr_glVariantivEXT=GLee_Lazy_glVariantivEXT;
#endif
#ifndef GLEE_C_DEFINED_glVariantfvEXT
#define GLEE_C_DEFINED_glVariantfvEXT
  void __stdcall GLee_Lazy_glVariantfvEXT(GLuint id, const GLfloat * addr)  {if (GLeeInit()) glVariantfvEXT(id, addr);}
  GLEEPFNGLVARIANTFVEXTPROC GLeeFuncPtr_glVariantfvEXT=GLee_Lazy_glVariantfvEXT;
#endif
#ifndef GLEE_C_DEFINED_glVariantdvEXT
#define GLEE_C_DEFINED_glVariantdvEXT
  void __stdcall GLee_Lazy_glVariantdvEXT(GLuint id, const GLdouble * addr)  {if (GLeeInit()) glVariantdvEXT(id, addr);}
  GLEEPFNGLVARIANTDVEXTPROC GLeeFuncPtr_glVariantdvEXT=GLee_Lazy_glVariantdvEXT;
#endif
#ifndef GLEE_C_DEFINED_glVariantubvEXT
#define GLEE_C_DEFINED_glVariantubvEXT
  void __stdcall GLee_Lazy_glVariantubvEXT(GLuint id, const GLubyte * addr)  {if (GLeeInit()) glVariantubvEXT(id, addr);}
  GLEEPFNGLVARIANTUBVEXTPROC GLeeFuncPtr_glVariantubvEXT=GLee_Lazy_glVariantubvEXT;
#endif
#ifndef GLEE_C_DEFINED_glVariantusvEXT
#define GLEE_C_DEFINED_glVariantusvEXT
  void __stdcall GLee_Lazy_glVariantusvEXT(GLuint id, const GLushort * addr)  {if (GLeeInit()) glVariantusvEXT(id, addr);}
  GLEEPFNGLVARIANTUSVEXTPROC GLeeFuncPtr_glVariantusvEXT=GLee_Lazy_glVariantusvEXT;
#endif
#ifndef GLEE_C_DEFINED_glVariantuivEXT
#define GLEE_C_DEFINED_glVariantuivEXT
  void __stdcall GLee_Lazy_glVariantuivEXT(GLuint id, const GLuint * addr)  {if (GLeeInit()) glVariantuivEXT(id, addr);}
  GLEEPFNGLVARIANTUIVEXTPROC GLeeFuncPtr_glVariantuivEXT=GLee_Lazy_glVariantuivEXT;
#endif
#ifndef GLEE_C_DEFINED_glVariantPointerEXT
#define GLEE_C_DEFINED_glVariantPointerEXT
  void __stdcall GLee_Lazy_glVariantPointerEXT(GLuint id, GLenum type, GLuint stride, const GLvoid * addr)  {if (GLeeInit()) glVariantPointerEXT(id, type, stride, addr);}
  GLEEPFNGLVARIANTPOINTEREXTPROC GLeeFuncPtr_glVariantPointerEXT=GLee_Lazy_glVariantPointerEXT;
#endif
#ifndef GLEE_C_DEFINED_glEnableVariantClientStateEXT
#define GLEE_C_DEFINED_glEnableVariantClientStateEXT
  void __stdcall GLee_Lazy_glEnableVariantClientStateEXT(GLuint id)  {if (GLeeInit()) glEnableVariantClientStateEXT(id);}
  GLEEPFNGLENABLEVARIANTCLIENTSTATEEXTPROC GLeeFuncPtr_glEnableVariantClientStateEXT=GLee_Lazy_glEnableVariantClientStateEXT;
#endif
#ifndef GLEE_C_DEFINED_glDisableVariantClientStateEXT
#define GLEE_C_DEFINED_glDisableVariantClientStateEXT
  void __stdcall GLee_Lazy_glDisableVariantClientStateEXT(GLuint id)  {if (GLeeInit()) glDisableVariantClientStateEXT(id);}
  GLEEPFNGLDISABLEVARIANTCLIENTSTATEEXTPROC GLeeFuncPtr_glDisableVariantClientStateEXT=GLee_Lazy_glDisableVariantClientStateEXT;
#endif
#ifndef GLEE_C_DEFINED_glBindLightParameterEXT
#define GLEE_C_DEFINED_glBindLightParameterEXT
  GLuint __stdcall GLee_Lazy_glBindLightParameterEXT(GLenum light, GLenum value)  {if (GLeeInit()) return glBindLightParameterEXT(light, value); return (GLuint)0;}
  GLEEPFNGLBINDLIGHTPARAMETEREXTPROC GLeeFuncPtr_glBindLightParameterEXT=GLee_Lazy_glBindLightParameterEXT;
#endif
#ifndef GLEE_C_DEFINED_glBindMaterialParameterEXT
#define GLEE_C_DEFINED_glBindMaterialParameterEXT
  GLuint __stdcall GLee_Lazy_glBindMaterialParameterEXT(GLenum face, GLenum value)  {if (GLeeInit()) return glBindMaterialParameterEXT(face, value); return (GLuint)0;}
  GLEEPFNGLBINDMATERIALPARAMETEREXTPROC GLeeFuncPtr_glBindMaterialParameterEXT=GLee_Lazy_glBindMaterialParameterEXT;
#endif
#ifndef GLEE_C_DEFINED_glBindTexGenParameterEXT
#define GLEE_C_DEFINED_glBindTexGenParameterEXT
  GLuint __stdcall GLee_Lazy_glBindTexGenParameterEXT(GLenum unit, GLenum coord, GLenum value)  {if (GLeeInit()) return glBindTexGenParameterEXT(unit, coord, value); return (GLuint)0;}
  GLEEPFNGLBINDTEXGENPARAMETEREXTPROC GLeeFuncPtr_glBindTexGenParameterEXT=GLee_Lazy_glBindTexGenParameterEXT;
#endif
#ifndef GLEE_C_DEFINED_glBindTextureUnitParameterEXT
#define GLEE_C_DEFINED_glBindTextureUnitParameterEXT
  GLuint __stdcall GLee_Lazy_glBindTextureUnitParameterEXT(GLenum unit, GLenum value)  {if (GLeeInit()) return glBindTextureUnitParameterEXT(unit, value); return (GLuint)0;}
  GLEEPFNGLBINDTEXTUREUNITPARAMETEREXTPROC GLeeFuncPtr_glBindTextureUnitParameterEXT=GLee_Lazy_glBindTextureUnitParameterEXT;
#endif
#ifndef GLEE_C_DEFINED_glBindParameterEXT
#define GLEE_C_DEFINED_glBindParameterEXT
  GLuint __stdcall GLee_Lazy_glBindParameterEXT(GLenum value)  {if (GLeeInit()) return glBindParameterEXT(value); return (GLuint)0;}
  GLEEPFNGLBINDPARAMETEREXTPROC GLeeFuncPtr_glBindParameterEXT=GLee_Lazy_glBindParameterEXT;
#endif
#ifndef GLEE_C_DEFINED_glIsVariantEnabledEXT
#define GLEE_C_DEFINED_glIsVariantEnabledEXT
  GLboolean __stdcall GLee_Lazy_glIsVariantEnabledEXT(GLuint id, GLenum cap)  {if (GLeeInit()) return glIsVariantEnabledEXT(id, cap); return (GLboolean)0;}
  GLEEPFNGLISVARIANTENABLEDEXTPROC GLeeFuncPtr_glIsVariantEnabledEXT=GLee_Lazy_glIsVariantEnabledEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetVariantBooleanvEXT
#define GLEE_C_DEFINED_glGetVariantBooleanvEXT
  void __stdcall GLee_Lazy_glGetVariantBooleanvEXT(GLuint id, GLenum value, GLboolean * data)  {if (GLeeInit()) glGetVariantBooleanvEXT(id, value, data);}
  GLEEPFNGLGETVARIANTBOOLEANVEXTPROC GLeeFuncPtr_glGetVariantBooleanvEXT=GLee_Lazy_glGetVariantBooleanvEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetVariantIntegervEXT
#define GLEE_C_DEFINED_glGetVariantIntegervEXT
  void __stdcall GLee_Lazy_glGetVariantIntegervEXT(GLuint id, GLenum value, GLint * data)  {if (GLeeInit()) glGetVariantIntegervEXT(id, value, data);}
  GLEEPFNGLGETVARIANTINTEGERVEXTPROC GLeeFuncPtr_glGetVariantIntegervEXT=GLee_Lazy_glGetVariantIntegervEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetVariantFloatvEXT
#define GLEE_C_DEFINED_glGetVariantFloatvEXT
  void __stdcall GLee_Lazy_glGetVariantFloatvEXT(GLuint id, GLenum value, GLfloat * data)  {if (GLeeInit()) glGetVariantFloatvEXT(id, value, data);}
  GLEEPFNGLGETVARIANTFLOATVEXTPROC GLeeFuncPtr_glGetVariantFloatvEXT=GLee_Lazy_glGetVariantFloatvEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetVariantPointervEXT
#define GLEE_C_DEFINED_glGetVariantPointervEXT
  void __stdcall GLee_Lazy_glGetVariantPointervEXT(GLuint id, GLenum value, GLvoid* * data)  {if (GLeeInit()) glGetVariantPointervEXT(id, value, data);}
  GLEEPFNGLGETVARIANTPOINTERVEXTPROC GLeeFuncPtr_glGetVariantPointervEXT=GLee_Lazy_glGetVariantPointervEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetInvariantBooleanvEXT
#define GLEE_C_DEFINED_glGetInvariantBooleanvEXT
  void __stdcall GLee_Lazy_glGetInvariantBooleanvEXT(GLuint id, GLenum value, GLboolean * data)  {if (GLeeInit()) glGetInvariantBooleanvEXT(id, value, data);}
  GLEEPFNGLGETINVARIANTBOOLEANVEXTPROC GLeeFuncPtr_glGetInvariantBooleanvEXT=GLee_Lazy_glGetInvariantBooleanvEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetInvariantIntegervEXT
#define GLEE_C_DEFINED_glGetInvariantIntegervEXT
  void __stdcall GLee_Lazy_glGetInvariantIntegervEXT(GLuint id, GLenum value, GLint * data)  {if (GLeeInit()) glGetInvariantIntegervEXT(id, value, data);}
  GLEEPFNGLGETINVARIANTINTEGERVEXTPROC GLeeFuncPtr_glGetInvariantIntegervEXT=GLee_Lazy_glGetInvariantIntegervEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetInvariantFloatvEXT
#define GLEE_C_DEFINED_glGetInvariantFloatvEXT
  void __stdcall GLee_Lazy_glGetInvariantFloatvEXT(GLuint id, GLenum value, GLfloat * data)  {if (GLeeInit()) glGetInvariantFloatvEXT(id, value, data);}
  GLEEPFNGLGETINVARIANTFLOATVEXTPROC GLeeFuncPtr_glGetInvariantFloatvEXT=GLee_Lazy_glGetInvariantFloatvEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetLocalConstantBooleanvEXT
#define GLEE_C_DEFINED_glGetLocalConstantBooleanvEXT
  void __stdcall GLee_Lazy_glGetLocalConstantBooleanvEXT(GLuint id, GLenum value, GLboolean * data)  {if (GLeeInit()) glGetLocalConstantBooleanvEXT(id, value, data);}
  GLEEPFNGLGETLOCALCONSTANTBOOLEANVEXTPROC GLeeFuncPtr_glGetLocalConstantBooleanvEXT=GLee_Lazy_glGetLocalConstantBooleanvEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetLocalConstantIntegervEXT
#define GLEE_C_DEFINED_glGetLocalConstantIntegervEXT
  void __stdcall GLee_Lazy_glGetLocalConstantIntegervEXT(GLuint id, GLenum value, GLint * data)  {if (GLeeInit()) glGetLocalConstantIntegervEXT(id, value, data);}
  GLEEPFNGLGETLOCALCONSTANTINTEGERVEXTPROC GLeeFuncPtr_glGetLocalConstantIntegervEXT=GLee_Lazy_glGetLocalConstantIntegervEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetLocalConstantFloatvEXT
#define GLEE_C_DEFINED_glGetLocalConstantFloatvEXT
  void __stdcall GLee_Lazy_glGetLocalConstantFloatvEXT(GLuint id, GLenum value, GLfloat * data)  {if (GLeeInit()) glGetLocalConstantFloatvEXT(id, value, data);}
  GLEEPFNGLGETLOCALCONSTANTFLOATVEXTPROC GLeeFuncPtr_glGetLocalConstantFloatvEXT=GLee_Lazy_glGetLocalConstantFloatvEXT;
#endif
#endif 

/* GL_ATI_vertex_streams */

#ifdef __GLEE_GL_ATI_vertex_streams
#ifndef GLEE_C_DEFINED_glVertexStream1sATI
#define GLEE_C_DEFINED_glVertexStream1sATI
  void __stdcall GLee_Lazy_glVertexStream1sATI(GLenum stream, GLshort x)  {if (GLeeInit()) glVertexStream1sATI(stream, x);}
  GLEEPFNGLVERTEXSTREAM1SATIPROC GLeeFuncPtr_glVertexStream1sATI=GLee_Lazy_glVertexStream1sATI;
#endif
#ifndef GLEE_C_DEFINED_glVertexStream1svATI
#define GLEE_C_DEFINED_glVertexStream1svATI
  void __stdcall GLee_Lazy_glVertexStream1svATI(GLenum stream, const GLshort * coords)  {if (GLeeInit()) glVertexStream1svATI(stream, coords);}
  GLEEPFNGLVERTEXSTREAM1SVATIPROC GLeeFuncPtr_glVertexStream1svATI=GLee_Lazy_glVertexStream1svATI;
#endif
#ifndef GLEE_C_DEFINED_glVertexStream1iATI
#define GLEE_C_DEFINED_glVertexStream1iATI
  void __stdcall GLee_Lazy_glVertexStream1iATI(GLenum stream, GLint x)  {if (GLeeInit()) glVertexStream1iATI(stream, x);}
  GLEEPFNGLVERTEXSTREAM1IATIPROC GLeeFuncPtr_glVertexStream1iATI=GLee_Lazy_glVertexStream1iATI;
#endif
#ifndef GLEE_C_DEFINED_glVertexStream1ivATI
#define GLEE_C_DEFINED_glVertexStream1ivATI
  void __stdcall GLee_Lazy_glVertexStream1ivATI(GLenum stream, const GLint * coords)  {if (GLeeInit()) glVertexStream1ivATI(stream, coords);}
  GLEEPFNGLVERTEXSTREAM1IVATIPROC GLeeFuncPtr_glVertexStream1ivATI=GLee_Lazy_glVertexStream1ivATI;
#endif
#ifndef GLEE_C_DEFINED_glVertexStream1fATI
#define GLEE_C_DEFINED_glVertexStream1fATI
  void __stdcall GLee_Lazy_glVertexStream1fATI(GLenum stream, GLfloat x)  {if (GLeeInit()) glVertexStream1fATI(stream, x);}
  GLEEPFNGLVERTEXSTREAM1FATIPROC GLeeFuncPtr_glVertexStream1fATI=GLee_Lazy_glVertexStream1fATI;
#endif
#ifndef GLEE_C_DEFINED_glVertexStream1fvATI
#define GLEE_C_DEFINED_glVertexStream1fvATI
  void __stdcall GLee_Lazy_glVertexStream1fvATI(GLenum stream, const GLfloat * coords)  {if (GLeeInit()) glVertexStream1fvATI(stream, coords);}
  GLEEPFNGLVERTEXSTREAM1FVATIPROC GLeeFuncPtr_glVertexStream1fvATI=GLee_Lazy_glVertexStream1fvATI;
#endif
#ifndef GLEE_C_DEFINED_glVertexStream1dATI
#define GLEE_C_DEFINED_glVertexStream1dATI
  void __stdcall GLee_Lazy_glVertexStream1dATI(GLenum stream, GLdouble x)  {if (GLeeInit()) glVertexStream1dATI(stream, x);}
  GLEEPFNGLVERTEXSTREAM1DATIPROC GLeeFuncPtr_glVertexStream1dATI=GLee_Lazy_glVertexStream1dATI;
#endif
#ifndef GLEE_C_DEFINED_glVertexStream1dvATI
#define GLEE_C_DEFINED_glVertexStream1dvATI
  void __stdcall GLee_Lazy_glVertexStream1dvATI(GLenum stream, const GLdouble * coords)  {if (GLeeInit()) glVertexStream1dvATI(stream, coords);}
  GLEEPFNGLVERTEXSTREAM1DVATIPROC GLeeFuncPtr_glVertexStream1dvATI=GLee_Lazy_glVertexStream1dvATI;
#endif
#ifndef GLEE_C_DEFINED_glVertexStream2sATI
#define GLEE_C_DEFINED_glVertexStream2sATI
  void __stdcall GLee_Lazy_glVertexStream2sATI(GLenum stream, GLshort x, GLshort y)  {if (GLeeInit()) glVertexStream2sATI(stream, x, y);}
  GLEEPFNGLVERTEXSTREAM2SATIPROC GLeeFuncPtr_glVertexStream2sATI=GLee_Lazy_glVertexStream2sATI;
#endif
#ifndef GLEE_C_DEFINED_glVertexStream2svATI
#define GLEE_C_DEFINED_glVertexStream2svATI
  void __stdcall GLee_Lazy_glVertexStream2svATI(GLenum stream, const GLshort * coords)  {if (GLeeInit()) glVertexStream2svATI(stream, coords);}
  GLEEPFNGLVERTEXSTREAM2SVATIPROC GLeeFuncPtr_glVertexStream2svATI=GLee_Lazy_glVertexStream2svATI;
#endif
#ifndef GLEE_C_DEFINED_glVertexStream2iATI
#define GLEE_C_DEFINED_glVertexStream2iATI
  void __stdcall GLee_Lazy_glVertexStream2iATI(GLenum stream, GLint x, GLint y)  {if (GLeeInit()) glVertexStream2iATI(stream, x, y);}
  GLEEPFNGLVERTEXSTREAM2IATIPROC GLeeFuncPtr_glVertexStream2iATI=GLee_Lazy_glVertexStream2iATI;
#endif
#ifndef GLEE_C_DEFINED_glVertexStream2ivATI
#define GLEE_C_DEFINED_glVertexStream2ivATI
  void __stdcall GLee_Lazy_glVertexStream2ivATI(GLenum stream, const GLint * coords)  {if (GLeeInit()) glVertexStream2ivATI(stream, coords);}
  GLEEPFNGLVERTEXSTREAM2IVATIPROC GLeeFuncPtr_glVertexStream2ivATI=GLee_Lazy_glVertexStream2ivATI;
#endif
#ifndef GLEE_C_DEFINED_glVertexStream2fATI
#define GLEE_C_DEFINED_glVertexStream2fATI
  void __stdcall GLee_Lazy_glVertexStream2fATI(GLenum stream, GLfloat x, GLfloat y)  {if (GLeeInit()) glVertexStream2fATI(stream, x, y);}
  GLEEPFNGLVERTEXSTREAM2FATIPROC GLeeFuncPtr_glVertexStream2fATI=GLee_Lazy_glVertexStream2fATI;
#endif
#ifndef GLEE_C_DEFINED_glVertexStream2fvATI
#define GLEE_C_DEFINED_glVertexStream2fvATI
  void __stdcall GLee_Lazy_glVertexStream2fvATI(GLenum stream, const GLfloat * coords)  {if (GLeeInit()) glVertexStream2fvATI(stream, coords);}
  GLEEPFNGLVERTEXSTREAM2FVATIPROC GLeeFuncPtr_glVertexStream2fvATI=GLee_Lazy_glVertexStream2fvATI;
#endif
#ifndef GLEE_C_DEFINED_glVertexStream2dATI
#define GLEE_C_DEFINED_glVertexStream2dATI
  void __stdcall GLee_Lazy_glVertexStream2dATI(GLenum stream, GLdouble x, GLdouble y)  {if (GLeeInit()) glVertexStream2dATI(stream, x, y);}
  GLEEPFNGLVERTEXSTREAM2DATIPROC GLeeFuncPtr_glVertexStream2dATI=GLee_Lazy_glVertexStream2dATI;
#endif
#ifndef GLEE_C_DEFINED_glVertexStream2dvATI
#define GLEE_C_DEFINED_glVertexStream2dvATI
  void __stdcall GLee_Lazy_glVertexStream2dvATI(GLenum stream, const GLdouble * coords)  {if (GLeeInit()) glVertexStream2dvATI(stream, coords);}
  GLEEPFNGLVERTEXSTREAM2DVATIPROC GLeeFuncPtr_glVertexStream2dvATI=GLee_Lazy_glVertexStream2dvATI;
#endif
#ifndef GLEE_C_DEFINED_glVertexStream3sATI
#define GLEE_C_DEFINED_glVertexStream3sATI
  void __stdcall GLee_Lazy_glVertexStream3sATI(GLenum stream, GLshort x, GLshort y, GLshort z)  {if (GLeeInit()) glVertexStream3sATI(stream, x, y, z);}
  GLEEPFNGLVERTEXSTREAM3SATIPROC GLeeFuncPtr_glVertexStream3sATI=GLee_Lazy_glVertexStream3sATI;
#endif
#ifndef GLEE_C_DEFINED_glVertexStream3svATI
#define GLEE_C_DEFINED_glVertexStream3svATI
  void __stdcall GLee_Lazy_glVertexStream3svATI(GLenum stream, const GLshort * coords)  {if (GLeeInit()) glVertexStream3svATI(stream, coords);}
  GLEEPFNGLVERTEXSTREAM3SVATIPROC GLeeFuncPtr_glVertexStream3svATI=GLee_Lazy_glVertexStream3svATI;
#endif
#ifndef GLEE_C_DEFINED_glVertexStream3iATI
#define GLEE_C_DEFINED_glVertexStream3iATI
  void __stdcall GLee_Lazy_glVertexStream3iATI(GLenum stream, GLint x, GLint y, GLint z)  {if (GLeeInit()) glVertexStream3iATI(stream, x, y, z);}
  GLEEPFNGLVERTEXSTREAM3IATIPROC GLeeFuncPtr_glVertexStream3iATI=GLee_Lazy_glVertexStream3iATI;
#endif
#ifndef GLEE_C_DEFINED_glVertexStream3ivATI
#define GLEE_C_DEFINED_glVertexStream3ivATI
  void __stdcall GLee_Lazy_glVertexStream3ivATI(GLenum stream, const GLint * coords)  {if (GLeeInit()) glVertexStream3ivATI(stream, coords);}
  GLEEPFNGLVERTEXSTREAM3IVATIPROC GLeeFuncPtr_glVertexStream3ivATI=GLee_Lazy_glVertexStream3ivATI;
#endif
#ifndef GLEE_C_DEFINED_glVertexStream3fATI
#define GLEE_C_DEFINED_glVertexStream3fATI
  void __stdcall GLee_Lazy_glVertexStream3fATI(GLenum stream, GLfloat x, GLfloat y, GLfloat z)  {if (GLeeInit()) glVertexStream3fATI(stream, x, y, z);}
  GLEEPFNGLVERTEXSTREAM3FATIPROC GLeeFuncPtr_glVertexStream3fATI=GLee_Lazy_glVertexStream3fATI;
#endif
#ifndef GLEE_C_DEFINED_glVertexStream3fvATI
#define GLEE_C_DEFINED_glVertexStream3fvATI
  void __stdcall GLee_Lazy_glVertexStream3fvATI(GLenum stream, const GLfloat * coords)  {if (GLeeInit()) glVertexStream3fvATI(stream, coords);}
  GLEEPFNGLVERTEXSTREAM3FVATIPROC GLeeFuncPtr_glVertexStream3fvATI=GLee_Lazy_glVertexStream3fvATI;
#endif
#ifndef GLEE_C_DEFINED_glVertexStream3dATI
#define GLEE_C_DEFINED_glVertexStream3dATI
  void __stdcall GLee_Lazy_glVertexStream3dATI(GLenum stream, GLdouble x, GLdouble y, GLdouble z)  {if (GLeeInit()) glVertexStream3dATI(stream, x, y, z);}
  GLEEPFNGLVERTEXSTREAM3DATIPROC GLeeFuncPtr_glVertexStream3dATI=GLee_Lazy_glVertexStream3dATI;
#endif
#ifndef GLEE_C_DEFINED_glVertexStream3dvATI
#define GLEE_C_DEFINED_glVertexStream3dvATI
  void __stdcall GLee_Lazy_glVertexStream3dvATI(GLenum stream, const GLdouble * coords)  {if (GLeeInit()) glVertexStream3dvATI(stream, coords);}
  GLEEPFNGLVERTEXSTREAM3DVATIPROC GLeeFuncPtr_glVertexStream3dvATI=GLee_Lazy_glVertexStream3dvATI;
#endif
#ifndef GLEE_C_DEFINED_glVertexStream4sATI
#define GLEE_C_DEFINED_glVertexStream4sATI
  void __stdcall GLee_Lazy_glVertexStream4sATI(GLenum stream, GLshort x, GLshort y, GLshort z, GLshort w)  {if (GLeeInit()) glVertexStream4sATI(stream, x, y, z, w);}
  GLEEPFNGLVERTEXSTREAM4SATIPROC GLeeFuncPtr_glVertexStream4sATI=GLee_Lazy_glVertexStream4sATI;
#endif
#ifndef GLEE_C_DEFINED_glVertexStream4svATI
#define GLEE_C_DEFINED_glVertexStream4svATI
  void __stdcall GLee_Lazy_glVertexStream4svATI(GLenum stream, const GLshort * coords)  {if (GLeeInit()) glVertexStream4svATI(stream, coords);}
  GLEEPFNGLVERTEXSTREAM4SVATIPROC GLeeFuncPtr_glVertexStream4svATI=GLee_Lazy_glVertexStream4svATI;
#endif
#ifndef GLEE_C_DEFINED_glVertexStream4iATI
#define GLEE_C_DEFINED_glVertexStream4iATI
  void __stdcall GLee_Lazy_glVertexStream4iATI(GLenum stream, GLint x, GLint y, GLint z, GLint w)  {if (GLeeInit()) glVertexStream4iATI(stream, x, y, z, w);}
  GLEEPFNGLVERTEXSTREAM4IATIPROC GLeeFuncPtr_glVertexStream4iATI=GLee_Lazy_glVertexStream4iATI;
#endif
#ifndef GLEE_C_DEFINED_glVertexStream4ivATI
#define GLEE_C_DEFINED_glVertexStream4ivATI
  void __stdcall GLee_Lazy_glVertexStream4ivATI(GLenum stream, const GLint * coords)  {if (GLeeInit()) glVertexStream4ivATI(stream, coords);}
  GLEEPFNGLVERTEXSTREAM4IVATIPROC GLeeFuncPtr_glVertexStream4ivATI=GLee_Lazy_glVertexStream4ivATI;
#endif
#ifndef GLEE_C_DEFINED_glVertexStream4fATI
#define GLEE_C_DEFINED_glVertexStream4fATI
  void __stdcall GLee_Lazy_glVertexStream4fATI(GLenum stream, GLfloat x, GLfloat y, GLfloat z, GLfloat w)  {if (GLeeInit()) glVertexStream4fATI(stream, x, y, z, w);}
  GLEEPFNGLVERTEXSTREAM4FATIPROC GLeeFuncPtr_glVertexStream4fATI=GLee_Lazy_glVertexStream4fATI;
#endif
#ifndef GLEE_C_DEFINED_glVertexStream4fvATI
#define GLEE_C_DEFINED_glVertexStream4fvATI
  void __stdcall GLee_Lazy_glVertexStream4fvATI(GLenum stream, const GLfloat * coords)  {if (GLeeInit()) glVertexStream4fvATI(stream, coords);}
  GLEEPFNGLVERTEXSTREAM4FVATIPROC GLeeFuncPtr_glVertexStream4fvATI=GLee_Lazy_glVertexStream4fvATI;
#endif
#ifndef GLEE_C_DEFINED_glVertexStream4dATI
#define GLEE_C_DEFINED_glVertexStream4dATI
  void __stdcall GLee_Lazy_glVertexStream4dATI(GLenum stream, GLdouble x, GLdouble y, GLdouble z, GLdouble w)  {if (GLeeInit()) glVertexStream4dATI(stream, x, y, z, w);}
  GLEEPFNGLVERTEXSTREAM4DATIPROC GLeeFuncPtr_glVertexStream4dATI=GLee_Lazy_glVertexStream4dATI;
#endif
#ifndef GLEE_C_DEFINED_glVertexStream4dvATI
#define GLEE_C_DEFINED_glVertexStream4dvATI
  void __stdcall GLee_Lazy_glVertexStream4dvATI(GLenum stream, const GLdouble * coords)  {if (GLeeInit()) glVertexStream4dvATI(stream, coords);}
  GLEEPFNGLVERTEXSTREAM4DVATIPROC GLeeFuncPtr_glVertexStream4dvATI=GLee_Lazy_glVertexStream4dvATI;
#endif
#ifndef GLEE_C_DEFINED_glNormalStream3bATI
#define GLEE_C_DEFINED_glNormalStream3bATI
  void __stdcall GLee_Lazy_glNormalStream3bATI(GLenum stream, GLbyte nx, GLbyte ny, GLbyte nz)  {if (GLeeInit()) glNormalStream3bATI(stream, nx, ny, nz);}
  GLEEPFNGLNORMALSTREAM3BATIPROC GLeeFuncPtr_glNormalStream3bATI=GLee_Lazy_glNormalStream3bATI;
#endif
#ifndef GLEE_C_DEFINED_glNormalStream3bvATI
#define GLEE_C_DEFINED_glNormalStream3bvATI
  void __stdcall GLee_Lazy_glNormalStream3bvATI(GLenum stream, const GLbyte * coords)  {if (GLeeInit()) glNormalStream3bvATI(stream, coords);}
  GLEEPFNGLNORMALSTREAM3BVATIPROC GLeeFuncPtr_glNormalStream3bvATI=GLee_Lazy_glNormalStream3bvATI;
#endif
#ifndef GLEE_C_DEFINED_glNormalStream3sATI
#define GLEE_C_DEFINED_glNormalStream3sATI
  void __stdcall GLee_Lazy_glNormalStream3sATI(GLenum stream, GLshort nx, GLshort ny, GLshort nz)  {if (GLeeInit()) glNormalStream3sATI(stream, nx, ny, nz);}
  GLEEPFNGLNORMALSTREAM3SATIPROC GLeeFuncPtr_glNormalStream3sATI=GLee_Lazy_glNormalStream3sATI;
#endif
#ifndef GLEE_C_DEFINED_glNormalStream3svATI
#define GLEE_C_DEFINED_glNormalStream3svATI
  void __stdcall GLee_Lazy_glNormalStream3svATI(GLenum stream, const GLshort * coords)  {if (GLeeInit()) glNormalStream3svATI(stream, coords);}
  GLEEPFNGLNORMALSTREAM3SVATIPROC GLeeFuncPtr_glNormalStream3svATI=GLee_Lazy_glNormalStream3svATI;
#endif
#ifndef GLEE_C_DEFINED_glNormalStream3iATI
#define GLEE_C_DEFINED_glNormalStream3iATI
  void __stdcall GLee_Lazy_glNormalStream3iATI(GLenum stream, GLint nx, GLint ny, GLint nz)  {if (GLeeInit()) glNormalStream3iATI(stream, nx, ny, nz);}
  GLEEPFNGLNORMALSTREAM3IATIPROC GLeeFuncPtr_glNormalStream3iATI=GLee_Lazy_glNormalStream3iATI;
#endif
#ifndef GLEE_C_DEFINED_glNormalStream3ivATI
#define GLEE_C_DEFINED_glNormalStream3ivATI
  void __stdcall GLee_Lazy_glNormalStream3ivATI(GLenum stream, const GLint * coords)  {if (GLeeInit()) glNormalStream3ivATI(stream, coords);}
  GLEEPFNGLNORMALSTREAM3IVATIPROC GLeeFuncPtr_glNormalStream3ivATI=GLee_Lazy_glNormalStream3ivATI;
#endif
#ifndef GLEE_C_DEFINED_glNormalStream3fATI
#define GLEE_C_DEFINED_glNormalStream3fATI
  void __stdcall GLee_Lazy_glNormalStream3fATI(GLenum stream, GLfloat nx, GLfloat ny, GLfloat nz)  {if (GLeeInit()) glNormalStream3fATI(stream, nx, ny, nz);}
  GLEEPFNGLNORMALSTREAM3FATIPROC GLeeFuncPtr_glNormalStream3fATI=GLee_Lazy_glNormalStream3fATI;
#endif
#ifndef GLEE_C_DEFINED_glNormalStream3fvATI
#define GLEE_C_DEFINED_glNormalStream3fvATI
  void __stdcall GLee_Lazy_glNormalStream3fvATI(GLenum stream, const GLfloat * coords)  {if (GLeeInit()) glNormalStream3fvATI(stream, coords);}
  GLEEPFNGLNORMALSTREAM3FVATIPROC GLeeFuncPtr_glNormalStream3fvATI=GLee_Lazy_glNormalStream3fvATI;
#endif
#ifndef GLEE_C_DEFINED_glNormalStream3dATI
#define GLEE_C_DEFINED_glNormalStream3dATI
  void __stdcall GLee_Lazy_glNormalStream3dATI(GLenum stream, GLdouble nx, GLdouble ny, GLdouble nz)  {if (GLeeInit()) glNormalStream3dATI(stream, nx, ny, nz);}
  GLEEPFNGLNORMALSTREAM3DATIPROC GLeeFuncPtr_glNormalStream3dATI=GLee_Lazy_glNormalStream3dATI;
#endif
#ifndef GLEE_C_DEFINED_glNormalStream3dvATI
#define GLEE_C_DEFINED_glNormalStream3dvATI
  void __stdcall GLee_Lazy_glNormalStream3dvATI(GLenum stream, const GLdouble * coords)  {if (GLeeInit()) glNormalStream3dvATI(stream, coords);}
  GLEEPFNGLNORMALSTREAM3DVATIPROC GLeeFuncPtr_glNormalStream3dvATI=GLee_Lazy_glNormalStream3dvATI;
#endif
#ifndef GLEE_C_DEFINED_glClientActiveVertexStreamATI
#define GLEE_C_DEFINED_glClientActiveVertexStreamATI
  void __stdcall GLee_Lazy_glClientActiveVertexStreamATI(GLenum stream)  {if (GLeeInit()) glClientActiveVertexStreamATI(stream);}
  GLEEPFNGLCLIENTACTIVEVERTEXSTREAMATIPROC GLeeFuncPtr_glClientActiveVertexStreamATI=GLee_Lazy_glClientActiveVertexStreamATI;
#endif
#ifndef GLEE_C_DEFINED_glVertexBlendEnviATI
#define GLEE_C_DEFINED_glVertexBlendEnviATI
  void __stdcall GLee_Lazy_glVertexBlendEnviATI(GLenum pname, GLint param)  {if (GLeeInit()) glVertexBlendEnviATI(pname, param);}
  GLEEPFNGLVERTEXBLENDENVIATIPROC GLeeFuncPtr_glVertexBlendEnviATI=GLee_Lazy_glVertexBlendEnviATI;
#endif
#ifndef GLEE_C_DEFINED_glVertexBlendEnvfATI
#define GLEE_C_DEFINED_glVertexBlendEnvfATI
  void __stdcall GLee_Lazy_glVertexBlendEnvfATI(GLenum pname, GLfloat param)  {if (GLeeInit()) glVertexBlendEnvfATI(pname, param);}
  GLEEPFNGLVERTEXBLENDENVFATIPROC GLeeFuncPtr_glVertexBlendEnvfATI=GLee_Lazy_glVertexBlendEnvfATI;
#endif
#endif 

/* GL_ATI_element_array */

#ifdef __GLEE_GL_ATI_element_array
#ifndef GLEE_C_DEFINED_glElementPointerATI
#define GLEE_C_DEFINED_glElementPointerATI
  void __stdcall GLee_Lazy_glElementPointerATI(GLenum type, const GLvoid * pointer)  {if (GLeeInit()) glElementPointerATI(type, pointer);}
  GLEEPFNGLELEMENTPOINTERATIPROC GLeeFuncPtr_glElementPointerATI=GLee_Lazy_glElementPointerATI;
#endif
#ifndef GLEE_C_DEFINED_glDrawElementArrayATI
#define GLEE_C_DEFINED_glDrawElementArrayATI
  void __stdcall GLee_Lazy_glDrawElementArrayATI(GLenum mode, GLsizei count)  {if (GLeeInit()) glDrawElementArrayATI(mode, count);}
  GLEEPFNGLDRAWELEMENTARRAYATIPROC GLeeFuncPtr_glDrawElementArrayATI=GLee_Lazy_glDrawElementArrayATI;
#endif
#ifndef GLEE_C_DEFINED_glDrawRangeElementArrayATI
#define GLEE_C_DEFINED_glDrawRangeElementArrayATI
  void __stdcall GLee_Lazy_glDrawRangeElementArrayATI(GLenum mode, GLuint start, GLuint end, GLsizei count)  {if (GLeeInit()) glDrawRangeElementArrayATI(mode, start, end, count);}
  GLEEPFNGLDRAWRANGEELEMENTARRAYATIPROC GLeeFuncPtr_glDrawRangeElementArrayATI=GLee_Lazy_glDrawRangeElementArrayATI;
#endif
#endif 

/* GL_SUN_mesh_array */

#ifdef __GLEE_GL_SUN_mesh_array
#ifndef GLEE_C_DEFINED_glDrawMeshArraysSUN
#define GLEE_C_DEFINED_glDrawMeshArraysSUN
  void __stdcall GLee_Lazy_glDrawMeshArraysSUN(GLenum mode, GLint first, GLsizei count, GLsizei width)  {if (GLeeInit()) glDrawMeshArraysSUN(mode, first, count, width);}
  GLEEPFNGLDRAWMESHARRAYSSUNPROC GLeeFuncPtr_glDrawMeshArraysSUN=GLee_Lazy_glDrawMeshArraysSUN;
#endif
#endif 

/* GL_SUN_slice_accum */

#ifdef __GLEE_GL_SUN_slice_accum
#endif 

/* GL_NV_multisample_filter_hint */

#ifdef __GLEE_GL_NV_multisample_filter_hint
#endif 

/* GL_NV_depth_clamp */

#ifdef __GLEE_GL_NV_depth_clamp
#endif 

/* GL_NV_occlusion_query */

#ifdef __GLEE_GL_NV_occlusion_query
#ifndef GLEE_C_DEFINED_glGenOcclusionQueriesNV
#define GLEE_C_DEFINED_glGenOcclusionQueriesNV
  void __stdcall GLee_Lazy_glGenOcclusionQueriesNV(GLsizei n, GLuint * ids)  {if (GLeeInit()) glGenOcclusionQueriesNV(n, ids);}
  GLEEPFNGLGENOCCLUSIONQUERIESNVPROC GLeeFuncPtr_glGenOcclusionQueriesNV=GLee_Lazy_glGenOcclusionQueriesNV;
#endif
#ifndef GLEE_C_DEFINED_glDeleteOcclusionQueriesNV
#define GLEE_C_DEFINED_glDeleteOcclusionQueriesNV
  void __stdcall GLee_Lazy_glDeleteOcclusionQueriesNV(GLsizei n, const GLuint * ids)  {if (GLeeInit()) glDeleteOcclusionQueriesNV(n, ids);}
  GLEEPFNGLDELETEOCCLUSIONQUERIESNVPROC GLeeFuncPtr_glDeleteOcclusionQueriesNV=GLee_Lazy_glDeleteOcclusionQueriesNV;
#endif
#ifndef GLEE_C_DEFINED_glIsOcclusionQueryNV
#define GLEE_C_DEFINED_glIsOcclusionQueryNV
  GLboolean __stdcall GLee_Lazy_glIsOcclusionQueryNV(GLuint id)  {if (GLeeInit()) return glIsOcclusionQueryNV(id); return (GLboolean)0;}
  GLEEPFNGLISOCCLUSIONQUERYNVPROC GLeeFuncPtr_glIsOcclusionQueryNV=GLee_Lazy_glIsOcclusionQueryNV;
#endif
#ifndef GLEE_C_DEFINED_glBeginOcclusionQueryNV
#define GLEE_C_DEFINED_glBeginOcclusionQueryNV
  void __stdcall GLee_Lazy_glBeginOcclusionQueryNV(GLuint id)  {if (GLeeInit()) glBeginOcclusionQueryNV(id);}
  GLEEPFNGLBEGINOCCLUSIONQUERYNVPROC GLeeFuncPtr_glBeginOcclusionQueryNV=GLee_Lazy_glBeginOcclusionQueryNV;
#endif
#ifndef GLEE_C_DEFINED_glEndOcclusionQueryNV
#define GLEE_C_DEFINED_glEndOcclusionQueryNV
  void __stdcall GLee_Lazy_glEndOcclusionQueryNV(void)  {if (GLeeInit()) glEndOcclusionQueryNV();}
  GLEEPFNGLENDOCCLUSIONQUERYNVPROC GLeeFuncPtr_glEndOcclusionQueryNV=GLee_Lazy_glEndOcclusionQueryNV;
#endif
#ifndef GLEE_C_DEFINED_glGetOcclusionQueryivNV
#define GLEE_C_DEFINED_glGetOcclusionQueryivNV
  void __stdcall GLee_Lazy_glGetOcclusionQueryivNV(GLuint id, GLenum pname, GLint * params)  {if (GLeeInit()) glGetOcclusionQueryivNV(id, pname, params);}
  GLEEPFNGLGETOCCLUSIONQUERYIVNVPROC GLeeFuncPtr_glGetOcclusionQueryivNV=GLee_Lazy_glGetOcclusionQueryivNV;
#endif
#ifndef GLEE_C_DEFINED_glGetOcclusionQueryuivNV
#define GLEE_C_DEFINED_glGetOcclusionQueryuivNV
  void __stdcall GLee_Lazy_glGetOcclusionQueryuivNV(GLuint id, GLenum pname, GLuint * params)  {if (GLeeInit()) glGetOcclusionQueryuivNV(id, pname, params);}
  GLEEPFNGLGETOCCLUSIONQUERYUIVNVPROC GLeeFuncPtr_glGetOcclusionQueryuivNV=GLee_Lazy_glGetOcclusionQueryuivNV;
#endif
#endif 

/* GL_NV_point_sprite */

#ifdef __GLEE_GL_NV_point_sprite
#ifndef GLEE_C_DEFINED_glPointParameteriNV
#define GLEE_C_DEFINED_glPointParameteriNV
  void __stdcall GLee_Lazy_glPointParameteriNV(GLenum pname, GLint param)  {if (GLeeInit()) glPointParameteriNV(pname, param);}
  GLEEPFNGLPOINTPARAMETERINVPROC GLeeFuncPtr_glPointParameteriNV=GLee_Lazy_glPointParameteriNV;
#endif
#ifndef GLEE_C_DEFINED_glPointParameterivNV
#define GLEE_C_DEFINED_glPointParameterivNV
  void __stdcall GLee_Lazy_glPointParameterivNV(GLenum pname, const GLint * params)  {if (GLeeInit()) glPointParameterivNV(pname, params);}
  GLEEPFNGLPOINTPARAMETERIVNVPROC GLeeFuncPtr_glPointParameterivNV=GLee_Lazy_glPointParameterivNV;
#endif
#endif 

/* GL_NV_texture_shader3 */

#ifdef __GLEE_GL_NV_texture_shader3
#endif 

/* GL_NV_vertex_program1_1 */

#ifdef __GLEE_GL_NV_vertex_program1_1
#endif 

/* GL_EXT_shadow_funcs */

#ifdef __GLEE_GL_EXT_shadow_funcs
#endif 

/* GL_EXT_stencil_two_side */

#ifdef __GLEE_GL_EXT_stencil_two_side
#ifndef GLEE_C_DEFINED_glActiveStencilFaceEXT
#define GLEE_C_DEFINED_glActiveStencilFaceEXT
  void __stdcall GLee_Lazy_glActiveStencilFaceEXT(GLenum face)  {if (GLeeInit()) glActiveStencilFaceEXT(face);}
  GLEEPFNGLACTIVESTENCILFACEEXTPROC GLeeFuncPtr_glActiveStencilFaceEXT=GLee_Lazy_glActiveStencilFaceEXT;
#endif
#endif 

/* GL_ATI_text_fragment_shader */

#ifdef __GLEE_GL_ATI_text_fragment_shader
#endif 

/* GL_APPLE_client_storage */

#ifdef __GLEE_GL_APPLE_client_storage
#endif 

/* GL_APPLE_element_array */

#ifdef __GLEE_GL_APPLE_element_array
#ifndef GLEE_C_DEFINED_glElementPointerAPPLE
#define GLEE_C_DEFINED_glElementPointerAPPLE
  void __stdcall GLee_Lazy_glElementPointerAPPLE(GLenum type, const GLvoid * pointer)  {if (GLeeInit()) glElementPointerAPPLE(type, pointer);}
  GLEEPFNGLELEMENTPOINTERAPPLEPROC GLeeFuncPtr_glElementPointerAPPLE=GLee_Lazy_glElementPointerAPPLE;
#endif
#ifndef GLEE_C_DEFINED_glDrawElementArrayAPPLE
#define GLEE_C_DEFINED_glDrawElementArrayAPPLE
  void __stdcall GLee_Lazy_glDrawElementArrayAPPLE(GLenum mode, GLint first, GLsizei count)  {if (GLeeInit()) glDrawElementArrayAPPLE(mode, first, count);}
  GLEEPFNGLDRAWELEMENTARRAYAPPLEPROC GLeeFuncPtr_glDrawElementArrayAPPLE=GLee_Lazy_glDrawElementArrayAPPLE;
#endif
#ifndef GLEE_C_DEFINED_glDrawRangeElementArrayAPPLE
#define GLEE_C_DEFINED_glDrawRangeElementArrayAPPLE
  void __stdcall GLee_Lazy_glDrawRangeElementArrayAPPLE(GLenum mode, GLuint start, GLuint end, GLint first, GLsizei count)  {if (GLeeInit()) glDrawRangeElementArrayAPPLE(mode, start, end, first, count);}
  GLEEPFNGLDRAWRANGEELEMENTARRAYAPPLEPROC GLeeFuncPtr_glDrawRangeElementArrayAPPLE=GLee_Lazy_glDrawRangeElementArrayAPPLE;
#endif
#ifndef GLEE_C_DEFINED_glMultiDrawElementArrayAPPLE
#define GLEE_C_DEFINED_glMultiDrawElementArrayAPPLE
  void __stdcall GLee_Lazy_glMultiDrawElementArrayAPPLE(GLenum mode, const GLint * first, const GLsizei * count, GLsizei primcount)  {if (GLeeInit()) glMultiDrawElementArrayAPPLE(mode, first, count, primcount);}
  GLEEPFNGLMULTIDRAWELEMENTARRAYAPPLEPROC GLeeFuncPtr_glMultiDrawElementArrayAPPLE=GLee_Lazy_glMultiDrawElementArrayAPPLE;
#endif
#ifndef GLEE_C_DEFINED_glMultiDrawRangeElementArrayAPPLE
#define GLEE_C_DEFINED_glMultiDrawRangeElementArrayAPPLE
  void __stdcall GLee_Lazy_glMultiDrawRangeElementArrayAPPLE(GLenum mode, GLuint start, GLuint end, const GLint * first, const GLsizei * count, GLsizei primcount)  {if (GLeeInit()) glMultiDrawRangeElementArrayAPPLE(mode, start, end, first, count, primcount);}
  GLEEPFNGLMULTIDRAWRANGEELEMENTARRAYAPPLEPROC GLeeFuncPtr_glMultiDrawRangeElementArrayAPPLE=GLee_Lazy_glMultiDrawRangeElementArrayAPPLE;
#endif
#endif 

/* GL_APPLE_fence */

#ifdef __GLEE_GL_APPLE_fence
#ifndef GLEE_C_DEFINED_glGenFencesAPPLE
#define GLEE_C_DEFINED_glGenFencesAPPLE
  void __stdcall GLee_Lazy_glGenFencesAPPLE(GLsizei n, GLuint * fences)  {if (GLeeInit()) glGenFencesAPPLE(n, fences);}
  GLEEPFNGLGENFENCESAPPLEPROC GLeeFuncPtr_glGenFencesAPPLE=GLee_Lazy_glGenFencesAPPLE;
#endif
#ifndef GLEE_C_DEFINED_glDeleteFencesAPPLE
#define GLEE_C_DEFINED_glDeleteFencesAPPLE
  void __stdcall GLee_Lazy_glDeleteFencesAPPLE(GLsizei n, const GLuint * fences)  {if (GLeeInit()) glDeleteFencesAPPLE(n, fences);}
  GLEEPFNGLDELETEFENCESAPPLEPROC GLeeFuncPtr_glDeleteFencesAPPLE=GLee_Lazy_glDeleteFencesAPPLE;
#endif
#ifndef GLEE_C_DEFINED_glSetFenceAPPLE
#define GLEE_C_DEFINED_glSetFenceAPPLE
  void __stdcall GLee_Lazy_glSetFenceAPPLE(GLuint fence)  {if (GLeeInit()) glSetFenceAPPLE(fence);}
  GLEEPFNGLSETFENCEAPPLEPROC GLeeFuncPtr_glSetFenceAPPLE=GLee_Lazy_glSetFenceAPPLE;
#endif
#ifndef GLEE_C_DEFINED_glIsFenceAPPLE
#define GLEE_C_DEFINED_glIsFenceAPPLE
  GLboolean __stdcall GLee_Lazy_glIsFenceAPPLE(GLuint fence)  {if (GLeeInit()) return glIsFenceAPPLE(fence); return (GLboolean)0;}
  GLEEPFNGLISFENCEAPPLEPROC GLeeFuncPtr_glIsFenceAPPLE=GLee_Lazy_glIsFenceAPPLE;
#endif
#ifndef GLEE_C_DEFINED_glTestFenceAPPLE
#define GLEE_C_DEFINED_glTestFenceAPPLE
  GLboolean __stdcall GLee_Lazy_glTestFenceAPPLE(GLuint fence)  {if (GLeeInit()) return glTestFenceAPPLE(fence); return (GLboolean)0;}
  GLEEPFNGLTESTFENCEAPPLEPROC GLeeFuncPtr_glTestFenceAPPLE=GLee_Lazy_glTestFenceAPPLE;
#endif
#ifndef GLEE_C_DEFINED_glFinishFenceAPPLE
#define GLEE_C_DEFINED_glFinishFenceAPPLE
  void __stdcall GLee_Lazy_glFinishFenceAPPLE(GLuint fence)  {if (GLeeInit()) glFinishFenceAPPLE(fence);}
  GLEEPFNGLFINISHFENCEAPPLEPROC GLeeFuncPtr_glFinishFenceAPPLE=GLee_Lazy_glFinishFenceAPPLE;
#endif
#ifndef GLEE_C_DEFINED_glTestObjectAPPLE
#define GLEE_C_DEFINED_glTestObjectAPPLE
  GLboolean __stdcall GLee_Lazy_glTestObjectAPPLE(GLenum object, GLuint name)  {if (GLeeInit()) return glTestObjectAPPLE(object, name); return (GLboolean)0;}
  GLEEPFNGLTESTOBJECTAPPLEPROC GLeeFuncPtr_glTestObjectAPPLE=GLee_Lazy_glTestObjectAPPLE;
#endif
#ifndef GLEE_C_DEFINED_glFinishObjectAPPLE
#define GLEE_C_DEFINED_glFinishObjectAPPLE
  void __stdcall GLee_Lazy_glFinishObjectAPPLE(GLenum object, GLint name)  {if (GLeeInit()) glFinishObjectAPPLE(object, name);}
  GLEEPFNGLFINISHOBJECTAPPLEPROC GLeeFuncPtr_glFinishObjectAPPLE=GLee_Lazy_glFinishObjectAPPLE;
#endif
#endif 

/* GL_APPLE_vertex_array_object */

#ifdef __GLEE_GL_APPLE_vertex_array_object
#ifndef GLEE_C_DEFINED_glBindVertexArrayAPPLE
#define GLEE_C_DEFINED_glBindVertexArrayAPPLE
  void __stdcall GLee_Lazy_glBindVertexArrayAPPLE(GLuint array)  {if (GLeeInit()) glBindVertexArrayAPPLE(array);}
  GLEEPFNGLBINDVERTEXARRAYAPPLEPROC GLeeFuncPtr_glBindVertexArrayAPPLE=GLee_Lazy_glBindVertexArrayAPPLE;
#endif
#ifndef GLEE_C_DEFINED_glDeleteVertexArraysAPPLE
#define GLEE_C_DEFINED_glDeleteVertexArraysAPPLE
  void __stdcall GLee_Lazy_glDeleteVertexArraysAPPLE(GLsizei n, const GLuint * arrays)  {if (GLeeInit()) glDeleteVertexArraysAPPLE(n, arrays);}
  GLEEPFNGLDELETEVERTEXARRAYSAPPLEPROC GLeeFuncPtr_glDeleteVertexArraysAPPLE=GLee_Lazy_glDeleteVertexArraysAPPLE;
#endif
#ifndef GLEE_C_DEFINED_glGenVertexArraysAPPLE
#define GLEE_C_DEFINED_glGenVertexArraysAPPLE
  void __stdcall GLee_Lazy_glGenVertexArraysAPPLE(GLsizei n, GLuint * arrays)  {if (GLeeInit()) glGenVertexArraysAPPLE(n, arrays);}
  GLEEPFNGLGENVERTEXARRAYSAPPLEPROC GLeeFuncPtr_glGenVertexArraysAPPLE=GLee_Lazy_glGenVertexArraysAPPLE;
#endif
#ifndef GLEE_C_DEFINED_glIsVertexArrayAPPLE
#define GLEE_C_DEFINED_glIsVertexArrayAPPLE
  GLboolean __stdcall GLee_Lazy_glIsVertexArrayAPPLE(GLuint array)  {if (GLeeInit()) return glIsVertexArrayAPPLE(array); return (GLboolean)0;}
  GLEEPFNGLISVERTEXARRAYAPPLEPROC GLeeFuncPtr_glIsVertexArrayAPPLE=GLee_Lazy_glIsVertexArrayAPPLE;
#endif
#endif 

/* GL_APPLE_vertex_array_range */

#ifdef __GLEE_GL_APPLE_vertex_array_range
#ifndef GLEE_C_DEFINED_glVertexArrayRangeAPPLE
#define GLEE_C_DEFINED_glVertexArrayRangeAPPLE
  void __stdcall GLee_Lazy_glVertexArrayRangeAPPLE(GLsizei length, GLvoid * pointer)  {if (GLeeInit()) glVertexArrayRangeAPPLE(length, pointer);}
  GLEEPFNGLVERTEXARRAYRANGEAPPLEPROC GLeeFuncPtr_glVertexArrayRangeAPPLE=GLee_Lazy_glVertexArrayRangeAPPLE;
#endif
#ifndef GLEE_C_DEFINED_glFlushVertexArrayRangeAPPLE
#define GLEE_C_DEFINED_glFlushVertexArrayRangeAPPLE
  void __stdcall GLee_Lazy_glFlushVertexArrayRangeAPPLE(GLsizei length, GLvoid * pointer)  {if (GLeeInit()) glFlushVertexArrayRangeAPPLE(length, pointer);}
  GLEEPFNGLFLUSHVERTEXARRAYRANGEAPPLEPROC GLeeFuncPtr_glFlushVertexArrayRangeAPPLE=GLee_Lazy_glFlushVertexArrayRangeAPPLE;
#endif
#ifndef GLEE_C_DEFINED_glVertexArrayParameteriAPPLE
#define GLEE_C_DEFINED_glVertexArrayParameteriAPPLE
  void __stdcall GLee_Lazy_glVertexArrayParameteriAPPLE(GLenum pname, GLint param)  {if (GLeeInit()) glVertexArrayParameteriAPPLE(pname, param);}
  GLEEPFNGLVERTEXARRAYPARAMETERIAPPLEPROC GLeeFuncPtr_glVertexArrayParameteriAPPLE=GLee_Lazy_glVertexArrayParameteriAPPLE;
#endif
#endif 

/* GL_APPLE_ycbcr_422 */

#ifdef __GLEE_GL_APPLE_ycbcr_422
#endif 

/* GL_S3_s3tc */

#ifdef __GLEE_GL_S3_s3tc
#endif 

/* GL_ATI_draw_buffers */

#ifdef __GLEE_GL_ATI_draw_buffers
#ifndef GLEE_C_DEFINED_glDrawBuffersATI
#define GLEE_C_DEFINED_glDrawBuffersATI
  void __stdcall GLee_Lazy_glDrawBuffersATI(GLsizei n, const GLenum * bufs)  {if (GLeeInit()) glDrawBuffersATI(n, bufs);}
  GLEEPFNGLDRAWBUFFERSATIPROC GLeeFuncPtr_glDrawBuffersATI=GLee_Lazy_glDrawBuffersATI;
#endif
#endif 

/* GL_ATI_pixel_format_float */

#ifdef __GLEE_GL_ATI_pixel_format_float
#endif 

/* GL_ATI_texture_env_combine3 */

#ifdef __GLEE_GL_ATI_texture_env_combine3
#endif 

/* GL_ATI_texture_float */

#ifdef __GLEE_GL_ATI_texture_float
#endif 

/* GL_NV_float_buffer */

#ifdef __GLEE_GL_NV_float_buffer
#endif 

/* GL_NV_fragment_program */

#ifdef __GLEE_GL_NV_fragment_program
#ifndef GLEE_C_DEFINED_glProgramNamedParameter4fNV
#define GLEE_C_DEFINED_glProgramNamedParameter4fNV
  void __stdcall GLee_Lazy_glProgramNamedParameter4fNV(GLuint id, GLsizei len, const GLubyte * name, GLfloat x, GLfloat y, GLfloat z, GLfloat w)  {if (GLeeInit()) glProgramNamedParameter4fNV(id, len, name, x, y, z, w);}
  GLEEPFNGLPROGRAMNAMEDPARAMETER4FNVPROC GLeeFuncPtr_glProgramNamedParameter4fNV=GLee_Lazy_glProgramNamedParameter4fNV;
#endif
#ifndef GLEE_C_DEFINED_glProgramNamedParameter4dNV
#define GLEE_C_DEFINED_glProgramNamedParameter4dNV
  void __stdcall GLee_Lazy_glProgramNamedParameter4dNV(GLuint id, GLsizei len, const GLubyte * name, GLdouble x, GLdouble y, GLdouble z, GLdouble w)  {if (GLeeInit()) glProgramNamedParameter4dNV(id, len, name, x, y, z, w);}
  GLEEPFNGLPROGRAMNAMEDPARAMETER4DNVPROC GLeeFuncPtr_glProgramNamedParameter4dNV=GLee_Lazy_glProgramNamedParameter4dNV;
#endif
#ifndef GLEE_C_DEFINED_glProgramNamedParameter4fvNV
#define GLEE_C_DEFINED_glProgramNamedParameter4fvNV
  void __stdcall GLee_Lazy_glProgramNamedParameter4fvNV(GLuint id, GLsizei len, const GLubyte * name, const GLfloat * v)  {if (GLeeInit()) glProgramNamedParameter4fvNV(id, len, name, v);}
  GLEEPFNGLPROGRAMNAMEDPARAMETER4FVNVPROC GLeeFuncPtr_glProgramNamedParameter4fvNV=GLee_Lazy_glProgramNamedParameter4fvNV;
#endif
#ifndef GLEE_C_DEFINED_glProgramNamedParameter4dvNV
#define GLEE_C_DEFINED_glProgramNamedParameter4dvNV
  void __stdcall GLee_Lazy_glProgramNamedParameter4dvNV(GLuint id, GLsizei len, const GLubyte * name, const GLdouble * v)  {if (GLeeInit()) glProgramNamedParameter4dvNV(id, len, name, v);}
  GLEEPFNGLPROGRAMNAMEDPARAMETER4DVNVPROC GLeeFuncPtr_glProgramNamedParameter4dvNV=GLee_Lazy_glProgramNamedParameter4dvNV;
#endif
#ifndef GLEE_C_DEFINED_glGetProgramNamedParameterfvNV
#define GLEE_C_DEFINED_glGetProgramNamedParameterfvNV
  void __stdcall GLee_Lazy_glGetProgramNamedParameterfvNV(GLuint id, GLsizei len, const GLubyte * name, GLfloat * params)  {if (GLeeInit()) glGetProgramNamedParameterfvNV(id, len, name, params);}
  GLEEPFNGLGETPROGRAMNAMEDPARAMETERFVNVPROC GLeeFuncPtr_glGetProgramNamedParameterfvNV=GLee_Lazy_glGetProgramNamedParameterfvNV;
#endif
#ifndef GLEE_C_DEFINED_glGetProgramNamedParameterdvNV
#define GLEE_C_DEFINED_glGetProgramNamedParameterdvNV
  void __stdcall GLee_Lazy_glGetProgramNamedParameterdvNV(GLuint id, GLsizei len, const GLubyte * name, GLdouble * params)  {if (GLeeInit()) glGetProgramNamedParameterdvNV(id, len, name, params);}
  GLEEPFNGLGETPROGRAMNAMEDPARAMETERDVNVPROC GLeeFuncPtr_glGetProgramNamedParameterdvNV=GLee_Lazy_glGetProgramNamedParameterdvNV;
#endif
#endif 

/* GL_NV_half_float */

#ifdef __GLEE_GL_NV_half_float
#ifndef GLEE_C_DEFINED_glVertex2hNV
#define GLEE_C_DEFINED_glVertex2hNV
  void __stdcall GLee_Lazy_glVertex2hNV(GLhalfNV x, GLhalfNV y)  {if (GLeeInit()) glVertex2hNV(x, y);}
  GLEEPFNGLVERTEX2HNVPROC GLeeFuncPtr_glVertex2hNV=GLee_Lazy_glVertex2hNV;
#endif
#ifndef GLEE_C_DEFINED_glVertex2hvNV
#define GLEE_C_DEFINED_glVertex2hvNV
  void __stdcall GLee_Lazy_glVertex2hvNV(const GLhalfNV * v)  {if (GLeeInit()) glVertex2hvNV(v);}
  GLEEPFNGLVERTEX2HVNVPROC GLeeFuncPtr_glVertex2hvNV=GLee_Lazy_glVertex2hvNV;
#endif
#ifndef GLEE_C_DEFINED_glVertex3hNV
#define GLEE_C_DEFINED_glVertex3hNV
  void __stdcall GLee_Lazy_glVertex3hNV(GLhalfNV x, GLhalfNV y, GLhalfNV z)  {if (GLeeInit()) glVertex3hNV(x, y, z);}
  GLEEPFNGLVERTEX3HNVPROC GLeeFuncPtr_glVertex3hNV=GLee_Lazy_glVertex3hNV;
#endif
#ifndef GLEE_C_DEFINED_glVertex3hvNV
#define GLEE_C_DEFINED_glVertex3hvNV
  void __stdcall GLee_Lazy_glVertex3hvNV(const GLhalfNV * v)  {if (GLeeInit()) glVertex3hvNV(v);}
  GLEEPFNGLVERTEX3HVNVPROC GLeeFuncPtr_glVertex3hvNV=GLee_Lazy_glVertex3hvNV;
#endif
#ifndef GLEE_C_DEFINED_glVertex4hNV
#define GLEE_C_DEFINED_glVertex4hNV
  void __stdcall GLee_Lazy_glVertex4hNV(GLhalfNV x, GLhalfNV y, GLhalfNV z, GLhalfNV w)  {if (GLeeInit()) glVertex4hNV(x, y, z, w);}
  GLEEPFNGLVERTEX4HNVPROC GLeeFuncPtr_glVertex4hNV=GLee_Lazy_glVertex4hNV;
#endif
#ifndef GLEE_C_DEFINED_glVertex4hvNV
#define GLEE_C_DEFINED_glVertex4hvNV
  void __stdcall GLee_Lazy_glVertex4hvNV(const GLhalfNV * v)  {if (GLeeInit()) glVertex4hvNV(v);}
  GLEEPFNGLVERTEX4HVNVPROC GLeeFuncPtr_glVertex4hvNV=GLee_Lazy_glVertex4hvNV;
#endif
#ifndef GLEE_C_DEFINED_glNormal3hNV
#define GLEE_C_DEFINED_glNormal3hNV
  void __stdcall GLee_Lazy_glNormal3hNV(GLhalfNV nx, GLhalfNV ny, GLhalfNV nz)  {if (GLeeInit()) glNormal3hNV(nx, ny, nz);}
  GLEEPFNGLNORMAL3HNVPROC GLeeFuncPtr_glNormal3hNV=GLee_Lazy_glNormal3hNV;
#endif
#ifndef GLEE_C_DEFINED_glNormal3hvNV
#define GLEE_C_DEFINED_glNormal3hvNV
  void __stdcall GLee_Lazy_glNormal3hvNV(const GLhalfNV * v)  {if (GLeeInit()) glNormal3hvNV(v);}
  GLEEPFNGLNORMAL3HVNVPROC GLeeFuncPtr_glNormal3hvNV=GLee_Lazy_glNormal3hvNV;
#endif
#ifndef GLEE_C_DEFINED_glColor3hNV
#define GLEE_C_DEFINED_glColor3hNV
  void __stdcall GLee_Lazy_glColor3hNV(GLhalfNV red, GLhalfNV green, GLhalfNV blue)  {if (GLeeInit()) glColor3hNV(red, green, blue);}
  GLEEPFNGLCOLOR3HNVPROC GLeeFuncPtr_glColor3hNV=GLee_Lazy_glColor3hNV;
#endif
#ifndef GLEE_C_DEFINED_glColor3hvNV
#define GLEE_C_DEFINED_glColor3hvNV
  void __stdcall GLee_Lazy_glColor3hvNV(const GLhalfNV * v)  {if (GLeeInit()) glColor3hvNV(v);}
  GLEEPFNGLCOLOR3HVNVPROC GLeeFuncPtr_glColor3hvNV=GLee_Lazy_glColor3hvNV;
#endif
#ifndef GLEE_C_DEFINED_glColor4hNV
#define GLEE_C_DEFINED_glColor4hNV
  void __stdcall GLee_Lazy_glColor4hNV(GLhalfNV red, GLhalfNV green, GLhalfNV blue, GLhalfNV alpha)  {if (GLeeInit()) glColor4hNV(red, green, blue, alpha);}
  GLEEPFNGLCOLOR4HNVPROC GLeeFuncPtr_glColor4hNV=GLee_Lazy_glColor4hNV;
#endif
#ifndef GLEE_C_DEFINED_glColor4hvNV
#define GLEE_C_DEFINED_glColor4hvNV
  void __stdcall GLee_Lazy_glColor4hvNV(const GLhalfNV * v)  {if (GLeeInit()) glColor4hvNV(v);}
  GLEEPFNGLCOLOR4HVNVPROC GLeeFuncPtr_glColor4hvNV=GLee_Lazy_glColor4hvNV;
#endif
#ifndef GLEE_C_DEFINED_glTexCoord1hNV
#define GLEE_C_DEFINED_glTexCoord1hNV
  void __stdcall GLee_Lazy_glTexCoord1hNV(GLhalfNV s)  {if (GLeeInit()) glTexCoord1hNV(s);}
  GLEEPFNGLTEXCOORD1HNVPROC GLeeFuncPtr_glTexCoord1hNV=GLee_Lazy_glTexCoord1hNV;
#endif
#ifndef GLEE_C_DEFINED_glTexCoord1hvNV
#define GLEE_C_DEFINED_glTexCoord1hvNV
  void __stdcall GLee_Lazy_glTexCoord1hvNV(const GLhalfNV * v)  {if (GLeeInit()) glTexCoord1hvNV(v);}
  GLEEPFNGLTEXCOORD1HVNVPROC GLeeFuncPtr_glTexCoord1hvNV=GLee_Lazy_glTexCoord1hvNV;
#endif
#ifndef GLEE_C_DEFINED_glTexCoord2hNV
#define GLEE_C_DEFINED_glTexCoord2hNV
  void __stdcall GLee_Lazy_glTexCoord2hNV(GLhalfNV s, GLhalfNV t)  {if (GLeeInit()) glTexCoord2hNV(s, t);}
  GLEEPFNGLTEXCOORD2HNVPROC GLeeFuncPtr_glTexCoord2hNV=GLee_Lazy_glTexCoord2hNV;
#endif
#ifndef GLEE_C_DEFINED_glTexCoord2hvNV
#define GLEE_C_DEFINED_glTexCoord2hvNV
  void __stdcall GLee_Lazy_glTexCoord2hvNV(const GLhalfNV * v)  {if (GLeeInit()) glTexCoord2hvNV(v);}
  GLEEPFNGLTEXCOORD2HVNVPROC GLeeFuncPtr_glTexCoord2hvNV=GLee_Lazy_glTexCoord2hvNV;
#endif
#ifndef GLEE_C_DEFINED_glTexCoord3hNV
#define GLEE_C_DEFINED_glTexCoord3hNV
  void __stdcall GLee_Lazy_glTexCoord3hNV(GLhalfNV s, GLhalfNV t, GLhalfNV r)  {if (GLeeInit()) glTexCoord3hNV(s, t, r);}
  GLEEPFNGLTEXCOORD3HNVPROC GLeeFuncPtr_glTexCoord3hNV=GLee_Lazy_glTexCoord3hNV;
#endif
#ifndef GLEE_C_DEFINED_glTexCoord3hvNV
#define GLEE_C_DEFINED_glTexCoord3hvNV
  void __stdcall GLee_Lazy_glTexCoord3hvNV(const GLhalfNV * v)  {if (GLeeInit()) glTexCoord3hvNV(v);}
  GLEEPFNGLTEXCOORD3HVNVPROC GLeeFuncPtr_glTexCoord3hvNV=GLee_Lazy_glTexCoord3hvNV;
#endif
#ifndef GLEE_C_DEFINED_glTexCoord4hNV
#define GLEE_C_DEFINED_glTexCoord4hNV
  void __stdcall GLee_Lazy_glTexCoord4hNV(GLhalfNV s, GLhalfNV t, GLhalfNV r, GLhalfNV q)  {if (GLeeInit()) glTexCoord4hNV(s, t, r, q);}
  GLEEPFNGLTEXCOORD4HNVPROC GLeeFuncPtr_glTexCoord4hNV=GLee_Lazy_glTexCoord4hNV;
#endif
#ifndef GLEE_C_DEFINED_glTexCoord4hvNV
#define GLEE_C_DEFINED_glTexCoord4hvNV
  void __stdcall GLee_Lazy_glTexCoord4hvNV(const GLhalfNV * v)  {if (GLeeInit()) glTexCoord4hvNV(v);}
  GLEEPFNGLTEXCOORD4HVNVPROC GLeeFuncPtr_glTexCoord4hvNV=GLee_Lazy_glTexCoord4hvNV;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord1hNV
#define GLEE_C_DEFINED_glMultiTexCoord1hNV
  void __stdcall GLee_Lazy_glMultiTexCoord1hNV(GLenum target, GLhalfNV s)  {if (GLeeInit()) glMultiTexCoord1hNV(target, s);}
  GLEEPFNGLMULTITEXCOORD1HNVPROC GLeeFuncPtr_glMultiTexCoord1hNV=GLee_Lazy_glMultiTexCoord1hNV;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord1hvNV
#define GLEE_C_DEFINED_glMultiTexCoord1hvNV
  void __stdcall GLee_Lazy_glMultiTexCoord1hvNV(GLenum target, const GLhalfNV * v)  {if (GLeeInit()) glMultiTexCoord1hvNV(target, v);}
  GLEEPFNGLMULTITEXCOORD1HVNVPROC GLeeFuncPtr_glMultiTexCoord1hvNV=GLee_Lazy_glMultiTexCoord1hvNV;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord2hNV
#define GLEE_C_DEFINED_glMultiTexCoord2hNV
  void __stdcall GLee_Lazy_glMultiTexCoord2hNV(GLenum target, GLhalfNV s, GLhalfNV t)  {if (GLeeInit()) glMultiTexCoord2hNV(target, s, t);}
  GLEEPFNGLMULTITEXCOORD2HNVPROC GLeeFuncPtr_glMultiTexCoord2hNV=GLee_Lazy_glMultiTexCoord2hNV;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord2hvNV
#define GLEE_C_DEFINED_glMultiTexCoord2hvNV
  void __stdcall GLee_Lazy_glMultiTexCoord2hvNV(GLenum target, const GLhalfNV * v)  {if (GLeeInit()) glMultiTexCoord2hvNV(target, v);}
  GLEEPFNGLMULTITEXCOORD2HVNVPROC GLeeFuncPtr_glMultiTexCoord2hvNV=GLee_Lazy_glMultiTexCoord2hvNV;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord3hNV
#define GLEE_C_DEFINED_glMultiTexCoord3hNV
  void __stdcall GLee_Lazy_glMultiTexCoord3hNV(GLenum target, GLhalfNV s, GLhalfNV t, GLhalfNV r)  {if (GLeeInit()) glMultiTexCoord3hNV(target, s, t, r);}
  GLEEPFNGLMULTITEXCOORD3HNVPROC GLeeFuncPtr_glMultiTexCoord3hNV=GLee_Lazy_glMultiTexCoord3hNV;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord3hvNV
#define GLEE_C_DEFINED_glMultiTexCoord3hvNV
  void __stdcall GLee_Lazy_glMultiTexCoord3hvNV(GLenum target, const GLhalfNV * v)  {if (GLeeInit()) glMultiTexCoord3hvNV(target, v);}
  GLEEPFNGLMULTITEXCOORD3HVNVPROC GLeeFuncPtr_glMultiTexCoord3hvNV=GLee_Lazy_glMultiTexCoord3hvNV;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord4hNV
#define GLEE_C_DEFINED_glMultiTexCoord4hNV
  void __stdcall GLee_Lazy_glMultiTexCoord4hNV(GLenum target, GLhalfNV s, GLhalfNV t, GLhalfNV r, GLhalfNV q)  {if (GLeeInit()) glMultiTexCoord4hNV(target, s, t, r, q);}
  GLEEPFNGLMULTITEXCOORD4HNVPROC GLeeFuncPtr_glMultiTexCoord4hNV=GLee_Lazy_glMultiTexCoord4hNV;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoord4hvNV
#define GLEE_C_DEFINED_glMultiTexCoord4hvNV
  void __stdcall GLee_Lazy_glMultiTexCoord4hvNV(GLenum target, const GLhalfNV * v)  {if (GLeeInit()) glMultiTexCoord4hvNV(target, v);}
  GLEEPFNGLMULTITEXCOORD4HVNVPROC GLeeFuncPtr_glMultiTexCoord4hvNV=GLee_Lazy_glMultiTexCoord4hvNV;
#endif
#ifndef GLEE_C_DEFINED_glFogCoordhNV
#define GLEE_C_DEFINED_glFogCoordhNV
  void __stdcall GLee_Lazy_glFogCoordhNV(GLhalfNV fog)  {if (GLeeInit()) glFogCoordhNV(fog);}
  GLEEPFNGLFOGCOORDHNVPROC GLeeFuncPtr_glFogCoordhNV=GLee_Lazy_glFogCoordhNV;
#endif
#ifndef GLEE_C_DEFINED_glFogCoordhvNV
#define GLEE_C_DEFINED_glFogCoordhvNV
  void __stdcall GLee_Lazy_glFogCoordhvNV(const GLhalfNV * fog)  {if (GLeeInit()) glFogCoordhvNV(fog);}
  GLEEPFNGLFOGCOORDHVNVPROC GLeeFuncPtr_glFogCoordhvNV=GLee_Lazy_glFogCoordhvNV;
#endif
#ifndef GLEE_C_DEFINED_glSecondaryColor3hNV
#define GLEE_C_DEFINED_glSecondaryColor3hNV
  void __stdcall GLee_Lazy_glSecondaryColor3hNV(GLhalfNV red, GLhalfNV green, GLhalfNV blue)  {if (GLeeInit()) glSecondaryColor3hNV(red, green, blue);}
  GLEEPFNGLSECONDARYCOLOR3HNVPROC GLeeFuncPtr_glSecondaryColor3hNV=GLee_Lazy_glSecondaryColor3hNV;
#endif
#ifndef GLEE_C_DEFINED_glSecondaryColor3hvNV
#define GLEE_C_DEFINED_glSecondaryColor3hvNV
  void __stdcall GLee_Lazy_glSecondaryColor3hvNV(const GLhalfNV * v)  {if (GLeeInit()) glSecondaryColor3hvNV(v);}
  GLEEPFNGLSECONDARYCOLOR3HVNVPROC GLeeFuncPtr_glSecondaryColor3hvNV=GLee_Lazy_glSecondaryColor3hvNV;
#endif
#ifndef GLEE_C_DEFINED_glVertexWeighthNV
#define GLEE_C_DEFINED_glVertexWeighthNV
  void __stdcall GLee_Lazy_glVertexWeighthNV(GLhalfNV weight)  {if (GLeeInit()) glVertexWeighthNV(weight);}
  GLEEPFNGLVERTEXWEIGHTHNVPROC GLeeFuncPtr_glVertexWeighthNV=GLee_Lazy_glVertexWeighthNV;
#endif
#ifndef GLEE_C_DEFINED_glVertexWeighthvNV
#define GLEE_C_DEFINED_glVertexWeighthvNV
  void __stdcall GLee_Lazy_glVertexWeighthvNV(const GLhalfNV * weight)  {if (GLeeInit()) glVertexWeighthvNV(weight);}
  GLEEPFNGLVERTEXWEIGHTHVNVPROC GLeeFuncPtr_glVertexWeighthvNV=GLee_Lazy_glVertexWeighthvNV;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib1hNV
#define GLEE_C_DEFINED_glVertexAttrib1hNV
  void __stdcall GLee_Lazy_glVertexAttrib1hNV(GLuint index, GLhalfNV x)  {if (GLeeInit()) glVertexAttrib1hNV(index, x);}
  GLEEPFNGLVERTEXATTRIB1HNVPROC GLeeFuncPtr_glVertexAttrib1hNV=GLee_Lazy_glVertexAttrib1hNV;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib1hvNV
#define GLEE_C_DEFINED_glVertexAttrib1hvNV
  void __stdcall GLee_Lazy_glVertexAttrib1hvNV(GLuint index, const GLhalfNV * v)  {if (GLeeInit()) glVertexAttrib1hvNV(index, v);}
  GLEEPFNGLVERTEXATTRIB1HVNVPROC GLeeFuncPtr_glVertexAttrib1hvNV=GLee_Lazy_glVertexAttrib1hvNV;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib2hNV
#define GLEE_C_DEFINED_glVertexAttrib2hNV
  void __stdcall GLee_Lazy_glVertexAttrib2hNV(GLuint index, GLhalfNV x, GLhalfNV y)  {if (GLeeInit()) glVertexAttrib2hNV(index, x, y);}
  GLEEPFNGLVERTEXATTRIB2HNVPROC GLeeFuncPtr_glVertexAttrib2hNV=GLee_Lazy_glVertexAttrib2hNV;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib2hvNV
#define GLEE_C_DEFINED_glVertexAttrib2hvNV
  void __stdcall GLee_Lazy_glVertexAttrib2hvNV(GLuint index, const GLhalfNV * v)  {if (GLeeInit()) glVertexAttrib2hvNV(index, v);}
  GLEEPFNGLVERTEXATTRIB2HVNVPROC GLeeFuncPtr_glVertexAttrib2hvNV=GLee_Lazy_glVertexAttrib2hvNV;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib3hNV
#define GLEE_C_DEFINED_glVertexAttrib3hNV
  void __stdcall GLee_Lazy_glVertexAttrib3hNV(GLuint index, GLhalfNV x, GLhalfNV y, GLhalfNV z)  {if (GLeeInit()) glVertexAttrib3hNV(index, x, y, z);}
  GLEEPFNGLVERTEXATTRIB3HNVPROC GLeeFuncPtr_glVertexAttrib3hNV=GLee_Lazy_glVertexAttrib3hNV;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib3hvNV
#define GLEE_C_DEFINED_glVertexAttrib3hvNV
  void __stdcall GLee_Lazy_glVertexAttrib3hvNV(GLuint index, const GLhalfNV * v)  {if (GLeeInit()) glVertexAttrib3hvNV(index, v);}
  GLEEPFNGLVERTEXATTRIB3HVNVPROC GLeeFuncPtr_glVertexAttrib3hvNV=GLee_Lazy_glVertexAttrib3hvNV;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib4hNV
#define GLEE_C_DEFINED_glVertexAttrib4hNV
  void __stdcall GLee_Lazy_glVertexAttrib4hNV(GLuint index, GLhalfNV x, GLhalfNV y, GLhalfNV z, GLhalfNV w)  {if (GLeeInit()) glVertexAttrib4hNV(index, x, y, z, w);}
  GLEEPFNGLVERTEXATTRIB4HNVPROC GLeeFuncPtr_glVertexAttrib4hNV=GLee_Lazy_glVertexAttrib4hNV;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttrib4hvNV
#define GLEE_C_DEFINED_glVertexAttrib4hvNV
  void __stdcall GLee_Lazy_glVertexAttrib4hvNV(GLuint index, const GLhalfNV * v)  {if (GLeeInit()) glVertexAttrib4hvNV(index, v);}
  GLEEPFNGLVERTEXATTRIB4HVNVPROC GLeeFuncPtr_glVertexAttrib4hvNV=GLee_Lazy_glVertexAttrib4hvNV;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttribs1hvNV
#define GLEE_C_DEFINED_glVertexAttribs1hvNV
  void __stdcall GLee_Lazy_glVertexAttribs1hvNV(GLuint index, GLsizei n, const GLhalfNV * v)  {if (GLeeInit()) glVertexAttribs1hvNV(index, n, v);}
  GLEEPFNGLVERTEXATTRIBS1HVNVPROC GLeeFuncPtr_glVertexAttribs1hvNV=GLee_Lazy_glVertexAttribs1hvNV;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttribs2hvNV
#define GLEE_C_DEFINED_glVertexAttribs2hvNV
  void __stdcall GLee_Lazy_glVertexAttribs2hvNV(GLuint index, GLsizei n, const GLhalfNV * v)  {if (GLeeInit()) glVertexAttribs2hvNV(index, n, v);}
  GLEEPFNGLVERTEXATTRIBS2HVNVPROC GLeeFuncPtr_glVertexAttribs2hvNV=GLee_Lazy_glVertexAttribs2hvNV;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttribs3hvNV
#define GLEE_C_DEFINED_glVertexAttribs3hvNV
  void __stdcall GLee_Lazy_glVertexAttribs3hvNV(GLuint index, GLsizei n, const GLhalfNV * v)  {if (GLeeInit()) glVertexAttribs3hvNV(index, n, v);}
  GLEEPFNGLVERTEXATTRIBS3HVNVPROC GLeeFuncPtr_glVertexAttribs3hvNV=GLee_Lazy_glVertexAttribs3hvNV;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttribs4hvNV
#define GLEE_C_DEFINED_glVertexAttribs4hvNV
  void __stdcall GLee_Lazy_glVertexAttribs4hvNV(GLuint index, GLsizei n, const GLhalfNV * v)  {if (GLeeInit()) glVertexAttribs4hvNV(index, n, v);}
  GLEEPFNGLVERTEXATTRIBS4HVNVPROC GLeeFuncPtr_glVertexAttribs4hvNV=GLee_Lazy_glVertexAttribs4hvNV;
#endif
#endif 

/* GL_NV_pixel_data_range */

#ifdef __GLEE_GL_NV_pixel_data_range
#ifndef GLEE_C_DEFINED_glPixelDataRangeNV
#define GLEE_C_DEFINED_glPixelDataRangeNV
  void __stdcall GLee_Lazy_glPixelDataRangeNV(GLenum target, GLsizei length, GLvoid * pointer)  {if (GLeeInit()) glPixelDataRangeNV(target, length, pointer);}
  GLEEPFNGLPIXELDATARANGENVPROC GLeeFuncPtr_glPixelDataRangeNV=GLee_Lazy_glPixelDataRangeNV;
#endif
#ifndef GLEE_C_DEFINED_glFlushPixelDataRangeNV
#define GLEE_C_DEFINED_glFlushPixelDataRangeNV
  void __stdcall GLee_Lazy_glFlushPixelDataRangeNV(GLenum target)  {if (GLeeInit()) glFlushPixelDataRangeNV(target);}
  GLEEPFNGLFLUSHPIXELDATARANGENVPROC GLeeFuncPtr_glFlushPixelDataRangeNV=GLee_Lazy_glFlushPixelDataRangeNV;
#endif
#endif 

/* GL_NV_primitive_restart */

#ifdef __GLEE_GL_NV_primitive_restart
#ifndef GLEE_C_DEFINED_glPrimitiveRestartNV
#define GLEE_C_DEFINED_glPrimitiveRestartNV
  void __stdcall GLee_Lazy_glPrimitiveRestartNV(void)  {if (GLeeInit()) glPrimitiveRestartNV();}
  GLEEPFNGLPRIMITIVERESTARTNVPROC GLeeFuncPtr_glPrimitiveRestartNV=GLee_Lazy_glPrimitiveRestartNV;
#endif
#ifndef GLEE_C_DEFINED_glPrimitiveRestartIndexNV
#define GLEE_C_DEFINED_glPrimitiveRestartIndexNV
  void __stdcall GLee_Lazy_glPrimitiveRestartIndexNV(GLuint index)  {if (GLeeInit()) glPrimitiveRestartIndexNV(index);}
  GLEEPFNGLPRIMITIVERESTARTINDEXNVPROC GLeeFuncPtr_glPrimitiveRestartIndexNV=GLee_Lazy_glPrimitiveRestartIndexNV;
#endif
#endif 

/* GL_NV_texture_expand_normal */

#ifdef __GLEE_GL_NV_texture_expand_normal
#endif 

/* GL_NV_vertex_program2 */

#ifdef __GLEE_GL_NV_vertex_program2
#endif 

/* GL_ATI_map_object_buffer */

#ifdef __GLEE_GL_ATI_map_object_buffer
#ifndef GLEE_C_DEFINED_glMapObjectBufferATI
#define GLEE_C_DEFINED_glMapObjectBufferATI
  GLvoid* __stdcall GLee_Lazy_glMapObjectBufferATI(GLuint buffer)  {if (GLeeInit()) return glMapObjectBufferATI(buffer); return (GLvoid*)0;}
  GLEEPFNGLMAPOBJECTBUFFERATIPROC GLeeFuncPtr_glMapObjectBufferATI=GLee_Lazy_glMapObjectBufferATI;
#endif
#ifndef GLEE_C_DEFINED_glUnmapObjectBufferATI
#define GLEE_C_DEFINED_glUnmapObjectBufferATI
  void __stdcall GLee_Lazy_glUnmapObjectBufferATI(GLuint buffer)  {if (GLeeInit()) glUnmapObjectBufferATI(buffer);}
  GLEEPFNGLUNMAPOBJECTBUFFERATIPROC GLeeFuncPtr_glUnmapObjectBufferATI=GLee_Lazy_glUnmapObjectBufferATI;
#endif
#endif 

/* GL_ATI_separate_stencil */

#ifdef __GLEE_GL_ATI_separate_stencil
#ifndef GLEE_C_DEFINED_glStencilOpSeparateATI
#define GLEE_C_DEFINED_glStencilOpSeparateATI
  void __stdcall GLee_Lazy_glStencilOpSeparateATI(GLenum face, GLenum sfail, GLenum dpfail, GLenum dppass)  {if (GLeeInit()) glStencilOpSeparateATI(face, sfail, dpfail, dppass);}
  GLEEPFNGLSTENCILOPSEPARATEATIPROC GLeeFuncPtr_glStencilOpSeparateATI=GLee_Lazy_glStencilOpSeparateATI;
#endif
#ifndef GLEE_C_DEFINED_glStencilFuncSeparateATI
#define GLEE_C_DEFINED_glStencilFuncSeparateATI
  void __stdcall GLee_Lazy_glStencilFuncSeparateATI(GLenum frontfunc, GLenum backfunc, GLint ref, GLuint mask)  {if (GLeeInit()) glStencilFuncSeparateATI(frontfunc, backfunc, ref, mask);}
  GLEEPFNGLSTENCILFUNCSEPARATEATIPROC GLeeFuncPtr_glStencilFuncSeparateATI=GLee_Lazy_glStencilFuncSeparateATI;
#endif
#endif 

/* GL_ATI_vertex_attrib_array_object */

#ifdef __GLEE_GL_ATI_vertex_attrib_array_object
#ifndef GLEE_C_DEFINED_glVertexAttribArrayObjectATI
#define GLEE_C_DEFINED_glVertexAttribArrayObjectATI
  void __stdcall GLee_Lazy_glVertexAttribArrayObjectATI(GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, GLuint buffer, GLuint offset)  {if (GLeeInit()) glVertexAttribArrayObjectATI(index, size, type, normalized, stride, buffer, offset);}
  GLEEPFNGLVERTEXATTRIBARRAYOBJECTATIPROC GLeeFuncPtr_glVertexAttribArrayObjectATI=GLee_Lazy_glVertexAttribArrayObjectATI;
#endif
#ifndef GLEE_C_DEFINED_glGetVertexAttribArrayObjectfvATI
#define GLEE_C_DEFINED_glGetVertexAttribArrayObjectfvATI
  void __stdcall GLee_Lazy_glGetVertexAttribArrayObjectfvATI(GLuint index, GLenum pname, GLfloat * params)  {if (GLeeInit()) glGetVertexAttribArrayObjectfvATI(index, pname, params);}
  GLEEPFNGLGETVERTEXATTRIBARRAYOBJECTFVATIPROC GLeeFuncPtr_glGetVertexAttribArrayObjectfvATI=GLee_Lazy_glGetVertexAttribArrayObjectfvATI;
#endif
#ifndef GLEE_C_DEFINED_glGetVertexAttribArrayObjectivATI
#define GLEE_C_DEFINED_glGetVertexAttribArrayObjectivATI
  void __stdcall GLee_Lazy_glGetVertexAttribArrayObjectivATI(GLuint index, GLenum pname, GLint * params)  {if (GLeeInit()) glGetVertexAttribArrayObjectivATI(index, pname, params);}
  GLEEPFNGLGETVERTEXATTRIBARRAYOBJECTIVATIPROC GLeeFuncPtr_glGetVertexAttribArrayObjectivATI=GLee_Lazy_glGetVertexAttribArrayObjectivATI;
#endif
#endif 

/* GL_OES_read_format */

#ifdef __GLEE_GL_OES_read_format
#endif 

/* GL_EXT_depth_bounds_test */

#ifdef __GLEE_GL_EXT_depth_bounds_test
#ifndef GLEE_C_DEFINED_glDepthBoundsEXT
#define GLEE_C_DEFINED_glDepthBoundsEXT
  void __stdcall GLee_Lazy_glDepthBoundsEXT(GLclampd zmin, GLclampd zmax)  {if (GLeeInit()) glDepthBoundsEXT(zmin, zmax);}
  GLEEPFNGLDEPTHBOUNDSEXTPROC GLeeFuncPtr_glDepthBoundsEXT=GLee_Lazy_glDepthBoundsEXT;
#endif
#endif 

/* GL_EXT_texture_mirror_clamp */

#ifdef __GLEE_GL_EXT_texture_mirror_clamp
#endif 

/* GL_EXT_blend_equation_separate */

#ifdef __GLEE_GL_EXT_blend_equation_separate
#ifndef GLEE_C_DEFINED_glBlendEquationSeparateEXT
#define GLEE_C_DEFINED_glBlendEquationSeparateEXT
  void __stdcall GLee_Lazy_glBlendEquationSeparateEXT(GLenum modeRGB, GLenum modeAlpha)  {if (GLeeInit()) glBlendEquationSeparateEXT(modeRGB, modeAlpha);}
  GLEEPFNGLBLENDEQUATIONSEPARATEEXTPROC GLeeFuncPtr_glBlendEquationSeparateEXT=GLee_Lazy_glBlendEquationSeparateEXT;
#endif
#endif 

/* GL_MESA_pack_invert */

#ifdef __GLEE_GL_MESA_pack_invert
#endif 

/* GL_MESA_ycbcr_texture */

#ifdef __GLEE_GL_MESA_ycbcr_texture
#endif 

/* GL_EXT_pixel_buffer_object */

#ifdef __GLEE_GL_EXT_pixel_buffer_object
#endif 

/* GL_NV_fragment_program_option */

#ifdef __GLEE_GL_NV_fragment_program_option
#endif 

/* GL_NV_fragment_program2 */

#ifdef __GLEE_GL_NV_fragment_program2
#endif 

/* GL_NV_vertex_program2_option */

#ifdef __GLEE_GL_NV_vertex_program2_option
#endif 

/* GL_NV_vertex_program3 */

#ifdef __GLEE_GL_NV_vertex_program3
#endif 

/* GL_EXT_framebuffer_object */

#ifdef __GLEE_GL_EXT_framebuffer_object
#ifndef GLEE_C_DEFINED_glIsRenderbufferEXT
#define GLEE_C_DEFINED_glIsRenderbufferEXT
  GLboolean __stdcall GLee_Lazy_glIsRenderbufferEXT(GLuint renderbuffer)  {if (GLeeInit()) return glIsRenderbufferEXT(renderbuffer); return (GLboolean)0;}
  GLEEPFNGLISRENDERBUFFEREXTPROC GLeeFuncPtr_glIsRenderbufferEXT=GLee_Lazy_glIsRenderbufferEXT;
#endif
#ifndef GLEE_C_DEFINED_glBindRenderbufferEXT
#define GLEE_C_DEFINED_glBindRenderbufferEXT
  void __stdcall GLee_Lazy_glBindRenderbufferEXT(GLenum target, GLuint renderbuffer)  {if (GLeeInit()) glBindRenderbufferEXT(target, renderbuffer);}
  GLEEPFNGLBINDRENDERBUFFEREXTPROC GLeeFuncPtr_glBindRenderbufferEXT=GLee_Lazy_glBindRenderbufferEXT;
#endif
#ifndef GLEE_C_DEFINED_glDeleteRenderbuffersEXT
#define GLEE_C_DEFINED_glDeleteRenderbuffersEXT
  void __stdcall GLee_Lazy_glDeleteRenderbuffersEXT(GLsizei n, const GLuint * renderbuffers)  {if (GLeeInit()) glDeleteRenderbuffersEXT(n, renderbuffers);}
  GLEEPFNGLDELETERENDERBUFFERSEXTPROC GLeeFuncPtr_glDeleteRenderbuffersEXT=GLee_Lazy_glDeleteRenderbuffersEXT;
#endif
#ifndef GLEE_C_DEFINED_glGenRenderbuffersEXT
#define GLEE_C_DEFINED_glGenRenderbuffersEXT
  void __stdcall GLee_Lazy_glGenRenderbuffersEXT(GLsizei n, GLuint * renderbuffers)  {if (GLeeInit()) glGenRenderbuffersEXT(n, renderbuffers);}
  GLEEPFNGLGENRENDERBUFFERSEXTPROC GLeeFuncPtr_glGenRenderbuffersEXT=GLee_Lazy_glGenRenderbuffersEXT;
#endif
#ifndef GLEE_C_DEFINED_glRenderbufferStorageEXT
#define GLEE_C_DEFINED_glRenderbufferStorageEXT
  void __stdcall GLee_Lazy_glRenderbufferStorageEXT(GLenum target, GLenum internalformat, GLsizei width, GLsizei height)  {if (GLeeInit()) glRenderbufferStorageEXT(target, internalformat, width, height);}
  GLEEPFNGLRENDERBUFFERSTORAGEEXTPROC GLeeFuncPtr_glRenderbufferStorageEXT=GLee_Lazy_glRenderbufferStorageEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetRenderbufferParameterivEXT
#define GLEE_C_DEFINED_glGetRenderbufferParameterivEXT
  void __stdcall GLee_Lazy_glGetRenderbufferParameterivEXT(GLenum target, GLenum pname, GLint * params)  {if (GLeeInit()) glGetRenderbufferParameterivEXT(target, pname, params);}
  GLEEPFNGLGETRENDERBUFFERPARAMETERIVEXTPROC GLeeFuncPtr_glGetRenderbufferParameterivEXT=GLee_Lazy_glGetRenderbufferParameterivEXT;
#endif
#ifndef GLEE_C_DEFINED_glIsFramebufferEXT
#define GLEE_C_DEFINED_glIsFramebufferEXT
  GLboolean __stdcall GLee_Lazy_glIsFramebufferEXT(GLuint framebuffer)  {if (GLeeInit()) return glIsFramebufferEXT(framebuffer); return (GLboolean)0;}
  GLEEPFNGLISFRAMEBUFFEREXTPROC GLeeFuncPtr_glIsFramebufferEXT=GLee_Lazy_glIsFramebufferEXT;
#endif
#ifndef GLEE_C_DEFINED_glBindFramebufferEXT
#define GLEE_C_DEFINED_glBindFramebufferEXT
  void __stdcall GLee_Lazy_glBindFramebufferEXT(GLenum target, GLuint framebuffer)  {if (GLeeInit()) glBindFramebufferEXT(target, framebuffer);}
  GLEEPFNGLBINDFRAMEBUFFEREXTPROC GLeeFuncPtr_glBindFramebufferEXT=GLee_Lazy_glBindFramebufferEXT;
#endif
#ifndef GLEE_C_DEFINED_glDeleteFramebuffersEXT
#define GLEE_C_DEFINED_glDeleteFramebuffersEXT
  void __stdcall GLee_Lazy_glDeleteFramebuffersEXT(GLsizei n, const GLuint * framebuffers)  {if (GLeeInit()) glDeleteFramebuffersEXT(n, framebuffers);}
  GLEEPFNGLDELETEFRAMEBUFFERSEXTPROC GLeeFuncPtr_glDeleteFramebuffersEXT=GLee_Lazy_glDeleteFramebuffersEXT;
#endif
#ifndef GLEE_C_DEFINED_glGenFramebuffersEXT
#define GLEE_C_DEFINED_glGenFramebuffersEXT
  void __stdcall GLee_Lazy_glGenFramebuffersEXT(GLsizei n, GLuint * framebuffers)  {if (GLeeInit()) glGenFramebuffersEXT(n, framebuffers);}
  GLEEPFNGLGENFRAMEBUFFERSEXTPROC GLeeFuncPtr_glGenFramebuffersEXT=GLee_Lazy_glGenFramebuffersEXT;
#endif
#ifndef GLEE_C_DEFINED_glCheckFramebufferStatusEXT
#define GLEE_C_DEFINED_glCheckFramebufferStatusEXT
  GLenum __stdcall GLee_Lazy_glCheckFramebufferStatusEXT(GLenum target)  {if (GLeeInit()) return glCheckFramebufferStatusEXT(target); return (GLenum)0;}
  GLEEPFNGLCHECKFRAMEBUFFERSTATUSEXTPROC GLeeFuncPtr_glCheckFramebufferStatusEXT=GLee_Lazy_glCheckFramebufferStatusEXT;
#endif
#ifndef GLEE_C_DEFINED_glFramebufferTexture1DEXT
#define GLEE_C_DEFINED_glFramebufferTexture1DEXT
  void __stdcall GLee_Lazy_glFramebufferTexture1DEXT(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level)  {if (GLeeInit()) glFramebufferTexture1DEXT(target, attachment, textarget, texture, level);}
  GLEEPFNGLFRAMEBUFFERTEXTURE1DEXTPROC GLeeFuncPtr_glFramebufferTexture1DEXT=GLee_Lazy_glFramebufferTexture1DEXT;
#endif
#ifndef GLEE_C_DEFINED_glFramebufferTexture2DEXT
#define GLEE_C_DEFINED_glFramebufferTexture2DEXT
  void __stdcall GLee_Lazy_glFramebufferTexture2DEXT(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level)  {if (GLeeInit()) glFramebufferTexture2DEXT(target, attachment, textarget, texture, level);}
  GLEEPFNGLFRAMEBUFFERTEXTURE2DEXTPROC GLeeFuncPtr_glFramebufferTexture2DEXT=GLee_Lazy_glFramebufferTexture2DEXT;
#endif
#ifndef GLEE_C_DEFINED_glFramebufferTexture3DEXT
#define GLEE_C_DEFINED_glFramebufferTexture3DEXT
  void __stdcall GLee_Lazy_glFramebufferTexture3DEXT(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset)  {if (GLeeInit()) glFramebufferTexture3DEXT(target, attachment, textarget, texture, level, zoffset);}
  GLEEPFNGLFRAMEBUFFERTEXTURE3DEXTPROC GLeeFuncPtr_glFramebufferTexture3DEXT=GLee_Lazy_glFramebufferTexture3DEXT;
#endif
#ifndef GLEE_C_DEFINED_glFramebufferRenderbufferEXT
#define GLEE_C_DEFINED_glFramebufferRenderbufferEXT
  void __stdcall GLee_Lazy_glFramebufferRenderbufferEXT(GLenum target, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer)  {if (GLeeInit()) glFramebufferRenderbufferEXT(target, attachment, renderbuffertarget, renderbuffer);}
  GLEEPFNGLFRAMEBUFFERRENDERBUFFEREXTPROC GLeeFuncPtr_glFramebufferRenderbufferEXT=GLee_Lazy_glFramebufferRenderbufferEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetFramebufferAttachmentParameterivEXT
#define GLEE_C_DEFINED_glGetFramebufferAttachmentParameterivEXT
  void __stdcall GLee_Lazy_glGetFramebufferAttachmentParameterivEXT(GLenum target, GLenum attachment, GLenum pname, GLint * params)  {if (GLeeInit()) glGetFramebufferAttachmentParameterivEXT(target, attachment, pname, params);}
  GLEEPFNGLGETFRAMEBUFFERATTACHMENTPARAMETERIVEXTPROC GLeeFuncPtr_glGetFramebufferAttachmentParameterivEXT=GLee_Lazy_glGetFramebufferAttachmentParameterivEXT;
#endif
#ifndef GLEE_C_DEFINED_glGenerateMipmapEXT
#define GLEE_C_DEFINED_glGenerateMipmapEXT
  void __stdcall GLee_Lazy_glGenerateMipmapEXT(GLenum target)  {if (GLeeInit()) glGenerateMipmapEXT(target);}
  GLEEPFNGLGENERATEMIPMAPEXTPROC GLeeFuncPtr_glGenerateMipmapEXT=GLee_Lazy_glGenerateMipmapEXT;
#endif
#endif 

/* GL_GREMEDY_string_marker */

#ifdef __GLEE_GL_GREMEDY_string_marker
#ifndef GLEE_C_DEFINED_glStringMarkerGREMEDY
#define GLEE_C_DEFINED_glStringMarkerGREMEDY
  void __stdcall GLee_Lazy_glStringMarkerGREMEDY(GLsizei len, const GLvoid * string)  {if (GLeeInit()) glStringMarkerGREMEDY(len, string);}
  GLEEPFNGLSTRINGMARKERGREMEDYPROC GLeeFuncPtr_glStringMarkerGREMEDY=GLee_Lazy_glStringMarkerGREMEDY;
#endif
#endif 

/* GL_EXT_packed_depth_stencil */

#ifdef __GLEE_GL_EXT_packed_depth_stencil
#endif 

/* GL_EXT_stencil_clear_tag */

#ifdef __GLEE_GL_EXT_stencil_clear_tag
#ifndef GLEE_C_DEFINED_glStencilClearTagEXT
#define GLEE_C_DEFINED_glStencilClearTagEXT
  void __stdcall GLee_Lazy_glStencilClearTagEXT(GLsizei stencilTagBits, GLuint stencilClearTag)  {if (GLeeInit()) glStencilClearTagEXT(stencilTagBits, stencilClearTag);}
  GLEEPFNGLSTENCILCLEARTAGEXTPROC GLeeFuncPtr_glStencilClearTagEXT=GLee_Lazy_glStencilClearTagEXT;
#endif
#endif 

/* GL_EXT_texture_sRGB */

#ifdef __GLEE_GL_EXT_texture_sRGB
#endif 

/* GL_EXT_framebuffer_blit */

#ifdef __GLEE_GL_EXT_framebuffer_blit
#ifndef GLEE_C_DEFINED_glBlitFramebufferEXT
#define GLEE_C_DEFINED_glBlitFramebufferEXT
  void __stdcall GLee_Lazy_glBlitFramebufferEXT(GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter)  {if (GLeeInit()) glBlitFramebufferEXT(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter);}
  GLEEPFNGLBLITFRAMEBUFFEREXTPROC GLeeFuncPtr_glBlitFramebufferEXT=GLee_Lazy_glBlitFramebufferEXT;
#endif
#endif 

/* GL_EXT_framebuffer_multisample */

#ifdef __GLEE_GL_EXT_framebuffer_multisample
#ifndef GLEE_C_DEFINED_glRenderbufferStorageMultisampleEXT
#define GLEE_C_DEFINED_glRenderbufferStorageMultisampleEXT
  void __stdcall GLee_Lazy_glRenderbufferStorageMultisampleEXT(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height)  {if (GLeeInit()) glRenderbufferStorageMultisampleEXT(target, samples, internalformat, width, height);}
  GLEEPFNGLRENDERBUFFERSTORAGEMULTISAMPLEEXTPROC GLeeFuncPtr_glRenderbufferStorageMultisampleEXT=GLee_Lazy_glRenderbufferStorageMultisampleEXT;
#endif
#endif 

/* GL_MESAX_texture_stack */

#ifdef __GLEE_GL_MESAX_texture_stack
#endif 

/* GL_EXT_timer_query */

#ifdef __GLEE_GL_EXT_timer_query
#ifndef GLEE_C_DEFINED_glGetQueryObjecti64vEXT
#define GLEE_C_DEFINED_glGetQueryObjecti64vEXT
  void __stdcall GLee_Lazy_glGetQueryObjecti64vEXT(GLuint id, GLenum pname, GLint64EXT * params)  {if (GLeeInit()) glGetQueryObjecti64vEXT(id, pname, params);}
  GLEEPFNGLGETQUERYOBJECTI64VEXTPROC GLeeFuncPtr_glGetQueryObjecti64vEXT=GLee_Lazy_glGetQueryObjecti64vEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetQueryObjectui64vEXT
#define GLEE_C_DEFINED_glGetQueryObjectui64vEXT
  void __stdcall GLee_Lazy_glGetQueryObjectui64vEXT(GLuint id, GLenum pname, GLuint64EXT * params)  {if (GLeeInit()) glGetQueryObjectui64vEXT(id, pname, params);}
  GLEEPFNGLGETQUERYOBJECTUI64VEXTPROC GLeeFuncPtr_glGetQueryObjectui64vEXT=GLee_Lazy_glGetQueryObjectui64vEXT;
#endif
#endif 

/* GL_EXT_gpu_program_parameters */

#ifdef __GLEE_GL_EXT_gpu_program_parameters
#ifndef GLEE_C_DEFINED_glProgramEnvParameters4fvEXT
#define GLEE_C_DEFINED_glProgramEnvParameters4fvEXT
  void __stdcall GLee_Lazy_glProgramEnvParameters4fvEXT(GLenum target, GLuint index, GLsizei count, const GLfloat * params)  {if (GLeeInit()) glProgramEnvParameters4fvEXT(target, index, count, params);}
  GLEEPFNGLPROGRAMENVPARAMETERS4FVEXTPROC GLeeFuncPtr_glProgramEnvParameters4fvEXT=GLee_Lazy_glProgramEnvParameters4fvEXT;
#endif
#ifndef GLEE_C_DEFINED_glProgramLocalParameters4fvEXT
#define GLEE_C_DEFINED_glProgramLocalParameters4fvEXT
  void __stdcall GLee_Lazy_glProgramLocalParameters4fvEXT(GLenum target, GLuint index, GLsizei count, const GLfloat * params)  {if (GLeeInit()) glProgramLocalParameters4fvEXT(target, index, count, params);}
  GLEEPFNGLPROGRAMLOCALPARAMETERS4FVEXTPROC GLeeFuncPtr_glProgramLocalParameters4fvEXT=GLee_Lazy_glProgramLocalParameters4fvEXT;
#endif
#endif 

/* GL_APPLE_flush_buffer_range */

#ifdef __GLEE_GL_APPLE_flush_buffer_range
#ifndef GLEE_C_DEFINED_glBufferParameteriAPPLE
#define GLEE_C_DEFINED_glBufferParameteriAPPLE
  void __stdcall GLee_Lazy_glBufferParameteriAPPLE(GLenum target, GLenum pname, GLint param)  {if (GLeeInit()) glBufferParameteriAPPLE(target, pname, param);}
  GLEEPFNGLBUFFERPARAMETERIAPPLEPROC GLeeFuncPtr_glBufferParameteriAPPLE=GLee_Lazy_glBufferParameteriAPPLE;
#endif
#ifndef GLEE_C_DEFINED_glFlushMappedBufferRangeAPPLE
#define GLEE_C_DEFINED_glFlushMappedBufferRangeAPPLE
  void __stdcall GLee_Lazy_glFlushMappedBufferRangeAPPLE(GLenum target, GLintptr offset, GLsizeiptr size)  {if (GLeeInit()) glFlushMappedBufferRangeAPPLE(target, offset, size);}
  GLEEPFNGLFLUSHMAPPEDBUFFERRANGEAPPLEPROC GLeeFuncPtr_glFlushMappedBufferRangeAPPLE=GLee_Lazy_glFlushMappedBufferRangeAPPLE;
#endif
#endif 

/* GL_EXT_gpu_shader4 */

#ifdef __GLEE_GL_EXT_gpu_shader4
#ifndef GLEE_C_DEFINED_glGetUniformuivEXT
#define GLEE_C_DEFINED_glGetUniformuivEXT
  void __stdcall GLee_Lazy_glGetUniformuivEXT(GLuint program, GLint location, GLuint * params)  {if (GLeeInit()) glGetUniformuivEXT(program, location, params);}
  GLEEPFNGLGETUNIFORMUIVEXTPROC GLeeFuncPtr_glGetUniformuivEXT=GLee_Lazy_glGetUniformuivEXT;
#endif
#ifndef GLEE_C_DEFINED_glBindFragDataLocationEXT
#define GLEE_C_DEFINED_glBindFragDataLocationEXT
  void __stdcall GLee_Lazy_glBindFragDataLocationEXT(GLuint program, GLuint color, const GLchar * name)  {if (GLeeInit()) glBindFragDataLocationEXT(program, color, name);}
  GLEEPFNGLBINDFRAGDATALOCATIONEXTPROC GLeeFuncPtr_glBindFragDataLocationEXT=GLee_Lazy_glBindFragDataLocationEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetFragDataLocationEXT
#define GLEE_C_DEFINED_glGetFragDataLocationEXT
  GLint __stdcall GLee_Lazy_glGetFragDataLocationEXT(GLuint program, const GLchar * name)  {if (GLeeInit()) return glGetFragDataLocationEXT(program, name); return (GLint)0;}
  GLEEPFNGLGETFRAGDATALOCATIONEXTPROC GLeeFuncPtr_glGetFragDataLocationEXT=GLee_Lazy_glGetFragDataLocationEXT;
#endif
#ifndef GLEE_C_DEFINED_glUniform1uiEXT
#define GLEE_C_DEFINED_glUniform1uiEXT
  void __stdcall GLee_Lazy_glUniform1uiEXT(GLint location, GLuint v0)  {if (GLeeInit()) glUniform1uiEXT(location, v0);}
  GLEEPFNGLUNIFORM1UIEXTPROC GLeeFuncPtr_glUniform1uiEXT=GLee_Lazy_glUniform1uiEXT;
#endif
#ifndef GLEE_C_DEFINED_glUniform2uiEXT
#define GLEE_C_DEFINED_glUniform2uiEXT
  void __stdcall GLee_Lazy_glUniform2uiEXT(GLint location, GLuint v0, GLuint v1)  {if (GLeeInit()) glUniform2uiEXT(location, v0, v1);}
  GLEEPFNGLUNIFORM2UIEXTPROC GLeeFuncPtr_glUniform2uiEXT=GLee_Lazy_glUniform2uiEXT;
#endif
#ifndef GLEE_C_DEFINED_glUniform3uiEXT
#define GLEE_C_DEFINED_glUniform3uiEXT
  void __stdcall GLee_Lazy_glUniform3uiEXT(GLint location, GLuint v0, GLuint v1, GLuint v2)  {if (GLeeInit()) glUniform3uiEXT(location, v0, v1, v2);}
  GLEEPFNGLUNIFORM3UIEXTPROC GLeeFuncPtr_glUniform3uiEXT=GLee_Lazy_glUniform3uiEXT;
#endif
#ifndef GLEE_C_DEFINED_glUniform4uiEXT
#define GLEE_C_DEFINED_glUniform4uiEXT
  void __stdcall GLee_Lazy_glUniform4uiEXT(GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3)  {if (GLeeInit()) glUniform4uiEXT(location, v0, v1, v2, v3);}
  GLEEPFNGLUNIFORM4UIEXTPROC GLeeFuncPtr_glUniform4uiEXT=GLee_Lazy_glUniform4uiEXT;
#endif
#ifndef GLEE_C_DEFINED_glUniform1uivEXT
#define GLEE_C_DEFINED_glUniform1uivEXT
  void __stdcall GLee_Lazy_glUniform1uivEXT(GLint location, GLsizei count, const GLuint * value)  {if (GLeeInit()) glUniform1uivEXT(location, count, value);}
  GLEEPFNGLUNIFORM1UIVEXTPROC GLeeFuncPtr_glUniform1uivEXT=GLee_Lazy_glUniform1uivEXT;
#endif
#ifndef GLEE_C_DEFINED_glUniform2uivEXT
#define GLEE_C_DEFINED_glUniform2uivEXT
  void __stdcall GLee_Lazy_glUniform2uivEXT(GLint location, GLsizei count, const GLuint * value)  {if (GLeeInit()) glUniform2uivEXT(location, count, value);}
  GLEEPFNGLUNIFORM2UIVEXTPROC GLeeFuncPtr_glUniform2uivEXT=GLee_Lazy_glUniform2uivEXT;
#endif
#ifndef GLEE_C_DEFINED_glUniform3uivEXT
#define GLEE_C_DEFINED_glUniform3uivEXT
  void __stdcall GLee_Lazy_glUniform3uivEXT(GLint location, GLsizei count, const GLuint * value)  {if (GLeeInit()) glUniform3uivEXT(location, count, value);}
  GLEEPFNGLUNIFORM3UIVEXTPROC GLeeFuncPtr_glUniform3uivEXT=GLee_Lazy_glUniform3uivEXT;
#endif
#ifndef GLEE_C_DEFINED_glUniform4uivEXT
#define GLEE_C_DEFINED_glUniform4uivEXT
  void __stdcall GLee_Lazy_glUniform4uivEXT(GLint location, GLsizei count, const GLuint * value)  {if (GLeeInit()) glUniform4uivEXT(location, count, value);}
  GLEEPFNGLUNIFORM4UIVEXTPROC GLeeFuncPtr_glUniform4uivEXT=GLee_Lazy_glUniform4uivEXT;
#endif
#endif 

/* GL_EXT_draw_instanced */

#ifdef __GLEE_GL_EXT_draw_instanced
#ifndef GLEE_C_DEFINED_glDrawArraysInstancedEXT
#define GLEE_C_DEFINED_glDrawArraysInstancedEXT
  void __stdcall GLee_Lazy_glDrawArraysInstancedEXT(GLenum mode, GLint start, GLsizei count, GLsizei primcount)  {if (GLeeInit()) glDrawArraysInstancedEXT(mode, start, count, primcount);}
  GLEEPFNGLDRAWARRAYSINSTANCEDEXTPROC GLeeFuncPtr_glDrawArraysInstancedEXT=GLee_Lazy_glDrawArraysInstancedEXT;
#endif
#ifndef GLEE_C_DEFINED_glDrawElementsInstancedEXT
#define GLEE_C_DEFINED_glDrawElementsInstancedEXT
  void __stdcall GLee_Lazy_glDrawElementsInstancedEXT(GLenum mode, GLsizei count, GLenum type, const GLvoid * indices, GLsizei primcount)  {if (GLeeInit()) glDrawElementsInstancedEXT(mode, count, type, indices, primcount);}
  GLEEPFNGLDRAWELEMENTSINSTANCEDEXTPROC GLeeFuncPtr_glDrawElementsInstancedEXT=GLee_Lazy_glDrawElementsInstancedEXT;
#endif
#endif 

/* GL_EXT_packed_float */

#ifdef __GLEE_GL_EXT_packed_float
#endif 

/* GL_EXT_texture_array */

#ifdef __GLEE_GL_EXT_texture_array
#endif 

/* GL_EXT_texture_buffer_object */

#ifdef __GLEE_GL_EXT_texture_buffer_object
#ifndef GLEE_C_DEFINED_glTexBufferEXT
#define GLEE_C_DEFINED_glTexBufferEXT
  void __stdcall GLee_Lazy_glTexBufferEXT(GLenum target, GLenum internalformat, GLuint buffer)  {if (GLeeInit()) glTexBufferEXT(target, internalformat, buffer);}
  GLEEPFNGLTEXBUFFEREXTPROC GLeeFuncPtr_glTexBufferEXT=GLee_Lazy_glTexBufferEXT;
#endif
#endif 

/* GL_EXT_texture_compression_latc */

#ifdef __GLEE_GL_EXT_texture_compression_latc
#endif 

/* GL_EXT_texture_compression_rgtc */

#ifdef __GLEE_GL_EXT_texture_compression_rgtc
#endif 

/* GL_EXT_texture_shared_exponent */

#ifdef __GLEE_GL_EXT_texture_shared_exponent
#endif 

/* GL_NV_depth_buffer_float */

#ifdef __GLEE_GL_NV_depth_buffer_float
#ifndef GLEE_C_DEFINED_glDepthRangedNV
#define GLEE_C_DEFINED_glDepthRangedNV
  void __stdcall GLee_Lazy_glDepthRangedNV(GLdouble zNear, GLdouble zFar)  {if (GLeeInit()) glDepthRangedNV(zNear, zFar);}
  GLEEPFNGLDEPTHRANGEDNVPROC GLeeFuncPtr_glDepthRangedNV=GLee_Lazy_glDepthRangedNV;
#endif
#ifndef GLEE_C_DEFINED_glClearDepthdNV
#define GLEE_C_DEFINED_glClearDepthdNV
  void __stdcall GLee_Lazy_glClearDepthdNV(GLdouble depth)  {if (GLeeInit()) glClearDepthdNV(depth);}
  GLEEPFNGLCLEARDEPTHDNVPROC GLeeFuncPtr_glClearDepthdNV=GLee_Lazy_glClearDepthdNV;
#endif
#ifndef GLEE_C_DEFINED_glDepthBoundsdNV
#define GLEE_C_DEFINED_glDepthBoundsdNV
  void __stdcall GLee_Lazy_glDepthBoundsdNV(GLdouble zmin, GLdouble zmax)  {if (GLeeInit()) glDepthBoundsdNV(zmin, zmax);}
  GLEEPFNGLDEPTHBOUNDSDNVPROC GLeeFuncPtr_glDepthBoundsdNV=GLee_Lazy_glDepthBoundsdNV;
#endif
#endif 

/* GL_NV_framebuffer_multisample_coverage */

#ifdef __GLEE_GL_NV_framebuffer_multisample_coverage
#ifndef GLEE_C_DEFINED_glRenderbufferStorageMultisampleCoverageNV
#define GLEE_C_DEFINED_glRenderbufferStorageMultisampleCoverageNV
  void __stdcall GLee_Lazy_glRenderbufferStorageMultisampleCoverageNV(GLenum target, GLsizei coverageSamples, GLsizei colorSamples, GLenum internalformat, GLsizei width, GLsizei height)  {if (GLeeInit()) glRenderbufferStorageMultisampleCoverageNV(target, coverageSamples, colorSamples, internalformat, width, height);}
  GLEEPFNGLRENDERBUFFERSTORAGEMULTISAMPLECOVERAGENVPROC GLeeFuncPtr_glRenderbufferStorageMultisampleCoverageNV=GLee_Lazy_glRenderbufferStorageMultisampleCoverageNV;
#endif
#endif 

/* GL_EXT_framebuffer_sRGB */

#ifdef __GLEE_GL_EXT_framebuffer_sRGB
#endif 

/* GL_NV_geometry_shader4 */

#ifdef __GLEE_GL_NV_geometry_shader4
#endif 

/* GL_NV_parameter_buffer_object */

#ifdef __GLEE_GL_NV_parameter_buffer_object
#ifndef GLEE_C_DEFINED_glProgramBufferParametersfvNV
#define GLEE_C_DEFINED_glProgramBufferParametersfvNV
  void __stdcall GLee_Lazy_glProgramBufferParametersfvNV(GLenum target, GLuint buffer, GLuint index, GLsizei count, const GLfloat * params)  {if (GLeeInit()) glProgramBufferParametersfvNV(target, buffer, index, count, params);}
  GLEEPFNGLPROGRAMBUFFERPARAMETERSFVNVPROC GLeeFuncPtr_glProgramBufferParametersfvNV=GLee_Lazy_glProgramBufferParametersfvNV;
#endif
#ifndef GLEE_C_DEFINED_glProgramBufferParametersIivNV
#define GLEE_C_DEFINED_glProgramBufferParametersIivNV
  void __stdcall GLee_Lazy_glProgramBufferParametersIivNV(GLenum target, GLuint buffer, GLuint index, GLsizei count, const GLint * params)  {if (GLeeInit()) glProgramBufferParametersIivNV(target, buffer, index, count, params);}
  GLEEPFNGLPROGRAMBUFFERPARAMETERSIIVNVPROC GLeeFuncPtr_glProgramBufferParametersIivNV=GLee_Lazy_glProgramBufferParametersIivNV;
#endif
#ifndef GLEE_C_DEFINED_glProgramBufferParametersIuivNV
#define GLEE_C_DEFINED_glProgramBufferParametersIuivNV
  void __stdcall GLee_Lazy_glProgramBufferParametersIuivNV(GLenum target, GLuint buffer, GLuint index, GLsizei count, const GLuint * params)  {if (GLeeInit()) glProgramBufferParametersIuivNV(target, buffer, index, count, params);}
  GLEEPFNGLPROGRAMBUFFERPARAMETERSIUIVNVPROC GLeeFuncPtr_glProgramBufferParametersIuivNV=GLee_Lazy_glProgramBufferParametersIuivNV;
#endif
#endif 

/* GL_EXT_draw_buffers2 */

#ifdef __GLEE_GL_EXT_draw_buffers2
#ifndef GLEE_C_DEFINED_glColorMaskIndexedEXT
#define GLEE_C_DEFINED_glColorMaskIndexedEXT
  void __stdcall GLee_Lazy_glColorMaskIndexedEXT(GLuint index, GLboolean r, GLboolean g, GLboolean b, GLboolean a)  {if (GLeeInit()) glColorMaskIndexedEXT(index, r, g, b, a);}
  GLEEPFNGLCOLORMASKINDEXEDEXTPROC GLeeFuncPtr_glColorMaskIndexedEXT=GLee_Lazy_glColorMaskIndexedEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetBooleanIndexedvEXT
#define GLEE_C_DEFINED_glGetBooleanIndexedvEXT
  void __stdcall GLee_Lazy_glGetBooleanIndexedvEXT(GLenum target, GLuint index, GLboolean * data)  {if (GLeeInit()) glGetBooleanIndexedvEXT(target, index, data);}
  GLEEPFNGLGETBOOLEANINDEXEDVEXTPROC GLeeFuncPtr_glGetBooleanIndexedvEXT=GLee_Lazy_glGetBooleanIndexedvEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetIntegerIndexedvEXT
#define GLEE_C_DEFINED_glGetIntegerIndexedvEXT
  void __stdcall GLee_Lazy_glGetIntegerIndexedvEXT(GLenum target, GLuint index, GLint * data)  {if (GLeeInit()) glGetIntegerIndexedvEXT(target, index, data);}
  GLEEPFNGLGETINTEGERINDEXEDVEXTPROC GLeeFuncPtr_glGetIntegerIndexedvEXT=GLee_Lazy_glGetIntegerIndexedvEXT;
#endif
#ifndef GLEE_C_DEFINED_glEnableIndexedEXT
#define GLEE_C_DEFINED_glEnableIndexedEXT
  void __stdcall GLee_Lazy_glEnableIndexedEXT(GLenum target, GLuint index)  {if (GLeeInit()) glEnableIndexedEXT(target, index);}
  GLEEPFNGLENABLEINDEXEDEXTPROC GLeeFuncPtr_glEnableIndexedEXT=GLee_Lazy_glEnableIndexedEXT;
#endif
#ifndef GLEE_C_DEFINED_glDisableIndexedEXT
#define GLEE_C_DEFINED_glDisableIndexedEXT
  void __stdcall GLee_Lazy_glDisableIndexedEXT(GLenum target, GLuint index)  {if (GLeeInit()) glDisableIndexedEXT(target, index);}
  GLEEPFNGLDISABLEINDEXEDEXTPROC GLeeFuncPtr_glDisableIndexedEXT=GLee_Lazy_glDisableIndexedEXT;
#endif
#ifndef GLEE_C_DEFINED_glIsEnabledIndexedEXT
#define GLEE_C_DEFINED_glIsEnabledIndexedEXT
  GLboolean __stdcall GLee_Lazy_glIsEnabledIndexedEXT(GLenum target, GLuint index)  {if (GLeeInit()) return glIsEnabledIndexedEXT(target, index); return (GLboolean)0;}
  GLEEPFNGLISENABLEDINDEXEDEXTPROC GLeeFuncPtr_glIsEnabledIndexedEXT=GLee_Lazy_glIsEnabledIndexedEXT;
#endif
#endif 

/* GL_NV_transform_feedback */

#ifdef __GLEE_GL_NV_transform_feedback
#ifndef GLEE_C_DEFINED_glBeginTransformFeedbackNV
#define GLEE_C_DEFINED_glBeginTransformFeedbackNV
  void __stdcall GLee_Lazy_glBeginTransformFeedbackNV(GLenum primitiveMode)  {if (GLeeInit()) glBeginTransformFeedbackNV(primitiveMode);}
  GLEEPFNGLBEGINTRANSFORMFEEDBACKNVPROC GLeeFuncPtr_glBeginTransformFeedbackNV=GLee_Lazy_glBeginTransformFeedbackNV;
#endif
#ifndef GLEE_C_DEFINED_glEndTransformFeedbackNV
#define GLEE_C_DEFINED_glEndTransformFeedbackNV
  void __stdcall GLee_Lazy_glEndTransformFeedbackNV(void)  {if (GLeeInit()) glEndTransformFeedbackNV();}
  GLEEPFNGLENDTRANSFORMFEEDBACKNVPROC GLeeFuncPtr_glEndTransformFeedbackNV=GLee_Lazy_glEndTransformFeedbackNV;
#endif
#ifndef GLEE_C_DEFINED_glTransformFeedbackAttribsNV
#define GLEE_C_DEFINED_glTransformFeedbackAttribsNV
  void __stdcall GLee_Lazy_glTransformFeedbackAttribsNV(GLuint count, const GLint * attribs, GLenum bufferMode)  {if (GLeeInit()) glTransformFeedbackAttribsNV(count, attribs, bufferMode);}
  GLEEPFNGLTRANSFORMFEEDBACKATTRIBSNVPROC GLeeFuncPtr_glTransformFeedbackAttribsNV=GLee_Lazy_glTransformFeedbackAttribsNV;
#endif
#ifndef GLEE_C_DEFINED_glBindBufferRangeNV
#define GLEE_C_DEFINED_glBindBufferRangeNV
  void __stdcall GLee_Lazy_glBindBufferRangeNV(GLenum target, GLuint index, GLuint buffer, GLintptr offset, GLsizeiptr size)  {if (GLeeInit()) glBindBufferRangeNV(target, index, buffer, offset, size);}
  GLEEPFNGLBINDBUFFERRANGENVPROC GLeeFuncPtr_glBindBufferRangeNV=GLee_Lazy_glBindBufferRangeNV;
#endif
#ifndef GLEE_C_DEFINED_glBindBufferOffsetNV
#define GLEE_C_DEFINED_glBindBufferOffsetNV
  void __stdcall GLee_Lazy_glBindBufferOffsetNV(GLenum target, GLuint index, GLuint buffer, GLintptr offset)  {if (GLeeInit()) glBindBufferOffsetNV(target, index, buffer, offset);}
  GLEEPFNGLBINDBUFFEROFFSETNVPROC GLeeFuncPtr_glBindBufferOffsetNV=GLee_Lazy_glBindBufferOffsetNV;
#endif
#ifndef GLEE_C_DEFINED_glBindBufferBaseNV
#define GLEE_C_DEFINED_glBindBufferBaseNV
  void __stdcall GLee_Lazy_glBindBufferBaseNV(GLenum target, GLuint index, GLuint buffer)  {if (GLeeInit()) glBindBufferBaseNV(target, index, buffer);}
  GLEEPFNGLBINDBUFFERBASENVPROC GLeeFuncPtr_glBindBufferBaseNV=GLee_Lazy_glBindBufferBaseNV;
#endif
#ifndef GLEE_C_DEFINED_glTransformFeedbackVaryingsNV
#define GLEE_C_DEFINED_glTransformFeedbackVaryingsNV
  void __stdcall GLee_Lazy_glTransformFeedbackVaryingsNV(GLuint program, GLsizei count, const GLint * locations, GLenum bufferMode)  {if (GLeeInit()) glTransformFeedbackVaryingsNV(program, count, locations, bufferMode);}
  GLEEPFNGLTRANSFORMFEEDBACKVARYINGSNVPROC GLeeFuncPtr_glTransformFeedbackVaryingsNV=GLee_Lazy_glTransformFeedbackVaryingsNV;
#endif
#ifndef GLEE_C_DEFINED_glActiveVaryingNV
#define GLEE_C_DEFINED_glActiveVaryingNV
  void __stdcall GLee_Lazy_glActiveVaryingNV(GLuint program, const GLchar * name)  {if (GLeeInit()) glActiveVaryingNV(program, name);}
  GLEEPFNGLACTIVEVARYINGNVPROC GLeeFuncPtr_glActiveVaryingNV=GLee_Lazy_glActiveVaryingNV;
#endif
#ifndef GLEE_C_DEFINED_glGetVaryingLocationNV
#define GLEE_C_DEFINED_glGetVaryingLocationNV
  GLint __stdcall GLee_Lazy_glGetVaryingLocationNV(GLuint program, const GLchar * name)  {if (GLeeInit()) return glGetVaryingLocationNV(program, name); return (GLint)0;}
  GLEEPFNGLGETVARYINGLOCATIONNVPROC GLeeFuncPtr_glGetVaryingLocationNV=GLee_Lazy_glGetVaryingLocationNV;
#endif
#ifndef GLEE_C_DEFINED_glGetActiveVaryingNV
#define GLEE_C_DEFINED_glGetActiveVaryingNV
  void __stdcall GLee_Lazy_glGetActiveVaryingNV(GLuint program, GLuint index, GLsizei bufSize, GLsizei * length, GLsizei * size, GLenum * type, GLchar * name)  {if (GLeeInit()) glGetActiveVaryingNV(program, index, bufSize, length, size, type, name);}
  GLEEPFNGLGETACTIVEVARYINGNVPROC GLeeFuncPtr_glGetActiveVaryingNV=GLee_Lazy_glGetActiveVaryingNV;
#endif
#ifndef GLEE_C_DEFINED_glGetTransformFeedbackVaryingNV
#define GLEE_C_DEFINED_glGetTransformFeedbackVaryingNV
  void __stdcall GLee_Lazy_glGetTransformFeedbackVaryingNV(GLuint program, GLuint index, GLint * location)  {if (GLeeInit()) glGetTransformFeedbackVaryingNV(program, index, location);}
  GLEEPFNGLGETTRANSFORMFEEDBACKVARYINGNVPROC GLeeFuncPtr_glGetTransformFeedbackVaryingNV=GLee_Lazy_glGetTransformFeedbackVaryingNV;
#endif
#endif 

/* GL_EXT_bindable_uniform */

#ifdef __GLEE_GL_EXT_bindable_uniform
#ifndef GLEE_C_DEFINED_glUniformBufferEXT
#define GLEE_C_DEFINED_glUniformBufferEXT
  void __stdcall GLee_Lazy_glUniformBufferEXT(GLuint program, GLint location, GLuint buffer)  {if (GLeeInit()) glUniformBufferEXT(program, location, buffer);}
  GLEEPFNGLUNIFORMBUFFEREXTPROC GLeeFuncPtr_glUniformBufferEXT=GLee_Lazy_glUniformBufferEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetUniformBufferSizeEXT
#define GLEE_C_DEFINED_glGetUniformBufferSizeEXT
  GLint __stdcall GLee_Lazy_glGetUniformBufferSizeEXT(GLuint program, GLint location)  {if (GLeeInit()) return glGetUniformBufferSizeEXT(program, location); return (GLint)0;}
  GLEEPFNGLGETUNIFORMBUFFERSIZEEXTPROC GLeeFuncPtr_glGetUniformBufferSizeEXT=GLee_Lazy_glGetUniformBufferSizeEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetUniformOffsetEXT
#define GLEE_C_DEFINED_glGetUniformOffsetEXT
  GLintptr __stdcall GLee_Lazy_glGetUniformOffsetEXT(GLuint program, GLint location)  {if (GLeeInit()) return glGetUniformOffsetEXT(program, location); return (GLintptr)0;}
  GLEEPFNGLGETUNIFORMOFFSETEXTPROC GLeeFuncPtr_glGetUniformOffsetEXT=GLee_Lazy_glGetUniformOffsetEXT;
#endif
#endif 

/* GL_EXT_texture_integer */

#ifdef __GLEE_GL_EXT_texture_integer
#ifndef GLEE_C_DEFINED_glTexParameterIivEXT
#define GLEE_C_DEFINED_glTexParameterIivEXT
  void __stdcall GLee_Lazy_glTexParameterIivEXT(GLenum target, GLenum pname, const GLint * params)  {if (GLeeInit()) glTexParameterIivEXT(target, pname, params);}
  GLEEPFNGLTEXPARAMETERIIVEXTPROC GLeeFuncPtr_glTexParameterIivEXT=GLee_Lazy_glTexParameterIivEXT;
#endif
#ifndef GLEE_C_DEFINED_glTexParameterIuivEXT
#define GLEE_C_DEFINED_glTexParameterIuivEXT
  void __stdcall GLee_Lazy_glTexParameterIuivEXT(GLenum target, GLenum pname, const GLuint * params)  {if (GLeeInit()) glTexParameterIuivEXT(target, pname, params);}
  GLEEPFNGLTEXPARAMETERIUIVEXTPROC GLeeFuncPtr_glTexParameterIuivEXT=GLee_Lazy_glTexParameterIuivEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetTexParameterIivEXT
#define GLEE_C_DEFINED_glGetTexParameterIivEXT
  void __stdcall GLee_Lazy_glGetTexParameterIivEXT(GLenum target, GLenum pname, GLint * params)  {if (GLeeInit()) glGetTexParameterIivEXT(target, pname, params);}
  GLEEPFNGLGETTEXPARAMETERIIVEXTPROC GLeeFuncPtr_glGetTexParameterIivEXT=GLee_Lazy_glGetTexParameterIivEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetTexParameterIuivEXT
#define GLEE_C_DEFINED_glGetTexParameterIuivEXT
  void __stdcall GLee_Lazy_glGetTexParameterIuivEXT(GLenum target, GLenum pname, GLuint * params)  {if (GLeeInit()) glGetTexParameterIuivEXT(target, pname, params);}
  GLEEPFNGLGETTEXPARAMETERIUIVEXTPROC GLeeFuncPtr_glGetTexParameterIuivEXT=GLee_Lazy_glGetTexParameterIuivEXT;
#endif
#ifndef GLEE_C_DEFINED_glClearColorIiEXT
#define GLEE_C_DEFINED_glClearColorIiEXT
  void __stdcall GLee_Lazy_glClearColorIiEXT(GLint red, GLint green, GLint blue, GLint alpha)  {if (GLeeInit()) glClearColorIiEXT(red, green, blue, alpha);}
  GLEEPFNGLCLEARCOLORIIEXTPROC GLeeFuncPtr_glClearColorIiEXT=GLee_Lazy_glClearColorIiEXT;
#endif
#ifndef GLEE_C_DEFINED_glClearColorIuiEXT
#define GLEE_C_DEFINED_glClearColorIuiEXT
  void __stdcall GLee_Lazy_glClearColorIuiEXT(GLuint red, GLuint green, GLuint blue, GLuint alpha)  {if (GLeeInit()) glClearColorIuiEXT(red, green, blue, alpha);}
  GLEEPFNGLCLEARCOLORIUIEXTPROC GLeeFuncPtr_glClearColorIuiEXT=GLee_Lazy_glClearColorIuiEXT;
#endif
#endif 

/* GL_GREMEDY_frame_terminator */

#ifdef __GLEE_GL_GREMEDY_frame_terminator
#ifndef GLEE_C_DEFINED_glFrameTerminatorGREMEDY
#define GLEE_C_DEFINED_glFrameTerminatorGREMEDY
  void __stdcall GLee_Lazy_glFrameTerminatorGREMEDY(void)  {if (GLeeInit()) glFrameTerminatorGREMEDY();}
  GLEEPFNGLFRAMETERMINATORGREMEDYPROC GLeeFuncPtr_glFrameTerminatorGREMEDY=GLee_Lazy_glFrameTerminatorGREMEDY;
#endif
#endif 

/* GL_NV_conditional_render */

#ifdef __GLEE_GL_NV_conditional_render
#ifndef GLEE_C_DEFINED_glBeginConditionalRenderNV
#define GLEE_C_DEFINED_glBeginConditionalRenderNV
  void __stdcall GLee_Lazy_glBeginConditionalRenderNV(GLuint id, GLenum mode)  {if (GLeeInit()) glBeginConditionalRenderNV(id, mode);}
  GLEEPFNGLBEGINCONDITIONALRENDERNVPROC GLeeFuncPtr_glBeginConditionalRenderNV=GLee_Lazy_glBeginConditionalRenderNV;
#endif
#ifndef GLEE_C_DEFINED_glEndConditionalRenderNV
#define GLEE_C_DEFINED_glEndConditionalRenderNV
  void __stdcall GLee_Lazy_glEndConditionalRenderNV(void)  {if (GLeeInit()) glEndConditionalRenderNV();}
  GLEEPFNGLENDCONDITIONALRENDERNVPROC GLeeFuncPtr_glEndConditionalRenderNV=GLee_Lazy_glEndConditionalRenderNV;
#endif
#endif 

/* GL_NV_present_video */

#ifdef __GLEE_GL_NV_present_video
#endif 

/* GL_EXT_transform_feedback */

#ifdef __GLEE_GL_EXT_transform_feedback
#ifndef GLEE_C_DEFINED_glBeginTransformFeedbackEXT
#define GLEE_C_DEFINED_glBeginTransformFeedbackEXT
  void __stdcall GLee_Lazy_glBeginTransformFeedbackEXT(GLenum primitiveMode)  {if (GLeeInit()) glBeginTransformFeedbackEXT(primitiveMode);}
  GLEEPFNGLBEGINTRANSFORMFEEDBACKEXTPROC GLeeFuncPtr_glBeginTransformFeedbackEXT=GLee_Lazy_glBeginTransformFeedbackEXT;
#endif
#ifndef GLEE_C_DEFINED_glEndTransformFeedbackEXT
#define GLEE_C_DEFINED_glEndTransformFeedbackEXT
  void __stdcall GLee_Lazy_glEndTransformFeedbackEXT(void)  {if (GLeeInit()) glEndTransformFeedbackEXT();}
  GLEEPFNGLENDTRANSFORMFEEDBACKEXTPROC GLeeFuncPtr_glEndTransformFeedbackEXT=GLee_Lazy_glEndTransformFeedbackEXT;
#endif
#ifndef GLEE_C_DEFINED_glBindBufferRangeEXT
#define GLEE_C_DEFINED_glBindBufferRangeEXT
  void __stdcall GLee_Lazy_glBindBufferRangeEXT(GLenum target, GLuint index, GLuint buffer, GLintptr offset, GLsizeiptr size)  {if (GLeeInit()) glBindBufferRangeEXT(target, index, buffer, offset, size);}
  GLEEPFNGLBINDBUFFERRANGEEXTPROC GLeeFuncPtr_glBindBufferRangeEXT=GLee_Lazy_glBindBufferRangeEXT;
#endif
#ifndef GLEE_C_DEFINED_glBindBufferOffsetEXT
#define GLEE_C_DEFINED_glBindBufferOffsetEXT
  void __stdcall GLee_Lazy_glBindBufferOffsetEXT(GLenum target, GLuint index, GLuint buffer, GLintptr offset)  {if (GLeeInit()) glBindBufferOffsetEXT(target, index, buffer, offset);}
  GLEEPFNGLBINDBUFFEROFFSETEXTPROC GLeeFuncPtr_glBindBufferOffsetEXT=GLee_Lazy_glBindBufferOffsetEXT;
#endif
#ifndef GLEE_C_DEFINED_glBindBufferBaseEXT
#define GLEE_C_DEFINED_glBindBufferBaseEXT
  void __stdcall GLee_Lazy_glBindBufferBaseEXT(GLenum target, GLuint index, GLuint buffer)  {if (GLeeInit()) glBindBufferBaseEXT(target, index, buffer);}
  GLEEPFNGLBINDBUFFERBASEEXTPROC GLeeFuncPtr_glBindBufferBaseEXT=GLee_Lazy_glBindBufferBaseEXT;
#endif
#ifndef GLEE_C_DEFINED_glTransformFeedbackVaryingsEXT
#define GLEE_C_DEFINED_glTransformFeedbackVaryingsEXT
  void __stdcall GLee_Lazy_glTransformFeedbackVaryingsEXT(GLuint program, GLsizei count, const GLint * locations, GLenum bufferMode)  {if (GLeeInit()) glTransformFeedbackVaryingsEXT(program, count, locations, bufferMode);}
  GLEEPFNGLTRANSFORMFEEDBACKVARYINGSEXTPROC GLeeFuncPtr_glTransformFeedbackVaryingsEXT=GLee_Lazy_glTransformFeedbackVaryingsEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetTransformFeedbackVaryingEXT
#define GLEE_C_DEFINED_glGetTransformFeedbackVaryingEXT
  void __stdcall GLee_Lazy_glGetTransformFeedbackVaryingEXT(GLuint program, GLuint index, GLint * location)  {if (GLeeInit()) glGetTransformFeedbackVaryingEXT(program, index, location);}
  GLEEPFNGLGETTRANSFORMFEEDBACKVARYINGEXTPROC GLeeFuncPtr_glGetTransformFeedbackVaryingEXT=GLee_Lazy_glGetTransformFeedbackVaryingEXT;
#endif
#endif 

/* GL_EXT_direct_state_access */

#ifdef __GLEE_GL_EXT_direct_state_access
#ifndef GLEE_C_DEFINED_glClientAttribDefaultEXT
#define GLEE_C_DEFINED_glClientAttribDefaultEXT
  void __stdcall GLee_Lazy_glClientAttribDefaultEXT(GLbitfield mask)  {if (GLeeInit()) glClientAttribDefaultEXT(mask);}
  GLEEPFNGLCLIENTATTRIBDEFAULTEXTPROC GLeeFuncPtr_glClientAttribDefaultEXT=GLee_Lazy_glClientAttribDefaultEXT;
#endif
#ifndef GLEE_C_DEFINED_glPushClientAttribDefaultEXT
#define GLEE_C_DEFINED_glPushClientAttribDefaultEXT
  void __stdcall GLee_Lazy_glPushClientAttribDefaultEXT(GLbitfield mask)  {if (GLeeInit()) glPushClientAttribDefaultEXT(mask);}
  GLEEPFNGLPUSHCLIENTATTRIBDEFAULTEXTPROC GLeeFuncPtr_glPushClientAttribDefaultEXT=GLee_Lazy_glPushClientAttribDefaultEXT;
#endif
#ifndef GLEE_C_DEFINED_glMatrixLoadfEXT
#define GLEE_C_DEFINED_glMatrixLoadfEXT
  void __stdcall GLee_Lazy_glMatrixLoadfEXT(GLenum mode, const GLfloat * m)  {if (GLeeInit()) glMatrixLoadfEXT(mode, m);}
  GLEEPFNGLMATRIXLOADFEXTPROC GLeeFuncPtr_glMatrixLoadfEXT=GLee_Lazy_glMatrixLoadfEXT;
#endif
#ifndef GLEE_C_DEFINED_glMatrixLoaddEXT
#define GLEE_C_DEFINED_glMatrixLoaddEXT
  void __stdcall GLee_Lazy_glMatrixLoaddEXT(GLenum mode, const GLdouble * m)  {if (GLeeInit()) glMatrixLoaddEXT(mode, m);}
  GLEEPFNGLMATRIXLOADDEXTPROC GLeeFuncPtr_glMatrixLoaddEXT=GLee_Lazy_glMatrixLoaddEXT;
#endif
#ifndef GLEE_C_DEFINED_glMatrixMultfEXT
#define GLEE_C_DEFINED_glMatrixMultfEXT
  void __stdcall GLee_Lazy_glMatrixMultfEXT(GLenum mode, const GLfloat * m)  {if (GLeeInit()) glMatrixMultfEXT(mode, m);}
  GLEEPFNGLMATRIXMULTFEXTPROC GLeeFuncPtr_glMatrixMultfEXT=GLee_Lazy_glMatrixMultfEXT;
#endif
#ifndef GLEE_C_DEFINED_glMatrixMultdEXT
#define GLEE_C_DEFINED_glMatrixMultdEXT
  void __stdcall GLee_Lazy_glMatrixMultdEXT(GLenum mode, const GLdouble * m)  {if (GLeeInit()) glMatrixMultdEXT(mode, m);}
  GLEEPFNGLMATRIXMULTDEXTPROC GLeeFuncPtr_glMatrixMultdEXT=GLee_Lazy_glMatrixMultdEXT;
#endif
#ifndef GLEE_C_DEFINED_glMatrixLoadIdentityEXT
#define GLEE_C_DEFINED_glMatrixLoadIdentityEXT
  void __stdcall GLee_Lazy_glMatrixLoadIdentityEXT(GLenum mode)  {if (GLeeInit()) glMatrixLoadIdentityEXT(mode);}
  GLEEPFNGLMATRIXLOADIDENTITYEXTPROC GLeeFuncPtr_glMatrixLoadIdentityEXT=GLee_Lazy_glMatrixLoadIdentityEXT;
#endif
#ifndef GLEE_C_DEFINED_glMatrixRotatefEXT
#define GLEE_C_DEFINED_glMatrixRotatefEXT
  void __stdcall GLee_Lazy_glMatrixRotatefEXT(GLenum mode, GLfloat angle, GLfloat x, GLfloat y, GLfloat z)  {if (GLeeInit()) glMatrixRotatefEXT(mode, angle, x, y, z);}
  GLEEPFNGLMATRIXROTATEFEXTPROC GLeeFuncPtr_glMatrixRotatefEXT=GLee_Lazy_glMatrixRotatefEXT;
#endif
#ifndef GLEE_C_DEFINED_glMatrixRotatedEXT
#define GLEE_C_DEFINED_glMatrixRotatedEXT
  void __stdcall GLee_Lazy_glMatrixRotatedEXT(GLenum mode, GLdouble angle, GLdouble x, GLdouble y, GLdouble z)  {if (GLeeInit()) glMatrixRotatedEXT(mode, angle, x, y, z);}
  GLEEPFNGLMATRIXROTATEDEXTPROC GLeeFuncPtr_glMatrixRotatedEXT=GLee_Lazy_glMatrixRotatedEXT;
#endif
#ifndef GLEE_C_DEFINED_glMatrixScalefEXT
#define GLEE_C_DEFINED_glMatrixScalefEXT
  void __stdcall GLee_Lazy_glMatrixScalefEXT(GLenum mode, GLfloat x, GLfloat y, GLfloat z)  {if (GLeeInit()) glMatrixScalefEXT(mode, x, y, z);}
  GLEEPFNGLMATRIXSCALEFEXTPROC GLeeFuncPtr_glMatrixScalefEXT=GLee_Lazy_glMatrixScalefEXT;
#endif
#ifndef GLEE_C_DEFINED_glMatrixScaledEXT
#define GLEE_C_DEFINED_glMatrixScaledEXT
  void __stdcall GLee_Lazy_glMatrixScaledEXT(GLenum mode, GLdouble x, GLdouble y, GLdouble z)  {if (GLeeInit()) glMatrixScaledEXT(mode, x, y, z);}
  GLEEPFNGLMATRIXSCALEDEXTPROC GLeeFuncPtr_glMatrixScaledEXT=GLee_Lazy_glMatrixScaledEXT;
#endif
#ifndef GLEE_C_DEFINED_glMatrixTranslatefEXT
#define GLEE_C_DEFINED_glMatrixTranslatefEXT
  void __stdcall GLee_Lazy_glMatrixTranslatefEXT(GLenum mode, GLfloat x, GLfloat y, GLfloat z)  {if (GLeeInit()) glMatrixTranslatefEXT(mode, x, y, z);}
  GLEEPFNGLMATRIXTRANSLATEFEXTPROC GLeeFuncPtr_glMatrixTranslatefEXT=GLee_Lazy_glMatrixTranslatefEXT;
#endif
#ifndef GLEE_C_DEFINED_glMatrixTranslatedEXT
#define GLEE_C_DEFINED_glMatrixTranslatedEXT
  void __stdcall GLee_Lazy_glMatrixTranslatedEXT(GLenum mode, GLdouble x, GLdouble y, GLdouble z)  {if (GLeeInit()) glMatrixTranslatedEXT(mode, x, y, z);}
  GLEEPFNGLMATRIXTRANSLATEDEXTPROC GLeeFuncPtr_glMatrixTranslatedEXT=GLee_Lazy_glMatrixTranslatedEXT;
#endif
#ifndef GLEE_C_DEFINED_glMatrixFrustumEXT
#define GLEE_C_DEFINED_glMatrixFrustumEXT
  void __stdcall GLee_Lazy_glMatrixFrustumEXT(GLenum mode, GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar)  {if (GLeeInit()) glMatrixFrustumEXT(mode, left, right, bottom, top, zNear, zFar);}
  GLEEPFNGLMATRIXFRUSTUMEXTPROC GLeeFuncPtr_glMatrixFrustumEXT=GLee_Lazy_glMatrixFrustumEXT;
#endif
#ifndef GLEE_C_DEFINED_glMatrixOrthoEXT
#define GLEE_C_DEFINED_glMatrixOrthoEXT
  void __stdcall GLee_Lazy_glMatrixOrthoEXT(GLenum mode, GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar)  {if (GLeeInit()) glMatrixOrthoEXT(mode, left, right, bottom, top, zNear, zFar);}
  GLEEPFNGLMATRIXORTHOEXTPROC GLeeFuncPtr_glMatrixOrthoEXT=GLee_Lazy_glMatrixOrthoEXT;
#endif
#ifndef GLEE_C_DEFINED_glMatrixPopEXT
#define GLEE_C_DEFINED_glMatrixPopEXT
  void __stdcall GLee_Lazy_glMatrixPopEXT(GLenum mode)  {if (GLeeInit()) glMatrixPopEXT(mode);}
  GLEEPFNGLMATRIXPOPEXTPROC GLeeFuncPtr_glMatrixPopEXT=GLee_Lazy_glMatrixPopEXT;
#endif
#ifndef GLEE_C_DEFINED_glMatrixPushEXT
#define GLEE_C_DEFINED_glMatrixPushEXT
  void __stdcall GLee_Lazy_glMatrixPushEXT(GLenum mode)  {if (GLeeInit()) glMatrixPushEXT(mode);}
  GLEEPFNGLMATRIXPUSHEXTPROC GLeeFuncPtr_glMatrixPushEXT=GLee_Lazy_glMatrixPushEXT;
#endif
#ifndef GLEE_C_DEFINED_glMatrixLoadTransposefEXT
#define GLEE_C_DEFINED_glMatrixLoadTransposefEXT
  void __stdcall GLee_Lazy_glMatrixLoadTransposefEXT(GLenum mode, const GLfloat * m)  {if (GLeeInit()) glMatrixLoadTransposefEXT(mode, m);}
  GLEEPFNGLMATRIXLOADTRANSPOSEFEXTPROC GLeeFuncPtr_glMatrixLoadTransposefEXT=GLee_Lazy_glMatrixLoadTransposefEXT;
#endif
#ifndef GLEE_C_DEFINED_glMatrixLoadTransposedEXT
#define GLEE_C_DEFINED_glMatrixLoadTransposedEXT
  void __stdcall GLee_Lazy_glMatrixLoadTransposedEXT(GLenum mode, const GLdouble * m)  {if (GLeeInit()) glMatrixLoadTransposedEXT(mode, m);}
  GLEEPFNGLMATRIXLOADTRANSPOSEDEXTPROC GLeeFuncPtr_glMatrixLoadTransposedEXT=GLee_Lazy_glMatrixLoadTransposedEXT;
#endif
#ifndef GLEE_C_DEFINED_glMatrixMultTransposefEXT
#define GLEE_C_DEFINED_glMatrixMultTransposefEXT
  void __stdcall GLee_Lazy_glMatrixMultTransposefEXT(GLenum mode, const GLfloat * m)  {if (GLeeInit()) glMatrixMultTransposefEXT(mode, m);}
  GLEEPFNGLMATRIXMULTTRANSPOSEFEXTPROC GLeeFuncPtr_glMatrixMultTransposefEXT=GLee_Lazy_glMatrixMultTransposefEXT;
#endif
#ifndef GLEE_C_DEFINED_glMatrixMultTransposedEXT
#define GLEE_C_DEFINED_glMatrixMultTransposedEXT
  void __stdcall GLee_Lazy_glMatrixMultTransposedEXT(GLenum mode, const GLdouble * m)  {if (GLeeInit()) glMatrixMultTransposedEXT(mode, m);}
  GLEEPFNGLMATRIXMULTTRANSPOSEDEXTPROC GLeeFuncPtr_glMatrixMultTransposedEXT=GLee_Lazy_glMatrixMultTransposedEXT;
#endif
#ifndef GLEE_C_DEFINED_glTextureParameterfEXT
#define GLEE_C_DEFINED_glTextureParameterfEXT
  void __stdcall GLee_Lazy_glTextureParameterfEXT(GLuint texture, GLenum target, GLenum pname, GLfloat param)  {if (GLeeInit()) glTextureParameterfEXT(texture, target, pname, param);}
  GLEEPFNGLTEXTUREPARAMETERFEXTPROC GLeeFuncPtr_glTextureParameterfEXT=GLee_Lazy_glTextureParameterfEXT;
#endif
#ifndef GLEE_C_DEFINED_glTextureParameterfvEXT
#define GLEE_C_DEFINED_glTextureParameterfvEXT
  void __stdcall GLee_Lazy_glTextureParameterfvEXT(GLuint texture, GLenum target, GLenum pname, const GLfloat * params)  {if (GLeeInit()) glTextureParameterfvEXT(texture, target, pname, params);}
  GLEEPFNGLTEXTUREPARAMETERFVEXTPROC GLeeFuncPtr_glTextureParameterfvEXT=GLee_Lazy_glTextureParameterfvEXT;
#endif
#ifndef GLEE_C_DEFINED_glTextureParameteriEXT
#define GLEE_C_DEFINED_glTextureParameteriEXT
  void __stdcall GLee_Lazy_glTextureParameteriEXT(GLuint texture, GLenum target, GLenum pname, GLint param)  {if (GLeeInit()) glTextureParameteriEXT(texture, target, pname, param);}
  GLEEPFNGLTEXTUREPARAMETERIEXTPROC GLeeFuncPtr_glTextureParameteriEXT=GLee_Lazy_glTextureParameteriEXT;
#endif
#ifndef GLEE_C_DEFINED_glTextureParameterivEXT
#define GLEE_C_DEFINED_glTextureParameterivEXT
  void __stdcall GLee_Lazy_glTextureParameterivEXT(GLuint texture, GLenum target, GLenum pname, const GLint * params)  {if (GLeeInit()) glTextureParameterivEXT(texture, target, pname, params);}
  GLEEPFNGLTEXTUREPARAMETERIVEXTPROC GLeeFuncPtr_glTextureParameterivEXT=GLee_Lazy_glTextureParameterivEXT;
#endif
#ifndef GLEE_C_DEFINED_glTextureImage1DEXT
#define GLEE_C_DEFINED_glTextureImage1DEXT
  void __stdcall GLee_Lazy_glTextureImage1DEXT(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid * pixels)  {if (GLeeInit()) glTextureImage1DEXT(texture, target, level, internalformat, width, border, format, type, pixels);}
  GLEEPFNGLTEXTUREIMAGE1DEXTPROC GLeeFuncPtr_glTextureImage1DEXT=GLee_Lazy_glTextureImage1DEXT;
#endif
#ifndef GLEE_C_DEFINED_glTextureImage2DEXT
#define GLEE_C_DEFINED_glTextureImage2DEXT
  void __stdcall GLee_Lazy_glTextureImage2DEXT(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid * pixels)  {if (GLeeInit()) glTextureImage2DEXT(texture, target, level, internalformat, width, height, border, format, type, pixels);}
  GLEEPFNGLTEXTUREIMAGE2DEXTPROC GLeeFuncPtr_glTextureImage2DEXT=GLee_Lazy_glTextureImage2DEXT;
#endif
#ifndef GLEE_C_DEFINED_glTextureSubImage1DEXT
#define GLEE_C_DEFINED_glTextureSubImage1DEXT
  void __stdcall GLee_Lazy_glTextureSubImage1DEXT(GLuint texture, GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid * pixels)  {if (GLeeInit()) glTextureSubImage1DEXT(texture, target, level, xoffset, width, format, type, pixels);}
  GLEEPFNGLTEXTURESUBIMAGE1DEXTPROC GLeeFuncPtr_glTextureSubImage1DEXT=GLee_Lazy_glTextureSubImage1DEXT;
#endif
#ifndef GLEE_C_DEFINED_glTextureSubImage2DEXT
#define GLEE_C_DEFINED_glTextureSubImage2DEXT
  void __stdcall GLee_Lazy_glTextureSubImage2DEXT(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid * pixels)  {if (GLeeInit()) glTextureSubImage2DEXT(texture, target, level, xoffset, yoffset, width, height, format, type, pixels);}
  GLEEPFNGLTEXTURESUBIMAGE2DEXTPROC GLeeFuncPtr_glTextureSubImage2DEXT=GLee_Lazy_glTextureSubImage2DEXT;
#endif
#ifndef GLEE_C_DEFINED_glCopyTextureImage1DEXT
#define GLEE_C_DEFINED_glCopyTextureImage1DEXT
  void __stdcall GLee_Lazy_glCopyTextureImage1DEXT(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border)  {if (GLeeInit()) glCopyTextureImage1DEXT(texture, target, level, internalformat, x, y, width, border);}
  GLEEPFNGLCOPYTEXTUREIMAGE1DEXTPROC GLeeFuncPtr_glCopyTextureImage1DEXT=GLee_Lazy_glCopyTextureImage1DEXT;
#endif
#ifndef GLEE_C_DEFINED_glCopyTextureImage2DEXT
#define GLEE_C_DEFINED_glCopyTextureImage2DEXT
  void __stdcall GLee_Lazy_glCopyTextureImage2DEXT(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border)  {if (GLeeInit()) glCopyTextureImage2DEXT(texture, target, level, internalformat, x, y, width, height, border);}
  GLEEPFNGLCOPYTEXTUREIMAGE2DEXTPROC GLeeFuncPtr_glCopyTextureImage2DEXT=GLee_Lazy_glCopyTextureImage2DEXT;
#endif
#ifndef GLEE_C_DEFINED_glCopyTextureSubImage1DEXT
#define GLEE_C_DEFINED_glCopyTextureSubImage1DEXT
  void __stdcall GLee_Lazy_glCopyTextureSubImage1DEXT(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width)  {if (GLeeInit()) glCopyTextureSubImage1DEXT(texture, target, level, xoffset, x, y, width);}
  GLEEPFNGLCOPYTEXTURESUBIMAGE1DEXTPROC GLeeFuncPtr_glCopyTextureSubImage1DEXT=GLee_Lazy_glCopyTextureSubImage1DEXT;
#endif
#ifndef GLEE_C_DEFINED_glCopyTextureSubImage2DEXT
#define GLEE_C_DEFINED_glCopyTextureSubImage2DEXT
  void __stdcall GLee_Lazy_glCopyTextureSubImage2DEXT(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height)  {if (GLeeInit()) glCopyTextureSubImage2DEXT(texture, target, level, xoffset, yoffset, x, y, width, height);}
  GLEEPFNGLCOPYTEXTURESUBIMAGE2DEXTPROC GLeeFuncPtr_glCopyTextureSubImage2DEXT=GLee_Lazy_glCopyTextureSubImage2DEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetTextureImageEXT
#define GLEE_C_DEFINED_glGetTextureImageEXT
  void __stdcall GLee_Lazy_glGetTextureImageEXT(GLuint texture, GLenum target, GLint level, GLenum format, GLenum type, GLvoid * pixels)  {if (GLeeInit()) glGetTextureImageEXT(texture, target, level, format, type, pixels);}
  GLEEPFNGLGETTEXTUREIMAGEEXTPROC GLeeFuncPtr_glGetTextureImageEXT=GLee_Lazy_glGetTextureImageEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetTextureParameterfvEXT
#define GLEE_C_DEFINED_glGetTextureParameterfvEXT
  void __stdcall GLee_Lazy_glGetTextureParameterfvEXT(GLuint texture, GLenum target, GLenum pname, GLfloat * params)  {if (GLeeInit()) glGetTextureParameterfvEXT(texture, target, pname, params);}
  GLEEPFNGLGETTEXTUREPARAMETERFVEXTPROC GLeeFuncPtr_glGetTextureParameterfvEXT=GLee_Lazy_glGetTextureParameterfvEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetTextureParameterivEXT
#define GLEE_C_DEFINED_glGetTextureParameterivEXT
  void __stdcall GLee_Lazy_glGetTextureParameterivEXT(GLuint texture, GLenum target, GLenum pname, GLint * params)  {if (GLeeInit()) glGetTextureParameterivEXT(texture, target, pname, params);}
  GLEEPFNGLGETTEXTUREPARAMETERIVEXTPROC GLeeFuncPtr_glGetTextureParameterivEXT=GLee_Lazy_glGetTextureParameterivEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetTextureLevelParameterfvEXT
#define GLEE_C_DEFINED_glGetTextureLevelParameterfvEXT
  void __stdcall GLee_Lazy_glGetTextureLevelParameterfvEXT(GLuint texture, GLenum target, GLint level, GLenum pname, GLfloat * params)  {if (GLeeInit()) glGetTextureLevelParameterfvEXT(texture, target, level, pname, params);}
  GLEEPFNGLGETTEXTURELEVELPARAMETERFVEXTPROC GLeeFuncPtr_glGetTextureLevelParameterfvEXT=GLee_Lazy_glGetTextureLevelParameterfvEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetTextureLevelParameterivEXT
#define GLEE_C_DEFINED_glGetTextureLevelParameterivEXT
  void __stdcall GLee_Lazy_glGetTextureLevelParameterivEXT(GLuint texture, GLenum target, GLint level, GLenum pname, GLint * params)  {if (GLeeInit()) glGetTextureLevelParameterivEXT(texture, target, level, pname, params);}
  GLEEPFNGLGETTEXTURELEVELPARAMETERIVEXTPROC GLeeFuncPtr_glGetTextureLevelParameterivEXT=GLee_Lazy_glGetTextureLevelParameterivEXT;
#endif
#ifndef GLEE_C_DEFINED_glTextureImage3DEXT
#define GLEE_C_DEFINED_glTextureImage3DEXT
  void __stdcall GLee_Lazy_glTextureImage3DEXT(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid * pixels)  {if (GLeeInit()) glTextureImage3DEXT(texture, target, level, internalformat, width, height, depth, border, format, type, pixels);}
  GLEEPFNGLTEXTUREIMAGE3DEXTPROC GLeeFuncPtr_glTextureImage3DEXT=GLee_Lazy_glTextureImage3DEXT;
#endif
#ifndef GLEE_C_DEFINED_glTextureSubImage3DEXT
#define GLEE_C_DEFINED_glTextureSubImage3DEXT
  void __stdcall GLee_Lazy_glTextureSubImage3DEXT(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid * pixels)  {if (GLeeInit()) glTextureSubImage3DEXT(texture, target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels);}
  GLEEPFNGLTEXTURESUBIMAGE3DEXTPROC GLeeFuncPtr_glTextureSubImage3DEXT=GLee_Lazy_glTextureSubImage3DEXT;
#endif
#ifndef GLEE_C_DEFINED_glCopyTextureSubImage3DEXT
#define GLEE_C_DEFINED_glCopyTextureSubImage3DEXT
  void __stdcall GLee_Lazy_glCopyTextureSubImage3DEXT(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height)  {if (GLeeInit()) glCopyTextureSubImage3DEXT(texture, target, level, xoffset, yoffset, zoffset, x, y, width, height);}
  GLEEPFNGLCOPYTEXTURESUBIMAGE3DEXTPROC GLeeFuncPtr_glCopyTextureSubImage3DEXT=GLee_Lazy_glCopyTextureSubImage3DEXT;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexParameterfEXT
#define GLEE_C_DEFINED_glMultiTexParameterfEXT
  void __stdcall GLee_Lazy_glMultiTexParameterfEXT(GLenum texunit, GLenum target, GLenum pname, GLfloat param)  {if (GLeeInit()) glMultiTexParameterfEXT(texunit, target, pname, param);}
  GLEEPFNGLMULTITEXPARAMETERFEXTPROC GLeeFuncPtr_glMultiTexParameterfEXT=GLee_Lazy_glMultiTexParameterfEXT;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexParameterfvEXT
#define GLEE_C_DEFINED_glMultiTexParameterfvEXT
  void __stdcall GLee_Lazy_glMultiTexParameterfvEXT(GLenum texunit, GLenum target, GLenum pname, const GLfloat * params)  {if (GLeeInit()) glMultiTexParameterfvEXT(texunit, target, pname, params);}
  GLEEPFNGLMULTITEXPARAMETERFVEXTPROC GLeeFuncPtr_glMultiTexParameterfvEXT=GLee_Lazy_glMultiTexParameterfvEXT;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexParameteriEXT
#define GLEE_C_DEFINED_glMultiTexParameteriEXT
  void __stdcall GLee_Lazy_glMultiTexParameteriEXT(GLenum texunit, GLenum target, GLenum pname, GLint param)  {if (GLeeInit()) glMultiTexParameteriEXT(texunit, target, pname, param);}
  GLEEPFNGLMULTITEXPARAMETERIEXTPROC GLeeFuncPtr_glMultiTexParameteriEXT=GLee_Lazy_glMultiTexParameteriEXT;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexParameterivEXT
#define GLEE_C_DEFINED_glMultiTexParameterivEXT
  void __stdcall GLee_Lazy_glMultiTexParameterivEXT(GLenum texunit, GLenum target, GLenum pname, const GLint * params)  {if (GLeeInit()) glMultiTexParameterivEXT(texunit, target, pname, params);}
  GLEEPFNGLMULTITEXPARAMETERIVEXTPROC GLeeFuncPtr_glMultiTexParameterivEXT=GLee_Lazy_glMultiTexParameterivEXT;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexImage1DEXT
#define GLEE_C_DEFINED_glMultiTexImage1DEXT
  void __stdcall GLee_Lazy_glMultiTexImage1DEXT(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid * pixels)  {if (GLeeInit()) glMultiTexImage1DEXT(texunit, target, level, internalformat, width, border, format, type, pixels);}
  GLEEPFNGLMULTITEXIMAGE1DEXTPROC GLeeFuncPtr_glMultiTexImage1DEXT=GLee_Lazy_glMultiTexImage1DEXT;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexImage2DEXT
#define GLEE_C_DEFINED_glMultiTexImage2DEXT
  void __stdcall GLee_Lazy_glMultiTexImage2DEXT(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid * pixels)  {if (GLeeInit()) glMultiTexImage2DEXT(texunit, target, level, internalformat, width, height, border, format, type, pixels);}
  GLEEPFNGLMULTITEXIMAGE2DEXTPROC GLeeFuncPtr_glMultiTexImage2DEXT=GLee_Lazy_glMultiTexImage2DEXT;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexSubImage1DEXT
#define GLEE_C_DEFINED_glMultiTexSubImage1DEXT
  void __stdcall GLee_Lazy_glMultiTexSubImage1DEXT(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid * pixels)  {if (GLeeInit()) glMultiTexSubImage1DEXT(texunit, target, level, xoffset, width, format, type, pixels);}
  GLEEPFNGLMULTITEXSUBIMAGE1DEXTPROC GLeeFuncPtr_glMultiTexSubImage1DEXT=GLee_Lazy_glMultiTexSubImage1DEXT;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexSubImage2DEXT
#define GLEE_C_DEFINED_glMultiTexSubImage2DEXT
  void __stdcall GLee_Lazy_glMultiTexSubImage2DEXT(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid * pixels)  {if (GLeeInit()) glMultiTexSubImage2DEXT(texunit, target, level, xoffset, yoffset, width, height, format, type, pixels);}
  GLEEPFNGLMULTITEXSUBIMAGE2DEXTPROC GLeeFuncPtr_glMultiTexSubImage2DEXT=GLee_Lazy_glMultiTexSubImage2DEXT;
#endif
#ifndef GLEE_C_DEFINED_glCopyMultiTexImage1DEXT
#define GLEE_C_DEFINED_glCopyMultiTexImage1DEXT
  void __stdcall GLee_Lazy_glCopyMultiTexImage1DEXT(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border)  {if (GLeeInit()) glCopyMultiTexImage1DEXT(texunit, target, level, internalformat, x, y, width, border);}
  GLEEPFNGLCOPYMULTITEXIMAGE1DEXTPROC GLeeFuncPtr_glCopyMultiTexImage1DEXT=GLee_Lazy_glCopyMultiTexImage1DEXT;
#endif
#ifndef GLEE_C_DEFINED_glCopyMultiTexImage2DEXT
#define GLEE_C_DEFINED_glCopyMultiTexImage2DEXT
  void __stdcall GLee_Lazy_glCopyMultiTexImage2DEXT(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border)  {if (GLeeInit()) glCopyMultiTexImage2DEXT(texunit, target, level, internalformat, x, y, width, height, border);}
  GLEEPFNGLCOPYMULTITEXIMAGE2DEXTPROC GLeeFuncPtr_glCopyMultiTexImage2DEXT=GLee_Lazy_glCopyMultiTexImage2DEXT;
#endif
#ifndef GLEE_C_DEFINED_glCopyMultiTexSubImage1DEXT
#define GLEE_C_DEFINED_glCopyMultiTexSubImage1DEXT
  void __stdcall GLee_Lazy_glCopyMultiTexSubImage1DEXT(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width)  {if (GLeeInit()) glCopyMultiTexSubImage1DEXT(texunit, target, level, xoffset, x, y, width);}
  GLEEPFNGLCOPYMULTITEXSUBIMAGE1DEXTPROC GLeeFuncPtr_glCopyMultiTexSubImage1DEXT=GLee_Lazy_glCopyMultiTexSubImage1DEXT;
#endif
#ifndef GLEE_C_DEFINED_glCopyMultiTexSubImage2DEXT
#define GLEE_C_DEFINED_glCopyMultiTexSubImage2DEXT
  void __stdcall GLee_Lazy_glCopyMultiTexSubImage2DEXT(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height)  {if (GLeeInit()) glCopyMultiTexSubImage2DEXT(texunit, target, level, xoffset, yoffset, x, y, width, height);}
  GLEEPFNGLCOPYMULTITEXSUBIMAGE2DEXTPROC GLeeFuncPtr_glCopyMultiTexSubImage2DEXT=GLee_Lazy_glCopyMultiTexSubImage2DEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetMultiTexImageEXT
#define GLEE_C_DEFINED_glGetMultiTexImageEXT
  void __stdcall GLee_Lazy_glGetMultiTexImageEXT(GLenum texunit, GLenum target, GLint level, GLenum format, GLenum type, GLvoid * pixels)  {if (GLeeInit()) glGetMultiTexImageEXT(texunit, target, level, format, type, pixels);}
  GLEEPFNGLGETMULTITEXIMAGEEXTPROC GLeeFuncPtr_glGetMultiTexImageEXT=GLee_Lazy_glGetMultiTexImageEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetMultiTexParameterfvEXT
#define GLEE_C_DEFINED_glGetMultiTexParameterfvEXT
  void __stdcall GLee_Lazy_glGetMultiTexParameterfvEXT(GLenum texunit, GLenum target, GLenum pname, GLfloat * params)  {if (GLeeInit()) glGetMultiTexParameterfvEXT(texunit, target, pname, params);}
  GLEEPFNGLGETMULTITEXPARAMETERFVEXTPROC GLeeFuncPtr_glGetMultiTexParameterfvEXT=GLee_Lazy_glGetMultiTexParameterfvEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetMultiTexParameterivEXT
#define GLEE_C_DEFINED_glGetMultiTexParameterivEXT
  void __stdcall GLee_Lazy_glGetMultiTexParameterivEXT(GLenum texunit, GLenum target, GLenum pname, GLint * params)  {if (GLeeInit()) glGetMultiTexParameterivEXT(texunit, target, pname, params);}
  GLEEPFNGLGETMULTITEXPARAMETERIVEXTPROC GLeeFuncPtr_glGetMultiTexParameterivEXT=GLee_Lazy_glGetMultiTexParameterivEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetMultiTexLevelParameterfvEXT
#define GLEE_C_DEFINED_glGetMultiTexLevelParameterfvEXT
  void __stdcall GLee_Lazy_glGetMultiTexLevelParameterfvEXT(GLenum texunit, GLenum target, GLint level, GLenum pname, GLfloat * params)  {if (GLeeInit()) glGetMultiTexLevelParameterfvEXT(texunit, target, level, pname, params);}
  GLEEPFNGLGETMULTITEXLEVELPARAMETERFVEXTPROC GLeeFuncPtr_glGetMultiTexLevelParameterfvEXT=GLee_Lazy_glGetMultiTexLevelParameterfvEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetMultiTexLevelParameterivEXT
#define GLEE_C_DEFINED_glGetMultiTexLevelParameterivEXT
  void __stdcall GLee_Lazy_glGetMultiTexLevelParameterivEXT(GLenum texunit, GLenum target, GLint level, GLenum pname, GLint * params)  {if (GLeeInit()) glGetMultiTexLevelParameterivEXT(texunit, target, level, pname, params);}
  GLEEPFNGLGETMULTITEXLEVELPARAMETERIVEXTPROC GLeeFuncPtr_glGetMultiTexLevelParameterivEXT=GLee_Lazy_glGetMultiTexLevelParameterivEXT;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexImage3DEXT
#define GLEE_C_DEFINED_glMultiTexImage3DEXT
  void __stdcall GLee_Lazy_glMultiTexImage3DEXT(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid * pixels)  {if (GLeeInit()) glMultiTexImage3DEXT(texunit, target, level, internalformat, width, height, depth, border, format, type, pixels);}
  GLEEPFNGLMULTITEXIMAGE3DEXTPROC GLeeFuncPtr_glMultiTexImage3DEXT=GLee_Lazy_glMultiTexImage3DEXT;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexSubImage3DEXT
#define GLEE_C_DEFINED_glMultiTexSubImage3DEXT
  void __stdcall GLee_Lazy_glMultiTexSubImage3DEXT(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid * pixels)  {if (GLeeInit()) glMultiTexSubImage3DEXT(texunit, target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels);}
  GLEEPFNGLMULTITEXSUBIMAGE3DEXTPROC GLeeFuncPtr_glMultiTexSubImage3DEXT=GLee_Lazy_glMultiTexSubImage3DEXT;
#endif
#ifndef GLEE_C_DEFINED_glCopyMultiTexSubImage3DEXT
#define GLEE_C_DEFINED_glCopyMultiTexSubImage3DEXT
  void __stdcall GLee_Lazy_glCopyMultiTexSubImage3DEXT(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height)  {if (GLeeInit()) glCopyMultiTexSubImage3DEXT(texunit, target, level, xoffset, yoffset, zoffset, x, y, width, height);}
  GLEEPFNGLCOPYMULTITEXSUBIMAGE3DEXTPROC GLeeFuncPtr_glCopyMultiTexSubImage3DEXT=GLee_Lazy_glCopyMultiTexSubImage3DEXT;
#endif
#ifndef GLEE_C_DEFINED_glBindMultiTextureEXT
#define GLEE_C_DEFINED_glBindMultiTextureEXT
  void __stdcall GLee_Lazy_glBindMultiTextureEXT(GLenum texunit, GLenum target, GLuint texture)  {if (GLeeInit()) glBindMultiTextureEXT(texunit, target, texture);}
  GLEEPFNGLBINDMULTITEXTUREEXTPROC GLeeFuncPtr_glBindMultiTextureEXT=GLee_Lazy_glBindMultiTextureEXT;
#endif
#ifndef GLEE_C_DEFINED_glEnableClientStateIndexedEXT
#define GLEE_C_DEFINED_glEnableClientStateIndexedEXT
  void __stdcall GLee_Lazy_glEnableClientStateIndexedEXT(GLenum array, GLuint index)  {if (GLeeInit()) glEnableClientStateIndexedEXT(array, index);}
  GLEEPFNGLENABLECLIENTSTATEINDEXEDEXTPROC GLeeFuncPtr_glEnableClientStateIndexedEXT=GLee_Lazy_glEnableClientStateIndexedEXT;
#endif
#ifndef GLEE_C_DEFINED_glDisableClientStateIndexedEXT
#define GLEE_C_DEFINED_glDisableClientStateIndexedEXT
  void __stdcall GLee_Lazy_glDisableClientStateIndexedEXT(GLenum array, GLuint index)  {if (GLeeInit()) glDisableClientStateIndexedEXT(array, index);}
  GLEEPFNGLDISABLECLIENTSTATEINDEXEDEXTPROC GLeeFuncPtr_glDisableClientStateIndexedEXT=GLee_Lazy_glDisableClientStateIndexedEXT;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexCoordPointerEXT
#define GLEE_C_DEFINED_glMultiTexCoordPointerEXT
  void __stdcall GLee_Lazy_glMultiTexCoordPointerEXT(GLenum texunit, GLint size, GLenum type, GLsizei stride, const GLvoid * pointer)  {if (GLeeInit()) glMultiTexCoordPointerEXT(texunit, size, type, stride, pointer);}
  GLEEPFNGLMULTITEXCOORDPOINTEREXTPROC GLeeFuncPtr_glMultiTexCoordPointerEXT=GLee_Lazy_glMultiTexCoordPointerEXT;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexEnvfEXT
#define GLEE_C_DEFINED_glMultiTexEnvfEXT
  void __stdcall GLee_Lazy_glMultiTexEnvfEXT(GLenum texunit, GLenum target, GLenum pname, GLfloat param)  {if (GLeeInit()) glMultiTexEnvfEXT(texunit, target, pname, param);}
  GLEEPFNGLMULTITEXENVFEXTPROC GLeeFuncPtr_glMultiTexEnvfEXT=GLee_Lazy_glMultiTexEnvfEXT;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexEnvfvEXT
#define GLEE_C_DEFINED_glMultiTexEnvfvEXT
  void __stdcall GLee_Lazy_glMultiTexEnvfvEXT(GLenum texunit, GLenum target, GLenum pname, const GLfloat * params)  {if (GLeeInit()) glMultiTexEnvfvEXT(texunit, target, pname, params);}
  GLEEPFNGLMULTITEXENVFVEXTPROC GLeeFuncPtr_glMultiTexEnvfvEXT=GLee_Lazy_glMultiTexEnvfvEXT;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexEnviEXT
#define GLEE_C_DEFINED_glMultiTexEnviEXT
  void __stdcall GLee_Lazy_glMultiTexEnviEXT(GLenum texunit, GLenum target, GLenum pname, GLint param)  {if (GLeeInit()) glMultiTexEnviEXT(texunit, target, pname, param);}
  GLEEPFNGLMULTITEXENVIEXTPROC GLeeFuncPtr_glMultiTexEnviEXT=GLee_Lazy_glMultiTexEnviEXT;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexEnvivEXT
#define GLEE_C_DEFINED_glMultiTexEnvivEXT
  void __stdcall GLee_Lazy_glMultiTexEnvivEXT(GLenum texunit, GLenum target, GLenum pname, const GLint * params)  {if (GLeeInit()) glMultiTexEnvivEXT(texunit, target, pname, params);}
  GLEEPFNGLMULTITEXENVIVEXTPROC GLeeFuncPtr_glMultiTexEnvivEXT=GLee_Lazy_glMultiTexEnvivEXT;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexGendEXT
#define GLEE_C_DEFINED_glMultiTexGendEXT
  void __stdcall GLee_Lazy_glMultiTexGendEXT(GLenum texunit, GLenum coord, GLenum pname, GLdouble param)  {if (GLeeInit()) glMultiTexGendEXT(texunit, coord, pname, param);}
  GLEEPFNGLMULTITEXGENDEXTPROC GLeeFuncPtr_glMultiTexGendEXT=GLee_Lazy_glMultiTexGendEXT;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexGendvEXT
#define GLEE_C_DEFINED_glMultiTexGendvEXT
  void __stdcall GLee_Lazy_glMultiTexGendvEXT(GLenum texunit, GLenum coord, GLenum pname, const GLdouble * params)  {if (GLeeInit()) glMultiTexGendvEXT(texunit, coord, pname, params);}
  GLEEPFNGLMULTITEXGENDVEXTPROC GLeeFuncPtr_glMultiTexGendvEXT=GLee_Lazy_glMultiTexGendvEXT;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexGenfEXT
#define GLEE_C_DEFINED_glMultiTexGenfEXT
  void __stdcall GLee_Lazy_glMultiTexGenfEXT(GLenum texunit, GLenum coord, GLenum pname, GLfloat param)  {if (GLeeInit()) glMultiTexGenfEXT(texunit, coord, pname, param);}
  GLEEPFNGLMULTITEXGENFEXTPROC GLeeFuncPtr_glMultiTexGenfEXT=GLee_Lazy_glMultiTexGenfEXT;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexGenfvEXT
#define GLEE_C_DEFINED_glMultiTexGenfvEXT
  void __stdcall GLee_Lazy_glMultiTexGenfvEXT(GLenum texunit, GLenum coord, GLenum pname, const GLfloat * params)  {if (GLeeInit()) glMultiTexGenfvEXT(texunit, coord, pname, params);}
  GLEEPFNGLMULTITEXGENFVEXTPROC GLeeFuncPtr_glMultiTexGenfvEXT=GLee_Lazy_glMultiTexGenfvEXT;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexGeniEXT
#define GLEE_C_DEFINED_glMultiTexGeniEXT
  void __stdcall GLee_Lazy_glMultiTexGeniEXT(GLenum texunit, GLenum coord, GLenum pname, GLint param)  {if (GLeeInit()) glMultiTexGeniEXT(texunit, coord, pname, param);}
  GLEEPFNGLMULTITEXGENIEXTPROC GLeeFuncPtr_glMultiTexGeniEXT=GLee_Lazy_glMultiTexGeniEXT;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexGenivEXT
#define GLEE_C_DEFINED_glMultiTexGenivEXT
  void __stdcall GLee_Lazy_glMultiTexGenivEXT(GLenum texunit, GLenum coord, GLenum pname, const GLint * params)  {if (GLeeInit()) glMultiTexGenivEXT(texunit, coord, pname, params);}
  GLEEPFNGLMULTITEXGENIVEXTPROC GLeeFuncPtr_glMultiTexGenivEXT=GLee_Lazy_glMultiTexGenivEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetMultiTexEnvfvEXT
#define GLEE_C_DEFINED_glGetMultiTexEnvfvEXT
  void __stdcall GLee_Lazy_glGetMultiTexEnvfvEXT(GLenum texunit, GLenum target, GLenum pname, GLfloat * params)  {if (GLeeInit()) glGetMultiTexEnvfvEXT(texunit, target, pname, params);}
  GLEEPFNGLGETMULTITEXENVFVEXTPROC GLeeFuncPtr_glGetMultiTexEnvfvEXT=GLee_Lazy_glGetMultiTexEnvfvEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetMultiTexEnvivEXT
#define GLEE_C_DEFINED_glGetMultiTexEnvivEXT
  void __stdcall GLee_Lazy_glGetMultiTexEnvivEXT(GLenum texunit, GLenum target, GLenum pname, GLint * params)  {if (GLeeInit()) glGetMultiTexEnvivEXT(texunit, target, pname, params);}
  GLEEPFNGLGETMULTITEXENVIVEXTPROC GLeeFuncPtr_glGetMultiTexEnvivEXT=GLee_Lazy_glGetMultiTexEnvivEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetMultiTexGendvEXT
#define GLEE_C_DEFINED_glGetMultiTexGendvEXT
  void __stdcall GLee_Lazy_glGetMultiTexGendvEXT(GLenum texunit, GLenum coord, GLenum pname, GLdouble * params)  {if (GLeeInit()) glGetMultiTexGendvEXT(texunit, coord, pname, params);}
  GLEEPFNGLGETMULTITEXGENDVEXTPROC GLeeFuncPtr_glGetMultiTexGendvEXT=GLee_Lazy_glGetMultiTexGendvEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetMultiTexGenfvEXT
#define GLEE_C_DEFINED_glGetMultiTexGenfvEXT
  void __stdcall GLee_Lazy_glGetMultiTexGenfvEXT(GLenum texunit, GLenum coord, GLenum pname, GLfloat * params)  {if (GLeeInit()) glGetMultiTexGenfvEXT(texunit, coord, pname, params);}
  GLEEPFNGLGETMULTITEXGENFVEXTPROC GLeeFuncPtr_glGetMultiTexGenfvEXT=GLee_Lazy_glGetMultiTexGenfvEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetMultiTexGenivEXT
#define GLEE_C_DEFINED_glGetMultiTexGenivEXT
  void __stdcall GLee_Lazy_glGetMultiTexGenivEXT(GLenum texunit, GLenum coord, GLenum pname, GLint * params)  {if (GLeeInit()) glGetMultiTexGenivEXT(texunit, coord, pname, params);}
  GLEEPFNGLGETMULTITEXGENIVEXTPROC GLeeFuncPtr_glGetMultiTexGenivEXT=GLee_Lazy_glGetMultiTexGenivEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetFloatIndexedvEXT
#define GLEE_C_DEFINED_glGetFloatIndexedvEXT
  void __stdcall GLee_Lazy_glGetFloatIndexedvEXT(GLenum target, GLuint index, GLfloat * data)  {if (GLeeInit()) glGetFloatIndexedvEXT(target, index, data);}
  GLEEPFNGLGETFLOATINDEXEDVEXTPROC GLeeFuncPtr_glGetFloatIndexedvEXT=GLee_Lazy_glGetFloatIndexedvEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetDoubleIndexedvEXT
#define GLEE_C_DEFINED_glGetDoubleIndexedvEXT
  void __stdcall GLee_Lazy_glGetDoubleIndexedvEXT(GLenum target, GLuint index, GLdouble * data)  {if (GLeeInit()) glGetDoubleIndexedvEXT(target, index, data);}
  GLEEPFNGLGETDOUBLEINDEXEDVEXTPROC GLeeFuncPtr_glGetDoubleIndexedvEXT=GLee_Lazy_glGetDoubleIndexedvEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetPointerIndexedvEXT
#define GLEE_C_DEFINED_glGetPointerIndexedvEXT
  void __stdcall GLee_Lazy_glGetPointerIndexedvEXT(GLenum target, GLuint index, GLvoid* * data)  {if (GLeeInit()) glGetPointerIndexedvEXT(target, index, data);}
  GLEEPFNGLGETPOINTERINDEXEDVEXTPROC GLeeFuncPtr_glGetPointerIndexedvEXT=GLee_Lazy_glGetPointerIndexedvEXT;
#endif
#ifndef GLEE_C_DEFINED_glCompressedTextureImage3DEXT
#define GLEE_C_DEFINED_glCompressedTextureImage3DEXT
  void __stdcall GLee_Lazy_glCompressedTextureImage3DEXT(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const GLvoid * bits)  {if (GLeeInit()) glCompressedTextureImage3DEXT(texture, target, level, internalformat, width, height, depth, border, imageSize, bits);}
  GLEEPFNGLCOMPRESSEDTEXTUREIMAGE3DEXTPROC GLeeFuncPtr_glCompressedTextureImage3DEXT=GLee_Lazy_glCompressedTextureImage3DEXT;
#endif
#ifndef GLEE_C_DEFINED_glCompressedTextureImage2DEXT
#define GLEE_C_DEFINED_glCompressedTextureImage2DEXT
  void __stdcall GLee_Lazy_glCompressedTextureImage2DEXT(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const GLvoid * bits)  {if (GLeeInit()) glCompressedTextureImage2DEXT(texture, target, level, internalformat, width, height, border, imageSize, bits);}
  GLEEPFNGLCOMPRESSEDTEXTUREIMAGE2DEXTPROC GLeeFuncPtr_glCompressedTextureImage2DEXT=GLee_Lazy_glCompressedTextureImage2DEXT;
#endif
#ifndef GLEE_C_DEFINED_glCompressedTextureImage1DEXT
#define GLEE_C_DEFINED_glCompressedTextureImage1DEXT
  void __stdcall GLee_Lazy_glCompressedTextureImage1DEXT(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const GLvoid * bits)  {if (GLeeInit()) glCompressedTextureImage1DEXT(texture, target, level, internalformat, width, border, imageSize, bits);}
  GLEEPFNGLCOMPRESSEDTEXTUREIMAGE1DEXTPROC GLeeFuncPtr_glCompressedTextureImage1DEXT=GLee_Lazy_glCompressedTextureImage1DEXT;
#endif
#ifndef GLEE_C_DEFINED_glCompressedTextureSubImage3DEXT
#define GLEE_C_DEFINED_glCompressedTextureSubImage3DEXT
  void __stdcall GLee_Lazy_glCompressedTextureSubImage3DEXT(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const GLvoid * bits)  {if (GLeeInit()) glCompressedTextureSubImage3DEXT(texture, target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, bits);}
  GLEEPFNGLCOMPRESSEDTEXTURESUBIMAGE3DEXTPROC GLeeFuncPtr_glCompressedTextureSubImage3DEXT=GLee_Lazy_glCompressedTextureSubImage3DEXT;
#endif
#ifndef GLEE_C_DEFINED_glCompressedTextureSubImage2DEXT
#define GLEE_C_DEFINED_glCompressedTextureSubImage2DEXT
  void __stdcall GLee_Lazy_glCompressedTextureSubImage2DEXT(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const GLvoid * bits)  {if (GLeeInit()) glCompressedTextureSubImage2DEXT(texture, target, level, xoffset, yoffset, width, height, format, imageSize, bits);}
  GLEEPFNGLCOMPRESSEDTEXTURESUBIMAGE2DEXTPROC GLeeFuncPtr_glCompressedTextureSubImage2DEXT=GLee_Lazy_glCompressedTextureSubImage2DEXT;
#endif
#ifndef GLEE_C_DEFINED_glCompressedTextureSubImage1DEXT
#define GLEE_C_DEFINED_glCompressedTextureSubImage1DEXT
  void __stdcall GLee_Lazy_glCompressedTextureSubImage1DEXT(GLuint texture, GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const GLvoid * bits)  {if (GLeeInit()) glCompressedTextureSubImage1DEXT(texture, target, level, xoffset, width, format, imageSize, bits);}
  GLEEPFNGLCOMPRESSEDTEXTURESUBIMAGE1DEXTPROC GLeeFuncPtr_glCompressedTextureSubImage1DEXT=GLee_Lazy_glCompressedTextureSubImage1DEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetCompressedTextureImageEXT
#define GLEE_C_DEFINED_glGetCompressedTextureImageEXT
  void __stdcall GLee_Lazy_glGetCompressedTextureImageEXT(GLuint texture, GLenum target, GLint lod, GLvoid * img)  {if (GLeeInit()) glGetCompressedTextureImageEXT(texture, target, lod, img);}
  GLEEPFNGLGETCOMPRESSEDTEXTUREIMAGEEXTPROC GLeeFuncPtr_glGetCompressedTextureImageEXT=GLee_Lazy_glGetCompressedTextureImageEXT;
#endif
#ifndef GLEE_C_DEFINED_glCompressedMultiTexImage3DEXT
#define GLEE_C_DEFINED_glCompressedMultiTexImage3DEXT
  void __stdcall GLee_Lazy_glCompressedMultiTexImage3DEXT(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const GLvoid * bits)  {if (GLeeInit()) glCompressedMultiTexImage3DEXT(texunit, target, level, internalformat, width, height, depth, border, imageSize, bits);}
  GLEEPFNGLCOMPRESSEDMULTITEXIMAGE3DEXTPROC GLeeFuncPtr_glCompressedMultiTexImage3DEXT=GLee_Lazy_glCompressedMultiTexImage3DEXT;
#endif
#ifndef GLEE_C_DEFINED_glCompressedMultiTexImage2DEXT
#define GLEE_C_DEFINED_glCompressedMultiTexImage2DEXT
  void __stdcall GLee_Lazy_glCompressedMultiTexImage2DEXT(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const GLvoid * bits)  {if (GLeeInit()) glCompressedMultiTexImage2DEXT(texunit, target, level, internalformat, width, height, border, imageSize, bits);}
  GLEEPFNGLCOMPRESSEDMULTITEXIMAGE2DEXTPROC GLeeFuncPtr_glCompressedMultiTexImage2DEXT=GLee_Lazy_glCompressedMultiTexImage2DEXT;
#endif
#ifndef GLEE_C_DEFINED_glCompressedMultiTexImage1DEXT
#define GLEE_C_DEFINED_glCompressedMultiTexImage1DEXT
  void __stdcall GLee_Lazy_glCompressedMultiTexImage1DEXT(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const GLvoid * bits)  {if (GLeeInit()) glCompressedMultiTexImage1DEXT(texunit, target, level, internalformat, width, border, imageSize, bits);}
  GLEEPFNGLCOMPRESSEDMULTITEXIMAGE1DEXTPROC GLeeFuncPtr_glCompressedMultiTexImage1DEXT=GLee_Lazy_glCompressedMultiTexImage1DEXT;
#endif
#ifndef GLEE_C_DEFINED_glCompressedMultiTexSubImage3DEXT
#define GLEE_C_DEFINED_glCompressedMultiTexSubImage3DEXT
  void __stdcall GLee_Lazy_glCompressedMultiTexSubImage3DEXT(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const GLvoid * bits)  {if (GLeeInit()) glCompressedMultiTexSubImage3DEXT(texunit, target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, bits);}
  GLEEPFNGLCOMPRESSEDMULTITEXSUBIMAGE3DEXTPROC GLeeFuncPtr_glCompressedMultiTexSubImage3DEXT=GLee_Lazy_glCompressedMultiTexSubImage3DEXT;
#endif
#ifndef GLEE_C_DEFINED_glCompressedMultiTexSubImage2DEXT
#define GLEE_C_DEFINED_glCompressedMultiTexSubImage2DEXT
  void __stdcall GLee_Lazy_glCompressedMultiTexSubImage2DEXT(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const GLvoid * bits)  {if (GLeeInit()) glCompressedMultiTexSubImage2DEXT(texunit, target, level, xoffset, yoffset, width, height, format, imageSize, bits);}
  GLEEPFNGLCOMPRESSEDMULTITEXSUBIMAGE2DEXTPROC GLeeFuncPtr_glCompressedMultiTexSubImage2DEXT=GLee_Lazy_glCompressedMultiTexSubImage2DEXT;
#endif
#ifndef GLEE_C_DEFINED_glCompressedMultiTexSubImage1DEXT
#define GLEE_C_DEFINED_glCompressedMultiTexSubImage1DEXT
  void __stdcall GLee_Lazy_glCompressedMultiTexSubImage1DEXT(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const GLvoid * bits)  {if (GLeeInit()) glCompressedMultiTexSubImage1DEXT(texunit, target, level, xoffset, width, format, imageSize, bits);}
  GLEEPFNGLCOMPRESSEDMULTITEXSUBIMAGE1DEXTPROC GLeeFuncPtr_glCompressedMultiTexSubImage1DEXT=GLee_Lazy_glCompressedMultiTexSubImage1DEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetCompressedMultiTexImageEXT
#define GLEE_C_DEFINED_glGetCompressedMultiTexImageEXT
  void __stdcall GLee_Lazy_glGetCompressedMultiTexImageEXT(GLenum texunit, GLenum target, GLint lod, GLvoid * img)  {if (GLeeInit()) glGetCompressedMultiTexImageEXT(texunit, target, lod, img);}
  GLEEPFNGLGETCOMPRESSEDMULTITEXIMAGEEXTPROC GLeeFuncPtr_glGetCompressedMultiTexImageEXT=GLee_Lazy_glGetCompressedMultiTexImageEXT;
#endif
#ifndef GLEE_C_DEFINED_glNamedProgramStringEXT
#define GLEE_C_DEFINED_glNamedProgramStringEXT
  void __stdcall GLee_Lazy_glNamedProgramStringEXT(GLuint program, GLenum target, GLenum format, GLsizei len, const GLvoid * string)  {if (GLeeInit()) glNamedProgramStringEXT(program, target, format, len, string);}
  GLEEPFNGLNAMEDPROGRAMSTRINGEXTPROC GLeeFuncPtr_glNamedProgramStringEXT=GLee_Lazy_glNamedProgramStringEXT;
#endif
#ifndef GLEE_C_DEFINED_glNamedProgramLocalParameter4dEXT
#define GLEE_C_DEFINED_glNamedProgramLocalParameter4dEXT
  void __stdcall GLee_Lazy_glNamedProgramLocalParameter4dEXT(GLuint program, GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w)  {if (GLeeInit()) glNamedProgramLocalParameter4dEXT(program, target, index, x, y, z, w);}
  GLEEPFNGLNAMEDPROGRAMLOCALPARAMETER4DEXTPROC GLeeFuncPtr_glNamedProgramLocalParameter4dEXT=GLee_Lazy_glNamedProgramLocalParameter4dEXT;
#endif
#ifndef GLEE_C_DEFINED_glNamedProgramLocalParameter4dvEXT
#define GLEE_C_DEFINED_glNamedProgramLocalParameter4dvEXT
  void __stdcall GLee_Lazy_glNamedProgramLocalParameter4dvEXT(GLuint program, GLenum target, GLuint index, const GLdouble * params)  {if (GLeeInit()) glNamedProgramLocalParameter4dvEXT(program, target, index, params);}
  GLEEPFNGLNAMEDPROGRAMLOCALPARAMETER4DVEXTPROC GLeeFuncPtr_glNamedProgramLocalParameter4dvEXT=GLee_Lazy_glNamedProgramLocalParameter4dvEXT;
#endif
#ifndef GLEE_C_DEFINED_glNamedProgramLocalParameter4fEXT
#define GLEE_C_DEFINED_glNamedProgramLocalParameter4fEXT
  void __stdcall GLee_Lazy_glNamedProgramLocalParameter4fEXT(GLuint program, GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w)  {if (GLeeInit()) glNamedProgramLocalParameter4fEXT(program, target, index, x, y, z, w);}
  GLEEPFNGLNAMEDPROGRAMLOCALPARAMETER4FEXTPROC GLeeFuncPtr_glNamedProgramLocalParameter4fEXT=GLee_Lazy_glNamedProgramLocalParameter4fEXT;
#endif
#ifndef GLEE_C_DEFINED_glNamedProgramLocalParameter4fvEXT
#define GLEE_C_DEFINED_glNamedProgramLocalParameter4fvEXT
  void __stdcall GLee_Lazy_glNamedProgramLocalParameter4fvEXT(GLuint program, GLenum target, GLuint index, const GLfloat * params)  {if (GLeeInit()) glNamedProgramLocalParameter4fvEXT(program, target, index, params);}
  GLEEPFNGLNAMEDPROGRAMLOCALPARAMETER4FVEXTPROC GLeeFuncPtr_glNamedProgramLocalParameter4fvEXT=GLee_Lazy_glNamedProgramLocalParameter4fvEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetNamedProgramLocalParameterdvEXT
#define GLEE_C_DEFINED_glGetNamedProgramLocalParameterdvEXT
  void __stdcall GLee_Lazy_glGetNamedProgramLocalParameterdvEXT(GLuint program, GLenum target, GLuint index, GLdouble * params)  {if (GLeeInit()) glGetNamedProgramLocalParameterdvEXT(program, target, index, params);}
  GLEEPFNGLGETNAMEDPROGRAMLOCALPARAMETERDVEXTPROC GLeeFuncPtr_glGetNamedProgramLocalParameterdvEXT=GLee_Lazy_glGetNamedProgramLocalParameterdvEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetNamedProgramLocalParameterfvEXT
#define GLEE_C_DEFINED_glGetNamedProgramLocalParameterfvEXT
  void __stdcall GLee_Lazy_glGetNamedProgramLocalParameterfvEXT(GLuint program, GLenum target, GLuint index, GLfloat * params)  {if (GLeeInit()) glGetNamedProgramLocalParameterfvEXT(program, target, index, params);}
  GLEEPFNGLGETNAMEDPROGRAMLOCALPARAMETERFVEXTPROC GLeeFuncPtr_glGetNamedProgramLocalParameterfvEXT=GLee_Lazy_glGetNamedProgramLocalParameterfvEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetNamedProgramivEXT
#define GLEE_C_DEFINED_glGetNamedProgramivEXT
  void __stdcall GLee_Lazy_glGetNamedProgramivEXT(GLuint program, GLenum target, GLenum pname, GLint * params)  {if (GLeeInit()) glGetNamedProgramivEXT(program, target, pname, params);}
  GLEEPFNGLGETNAMEDPROGRAMIVEXTPROC GLeeFuncPtr_glGetNamedProgramivEXT=GLee_Lazy_glGetNamedProgramivEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetNamedProgramStringEXT
#define GLEE_C_DEFINED_glGetNamedProgramStringEXT
  void __stdcall GLee_Lazy_glGetNamedProgramStringEXT(GLuint program, GLenum target, GLenum pname, GLvoid * string)  {if (GLeeInit()) glGetNamedProgramStringEXT(program, target, pname, string);}
  GLEEPFNGLGETNAMEDPROGRAMSTRINGEXTPROC GLeeFuncPtr_glGetNamedProgramStringEXT=GLee_Lazy_glGetNamedProgramStringEXT;
#endif
#ifndef GLEE_C_DEFINED_glNamedProgramLocalParameters4fvEXT
#define GLEE_C_DEFINED_glNamedProgramLocalParameters4fvEXT
  void __stdcall GLee_Lazy_glNamedProgramLocalParameters4fvEXT(GLuint program, GLenum target, GLuint index, GLsizei count, const GLfloat * params)  {if (GLeeInit()) glNamedProgramLocalParameters4fvEXT(program, target, index, count, params);}
  GLEEPFNGLNAMEDPROGRAMLOCALPARAMETERS4FVEXTPROC GLeeFuncPtr_glNamedProgramLocalParameters4fvEXT=GLee_Lazy_glNamedProgramLocalParameters4fvEXT;
#endif
#ifndef GLEE_C_DEFINED_glNamedProgramLocalParameterI4iEXT
#define GLEE_C_DEFINED_glNamedProgramLocalParameterI4iEXT
  void __stdcall GLee_Lazy_glNamedProgramLocalParameterI4iEXT(GLuint program, GLenum target, GLuint index, GLint x, GLint y, GLint z, GLint w)  {if (GLeeInit()) glNamedProgramLocalParameterI4iEXT(program, target, index, x, y, z, w);}
  GLEEPFNGLNAMEDPROGRAMLOCALPARAMETERI4IEXTPROC GLeeFuncPtr_glNamedProgramLocalParameterI4iEXT=GLee_Lazy_glNamedProgramLocalParameterI4iEXT;
#endif
#ifndef GLEE_C_DEFINED_glNamedProgramLocalParameterI4ivEXT
#define GLEE_C_DEFINED_glNamedProgramLocalParameterI4ivEXT
  void __stdcall GLee_Lazy_glNamedProgramLocalParameterI4ivEXT(GLuint program, GLenum target, GLuint index, const GLint * params)  {if (GLeeInit()) glNamedProgramLocalParameterI4ivEXT(program, target, index, params);}
  GLEEPFNGLNAMEDPROGRAMLOCALPARAMETERI4IVEXTPROC GLeeFuncPtr_glNamedProgramLocalParameterI4ivEXT=GLee_Lazy_glNamedProgramLocalParameterI4ivEXT;
#endif
#ifndef GLEE_C_DEFINED_glNamedProgramLocalParametersI4ivEXT
#define GLEE_C_DEFINED_glNamedProgramLocalParametersI4ivEXT
  void __stdcall GLee_Lazy_glNamedProgramLocalParametersI4ivEXT(GLuint program, GLenum target, GLuint index, GLsizei count, const GLint * params)  {if (GLeeInit()) glNamedProgramLocalParametersI4ivEXT(program, target, index, count, params);}
  GLEEPFNGLNAMEDPROGRAMLOCALPARAMETERSI4IVEXTPROC GLeeFuncPtr_glNamedProgramLocalParametersI4ivEXT=GLee_Lazy_glNamedProgramLocalParametersI4ivEXT;
#endif
#ifndef GLEE_C_DEFINED_glNamedProgramLocalParameterI4uiEXT
#define GLEE_C_DEFINED_glNamedProgramLocalParameterI4uiEXT
  void __stdcall GLee_Lazy_glNamedProgramLocalParameterI4uiEXT(GLuint program, GLenum target, GLuint index, GLuint x, GLuint y, GLuint z, GLuint w)  {if (GLeeInit()) glNamedProgramLocalParameterI4uiEXT(program, target, index, x, y, z, w);}
  GLEEPFNGLNAMEDPROGRAMLOCALPARAMETERI4UIEXTPROC GLeeFuncPtr_glNamedProgramLocalParameterI4uiEXT=GLee_Lazy_glNamedProgramLocalParameterI4uiEXT;
#endif
#ifndef GLEE_C_DEFINED_glNamedProgramLocalParameterI4uivEXT
#define GLEE_C_DEFINED_glNamedProgramLocalParameterI4uivEXT
  void __stdcall GLee_Lazy_glNamedProgramLocalParameterI4uivEXT(GLuint program, GLenum target, GLuint index, const GLuint * params)  {if (GLeeInit()) glNamedProgramLocalParameterI4uivEXT(program, target, index, params);}
  GLEEPFNGLNAMEDPROGRAMLOCALPARAMETERI4UIVEXTPROC GLeeFuncPtr_glNamedProgramLocalParameterI4uivEXT=GLee_Lazy_glNamedProgramLocalParameterI4uivEXT;
#endif
#ifndef GLEE_C_DEFINED_glNamedProgramLocalParametersI4uivEXT
#define GLEE_C_DEFINED_glNamedProgramLocalParametersI4uivEXT
  void __stdcall GLee_Lazy_glNamedProgramLocalParametersI4uivEXT(GLuint program, GLenum target, GLuint index, GLsizei count, const GLuint * params)  {if (GLeeInit()) glNamedProgramLocalParametersI4uivEXT(program, target, index, count, params);}
  GLEEPFNGLNAMEDPROGRAMLOCALPARAMETERSI4UIVEXTPROC GLeeFuncPtr_glNamedProgramLocalParametersI4uivEXT=GLee_Lazy_glNamedProgramLocalParametersI4uivEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetNamedProgramLocalParameterIivEXT
#define GLEE_C_DEFINED_glGetNamedProgramLocalParameterIivEXT
  void __stdcall GLee_Lazy_glGetNamedProgramLocalParameterIivEXT(GLuint program, GLenum target, GLuint index, GLint * params)  {if (GLeeInit()) glGetNamedProgramLocalParameterIivEXT(program, target, index, params);}
  GLEEPFNGLGETNAMEDPROGRAMLOCALPARAMETERIIVEXTPROC GLeeFuncPtr_glGetNamedProgramLocalParameterIivEXT=GLee_Lazy_glGetNamedProgramLocalParameterIivEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetNamedProgramLocalParameterIuivEXT
#define GLEE_C_DEFINED_glGetNamedProgramLocalParameterIuivEXT
  void __stdcall GLee_Lazy_glGetNamedProgramLocalParameterIuivEXT(GLuint program, GLenum target, GLuint index, GLuint * params)  {if (GLeeInit()) glGetNamedProgramLocalParameterIuivEXT(program, target, index, params);}
  GLEEPFNGLGETNAMEDPROGRAMLOCALPARAMETERIUIVEXTPROC GLeeFuncPtr_glGetNamedProgramLocalParameterIuivEXT=GLee_Lazy_glGetNamedProgramLocalParameterIuivEXT;
#endif
#ifndef GLEE_C_DEFINED_glTextureParameterIivEXT
#define GLEE_C_DEFINED_glTextureParameterIivEXT
  void __stdcall GLee_Lazy_glTextureParameterIivEXT(GLuint texture, GLenum target, GLenum pname, const GLint * params)  {if (GLeeInit()) glTextureParameterIivEXT(texture, target, pname, params);}
  GLEEPFNGLTEXTUREPARAMETERIIVEXTPROC GLeeFuncPtr_glTextureParameterIivEXT=GLee_Lazy_glTextureParameterIivEXT;
#endif
#ifndef GLEE_C_DEFINED_glTextureParameterIuivEXT
#define GLEE_C_DEFINED_glTextureParameterIuivEXT
  void __stdcall GLee_Lazy_glTextureParameterIuivEXT(GLuint texture, GLenum target, GLenum pname, const GLuint * params)  {if (GLeeInit()) glTextureParameterIuivEXT(texture, target, pname, params);}
  GLEEPFNGLTEXTUREPARAMETERIUIVEXTPROC GLeeFuncPtr_glTextureParameterIuivEXT=GLee_Lazy_glTextureParameterIuivEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetTextureParameterIivEXT
#define GLEE_C_DEFINED_glGetTextureParameterIivEXT
  void __stdcall GLee_Lazy_glGetTextureParameterIivEXT(GLuint texture, GLenum target, GLenum pname, GLint * params)  {if (GLeeInit()) glGetTextureParameterIivEXT(texture, target, pname, params);}
  GLEEPFNGLGETTEXTUREPARAMETERIIVEXTPROC GLeeFuncPtr_glGetTextureParameterIivEXT=GLee_Lazy_glGetTextureParameterIivEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetTextureParameterIuivEXT
#define GLEE_C_DEFINED_glGetTextureParameterIuivEXT
  void __stdcall GLee_Lazy_glGetTextureParameterIuivEXT(GLuint texture, GLenum target, GLenum pname, GLuint * params)  {if (GLeeInit()) glGetTextureParameterIuivEXT(texture, target, pname, params);}
  GLEEPFNGLGETTEXTUREPARAMETERIUIVEXTPROC GLeeFuncPtr_glGetTextureParameterIuivEXT=GLee_Lazy_glGetTextureParameterIuivEXT;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexParameterIivEXT
#define GLEE_C_DEFINED_glMultiTexParameterIivEXT
  void __stdcall GLee_Lazy_glMultiTexParameterIivEXT(GLenum texunit, GLenum target, GLenum pname, const GLint * params)  {if (GLeeInit()) glMultiTexParameterIivEXT(texunit, target, pname, params);}
  GLEEPFNGLMULTITEXPARAMETERIIVEXTPROC GLeeFuncPtr_glMultiTexParameterIivEXT=GLee_Lazy_glMultiTexParameterIivEXT;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexParameterIuivEXT
#define GLEE_C_DEFINED_glMultiTexParameterIuivEXT
  void __stdcall GLee_Lazy_glMultiTexParameterIuivEXT(GLenum texunit, GLenum target, GLenum pname, const GLuint * params)  {if (GLeeInit()) glMultiTexParameterIuivEXT(texunit, target, pname, params);}
  GLEEPFNGLMULTITEXPARAMETERIUIVEXTPROC GLeeFuncPtr_glMultiTexParameterIuivEXT=GLee_Lazy_glMultiTexParameterIuivEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetMultiTexParameterIivEXT
#define GLEE_C_DEFINED_glGetMultiTexParameterIivEXT
  void __stdcall GLee_Lazy_glGetMultiTexParameterIivEXT(GLenum texunit, GLenum target, GLenum pname, GLint * params)  {if (GLeeInit()) glGetMultiTexParameterIivEXT(texunit, target, pname, params);}
  GLEEPFNGLGETMULTITEXPARAMETERIIVEXTPROC GLeeFuncPtr_glGetMultiTexParameterIivEXT=GLee_Lazy_glGetMultiTexParameterIivEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetMultiTexParameterIuivEXT
#define GLEE_C_DEFINED_glGetMultiTexParameterIuivEXT
  void __stdcall GLee_Lazy_glGetMultiTexParameterIuivEXT(GLenum texunit, GLenum target, GLenum pname, GLuint * params)  {if (GLeeInit()) glGetMultiTexParameterIuivEXT(texunit, target, pname, params);}
  GLEEPFNGLGETMULTITEXPARAMETERIUIVEXTPROC GLeeFuncPtr_glGetMultiTexParameterIuivEXT=GLee_Lazy_glGetMultiTexParameterIuivEXT;
#endif
#ifndef GLEE_C_DEFINED_glProgramUniform1fEXT
#define GLEE_C_DEFINED_glProgramUniform1fEXT
  void __stdcall GLee_Lazy_glProgramUniform1fEXT(GLuint program, GLint location, GLfloat v0)  {if (GLeeInit()) glProgramUniform1fEXT(program, location, v0);}
  GLEEPFNGLPROGRAMUNIFORM1FEXTPROC GLeeFuncPtr_glProgramUniform1fEXT=GLee_Lazy_glProgramUniform1fEXT;
#endif
#ifndef GLEE_C_DEFINED_glProgramUniform2fEXT
#define GLEE_C_DEFINED_glProgramUniform2fEXT
  void __stdcall GLee_Lazy_glProgramUniform2fEXT(GLuint program, GLint location, GLfloat v0, GLfloat v1)  {if (GLeeInit()) glProgramUniform2fEXT(program, location, v0, v1);}
  GLEEPFNGLPROGRAMUNIFORM2FEXTPROC GLeeFuncPtr_glProgramUniform2fEXT=GLee_Lazy_glProgramUniform2fEXT;
#endif
#ifndef GLEE_C_DEFINED_glProgramUniform3fEXT
#define GLEE_C_DEFINED_glProgramUniform3fEXT
  void __stdcall GLee_Lazy_glProgramUniform3fEXT(GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2)  {if (GLeeInit()) glProgramUniform3fEXT(program, location, v0, v1, v2);}
  GLEEPFNGLPROGRAMUNIFORM3FEXTPROC GLeeFuncPtr_glProgramUniform3fEXT=GLee_Lazy_glProgramUniform3fEXT;
#endif
#ifndef GLEE_C_DEFINED_glProgramUniform4fEXT
#define GLEE_C_DEFINED_glProgramUniform4fEXT
  void __stdcall GLee_Lazy_glProgramUniform4fEXT(GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3)  {if (GLeeInit()) glProgramUniform4fEXT(program, location, v0, v1, v2, v3);}
  GLEEPFNGLPROGRAMUNIFORM4FEXTPROC GLeeFuncPtr_glProgramUniform4fEXT=GLee_Lazy_glProgramUniform4fEXT;
#endif
#ifndef GLEE_C_DEFINED_glProgramUniform1iEXT
#define GLEE_C_DEFINED_glProgramUniform1iEXT
  void __stdcall GLee_Lazy_glProgramUniform1iEXT(GLuint program, GLint location, GLint v0)  {if (GLeeInit()) glProgramUniform1iEXT(program, location, v0);}
  GLEEPFNGLPROGRAMUNIFORM1IEXTPROC GLeeFuncPtr_glProgramUniform1iEXT=GLee_Lazy_glProgramUniform1iEXT;
#endif
#ifndef GLEE_C_DEFINED_glProgramUniform2iEXT
#define GLEE_C_DEFINED_glProgramUniform2iEXT
  void __stdcall GLee_Lazy_glProgramUniform2iEXT(GLuint program, GLint location, GLint v0, GLint v1)  {if (GLeeInit()) glProgramUniform2iEXT(program, location, v0, v1);}
  GLEEPFNGLPROGRAMUNIFORM2IEXTPROC GLeeFuncPtr_glProgramUniform2iEXT=GLee_Lazy_glProgramUniform2iEXT;
#endif
#ifndef GLEE_C_DEFINED_glProgramUniform3iEXT
#define GLEE_C_DEFINED_glProgramUniform3iEXT
  void __stdcall GLee_Lazy_glProgramUniform3iEXT(GLuint program, GLint location, GLint v0, GLint v1, GLint v2)  {if (GLeeInit()) glProgramUniform3iEXT(program, location, v0, v1, v2);}
  GLEEPFNGLPROGRAMUNIFORM3IEXTPROC GLeeFuncPtr_glProgramUniform3iEXT=GLee_Lazy_glProgramUniform3iEXT;
#endif
#ifndef GLEE_C_DEFINED_glProgramUniform4iEXT
#define GLEE_C_DEFINED_glProgramUniform4iEXT
  void __stdcall GLee_Lazy_glProgramUniform4iEXT(GLuint program, GLint location, GLint v0, GLint v1, GLint v2, GLint v3)  {if (GLeeInit()) glProgramUniform4iEXT(program, location, v0, v1, v2, v3);}
  GLEEPFNGLPROGRAMUNIFORM4IEXTPROC GLeeFuncPtr_glProgramUniform4iEXT=GLee_Lazy_glProgramUniform4iEXT;
#endif
#ifndef GLEE_C_DEFINED_glProgramUniform1fvEXT
#define GLEE_C_DEFINED_glProgramUniform1fvEXT
  void __stdcall GLee_Lazy_glProgramUniform1fvEXT(GLuint program, GLint location, GLsizei count, const GLfloat * value)  {if (GLeeInit()) glProgramUniform1fvEXT(program, location, count, value);}
  GLEEPFNGLPROGRAMUNIFORM1FVEXTPROC GLeeFuncPtr_glProgramUniform1fvEXT=GLee_Lazy_glProgramUniform1fvEXT;
#endif
#ifndef GLEE_C_DEFINED_glProgramUniform2fvEXT
#define GLEE_C_DEFINED_glProgramUniform2fvEXT
  void __stdcall GLee_Lazy_glProgramUniform2fvEXT(GLuint program, GLint location, GLsizei count, const GLfloat * value)  {if (GLeeInit()) glProgramUniform2fvEXT(program, location, count, value);}
  GLEEPFNGLPROGRAMUNIFORM2FVEXTPROC GLeeFuncPtr_glProgramUniform2fvEXT=GLee_Lazy_glProgramUniform2fvEXT;
#endif
#ifndef GLEE_C_DEFINED_glProgramUniform3fvEXT
#define GLEE_C_DEFINED_glProgramUniform3fvEXT
  void __stdcall GLee_Lazy_glProgramUniform3fvEXT(GLuint program, GLint location, GLsizei count, const GLfloat * value)  {if (GLeeInit()) glProgramUniform3fvEXT(program, location, count, value);}
  GLEEPFNGLPROGRAMUNIFORM3FVEXTPROC GLeeFuncPtr_glProgramUniform3fvEXT=GLee_Lazy_glProgramUniform3fvEXT;
#endif
#ifndef GLEE_C_DEFINED_glProgramUniform4fvEXT
#define GLEE_C_DEFINED_glProgramUniform4fvEXT
  void __stdcall GLee_Lazy_glProgramUniform4fvEXT(GLuint program, GLint location, GLsizei count, const GLfloat * value)  {if (GLeeInit()) glProgramUniform4fvEXT(program, location, count, value);}
  GLEEPFNGLPROGRAMUNIFORM4FVEXTPROC GLeeFuncPtr_glProgramUniform4fvEXT=GLee_Lazy_glProgramUniform4fvEXT;
#endif
#ifndef GLEE_C_DEFINED_glProgramUniform1ivEXT
#define GLEE_C_DEFINED_glProgramUniform1ivEXT
  void __stdcall GLee_Lazy_glProgramUniform1ivEXT(GLuint program, GLint location, GLsizei count, const GLint * value)  {if (GLeeInit()) glProgramUniform1ivEXT(program, location, count, value);}
  GLEEPFNGLPROGRAMUNIFORM1IVEXTPROC GLeeFuncPtr_glProgramUniform1ivEXT=GLee_Lazy_glProgramUniform1ivEXT;
#endif
#ifndef GLEE_C_DEFINED_glProgramUniform2ivEXT
#define GLEE_C_DEFINED_glProgramUniform2ivEXT
  void __stdcall GLee_Lazy_glProgramUniform2ivEXT(GLuint program, GLint location, GLsizei count, const GLint * value)  {if (GLeeInit()) glProgramUniform2ivEXT(program, location, count, value);}
  GLEEPFNGLPROGRAMUNIFORM2IVEXTPROC GLeeFuncPtr_glProgramUniform2ivEXT=GLee_Lazy_glProgramUniform2ivEXT;
#endif
#ifndef GLEE_C_DEFINED_glProgramUniform3ivEXT
#define GLEE_C_DEFINED_glProgramUniform3ivEXT
  void __stdcall GLee_Lazy_glProgramUniform3ivEXT(GLuint program, GLint location, GLsizei count, const GLint * value)  {if (GLeeInit()) glProgramUniform3ivEXT(program, location, count, value);}
  GLEEPFNGLPROGRAMUNIFORM3IVEXTPROC GLeeFuncPtr_glProgramUniform3ivEXT=GLee_Lazy_glProgramUniform3ivEXT;
#endif
#ifndef GLEE_C_DEFINED_glProgramUniform4ivEXT
#define GLEE_C_DEFINED_glProgramUniform4ivEXT
  void __stdcall GLee_Lazy_glProgramUniform4ivEXT(GLuint program, GLint location, GLsizei count, const GLint * value)  {if (GLeeInit()) glProgramUniform4ivEXT(program, location, count, value);}
  GLEEPFNGLPROGRAMUNIFORM4IVEXTPROC GLeeFuncPtr_glProgramUniform4ivEXT=GLee_Lazy_glProgramUniform4ivEXT;
#endif
#ifndef GLEE_C_DEFINED_glProgramUniformMatrix2fvEXT
#define GLEE_C_DEFINED_glProgramUniformMatrix2fvEXT
  void __stdcall GLee_Lazy_glProgramUniformMatrix2fvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat * value)  {if (GLeeInit()) glProgramUniformMatrix2fvEXT(program, location, count, transpose, value);}
  GLEEPFNGLPROGRAMUNIFORMMATRIX2FVEXTPROC GLeeFuncPtr_glProgramUniformMatrix2fvEXT=GLee_Lazy_glProgramUniformMatrix2fvEXT;
#endif
#ifndef GLEE_C_DEFINED_glProgramUniformMatrix3fvEXT
#define GLEE_C_DEFINED_glProgramUniformMatrix3fvEXT
  void __stdcall GLee_Lazy_glProgramUniformMatrix3fvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat * value)  {if (GLeeInit()) glProgramUniformMatrix3fvEXT(program, location, count, transpose, value);}
  GLEEPFNGLPROGRAMUNIFORMMATRIX3FVEXTPROC GLeeFuncPtr_glProgramUniformMatrix3fvEXT=GLee_Lazy_glProgramUniformMatrix3fvEXT;
#endif
#ifndef GLEE_C_DEFINED_glProgramUniformMatrix4fvEXT
#define GLEE_C_DEFINED_glProgramUniformMatrix4fvEXT
  void __stdcall GLee_Lazy_glProgramUniformMatrix4fvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat * value)  {if (GLeeInit()) glProgramUniformMatrix4fvEXT(program, location, count, transpose, value);}
  GLEEPFNGLPROGRAMUNIFORMMATRIX4FVEXTPROC GLeeFuncPtr_glProgramUniformMatrix4fvEXT=GLee_Lazy_glProgramUniformMatrix4fvEXT;
#endif
#ifndef GLEE_C_DEFINED_glProgramUniformMatrix2x3fvEXT
#define GLEE_C_DEFINED_glProgramUniformMatrix2x3fvEXT
  void __stdcall GLee_Lazy_glProgramUniformMatrix2x3fvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat * value)  {if (GLeeInit()) glProgramUniformMatrix2x3fvEXT(program, location, count, transpose, value);}
  GLEEPFNGLPROGRAMUNIFORMMATRIX2X3FVEXTPROC GLeeFuncPtr_glProgramUniformMatrix2x3fvEXT=GLee_Lazy_glProgramUniformMatrix2x3fvEXT;
#endif
#ifndef GLEE_C_DEFINED_glProgramUniformMatrix3x2fvEXT
#define GLEE_C_DEFINED_glProgramUniformMatrix3x2fvEXT
  void __stdcall GLee_Lazy_glProgramUniformMatrix3x2fvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat * value)  {if (GLeeInit()) glProgramUniformMatrix3x2fvEXT(program, location, count, transpose, value);}
  GLEEPFNGLPROGRAMUNIFORMMATRIX3X2FVEXTPROC GLeeFuncPtr_glProgramUniformMatrix3x2fvEXT=GLee_Lazy_glProgramUniformMatrix3x2fvEXT;
#endif
#ifndef GLEE_C_DEFINED_glProgramUniformMatrix2x4fvEXT
#define GLEE_C_DEFINED_glProgramUniformMatrix2x4fvEXT
  void __stdcall GLee_Lazy_glProgramUniformMatrix2x4fvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat * value)  {if (GLeeInit()) glProgramUniformMatrix2x4fvEXT(program, location, count, transpose, value);}
  GLEEPFNGLPROGRAMUNIFORMMATRIX2X4FVEXTPROC GLeeFuncPtr_glProgramUniformMatrix2x4fvEXT=GLee_Lazy_glProgramUniformMatrix2x4fvEXT;
#endif
#ifndef GLEE_C_DEFINED_glProgramUniformMatrix4x2fvEXT
#define GLEE_C_DEFINED_glProgramUniformMatrix4x2fvEXT
  void __stdcall GLee_Lazy_glProgramUniformMatrix4x2fvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat * value)  {if (GLeeInit()) glProgramUniformMatrix4x2fvEXT(program, location, count, transpose, value);}
  GLEEPFNGLPROGRAMUNIFORMMATRIX4X2FVEXTPROC GLeeFuncPtr_glProgramUniformMatrix4x2fvEXT=GLee_Lazy_glProgramUniformMatrix4x2fvEXT;
#endif
#ifndef GLEE_C_DEFINED_glProgramUniformMatrix3x4fvEXT
#define GLEE_C_DEFINED_glProgramUniformMatrix3x4fvEXT
  void __stdcall GLee_Lazy_glProgramUniformMatrix3x4fvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat * value)  {if (GLeeInit()) glProgramUniformMatrix3x4fvEXT(program, location, count, transpose, value);}
  GLEEPFNGLPROGRAMUNIFORMMATRIX3X4FVEXTPROC GLeeFuncPtr_glProgramUniformMatrix3x4fvEXT=GLee_Lazy_glProgramUniformMatrix3x4fvEXT;
#endif
#ifndef GLEE_C_DEFINED_glProgramUniformMatrix4x3fvEXT
#define GLEE_C_DEFINED_glProgramUniformMatrix4x3fvEXT
  void __stdcall GLee_Lazy_glProgramUniformMatrix4x3fvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat * value)  {if (GLeeInit()) glProgramUniformMatrix4x3fvEXT(program, location, count, transpose, value);}
  GLEEPFNGLPROGRAMUNIFORMMATRIX4X3FVEXTPROC GLeeFuncPtr_glProgramUniformMatrix4x3fvEXT=GLee_Lazy_glProgramUniformMatrix4x3fvEXT;
#endif
#ifndef GLEE_C_DEFINED_glProgramUniform1uiEXT
#define GLEE_C_DEFINED_glProgramUniform1uiEXT
  void __stdcall GLee_Lazy_glProgramUniform1uiEXT(GLuint program, GLint location, GLuint v0)  {if (GLeeInit()) glProgramUniform1uiEXT(program, location, v0);}
  GLEEPFNGLPROGRAMUNIFORM1UIEXTPROC GLeeFuncPtr_glProgramUniform1uiEXT=GLee_Lazy_glProgramUniform1uiEXT;
#endif
#ifndef GLEE_C_DEFINED_glProgramUniform2uiEXT
#define GLEE_C_DEFINED_glProgramUniform2uiEXT
  void __stdcall GLee_Lazy_glProgramUniform2uiEXT(GLuint program, GLint location, GLuint v0, GLuint v1)  {if (GLeeInit()) glProgramUniform2uiEXT(program, location, v0, v1);}
  GLEEPFNGLPROGRAMUNIFORM2UIEXTPROC GLeeFuncPtr_glProgramUniform2uiEXT=GLee_Lazy_glProgramUniform2uiEXT;
#endif
#ifndef GLEE_C_DEFINED_glProgramUniform3uiEXT
#define GLEE_C_DEFINED_glProgramUniform3uiEXT
  void __stdcall GLee_Lazy_glProgramUniform3uiEXT(GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2)  {if (GLeeInit()) glProgramUniform3uiEXT(program, location, v0, v1, v2);}
  GLEEPFNGLPROGRAMUNIFORM3UIEXTPROC GLeeFuncPtr_glProgramUniform3uiEXT=GLee_Lazy_glProgramUniform3uiEXT;
#endif
#ifndef GLEE_C_DEFINED_glProgramUniform4uiEXT
#define GLEE_C_DEFINED_glProgramUniform4uiEXT
  void __stdcall GLee_Lazy_glProgramUniform4uiEXT(GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3)  {if (GLeeInit()) glProgramUniform4uiEXT(program, location, v0, v1, v2, v3);}
  GLEEPFNGLPROGRAMUNIFORM4UIEXTPROC GLeeFuncPtr_glProgramUniform4uiEXT=GLee_Lazy_glProgramUniform4uiEXT;
#endif
#ifndef GLEE_C_DEFINED_glProgramUniform1uivEXT
#define GLEE_C_DEFINED_glProgramUniform1uivEXT
  void __stdcall GLee_Lazy_glProgramUniform1uivEXT(GLuint program, GLint location, GLsizei count, const GLuint * value)  {if (GLeeInit()) glProgramUniform1uivEXT(program, location, count, value);}
  GLEEPFNGLPROGRAMUNIFORM1UIVEXTPROC GLeeFuncPtr_glProgramUniform1uivEXT=GLee_Lazy_glProgramUniform1uivEXT;
#endif
#ifndef GLEE_C_DEFINED_glProgramUniform2uivEXT
#define GLEE_C_DEFINED_glProgramUniform2uivEXT
  void __stdcall GLee_Lazy_glProgramUniform2uivEXT(GLuint program, GLint location, GLsizei count, const GLuint * value)  {if (GLeeInit()) glProgramUniform2uivEXT(program, location, count, value);}
  GLEEPFNGLPROGRAMUNIFORM2UIVEXTPROC GLeeFuncPtr_glProgramUniform2uivEXT=GLee_Lazy_glProgramUniform2uivEXT;
#endif
#ifndef GLEE_C_DEFINED_glProgramUniform3uivEXT
#define GLEE_C_DEFINED_glProgramUniform3uivEXT
  void __stdcall GLee_Lazy_glProgramUniform3uivEXT(GLuint program, GLint location, GLsizei count, const GLuint * value)  {if (GLeeInit()) glProgramUniform3uivEXT(program, location, count, value);}
  GLEEPFNGLPROGRAMUNIFORM3UIVEXTPROC GLeeFuncPtr_glProgramUniform3uivEXT=GLee_Lazy_glProgramUniform3uivEXT;
#endif
#ifndef GLEE_C_DEFINED_glProgramUniform4uivEXT
#define GLEE_C_DEFINED_glProgramUniform4uivEXT
  void __stdcall GLee_Lazy_glProgramUniform4uivEXT(GLuint program, GLint location, GLsizei count, const GLuint * value)  {if (GLeeInit()) glProgramUniform4uivEXT(program, location, count, value);}
  GLEEPFNGLPROGRAMUNIFORM4UIVEXTPROC GLeeFuncPtr_glProgramUniform4uivEXT=GLee_Lazy_glProgramUniform4uivEXT;
#endif
#ifndef GLEE_C_DEFINED_glNamedBufferDataEXT
#define GLEE_C_DEFINED_glNamedBufferDataEXT
  void __stdcall GLee_Lazy_glNamedBufferDataEXT(GLuint buffer, GLsizeiptr size, const GLvoid * data, GLenum usage)  {if (GLeeInit()) glNamedBufferDataEXT(buffer, size, data, usage);}
  GLEEPFNGLNAMEDBUFFERDATAEXTPROC GLeeFuncPtr_glNamedBufferDataEXT=GLee_Lazy_glNamedBufferDataEXT;
#endif
#ifndef GLEE_C_DEFINED_glNamedBufferSubDataEXT
#define GLEE_C_DEFINED_glNamedBufferSubDataEXT
  void __stdcall GLee_Lazy_glNamedBufferSubDataEXT(GLuint buffer, GLintptr offset, GLsizeiptr size, const GLvoid * data)  {if (GLeeInit()) glNamedBufferSubDataEXT(buffer, offset, size, data);}
  GLEEPFNGLNAMEDBUFFERSUBDATAEXTPROC GLeeFuncPtr_glNamedBufferSubDataEXT=GLee_Lazy_glNamedBufferSubDataEXT;
#endif
#ifndef GLEE_C_DEFINED_glMapNamedBufferEXT
#define GLEE_C_DEFINED_glMapNamedBufferEXT
  GLvoid* __stdcall GLee_Lazy_glMapNamedBufferEXT(GLuint buffer, GLenum access)  {if (GLeeInit()) return glMapNamedBufferEXT(buffer, access); return (GLvoid*)0;}
  GLEEPFNGLMAPNAMEDBUFFEREXTPROC GLeeFuncPtr_glMapNamedBufferEXT=GLee_Lazy_glMapNamedBufferEXT;
#endif
#ifndef GLEE_C_DEFINED_glUnmapNamedBufferEXT
#define GLEE_C_DEFINED_glUnmapNamedBufferEXT
  GLboolean __stdcall GLee_Lazy_glUnmapNamedBufferEXT(GLuint buffer)  {if (GLeeInit()) return glUnmapNamedBufferEXT(buffer); return (GLboolean)0;}
  GLEEPFNGLUNMAPNAMEDBUFFEREXTPROC GLeeFuncPtr_glUnmapNamedBufferEXT=GLee_Lazy_glUnmapNamedBufferEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetNamedBufferParameterivEXT
#define GLEE_C_DEFINED_glGetNamedBufferParameterivEXT
  void __stdcall GLee_Lazy_glGetNamedBufferParameterivEXT(GLuint buffer, GLenum pname, GLint * params)  {if (GLeeInit()) glGetNamedBufferParameterivEXT(buffer, pname, params);}
  GLEEPFNGLGETNAMEDBUFFERPARAMETERIVEXTPROC GLeeFuncPtr_glGetNamedBufferParameterivEXT=GLee_Lazy_glGetNamedBufferParameterivEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetNamedBufferPointervEXT
#define GLEE_C_DEFINED_glGetNamedBufferPointervEXT
  void __stdcall GLee_Lazy_glGetNamedBufferPointervEXT(GLuint buffer, GLenum pname, GLvoid* * params)  {if (GLeeInit()) glGetNamedBufferPointervEXT(buffer, pname, params);}
  GLEEPFNGLGETNAMEDBUFFERPOINTERVEXTPROC GLeeFuncPtr_glGetNamedBufferPointervEXT=GLee_Lazy_glGetNamedBufferPointervEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetNamedBufferSubDataEXT
#define GLEE_C_DEFINED_glGetNamedBufferSubDataEXT
  void __stdcall GLee_Lazy_glGetNamedBufferSubDataEXT(GLuint buffer, GLintptr offset, GLsizeiptr size, GLvoid * data)  {if (GLeeInit()) glGetNamedBufferSubDataEXT(buffer, offset, size, data);}
  GLEEPFNGLGETNAMEDBUFFERSUBDATAEXTPROC GLeeFuncPtr_glGetNamedBufferSubDataEXT=GLee_Lazy_glGetNamedBufferSubDataEXT;
#endif
#ifndef GLEE_C_DEFINED_glTextureBufferEXT
#define GLEE_C_DEFINED_glTextureBufferEXT
  void __stdcall GLee_Lazy_glTextureBufferEXT(GLuint texture, GLenum target, GLenum internalformat, GLuint buffer)  {if (GLeeInit()) glTextureBufferEXT(texture, target, internalformat, buffer);}
  GLEEPFNGLTEXTUREBUFFEREXTPROC GLeeFuncPtr_glTextureBufferEXT=GLee_Lazy_glTextureBufferEXT;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexBufferEXT
#define GLEE_C_DEFINED_glMultiTexBufferEXT
  void __stdcall GLee_Lazy_glMultiTexBufferEXT(GLenum texunit, GLenum target, GLenum internalformat, GLuint buffer)  {if (GLeeInit()) glMultiTexBufferEXT(texunit, target, internalformat, buffer);}
  GLEEPFNGLMULTITEXBUFFEREXTPROC GLeeFuncPtr_glMultiTexBufferEXT=GLee_Lazy_glMultiTexBufferEXT;
#endif
#ifndef GLEE_C_DEFINED_glNamedRenderbufferStorageEXT
#define GLEE_C_DEFINED_glNamedRenderbufferStorageEXT
  void __stdcall GLee_Lazy_glNamedRenderbufferStorageEXT(GLuint renderbuffer, GLenum internalformat, GLsizei width, GLsizei height)  {if (GLeeInit()) glNamedRenderbufferStorageEXT(renderbuffer, internalformat, width, height);}
  GLEEPFNGLNAMEDRENDERBUFFERSTORAGEEXTPROC GLeeFuncPtr_glNamedRenderbufferStorageEXT=GLee_Lazy_glNamedRenderbufferStorageEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetNamedRenderbufferParameterivEXT
#define GLEE_C_DEFINED_glGetNamedRenderbufferParameterivEXT
  void __stdcall GLee_Lazy_glGetNamedRenderbufferParameterivEXT(GLuint renderbuffer, GLenum pname, GLint * params)  {if (GLeeInit()) glGetNamedRenderbufferParameterivEXT(renderbuffer, pname, params);}
  GLEEPFNGLGETNAMEDRENDERBUFFERPARAMETERIVEXTPROC GLeeFuncPtr_glGetNamedRenderbufferParameterivEXT=GLee_Lazy_glGetNamedRenderbufferParameterivEXT;
#endif
#ifndef GLEE_C_DEFINED_glCheckNamedFramebufferStatusEXT
#define GLEE_C_DEFINED_glCheckNamedFramebufferStatusEXT
  GLenum __stdcall GLee_Lazy_glCheckNamedFramebufferStatusEXT(GLuint framebuffer, GLenum target)  {if (GLeeInit()) return glCheckNamedFramebufferStatusEXT(framebuffer, target); return (GLenum)0;}
  GLEEPFNGLCHECKNAMEDFRAMEBUFFERSTATUSEXTPROC GLeeFuncPtr_glCheckNamedFramebufferStatusEXT=GLee_Lazy_glCheckNamedFramebufferStatusEXT;
#endif
#ifndef GLEE_C_DEFINED_glNamedFramebufferTexture1DEXT
#define GLEE_C_DEFINED_glNamedFramebufferTexture1DEXT
  void __stdcall GLee_Lazy_glNamedFramebufferTexture1DEXT(GLuint framebuffer, GLenum attachment, GLenum textarget, GLuint texture, GLint level)  {if (GLeeInit()) glNamedFramebufferTexture1DEXT(framebuffer, attachment, textarget, texture, level);}
  GLEEPFNGLNAMEDFRAMEBUFFERTEXTURE1DEXTPROC GLeeFuncPtr_glNamedFramebufferTexture1DEXT=GLee_Lazy_glNamedFramebufferTexture1DEXT;
#endif
#ifndef GLEE_C_DEFINED_glNamedFramebufferTexture2DEXT
#define GLEE_C_DEFINED_glNamedFramebufferTexture2DEXT
  void __stdcall GLee_Lazy_glNamedFramebufferTexture2DEXT(GLuint framebuffer, GLenum attachment, GLenum textarget, GLuint texture, GLint level)  {if (GLeeInit()) glNamedFramebufferTexture2DEXT(framebuffer, attachment, textarget, texture, level);}
  GLEEPFNGLNAMEDFRAMEBUFFERTEXTURE2DEXTPROC GLeeFuncPtr_glNamedFramebufferTexture2DEXT=GLee_Lazy_glNamedFramebufferTexture2DEXT;
#endif
#ifndef GLEE_C_DEFINED_glNamedFramebufferTexture3DEXT
#define GLEE_C_DEFINED_glNamedFramebufferTexture3DEXT
  void __stdcall GLee_Lazy_glNamedFramebufferTexture3DEXT(GLuint framebuffer, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset)  {if (GLeeInit()) glNamedFramebufferTexture3DEXT(framebuffer, attachment, textarget, texture, level, zoffset);}
  GLEEPFNGLNAMEDFRAMEBUFFERTEXTURE3DEXTPROC GLeeFuncPtr_glNamedFramebufferTexture3DEXT=GLee_Lazy_glNamedFramebufferTexture3DEXT;
#endif
#ifndef GLEE_C_DEFINED_glNamedFramebufferRenderbufferEXT
#define GLEE_C_DEFINED_glNamedFramebufferRenderbufferEXT
  void __stdcall GLee_Lazy_glNamedFramebufferRenderbufferEXT(GLuint framebuffer, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer)  {if (GLeeInit()) glNamedFramebufferRenderbufferEXT(framebuffer, attachment, renderbuffertarget, renderbuffer);}
  GLEEPFNGLNAMEDFRAMEBUFFERRENDERBUFFEREXTPROC GLeeFuncPtr_glNamedFramebufferRenderbufferEXT=GLee_Lazy_glNamedFramebufferRenderbufferEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetNamedFramebufferAttachmentParameterivEXT
#define GLEE_C_DEFINED_glGetNamedFramebufferAttachmentParameterivEXT
  void __stdcall GLee_Lazy_glGetNamedFramebufferAttachmentParameterivEXT(GLuint framebuffer, GLenum attachment, GLenum pname, GLint * params)  {if (GLeeInit()) glGetNamedFramebufferAttachmentParameterivEXT(framebuffer, attachment, pname, params);}
  GLEEPFNGLGETNAMEDFRAMEBUFFERATTACHMENTPARAMETERIVEXTPROC GLeeFuncPtr_glGetNamedFramebufferAttachmentParameterivEXT=GLee_Lazy_glGetNamedFramebufferAttachmentParameterivEXT;
#endif
#ifndef GLEE_C_DEFINED_glGenerateTextureMipmapEXT
#define GLEE_C_DEFINED_glGenerateTextureMipmapEXT
  void __stdcall GLee_Lazy_glGenerateTextureMipmapEXT(GLuint texture, GLenum target)  {if (GLeeInit()) glGenerateTextureMipmapEXT(texture, target);}
  GLEEPFNGLGENERATETEXTUREMIPMAPEXTPROC GLeeFuncPtr_glGenerateTextureMipmapEXT=GLee_Lazy_glGenerateTextureMipmapEXT;
#endif
#ifndef GLEE_C_DEFINED_glGenerateMultiTexMipmapEXT
#define GLEE_C_DEFINED_glGenerateMultiTexMipmapEXT
  void __stdcall GLee_Lazy_glGenerateMultiTexMipmapEXT(GLenum texunit, GLenum target)  {if (GLeeInit()) glGenerateMultiTexMipmapEXT(texunit, target);}
  GLEEPFNGLGENERATEMULTITEXMIPMAPEXTPROC GLeeFuncPtr_glGenerateMultiTexMipmapEXT=GLee_Lazy_glGenerateMultiTexMipmapEXT;
#endif
#ifndef GLEE_C_DEFINED_glFramebufferDrawBufferEXT
#define GLEE_C_DEFINED_glFramebufferDrawBufferEXT
  void __stdcall GLee_Lazy_glFramebufferDrawBufferEXT(GLuint framebuffer, GLenum mode)  {if (GLeeInit()) glFramebufferDrawBufferEXT(framebuffer, mode);}
  GLEEPFNGLFRAMEBUFFERDRAWBUFFEREXTPROC GLeeFuncPtr_glFramebufferDrawBufferEXT=GLee_Lazy_glFramebufferDrawBufferEXT;
#endif
#ifndef GLEE_C_DEFINED_glFramebufferDrawBuffersEXT
#define GLEE_C_DEFINED_glFramebufferDrawBuffersEXT
  void __stdcall GLee_Lazy_glFramebufferDrawBuffersEXT(GLuint framebuffer, GLsizei n, const GLenum * bufs)  {if (GLeeInit()) glFramebufferDrawBuffersEXT(framebuffer, n, bufs);}
  GLEEPFNGLFRAMEBUFFERDRAWBUFFERSEXTPROC GLeeFuncPtr_glFramebufferDrawBuffersEXT=GLee_Lazy_glFramebufferDrawBuffersEXT;
#endif
#ifndef GLEE_C_DEFINED_glFramebufferReadBufferEXT
#define GLEE_C_DEFINED_glFramebufferReadBufferEXT
  void __stdcall GLee_Lazy_glFramebufferReadBufferEXT(GLuint framebuffer, GLenum mode)  {if (GLeeInit()) glFramebufferReadBufferEXT(framebuffer, mode);}
  GLEEPFNGLFRAMEBUFFERREADBUFFEREXTPROC GLeeFuncPtr_glFramebufferReadBufferEXT=GLee_Lazy_glFramebufferReadBufferEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetFramebufferParameterivEXT
#define GLEE_C_DEFINED_glGetFramebufferParameterivEXT
  void __stdcall GLee_Lazy_glGetFramebufferParameterivEXT(GLuint framebuffer, GLenum pname, GLint * params)  {if (GLeeInit()) glGetFramebufferParameterivEXT(framebuffer, pname, params);}
  GLEEPFNGLGETFRAMEBUFFERPARAMETERIVEXTPROC GLeeFuncPtr_glGetFramebufferParameterivEXT=GLee_Lazy_glGetFramebufferParameterivEXT;
#endif
#ifndef GLEE_C_DEFINED_glNamedRenderbufferStorageMultisampleEXT
#define GLEE_C_DEFINED_glNamedRenderbufferStorageMultisampleEXT
  void __stdcall GLee_Lazy_glNamedRenderbufferStorageMultisampleEXT(GLuint renderbuffer, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height)  {if (GLeeInit()) glNamedRenderbufferStorageMultisampleEXT(renderbuffer, samples, internalformat, width, height);}
  GLEEPFNGLNAMEDRENDERBUFFERSTORAGEMULTISAMPLEEXTPROC GLeeFuncPtr_glNamedRenderbufferStorageMultisampleEXT=GLee_Lazy_glNamedRenderbufferStorageMultisampleEXT;
#endif
#ifndef GLEE_C_DEFINED_glNamedRenderbufferStorageMultisampleCoverageEXT
#define GLEE_C_DEFINED_glNamedRenderbufferStorageMultisampleCoverageEXT
  void __stdcall GLee_Lazy_glNamedRenderbufferStorageMultisampleCoverageEXT(GLuint renderbuffer, GLsizei coverageSamples, GLsizei colorSamples, GLenum internalformat, GLsizei width, GLsizei height)  {if (GLeeInit()) glNamedRenderbufferStorageMultisampleCoverageEXT(renderbuffer, coverageSamples, colorSamples, internalformat, width, height);}
  GLEEPFNGLNAMEDRENDERBUFFERSTORAGEMULTISAMPLECOVERAGEEXTPROC GLeeFuncPtr_glNamedRenderbufferStorageMultisampleCoverageEXT=GLee_Lazy_glNamedRenderbufferStorageMultisampleCoverageEXT;
#endif
#ifndef GLEE_C_DEFINED_glNamedFramebufferTextureEXT
#define GLEE_C_DEFINED_glNamedFramebufferTextureEXT
  void __stdcall GLee_Lazy_glNamedFramebufferTextureEXT(GLuint framebuffer, GLenum attachment, GLuint texture, GLint level)  {if (GLeeInit()) glNamedFramebufferTextureEXT(framebuffer, attachment, texture, level);}
  GLEEPFNGLNAMEDFRAMEBUFFERTEXTUREEXTPROC GLeeFuncPtr_glNamedFramebufferTextureEXT=GLee_Lazy_glNamedFramebufferTextureEXT;
#endif
#ifndef GLEE_C_DEFINED_glNamedFramebufferTextureLayerEXT
#define GLEE_C_DEFINED_glNamedFramebufferTextureLayerEXT
  void __stdcall GLee_Lazy_glNamedFramebufferTextureLayerEXT(GLuint framebuffer, GLenum attachment, GLuint texture, GLint level, GLint layer)  {if (GLeeInit()) glNamedFramebufferTextureLayerEXT(framebuffer, attachment, texture, level, layer);}
  GLEEPFNGLNAMEDFRAMEBUFFERTEXTURELAYEREXTPROC GLeeFuncPtr_glNamedFramebufferTextureLayerEXT=GLee_Lazy_glNamedFramebufferTextureLayerEXT;
#endif
#ifndef GLEE_C_DEFINED_glNamedFramebufferTextureFaceEXT
#define GLEE_C_DEFINED_glNamedFramebufferTextureFaceEXT
  void __stdcall GLee_Lazy_glNamedFramebufferTextureFaceEXT(GLuint framebuffer, GLenum attachment, GLuint texture, GLint level, GLenum face)  {if (GLeeInit()) glNamedFramebufferTextureFaceEXT(framebuffer, attachment, texture, level, face);}
  GLEEPFNGLNAMEDFRAMEBUFFERTEXTUREFACEEXTPROC GLeeFuncPtr_glNamedFramebufferTextureFaceEXT=GLee_Lazy_glNamedFramebufferTextureFaceEXT;
#endif
#ifndef GLEE_C_DEFINED_glTextureRenderbufferEXT
#define GLEE_C_DEFINED_glTextureRenderbufferEXT
  void __stdcall GLee_Lazy_glTextureRenderbufferEXT(GLuint texture, GLenum target, GLuint renderbuffer)  {if (GLeeInit()) glTextureRenderbufferEXT(texture, target, renderbuffer);}
  GLEEPFNGLTEXTURERENDERBUFFEREXTPROC GLeeFuncPtr_glTextureRenderbufferEXT=GLee_Lazy_glTextureRenderbufferEXT;
#endif
#ifndef GLEE_C_DEFINED_glMultiTexRenderbufferEXT
#define GLEE_C_DEFINED_glMultiTexRenderbufferEXT
  void __stdcall GLee_Lazy_glMultiTexRenderbufferEXT(GLenum texunit, GLenum target, GLuint renderbuffer)  {if (GLeeInit()) glMultiTexRenderbufferEXT(texunit, target, renderbuffer);}
  GLEEPFNGLMULTITEXRENDERBUFFEREXTPROC GLeeFuncPtr_glMultiTexRenderbufferEXT=GLee_Lazy_glMultiTexRenderbufferEXT;
#endif
#endif 

/* GL_EXT_vertex_array_bgra */

#ifdef __GLEE_GL_EXT_vertex_array_bgra
#endif 

/* GL_EXT_texture_swizzle */

#ifdef __GLEE_GL_EXT_texture_swizzle
#endif 

/* GL_NV_explicit_multisample */

#ifdef __GLEE_GL_NV_explicit_multisample
#ifndef GLEE_C_DEFINED_glGetMultisamplefvNV
#define GLEE_C_DEFINED_glGetMultisamplefvNV
  void __stdcall GLee_Lazy_glGetMultisamplefvNV(GLenum pname, GLuint index, GLfloat * val)  {if (GLeeInit()) glGetMultisamplefvNV(pname, index, val);}
  GLEEPFNGLGETMULTISAMPLEFVNVPROC GLeeFuncPtr_glGetMultisamplefvNV=GLee_Lazy_glGetMultisamplefvNV;
#endif
#ifndef GLEE_C_DEFINED_glSampleMaskIndexedNV
#define GLEE_C_DEFINED_glSampleMaskIndexedNV
  void __stdcall GLee_Lazy_glSampleMaskIndexedNV(GLuint index, GLbitfield mask)  {if (GLeeInit()) glSampleMaskIndexedNV(index, mask);}
  GLEEPFNGLSAMPLEMASKINDEXEDNVPROC GLeeFuncPtr_glSampleMaskIndexedNV=GLee_Lazy_glSampleMaskIndexedNV;
#endif
#ifndef GLEE_C_DEFINED_glTexRenderbufferNV
#define GLEE_C_DEFINED_glTexRenderbufferNV
  void __stdcall GLee_Lazy_glTexRenderbufferNV(GLenum target, GLuint renderbuffer)  {if (GLeeInit()) glTexRenderbufferNV(target, renderbuffer);}
  GLEEPFNGLTEXRENDERBUFFERNVPROC GLeeFuncPtr_glTexRenderbufferNV=GLee_Lazy_glTexRenderbufferNV;
#endif
#endif 

/* GL_NV_transform_feedback2 */

#ifdef __GLEE_GL_NV_transform_feedback2
#ifndef GLEE_C_DEFINED_glBindTransformFeedbackNV
#define GLEE_C_DEFINED_glBindTransformFeedbackNV
  void __stdcall GLee_Lazy_glBindTransformFeedbackNV(GLenum target, GLuint id)  {if (GLeeInit()) glBindTransformFeedbackNV(target, id);}
  GLEEPFNGLBINDTRANSFORMFEEDBACKNVPROC GLeeFuncPtr_glBindTransformFeedbackNV=GLee_Lazy_glBindTransformFeedbackNV;
#endif
#ifndef GLEE_C_DEFINED_glDeleteTransformFeedbacksNV
#define GLEE_C_DEFINED_glDeleteTransformFeedbacksNV
  void __stdcall GLee_Lazy_glDeleteTransformFeedbacksNV(GLsizei n, const GLuint * ids)  {if (GLeeInit()) glDeleteTransformFeedbacksNV(n, ids);}
  GLEEPFNGLDELETETRANSFORMFEEDBACKSNVPROC GLeeFuncPtr_glDeleteTransformFeedbacksNV=GLee_Lazy_glDeleteTransformFeedbacksNV;
#endif
#ifndef GLEE_C_DEFINED_glGenTransformFeedbacksNV
#define GLEE_C_DEFINED_glGenTransformFeedbacksNV
  void __stdcall GLee_Lazy_glGenTransformFeedbacksNV(GLsizei n, GLuint * ids)  {if (GLeeInit()) glGenTransformFeedbacksNV(n, ids);}
  GLEEPFNGLGENTRANSFORMFEEDBACKSNVPROC GLeeFuncPtr_glGenTransformFeedbacksNV=GLee_Lazy_glGenTransformFeedbacksNV;
#endif
#ifndef GLEE_C_DEFINED_glIsTransformFeedbackNV
#define GLEE_C_DEFINED_glIsTransformFeedbackNV
  GLboolean __stdcall GLee_Lazy_glIsTransformFeedbackNV(GLuint id)  {if (GLeeInit()) return glIsTransformFeedbackNV(id); return (GLboolean)0;}
  GLEEPFNGLISTRANSFORMFEEDBACKNVPROC GLeeFuncPtr_glIsTransformFeedbackNV=GLee_Lazy_glIsTransformFeedbackNV;
#endif
#ifndef GLEE_C_DEFINED_glPauseTransformFeedbackNV
#define GLEE_C_DEFINED_glPauseTransformFeedbackNV
  void __stdcall GLee_Lazy_glPauseTransformFeedbackNV(void)  {if (GLeeInit()) glPauseTransformFeedbackNV();}
  GLEEPFNGLPAUSETRANSFORMFEEDBACKNVPROC GLeeFuncPtr_glPauseTransformFeedbackNV=GLee_Lazy_glPauseTransformFeedbackNV;
#endif
#ifndef GLEE_C_DEFINED_glResumeTransformFeedbackNV
#define GLEE_C_DEFINED_glResumeTransformFeedbackNV
  void __stdcall GLee_Lazy_glResumeTransformFeedbackNV(void)  {if (GLeeInit()) glResumeTransformFeedbackNV();}
  GLEEPFNGLRESUMETRANSFORMFEEDBACKNVPROC GLeeFuncPtr_glResumeTransformFeedbackNV=GLee_Lazy_glResumeTransformFeedbackNV;
#endif
#ifndef GLEE_C_DEFINED_glDrawTransformFeedbackNV
#define GLEE_C_DEFINED_glDrawTransformFeedbackNV
  void __stdcall GLee_Lazy_glDrawTransformFeedbackNV(GLenum mode, GLuint id)  {if (GLeeInit()) glDrawTransformFeedbackNV(mode, id);}
  GLEEPFNGLDRAWTRANSFORMFEEDBACKNVPROC GLeeFuncPtr_glDrawTransformFeedbackNV=GLee_Lazy_glDrawTransformFeedbackNV;
#endif
#endif 

/* GL_SGIX_texture_select */

#ifdef __GLEE_GL_SGIX_texture_select
#endif 

/* GL_INGR_blend_func_separate */

#ifdef __GLEE_GL_INGR_blend_func_separate
#ifndef GLEE_C_DEFINED_glBlendFuncSeparateINGR
#define GLEE_C_DEFINED_glBlendFuncSeparateINGR
  void __stdcall GLee_Lazy_glBlendFuncSeparateINGR(GLenum sfactorRGB, GLenum dfactorRGB, GLenum sfactorAlpha, GLenum dfactorAlpha)  {if (GLeeInit()) glBlendFuncSeparateINGR(sfactorRGB, dfactorRGB, sfactorAlpha, dfactorAlpha);}
  GLEEPFNGLBLENDFUNCSEPARATEINGRPROC GLeeFuncPtr_glBlendFuncSeparateINGR=GLee_Lazy_glBlendFuncSeparateINGR;
#endif
#endif 

/* GL_SGIX_depth_pass_instrument */

#ifdef __GLEE_GL_SGIX_depth_pass_instrument
#endif 

/* GL_SGIX_igloo_interface */

#ifdef __GLEE_GL_SGIX_igloo_interface
#ifndef GLEE_C_DEFINED_glIglooInterfaceSGIX
#define GLEE_C_DEFINED_glIglooInterfaceSGIX
  void __stdcall GLee_Lazy_glIglooInterfaceSGIX(GLenum pname, const GLvoid * params)  {if (GLeeInit()) glIglooInterfaceSGIX(pname, params);}
  GLEEPFNGLIGLOOINTERFACESGIXPROC GLeeFuncPtr_glIglooInterfaceSGIX=GLee_Lazy_glIglooInterfaceSGIX;
#endif
#endif 

/* GL_EXT_fragment_lighting */

#ifdef __GLEE_GL_EXT_fragment_lighting
#ifndef GLEE_C_DEFINED_glFragmentLightModeliEXT
#define GLEE_C_DEFINED_glFragmentLightModeliEXT
  GLvoid __stdcall GLee_Lazy_glFragmentLightModeliEXT(GLenum pname, GLint param)  {if (GLeeInit()) glFragmentLightModeliEXT(pname, param);}
  GLEEPFNGLFRAGMENTLIGHTMODELIEXTPROC GLeeFuncPtr_glFragmentLightModeliEXT=GLee_Lazy_glFragmentLightModeliEXT;
#endif
#ifndef GLEE_C_DEFINED_glFragmentLightModelfEXT
#define GLEE_C_DEFINED_glFragmentLightModelfEXT
  GLvoid __stdcall GLee_Lazy_glFragmentLightModelfEXT(GLenum pname, GLfloat param)  {if (GLeeInit()) glFragmentLightModelfEXT(pname, param);}
  GLEEPFNGLFRAGMENTLIGHTMODELFEXTPROC GLeeFuncPtr_glFragmentLightModelfEXT=GLee_Lazy_glFragmentLightModelfEXT;
#endif
#ifndef GLEE_C_DEFINED_glFragmentLightModelivEXT
#define GLEE_C_DEFINED_glFragmentLightModelivEXT
  GLvoid __stdcall GLee_Lazy_glFragmentLightModelivEXT(GLenum pname, GLint * params)  {if (GLeeInit()) glFragmentLightModelivEXT(pname, params);}
  GLEEPFNGLFRAGMENTLIGHTMODELIVEXTPROC GLeeFuncPtr_glFragmentLightModelivEXT=GLee_Lazy_glFragmentLightModelivEXT;
#endif
#ifndef GLEE_C_DEFINED_glFragmentLightModelfvEXT
#define GLEE_C_DEFINED_glFragmentLightModelfvEXT
  GLvoid __stdcall GLee_Lazy_glFragmentLightModelfvEXT(GLenum pname, GLfloat * params)  {if (GLeeInit()) glFragmentLightModelfvEXT(pname, params);}
  GLEEPFNGLFRAGMENTLIGHTMODELFVEXTPROC GLeeFuncPtr_glFragmentLightModelfvEXT=GLee_Lazy_glFragmentLightModelfvEXT;
#endif
#ifndef GLEE_C_DEFINED_glFragmentLightiEXT
#define GLEE_C_DEFINED_glFragmentLightiEXT
  GLvoid __stdcall GLee_Lazy_glFragmentLightiEXT(GLenum light, GLenum pname, GLint param)  {if (GLeeInit()) glFragmentLightiEXT(light, pname, param);}
  GLEEPFNGLFRAGMENTLIGHTIEXTPROC GLeeFuncPtr_glFragmentLightiEXT=GLee_Lazy_glFragmentLightiEXT;
#endif
#ifndef GLEE_C_DEFINED_glFragmentLightfEXT
#define GLEE_C_DEFINED_glFragmentLightfEXT
  GLvoid __stdcall GLee_Lazy_glFragmentLightfEXT(GLenum light, GLenum pname, GLfloat param)  {if (GLeeInit()) glFragmentLightfEXT(light, pname, param);}
  GLEEPFNGLFRAGMENTLIGHTFEXTPROC GLeeFuncPtr_glFragmentLightfEXT=GLee_Lazy_glFragmentLightfEXT;
#endif
#ifndef GLEE_C_DEFINED_glFragmentLightivEXT
#define GLEE_C_DEFINED_glFragmentLightivEXT
  GLvoid __stdcall GLee_Lazy_glFragmentLightivEXT(GLenum light, GLenum pname, GLint * params)  {if (GLeeInit()) glFragmentLightivEXT(light, pname, params);}
  GLEEPFNGLFRAGMENTLIGHTIVEXTPROC GLeeFuncPtr_glFragmentLightivEXT=GLee_Lazy_glFragmentLightivEXT;
#endif
#ifndef GLEE_C_DEFINED_glFragmentLightfvEXT
#define GLEE_C_DEFINED_glFragmentLightfvEXT
  GLvoid __stdcall GLee_Lazy_glFragmentLightfvEXT(GLenum light, GLenum pname, GLfloat * params)  {if (GLeeInit()) glFragmentLightfvEXT(light, pname, params);}
  GLEEPFNGLFRAGMENTLIGHTFVEXTPROC GLeeFuncPtr_glFragmentLightfvEXT=GLee_Lazy_glFragmentLightfvEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetFragmentLightivEXT
#define GLEE_C_DEFINED_glGetFragmentLightivEXT
  GLvoid __stdcall GLee_Lazy_glGetFragmentLightivEXT(GLenum light, GLenum pname, GLint * params)  {if (GLeeInit()) glGetFragmentLightivEXT(light, pname, params);}
  GLEEPFNGLGETFRAGMENTLIGHTIVEXTPROC GLeeFuncPtr_glGetFragmentLightivEXT=GLee_Lazy_glGetFragmentLightivEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetFragmentLightfvEXT
#define GLEE_C_DEFINED_glGetFragmentLightfvEXT
  GLvoid __stdcall GLee_Lazy_glGetFragmentLightfvEXT(GLenum light, GLenum pname, GLfloat * params)  {if (GLeeInit()) glGetFragmentLightfvEXT(light, pname, params);}
  GLEEPFNGLGETFRAGMENTLIGHTFVEXTPROC GLeeFuncPtr_glGetFragmentLightfvEXT=GLee_Lazy_glGetFragmentLightfvEXT;
#endif
#ifndef GLEE_C_DEFINED_glFragmentMaterialfEXT
#define GLEE_C_DEFINED_glFragmentMaterialfEXT
  GLvoid __stdcall GLee_Lazy_glFragmentMaterialfEXT(GLenum face, GLenum pname, const GLfloat param)  {if (GLeeInit()) glFragmentMaterialfEXT(face, pname, param);}
  GLEEPFNGLFRAGMENTMATERIALFEXTPROC GLeeFuncPtr_glFragmentMaterialfEXT=GLee_Lazy_glFragmentMaterialfEXT;
#endif
#ifndef GLEE_C_DEFINED_glFragmentMaterialiEXT
#define GLEE_C_DEFINED_glFragmentMaterialiEXT
  GLvoid __stdcall GLee_Lazy_glFragmentMaterialiEXT(GLenum face, GLenum pname, const GLint param)  {if (GLeeInit()) glFragmentMaterialiEXT(face, pname, param);}
  GLEEPFNGLFRAGMENTMATERIALIEXTPROC GLeeFuncPtr_glFragmentMaterialiEXT=GLee_Lazy_glFragmentMaterialiEXT;
#endif
#ifndef GLEE_C_DEFINED_glFragmentMaterialfvEXT
#define GLEE_C_DEFINED_glFragmentMaterialfvEXT
  GLvoid __stdcall GLee_Lazy_glFragmentMaterialfvEXT(GLenum face, GLenum pname, const GLfloat * params)  {if (GLeeInit()) glFragmentMaterialfvEXT(face, pname, params);}
  GLEEPFNGLFRAGMENTMATERIALFVEXTPROC GLeeFuncPtr_glFragmentMaterialfvEXT=GLee_Lazy_glFragmentMaterialfvEXT;
#endif
#ifndef GLEE_C_DEFINED_glFragmentMaterialivEXT
#define GLEE_C_DEFINED_glFragmentMaterialivEXT
  GLvoid __stdcall GLee_Lazy_glFragmentMaterialivEXT(GLenum face, GLenum pname, const GLint * params)  {if (GLeeInit()) glFragmentMaterialivEXT(face, pname, params);}
  GLEEPFNGLFRAGMENTMATERIALIVEXTPROC GLeeFuncPtr_glFragmentMaterialivEXT=GLee_Lazy_glFragmentMaterialivEXT;
#endif
#ifndef GLEE_C_DEFINED_glFragmentColorMaterialEXT
#define GLEE_C_DEFINED_glFragmentColorMaterialEXT
  GLvoid __stdcall GLee_Lazy_glFragmentColorMaterialEXT(GLenum face, GLenum mode)  {if (GLeeInit()) glFragmentColorMaterialEXT(face, mode);}
  GLEEPFNGLFRAGMENTCOLORMATERIALEXTPROC GLeeFuncPtr_glFragmentColorMaterialEXT=GLee_Lazy_glFragmentColorMaterialEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetFragmentMaterialfvEXT
#define GLEE_C_DEFINED_glGetFragmentMaterialfvEXT
  GLvoid __stdcall GLee_Lazy_glGetFragmentMaterialfvEXT(GLenum face, GLenum pname, const GLfloat * params)  {if (GLeeInit()) glGetFragmentMaterialfvEXT(face, pname, params);}
  GLEEPFNGLGETFRAGMENTMATERIALFVEXTPROC GLeeFuncPtr_glGetFragmentMaterialfvEXT=GLee_Lazy_glGetFragmentMaterialfvEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetFragmentMaterialivEXT
#define GLEE_C_DEFINED_glGetFragmentMaterialivEXT
  GLvoid __stdcall GLee_Lazy_glGetFragmentMaterialivEXT(GLenum face, GLenum pname, const GLint * params)  {if (GLeeInit()) glGetFragmentMaterialivEXT(face, pname, params);}
  GLEEPFNGLGETFRAGMENTMATERIALIVEXTPROC GLeeFuncPtr_glGetFragmentMaterialivEXT=GLee_Lazy_glGetFragmentMaterialivEXT;
#endif
#ifndef GLEE_C_DEFINED_glLightEnviEXT
#define GLEE_C_DEFINED_glLightEnviEXT
  GLvoid __stdcall GLee_Lazy_glLightEnviEXT(GLenum pname, GLint param)  {if (GLeeInit()) glLightEnviEXT(pname, param);}
  GLEEPFNGLLIGHTENVIEXTPROC GLeeFuncPtr_glLightEnviEXT=GLee_Lazy_glLightEnviEXT;
#endif
#endif 

/* GL_EXT_geometry_shader4 */

#ifdef __GLEE_GL_EXT_geometry_shader4
#ifndef GLEE_C_DEFINED_glProgramParameteriEXT
#define GLEE_C_DEFINED_glProgramParameteriEXT
  GLvoid __stdcall GLee_Lazy_glProgramParameteriEXT(GLuint program, GLenum pname, GLint value)  {if (GLeeInit()) glProgramParameteriEXT(program, pname, value);}
  GLEEPFNGLPROGRAMPARAMETERIEXTPROC GLeeFuncPtr_glProgramParameteriEXT=GLee_Lazy_glProgramParameteriEXT;
#endif
#ifndef GLEE_C_DEFINED_glFramebufferTextureEXT
#define GLEE_C_DEFINED_glFramebufferTextureEXT
  GLvoid __stdcall GLee_Lazy_glFramebufferTextureEXT(GLenum target, GLenum attachment, GLuint texture, GLint level)  {if (GLeeInit()) glFramebufferTextureEXT(target, attachment, texture, level);}
  GLEEPFNGLFRAMEBUFFERTEXTUREEXTPROC GLeeFuncPtr_glFramebufferTextureEXT=GLee_Lazy_glFramebufferTextureEXT;
#endif
#ifndef GLEE_C_DEFINED_glFramebufferTextureLayerEXT
#define GLEE_C_DEFINED_glFramebufferTextureLayerEXT
  GLvoid __stdcall GLee_Lazy_glFramebufferTextureLayerEXT(GLenum target, GLenum attachment, GLuint texture, GLint level, GLint layer)  {if (GLeeInit()) glFramebufferTextureLayerEXT(target, attachment, texture, level, layer);}
  GLEEPFNGLFRAMEBUFFERTEXTURELAYEREXTPROC GLeeFuncPtr_glFramebufferTextureLayerEXT=GLee_Lazy_glFramebufferTextureLayerEXT;
#endif
#ifndef GLEE_C_DEFINED_glFramebufferTextureFaceEXT
#define GLEE_C_DEFINED_glFramebufferTextureFaceEXT
  GLvoid __stdcall GLee_Lazy_glFramebufferTextureFaceEXT(GLenum target, GLenum attachment, GLuint texture, GLint level, GLenum face)  {if (GLeeInit()) glFramebufferTextureFaceEXT(target, attachment, texture, level, face);}
  GLEEPFNGLFRAMEBUFFERTEXTUREFACEEXTPROC GLeeFuncPtr_glFramebufferTextureFaceEXT=GLee_Lazy_glFramebufferTextureFaceEXT;
#endif
#endif 

/* GL_EXT_scene_marker */

#ifdef __GLEE_GL_EXT_scene_marker
#ifndef GLEE_C_DEFINED_glBeginSceneEXT
#define GLEE_C_DEFINED_glBeginSceneEXT
  GLvoid __stdcall GLee_Lazy_glBeginSceneEXT(void)  {if (GLeeInit()) glBeginSceneEXT();}
  GLEEPFNGLBEGINSCENEEXTPROC GLeeFuncPtr_glBeginSceneEXT=GLee_Lazy_glBeginSceneEXT;
#endif
#ifndef GLEE_C_DEFINED_glEndSceneEXT
#define GLEE_C_DEFINED_glEndSceneEXT
  GLvoid __stdcall GLee_Lazy_glEndSceneEXT(void)  {if (GLeeInit()) glEndSceneEXT();}
  GLEEPFNGLENDSCENEEXTPROC GLeeFuncPtr_glEndSceneEXT=GLee_Lazy_glEndSceneEXT;
#endif
#endif 

/* GL_EXT_texture_compression_dxt1 */

#ifdef __GLEE_GL_EXT_texture_compression_dxt1
#endif 

/* GL_EXT_texture_env */

#ifdef __GLEE_GL_EXT_texture_env
#endif 

/* GL_IBM_static_data */

#ifdef __GLEE_GL_IBM_static_data
#endif 

/* GL_NV_gpu_program4 */

#ifdef __GLEE_GL_NV_gpu_program4
#ifndef GLEE_C_DEFINED_glProgramLocalParameterI4iNV
#define GLEE_C_DEFINED_glProgramLocalParameterI4iNV
  GLvoid __stdcall GLee_Lazy_glProgramLocalParameterI4iNV(GLenum target, GLuint index, GLint x, GLint y, GLint z, GLint w)  {if (GLeeInit()) glProgramLocalParameterI4iNV(target, index, x, y, z, w);}
  GLEEPFNGLPROGRAMLOCALPARAMETERI4INVPROC GLeeFuncPtr_glProgramLocalParameterI4iNV=GLee_Lazy_glProgramLocalParameterI4iNV;
#endif
#ifndef GLEE_C_DEFINED_glProgramLocalParameterI4ivNV
#define GLEE_C_DEFINED_glProgramLocalParameterI4ivNV
  GLvoid __stdcall GLee_Lazy_glProgramLocalParameterI4ivNV(GLenum target, GLuint index, const GLint * params)  {if (GLeeInit()) glProgramLocalParameterI4ivNV(target, index, params);}
  GLEEPFNGLPROGRAMLOCALPARAMETERI4IVNVPROC GLeeFuncPtr_glProgramLocalParameterI4ivNV=GLee_Lazy_glProgramLocalParameterI4ivNV;
#endif
#ifndef GLEE_C_DEFINED_glProgramLocalParametersI4ivNV
#define GLEE_C_DEFINED_glProgramLocalParametersI4ivNV
  GLvoid __stdcall GLee_Lazy_glProgramLocalParametersI4ivNV(GLenum target, GLuint index, GLsizei count, const GLint * params)  {if (GLeeInit()) glProgramLocalParametersI4ivNV(target, index, count, params);}
  GLEEPFNGLPROGRAMLOCALPARAMETERSI4IVNVPROC GLeeFuncPtr_glProgramLocalParametersI4ivNV=GLee_Lazy_glProgramLocalParametersI4ivNV;
#endif
#ifndef GLEE_C_DEFINED_glProgramLocalParameterI4uiNV
#define GLEE_C_DEFINED_glProgramLocalParameterI4uiNV
  GLvoid __stdcall GLee_Lazy_glProgramLocalParameterI4uiNV(GLenum target, GLuint index, GLuint x, GLuint y, GLuint z, GLuint w)  {if (GLeeInit()) glProgramLocalParameterI4uiNV(target, index, x, y, z, w);}
  GLEEPFNGLPROGRAMLOCALPARAMETERI4UINVPROC GLeeFuncPtr_glProgramLocalParameterI4uiNV=GLee_Lazy_glProgramLocalParameterI4uiNV;
#endif
#ifndef GLEE_C_DEFINED_glProgramLocalParameterI4uivNV
#define GLEE_C_DEFINED_glProgramLocalParameterI4uivNV
  GLvoid __stdcall GLee_Lazy_glProgramLocalParameterI4uivNV(GLenum target, GLuint index, const GLuint * params)  {if (GLeeInit()) glProgramLocalParameterI4uivNV(target, index, params);}
  GLEEPFNGLPROGRAMLOCALPARAMETERI4UIVNVPROC GLeeFuncPtr_glProgramLocalParameterI4uivNV=GLee_Lazy_glProgramLocalParameterI4uivNV;
#endif
#ifndef GLEE_C_DEFINED_glProgramLocalParametersI4uivNV
#define GLEE_C_DEFINED_glProgramLocalParametersI4uivNV
  GLvoid __stdcall GLee_Lazy_glProgramLocalParametersI4uivNV(GLenum target, GLuint index, GLsizei count, const GLuint * params)  {if (GLeeInit()) glProgramLocalParametersI4uivNV(target, index, count, params);}
  GLEEPFNGLPROGRAMLOCALPARAMETERSI4UIVNVPROC GLeeFuncPtr_glProgramLocalParametersI4uivNV=GLee_Lazy_glProgramLocalParametersI4uivNV;
#endif
#ifndef GLEE_C_DEFINED_glProgramEnvParameterI4iNV
#define GLEE_C_DEFINED_glProgramEnvParameterI4iNV
  GLvoid __stdcall GLee_Lazy_glProgramEnvParameterI4iNV(GLenum target, GLuint index, GLint x, GLint y, GLint z, GLint w)  {if (GLeeInit()) glProgramEnvParameterI4iNV(target, index, x, y, z, w);}
  GLEEPFNGLPROGRAMENVPARAMETERI4INVPROC GLeeFuncPtr_glProgramEnvParameterI4iNV=GLee_Lazy_glProgramEnvParameterI4iNV;
#endif
#ifndef GLEE_C_DEFINED_glProgramEnvParameterI4ivNV
#define GLEE_C_DEFINED_glProgramEnvParameterI4ivNV
  GLvoid __stdcall GLee_Lazy_glProgramEnvParameterI4ivNV(GLenum target, GLuint index, const GLint * params)  {if (GLeeInit()) glProgramEnvParameterI4ivNV(target, index, params);}
  GLEEPFNGLPROGRAMENVPARAMETERI4IVNVPROC GLeeFuncPtr_glProgramEnvParameterI4ivNV=GLee_Lazy_glProgramEnvParameterI4ivNV;
#endif
#ifndef GLEE_C_DEFINED_glProgramEnvParametersI4ivNV
#define GLEE_C_DEFINED_glProgramEnvParametersI4ivNV
  GLvoid __stdcall GLee_Lazy_glProgramEnvParametersI4ivNV(GLenum target, GLuint index, GLsizei count, const GLint * params)  {if (GLeeInit()) glProgramEnvParametersI4ivNV(target, index, count, params);}
  GLEEPFNGLPROGRAMENVPARAMETERSI4IVNVPROC GLeeFuncPtr_glProgramEnvParametersI4ivNV=GLee_Lazy_glProgramEnvParametersI4ivNV;
#endif
#ifndef GLEE_C_DEFINED_glProgramEnvParameterI4uiNV
#define GLEE_C_DEFINED_glProgramEnvParameterI4uiNV
  GLvoid __stdcall GLee_Lazy_glProgramEnvParameterI4uiNV(GLenum target, GLuint index, GLuint x, GLuint y, GLuint z, GLuint w)  {if (GLeeInit()) glProgramEnvParameterI4uiNV(target, index, x, y, z, w);}
  GLEEPFNGLPROGRAMENVPARAMETERI4UINVPROC GLeeFuncPtr_glProgramEnvParameterI4uiNV=GLee_Lazy_glProgramEnvParameterI4uiNV;
#endif
#ifndef GLEE_C_DEFINED_glProgramEnvParameterI4uivNV
#define GLEE_C_DEFINED_glProgramEnvParameterI4uivNV
  GLvoid __stdcall GLee_Lazy_glProgramEnvParameterI4uivNV(GLenum target, GLuint index, const GLuint * params)  {if (GLeeInit()) glProgramEnvParameterI4uivNV(target, index, params);}
  GLEEPFNGLPROGRAMENVPARAMETERI4UIVNVPROC GLeeFuncPtr_glProgramEnvParameterI4uivNV=GLee_Lazy_glProgramEnvParameterI4uivNV;
#endif
#ifndef GLEE_C_DEFINED_glProgramEnvParametersI4uivNV
#define GLEE_C_DEFINED_glProgramEnvParametersI4uivNV
  GLvoid __stdcall GLee_Lazy_glProgramEnvParametersI4uivNV(GLenum target, GLuint index, GLsizei count, const GLuint * params)  {if (GLeeInit()) glProgramEnvParametersI4uivNV(target, index, count, params);}
  GLEEPFNGLPROGRAMENVPARAMETERSI4UIVNVPROC GLeeFuncPtr_glProgramEnvParametersI4uivNV=GLee_Lazy_glProgramEnvParametersI4uivNV;
#endif
#ifndef GLEE_C_DEFINED_glGetProgramLocalParameterIivNV
#define GLEE_C_DEFINED_glGetProgramLocalParameterIivNV
  GLvoid __stdcall GLee_Lazy_glGetProgramLocalParameterIivNV(GLenum target, GLuint index, GLint * params)  {if (GLeeInit()) glGetProgramLocalParameterIivNV(target, index, params);}
  GLEEPFNGLGETPROGRAMLOCALPARAMETERIIVNVPROC GLeeFuncPtr_glGetProgramLocalParameterIivNV=GLee_Lazy_glGetProgramLocalParameterIivNV;
#endif
#ifndef GLEE_C_DEFINED_glGetProgramLocalParameterIuivNV
#define GLEE_C_DEFINED_glGetProgramLocalParameterIuivNV
  GLvoid __stdcall GLee_Lazy_glGetProgramLocalParameterIuivNV(GLenum target, GLuint index, GLuint * params)  {if (GLeeInit()) glGetProgramLocalParameterIuivNV(target, index, params);}
  GLEEPFNGLGETPROGRAMLOCALPARAMETERIUIVNVPROC GLeeFuncPtr_glGetProgramLocalParameterIuivNV=GLee_Lazy_glGetProgramLocalParameterIuivNV;
#endif
#ifndef GLEE_C_DEFINED_glGetProgramEnvParameterIivNV
#define GLEE_C_DEFINED_glGetProgramEnvParameterIivNV
  GLvoid __stdcall GLee_Lazy_glGetProgramEnvParameterIivNV(GLenum target, GLuint index, GLint * params)  {if (GLeeInit()) glGetProgramEnvParameterIivNV(target, index, params);}
  GLEEPFNGLGETPROGRAMENVPARAMETERIIVNVPROC GLeeFuncPtr_glGetProgramEnvParameterIivNV=GLee_Lazy_glGetProgramEnvParameterIivNV;
#endif
#ifndef GLEE_C_DEFINED_glGetProgramEnvParameterIuivNV
#define GLEE_C_DEFINED_glGetProgramEnvParameterIuivNV
  GLvoid __stdcall GLee_Lazy_glGetProgramEnvParameterIuivNV(GLenum target, GLuint index, GLuint * params)  {if (GLeeInit()) glGetProgramEnvParameterIuivNV(target, index, params);}
  GLEEPFNGLGETPROGRAMENVPARAMETERIUIVNVPROC GLeeFuncPtr_glGetProgramEnvParameterIuivNV=GLee_Lazy_glGetProgramEnvParameterIuivNV;
#endif
#ifndef GLEE_C_DEFINED_glFramebufferTextureEXT
#define GLEE_C_DEFINED_glFramebufferTextureEXT
  GLvoid __stdcall GLee_Lazy_glFramebufferTextureEXT(GLenum target, GLenum attachment, GLuint texture, GLint level)  {if (GLeeInit()) glFramebufferTextureEXT(target, attachment, texture, level);}
  GLEEPFNGLFRAMEBUFFERTEXTUREEXTPROC GLeeFuncPtr_glFramebufferTextureEXT=GLee_Lazy_glFramebufferTextureEXT;
#endif
#ifndef GLEE_C_DEFINED_glFramebufferTextureLayerEXT
#define GLEE_C_DEFINED_glFramebufferTextureLayerEXT
  GLvoid __stdcall GLee_Lazy_glFramebufferTextureLayerEXT(GLenum target, GLenum attachment, GLuint texture, GLint level, GLint layer)  {if (GLeeInit()) glFramebufferTextureLayerEXT(target, attachment, texture, level, layer);}
  GLEEPFNGLFRAMEBUFFERTEXTURELAYEREXTPROC GLeeFuncPtr_glFramebufferTextureLayerEXT=GLee_Lazy_glFramebufferTextureLayerEXT;
#endif
#ifndef GLEE_C_DEFINED_glFramebufferTextureFaceEXT
#define GLEE_C_DEFINED_glFramebufferTextureFaceEXT
  GLvoid __stdcall GLee_Lazy_glFramebufferTextureFaceEXT(GLenum target, GLenum attachment, GLuint texture, GLint level, GLenum face)  {if (GLeeInit()) glFramebufferTextureFaceEXT(target, attachment, texture, level, face);}
  GLEEPFNGLFRAMEBUFFERTEXTUREFACEEXTPROC GLeeFuncPtr_glFramebufferTextureFaceEXT=GLee_Lazy_glFramebufferTextureFaceEXT;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttribI2iEXT
#define GLEE_C_DEFINED_glVertexAttribI2iEXT
  GLvoid __stdcall GLee_Lazy_glVertexAttribI2iEXT(GLuint index, GLint x, GLint y)  {if (GLeeInit()) glVertexAttribI2iEXT(index, x, y);}
  GLEEPFNGLVERTEXATTRIBI2IEXTPROC GLeeFuncPtr_glVertexAttribI2iEXT=GLee_Lazy_glVertexAttribI2iEXT;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttribI3iEXT
#define GLEE_C_DEFINED_glVertexAttribI3iEXT
  GLvoid __stdcall GLee_Lazy_glVertexAttribI3iEXT(GLuint index, GLint x, GLint y, GLint z)  {if (GLeeInit()) glVertexAttribI3iEXT(index, x, y, z);}
  GLEEPFNGLVERTEXATTRIBI3IEXTPROC GLeeFuncPtr_glVertexAttribI3iEXT=GLee_Lazy_glVertexAttribI3iEXT;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttribI4iEXT
#define GLEE_C_DEFINED_glVertexAttribI4iEXT
  GLvoid __stdcall GLee_Lazy_glVertexAttribI4iEXT(GLuint index, GLint x, GLint y, GLint z, GLint w)  {if (GLeeInit()) glVertexAttribI4iEXT(index, x, y, z, w);}
  GLEEPFNGLVERTEXATTRIBI4IEXTPROC GLeeFuncPtr_glVertexAttribI4iEXT=GLee_Lazy_glVertexAttribI4iEXT;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttribI1uiEXT
#define GLEE_C_DEFINED_glVertexAttribI1uiEXT
  GLvoid __stdcall GLee_Lazy_glVertexAttribI1uiEXT(GLuint index, GLuint x)  {if (GLeeInit()) glVertexAttribI1uiEXT(index, x);}
  GLEEPFNGLVERTEXATTRIBI1UIEXTPROC GLeeFuncPtr_glVertexAttribI1uiEXT=GLee_Lazy_glVertexAttribI1uiEXT;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttribI2uiEXT
#define GLEE_C_DEFINED_glVertexAttribI2uiEXT
  GLvoid __stdcall GLee_Lazy_glVertexAttribI2uiEXT(GLuint index, GLuint x, GLuint y)  {if (GLeeInit()) glVertexAttribI2uiEXT(index, x, y);}
  GLEEPFNGLVERTEXATTRIBI2UIEXTPROC GLeeFuncPtr_glVertexAttribI2uiEXT=GLee_Lazy_glVertexAttribI2uiEXT;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttribI3uiEXT
#define GLEE_C_DEFINED_glVertexAttribI3uiEXT
  GLvoid __stdcall GLee_Lazy_glVertexAttribI3uiEXT(GLuint index, GLuint x, GLuint y, GLuint z)  {if (GLeeInit()) glVertexAttribI3uiEXT(index, x, y, z);}
  GLEEPFNGLVERTEXATTRIBI3UIEXTPROC GLeeFuncPtr_glVertexAttribI3uiEXT=GLee_Lazy_glVertexAttribI3uiEXT;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttribI4uiEXT
#define GLEE_C_DEFINED_glVertexAttribI4uiEXT
  GLvoid __stdcall GLee_Lazy_glVertexAttribI4uiEXT(GLuint index, GLuint x, GLuint y, GLuint z, GLuint w)  {if (GLeeInit()) glVertexAttribI4uiEXT(index, x, y, z, w);}
  GLEEPFNGLVERTEXATTRIBI4UIEXTPROC GLeeFuncPtr_glVertexAttribI4uiEXT=GLee_Lazy_glVertexAttribI4uiEXT;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttribI1ivEXT
#define GLEE_C_DEFINED_glVertexAttribI1ivEXT
  GLvoid __stdcall GLee_Lazy_glVertexAttribI1ivEXT(GLuint index, const GLint * v)  {if (GLeeInit()) glVertexAttribI1ivEXT(index, v);}
  GLEEPFNGLVERTEXATTRIBI1IVEXTPROC GLeeFuncPtr_glVertexAttribI1ivEXT=GLee_Lazy_glVertexAttribI1ivEXT;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttribI2ivEXT
#define GLEE_C_DEFINED_glVertexAttribI2ivEXT
  GLvoid __stdcall GLee_Lazy_glVertexAttribI2ivEXT(GLuint index, const GLint * v)  {if (GLeeInit()) glVertexAttribI2ivEXT(index, v);}
  GLEEPFNGLVERTEXATTRIBI2IVEXTPROC GLeeFuncPtr_glVertexAttribI2ivEXT=GLee_Lazy_glVertexAttribI2ivEXT;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttribI3ivEXT
#define GLEE_C_DEFINED_glVertexAttribI3ivEXT
  GLvoid __stdcall GLee_Lazy_glVertexAttribI3ivEXT(GLuint index, const GLint * v)  {if (GLeeInit()) glVertexAttribI3ivEXT(index, v);}
  GLEEPFNGLVERTEXATTRIBI3IVEXTPROC GLeeFuncPtr_glVertexAttribI3ivEXT=GLee_Lazy_glVertexAttribI3ivEXT;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttribI4ivEXT
#define GLEE_C_DEFINED_glVertexAttribI4ivEXT
  GLvoid __stdcall GLee_Lazy_glVertexAttribI4ivEXT(GLuint index, const GLint * v)  {if (GLeeInit()) glVertexAttribI4ivEXT(index, v);}
  GLEEPFNGLVERTEXATTRIBI4IVEXTPROC GLeeFuncPtr_glVertexAttribI4ivEXT=GLee_Lazy_glVertexAttribI4ivEXT;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttribI1uivEXT
#define GLEE_C_DEFINED_glVertexAttribI1uivEXT
  GLvoid __stdcall GLee_Lazy_glVertexAttribI1uivEXT(GLuint index, const GLuint * v)  {if (GLeeInit()) glVertexAttribI1uivEXT(index, v);}
  GLEEPFNGLVERTEXATTRIBI1UIVEXTPROC GLeeFuncPtr_glVertexAttribI1uivEXT=GLee_Lazy_glVertexAttribI1uivEXT;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttribI2uivEXT
#define GLEE_C_DEFINED_glVertexAttribI2uivEXT
  GLvoid __stdcall GLee_Lazy_glVertexAttribI2uivEXT(GLuint index, const GLuint * v)  {if (GLeeInit()) glVertexAttribI2uivEXT(index, v);}
  GLEEPFNGLVERTEXATTRIBI2UIVEXTPROC GLeeFuncPtr_glVertexAttribI2uivEXT=GLee_Lazy_glVertexAttribI2uivEXT;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttribI3uivEXT
#define GLEE_C_DEFINED_glVertexAttribI3uivEXT
  GLvoid __stdcall GLee_Lazy_glVertexAttribI3uivEXT(GLuint index, const GLuint * v)  {if (GLeeInit()) glVertexAttribI3uivEXT(index, v);}
  GLEEPFNGLVERTEXATTRIBI3UIVEXTPROC GLeeFuncPtr_glVertexAttribI3uivEXT=GLee_Lazy_glVertexAttribI3uivEXT;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttribI4uivEXT
#define GLEE_C_DEFINED_glVertexAttribI4uivEXT
  GLvoid __stdcall GLee_Lazy_glVertexAttribI4uivEXT(GLuint index, const GLuint * v)  {if (GLeeInit()) glVertexAttribI4uivEXT(index, v);}
  GLEEPFNGLVERTEXATTRIBI4UIVEXTPROC GLeeFuncPtr_glVertexAttribI4uivEXT=GLee_Lazy_glVertexAttribI4uivEXT;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttribI4bvEXT
#define GLEE_C_DEFINED_glVertexAttribI4bvEXT
  GLvoid __stdcall GLee_Lazy_glVertexAttribI4bvEXT(GLuint index, const GLbyte * v)  {if (GLeeInit()) glVertexAttribI4bvEXT(index, v);}
  GLEEPFNGLVERTEXATTRIBI4BVEXTPROC GLeeFuncPtr_glVertexAttribI4bvEXT=GLee_Lazy_glVertexAttribI4bvEXT;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttribI4svEXT
#define GLEE_C_DEFINED_glVertexAttribI4svEXT
  GLvoid __stdcall GLee_Lazy_glVertexAttribI4svEXT(GLuint index, const GLshort * v)  {if (GLeeInit()) glVertexAttribI4svEXT(index, v);}
  GLEEPFNGLVERTEXATTRIBI4SVEXTPROC GLeeFuncPtr_glVertexAttribI4svEXT=GLee_Lazy_glVertexAttribI4svEXT;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttribI4ubvEXT
#define GLEE_C_DEFINED_glVertexAttribI4ubvEXT
  GLvoid __stdcall GLee_Lazy_glVertexAttribI4ubvEXT(GLuint index, const GLubyte * v)  {if (GLeeInit()) glVertexAttribI4ubvEXT(index, v);}
  GLEEPFNGLVERTEXATTRIBI4UBVEXTPROC GLeeFuncPtr_glVertexAttribI4ubvEXT=GLee_Lazy_glVertexAttribI4ubvEXT;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttribI4usvEXT
#define GLEE_C_DEFINED_glVertexAttribI4usvEXT
  GLvoid __stdcall GLee_Lazy_glVertexAttribI4usvEXT(GLuint index, const GLushort * v)  {if (GLeeInit()) glVertexAttribI4usvEXT(index, v);}
  GLEEPFNGLVERTEXATTRIBI4USVEXTPROC GLeeFuncPtr_glVertexAttribI4usvEXT=GLee_Lazy_glVertexAttribI4usvEXT;
#endif
#ifndef GLEE_C_DEFINED_glVertexAttribIPointerEXT
#define GLEE_C_DEFINED_glVertexAttribIPointerEXT
  GLvoid __stdcall GLee_Lazy_glVertexAttribIPointerEXT(GLuint index, GLint size, GLenum type, GLsizei stride, const GLvoid * pointer)  {if (GLeeInit()) glVertexAttribIPointerEXT(index, size, type, stride, pointer);}
  GLEEPFNGLVERTEXATTRIBIPOINTEREXTPROC GLeeFuncPtr_glVertexAttribIPointerEXT=GLee_Lazy_glVertexAttribIPointerEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetVertexAttribIivEXT
#define GLEE_C_DEFINED_glGetVertexAttribIivEXT
  GLvoid __stdcall GLee_Lazy_glGetVertexAttribIivEXT(GLuint index, GLenum pname, GLint * params)  {if (GLeeInit()) glGetVertexAttribIivEXT(index, pname, params);}
  GLEEPFNGLGETVERTEXATTRIBIIVEXTPROC GLeeFuncPtr_glGetVertexAttribIivEXT=GLee_Lazy_glGetVertexAttribIivEXT;
#endif
#ifndef GLEE_C_DEFINED_glGetVertexAttribIuivEXT
#define GLEE_C_DEFINED_glGetVertexAttribIuivEXT
  GLvoid __stdcall GLee_Lazy_glGetVertexAttribIuivEXT(GLuint index, GLenum pname, GLuint * params)  {if (GLeeInit()) glGetVertexAttribIuivEXT(index, pname, params);}
  GLEEPFNGLGETVERTEXATTRIBIUIVEXTPROC GLeeFuncPtr_glGetVertexAttribIuivEXT=GLee_Lazy_glGetVertexAttribIuivEXT;
#endif
#endif 

/* GL_OES_byte_coordinates */

#ifdef __GLEE_GL_OES_byte_coordinates
#endif 

/* GL_OES_compressed_paletted_texture */

#ifdef __GLEE_GL_OES_compressed_paletted_texture
#endif 

/* GL_OES_single_precision */

#ifdef __GLEE_GL_OES_single_precision
#ifndef GLEE_C_DEFINED_glDepthRangefOES
#define GLEE_C_DEFINED_glDepthRangefOES
  GLvoid __stdcall GLee_Lazy_glDepthRangefOES(GLclampf n, GLclampf f)  {if (GLeeInit()) glDepthRangefOES(n, f);}
  GLEEPFNGLDEPTHRANGEFOESPROC GLeeFuncPtr_glDepthRangefOES=GLee_Lazy_glDepthRangefOES;
#endif
#ifndef GLEE_C_DEFINED_glFrustumfOES
#define GLEE_C_DEFINED_glFrustumfOES
  GLvoid __stdcall GLee_Lazy_glFrustumfOES(GLfloat l, GLfloat r, GLfloat b, GLfloat t, GLfloat n, GLfloat f)  {if (GLeeInit()) glFrustumfOES(l, r, b, t, n, f);}
  GLEEPFNGLFRUSTUMFOESPROC GLeeFuncPtr_glFrustumfOES=GLee_Lazy_glFrustumfOES;
#endif
#ifndef GLEE_C_DEFINED_glOrthofOES
#define GLEE_C_DEFINED_glOrthofOES
  GLvoid __stdcall GLee_Lazy_glOrthofOES(GLfloat l, GLfloat r, GLfloat b, GLfloat t, GLfloat n, GLfloat f)  {if (GLeeInit()) glOrthofOES(l, r, b, t, n, f);}
  GLEEPFNGLORTHOFOESPROC GLeeFuncPtr_glOrthofOES=GLee_Lazy_glOrthofOES;
#endif
#ifndef GLEE_C_DEFINED_glClipPlanefOES
#define GLEE_C_DEFINED_glClipPlanefOES
  GLvoid __stdcall GLee_Lazy_glClipPlanefOES(GLenum plane, const GLfloat* equation)  {if (GLeeInit()) glClipPlanefOES(plane, equation);}
  GLEEPFNGLCLIPPLANEFOESPROC GLeeFuncPtr_glClipPlanefOES=GLee_Lazy_glClipPlanefOES;
#endif
#ifndef GLEE_C_DEFINED_glGetClipPlanefOES
#define GLEE_C_DEFINED_glGetClipPlanefOES
  GLvoid __stdcall GLee_Lazy_glGetClipPlanefOES(GLenum plane, GLfloat* equation)  {if (GLeeInit()) glGetClipPlanefOES(plane, equation);}
  GLEEPFNGLGETCLIPPLANEFOESPROC GLeeFuncPtr_glGetClipPlanefOES=GLee_Lazy_glGetClipPlanefOES;
#endif
#ifndef GL_VERSION_ES_CM_1_1
#ifndef GLEE_C_DEFINED_glClearDepthfOES
#define GLEE_C_DEFINED_glClearDepthfOES
  GLvoid __stdcall GLee_Lazy_glClearDepthfOES(GLclampd depth)  {if (GLeeInit()) glClearDepthfOES(depth);}
  GLEEPFNGLCLEARDEPTHFOESPROC GLeeFuncPtr_glClearDepthfOES=GLee_Lazy_glClearDepthfOES;
#endif
#endif 
#endif 

/* GL_SGIX_pixel_texture_bits */

#ifdef __GLEE_GL_SGIX_pixel_texture_bits
#endif 

/* GL_SGIX_texture_range */

#ifdef __GLEE_GL_SGIX_texture_range
#endif 

/* WGL */

#ifdef WIN32

/* Extension querying variables */

GLboolean _GLEE_WGL_ARB_buffer_region = GL_FALSE;
GLboolean _GLEE_WGL_ARB_multisample = GL_FALSE;
GLboolean _GLEE_WGL_ARB_extensions_string = GL_FALSE;
GLboolean _GLEE_WGL_ARB_pixel_format = GL_FALSE;
GLboolean _GLEE_WGL_ARB_make_current_read = GL_FALSE;
GLboolean _GLEE_WGL_ARB_pbuffer = GL_FALSE;
GLboolean _GLEE_WGL_ARB_render_texture = GL_FALSE;
GLboolean _GLEE_WGL_ARB_pixel_format_float = GL_FALSE;
GLboolean _GLEE_WGL_ARB_create_context = GL_FALSE;
GLboolean _GLEE_WGL_EXT_make_current_read = GL_FALSE;
GLboolean _GLEE_WGL_EXT_pixel_format = GL_FALSE;
GLboolean _GLEE_WGL_EXT_pbuffer = GL_FALSE;
GLboolean _GLEE_WGL_EXT_depth_float = GL_FALSE;
GLboolean _GLEE_WGL_3DFX_multisample = GL_FALSE;
GLboolean _GLEE_WGL_EXT_multisample = GL_FALSE;
GLboolean _GLEE_WGL_I3D_digital_video_control = GL_FALSE;
GLboolean _GLEE_WGL_I3D_gamma = GL_FALSE;
GLboolean _GLEE_WGL_I3D_genlock = GL_FALSE;
GLboolean _GLEE_WGL_I3D_image_buffer = GL_FALSE;
GLboolean _GLEE_WGL_I3D_swap_frame_lock = GL_FALSE;
GLboolean _GLEE_WGL_NV_render_depth_texture = GL_FALSE;
GLboolean _GLEE_WGL_NV_render_texture_rectangle = GL_FALSE;
GLboolean _GLEE_WGL_ATI_pixel_format_float = GL_FALSE;
GLboolean _GLEE_WGL_NV_float_buffer = GL_FALSE;
GLboolean _GLEE_WGL_3DL_stereo_control = GL_FALSE;
GLboolean _GLEE_WGL_EXT_pixel_format_packed_float = GL_FALSE;
GLboolean _GLEE_WGL_EXT_framebuffer_sRGB = GL_FALSE;
GLboolean _GLEE_WGL_NV_present_video = GL_FALSE;
GLboolean _GLEE_WGL_NV_swap_group = GL_FALSE;
GLboolean _GLEE_WGL_NV_gpu_affinity = GL_FALSE;
GLboolean _GLEE_WGL_EXT_display_color_table = GL_FALSE;
GLboolean _GLEE_WGL_EXT_extensions_string = GL_FALSE;
GLboolean _GLEE_WGL_EXT_swap_control = GL_FALSE;
GLboolean _GLEE_WGL_NV_vertex_array_range = GL_FALSE;
GLboolean _GLEE_WGL_OML_sync_control = GL_FALSE;
GLboolean _GLEE_WGL_I3D_swap_frame_usage = GL_FALSE;
GLboolean _GLEE_WGL_NV_video_output = GL_FALSE;

/*  WGL Extension names */

char __GLeeWGLExtensionNames[37][34]={
    "WGL_ARB_buffer_region",
    "WGL_ARB_multisample",
    "WGL_ARB_extensions_string",
    "WGL_ARB_pixel_format",
    "WGL_ARB_make_current_read",
    "WGL_ARB_pbuffer",
    "WGL_ARB_render_texture",
    "WGL_ARB_pixel_format_float",
    "WGL_ARB_create_context",
    "WGL_EXT_make_current_read",
    "WGL_EXT_pixel_format",
    "WGL_EXT_pbuffer",
    "WGL_EXT_depth_float",
    "WGL_3DFX_multisample",
    "WGL_EXT_multisample",
    "WGL_I3D_digital_video_control",
    "WGL_I3D_gamma",
    "WGL_I3D_genlock",
    "WGL_I3D_image_buffer",
    "WGL_I3D_swap_frame_lock",
    "WGL_NV_render_depth_texture",
    "WGL_NV_render_texture_rectangle",
    "WGL_ATI_pixel_format_float",
    "WGL_NV_float_buffer",
    "WGL_3DL_stereo_control",
    "WGL_EXT_pixel_format_packed_float",
    "WGL_EXT_framebuffer_sRGB",
    "WGL_NV_present_video",
    "WGL_NV_swap_group",
    "WGL_NV_gpu_affinity",
    "WGL_EXT_display_color_table",
    "WGL_EXT_extensions_string",
    "WGL_EXT_swap_control",
    "WGL_NV_vertex_array_range",
    "WGL_OML_sync_control",
    "WGL_I3D_swap_frame_usage",
    "WGL_NV_video_output"
};
int __GLeeWGLNumExtensions=37;

/* WGL_ARB_buffer_region */

#ifdef __GLEE_WGL_ARB_buffer_region
#ifndef GLEE_C_DEFINED_wglCreateBufferRegionARB
#define GLEE_C_DEFINED_wglCreateBufferRegionARB
  HANDLE __stdcall GLee_Lazy_wglCreateBufferRegionARB(HDC hDC, int iLayerPlane, UINT uType)  {if (GLeeInit()) return wglCreateBufferRegionARB(hDC, iLayerPlane, uType); return (HANDLE)0;}
  GLEEPFNWGLCREATEBUFFERREGIONARBPROC GLeeFuncPtr_wglCreateBufferRegionARB=GLee_Lazy_wglCreateBufferRegionARB;
#endif
#ifndef GLEE_C_DEFINED_wglDeleteBufferRegionARB
#define GLEE_C_DEFINED_wglDeleteBufferRegionARB
  VOID __stdcall GLee_Lazy_wglDeleteBufferRegionARB(HANDLE hRegion)  {if (GLeeInit()) wglDeleteBufferRegionARB(hRegion);}
  GLEEPFNWGLDELETEBUFFERREGIONARBPROC GLeeFuncPtr_wglDeleteBufferRegionARB=GLee_Lazy_wglDeleteBufferRegionARB;
#endif
#ifndef GLEE_C_DEFINED_wglSaveBufferRegionARB
#define GLEE_C_DEFINED_wglSaveBufferRegionARB
  BOOL __stdcall GLee_Lazy_wglSaveBufferRegionARB(HANDLE hRegion, int x, int y, int width, int height)  {if (GLeeInit()) return wglSaveBufferRegionARB(hRegion, x, y, width, height); return (BOOL)0;}
  GLEEPFNWGLSAVEBUFFERREGIONARBPROC GLeeFuncPtr_wglSaveBufferRegionARB=GLee_Lazy_wglSaveBufferRegionARB;
#endif
#ifndef GLEE_C_DEFINED_wglRestoreBufferRegionARB
#define GLEE_C_DEFINED_wglRestoreBufferRegionARB
  BOOL __stdcall GLee_Lazy_wglRestoreBufferRegionARB(HANDLE hRegion, int x, int y, int width, int height, int xSrc, int ySrc)  {if (GLeeInit()) return wglRestoreBufferRegionARB(hRegion, x, y, width, height, xSrc, ySrc); return (BOOL)0;}
  GLEEPFNWGLRESTOREBUFFERREGIONARBPROC GLeeFuncPtr_wglRestoreBufferRegionARB=GLee_Lazy_wglRestoreBufferRegionARB;
#endif
#endif 

/* WGL_ARB_multisample */

#ifdef __GLEE_WGL_ARB_multisample
#endif 

/* WGL_ARB_extensions_string */

#ifdef __GLEE_WGL_ARB_extensions_string
#ifndef GLEE_C_DEFINED_wglGetExtensionsStringARB
#define GLEE_C_DEFINED_wglGetExtensionsStringARB
  const char * __stdcall GLee_Lazy_wglGetExtensionsStringARB(HDC hdc)  {if (GLeeInit()) return wglGetExtensionsStringARB(hdc); return (const char *)0;}
  GLEEPFNWGLGETEXTENSIONSSTRINGARBPROC GLeeFuncPtr_wglGetExtensionsStringARB=GLee_Lazy_wglGetExtensionsStringARB;
#endif
#endif 

/* WGL_ARB_pixel_format */

#ifdef __GLEE_WGL_ARB_pixel_format
#ifndef GLEE_C_DEFINED_wglGetPixelFormatAttribivARB
#define GLEE_C_DEFINED_wglGetPixelFormatAttribivARB
  BOOL __stdcall GLee_Lazy_wglGetPixelFormatAttribivARB(HDC hdc, int iPixelFormat, int iLayerPlane, UINT nAttributes, const int * piAttributes, int * piValues)  {if (GLeeInit()) return wglGetPixelFormatAttribivARB(hdc, iPixelFormat, iLayerPlane, nAttributes, piAttributes, piValues); return (BOOL)0;}
  GLEEPFNWGLGETPIXELFORMATATTRIBIVARBPROC GLeeFuncPtr_wglGetPixelFormatAttribivARB=GLee_Lazy_wglGetPixelFormatAttribivARB;
#endif
#ifndef GLEE_C_DEFINED_wglGetPixelFormatAttribfvARB
#define GLEE_C_DEFINED_wglGetPixelFormatAttribfvARB
  BOOL __stdcall GLee_Lazy_wglGetPixelFormatAttribfvARB(HDC hdc, int iPixelFormat, int iLayerPlane, UINT nAttributes, const int * piAttributes, FLOAT * pfValues)  {if (GLeeInit()) return wglGetPixelFormatAttribfvARB(hdc, iPixelFormat, iLayerPlane, nAttributes, piAttributes, pfValues); return (BOOL)0;}
  GLEEPFNWGLGETPIXELFORMATATTRIBFVARBPROC GLeeFuncPtr_wglGetPixelFormatAttribfvARB=GLee_Lazy_wglGetPixelFormatAttribfvARB;
#endif
#ifndef GLEE_C_DEFINED_wglChoosePixelFormatARB
#define GLEE_C_DEFINED_wglChoosePixelFormatARB
  BOOL __stdcall GLee_Lazy_wglChoosePixelFormatARB(HDC hdc, const int * piAttribIList, const FLOAT * pfAttribFList, UINT nMaxFormats, int * piFormats, UINT * nNumFormats)  {if (GLeeInit()) return wglChoosePixelFormatARB(hdc, piAttribIList, pfAttribFList, nMaxFormats, piFormats, nNumFormats); return (BOOL)0;}
  GLEEPFNWGLCHOOSEPIXELFORMATARBPROC GLeeFuncPtr_wglChoosePixelFormatARB=GLee_Lazy_wglChoosePixelFormatARB;
#endif
#endif 

/* WGL_ARB_make_current_read */

#ifdef __GLEE_WGL_ARB_make_current_read
#ifndef GLEE_C_DEFINED_wglMakeContextCurrentARB
#define GLEE_C_DEFINED_wglMakeContextCurrentARB
  BOOL __stdcall GLee_Lazy_wglMakeContextCurrentARB(HDC hDrawDC, HDC hReadDC, HGLRC hglrc)  {if (GLeeInit()) return wglMakeContextCurrentARB(hDrawDC, hReadDC, hglrc); return (BOOL)0;}
  GLEEPFNWGLMAKECONTEXTCURRENTARBPROC GLeeFuncPtr_wglMakeContextCurrentARB=GLee_Lazy_wglMakeContextCurrentARB;
#endif
#ifndef GLEE_C_DEFINED_wglGetCurrentReadDCARB
#define GLEE_C_DEFINED_wglGetCurrentReadDCARB
  HDC __stdcall GLee_Lazy_wglGetCurrentReadDCARB(void)  {if (GLeeInit()) return wglGetCurrentReadDCARB(); return (HDC)0;}
  GLEEPFNWGLGETCURRENTREADDCARBPROC GLeeFuncPtr_wglGetCurrentReadDCARB=GLee_Lazy_wglGetCurrentReadDCARB;
#endif
#endif 

/* WGL_ARB_pbuffer */

#ifdef __GLEE_WGL_ARB_pbuffer
#ifndef GLEE_C_DEFINED_wglCreatePbufferARB
#define GLEE_C_DEFINED_wglCreatePbufferARB
  HPBUFFERARB __stdcall GLee_Lazy_wglCreatePbufferARB(HDC hDC, int iPixelFormat, int iWidth, int iHeight, const int * piAttribList)  {if (GLeeInit()) return wglCreatePbufferARB(hDC, iPixelFormat, iWidth, iHeight, piAttribList); return (HPBUFFERARB)0;}
  GLEEPFNWGLCREATEPBUFFERARBPROC GLeeFuncPtr_wglCreatePbufferARB=GLee_Lazy_wglCreatePbufferARB;
#endif
#ifndef GLEE_C_DEFINED_wglGetPbufferDCARB
#define GLEE_C_DEFINED_wglGetPbufferDCARB
  HDC __stdcall GLee_Lazy_wglGetPbufferDCARB(HPBUFFERARB hPbuffer)  {if (GLeeInit()) return wglGetPbufferDCARB(hPbuffer); return (HDC)0;}
  GLEEPFNWGLGETPBUFFERDCARBPROC GLeeFuncPtr_wglGetPbufferDCARB=GLee_Lazy_wglGetPbufferDCARB;
#endif
#ifndef GLEE_C_DEFINED_wglReleasePbufferDCARB
#define GLEE_C_DEFINED_wglReleasePbufferDCARB
  int __stdcall GLee_Lazy_wglReleasePbufferDCARB(HPBUFFERARB hPbuffer, HDC hDC)  {if (GLeeInit()) return wglReleasePbufferDCARB(hPbuffer, hDC); return (int)0;}
  GLEEPFNWGLRELEASEPBUFFERDCARBPROC GLeeFuncPtr_wglReleasePbufferDCARB=GLee_Lazy_wglReleasePbufferDCARB;
#endif
#ifndef GLEE_C_DEFINED_wglDestroyPbufferARB
#define GLEE_C_DEFINED_wglDestroyPbufferARB
  BOOL __stdcall GLee_Lazy_wglDestroyPbufferARB(HPBUFFERARB hPbuffer)  {if (GLeeInit()) return wglDestroyPbufferARB(hPbuffer); return (BOOL)0;}
  GLEEPFNWGLDESTROYPBUFFERARBPROC GLeeFuncPtr_wglDestroyPbufferARB=GLee_Lazy_wglDestroyPbufferARB;
#endif
#ifndef GLEE_C_DEFINED_wglQueryPbufferARB
#define GLEE_C_DEFINED_wglQueryPbufferARB
  BOOL __stdcall GLee_Lazy_wglQueryPbufferARB(HPBUFFERARB hPbuffer, int iAttribute, int * piValue)  {if (GLeeInit()) return wglQueryPbufferARB(hPbuffer, iAttribute, piValue); return (BOOL)0;}
  GLEEPFNWGLQUERYPBUFFERARBPROC GLeeFuncPtr_wglQueryPbufferARB=GLee_Lazy_wglQueryPbufferARB;
#endif
#endif 

/* WGL_ARB_render_texture */

#ifdef __GLEE_WGL_ARB_render_texture
#ifndef GLEE_C_DEFINED_wglBindTexImageARB
#define GLEE_C_DEFINED_wglBindTexImageARB
  BOOL __stdcall GLee_Lazy_wglBindTexImageARB(HPBUFFERARB hPbuffer, int iBuffer)  {if (GLeeInit()) return wglBindTexImageARB(hPbuffer, iBuffer); return (BOOL)0;}
  GLEEPFNWGLBINDTEXIMAGEARBPROC GLeeFuncPtr_wglBindTexImageARB=GLee_Lazy_wglBindTexImageARB;
#endif
#ifndef GLEE_C_DEFINED_wglReleaseTexImageARB
#define GLEE_C_DEFINED_wglReleaseTexImageARB
  BOOL __stdcall GLee_Lazy_wglReleaseTexImageARB(HPBUFFERARB hPbuffer, int iBuffer)  {if (GLeeInit()) return wglReleaseTexImageARB(hPbuffer, iBuffer); return (BOOL)0;}
  GLEEPFNWGLRELEASETEXIMAGEARBPROC GLeeFuncPtr_wglReleaseTexImageARB=GLee_Lazy_wglReleaseTexImageARB;
#endif
#ifndef GLEE_C_DEFINED_wglSetPbufferAttribARB
#define GLEE_C_DEFINED_wglSetPbufferAttribARB
  BOOL __stdcall GLee_Lazy_wglSetPbufferAttribARB(HPBUFFERARB hPbuffer, const int * piAttribList)  {if (GLeeInit()) return wglSetPbufferAttribARB(hPbuffer, piAttribList); return (BOOL)0;}
  GLEEPFNWGLSETPBUFFERATTRIBARBPROC GLeeFuncPtr_wglSetPbufferAttribARB=GLee_Lazy_wglSetPbufferAttribARB;
#endif
#endif 

/* WGL_ARB_pixel_format_float */

#ifdef __GLEE_WGL_ARB_pixel_format_float
#endif 

/* WGL_ARB_create_context */

#ifdef __GLEE_WGL_ARB_create_context
#ifndef GLEE_C_DEFINED_wglCreateContextAttribsARB
#define GLEE_C_DEFINED_wglCreateContextAttribsARB
  HGLRC __stdcall GLee_Lazy_wglCreateContextAttribsARB(HDC hDC, HGLRC hShareContext, const int * attribList)  {if (GLeeInit()) return wglCreateContextAttribsARB(hDC, hShareContext, attribList); return (HGLRC)0;}
  GLEEPFNWGLCREATECONTEXTATTRIBSARBPROC GLeeFuncPtr_wglCreateContextAttribsARB=GLee_Lazy_wglCreateContextAttribsARB;
#endif
#endif 

/* WGL_EXT_make_current_read */

#ifdef __GLEE_WGL_EXT_make_current_read
#ifndef GLEE_C_DEFINED_wglMakeContextCurrentEXT
#define GLEE_C_DEFINED_wglMakeContextCurrentEXT
  BOOL __stdcall GLee_Lazy_wglMakeContextCurrentEXT(HDC hDrawDC, HDC hReadDC, HGLRC hglrc)  {if (GLeeInit()) return wglMakeContextCurrentEXT(hDrawDC, hReadDC, hglrc); return (BOOL)0;}
  GLEEPFNWGLMAKECONTEXTCURRENTEXTPROC GLeeFuncPtr_wglMakeContextCurrentEXT=GLee_Lazy_wglMakeContextCurrentEXT;
#endif
#ifndef GLEE_C_DEFINED_wglGetCurrentReadDCEXT
#define GLEE_C_DEFINED_wglGetCurrentReadDCEXT
  HDC __stdcall GLee_Lazy_wglGetCurrentReadDCEXT(void)  {if (GLeeInit()) return wglGetCurrentReadDCEXT(); return (HDC)0;}
  GLEEPFNWGLGETCURRENTREADDCEXTPROC GLeeFuncPtr_wglGetCurrentReadDCEXT=GLee_Lazy_wglGetCurrentReadDCEXT;
#endif
#endif 

/* WGL_EXT_pixel_format */

#ifdef __GLEE_WGL_EXT_pixel_format
#ifndef GLEE_C_DEFINED_wglGetPixelFormatAttribivEXT
#define GLEE_C_DEFINED_wglGetPixelFormatAttribivEXT
  BOOL __stdcall GLee_Lazy_wglGetPixelFormatAttribivEXT(HDC hdc, int iPixelFormat, int iLayerPlane, UINT nAttributes, int * piAttributes, int * piValues)  {if (GLeeInit()) return wglGetPixelFormatAttribivEXT(hdc, iPixelFormat, iLayerPlane, nAttributes, piAttributes, piValues); return (BOOL)0;}
  GLEEPFNWGLGETPIXELFORMATATTRIBIVEXTPROC GLeeFuncPtr_wglGetPixelFormatAttribivEXT=GLee_Lazy_wglGetPixelFormatAttribivEXT;
#endif
#ifndef GLEE_C_DEFINED_wglGetPixelFormatAttribfvEXT
#define GLEE_C_DEFINED_wglGetPixelFormatAttribfvEXT
  BOOL __stdcall GLee_Lazy_wglGetPixelFormatAttribfvEXT(HDC hdc, int iPixelFormat, int iLayerPlane, UINT nAttributes, int * piAttributes, FLOAT * pfValues)  {if (GLeeInit()) return wglGetPixelFormatAttribfvEXT(hdc, iPixelFormat, iLayerPlane, nAttributes, piAttributes, pfValues); return (BOOL)0;}
  GLEEPFNWGLGETPIXELFORMATATTRIBFVEXTPROC GLeeFuncPtr_wglGetPixelFormatAttribfvEXT=GLee_Lazy_wglGetPixelFormatAttribfvEXT;
#endif
#ifndef GLEE_C_DEFINED_wglChoosePixelFormatEXT
#define GLEE_C_DEFINED_wglChoosePixelFormatEXT
  BOOL __stdcall GLee_Lazy_wglChoosePixelFormatEXT(HDC hdc, const int * piAttribIList, const FLOAT * pfAttribFList, UINT nMaxFormats, int * piFormats, UINT * nNumFormats)  {if (GLeeInit()) return wglChoosePixelFormatEXT(hdc, piAttribIList, pfAttribFList, nMaxFormats, piFormats, nNumFormats); return (BOOL)0;}
  GLEEPFNWGLCHOOSEPIXELFORMATEXTPROC GLeeFuncPtr_wglChoosePixelFormatEXT=GLee_Lazy_wglChoosePixelFormatEXT;
#endif
#endif 

/* WGL_EXT_pbuffer */

#ifdef __GLEE_WGL_EXT_pbuffer
#ifndef GLEE_C_DEFINED_wglCreatePbufferEXT
#define GLEE_C_DEFINED_wglCreatePbufferEXT
  HPBUFFEREXT __stdcall GLee_Lazy_wglCreatePbufferEXT(HDC hDC, int iPixelFormat, int iWidth, int iHeight, const int * piAttribList)  {if (GLeeInit()) return wglCreatePbufferEXT(hDC, iPixelFormat, iWidth, iHeight, piAttribList); return (HPBUFFEREXT)0;}
  GLEEPFNWGLCREATEPBUFFEREXTPROC GLeeFuncPtr_wglCreatePbufferEXT=GLee_Lazy_wglCreatePbufferEXT;
#endif
#ifndef GLEE_C_DEFINED_wglGetPbufferDCEXT
#define GLEE_C_DEFINED_wglGetPbufferDCEXT
  HDC __stdcall GLee_Lazy_wglGetPbufferDCEXT(HPBUFFEREXT hPbuffer)  {if (GLeeInit()) return wglGetPbufferDCEXT(hPbuffer); return (HDC)0;}
  GLEEPFNWGLGETPBUFFERDCEXTPROC GLeeFuncPtr_wglGetPbufferDCEXT=GLee_Lazy_wglGetPbufferDCEXT;
#endif
#ifndef GLEE_C_DEFINED_wglReleasePbufferDCEXT
#define GLEE_C_DEFINED_wglReleasePbufferDCEXT
  int __stdcall GLee_Lazy_wglReleasePbufferDCEXT(HPBUFFEREXT hPbuffer, HDC hDC)  {if (GLeeInit()) return wglReleasePbufferDCEXT(hPbuffer, hDC); return (int)0;}
  GLEEPFNWGLRELEASEPBUFFERDCEXTPROC GLeeFuncPtr_wglReleasePbufferDCEXT=GLee_Lazy_wglReleasePbufferDCEXT;
#endif
#ifndef GLEE_C_DEFINED_wglDestroyPbufferEXT
#define GLEE_C_DEFINED_wglDestroyPbufferEXT
  BOOL __stdcall GLee_Lazy_wglDestroyPbufferEXT(HPBUFFEREXT hPbuffer)  {if (GLeeInit()) return wglDestroyPbufferEXT(hPbuffer); return (BOOL)0;}
  GLEEPFNWGLDESTROYPBUFFEREXTPROC GLeeFuncPtr_wglDestroyPbufferEXT=GLee_Lazy_wglDestroyPbufferEXT;
#endif
#ifndef GLEE_C_DEFINED_wglQueryPbufferEXT
#define GLEE_C_DEFINED_wglQueryPbufferEXT
  BOOL __stdcall GLee_Lazy_wglQueryPbufferEXT(HPBUFFEREXT hPbuffer, int iAttribute, int * piValue)  {if (GLeeInit()) return wglQueryPbufferEXT(hPbuffer, iAttribute, piValue); return (BOOL)0;}
  GLEEPFNWGLQUERYPBUFFEREXTPROC GLeeFuncPtr_wglQueryPbufferEXT=GLee_Lazy_wglQueryPbufferEXT;
#endif
#endif 

/* WGL_EXT_depth_float */

#ifdef __GLEE_WGL_EXT_depth_float
#endif 

/* WGL_3DFX_multisample */

#ifdef __GLEE_WGL_3DFX_multisample
#endif 

/* WGL_EXT_multisample */

#ifdef __GLEE_WGL_EXT_multisample
#endif 

/* WGL_I3D_digital_video_control */

#ifdef __GLEE_WGL_I3D_digital_video_control
#ifndef GLEE_C_DEFINED_wglGetDigitalVideoParametersI3D
#define GLEE_C_DEFINED_wglGetDigitalVideoParametersI3D
  BOOL __stdcall GLee_Lazy_wglGetDigitalVideoParametersI3D(HDC hDC, int iAttribute, int * piValue)  {if (GLeeInit()) return wglGetDigitalVideoParametersI3D(hDC, iAttribute, piValue); return (BOOL)0;}
  GLEEPFNWGLGETDIGITALVIDEOPARAMETERSI3DPROC GLeeFuncPtr_wglGetDigitalVideoParametersI3D=GLee_Lazy_wglGetDigitalVideoParametersI3D;
#endif
#ifndef GLEE_C_DEFINED_wglSetDigitalVideoParametersI3D
#define GLEE_C_DEFINED_wglSetDigitalVideoParametersI3D
  BOOL __stdcall GLee_Lazy_wglSetDigitalVideoParametersI3D(HDC hDC, int iAttribute, const int * piValue)  {if (GLeeInit()) return wglSetDigitalVideoParametersI3D(hDC, iAttribute, piValue); return (BOOL)0;}
  GLEEPFNWGLSETDIGITALVIDEOPARAMETERSI3DPROC GLeeFuncPtr_wglSetDigitalVideoParametersI3D=GLee_Lazy_wglSetDigitalVideoParametersI3D;
#endif
#endif 

/* WGL_I3D_gamma */

#ifdef __GLEE_WGL_I3D_gamma
#ifndef GLEE_C_DEFINED_wglGetGammaTableParametersI3D
#define GLEE_C_DEFINED_wglGetGammaTableParametersI3D
  BOOL __stdcall GLee_Lazy_wglGetGammaTableParametersI3D(HDC hDC, int iAttribute, int * piValue)  {if (GLeeInit()) return wglGetGammaTableParametersI3D(hDC, iAttribute, piValue); return (BOOL)0;}
  GLEEPFNWGLGETGAMMATABLEPARAMETERSI3DPROC GLeeFuncPtr_wglGetGammaTableParametersI3D=GLee_Lazy_wglGetGammaTableParametersI3D;
#endif
#ifndef GLEE_C_DEFINED_wglSetGammaTableParametersI3D
#define GLEE_C_DEFINED_wglSetGammaTableParametersI3D
  BOOL __stdcall GLee_Lazy_wglSetGammaTableParametersI3D(HDC hDC, int iAttribute, const int * piValue)  {if (GLeeInit()) return wglSetGammaTableParametersI3D(hDC, iAttribute, piValue); return (BOOL)0;}
  GLEEPFNWGLSETGAMMATABLEPARAMETERSI3DPROC GLeeFuncPtr_wglSetGammaTableParametersI3D=GLee_Lazy_wglSetGammaTableParametersI3D;
#endif
#ifndef GLEE_C_DEFINED_wglGetGammaTableI3D
#define GLEE_C_DEFINED_wglGetGammaTableI3D
  BOOL __stdcall GLee_Lazy_wglGetGammaTableI3D(HDC hDC, int iEntries, USHORT * puRed, USHORT * puGreen, USHORT * puBlue)  {if (GLeeInit()) return wglGetGammaTableI3D(hDC, iEntries, puRed, puGreen, puBlue); return (BOOL)0;}
  GLEEPFNWGLGETGAMMATABLEI3DPROC GLeeFuncPtr_wglGetGammaTableI3D=GLee_Lazy_wglGetGammaTableI3D;
#endif
#ifndef GLEE_C_DEFINED_wglSetGammaTableI3D
#define GLEE_C_DEFINED_wglSetGammaTableI3D
  BOOL __stdcall GLee_Lazy_wglSetGammaTableI3D(HDC hDC, int iEntries, const USHORT * puRed, const USHORT * puGreen, const USHORT * puBlue)  {if (GLeeInit()) return wglSetGammaTableI3D(hDC, iEntries, puRed, puGreen, puBlue); return (BOOL)0;}
  GLEEPFNWGLSETGAMMATABLEI3DPROC GLeeFuncPtr_wglSetGammaTableI3D=GLee_Lazy_wglSetGammaTableI3D;
#endif
#endif 

/* WGL_I3D_genlock */

#ifdef __GLEE_WGL_I3D_genlock
#ifndef GLEE_C_DEFINED_wglEnableGenlockI3D
#define GLEE_C_DEFINED_wglEnableGenlockI3D
  BOOL __stdcall GLee_Lazy_wglEnableGenlockI3D(HDC hDC)  {if (GLeeInit()) return wglEnableGenlockI3D(hDC); return (BOOL)0;}
  GLEEPFNWGLENABLEGENLOCKI3DPROC GLeeFuncPtr_wglEnableGenlockI3D=GLee_Lazy_wglEnableGenlockI3D;
#endif
#ifndef GLEE_C_DEFINED_wglDisableGenlockI3D
#define GLEE_C_DEFINED_wglDisableGenlockI3D
  BOOL __stdcall GLee_Lazy_wglDisableGenlockI3D(HDC hDC)  {if (GLeeInit()) return wglDisableGenlockI3D(hDC); return (BOOL)0;}
  GLEEPFNWGLDISABLEGENLOCKI3DPROC GLeeFuncPtr_wglDisableGenlockI3D=GLee_Lazy_wglDisableGenlockI3D;
#endif
#ifndef GLEE_C_DEFINED_wglIsEnabledGenlockI3D
#define GLEE_C_DEFINED_wglIsEnabledGenlockI3D
  BOOL __stdcall GLee_Lazy_wglIsEnabledGenlockI3D(HDC hDC, BOOL * pFlag)  {if (GLeeInit()) return wglIsEnabledGenlockI3D(hDC, pFlag); return (BOOL)0;}
  GLEEPFNWGLISENABLEDGENLOCKI3DPROC GLeeFuncPtr_wglIsEnabledGenlockI3D=GLee_Lazy_wglIsEnabledGenlockI3D;
#endif
#ifndef GLEE_C_DEFINED_wglGenlockSourceI3D
#define GLEE_C_DEFINED_wglGenlockSourceI3D
  BOOL __stdcall GLee_Lazy_wglGenlockSourceI3D(HDC hDC, UINT uSource)  {if (GLeeInit()) return wglGenlockSourceI3D(hDC, uSource); return (BOOL)0;}
  GLEEPFNWGLGENLOCKSOURCEI3DPROC GLeeFuncPtr_wglGenlockSourceI3D=GLee_Lazy_wglGenlockSourceI3D;
#endif
#ifndef GLEE_C_DEFINED_wglGetGenlockSourceI3D
#define GLEE_C_DEFINED_wglGetGenlockSourceI3D
  BOOL __stdcall GLee_Lazy_wglGetGenlockSourceI3D(HDC hDC, UINT * uSource)  {if (GLeeInit()) return wglGetGenlockSourceI3D(hDC, uSource); return (BOOL)0;}
  GLEEPFNWGLGETGENLOCKSOURCEI3DPROC GLeeFuncPtr_wglGetGenlockSourceI3D=GLee_Lazy_wglGetGenlockSourceI3D;
#endif
#ifndef GLEE_C_DEFINED_wglGenlockSourceEdgeI3D
#define GLEE_C_DEFINED_wglGenlockSourceEdgeI3D
  BOOL __stdcall GLee_Lazy_wglGenlockSourceEdgeI3D(HDC hDC, UINT uEdge)  {if (GLeeInit()) return wglGenlockSourceEdgeI3D(hDC, uEdge); return (BOOL)0;}
  GLEEPFNWGLGENLOCKSOURCEEDGEI3DPROC GLeeFuncPtr_wglGenlockSourceEdgeI3D=GLee_Lazy_wglGenlockSourceEdgeI3D;
#endif
#ifndef GLEE_C_DEFINED_wglGetGenlockSourceEdgeI3D
#define GLEE_C_DEFINED_wglGetGenlockSourceEdgeI3D
  BOOL __stdcall GLee_Lazy_wglGetGenlockSourceEdgeI3D(HDC hDC, UINT * uEdge)  {if (GLeeInit()) return wglGetGenlockSourceEdgeI3D(hDC, uEdge); return (BOOL)0;}
  GLEEPFNWGLGETGENLOCKSOURCEEDGEI3DPROC GLeeFuncPtr_wglGetGenlockSourceEdgeI3D=GLee_Lazy_wglGetGenlockSourceEdgeI3D;
#endif
#ifndef GLEE_C_DEFINED_wglGenlockSampleRateI3D
#define GLEE_C_DEFINED_wglGenlockSampleRateI3D
  BOOL __stdcall GLee_Lazy_wglGenlockSampleRateI3D(HDC hDC, UINT uRate)  {if (GLeeInit()) return wglGenlockSampleRateI3D(hDC, uRate); return (BOOL)0;}
  GLEEPFNWGLGENLOCKSAMPLERATEI3DPROC GLeeFuncPtr_wglGenlockSampleRateI3D=GLee_Lazy_wglGenlockSampleRateI3D;
#endif
#ifndef GLEE_C_DEFINED_wglGetGenlockSampleRateI3D
#define GLEE_C_DEFINED_wglGetGenlockSampleRateI3D
  BOOL __stdcall GLee_Lazy_wglGetGenlockSampleRateI3D(HDC hDC, UINT * uRate)  {if (GLeeInit()) return wglGetGenlockSampleRateI3D(hDC, uRate); return (BOOL)0;}
  GLEEPFNWGLGETGENLOCKSAMPLERATEI3DPROC GLeeFuncPtr_wglGetGenlockSampleRateI3D=GLee_Lazy_wglGetGenlockSampleRateI3D;
#endif
#ifndef GLEE_C_DEFINED_wglGenlockSourceDelayI3D
#define GLEE_C_DEFINED_wglGenlockSourceDelayI3D
  BOOL __stdcall GLee_Lazy_wglGenlockSourceDelayI3D(HDC hDC, UINT uDelay)  {if (GLeeInit()) return wglGenlockSourceDelayI3D(hDC, uDelay); return (BOOL)0;}
  GLEEPFNWGLGENLOCKSOURCEDELAYI3DPROC GLeeFuncPtr_wglGenlockSourceDelayI3D=GLee_Lazy_wglGenlockSourceDelayI3D;
#endif
#ifndef GLEE_C_DEFINED_wglGetGenlockSourceDelayI3D
#define GLEE_C_DEFINED_wglGetGenlockSourceDelayI3D
  BOOL __stdcall GLee_Lazy_wglGetGenlockSourceDelayI3D(HDC hDC, UINT * uDelay)  {if (GLeeInit()) return wglGetGenlockSourceDelayI3D(hDC, uDelay); return (BOOL)0;}
  GLEEPFNWGLGETGENLOCKSOURCEDELAYI3DPROC GLeeFuncPtr_wglGetGenlockSourceDelayI3D=GLee_Lazy_wglGetGenlockSourceDelayI3D;
#endif
#ifndef GLEE_C_DEFINED_wglQueryGenlockMaxSourceDelayI3D
#define GLEE_C_DEFINED_wglQueryGenlockMaxSourceDelayI3D
  BOOL __stdcall GLee_Lazy_wglQueryGenlockMaxSourceDelayI3D(HDC hDC, UINT * uMaxLineDelay, UINT * uMaxPixelDelay)  {if (GLeeInit()) return wglQueryGenlockMaxSourceDelayI3D(hDC, uMaxLineDelay, uMaxPixelDelay); return (BOOL)0;}
  GLEEPFNWGLQUERYGENLOCKMAXSOURCEDELAYI3DPROC GLeeFuncPtr_wglQueryGenlockMaxSourceDelayI3D=GLee_Lazy_wglQueryGenlockMaxSourceDelayI3D;
#endif
#endif 

/* WGL_I3D_image_buffer */

#ifdef __GLEE_WGL_I3D_image_buffer
#ifndef GLEE_C_DEFINED_wglCreateImageBufferI3D
#define GLEE_C_DEFINED_wglCreateImageBufferI3D
  LPVOID __stdcall GLee_Lazy_wglCreateImageBufferI3D(HDC hDC, DWORD dwSize, UINT uFlags)  {if (GLeeInit()) return wglCreateImageBufferI3D(hDC, dwSize, uFlags); return (LPVOID)0;}
  GLEEPFNWGLCREATEIMAGEBUFFERI3DPROC GLeeFuncPtr_wglCreateImageBufferI3D=GLee_Lazy_wglCreateImageBufferI3D;
#endif
#ifndef GLEE_C_DEFINED_wglDestroyImageBufferI3D
#define GLEE_C_DEFINED_wglDestroyImageBufferI3D
  BOOL __stdcall GLee_Lazy_wglDestroyImageBufferI3D(HDC hDC, LPVOID pAddress)  {if (GLeeInit()) return wglDestroyImageBufferI3D(hDC, pAddress); return (BOOL)0;}
  GLEEPFNWGLDESTROYIMAGEBUFFERI3DPROC GLeeFuncPtr_wglDestroyImageBufferI3D=GLee_Lazy_wglDestroyImageBufferI3D;
#endif
#ifndef GLEE_C_DEFINED_wglAssociateImageBufferEventsI3D
#define GLEE_C_DEFINED_wglAssociateImageBufferEventsI3D
  BOOL __stdcall GLee_Lazy_wglAssociateImageBufferEventsI3D(HDC hDC, const HANDLE * pEvent, const LPVOID * pAddress, const DWORD * pSize, UINT count)  {if (GLeeInit()) return wglAssociateImageBufferEventsI3D(hDC, pEvent, pAddress, pSize, count); return (BOOL)0;}
  GLEEPFNWGLASSOCIATEIMAGEBUFFEREVENTSI3DPROC GLeeFuncPtr_wglAssociateImageBufferEventsI3D=GLee_Lazy_wglAssociateImageBufferEventsI3D;
#endif
#ifndef GLEE_C_DEFINED_wglReleaseImageBufferEventsI3D
#define GLEE_C_DEFINED_wglReleaseImageBufferEventsI3D
  BOOL __stdcall GLee_Lazy_wglReleaseImageBufferEventsI3D(HDC hDC, const LPVOID * pAddress, UINT count)  {if (GLeeInit()) return wglReleaseImageBufferEventsI3D(hDC, pAddress, count); return (BOOL)0;}
  GLEEPFNWGLRELEASEIMAGEBUFFEREVENTSI3DPROC GLeeFuncPtr_wglReleaseImageBufferEventsI3D=GLee_Lazy_wglReleaseImageBufferEventsI3D;
#endif
#endif 

/* WGL_I3D_swap_frame_lock */

#ifdef __GLEE_WGL_I3D_swap_frame_lock
#ifndef GLEE_C_DEFINED_wglEnableFrameLockI3D
#define GLEE_C_DEFINED_wglEnableFrameLockI3D
  BOOL __stdcall GLee_Lazy_wglEnableFrameLockI3D(void)  {if (GLeeInit()) return wglEnableFrameLockI3D(); return (BOOL)0;}
  GLEEPFNWGLENABLEFRAMELOCKI3DPROC GLeeFuncPtr_wglEnableFrameLockI3D=GLee_Lazy_wglEnableFrameLockI3D;
#endif
#ifndef GLEE_C_DEFINED_wglDisableFrameLockI3D
#define GLEE_C_DEFINED_wglDisableFrameLockI3D
  BOOL __stdcall GLee_Lazy_wglDisableFrameLockI3D(void)  {if (GLeeInit()) return wglDisableFrameLockI3D(); return (BOOL)0;}
  GLEEPFNWGLDISABLEFRAMELOCKI3DPROC GLeeFuncPtr_wglDisableFrameLockI3D=GLee_Lazy_wglDisableFrameLockI3D;
#endif
#ifndef GLEE_C_DEFINED_wglIsEnabledFrameLockI3D
#define GLEE_C_DEFINED_wglIsEnabledFrameLockI3D
  BOOL __stdcall GLee_Lazy_wglIsEnabledFrameLockI3D(BOOL * pFlag)  {if (GLeeInit()) return wglIsEnabledFrameLockI3D(pFlag); return (BOOL)0;}
  GLEEPFNWGLISENABLEDFRAMELOCKI3DPROC GLeeFuncPtr_wglIsEnabledFrameLockI3D=GLee_Lazy_wglIsEnabledFrameLockI3D;
#endif
#ifndef GLEE_C_DEFINED_wglQueryFrameLockMasterI3D
#define GLEE_C_DEFINED_wglQueryFrameLockMasterI3D
  BOOL __stdcall GLee_Lazy_wglQueryFrameLockMasterI3D(BOOL * pFlag)  {if (GLeeInit()) return wglQueryFrameLockMasterI3D(pFlag); return (BOOL)0;}
  GLEEPFNWGLQUERYFRAMELOCKMASTERI3DPROC GLeeFuncPtr_wglQueryFrameLockMasterI3D=GLee_Lazy_wglQueryFrameLockMasterI3D;
#endif
#endif 

/* WGL_NV_render_depth_texture */

#ifdef __GLEE_WGL_NV_render_depth_texture
#endif 

/* WGL_NV_render_texture_rectangle */

#ifdef __GLEE_WGL_NV_render_texture_rectangle
#endif 

/* WGL_ATI_pixel_format_float */

#ifdef __GLEE_WGL_ATI_pixel_format_float
#endif 

/* WGL_NV_float_buffer */

#ifdef __GLEE_WGL_NV_float_buffer
#endif 

/* WGL_3DL_stereo_control */

#ifdef __GLEE_WGL_3DL_stereo_control
#endif 

/* WGL_EXT_pixel_format_packed_float */

#ifdef __GLEE_WGL_EXT_pixel_format_packed_float
#endif 

/* WGL_EXT_framebuffer_sRGB */

#ifdef __GLEE_WGL_EXT_framebuffer_sRGB
#endif 

/* WGL_NV_present_video */

#ifdef __GLEE_WGL_NV_present_video
#ifndef GLEE_C_DEFINED_wglEnumerateVideoDevicesNV
#define GLEE_C_DEFINED_wglEnumerateVideoDevicesNV
  int __stdcall GLee_Lazy_wglEnumerateVideoDevicesNV(HDC hDC, HVIDEOOUTPUTDEVICENV * phDeviceList)  {if (GLeeInit()) return wglEnumerateVideoDevicesNV(hDC, phDeviceList); return (int)0;}
  GLEEPFNWGLENUMERATEVIDEODEVICESNVPROC GLeeFuncPtr_wglEnumerateVideoDevicesNV=GLee_Lazy_wglEnumerateVideoDevicesNV;
#endif
#ifndef GLEE_C_DEFINED_wglBindVideoDeviceNV
#define GLEE_C_DEFINED_wglBindVideoDeviceNV
  BOOL __stdcall GLee_Lazy_wglBindVideoDeviceNV(HDC hDC, unsigned int uVideoSlot, HVIDEOOUTPUTDEVICENV hVideoDevice, const int * piAttribList)  {if (GLeeInit()) return wglBindVideoDeviceNV(hDC, uVideoSlot, hVideoDevice, piAttribList); return (BOOL)0;}
  GLEEPFNWGLBINDVIDEODEVICENVPROC GLeeFuncPtr_wglBindVideoDeviceNV=GLee_Lazy_wglBindVideoDeviceNV;
#endif
#ifndef GLEE_C_DEFINED_wglQueryCurrentContextNV
#define GLEE_C_DEFINED_wglQueryCurrentContextNV
  BOOL __stdcall GLee_Lazy_wglQueryCurrentContextNV(int iAttribute, int * piValue)  {if (GLeeInit()) return wglQueryCurrentContextNV(iAttribute, piValue); return (BOOL)0;}
  GLEEPFNWGLQUERYCURRENTCONTEXTNVPROC GLeeFuncPtr_wglQueryCurrentContextNV=GLee_Lazy_wglQueryCurrentContextNV;
#endif
#endif 

/* WGL_NV_swap_group */

#ifdef __GLEE_WGL_NV_swap_group
#ifndef GLEE_C_DEFINED_wglJoinSwapGroupNV
#define GLEE_C_DEFINED_wglJoinSwapGroupNV
  BOOL __stdcall GLee_Lazy_wglJoinSwapGroupNV(HDC hDC, GLuint group)  {if (GLeeInit()) return wglJoinSwapGroupNV(hDC, group); return (BOOL)0;}
  GLEEPFNWGLJOINSWAPGROUPNVPROC GLeeFuncPtr_wglJoinSwapGroupNV=GLee_Lazy_wglJoinSwapGroupNV;
#endif
#ifndef GLEE_C_DEFINED_wglBindSwapBarrierNV
#define GLEE_C_DEFINED_wglBindSwapBarrierNV
  BOOL __stdcall GLee_Lazy_wglBindSwapBarrierNV(GLuint group, GLuint barrier)  {if (GLeeInit()) return wglBindSwapBarrierNV(group, barrier); return (BOOL)0;}
  GLEEPFNWGLBINDSWAPBARRIERNVPROC GLeeFuncPtr_wglBindSwapBarrierNV=GLee_Lazy_wglBindSwapBarrierNV;
#endif
#ifndef GLEE_C_DEFINED_wglQuerySwapGroupNV
#define GLEE_C_DEFINED_wglQuerySwapGroupNV
  BOOL __stdcall GLee_Lazy_wglQuerySwapGroupNV(HDC hDC, GLuint * group, GLuint * barrier)  {if (GLeeInit()) return wglQuerySwapGroupNV(hDC, group, barrier); return (BOOL)0;}
  GLEEPFNWGLQUERYSWAPGROUPNVPROC GLeeFuncPtr_wglQuerySwapGroupNV=GLee_Lazy_wglQuerySwapGroupNV;
#endif
#ifndef GLEE_C_DEFINED_wglQueryMaxSwapGroupsNV
#define GLEE_C_DEFINED_wglQueryMaxSwapGroupsNV
  BOOL __stdcall GLee_Lazy_wglQueryMaxSwapGroupsNV(HDC hDC, GLuint * maxGroups, GLuint * maxBarriers)  {if (GLeeInit()) return wglQueryMaxSwapGroupsNV(hDC, maxGroups, maxBarriers); return (BOOL)0;}
  GLEEPFNWGLQUERYMAXSWAPGROUPSNVPROC GLeeFuncPtr_wglQueryMaxSwapGroupsNV=GLee_Lazy_wglQueryMaxSwapGroupsNV;
#endif
#ifndef GLEE_C_DEFINED_wglQueryFrameCountNV
#define GLEE_C_DEFINED_wglQueryFrameCountNV
  BOOL __stdcall GLee_Lazy_wglQueryFrameCountNV(HDC hDC, GLuint * count)  {if (GLeeInit()) return wglQueryFrameCountNV(hDC, count); return (BOOL)0;}
  GLEEPFNWGLQUERYFRAMECOUNTNVPROC GLeeFuncPtr_wglQueryFrameCountNV=GLee_Lazy_wglQueryFrameCountNV;
#endif
#ifndef GLEE_C_DEFINED_wglResetFrameCountNV
#define GLEE_C_DEFINED_wglResetFrameCountNV
  BOOL __stdcall GLee_Lazy_wglResetFrameCountNV(HDC hDC)  {if (GLeeInit()) return wglResetFrameCountNV(hDC); return (BOOL)0;}
  GLEEPFNWGLRESETFRAMECOUNTNVPROC GLeeFuncPtr_wglResetFrameCountNV=GLee_Lazy_wglResetFrameCountNV;
#endif
#endif 

/* WGL_NV_gpu_affinity */

#ifdef __GLEE_WGL_NV_gpu_affinity
#ifndef GLEE_C_DEFINED_wglEnumGpusNV
#define GLEE_C_DEFINED_wglEnumGpusNV
  BOOL __stdcall GLee_Lazy_wglEnumGpusNV(UINT iGpuIndex, HGPUNV * phGpu)  {if (GLeeInit()) return wglEnumGpusNV(iGpuIndex, phGpu); return (BOOL)0;}
  GLEEPFNWGLENUMGPUSNVPROC GLeeFuncPtr_wglEnumGpusNV=GLee_Lazy_wglEnumGpusNV;
#endif
#ifndef GLEE_C_DEFINED_wglEnumGpuDevicesNV
#define GLEE_C_DEFINED_wglEnumGpuDevicesNV
  BOOL __stdcall GLee_Lazy_wglEnumGpuDevicesNV(HGPUNV hGpu, UINT iDeviceIndex, PGPU_DEVICE lpGpuDevice)  {if (GLeeInit()) return wglEnumGpuDevicesNV(hGpu, iDeviceIndex, lpGpuDevice); return (BOOL)0;}
  GLEEPFNWGLENUMGPUDEVICESNVPROC GLeeFuncPtr_wglEnumGpuDevicesNV=GLee_Lazy_wglEnumGpuDevicesNV;
#endif
#ifndef GLEE_C_DEFINED_wglCreateAffinityDCNV
#define GLEE_C_DEFINED_wglCreateAffinityDCNV
  HDC __stdcall GLee_Lazy_wglCreateAffinityDCNV(const HGPUNV * phGpuList)  {if (GLeeInit()) return wglCreateAffinityDCNV(phGpuList); return (HDC)0;}
  GLEEPFNWGLCREATEAFFINITYDCNVPROC GLeeFuncPtr_wglCreateAffinityDCNV=GLee_Lazy_wglCreateAffinityDCNV;
#endif
#ifndef GLEE_C_DEFINED_wglEnumGpusFromAffinityDCNV
#define GLEE_C_DEFINED_wglEnumGpusFromAffinityDCNV
  BOOL __stdcall GLee_Lazy_wglEnumGpusFromAffinityDCNV(HDC hAffinityDC, UINT iGpuIndex, HGPUNV * hGpu)  {if (GLeeInit()) return wglEnumGpusFromAffinityDCNV(hAffinityDC, iGpuIndex, hGpu); return (BOOL)0;}
  GLEEPFNWGLENUMGPUSFROMAFFINITYDCNVPROC GLeeFuncPtr_wglEnumGpusFromAffinityDCNV=GLee_Lazy_wglEnumGpusFromAffinityDCNV;
#endif
#ifndef GLEE_C_DEFINED_wglDeleteDCNV
#define GLEE_C_DEFINED_wglDeleteDCNV
  BOOL __stdcall GLee_Lazy_wglDeleteDCNV(HDC hdc)  {if (GLeeInit()) return wglDeleteDCNV(hdc); return (BOOL)0;}
  GLEEPFNWGLDELETEDCNVPROC GLeeFuncPtr_wglDeleteDCNV=GLee_Lazy_wglDeleteDCNV;
#endif
#endif 

/* WGL_EXT_display_color_table */

#ifdef __GLEE_WGL_EXT_display_color_table
#ifndef GLEE_C_DEFINED_wglCreateDisplayColorTableEXT
#define GLEE_C_DEFINED_wglCreateDisplayColorTableEXT
  GLboolean __stdcall GLee_Lazy_wglCreateDisplayColorTableEXT(GLushort id)  {if (GLeeInit()) return wglCreateDisplayColorTableEXT(id); return (GLboolean)0;}
  GLEEPFNWGLCREATEDISPLAYCOLORTABLEEXTPROC GLeeFuncPtr_wglCreateDisplayColorTableEXT=GLee_Lazy_wglCreateDisplayColorTableEXT;
#endif
#ifndef GLEE_C_DEFINED_wglLoadDisplayColorTableEXT
#define GLEE_C_DEFINED_wglLoadDisplayColorTableEXT
  GLboolean __stdcall GLee_Lazy_wglLoadDisplayColorTableEXT(const GLushort * table, GLuint length)  {if (GLeeInit()) return wglLoadDisplayColorTableEXT(table, length); return (GLboolean)0;}
  GLEEPFNWGLLOADDISPLAYCOLORTABLEEXTPROC GLeeFuncPtr_wglLoadDisplayColorTableEXT=GLee_Lazy_wglLoadDisplayColorTableEXT;
#endif
#ifndef GLEE_C_DEFINED_wglBindDisplayColorTableEXT
#define GLEE_C_DEFINED_wglBindDisplayColorTableEXT
  GLboolean __stdcall GLee_Lazy_wglBindDisplayColorTableEXT(GLushort id)  {if (GLeeInit()) return wglBindDisplayColorTableEXT(id); return (GLboolean)0;}
  GLEEPFNWGLBINDDISPLAYCOLORTABLEEXTPROC GLeeFuncPtr_wglBindDisplayColorTableEXT=GLee_Lazy_wglBindDisplayColorTableEXT;
#endif
#ifndef GLEE_C_DEFINED_wglDestroyDisplayColorTableEXT
#define GLEE_C_DEFINED_wglDestroyDisplayColorTableEXT
  VOID __stdcall GLee_Lazy_wglDestroyDisplayColorTableEXT(GLushort id)  {if (GLeeInit()) wglDestroyDisplayColorTableEXT(id);}
  GLEEPFNWGLDESTROYDISPLAYCOLORTABLEEXTPROC GLeeFuncPtr_wglDestroyDisplayColorTableEXT=GLee_Lazy_wglDestroyDisplayColorTableEXT;
#endif
#endif 

/* WGL_EXT_extensions_string */

#ifdef __GLEE_WGL_EXT_extensions_string
#ifndef GLEE_C_DEFINED_wglGetExtensionsStringEXT
#define GLEE_C_DEFINED_wglGetExtensionsStringEXT
  const char * __stdcall GLee_Lazy_wglGetExtensionsStringEXT(void)  {if (GLeeInit()) return wglGetExtensionsStringEXT(); return (const char *)0;}
  GLEEPFNWGLGETEXTENSIONSSTRINGEXTPROC GLeeFuncPtr_wglGetExtensionsStringEXT=GLee_Lazy_wglGetExtensionsStringEXT;
#endif
#endif 

/* WGL_EXT_swap_control */

#ifdef __GLEE_WGL_EXT_swap_control
#ifndef GLEE_C_DEFINED_wglSwapIntervalEXT
#define GLEE_C_DEFINED_wglSwapIntervalEXT
  BOOL __stdcall GLee_Lazy_wglSwapIntervalEXT(int interval)  {if (GLeeInit()) return wglSwapIntervalEXT(interval); return (BOOL)0;}
  GLEEPFNWGLSWAPINTERVALEXTPROC GLeeFuncPtr_wglSwapIntervalEXT=GLee_Lazy_wglSwapIntervalEXT;
#endif
#ifndef GLEE_C_DEFINED_wglGetSwapIntervalEXT
#define GLEE_C_DEFINED_wglGetSwapIntervalEXT
  int __stdcall GLee_Lazy_wglGetSwapIntervalEXT(void)  {if (GLeeInit()) return wglGetSwapIntervalEXT(); return (int)0;}
  GLEEPFNWGLGETSWAPINTERVALEXTPROC GLeeFuncPtr_wglGetSwapIntervalEXT=GLee_Lazy_wglGetSwapIntervalEXT;
#endif
#endif 

/* WGL_NV_vertex_array_range */

#ifdef __GLEE_WGL_NV_vertex_array_range
#ifndef GLEE_C_DEFINED_wglAllocateMemoryNV
#define GLEE_C_DEFINED_wglAllocateMemoryNV
  void* __stdcall GLee_Lazy_wglAllocateMemoryNV(GLsizei size, GLfloat readfreq, GLfloat writefreq, GLfloat priority)  {if (GLeeInit()) return wglAllocateMemoryNV(size, readfreq, writefreq, priority); return (void*)0;}
  GLEEPFNWGLALLOCATEMEMORYNVPROC GLeeFuncPtr_wglAllocateMemoryNV=GLee_Lazy_wglAllocateMemoryNV;
#endif
#ifndef GLEE_C_DEFINED_wglFreeMemoryNV
#define GLEE_C_DEFINED_wglFreeMemoryNV
  void __stdcall GLee_Lazy_wglFreeMemoryNV(void * pointer)  {if (GLeeInit()) wglFreeMemoryNV(pointer);}
  GLEEPFNWGLFREEMEMORYNVPROC GLeeFuncPtr_wglFreeMemoryNV=GLee_Lazy_wglFreeMemoryNV;
#endif
#endif 

/* WGL_OML_sync_control */

#ifdef __GLEE_WGL_OML_sync_control
#ifndef GLEE_C_DEFINED_wglGetSyncValuesOML
#define GLEE_C_DEFINED_wglGetSyncValuesOML
  BOOL __stdcall GLee_Lazy_wglGetSyncValuesOML(HDC hdc, INT64 * ust, INT64 * msc, INT64 * sbc)  {if (GLeeInit()) return wglGetSyncValuesOML(hdc, ust, msc, sbc); return (BOOL)0;}
  GLEEPFNWGLGETSYNCVALUESOMLPROC GLeeFuncPtr_wglGetSyncValuesOML=GLee_Lazy_wglGetSyncValuesOML;
#endif
#ifndef GLEE_C_DEFINED_wglGetMscRateOML
#define GLEE_C_DEFINED_wglGetMscRateOML
  BOOL __stdcall GLee_Lazy_wglGetMscRateOML(HDC hdc, INT32 * numerator, INT32 * denominator)  {if (GLeeInit()) return wglGetMscRateOML(hdc, numerator, denominator); return (BOOL)0;}
  GLEEPFNWGLGETMSCRATEOMLPROC GLeeFuncPtr_wglGetMscRateOML=GLee_Lazy_wglGetMscRateOML;
#endif
#ifndef GLEE_C_DEFINED_wglSwapBuffersMscOML
#define GLEE_C_DEFINED_wglSwapBuffersMscOML
  INT64 __stdcall GLee_Lazy_wglSwapBuffersMscOML(HDC hdc, INT64 target_msc, INT64 divisor, INT64 remainder)  {if (GLeeInit()) return wglSwapBuffersMscOML(hdc, target_msc, divisor, remainder); return (INT64)0;}
  GLEEPFNWGLSWAPBUFFERSMSCOMLPROC GLeeFuncPtr_wglSwapBuffersMscOML=GLee_Lazy_wglSwapBuffersMscOML;
#endif
#ifndef GLEE_C_DEFINED_wglSwapLayerBuffersMscOML
#define GLEE_C_DEFINED_wglSwapLayerBuffersMscOML
  INT64 __stdcall GLee_Lazy_wglSwapLayerBuffersMscOML(HDC hdc, int fuPlanes, INT64 target_msc, INT64 divisor, INT64 remainder)  {if (GLeeInit()) return wglSwapLayerBuffersMscOML(hdc, fuPlanes, target_msc, divisor, remainder); return (INT64)0;}
  GLEEPFNWGLSWAPLAYERBUFFERSMSCOMLPROC GLeeFuncPtr_wglSwapLayerBuffersMscOML=GLee_Lazy_wglSwapLayerBuffersMscOML;
#endif
#ifndef GLEE_C_DEFINED_wglWaitForMscOML
#define GLEE_C_DEFINED_wglWaitForMscOML
  BOOL __stdcall GLee_Lazy_wglWaitForMscOML(HDC hdc, INT64 target_msc, INT64 divisor, INT64 remainder, INT64 * ust, INT64 * msc, INT64 * sbc)  {if (GLeeInit()) return wglWaitForMscOML(hdc, target_msc, divisor, remainder, ust, msc, sbc); return (BOOL)0;}
  GLEEPFNWGLWAITFORMSCOMLPROC GLeeFuncPtr_wglWaitForMscOML=GLee_Lazy_wglWaitForMscOML;
#endif
#ifndef GLEE_C_DEFINED_wglWaitForSbcOML
#define GLEE_C_DEFINED_wglWaitForSbcOML
  BOOL __stdcall GLee_Lazy_wglWaitForSbcOML(HDC hdc, INT64 target_sbc, INT64 * ust, INT64 * msc, INT64 * sbc)  {if (GLeeInit()) return wglWaitForSbcOML(hdc, target_sbc, ust, msc, sbc); return (BOOL)0;}
  GLEEPFNWGLWAITFORSBCOMLPROC GLeeFuncPtr_wglWaitForSbcOML=GLee_Lazy_wglWaitForSbcOML;
#endif
#endif 

/* WGL_I3D_swap_frame_usage */

#ifdef __GLEE_WGL_I3D_swap_frame_usage
#ifndef GLEE_C_DEFINED_wglGetFrameUsageI3D
#define GLEE_C_DEFINED_wglGetFrameUsageI3D
  BOOL __stdcall GLee_Lazy_wglGetFrameUsageI3D(float * pUsage)  {if (GLeeInit()) return wglGetFrameUsageI3D(pUsage); return (BOOL)0;}
  GLEEPFNWGLGETFRAMEUSAGEI3DPROC GLeeFuncPtr_wglGetFrameUsageI3D=GLee_Lazy_wglGetFrameUsageI3D;
#endif
#ifndef GLEE_C_DEFINED_wglBeginFrameTrackingI3D
#define GLEE_C_DEFINED_wglBeginFrameTrackingI3D
  BOOL __stdcall GLee_Lazy_wglBeginFrameTrackingI3D(void)  {if (GLeeInit()) return wglBeginFrameTrackingI3D(); return (BOOL)0;}
  GLEEPFNWGLBEGINFRAMETRACKINGI3DPROC GLeeFuncPtr_wglBeginFrameTrackingI3D=GLee_Lazy_wglBeginFrameTrackingI3D;
#endif
#ifndef GLEE_C_DEFINED_wglEndFrameTrackingI3D
#define GLEE_C_DEFINED_wglEndFrameTrackingI3D
  BOOL __stdcall GLee_Lazy_wglEndFrameTrackingI3D(void)  {if (GLeeInit()) return wglEndFrameTrackingI3D(); return (BOOL)0;}
  GLEEPFNWGLENDFRAMETRACKINGI3DPROC GLeeFuncPtr_wglEndFrameTrackingI3D=GLee_Lazy_wglEndFrameTrackingI3D;
#endif
#ifndef GLEE_C_DEFINED_wglQueryFrameTrackingI3D
#define GLEE_C_DEFINED_wglQueryFrameTrackingI3D
  BOOL __stdcall GLee_Lazy_wglQueryFrameTrackingI3D(DWORD * pFrameCount, DWORD * pMissedFrames, float * pLastMissedUsage)  {if (GLeeInit()) return wglQueryFrameTrackingI3D(pFrameCount, pMissedFrames, pLastMissedUsage); return (BOOL)0;}
  GLEEPFNWGLQUERYFRAMETRACKINGI3DPROC GLeeFuncPtr_wglQueryFrameTrackingI3D=GLee_Lazy_wglQueryFrameTrackingI3D;
#endif
#endif 

/* WGL_NV_video_output */

#ifdef __GLEE_WGL_NV_video_output
#ifndef GLEE_C_DEFINED_wglGetVideoDeviceNV
#define GLEE_C_DEFINED_wglGetVideoDeviceNV
  BOOL __stdcall GLee_Lazy_wglGetVideoDeviceNV(HDC hDC, int numDevices, HPVIDEODEV * hVideoDevice)  {if (GLeeInit()) return wglGetVideoDeviceNV(hDC, numDevices, hVideoDevice); return (BOOL)0;}
  GLEEPFNWGLGETVIDEODEVICENVPROC GLeeFuncPtr_wglGetVideoDeviceNV=GLee_Lazy_wglGetVideoDeviceNV;
#endif
#ifndef GLEE_C_DEFINED_wglReleaseVideoDeviceNV
#define GLEE_C_DEFINED_wglReleaseVideoDeviceNV
  BOOL __stdcall GLee_Lazy_wglReleaseVideoDeviceNV(HPVIDEODEV hVideoDevice)  {if (GLeeInit()) return wglReleaseVideoDeviceNV(hVideoDevice); return (BOOL)0;}
  GLEEPFNWGLRELEASEVIDEODEVICENVPROC GLeeFuncPtr_wglReleaseVideoDeviceNV=GLee_Lazy_wglReleaseVideoDeviceNV;
#endif
#ifndef GLEE_C_DEFINED_wglBindVideoImageNV
#define GLEE_C_DEFINED_wglBindVideoImageNV
  BOOL __stdcall GLee_Lazy_wglBindVideoImageNV(HPVIDEODEV hVideoDevice, HPBUFFERARB hPbuffer, int iVideoBuffer)  {if (GLeeInit()) return wglBindVideoImageNV(hVideoDevice, hPbuffer, iVideoBuffer); return (BOOL)0;}
  GLEEPFNWGLBINDVIDEOIMAGENVPROC GLeeFuncPtr_wglBindVideoImageNV=GLee_Lazy_wglBindVideoImageNV;
#endif
#ifndef GLEE_C_DEFINED_wglReleaseVideoImageNV
#define GLEE_C_DEFINED_wglReleaseVideoImageNV
  BOOL __stdcall GLee_Lazy_wglReleaseVideoImageNV(HPBUFFERARB hPbuffer, int iVideoBuffer)  {if (GLeeInit()) return wglReleaseVideoImageNV(hPbuffer, iVideoBuffer); return (BOOL)0;}
  GLEEPFNWGLRELEASEVIDEOIMAGENVPROC GLeeFuncPtr_wglReleaseVideoImageNV=GLee_Lazy_wglReleaseVideoImageNV;
#endif
#ifndef GLEE_C_DEFINED_wglSendPbufferToVideoNV
#define GLEE_C_DEFINED_wglSendPbufferToVideoNV
  BOOL __stdcall GLee_Lazy_wglSendPbufferToVideoNV(HPBUFFERARB hPbuffer, int iBufferType, unsigned long * pulCounterPbuffer, BOOL bBlock)  {if (GLeeInit()) return wglSendPbufferToVideoNV(hPbuffer, iBufferType, pulCounterPbuffer, bBlock); return (BOOL)0;}
  GLEEPFNWGLSENDPBUFFERTOVIDEONVPROC GLeeFuncPtr_wglSendPbufferToVideoNV=GLee_Lazy_wglSendPbufferToVideoNV;
#endif
#ifndef GLEE_C_DEFINED_wglGetVideoInfoNV
#define GLEE_C_DEFINED_wglGetVideoInfoNV
  BOOL __stdcall GLee_Lazy_wglGetVideoInfoNV(HPVIDEODEV hpVideoDevice, unsigned long * pulCounterOutputPbuffer, unsigned long * pulCounterOutputVideo)  {if (GLeeInit()) return wglGetVideoInfoNV(hpVideoDevice, pulCounterOutputPbuffer, pulCounterOutputVideo); return (BOOL)0;}
  GLEEPFNWGLGETVIDEOINFONVPROC GLeeFuncPtr_wglGetVideoInfoNV=GLee_Lazy_wglGetVideoInfoNV;
#endif
#endif 
#elif defined(__APPLE__) || defined(__APPLE_CC__)
#else /* GLX */

/* Extension querying variables */

GLboolean _GLEE_GLX_VERSION_1_3 = GL_FALSE;
GLboolean _GLEE_GLX_VERSION_1_4 = GL_FALSE;
GLboolean _GLEE_GLX_ARB_multisample = GL_FALSE;
GLboolean _GLEE_GLX_ARB_fbconfig_float = GL_FALSE;
GLboolean _GLEE_GLX_ARB_create_context = GL_FALSE;
GLboolean _GLEE_GLX_SGIS_multisample = GL_FALSE;
GLboolean _GLEE_GLX_EXT_visual_info = GL_FALSE;
GLboolean _GLEE_GLX_SGI_swap_control = GL_FALSE;
GLboolean _GLEE_GLX_SGI_video_sync = GL_FALSE;
GLboolean _GLEE_GLX_SGI_make_current_read = GL_FALSE;
GLboolean _GLEE_GLX_EXT_visual_rating = GL_FALSE;
GLboolean _GLEE_GLX_EXT_import_context = GL_FALSE;
GLboolean _GLEE_GLX_SGIX_fbconfig = GL_FALSE;
GLboolean _GLEE_GLX_SGIX_pbuffer = GL_FALSE;
GLboolean _GLEE_GLX_SGI_cushion = GL_FALSE;
GLboolean _GLEE_GLX_SGIX_video_resize = GL_FALSE;
GLboolean _GLEE_GLX_SGIX_swap_group = GL_FALSE;
GLboolean _GLEE_GLX_SGIX_swap_barrier = GL_FALSE;
GLboolean _GLEE_GLX_SGIS_blended_overlay = GL_FALSE;
GLboolean _GLEE_GLX_SGIS_shared_multisample = GL_FALSE;
GLboolean _GLEE_GLX_SUN_get_transparent_index = GL_FALSE;
GLboolean _GLEE_GLX_3DFX_multisample = GL_FALSE;
GLboolean _GLEE_GLX_MESA_copy_sub_buffer = GL_FALSE;
GLboolean _GLEE_GLX_MESA_pixmap_colormap = GL_FALSE;
GLboolean _GLEE_GLX_MESA_release_buffers = GL_FALSE;
GLboolean _GLEE_GLX_MESA_set_3dfx_mode = GL_FALSE;
GLboolean _GLEE_GLX_SGIX_visual_select_group = GL_FALSE;
GLboolean _GLEE_GLX_OML_swap_method = GL_FALSE;
GLboolean _GLEE_GLX_OML_sync_control = GL_FALSE;
GLboolean _GLEE_GLX_NV_float_buffer = GL_FALSE;
GLboolean _GLEE_GLX_SGIX_hyperpipe = GL_FALSE;
GLboolean _GLEE_GLX_MESA_agp_offset = GL_FALSE;
GLboolean _GLEE_GLX_EXT_fbconfig_packed_float = GL_FALSE;
GLboolean _GLEE_GLX_EXT_framebuffer_sRGB = GL_FALSE;
GLboolean _GLEE_GLX_EXT_texture_from_pixmap = GL_FALSE;
GLboolean _GLEE_GLX_NV_present_video = GL_FALSE;
GLboolean _GLEE_GLX_NV_video_out = GL_FALSE;
GLboolean _GLEE_GLX_NV_swap_group = GL_FALSE;
GLboolean _GLEE_GLX_EXT_scene_marker = GL_FALSE;
GLboolean _GLEE_GLX_NV_video_output = GL_FALSE;

/*  GLX Extension names */

char __GLeeGLXExtensionNames[40][30]={
    "GLX_VERSION_1_3",
    "GLX_VERSION_1_4",
    "GLX_ARB_multisample",
    "GLX_ARB_fbconfig_float",
    "GLX_ARB_create_context",
    "GLX_SGIS_multisample",
    "GLX_EXT_visual_info",
    "GLX_SGI_swap_control",
    "GLX_SGI_video_sync",
    "GLX_SGI_make_current_read",
    "GLX_EXT_visual_rating",
    "GLX_EXT_import_context",
    "GLX_SGIX_fbconfig",
    "GLX_SGIX_pbuffer",
    "GLX_SGI_cushion",
    "GLX_SGIX_video_resize",
    "GLX_SGIX_swap_group",
    "GLX_SGIX_swap_barrier",
    "GLX_SGIS_blended_overlay",
    "GLX_SGIS_shared_multisample",
    "GLX_SUN_get_transparent_index",
    "GLX_3DFX_multisample",
    "GLX_MESA_copy_sub_buffer",
    "GLX_MESA_pixmap_colormap",
    "GLX_MESA_release_buffers",
    "GLX_MESA_set_3dfx_mode",
    "GLX_SGIX_visual_select_group",
    "GLX_OML_swap_method",
    "GLX_OML_sync_control",
    "GLX_NV_float_buffer",
    "GLX_SGIX_hyperpipe",
    "GLX_MESA_agp_offset",
    "GLX_EXT_fbconfig_packed_float",
    "GLX_EXT_framebuffer_sRGB",
    "GLX_EXT_texture_from_pixmap",
    "GLX_NV_present_video",
    "GLX_NV_video_out",
    "GLX_NV_swap_group",
    "GLX_EXT_scene_marker",
    "GLX_NV_video_output"
};
int __GLeeGLXNumExtensions=40;

/* GLX_VERSION_1_3 */

#ifdef __GLEE_GLX_VERSION_1_3
#ifndef GLEE_C_DEFINED_glXGetFBConfigs
#define GLEE_C_DEFINED_glXGetFBConfigs
  GLXFBConfig * __stdcall GLee_Lazy_glXGetFBConfigs(Display * dpy, int screen, int * nelements)  {if (GLeeInit()) return glXGetFBConfigs(dpy, screen, nelements); return (GLXFBConfig *)0;}
  GLEEPFNGLXGETFBCONFIGSPROC GLeeFuncPtr_glXGetFBConfigs=GLee_Lazy_glXGetFBConfigs;
#endif
#ifndef GLEE_C_DEFINED_glXChooseFBConfig
#define GLEE_C_DEFINED_glXChooseFBConfig
  GLXFBConfig * __stdcall GLee_Lazy_glXChooseFBConfig(Display * dpy, int screen, const int * attrib_list, int * nelements)  {if (GLeeInit()) return glXChooseFBConfig(dpy, screen, attrib_list, nelements); return (GLXFBConfig *)0;}
  GLEEPFNGLXCHOOSEFBCONFIGPROC GLeeFuncPtr_glXChooseFBConfig=GLee_Lazy_glXChooseFBConfig;
#endif
#ifndef GLEE_C_DEFINED_glXGetFBConfigAttrib
#define GLEE_C_DEFINED_glXGetFBConfigAttrib
  int __stdcall GLee_Lazy_glXGetFBConfigAttrib(Display * dpy, GLXFBConfig config, int attribute, int * value)  {if (GLeeInit()) return glXGetFBConfigAttrib(dpy, config, attribute, value); return (int)0;}
  GLEEPFNGLXGETFBCONFIGATTRIBPROC GLeeFuncPtr_glXGetFBConfigAttrib=GLee_Lazy_glXGetFBConfigAttrib;
#endif
#ifndef GLEE_C_DEFINED_glXGetVisualFromFBConfig
#define GLEE_C_DEFINED_glXGetVisualFromFBConfig
  XVisualInfo * __stdcall GLee_Lazy_glXGetVisualFromFBConfig(Display * dpy, GLXFBConfig config)  {if (GLeeInit()) return glXGetVisualFromFBConfig(dpy, config); return (XVisualInfo *)0;}
  GLEEPFNGLXGETVISUALFROMFBCONFIGPROC GLeeFuncPtr_glXGetVisualFromFBConfig=GLee_Lazy_glXGetVisualFromFBConfig;
#endif
#ifndef GLEE_C_DEFINED_glXCreateWindow
#define GLEE_C_DEFINED_glXCreateWindow
  GLXWindow __stdcall GLee_Lazy_glXCreateWindow(Display * dpy, GLXFBConfig config, Window win, const int * attrib_list)  {if (GLeeInit()) return glXCreateWindow(dpy, config, win, attrib_list); return (GLXWindow)0;}
  GLEEPFNGLXCREATEWINDOWPROC GLeeFuncPtr_glXCreateWindow=GLee_Lazy_glXCreateWindow;
#endif
#ifndef GLEE_C_DEFINED_glXDestroyWindow
#define GLEE_C_DEFINED_glXDestroyWindow
  void __stdcall GLee_Lazy_glXDestroyWindow(Display * dpy, GLXWindow win)  {if (GLeeInit()) glXDestroyWindow(dpy, win);}
  GLEEPFNGLXDESTROYWINDOWPROC GLeeFuncPtr_glXDestroyWindow=GLee_Lazy_glXDestroyWindow;
#endif
#ifndef GLEE_C_DEFINED_glXCreatePixmap
#define GLEE_C_DEFINED_glXCreatePixmap
  GLXPixmap __stdcall GLee_Lazy_glXCreatePixmap(Display * dpy, GLXFBConfig config, Pixmap pixmap, const int * attrib_list)  {if (GLeeInit()) return glXCreatePixmap(dpy, config, pixmap, attrib_list); return (GLXPixmap)0;}
  GLEEPFNGLXCREATEPIXMAPPROC GLeeFuncPtr_glXCreatePixmap=GLee_Lazy_glXCreatePixmap;
#endif
#ifndef GLEE_C_DEFINED_glXDestroyPixmap
#define GLEE_C_DEFINED_glXDestroyPixmap
  void __stdcall GLee_Lazy_glXDestroyPixmap(Display * dpy, GLXPixmap pixmap)  {if (GLeeInit()) glXDestroyPixmap(dpy, pixmap);}
  GLEEPFNGLXDESTROYPIXMAPPROC GLeeFuncPtr_glXDestroyPixmap=GLee_Lazy_glXDestroyPixmap;
#endif
#ifndef GLEE_C_DEFINED_glXCreatePbuffer
#define GLEE_C_DEFINED_glXCreatePbuffer
  GLXPbuffer __stdcall GLee_Lazy_glXCreatePbuffer(Display * dpy, GLXFBConfig config, const int * attrib_list)  {if (GLeeInit()) return glXCreatePbuffer(dpy, config, attrib_list); return (GLXPbuffer)0;}
  GLEEPFNGLXCREATEPBUFFERPROC GLeeFuncPtr_glXCreatePbuffer=GLee_Lazy_glXCreatePbuffer;
#endif
#ifndef GLEE_C_DEFINED_glXDestroyPbuffer
#define GLEE_C_DEFINED_glXDestroyPbuffer
  void __stdcall GLee_Lazy_glXDestroyPbuffer(Display * dpy, GLXPbuffer pbuf)  {if (GLeeInit()) glXDestroyPbuffer(dpy, pbuf);}
  GLEEPFNGLXDESTROYPBUFFERPROC GLeeFuncPtr_glXDestroyPbuffer=GLee_Lazy_glXDestroyPbuffer;
#endif
#ifndef GLEE_C_DEFINED_glXQueryDrawable
#define GLEE_C_DEFINED_glXQueryDrawable
  void __stdcall GLee_Lazy_glXQueryDrawable(Display * dpy, GLXDrawable draw, int attribute, unsigned int * value)  {if (GLeeInit()) glXQueryDrawable(dpy, draw, attribute, value);}
  GLEEPFNGLXQUERYDRAWABLEPROC GLeeFuncPtr_glXQueryDrawable=GLee_Lazy_glXQueryDrawable;
#endif
#ifndef GLEE_C_DEFINED_glXCreateNewContext
#define GLEE_C_DEFINED_glXCreateNewContext
  GLXContext __stdcall GLee_Lazy_glXCreateNewContext(Display * dpy, GLXFBConfig config, int render_type, GLXContext share_list, Bool direct)  {if (GLeeInit()) return glXCreateNewContext(dpy, config, render_type, share_list, direct); return (GLXContext)0;}
  GLEEPFNGLXCREATENEWCONTEXTPROC GLeeFuncPtr_glXCreateNewContext=GLee_Lazy_glXCreateNewContext;
#endif
#ifndef GLEE_C_DEFINED_glXMakeContextCurrent
#define GLEE_C_DEFINED_glXMakeContextCurrent
  Bool __stdcall GLee_Lazy_glXMakeContextCurrent(Display * dpy, GLXDrawable draw, GLXDrawable read, GLXContext ctx)  {if (GLeeInit()) return glXMakeContextCurrent(dpy, draw, read, ctx); return (Bool)0;}
  GLEEPFNGLXMAKECONTEXTCURRENTPROC GLeeFuncPtr_glXMakeContextCurrent=GLee_Lazy_glXMakeContextCurrent;
#endif
#ifndef GLEE_C_DEFINED_glXGetCurrentReadDrawable
#define GLEE_C_DEFINED_glXGetCurrentReadDrawable
  GLXDrawable __stdcall GLee_Lazy_glXGetCurrentReadDrawable(void)  {if (GLeeInit()) return glXGetCurrentReadDrawable(); return (GLXDrawable)0;}
  GLEEPFNGLXGETCURRENTREADDRAWABLEPROC GLeeFuncPtr_glXGetCurrentReadDrawable=GLee_Lazy_glXGetCurrentReadDrawable;
#endif
#ifndef GLEE_C_DEFINED_glXGetCurrentDisplay
#define GLEE_C_DEFINED_glXGetCurrentDisplay
  Display * __stdcall GLee_Lazy_glXGetCurrentDisplay(void)  {if (GLeeInit()) return glXGetCurrentDisplay(); return (Display *)0;}
  GLEEPFNGLXGETCURRENTDISPLAYPROC GLeeFuncPtr_glXGetCurrentDisplay=GLee_Lazy_glXGetCurrentDisplay;
#endif
#ifndef GLEE_C_DEFINED_glXQueryContext
#define GLEE_C_DEFINED_glXQueryContext
  int __stdcall GLee_Lazy_glXQueryContext(Display * dpy, GLXContext ctx, int attribute, int * value)  {if (GLeeInit()) return glXQueryContext(dpy, ctx, attribute, value); return (int)0;}
  GLEEPFNGLXQUERYCONTEXTPROC GLeeFuncPtr_glXQueryContext=GLee_Lazy_glXQueryContext;
#endif
#ifndef GLEE_C_DEFINED_glXSelectEvent
#define GLEE_C_DEFINED_glXSelectEvent
  void __stdcall GLee_Lazy_glXSelectEvent(Display * dpy, GLXDrawable draw, unsigned long event_mask)  {if (GLeeInit()) glXSelectEvent(dpy, draw, event_mask);}
  GLEEPFNGLXSELECTEVENTPROC GLeeFuncPtr_glXSelectEvent=GLee_Lazy_glXSelectEvent;
#endif
#ifndef GLEE_C_DEFINED_glXGetSelectedEvent
#define GLEE_C_DEFINED_glXGetSelectedEvent
  void __stdcall GLee_Lazy_glXGetSelectedEvent(Display * dpy, GLXDrawable draw, unsigned long * event_mask)  {if (GLeeInit()) glXGetSelectedEvent(dpy, draw, event_mask);}
  GLEEPFNGLXGETSELECTEDEVENTPROC GLeeFuncPtr_glXGetSelectedEvent=GLee_Lazy_glXGetSelectedEvent;
#endif
#endif 

/* GLX_VERSION_1_4 */

#ifdef __GLEE_GLX_VERSION_1_4
#ifndef GLEE_C_DEFINED_glXGetProcAddress
#define GLEE_C_DEFINED_glXGetProcAddress
  __GLXextFuncPtr __stdcall GLee_Lazy_glXGetProcAddress(const GLubyte * procName)  {if (GLeeInit()) return glXGetProcAddress(procName); return (__GLXextFuncPtr)0;}
  GLEEPFNGLXGETPROCADDRESSPROC GLeeFuncPtr_glXGetProcAddress=GLee_Lazy_glXGetProcAddress;
#endif
#endif 

/* GLX_ARB_multisample */

#ifdef __GLEE_GLX_ARB_multisample
#endif 

/* GLX_ARB_fbconfig_float */

#ifdef __GLEE_GLX_ARB_fbconfig_float
#endif 

/* GLX_ARB_create_context */

#ifdef __GLEE_GLX_ARB_create_context
#ifndef GLEE_C_DEFINED_glXCreateContextAttribsARB
#define GLEE_C_DEFINED_glXCreateContextAttribsARB
  GLXContext __stdcall GLee_Lazy_glXCreateContextAttribsARB(Display * dpy, GLXFBConfig config, GLXContext share_context, Bool direct, const int * attrib_list)  {if (GLeeInit()) return glXCreateContextAttribsARB(dpy, config, share_context, direct, attrib_list); return (GLXContext)0;}
  GLEEPFNGLXCREATECONTEXTATTRIBSARBPROC GLeeFuncPtr_glXCreateContextAttribsARB=GLee_Lazy_glXCreateContextAttribsARB;
#endif
#endif 

/* GLX_SGIS_multisample */

#ifdef __GLEE_GLX_SGIS_multisample
#endif 

/* GLX_EXT_visual_info */

#ifdef __GLEE_GLX_EXT_visual_info
#endif 

/* GLX_SGI_swap_control */

#ifdef __GLEE_GLX_SGI_swap_control
#ifndef GLEE_C_DEFINED_glXSwapIntervalSGI
#define GLEE_C_DEFINED_glXSwapIntervalSGI
  int __stdcall GLee_Lazy_glXSwapIntervalSGI(int interval)  {if (GLeeInit()) return glXSwapIntervalSGI(interval); return (int)0;}
  GLEEPFNGLXSWAPINTERVALSGIPROC GLeeFuncPtr_glXSwapIntervalSGI=GLee_Lazy_glXSwapIntervalSGI;
#endif
#endif 

/* GLX_SGI_video_sync */

#ifdef __GLEE_GLX_SGI_video_sync
#ifndef GLEE_C_DEFINED_glXGetVideoSyncSGI
#define GLEE_C_DEFINED_glXGetVideoSyncSGI
  int __stdcall GLee_Lazy_glXGetVideoSyncSGI(unsigned int * count)  {if (GLeeInit()) return glXGetVideoSyncSGI(count); return (int)0;}
  GLEEPFNGLXGETVIDEOSYNCSGIPROC GLeeFuncPtr_glXGetVideoSyncSGI=GLee_Lazy_glXGetVideoSyncSGI;
#endif
#ifndef GLEE_C_DEFINED_glXWaitVideoSyncSGI
#define GLEE_C_DEFINED_glXWaitVideoSyncSGI
  int __stdcall GLee_Lazy_glXWaitVideoSyncSGI(int divisor, int remainder, unsigned int * count)  {if (GLeeInit()) return glXWaitVideoSyncSGI(divisor, remainder, count); return (int)0;}
  GLEEPFNGLXWAITVIDEOSYNCSGIPROC GLeeFuncPtr_glXWaitVideoSyncSGI=GLee_Lazy_glXWaitVideoSyncSGI;
#endif
#endif 

/* GLX_SGI_make_current_read */

#ifdef __GLEE_GLX_SGI_make_current_read
#ifndef GLEE_C_DEFINED_glXMakeCurrentReadSGI
#define GLEE_C_DEFINED_glXMakeCurrentReadSGI
  Bool __stdcall GLee_Lazy_glXMakeCurrentReadSGI(Display * dpy, GLXDrawable draw, GLXDrawable read, GLXContext ctx)  {if (GLeeInit()) return glXMakeCurrentReadSGI(dpy, draw, read, ctx); return (Bool)0;}
  GLEEPFNGLXMAKECURRENTREADSGIPROC GLeeFuncPtr_glXMakeCurrentReadSGI=GLee_Lazy_glXMakeCurrentReadSGI;
#endif
#ifndef GLEE_C_DEFINED_glXGetCurrentReadDrawableSGI
#define GLEE_C_DEFINED_glXGetCurrentReadDrawableSGI
  GLXDrawable __stdcall GLee_Lazy_glXGetCurrentReadDrawableSGI(void)  {if (GLeeInit()) return glXGetCurrentReadDrawableSGI(); return (GLXDrawable)0;}
  GLEEPFNGLXGETCURRENTREADDRAWABLESGIPROC GLeeFuncPtr_glXGetCurrentReadDrawableSGI=GLee_Lazy_glXGetCurrentReadDrawableSGI;
#endif
#endif 

/* GLX_EXT_visual_rating */

#ifdef __GLEE_GLX_EXT_visual_rating
#endif 

/* GLX_EXT_import_context */

#ifdef __GLEE_GLX_EXT_import_context
#ifndef GLEE_C_DEFINED_glXGetCurrentDisplayEXT
#define GLEE_C_DEFINED_glXGetCurrentDisplayEXT
  Display * __stdcall GLee_Lazy_glXGetCurrentDisplayEXT(void)  {if (GLeeInit()) return glXGetCurrentDisplayEXT(); return (Display *)0;}
  GLEEPFNGLXGETCURRENTDISPLAYEXTPROC GLeeFuncPtr_glXGetCurrentDisplayEXT=GLee_Lazy_glXGetCurrentDisplayEXT;
#endif
#ifndef GLEE_C_DEFINED_glXQueryContextInfoEXT
#define GLEE_C_DEFINED_glXQueryContextInfoEXT
  int __stdcall GLee_Lazy_glXQueryContextInfoEXT(Display * dpy, GLXContext context, int attribute, int * value)  {if (GLeeInit()) return glXQueryContextInfoEXT(dpy, context, attribute, value); return (int)0;}
  GLEEPFNGLXQUERYCONTEXTINFOEXTPROC GLeeFuncPtr_glXQueryContextInfoEXT=GLee_Lazy_glXQueryContextInfoEXT;
#endif
#ifndef GLEE_C_DEFINED_glXGetContextIDEXT
#define GLEE_C_DEFINED_glXGetContextIDEXT
  GLXContextID __stdcall GLee_Lazy_glXGetContextIDEXT(const GLXContext context)  {if (GLeeInit()) return glXGetContextIDEXT(context); return (GLXContextID)0;}
  GLEEPFNGLXGETCONTEXTIDEXTPROC GLeeFuncPtr_glXGetContextIDEXT=GLee_Lazy_glXGetContextIDEXT;
#endif
#ifndef GLEE_C_DEFINED_glXImportContextEXT
#define GLEE_C_DEFINED_glXImportContextEXT
  GLXContext __stdcall GLee_Lazy_glXImportContextEXT(Display * dpy, GLXContextID contextID)  {if (GLeeInit()) return glXImportContextEXT(dpy, contextID); return (GLXContext)0;}
  GLEEPFNGLXIMPORTCONTEXTEXTPROC GLeeFuncPtr_glXImportContextEXT=GLee_Lazy_glXImportContextEXT;
#endif
#ifndef GLEE_C_DEFINED_glXFreeContextEXT
#define GLEE_C_DEFINED_glXFreeContextEXT
  void __stdcall GLee_Lazy_glXFreeContextEXT(Display * dpy, GLXContext context)  {if (GLeeInit()) glXFreeContextEXT(dpy, context);}
  GLEEPFNGLXFREECONTEXTEXTPROC GLeeFuncPtr_glXFreeContextEXT=GLee_Lazy_glXFreeContextEXT;
#endif
#endif 

/* GLX_SGIX_fbconfig */

#ifdef __GLEE_GLX_SGIX_fbconfig
#ifndef GLEE_C_DEFINED_glXGetFBConfigAttribSGIX
#define GLEE_C_DEFINED_glXGetFBConfigAttribSGIX
  int __stdcall GLee_Lazy_glXGetFBConfigAttribSGIX(Display * dpy, GLXFBConfigSGIX config, int attribute, int * value)  {if (GLeeInit()) return glXGetFBConfigAttribSGIX(dpy, config, attribute, value); return (int)0;}
  GLEEPFNGLXGETFBCONFIGATTRIBSGIXPROC GLeeFuncPtr_glXGetFBConfigAttribSGIX=GLee_Lazy_glXGetFBConfigAttribSGIX;
#endif
#ifndef GLEE_C_DEFINED_glXChooseFBConfigSGIX
#define GLEE_C_DEFINED_glXChooseFBConfigSGIX
  GLXFBConfigSGIX * __stdcall GLee_Lazy_glXChooseFBConfigSGIX(Display * dpy, int screen, int * attrib_list, int * nelements)  {if (GLeeInit()) return glXChooseFBConfigSGIX(dpy, screen, attrib_list, nelements); return (GLXFBConfigSGIX *)0;}
  GLEEPFNGLXCHOOSEFBCONFIGSGIXPROC GLeeFuncPtr_glXChooseFBConfigSGIX=GLee_Lazy_glXChooseFBConfigSGIX;
#endif
#ifndef GLEE_C_DEFINED_glXCreateGLXPixmapWithConfigSGIX
#define GLEE_C_DEFINED_glXCreateGLXPixmapWithConfigSGIX
  GLXPixmap __stdcall GLee_Lazy_glXCreateGLXPixmapWithConfigSGIX(Display * dpy, GLXFBConfigSGIX config, Pixmap pixmap)  {if (GLeeInit()) return glXCreateGLXPixmapWithConfigSGIX(dpy, config, pixmap); return (GLXPixmap)0;}
  GLEEPFNGLXCREATEGLXPIXMAPWITHCONFIGSGIXPROC GLeeFuncPtr_glXCreateGLXPixmapWithConfigSGIX=GLee_Lazy_glXCreateGLXPixmapWithConfigSGIX;
#endif
#ifndef GLEE_C_DEFINED_glXCreateContextWithConfigSGIX
#define GLEE_C_DEFINED_glXCreateContextWithConfigSGIX
  GLXContext __stdcall GLee_Lazy_glXCreateContextWithConfigSGIX(Display * dpy, GLXFBConfigSGIX config, int render_type, GLXContext share_list, Bool direct)  {if (GLeeInit()) return glXCreateContextWithConfigSGIX(dpy, config, render_type, share_list, direct); return (GLXContext)0;}
  GLEEPFNGLXCREATECONTEXTWITHCONFIGSGIXPROC GLeeFuncPtr_glXCreateContextWithConfigSGIX=GLee_Lazy_glXCreateContextWithConfigSGIX;
#endif
#ifndef GLEE_C_DEFINED_glXGetVisualFromFBConfigSGIX
#define GLEE_C_DEFINED_glXGetVisualFromFBConfigSGIX
  XVisualInfo * __stdcall GLee_Lazy_glXGetVisualFromFBConfigSGIX(Display * dpy, GLXFBConfigSGIX config)  {if (GLeeInit()) return glXGetVisualFromFBConfigSGIX(dpy, config); return (XVisualInfo *)0;}
  GLEEPFNGLXGETVISUALFROMFBCONFIGSGIXPROC GLeeFuncPtr_glXGetVisualFromFBConfigSGIX=GLee_Lazy_glXGetVisualFromFBConfigSGIX;
#endif
#ifndef GLEE_C_DEFINED_glXGetFBConfigFromVisualSGIX
#define GLEE_C_DEFINED_glXGetFBConfigFromVisualSGIX
  GLXFBConfigSGIX __stdcall GLee_Lazy_glXGetFBConfigFromVisualSGIX(Display * dpy, XVisualInfo * vis)  {if (GLeeInit()) return glXGetFBConfigFromVisualSGIX(dpy, vis); return (GLXFBConfigSGIX)0;}
  GLEEPFNGLXGETFBCONFIGFROMVISUALSGIXPROC GLeeFuncPtr_glXGetFBConfigFromVisualSGIX=GLee_Lazy_glXGetFBConfigFromVisualSGIX;
#endif
#endif 

/* GLX_SGIX_pbuffer */

#ifdef __GLEE_GLX_SGIX_pbuffer
#ifndef GLEE_C_DEFINED_glXCreateGLXPbufferSGIX
#define GLEE_C_DEFINED_glXCreateGLXPbufferSGIX
  GLXPbufferSGIX __stdcall GLee_Lazy_glXCreateGLXPbufferSGIX(Display * dpy, GLXFBConfigSGIX config, unsigned int width, unsigned int height, int * attrib_list)  {if (GLeeInit()) return glXCreateGLXPbufferSGIX(dpy, config, width, height, attrib_list); return (GLXPbufferSGIX)0;}
  GLEEPFNGLXCREATEGLXPBUFFERSGIXPROC GLeeFuncPtr_glXCreateGLXPbufferSGIX=GLee_Lazy_glXCreateGLXPbufferSGIX;
#endif
#ifndef GLEE_C_DEFINED_glXDestroyGLXPbufferSGIX
#define GLEE_C_DEFINED_glXDestroyGLXPbufferSGIX
  void __stdcall GLee_Lazy_glXDestroyGLXPbufferSGIX(Display * dpy, GLXPbufferSGIX pbuf)  {if (GLeeInit()) glXDestroyGLXPbufferSGIX(dpy, pbuf);}
  GLEEPFNGLXDESTROYGLXPBUFFERSGIXPROC GLeeFuncPtr_glXDestroyGLXPbufferSGIX=GLee_Lazy_glXDestroyGLXPbufferSGIX;
#endif
#ifndef GLEE_C_DEFINED_glXQueryGLXPbufferSGIX
#define GLEE_C_DEFINED_glXQueryGLXPbufferSGIX
  int __stdcall GLee_Lazy_glXQueryGLXPbufferSGIX(Display * dpy, GLXPbufferSGIX pbuf, int attribute, unsigned int * value)  {if (GLeeInit()) return glXQueryGLXPbufferSGIX(dpy, pbuf, attribute, value); return (int)0;}
  GLEEPFNGLXQUERYGLXPBUFFERSGIXPROC GLeeFuncPtr_glXQueryGLXPbufferSGIX=GLee_Lazy_glXQueryGLXPbufferSGIX;
#endif
#ifndef GLEE_C_DEFINED_glXSelectEventSGIX
#define GLEE_C_DEFINED_glXSelectEventSGIX
  void __stdcall GLee_Lazy_glXSelectEventSGIX(Display * dpy, GLXDrawable drawable, unsigned long mask)  {if (GLeeInit()) glXSelectEventSGIX(dpy, drawable, mask);}
  GLEEPFNGLXSELECTEVENTSGIXPROC GLeeFuncPtr_glXSelectEventSGIX=GLee_Lazy_glXSelectEventSGIX;
#endif
#ifndef GLEE_C_DEFINED_glXGetSelectedEventSGIX
#define GLEE_C_DEFINED_glXGetSelectedEventSGIX
  void __stdcall GLee_Lazy_glXGetSelectedEventSGIX(Display * dpy, GLXDrawable drawable, unsigned long * mask)  {if (GLeeInit()) glXGetSelectedEventSGIX(dpy, drawable, mask);}
  GLEEPFNGLXGETSELECTEDEVENTSGIXPROC GLeeFuncPtr_glXGetSelectedEventSGIX=GLee_Lazy_glXGetSelectedEventSGIX;
#endif
#endif 

/* GLX_SGI_cushion */

#ifdef __GLEE_GLX_SGI_cushion
#ifndef GLEE_C_DEFINED_glXCushionSGI
#define GLEE_C_DEFINED_glXCushionSGI
  void __stdcall GLee_Lazy_glXCushionSGI(Display * dpy, Window window, float cushion)  {if (GLeeInit()) glXCushionSGI(dpy, window, cushion);}
  GLEEPFNGLXCUSHIONSGIPROC GLeeFuncPtr_glXCushionSGI=GLee_Lazy_glXCushionSGI;
#endif
#endif 

/* GLX_SGIX_video_resize */

#ifdef __GLEE_GLX_SGIX_video_resize
#ifndef GLEE_C_DEFINED_glXBindChannelToWindowSGIX
#define GLEE_C_DEFINED_glXBindChannelToWindowSGIX
  int __stdcall GLee_Lazy_glXBindChannelToWindowSGIX(Display * display, int screen, int channel, Window window)  {if (GLeeInit()) return glXBindChannelToWindowSGIX(display, screen, channel, window); return (int)0;}
  GLEEPFNGLXBINDCHANNELTOWINDOWSGIXPROC GLeeFuncPtr_glXBindChannelToWindowSGIX=GLee_Lazy_glXBindChannelToWindowSGIX;
#endif
#ifndef GLEE_C_DEFINED_glXChannelRectSGIX
#define GLEE_C_DEFINED_glXChannelRectSGIX
  int __stdcall GLee_Lazy_glXChannelRectSGIX(Display * display, int screen, int channel, int x, int y, int w, int h)  {if (GLeeInit()) return glXChannelRectSGIX(display, screen, channel, x, y, w, h); return (int)0;}
  GLEEPFNGLXCHANNELRECTSGIXPROC GLeeFuncPtr_glXChannelRectSGIX=GLee_Lazy_glXChannelRectSGIX;
#endif
#ifndef GLEE_C_DEFINED_glXQueryChannelRectSGIX
#define GLEE_C_DEFINED_glXQueryChannelRectSGIX
  int __stdcall GLee_Lazy_glXQueryChannelRectSGIX(Display * display, int screen, int channel, int * dx, int * dy, int * dw, int * dh)  {if (GLeeInit()) return glXQueryChannelRectSGIX(display, screen, channel, dx, dy, dw, dh); return (int)0;}
  GLEEPFNGLXQUERYCHANNELRECTSGIXPROC GLeeFuncPtr_glXQueryChannelRectSGIX=GLee_Lazy_glXQueryChannelRectSGIX;
#endif
#ifndef GLEE_C_DEFINED_glXQueryChannelDeltasSGIX
#define GLEE_C_DEFINED_glXQueryChannelDeltasSGIX
  int __stdcall GLee_Lazy_glXQueryChannelDeltasSGIX(Display * display, int screen, int channel, int * x, int * y, int * w, int * h)  {if (GLeeInit()) return glXQueryChannelDeltasSGIX(display, screen, channel, x, y, w, h); return (int)0;}
  GLEEPFNGLXQUERYCHANNELDELTASSGIXPROC GLeeFuncPtr_glXQueryChannelDeltasSGIX=GLee_Lazy_glXQueryChannelDeltasSGIX;
#endif
#ifndef GLEE_C_DEFINED_glXChannelRectSyncSGIX
#define GLEE_C_DEFINED_glXChannelRectSyncSGIX
  int __stdcall GLee_Lazy_glXChannelRectSyncSGIX(Display * display, int screen, int channel, GLenum synctype)  {if (GLeeInit()) return glXChannelRectSyncSGIX(display, screen, channel, synctype); return (int)0;}
  GLEEPFNGLXCHANNELRECTSYNCSGIXPROC GLeeFuncPtr_glXChannelRectSyncSGIX=GLee_Lazy_glXChannelRectSyncSGIX;
#endif
#endif 

/* GLX_SGIX_swap_group */

#ifdef __GLEE_GLX_SGIX_swap_group
#ifndef GLEE_C_DEFINED_glXJoinSwapGroupSGIX
#define GLEE_C_DEFINED_glXJoinSwapGroupSGIX
  void __stdcall GLee_Lazy_glXJoinSwapGroupSGIX(Display * dpy, GLXDrawable drawable, GLXDrawable member)  {if (GLeeInit()) glXJoinSwapGroupSGIX(dpy, drawable, member);}
  GLEEPFNGLXJOINSWAPGROUPSGIXPROC GLeeFuncPtr_glXJoinSwapGroupSGIX=GLee_Lazy_glXJoinSwapGroupSGIX;
#endif
#endif 

/* GLX_SGIX_swap_barrier */

#ifdef __GLEE_GLX_SGIX_swap_barrier
#ifndef GLEE_C_DEFINED_glXBindSwapBarrierSGIX
#define GLEE_C_DEFINED_glXBindSwapBarrierSGIX
  void __stdcall GLee_Lazy_glXBindSwapBarrierSGIX(Display * dpy, GLXDrawable drawable, int barrier)  {if (GLeeInit()) glXBindSwapBarrierSGIX(dpy, drawable, barrier);}
  GLEEPFNGLXBINDSWAPBARRIERSGIXPROC GLeeFuncPtr_glXBindSwapBarrierSGIX=GLee_Lazy_glXBindSwapBarrierSGIX;
#endif
#ifndef GLEE_C_DEFINED_glXQueryMaxSwapBarriersSGIX
#define GLEE_C_DEFINED_glXQueryMaxSwapBarriersSGIX
  Bool __stdcall GLee_Lazy_glXQueryMaxSwapBarriersSGIX(Display * dpy, int screen, int * max)  {if (GLeeInit()) return glXQueryMaxSwapBarriersSGIX(dpy, screen, max); return (Bool)0;}
  GLEEPFNGLXQUERYMAXSWAPBARRIERSSGIXPROC GLeeFuncPtr_glXQueryMaxSwapBarriersSGIX=GLee_Lazy_glXQueryMaxSwapBarriersSGIX;
#endif
#endif 

/* GLX_SGIS_blended_overlay */

#ifdef __GLEE_GLX_SGIS_blended_overlay
#endif 

/* GLX_SGIS_shared_multisample */

#ifdef __GLEE_GLX_SGIS_shared_multisample
#endif 

/* GLX_SUN_get_transparent_index */

#ifdef __GLEE_GLX_SUN_get_transparent_index
#ifndef GLEE_C_DEFINED_glXGetTransparentIndexSUN
#define GLEE_C_DEFINED_glXGetTransparentIndexSUN
  Status __stdcall GLee_Lazy_glXGetTransparentIndexSUN(Display * dpy, Window overlay, Window underlay, long * pTransparentIndex)  {if (GLeeInit()) return glXGetTransparentIndexSUN(dpy, overlay, underlay, pTransparentIndex); return (Status)0;}
  GLEEPFNGLXGETTRANSPARENTINDEXSUNPROC GLeeFuncPtr_glXGetTransparentIndexSUN=GLee_Lazy_glXGetTransparentIndexSUN;
#endif
#endif 

/* GLX_3DFX_multisample */

#ifdef __GLEE_GLX_3DFX_multisample
#endif 

/* GLX_MESA_copy_sub_buffer */

#ifdef __GLEE_GLX_MESA_copy_sub_buffer
#ifndef GLEE_C_DEFINED_glXCopySubBufferMESA
#define GLEE_C_DEFINED_glXCopySubBufferMESA
  void __stdcall GLee_Lazy_glXCopySubBufferMESA(Display * dpy, GLXDrawable drawable, int x, int y, int width, int height)  {if (GLeeInit()) glXCopySubBufferMESA(dpy, drawable, x, y, width, height);}
  GLEEPFNGLXCOPYSUBBUFFERMESAPROC GLeeFuncPtr_glXCopySubBufferMESA=GLee_Lazy_glXCopySubBufferMESA;
#endif
#endif 

/* GLX_MESA_pixmap_colormap */

#ifdef __GLEE_GLX_MESA_pixmap_colormap
#ifndef GLEE_C_DEFINED_glXCreateGLXPixmapMESA
#define GLEE_C_DEFINED_glXCreateGLXPixmapMESA
  GLXPixmap __stdcall GLee_Lazy_glXCreateGLXPixmapMESA(Display * dpy, XVisualInfo * visual, Pixmap pixmap, Colormap cmap)  {if (GLeeInit()) return glXCreateGLXPixmapMESA(dpy, visual, pixmap, cmap); return (GLXPixmap)0;}
  GLEEPFNGLXCREATEGLXPIXMAPMESAPROC GLeeFuncPtr_glXCreateGLXPixmapMESA=GLee_Lazy_glXCreateGLXPixmapMESA;
#endif
#endif 

/* GLX_MESA_release_buffers */

#ifdef __GLEE_GLX_MESA_release_buffers
#ifndef GLEE_C_DEFINED_glXReleaseBuffersMESA
#define GLEE_C_DEFINED_glXReleaseBuffersMESA
  Bool __stdcall GLee_Lazy_glXReleaseBuffersMESA(Display * dpy, GLXDrawable drawable)  {if (GLeeInit()) return glXReleaseBuffersMESA(dpy, drawable); return (Bool)0;}
  GLEEPFNGLXRELEASEBUFFERSMESAPROC GLeeFuncPtr_glXReleaseBuffersMESA=GLee_Lazy_glXReleaseBuffersMESA;
#endif
#endif 

/* GLX_MESA_set_3dfx_mode */

#ifdef __GLEE_GLX_MESA_set_3dfx_mode
#ifndef GLEE_C_DEFINED_glXSet3DfxModeMESA
#define GLEE_C_DEFINED_glXSet3DfxModeMESA
  Bool __stdcall GLee_Lazy_glXSet3DfxModeMESA(int mode)  {if (GLeeInit()) return glXSet3DfxModeMESA(mode); return (Bool)0;}
  GLEEPFNGLXSET3DFXMODEMESAPROC GLeeFuncPtr_glXSet3DfxModeMESA=GLee_Lazy_glXSet3DfxModeMESA;
#endif
#endif 

/* GLX_SGIX_visual_select_group */

#ifdef __GLEE_GLX_SGIX_visual_select_group
#endif 

/* GLX_OML_swap_method */

#ifdef __GLEE_GLX_OML_swap_method
#endif 

/* GLX_OML_sync_control */

#ifdef __GLEE_GLX_OML_sync_control
#ifndef GLEE_C_DEFINED_glXGetSyncValuesOML
#define GLEE_C_DEFINED_glXGetSyncValuesOML
  Bool __stdcall GLee_Lazy_glXGetSyncValuesOML(Display * dpy, GLXDrawable drawable, int64_t * ust, int64_t * msc, int64_t * sbc)  {if (GLeeInit()) return glXGetSyncValuesOML(dpy, drawable, ust, msc, sbc); return (Bool)0;}
  GLEEPFNGLXGETSYNCVALUESOMLPROC GLeeFuncPtr_glXGetSyncValuesOML=GLee_Lazy_glXGetSyncValuesOML;
#endif
#ifndef GLEE_C_DEFINED_glXGetMscRateOML
#define GLEE_C_DEFINED_glXGetMscRateOML
  Bool __stdcall GLee_Lazy_glXGetMscRateOML(Display * dpy, GLXDrawable drawable, int32_t * numerator, int32_t * denominator)  {if (GLeeInit()) return glXGetMscRateOML(dpy, drawable, numerator, denominator); return (Bool)0;}
  GLEEPFNGLXGETMSCRATEOMLPROC GLeeFuncPtr_glXGetMscRateOML=GLee_Lazy_glXGetMscRateOML;
#endif
#ifndef GLEE_C_DEFINED_glXSwapBuffersMscOML
#define GLEE_C_DEFINED_glXSwapBuffersMscOML
  int64_t __stdcall GLee_Lazy_glXSwapBuffersMscOML(Display * dpy, GLXDrawable drawable, int64_t target_msc, int64_t divisor, int64_t remainder)  {if (GLeeInit()) return glXSwapBuffersMscOML(dpy, drawable, target_msc, divisor, remainder); return (int64_t)0;}
  GLEEPFNGLXSWAPBUFFERSMSCOMLPROC GLeeFuncPtr_glXSwapBuffersMscOML=GLee_Lazy_glXSwapBuffersMscOML;
#endif
#ifndef GLEE_C_DEFINED_glXWaitForMscOML
#define GLEE_C_DEFINED_glXWaitForMscOML
  Bool __stdcall GLee_Lazy_glXWaitForMscOML(Display * dpy, GLXDrawable drawable, int64_t target_msc, int64_t divisor, int64_t remainder, int64_t * ust, int64_t * msc, int64_t * sbc)  {if (GLeeInit()) return glXWaitForMscOML(dpy, drawable, target_msc, divisor, remainder, ust, msc, sbc); return (Bool)0;}
  GLEEPFNGLXWAITFORMSCOMLPROC GLeeFuncPtr_glXWaitForMscOML=GLee_Lazy_glXWaitForMscOML;
#endif
#ifndef GLEE_C_DEFINED_glXWaitForSbcOML
#define GLEE_C_DEFINED_glXWaitForSbcOML
  Bool __stdcall GLee_Lazy_glXWaitForSbcOML(Display * dpy, GLXDrawable drawable, int64_t target_sbc, int64_t * ust, int64_t * msc, int64_t * sbc)  {if (GLeeInit()) return glXWaitForSbcOML(dpy, drawable, target_sbc, ust, msc, sbc); return (Bool)0;}
  GLEEPFNGLXWAITFORSBCOMLPROC GLeeFuncPtr_glXWaitForSbcOML=GLee_Lazy_glXWaitForSbcOML;
#endif
#endif 

/* GLX_NV_float_buffer */

#ifdef __GLEE_GLX_NV_float_buffer
#endif 

/* GLX_SGIX_hyperpipe */

#ifdef __GLEE_GLX_SGIX_hyperpipe
#ifndef GLEE_C_DEFINED_glXQueryHyperpipeNetworkSGIX
#define GLEE_C_DEFINED_glXQueryHyperpipeNetworkSGIX
  GLXHyperpipeNetworkSGIX * __stdcall GLee_Lazy_glXQueryHyperpipeNetworkSGIX(Display * dpy, int * npipes)  {if (GLeeInit()) return glXQueryHyperpipeNetworkSGIX(dpy, npipes); return (GLXHyperpipeNetworkSGIX *)0;}
  GLEEPFNGLXQUERYHYPERPIPENETWORKSGIXPROC GLeeFuncPtr_glXQueryHyperpipeNetworkSGIX=GLee_Lazy_glXQueryHyperpipeNetworkSGIX;
#endif
#ifndef GLEE_C_DEFINED_glXHyperpipeConfigSGIX
#define GLEE_C_DEFINED_glXHyperpipeConfigSGIX
  int __stdcall GLee_Lazy_glXHyperpipeConfigSGIX(Display * dpy, int networkId, int npipes, GLXHyperpipeConfigSGIX * cfg, int * hpId)  {if (GLeeInit()) return glXHyperpipeConfigSGIX(dpy, networkId, npipes, cfg, hpId); return (int)0;}
  GLEEPFNGLXHYPERPIPECONFIGSGIXPROC GLeeFuncPtr_glXHyperpipeConfigSGIX=GLee_Lazy_glXHyperpipeConfigSGIX;
#endif
#ifndef GLEE_C_DEFINED_glXQueryHyperpipeConfigSGIX
#define GLEE_C_DEFINED_glXQueryHyperpipeConfigSGIX
  GLXHyperpipeConfigSGIX * __stdcall GLee_Lazy_glXQueryHyperpipeConfigSGIX(Display * dpy, int hpId, int * npipes)  {if (GLeeInit()) return glXQueryHyperpipeConfigSGIX(dpy, hpId, npipes); return (GLXHyperpipeConfigSGIX *)0;}
  GLEEPFNGLXQUERYHYPERPIPECONFIGSGIXPROC GLeeFuncPtr_glXQueryHyperpipeConfigSGIX=GLee_Lazy_glXQueryHyperpipeConfigSGIX;
#endif
#ifndef GLEE_C_DEFINED_glXDestroyHyperpipeConfigSGIX
#define GLEE_C_DEFINED_glXDestroyHyperpipeConfigSGIX
  int __stdcall GLee_Lazy_glXDestroyHyperpipeConfigSGIX(Display * dpy, int hpId)  {if (GLeeInit()) return glXDestroyHyperpipeConfigSGIX(dpy, hpId); return (int)0;}
  GLEEPFNGLXDESTROYHYPERPIPECONFIGSGIXPROC GLeeFuncPtr_glXDestroyHyperpipeConfigSGIX=GLee_Lazy_glXDestroyHyperpipeConfigSGIX;
#endif
#ifndef GLEE_C_DEFINED_glXBindHyperpipeSGIX
#define GLEE_C_DEFINED_glXBindHyperpipeSGIX
  int __stdcall GLee_Lazy_glXBindHyperpipeSGIX(Display * dpy, int hpId)  {if (GLeeInit()) return glXBindHyperpipeSGIX(dpy, hpId); return (int)0;}
  GLEEPFNGLXBINDHYPERPIPESGIXPROC GLeeFuncPtr_glXBindHyperpipeSGIX=GLee_Lazy_glXBindHyperpipeSGIX;
#endif
#ifndef GLEE_C_DEFINED_glXQueryHyperpipeBestAttribSGIX
#define GLEE_C_DEFINED_glXQueryHyperpipeBestAttribSGIX
  int __stdcall GLee_Lazy_glXQueryHyperpipeBestAttribSGIX(Display * dpy, int timeSlice, int attrib, int size, void * attribList, void * returnAttribList)  {if (GLeeInit()) return glXQueryHyperpipeBestAttribSGIX(dpy, timeSlice, attrib, size, attribList, returnAttribList); return (int)0;}
  GLEEPFNGLXQUERYHYPERPIPEBESTATTRIBSGIXPROC GLeeFuncPtr_glXQueryHyperpipeBestAttribSGIX=GLee_Lazy_glXQueryHyperpipeBestAttribSGIX;
#endif
#ifndef GLEE_C_DEFINED_glXHyperpipeAttribSGIX
#define GLEE_C_DEFINED_glXHyperpipeAttribSGIX
  int __stdcall GLee_Lazy_glXHyperpipeAttribSGIX(Display * dpy, int timeSlice, int attrib, int size, void * attribList)  {if (GLeeInit()) return glXHyperpipeAttribSGIX(dpy, timeSlice, attrib, size, attribList); return (int)0;}
  GLEEPFNGLXHYPERPIPEATTRIBSGIXPROC GLeeFuncPtr_glXHyperpipeAttribSGIX=GLee_Lazy_glXHyperpipeAttribSGIX;
#endif
#ifndef GLEE_C_DEFINED_glXQueryHyperpipeAttribSGIX
#define GLEE_C_DEFINED_glXQueryHyperpipeAttribSGIX
  int __stdcall GLee_Lazy_glXQueryHyperpipeAttribSGIX(Display * dpy, int timeSlice, int attrib, int size, void * returnAttribList)  {if (GLeeInit()) return glXQueryHyperpipeAttribSGIX(dpy, timeSlice, attrib, size, returnAttribList); return (int)0;}
  GLEEPFNGLXQUERYHYPERPIPEATTRIBSGIXPROC GLeeFuncPtr_glXQueryHyperpipeAttribSGIX=GLee_Lazy_glXQueryHyperpipeAttribSGIX;
#endif
#endif 

/* GLX_MESA_agp_offset */

#ifdef __GLEE_GLX_MESA_agp_offset
#ifndef GLEE_C_DEFINED_glXGetAGPOffsetMESA
#define GLEE_C_DEFINED_glXGetAGPOffsetMESA
  unsigned int __stdcall GLee_Lazy_glXGetAGPOffsetMESA(const void * pointer)  {if (GLeeInit()) return glXGetAGPOffsetMESA(pointer); return (unsigned int)0;}
  GLEEPFNGLXGETAGPOFFSETMESAPROC GLeeFuncPtr_glXGetAGPOffsetMESA=GLee_Lazy_glXGetAGPOffsetMESA;
#endif
#endif 

/* GLX_EXT_fbconfig_packed_float */

#ifdef __GLEE_GLX_EXT_fbconfig_packed_float
#endif 

/* GLX_EXT_framebuffer_sRGB */

#ifdef __GLEE_GLX_EXT_framebuffer_sRGB
#endif 

/* GLX_EXT_texture_from_pixmap */

#ifdef __GLEE_GLX_EXT_texture_from_pixmap
#ifndef GLEE_C_DEFINED_glXBindTexImageEXT
#define GLEE_C_DEFINED_glXBindTexImageEXT
  void __stdcall GLee_Lazy_glXBindTexImageEXT(Display * dpy, GLXDrawable drawable, int buffer, const int * attrib_list)  {if (GLeeInit()) glXBindTexImageEXT(dpy, drawable, buffer, attrib_list);}
  GLEEPFNGLXBINDTEXIMAGEEXTPROC GLeeFuncPtr_glXBindTexImageEXT=GLee_Lazy_glXBindTexImageEXT;
#endif
#ifndef GLEE_C_DEFINED_glXReleaseTexImageEXT
#define GLEE_C_DEFINED_glXReleaseTexImageEXT
  void __stdcall GLee_Lazy_glXReleaseTexImageEXT(Display * dpy, GLXDrawable drawable, int buffer)  {if (GLeeInit()) glXReleaseTexImageEXT(dpy, drawable, buffer);}
  GLEEPFNGLXRELEASETEXIMAGEEXTPROC GLeeFuncPtr_glXReleaseTexImageEXT=GLee_Lazy_glXReleaseTexImageEXT;
#endif
#endif 

/* GLX_NV_present_video */

#ifdef __GLEE_GLX_NV_present_video
#endif 

/* GLX_NV_video_out */

#ifdef __GLEE_GLX_NV_video_out
#endif 

/* GLX_NV_swap_group */

#ifdef __GLEE_GLX_NV_swap_group
#endif 

/* GLX_EXT_scene_marker */

#ifdef __GLEE_GLX_EXT_scene_marker
#endif 

/* GLX_NV_video_output */

#ifdef __GLEE_GLX_NV_video_output
#ifndef GLEE_C_DEFINED_glXGetVideoDeviceNV
#define GLEE_C_DEFINED_glXGetVideoDeviceNV
  int __stdcall GLee_Lazy_glXGetVideoDeviceNV(Display * dpy, int screen, int numVideoDevices, GLXVideoDeviceNV * pVideoDevice)  {if (GLeeInit()) return glXGetVideoDeviceNV(dpy, screen, numVideoDevices, pVideoDevice); return (int)0;}
  GLEEPFNGLXGETVIDEODEVICENVPROC GLeeFuncPtr_glXGetVideoDeviceNV=GLee_Lazy_glXGetVideoDeviceNV;
#endif
#ifndef GLEE_C_DEFINED_glXReleaseVideoDeviceNV
#define GLEE_C_DEFINED_glXReleaseVideoDeviceNV
  int __stdcall GLee_Lazy_glXReleaseVideoDeviceNV(Display * dpy, int screen, GLXVideoDeviceNV VideoDevice)  {if (GLeeInit()) return glXReleaseVideoDeviceNV(dpy, screen, VideoDevice); return (int)0;}
  GLEEPFNGLXRELEASEVIDEODEVICENVPROC GLeeFuncPtr_glXReleaseVideoDeviceNV=GLee_Lazy_glXReleaseVideoDeviceNV;
#endif
#ifndef GLEE_C_DEFINED_glXBindVideoImageNV
#define GLEE_C_DEFINED_glXBindVideoImageNV
  int __stdcall GLee_Lazy_glXBindVideoImageNV(Display * dpy, GLXVideoDeviceNV VideoDevice, GLXPbuffer pbuf, int iVideoBuffer)  {if (GLeeInit()) return glXBindVideoImageNV(dpy, VideoDevice, pbuf, iVideoBuffer); return (int)0;}
  GLEEPFNGLXBINDVIDEOIMAGENVPROC GLeeFuncPtr_glXBindVideoImageNV=GLee_Lazy_glXBindVideoImageNV;
#endif
#ifndef GLEE_C_DEFINED_glXReleaseVideoImageNV
#define GLEE_C_DEFINED_glXReleaseVideoImageNV
  int __stdcall GLee_Lazy_glXReleaseVideoImageNV(Display * dpy, GLXPbuffer pbuf)  {if (GLeeInit()) return glXReleaseVideoImageNV(dpy, pbuf); return (int)0;}
  GLEEPFNGLXRELEASEVIDEOIMAGENVPROC GLeeFuncPtr_glXReleaseVideoImageNV=GLee_Lazy_glXReleaseVideoImageNV;
#endif
#ifndef GLEE_C_DEFINED_glXSendPbufferToVideoNV
#define GLEE_C_DEFINED_glXSendPbufferToVideoNV
  int __stdcall GLee_Lazy_glXSendPbufferToVideoNV(Display * dpy, GLXPbuffer pbuf, int iBufferType, unsigned long * pulCounterPbuffer, GLboolean bBlock)  {if (GLeeInit()) return glXSendPbufferToVideoNV(dpy, pbuf, iBufferType, pulCounterPbuffer, bBlock); return (int)0;}
  GLEEPFNGLXSENDPBUFFERTOVIDEONVPROC GLeeFuncPtr_glXSendPbufferToVideoNV=GLee_Lazy_glXSendPbufferToVideoNV;
#endif
#ifndef GLEE_C_DEFINED_glXGetVideoInfoNV
#define GLEE_C_DEFINED_glXGetVideoInfoNV
  int __stdcall GLee_Lazy_glXGetVideoInfoNV(Display * dpy, int screen, GLXVideoDeviceNV VideoDevice, unsigned long * pulCounterOutputPbuffer, unsigned long * pulCounterOutputVideo)  {if (GLeeInit()) return glXGetVideoInfoNV(dpy, screen, VideoDevice, pulCounterOutputPbuffer, pulCounterOutputVideo); return (int)0;}
  GLEEPFNGLXGETVIDEOINFONVPROC GLeeFuncPtr_glXGetVideoInfoNV=GLee_Lazy_glXGetVideoInfoNV;
#endif
#endif 
#endif /* end GLX */
/*****************************************************************
* Extension link functions
*****************************************************************/

GLuint __GLeeLink_GL_VERSION_1_2(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_VERSION_1_2
    if ((GLeeFuncPtr_glBlendColor = (GLEEPFNGLBLENDCOLORPROC) __GLeeGetProcAddress("glBlendColor"))!=0) nLinked++;
    if ((GLeeFuncPtr_glBlendEquation = (GLEEPFNGLBLENDEQUATIONPROC) __GLeeGetProcAddress("glBlendEquation"))!=0) nLinked++;
    if ((GLeeFuncPtr_glDrawRangeElements = (GLEEPFNGLDRAWRANGEELEMENTSPROC) __GLeeGetProcAddress("glDrawRangeElements"))!=0) nLinked++;
    if ((GLeeFuncPtr_glColorTable = (GLEEPFNGLCOLORTABLEPROC) __GLeeGetProcAddress("glColorTable"))!=0) nLinked++;
    if ((GLeeFuncPtr_glColorTableParameterfv = (GLEEPFNGLCOLORTABLEPARAMETERFVPROC) __GLeeGetProcAddress("glColorTableParameterfv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glColorTableParameteriv = (GLEEPFNGLCOLORTABLEPARAMETERIVPROC) __GLeeGetProcAddress("glColorTableParameteriv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glCopyColorTable = (GLEEPFNGLCOPYCOLORTABLEPROC) __GLeeGetProcAddress("glCopyColorTable"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetColorTable = (GLEEPFNGLGETCOLORTABLEPROC) __GLeeGetProcAddress("glGetColorTable"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetColorTableParameterfv = (GLEEPFNGLGETCOLORTABLEPARAMETERFVPROC) __GLeeGetProcAddress("glGetColorTableParameterfv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetColorTableParameteriv = (GLEEPFNGLGETCOLORTABLEPARAMETERIVPROC) __GLeeGetProcAddress("glGetColorTableParameteriv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glColorSubTable = (GLEEPFNGLCOLORSUBTABLEPROC) __GLeeGetProcAddress("glColorSubTable"))!=0) nLinked++;
    if ((GLeeFuncPtr_glCopyColorSubTable = (GLEEPFNGLCOPYCOLORSUBTABLEPROC) __GLeeGetProcAddress("glCopyColorSubTable"))!=0) nLinked++;
    if ((GLeeFuncPtr_glConvolutionFilter1D = (GLEEPFNGLCONVOLUTIONFILTER1DPROC) __GLeeGetProcAddress("glConvolutionFilter1D"))!=0) nLinked++;
    if ((GLeeFuncPtr_glConvolutionFilter2D = (GLEEPFNGLCONVOLUTIONFILTER2DPROC) __GLeeGetProcAddress("glConvolutionFilter2D"))!=0) nLinked++;
    if ((GLeeFuncPtr_glConvolutionParameterf = (GLEEPFNGLCONVOLUTIONPARAMETERFPROC) __GLeeGetProcAddress("glConvolutionParameterf"))!=0) nLinked++;
    if ((GLeeFuncPtr_glConvolutionParameterfv = (GLEEPFNGLCONVOLUTIONPARAMETERFVPROC) __GLeeGetProcAddress("glConvolutionParameterfv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glConvolutionParameteri = (GLEEPFNGLCONVOLUTIONPARAMETERIPROC) __GLeeGetProcAddress("glConvolutionParameteri"))!=0) nLinked++;
    if ((GLeeFuncPtr_glConvolutionParameteriv = (GLEEPFNGLCONVOLUTIONPARAMETERIVPROC) __GLeeGetProcAddress("glConvolutionParameteriv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glCopyConvolutionFilter1D = (GLEEPFNGLCOPYCONVOLUTIONFILTER1DPROC) __GLeeGetProcAddress("glCopyConvolutionFilter1D"))!=0) nLinked++;
    if ((GLeeFuncPtr_glCopyConvolutionFilter2D = (GLEEPFNGLCOPYCONVOLUTIONFILTER2DPROC) __GLeeGetProcAddress("glCopyConvolutionFilter2D"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetConvolutionFilter = (GLEEPFNGLGETCONVOLUTIONFILTERPROC) __GLeeGetProcAddress("glGetConvolutionFilter"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetConvolutionParameterfv = (GLEEPFNGLGETCONVOLUTIONPARAMETERFVPROC) __GLeeGetProcAddress("glGetConvolutionParameterfv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetConvolutionParameteriv = (GLEEPFNGLGETCONVOLUTIONPARAMETERIVPROC) __GLeeGetProcAddress("glGetConvolutionParameteriv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetSeparableFilter = (GLEEPFNGLGETSEPARABLEFILTERPROC) __GLeeGetProcAddress("glGetSeparableFilter"))!=0) nLinked++;
    if ((GLeeFuncPtr_glSeparableFilter2D = (GLEEPFNGLSEPARABLEFILTER2DPROC) __GLeeGetProcAddress("glSeparableFilter2D"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetHistogram = (GLEEPFNGLGETHISTOGRAMPROC) __GLeeGetProcAddress("glGetHistogram"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetHistogramParameterfv = (GLEEPFNGLGETHISTOGRAMPARAMETERFVPROC) __GLeeGetProcAddress("glGetHistogramParameterfv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetHistogramParameteriv = (GLEEPFNGLGETHISTOGRAMPARAMETERIVPROC) __GLeeGetProcAddress("glGetHistogramParameteriv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetMinmax = (GLEEPFNGLGETMINMAXPROC) __GLeeGetProcAddress("glGetMinmax"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetMinmaxParameterfv = (GLEEPFNGLGETMINMAXPARAMETERFVPROC) __GLeeGetProcAddress("glGetMinmaxParameterfv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetMinmaxParameteriv = (GLEEPFNGLGETMINMAXPARAMETERIVPROC) __GLeeGetProcAddress("glGetMinmaxParameteriv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glHistogram = (GLEEPFNGLHISTOGRAMPROC) __GLeeGetProcAddress("glHistogram"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMinmax = (GLEEPFNGLMINMAXPROC) __GLeeGetProcAddress("glMinmax"))!=0) nLinked++;
    if ((GLeeFuncPtr_glResetHistogram = (GLEEPFNGLRESETHISTOGRAMPROC) __GLeeGetProcAddress("glResetHistogram"))!=0) nLinked++;
    if ((GLeeFuncPtr_glResetMinmax = (GLEEPFNGLRESETMINMAXPROC) __GLeeGetProcAddress("glResetMinmax"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTexImage3D = (GLEEPFNGLTEXIMAGE3DPROC) __GLeeGetProcAddress("glTexImage3D"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTexSubImage3D = (GLEEPFNGLTEXSUBIMAGE3DPROC) __GLeeGetProcAddress("glTexSubImage3D"))!=0) nLinked++;
    if ((GLeeFuncPtr_glCopyTexSubImage3D = (GLEEPFNGLCOPYTEXSUBIMAGE3DPROC) __GLeeGetProcAddress("glCopyTexSubImage3D"))!=0) nLinked++;
#endif
    if (nLinked==38) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_ARB_imaging(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_VERSION_1_3(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_VERSION_1_3
    if ((GLeeFuncPtr_glActiveTexture = (GLEEPFNGLACTIVETEXTUREPROC) __GLeeGetProcAddress("glActiveTexture"))!=0) nLinked++;
    if ((GLeeFuncPtr_glClientActiveTexture = (GLEEPFNGLCLIENTACTIVETEXTUREPROC) __GLeeGetProcAddress("glClientActiveTexture"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord1d = (GLEEPFNGLMULTITEXCOORD1DPROC) __GLeeGetProcAddress("glMultiTexCoord1d"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord1dv = (GLEEPFNGLMULTITEXCOORD1DVPROC) __GLeeGetProcAddress("glMultiTexCoord1dv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord1f = (GLEEPFNGLMULTITEXCOORD1FPROC) __GLeeGetProcAddress("glMultiTexCoord1f"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord1fv = (GLEEPFNGLMULTITEXCOORD1FVPROC) __GLeeGetProcAddress("glMultiTexCoord1fv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord1i = (GLEEPFNGLMULTITEXCOORD1IPROC) __GLeeGetProcAddress("glMultiTexCoord1i"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord1iv = (GLEEPFNGLMULTITEXCOORD1IVPROC) __GLeeGetProcAddress("glMultiTexCoord1iv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord1s = (GLEEPFNGLMULTITEXCOORD1SPROC) __GLeeGetProcAddress("glMultiTexCoord1s"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord1sv = (GLEEPFNGLMULTITEXCOORD1SVPROC) __GLeeGetProcAddress("glMultiTexCoord1sv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord2d = (GLEEPFNGLMULTITEXCOORD2DPROC) __GLeeGetProcAddress("glMultiTexCoord2d"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord2dv = (GLEEPFNGLMULTITEXCOORD2DVPROC) __GLeeGetProcAddress("glMultiTexCoord2dv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord2f = (GLEEPFNGLMULTITEXCOORD2FPROC) __GLeeGetProcAddress("glMultiTexCoord2f"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord2fv = (GLEEPFNGLMULTITEXCOORD2FVPROC) __GLeeGetProcAddress("glMultiTexCoord2fv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord2i = (GLEEPFNGLMULTITEXCOORD2IPROC) __GLeeGetProcAddress("glMultiTexCoord2i"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord2iv = (GLEEPFNGLMULTITEXCOORD2IVPROC) __GLeeGetProcAddress("glMultiTexCoord2iv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord2s = (GLEEPFNGLMULTITEXCOORD2SPROC) __GLeeGetProcAddress("glMultiTexCoord2s"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord2sv = (GLEEPFNGLMULTITEXCOORD2SVPROC) __GLeeGetProcAddress("glMultiTexCoord2sv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord3d = (GLEEPFNGLMULTITEXCOORD3DPROC) __GLeeGetProcAddress("glMultiTexCoord3d"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord3dv = (GLEEPFNGLMULTITEXCOORD3DVPROC) __GLeeGetProcAddress("glMultiTexCoord3dv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord3f = (GLEEPFNGLMULTITEXCOORD3FPROC) __GLeeGetProcAddress("glMultiTexCoord3f"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord3fv = (GLEEPFNGLMULTITEXCOORD3FVPROC) __GLeeGetProcAddress("glMultiTexCoord3fv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord3i = (GLEEPFNGLMULTITEXCOORD3IPROC) __GLeeGetProcAddress("glMultiTexCoord3i"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord3iv = (GLEEPFNGLMULTITEXCOORD3IVPROC) __GLeeGetProcAddress("glMultiTexCoord3iv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord3s = (GLEEPFNGLMULTITEXCOORD3SPROC) __GLeeGetProcAddress("glMultiTexCoord3s"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord3sv = (GLEEPFNGLMULTITEXCOORD3SVPROC) __GLeeGetProcAddress("glMultiTexCoord3sv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord4d = (GLEEPFNGLMULTITEXCOORD4DPROC) __GLeeGetProcAddress("glMultiTexCoord4d"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord4dv = (GLEEPFNGLMULTITEXCOORD4DVPROC) __GLeeGetProcAddress("glMultiTexCoord4dv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord4f = (GLEEPFNGLMULTITEXCOORD4FPROC) __GLeeGetProcAddress("glMultiTexCoord4f"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord4fv = (GLEEPFNGLMULTITEXCOORD4FVPROC) __GLeeGetProcAddress("glMultiTexCoord4fv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord4i = (GLEEPFNGLMULTITEXCOORD4IPROC) __GLeeGetProcAddress("glMultiTexCoord4i"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord4iv = (GLEEPFNGLMULTITEXCOORD4IVPROC) __GLeeGetProcAddress("glMultiTexCoord4iv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord4s = (GLEEPFNGLMULTITEXCOORD4SPROC) __GLeeGetProcAddress("glMultiTexCoord4s"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord4sv = (GLEEPFNGLMULTITEXCOORD4SVPROC) __GLeeGetProcAddress("glMultiTexCoord4sv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glLoadTransposeMatrixf = (GLEEPFNGLLOADTRANSPOSEMATRIXFPROC) __GLeeGetProcAddress("glLoadTransposeMatrixf"))!=0) nLinked++;
    if ((GLeeFuncPtr_glLoadTransposeMatrixd = (GLEEPFNGLLOADTRANSPOSEMATRIXDPROC) __GLeeGetProcAddress("glLoadTransposeMatrixd"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultTransposeMatrixf = (GLEEPFNGLMULTTRANSPOSEMATRIXFPROC) __GLeeGetProcAddress("glMultTransposeMatrixf"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultTransposeMatrixd = (GLEEPFNGLMULTTRANSPOSEMATRIXDPROC) __GLeeGetProcAddress("glMultTransposeMatrixd"))!=0) nLinked++;
    if ((GLeeFuncPtr_glSampleCoverage = (GLEEPFNGLSAMPLECOVERAGEPROC) __GLeeGetProcAddress("glSampleCoverage"))!=0) nLinked++;
    if ((GLeeFuncPtr_glCompressedTexImage3D = (GLEEPFNGLCOMPRESSEDTEXIMAGE3DPROC) __GLeeGetProcAddress("glCompressedTexImage3D"))!=0) nLinked++;
    if ((GLeeFuncPtr_glCompressedTexImage2D = (GLEEPFNGLCOMPRESSEDTEXIMAGE2DPROC) __GLeeGetProcAddress("glCompressedTexImage2D"))!=0) nLinked++;
    if ((GLeeFuncPtr_glCompressedTexImage1D = (GLEEPFNGLCOMPRESSEDTEXIMAGE1DPROC) __GLeeGetProcAddress("glCompressedTexImage1D"))!=0) nLinked++;
    if ((GLeeFuncPtr_glCompressedTexSubImage3D = (GLEEPFNGLCOMPRESSEDTEXSUBIMAGE3DPROC) __GLeeGetProcAddress("glCompressedTexSubImage3D"))!=0) nLinked++;
    if ((GLeeFuncPtr_glCompressedTexSubImage2D = (GLEEPFNGLCOMPRESSEDTEXSUBIMAGE2DPROC) __GLeeGetProcAddress("glCompressedTexSubImage2D"))!=0) nLinked++;
    if ((GLeeFuncPtr_glCompressedTexSubImage1D = (GLEEPFNGLCOMPRESSEDTEXSUBIMAGE1DPROC) __GLeeGetProcAddress("glCompressedTexSubImage1D"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetCompressedTexImage = (GLEEPFNGLGETCOMPRESSEDTEXIMAGEPROC) __GLeeGetProcAddress("glGetCompressedTexImage"))!=0) nLinked++;
#endif
    if (nLinked==46) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_VERSION_1_4(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_VERSION_1_4
    if ((GLeeFuncPtr_glBlendFuncSeparate = (GLEEPFNGLBLENDFUNCSEPARATEPROC) __GLeeGetProcAddress("glBlendFuncSeparate"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFogCoordf = (GLEEPFNGLFOGCOORDFPROC) __GLeeGetProcAddress("glFogCoordf"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFogCoordfv = (GLEEPFNGLFOGCOORDFVPROC) __GLeeGetProcAddress("glFogCoordfv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFogCoordd = (GLEEPFNGLFOGCOORDDPROC) __GLeeGetProcAddress("glFogCoordd"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFogCoorddv = (GLEEPFNGLFOGCOORDDVPROC) __GLeeGetProcAddress("glFogCoorddv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFogCoordPointer = (GLEEPFNGLFOGCOORDPOINTERPROC) __GLeeGetProcAddress("glFogCoordPointer"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiDrawArrays = (GLEEPFNGLMULTIDRAWARRAYSPROC) __GLeeGetProcAddress("glMultiDrawArrays"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiDrawElements = (GLEEPFNGLMULTIDRAWELEMENTSPROC) __GLeeGetProcAddress("glMultiDrawElements"))!=0) nLinked++;
    if ((GLeeFuncPtr_glPointParameterf = (GLEEPFNGLPOINTPARAMETERFPROC) __GLeeGetProcAddress("glPointParameterf"))!=0) nLinked++;
    if ((GLeeFuncPtr_glPointParameterfv = (GLEEPFNGLPOINTPARAMETERFVPROC) __GLeeGetProcAddress("glPointParameterfv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glPointParameteri = (GLEEPFNGLPOINTPARAMETERIPROC) __GLeeGetProcAddress("glPointParameteri"))!=0) nLinked++;
    if ((GLeeFuncPtr_glPointParameteriv = (GLEEPFNGLPOINTPARAMETERIVPROC) __GLeeGetProcAddress("glPointParameteriv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glSecondaryColor3b = (GLEEPFNGLSECONDARYCOLOR3BPROC) __GLeeGetProcAddress("glSecondaryColor3b"))!=0) nLinked++;
    if ((GLeeFuncPtr_glSecondaryColor3bv = (GLEEPFNGLSECONDARYCOLOR3BVPROC) __GLeeGetProcAddress("glSecondaryColor3bv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glSecondaryColor3d = (GLEEPFNGLSECONDARYCOLOR3DPROC) __GLeeGetProcAddress("glSecondaryColor3d"))!=0) nLinked++;
    if ((GLeeFuncPtr_glSecondaryColor3dv = (GLEEPFNGLSECONDARYCOLOR3DVPROC) __GLeeGetProcAddress("glSecondaryColor3dv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glSecondaryColor3f = (GLEEPFNGLSECONDARYCOLOR3FPROC) __GLeeGetProcAddress("glSecondaryColor3f"))!=0) nLinked++;
    if ((GLeeFuncPtr_glSecondaryColor3fv = (GLEEPFNGLSECONDARYCOLOR3FVPROC) __GLeeGetProcAddress("glSecondaryColor3fv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glSecondaryColor3i = (GLEEPFNGLSECONDARYCOLOR3IPROC) __GLeeGetProcAddress("glSecondaryColor3i"))!=0) nLinked++;
    if ((GLeeFuncPtr_glSecondaryColor3iv = (GLEEPFNGLSECONDARYCOLOR3IVPROC) __GLeeGetProcAddress("glSecondaryColor3iv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glSecondaryColor3s = (GLEEPFNGLSECONDARYCOLOR3SPROC) __GLeeGetProcAddress("glSecondaryColor3s"))!=0) nLinked++;
    if ((GLeeFuncPtr_glSecondaryColor3sv = (GLEEPFNGLSECONDARYCOLOR3SVPROC) __GLeeGetProcAddress("glSecondaryColor3sv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glSecondaryColor3ub = (GLEEPFNGLSECONDARYCOLOR3UBPROC) __GLeeGetProcAddress("glSecondaryColor3ub"))!=0) nLinked++;
    if ((GLeeFuncPtr_glSecondaryColor3ubv = (GLEEPFNGLSECONDARYCOLOR3UBVPROC) __GLeeGetProcAddress("glSecondaryColor3ubv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glSecondaryColor3ui = (GLEEPFNGLSECONDARYCOLOR3UIPROC) __GLeeGetProcAddress("glSecondaryColor3ui"))!=0) nLinked++;
    if ((GLeeFuncPtr_glSecondaryColor3uiv = (GLEEPFNGLSECONDARYCOLOR3UIVPROC) __GLeeGetProcAddress("glSecondaryColor3uiv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glSecondaryColor3us = (GLEEPFNGLSECONDARYCOLOR3USPROC) __GLeeGetProcAddress("glSecondaryColor3us"))!=0) nLinked++;
    if ((GLeeFuncPtr_glSecondaryColor3usv = (GLEEPFNGLSECONDARYCOLOR3USVPROC) __GLeeGetProcAddress("glSecondaryColor3usv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glSecondaryColorPointer = (GLEEPFNGLSECONDARYCOLORPOINTERPROC) __GLeeGetProcAddress("glSecondaryColorPointer"))!=0) nLinked++;
    if ((GLeeFuncPtr_glWindowPos2d = (GLEEPFNGLWINDOWPOS2DPROC) __GLeeGetProcAddress("glWindowPos2d"))!=0) nLinked++;
    if ((GLeeFuncPtr_glWindowPos2dv = (GLEEPFNGLWINDOWPOS2DVPROC) __GLeeGetProcAddress("glWindowPos2dv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glWindowPos2f = (GLEEPFNGLWINDOWPOS2FPROC) __GLeeGetProcAddress("glWindowPos2f"))!=0) nLinked++;
    if ((GLeeFuncPtr_glWindowPos2fv = (GLEEPFNGLWINDOWPOS2FVPROC) __GLeeGetProcAddress("glWindowPos2fv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glWindowPos2i = (GLEEPFNGLWINDOWPOS2IPROC) __GLeeGetProcAddress("glWindowPos2i"))!=0) nLinked++;
    if ((GLeeFuncPtr_glWindowPos2iv = (GLEEPFNGLWINDOWPOS2IVPROC) __GLeeGetProcAddress("glWindowPos2iv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glWindowPos2s = (GLEEPFNGLWINDOWPOS2SPROC) __GLeeGetProcAddress("glWindowPos2s"))!=0) nLinked++;
    if ((GLeeFuncPtr_glWindowPos2sv = (GLEEPFNGLWINDOWPOS2SVPROC) __GLeeGetProcAddress("glWindowPos2sv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glWindowPos3d = (GLEEPFNGLWINDOWPOS3DPROC) __GLeeGetProcAddress("glWindowPos3d"))!=0) nLinked++;
    if ((GLeeFuncPtr_glWindowPos3dv = (GLEEPFNGLWINDOWPOS3DVPROC) __GLeeGetProcAddress("glWindowPos3dv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glWindowPos3f = (GLEEPFNGLWINDOWPOS3FPROC) __GLeeGetProcAddress("glWindowPos3f"))!=0) nLinked++;
    if ((GLeeFuncPtr_glWindowPos3fv = (GLEEPFNGLWINDOWPOS3FVPROC) __GLeeGetProcAddress("glWindowPos3fv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glWindowPos3i = (GLEEPFNGLWINDOWPOS3IPROC) __GLeeGetProcAddress("glWindowPos3i"))!=0) nLinked++;
    if ((GLeeFuncPtr_glWindowPos3iv = (GLEEPFNGLWINDOWPOS3IVPROC) __GLeeGetProcAddress("glWindowPos3iv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glWindowPos3s = (GLEEPFNGLWINDOWPOS3SPROC) __GLeeGetProcAddress("glWindowPos3s"))!=0) nLinked++;
    if ((GLeeFuncPtr_glWindowPos3sv = (GLEEPFNGLWINDOWPOS3SVPROC) __GLeeGetProcAddress("glWindowPos3sv"))!=0) nLinked++;
#endif
    if (nLinked==45) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_VERSION_1_5(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_VERSION_1_5
    if ((GLeeFuncPtr_glGenQueries = (GLEEPFNGLGENQUERIESPROC) __GLeeGetProcAddress("glGenQueries"))!=0) nLinked++;
    if ((GLeeFuncPtr_glDeleteQueries = (GLEEPFNGLDELETEQUERIESPROC) __GLeeGetProcAddress("glDeleteQueries"))!=0) nLinked++;
    if ((GLeeFuncPtr_glIsQuery = (GLEEPFNGLISQUERYPROC) __GLeeGetProcAddress("glIsQuery"))!=0) nLinked++;
    if ((GLeeFuncPtr_glBeginQuery = (GLEEPFNGLBEGINQUERYPROC) __GLeeGetProcAddress("glBeginQuery"))!=0) nLinked++;
    if ((GLeeFuncPtr_glEndQuery = (GLEEPFNGLENDQUERYPROC) __GLeeGetProcAddress("glEndQuery"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetQueryiv = (GLEEPFNGLGETQUERYIVPROC) __GLeeGetProcAddress("glGetQueryiv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetQueryObjectiv = (GLEEPFNGLGETQUERYOBJECTIVPROC) __GLeeGetProcAddress("glGetQueryObjectiv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetQueryObjectuiv = (GLEEPFNGLGETQUERYOBJECTUIVPROC) __GLeeGetProcAddress("glGetQueryObjectuiv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glBindBuffer = (GLEEPFNGLBINDBUFFERPROC) __GLeeGetProcAddress("glBindBuffer"))!=0) nLinked++;
    if ((GLeeFuncPtr_glDeleteBuffers = (GLEEPFNGLDELETEBUFFERSPROC) __GLeeGetProcAddress("glDeleteBuffers"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGenBuffers = (GLEEPFNGLGENBUFFERSPROC) __GLeeGetProcAddress("glGenBuffers"))!=0) nLinked++;
    if ((GLeeFuncPtr_glIsBuffer = (GLEEPFNGLISBUFFERPROC) __GLeeGetProcAddress("glIsBuffer"))!=0) nLinked++;
    if ((GLeeFuncPtr_glBufferData = (GLEEPFNGLBUFFERDATAPROC) __GLeeGetProcAddress("glBufferData"))!=0) nLinked++;
    if ((GLeeFuncPtr_glBufferSubData = (GLEEPFNGLBUFFERSUBDATAPROC) __GLeeGetProcAddress("glBufferSubData"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetBufferSubData = (GLEEPFNGLGETBUFFERSUBDATAPROC) __GLeeGetProcAddress("glGetBufferSubData"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMapBuffer = (GLEEPFNGLMAPBUFFERPROC) __GLeeGetProcAddress("glMapBuffer"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUnmapBuffer = (GLEEPFNGLUNMAPBUFFERPROC) __GLeeGetProcAddress("glUnmapBuffer"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetBufferParameteriv = (GLEEPFNGLGETBUFFERPARAMETERIVPROC) __GLeeGetProcAddress("glGetBufferParameteriv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetBufferPointerv = (GLEEPFNGLGETBUFFERPOINTERVPROC) __GLeeGetProcAddress("glGetBufferPointerv"))!=0) nLinked++;
#endif
    if (nLinked==19) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_VERSION_2_0(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_VERSION_2_0
    if ((GLeeFuncPtr_glBlendEquationSeparate = (GLEEPFNGLBLENDEQUATIONSEPARATEPROC) __GLeeGetProcAddress("glBlendEquationSeparate"))!=0) nLinked++;
    if ((GLeeFuncPtr_glDrawBuffers = (GLEEPFNGLDRAWBUFFERSPROC) __GLeeGetProcAddress("glDrawBuffers"))!=0) nLinked++;
    if ((GLeeFuncPtr_glStencilOpSeparate = (GLEEPFNGLSTENCILOPSEPARATEPROC) __GLeeGetProcAddress("glStencilOpSeparate"))!=0) nLinked++;
    if ((GLeeFuncPtr_glStencilFuncSeparate = (GLEEPFNGLSTENCILFUNCSEPARATEPROC) __GLeeGetProcAddress("glStencilFuncSeparate"))!=0) nLinked++;
    if ((GLeeFuncPtr_glStencilMaskSeparate = (GLEEPFNGLSTENCILMASKSEPARATEPROC) __GLeeGetProcAddress("glStencilMaskSeparate"))!=0) nLinked++;
    if ((GLeeFuncPtr_glAttachShader = (GLEEPFNGLATTACHSHADERPROC) __GLeeGetProcAddress("glAttachShader"))!=0) nLinked++;
    if ((GLeeFuncPtr_glBindAttribLocation = (GLEEPFNGLBINDATTRIBLOCATIONPROC) __GLeeGetProcAddress("glBindAttribLocation"))!=0) nLinked++;
    if ((GLeeFuncPtr_glCompileShader = (GLEEPFNGLCOMPILESHADERPROC) __GLeeGetProcAddress("glCompileShader"))!=0) nLinked++;
    if ((GLeeFuncPtr_glCreateProgram = (GLEEPFNGLCREATEPROGRAMPROC) __GLeeGetProcAddress("glCreateProgram"))!=0) nLinked++;
    if ((GLeeFuncPtr_glCreateShader = (GLEEPFNGLCREATESHADERPROC) __GLeeGetProcAddress("glCreateShader"))!=0) nLinked++;
    if ((GLeeFuncPtr_glDeleteProgram = (GLEEPFNGLDELETEPROGRAMPROC) __GLeeGetProcAddress("glDeleteProgram"))!=0) nLinked++;
    if ((GLeeFuncPtr_glDeleteShader = (GLEEPFNGLDELETESHADERPROC) __GLeeGetProcAddress("glDeleteShader"))!=0) nLinked++;
    if ((GLeeFuncPtr_glDetachShader = (GLEEPFNGLDETACHSHADERPROC) __GLeeGetProcAddress("glDetachShader"))!=0) nLinked++;
    if ((GLeeFuncPtr_glDisableVertexAttribArray = (GLEEPFNGLDISABLEVERTEXATTRIBARRAYPROC) __GLeeGetProcAddress("glDisableVertexAttribArray"))!=0) nLinked++;
    if ((GLeeFuncPtr_glEnableVertexAttribArray = (GLEEPFNGLENABLEVERTEXATTRIBARRAYPROC) __GLeeGetProcAddress("glEnableVertexAttribArray"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetActiveAttrib = (GLEEPFNGLGETACTIVEATTRIBPROC) __GLeeGetProcAddress("glGetActiveAttrib"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetActiveUniform = (GLEEPFNGLGETACTIVEUNIFORMPROC) __GLeeGetProcAddress("glGetActiveUniform"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetAttachedShaders = (GLEEPFNGLGETATTACHEDSHADERSPROC) __GLeeGetProcAddress("glGetAttachedShaders"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetAttribLocation = (GLEEPFNGLGETATTRIBLOCATIONPROC) __GLeeGetProcAddress("glGetAttribLocation"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetProgramiv = (GLEEPFNGLGETPROGRAMIVPROC) __GLeeGetProcAddress("glGetProgramiv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetProgramInfoLog = (GLEEPFNGLGETPROGRAMINFOLOGPROC) __GLeeGetProcAddress("glGetProgramInfoLog"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetShaderiv = (GLEEPFNGLGETSHADERIVPROC) __GLeeGetProcAddress("glGetShaderiv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetShaderInfoLog = (GLEEPFNGLGETSHADERINFOLOGPROC) __GLeeGetProcAddress("glGetShaderInfoLog"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetShaderSource = (GLEEPFNGLGETSHADERSOURCEPROC) __GLeeGetProcAddress("glGetShaderSource"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetUniformLocation = (GLEEPFNGLGETUNIFORMLOCATIONPROC) __GLeeGetProcAddress("glGetUniformLocation"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetUniformfv = (GLEEPFNGLGETUNIFORMFVPROC) __GLeeGetProcAddress("glGetUniformfv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetUniformiv = (GLEEPFNGLGETUNIFORMIVPROC) __GLeeGetProcAddress("glGetUniformiv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetVertexAttribdv = (GLEEPFNGLGETVERTEXATTRIBDVPROC) __GLeeGetProcAddress("glGetVertexAttribdv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetVertexAttribfv = (GLEEPFNGLGETVERTEXATTRIBFVPROC) __GLeeGetProcAddress("glGetVertexAttribfv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetVertexAttribiv = (GLEEPFNGLGETVERTEXATTRIBIVPROC) __GLeeGetProcAddress("glGetVertexAttribiv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetVertexAttribPointerv = (GLEEPFNGLGETVERTEXATTRIBPOINTERVPROC) __GLeeGetProcAddress("glGetVertexAttribPointerv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glIsProgram = (GLEEPFNGLISPROGRAMPROC) __GLeeGetProcAddress("glIsProgram"))!=0) nLinked++;
    if ((GLeeFuncPtr_glIsShader = (GLEEPFNGLISSHADERPROC) __GLeeGetProcAddress("glIsShader"))!=0) nLinked++;
    if ((GLeeFuncPtr_glLinkProgram = (GLEEPFNGLLINKPROGRAMPROC) __GLeeGetProcAddress("glLinkProgram"))!=0) nLinked++;
    if ((GLeeFuncPtr_glShaderSource = (GLEEPFNGLSHADERSOURCEPROC) __GLeeGetProcAddress("glShaderSource"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUseProgram = (GLEEPFNGLUSEPROGRAMPROC) __GLeeGetProcAddress("glUseProgram"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUniform1f = (GLEEPFNGLUNIFORM1FPROC) __GLeeGetProcAddress("glUniform1f"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUniform2f = (GLEEPFNGLUNIFORM2FPROC) __GLeeGetProcAddress("glUniform2f"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUniform3f = (GLEEPFNGLUNIFORM3FPROC) __GLeeGetProcAddress("glUniform3f"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUniform4f = (GLEEPFNGLUNIFORM4FPROC) __GLeeGetProcAddress("glUniform4f"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUniform1i = (GLEEPFNGLUNIFORM1IPROC) __GLeeGetProcAddress("glUniform1i"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUniform2i = (GLEEPFNGLUNIFORM2IPROC) __GLeeGetProcAddress("glUniform2i"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUniform3i = (GLEEPFNGLUNIFORM3IPROC) __GLeeGetProcAddress("glUniform3i"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUniform4i = (GLEEPFNGLUNIFORM4IPROC) __GLeeGetProcAddress("glUniform4i"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUniform1fv = (GLEEPFNGLUNIFORM1FVPROC) __GLeeGetProcAddress("glUniform1fv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUniform2fv = (GLEEPFNGLUNIFORM2FVPROC) __GLeeGetProcAddress("glUniform2fv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUniform3fv = (GLEEPFNGLUNIFORM3FVPROC) __GLeeGetProcAddress("glUniform3fv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUniform4fv = (GLEEPFNGLUNIFORM4FVPROC) __GLeeGetProcAddress("glUniform4fv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUniform1iv = (GLEEPFNGLUNIFORM1IVPROC) __GLeeGetProcAddress("glUniform1iv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUniform2iv = (GLEEPFNGLUNIFORM2IVPROC) __GLeeGetProcAddress("glUniform2iv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUniform3iv = (GLEEPFNGLUNIFORM3IVPROC) __GLeeGetProcAddress("glUniform3iv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUniform4iv = (GLEEPFNGLUNIFORM4IVPROC) __GLeeGetProcAddress("glUniform4iv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUniformMatrix2fv = (GLEEPFNGLUNIFORMMATRIX2FVPROC) __GLeeGetProcAddress("glUniformMatrix2fv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUniformMatrix3fv = (GLEEPFNGLUNIFORMMATRIX3FVPROC) __GLeeGetProcAddress("glUniformMatrix3fv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUniformMatrix4fv = (GLEEPFNGLUNIFORMMATRIX4FVPROC) __GLeeGetProcAddress("glUniformMatrix4fv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glValidateProgram = (GLEEPFNGLVALIDATEPROGRAMPROC) __GLeeGetProcAddress("glValidateProgram"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib1d = (GLEEPFNGLVERTEXATTRIB1DPROC) __GLeeGetProcAddress("glVertexAttrib1d"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib1dv = (GLEEPFNGLVERTEXATTRIB1DVPROC) __GLeeGetProcAddress("glVertexAttrib1dv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib1f = (GLEEPFNGLVERTEXATTRIB1FPROC) __GLeeGetProcAddress("glVertexAttrib1f"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib1fv = (GLEEPFNGLVERTEXATTRIB1FVPROC) __GLeeGetProcAddress("glVertexAttrib1fv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib1s = (GLEEPFNGLVERTEXATTRIB1SPROC) __GLeeGetProcAddress("glVertexAttrib1s"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib1sv = (GLEEPFNGLVERTEXATTRIB1SVPROC) __GLeeGetProcAddress("glVertexAttrib1sv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib2d = (GLEEPFNGLVERTEXATTRIB2DPROC) __GLeeGetProcAddress("glVertexAttrib2d"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib2dv = (GLEEPFNGLVERTEXATTRIB2DVPROC) __GLeeGetProcAddress("glVertexAttrib2dv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib2f = (GLEEPFNGLVERTEXATTRIB2FPROC) __GLeeGetProcAddress("glVertexAttrib2f"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib2fv = (GLEEPFNGLVERTEXATTRIB2FVPROC) __GLeeGetProcAddress("glVertexAttrib2fv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib2s = (GLEEPFNGLVERTEXATTRIB2SPROC) __GLeeGetProcAddress("glVertexAttrib2s"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib2sv = (GLEEPFNGLVERTEXATTRIB2SVPROC) __GLeeGetProcAddress("glVertexAttrib2sv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib3d = (GLEEPFNGLVERTEXATTRIB3DPROC) __GLeeGetProcAddress("glVertexAttrib3d"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib3dv = (GLEEPFNGLVERTEXATTRIB3DVPROC) __GLeeGetProcAddress("glVertexAttrib3dv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib3f = (GLEEPFNGLVERTEXATTRIB3FPROC) __GLeeGetProcAddress("glVertexAttrib3f"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib3fv = (GLEEPFNGLVERTEXATTRIB3FVPROC) __GLeeGetProcAddress("glVertexAttrib3fv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib3s = (GLEEPFNGLVERTEXATTRIB3SPROC) __GLeeGetProcAddress("glVertexAttrib3s"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib3sv = (GLEEPFNGLVERTEXATTRIB3SVPROC) __GLeeGetProcAddress("glVertexAttrib3sv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib4Nbv = (GLEEPFNGLVERTEXATTRIB4NBVPROC) __GLeeGetProcAddress("glVertexAttrib4Nbv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib4Niv = (GLEEPFNGLVERTEXATTRIB4NIVPROC) __GLeeGetProcAddress("glVertexAttrib4Niv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib4Nsv = (GLEEPFNGLVERTEXATTRIB4NSVPROC) __GLeeGetProcAddress("glVertexAttrib4Nsv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib4Nub = (GLEEPFNGLVERTEXATTRIB4NUBPROC) __GLeeGetProcAddress("glVertexAttrib4Nub"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib4Nubv = (GLEEPFNGLVERTEXATTRIB4NUBVPROC) __GLeeGetProcAddress("glVertexAttrib4Nubv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib4Nuiv = (GLEEPFNGLVERTEXATTRIB4NUIVPROC) __GLeeGetProcAddress("glVertexAttrib4Nuiv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib4Nusv = (GLEEPFNGLVERTEXATTRIB4NUSVPROC) __GLeeGetProcAddress("glVertexAttrib4Nusv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib4bv = (GLEEPFNGLVERTEXATTRIB4BVPROC) __GLeeGetProcAddress("glVertexAttrib4bv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib4d = (GLEEPFNGLVERTEXATTRIB4DPROC) __GLeeGetProcAddress("glVertexAttrib4d"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib4dv = (GLEEPFNGLVERTEXATTRIB4DVPROC) __GLeeGetProcAddress("glVertexAttrib4dv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib4f = (GLEEPFNGLVERTEXATTRIB4FPROC) __GLeeGetProcAddress("glVertexAttrib4f"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib4fv = (GLEEPFNGLVERTEXATTRIB4FVPROC) __GLeeGetProcAddress("glVertexAttrib4fv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib4iv = (GLEEPFNGLVERTEXATTRIB4IVPROC) __GLeeGetProcAddress("glVertexAttrib4iv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib4s = (GLEEPFNGLVERTEXATTRIB4SPROC) __GLeeGetProcAddress("glVertexAttrib4s"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib4sv = (GLEEPFNGLVERTEXATTRIB4SVPROC) __GLeeGetProcAddress("glVertexAttrib4sv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib4ubv = (GLEEPFNGLVERTEXATTRIB4UBVPROC) __GLeeGetProcAddress("glVertexAttrib4ubv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib4uiv = (GLEEPFNGLVERTEXATTRIB4UIVPROC) __GLeeGetProcAddress("glVertexAttrib4uiv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib4usv = (GLEEPFNGLVERTEXATTRIB4USVPROC) __GLeeGetProcAddress("glVertexAttrib4usv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttribPointer = (GLEEPFNGLVERTEXATTRIBPOINTERPROC) __GLeeGetProcAddress("glVertexAttribPointer"))!=0) nLinked++;
#endif
    if (nLinked==93) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_VERSION_2_1(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_VERSION_2_1
    if ((GLeeFuncPtr_glUniformMatrix2x3fv = (GLEEPFNGLUNIFORMMATRIX2X3FVPROC) __GLeeGetProcAddress("glUniformMatrix2x3fv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUniformMatrix3x2fv = (GLEEPFNGLUNIFORMMATRIX3X2FVPROC) __GLeeGetProcAddress("glUniformMatrix3x2fv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUniformMatrix2x4fv = (GLEEPFNGLUNIFORMMATRIX2X4FVPROC) __GLeeGetProcAddress("glUniformMatrix2x4fv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUniformMatrix4x2fv = (GLEEPFNGLUNIFORMMATRIX4X2FVPROC) __GLeeGetProcAddress("glUniformMatrix4x2fv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUniformMatrix3x4fv = (GLEEPFNGLUNIFORMMATRIX3X4FVPROC) __GLeeGetProcAddress("glUniformMatrix3x4fv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUniformMatrix4x3fv = (GLEEPFNGLUNIFORMMATRIX4X3FVPROC) __GLeeGetProcAddress("glUniformMatrix4x3fv"))!=0) nLinked++;
#endif
    if (nLinked==6) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_VERSION_3_0(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_VERSION_3_0
    if ((GLeeFuncPtr_glColorMaski = (GLEEPFNGLCOLORMASKIPROC) __GLeeGetProcAddress("glColorMaski"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetBooleani_v = (GLEEPFNGLGETBOOLEANI_VPROC) __GLeeGetProcAddress("glGetBooleani_v"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetIntegeri_v = (GLEEPFNGLGETINTEGERI_VPROC) __GLeeGetProcAddress("glGetIntegeri_v"))!=0) nLinked++;
    if ((GLeeFuncPtr_glEnablei = (GLEEPFNGLENABLEIPROC) __GLeeGetProcAddress("glEnablei"))!=0) nLinked++;
    if ((GLeeFuncPtr_glDisablei = (GLEEPFNGLDISABLEIPROC) __GLeeGetProcAddress("glDisablei"))!=0) nLinked++;
    if ((GLeeFuncPtr_glIsEnabledi = (GLEEPFNGLISENABLEDIPROC) __GLeeGetProcAddress("glIsEnabledi"))!=0) nLinked++;
    if ((GLeeFuncPtr_glBeginTransformFeedback = (GLEEPFNGLBEGINTRANSFORMFEEDBACKPROC) __GLeeGetProcAddress("glBeginTransformFeedback"))!=0) nLinked++;
    if ((GLeeFuncPtr_glEndTransformFeedback = (GLEEPFNGLENDTRANSFORMFEEDBACKPROC) __GLeeGetProcAddress("glEndTransformFeedback"))!=0) nLinked++;
    if ((GLeeFuncPtr_glBindBufferRange = (GLEEPFNGLBINDBUFFERRANGEPROC) __GLeeGetProcAddress("glBindBufferRange"))!=0) nLinked++;
    if ((GLeeFuncPtr_glBindBufferBase = (GLEEPFNGLBINDBUFFERBASEPROC) __GLeeGetProcAddress("glBindBufferBase"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTransformFeedbackVaryings = (GLEEPFNGLTRANSFORMFEEDBACKVARYINGSPROC) __GLeeGetProcAddress("glTransformFeedbackVaryings"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetTransformFeedbackVarying = (GLEEPFNGLGETTRANSFORMFEEDBACKVARYINGPROC) __GLeeGetProcAddress("glGetTransformFeedbackVarying"))!=0) nLinked++;
    if ((GLeeFuncPtr_glClampColor = (GLEEPFNGLCLAMPCOLORPROC) __GLeeGetProcAddress("glClampColor"))!=0) nLinked++;
    if ((GLeeFuncPtr_glBeginConditionalRender = (GLEEPFNGLBEGINCONDITIONALRENDERPROC) __GLeeGetProcAddress("glBeginConditionalRender"))!=0) nLinked++;
    if ((GLeeFuncPtr_glEndConditionalRender = (GLEEPFNGLENDCONDITIONALRENDERPROC) __GLeeGetProcAddress("glEndConditionalRender"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttribI1i = (GLEEPFNGLVERTEXATTRIBI1IPROC) __GLeeGetProcAddress("glVertexAttribI1i"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttribI2i = (GLEEPFNGLVERTEXATTRIBI2IPROC) __GLeeGetProcAddress("glVertexAttribI2i"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttribI3i = (GLEEPFNGLVERTEXATTRIBI3IPROC) __GLeeGetProcAddress("glVertexAttribI3i"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttribI4i = (GLEEPFNGLVERTEXATTRIBI4IPROC) __GLeeGetProcAddress("glVertexAttribI4i"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttribI1ui = (GLEEPFNGLVERTEXATTRIBI1UIPROC) __GLeeGetProcAddress("glVertexAttribI1ui"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttribI2ui = (GLEEPFNGLVERTEXATTRIBI2UIPROC) __GLeeGetProcAddress("glVertexAttribI2ui"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttribI3ui = (GLEEPFNGLVERTEXATTRIBI3UIPROC) __GLeeGetProcAddress("glVertexAttribI3ui"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttribI4ui = (GLEEPFNGLVERTEXATTRIBI4UIPROC) __GLeeGetProcAddress("glVertexAttribI4ui"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttribI1iv = (GLEEPFNGLVERTEXATTRIBI1IVPROC) __GLeeGetProcAddress("glVertexAttribI1iv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttribI2iv = (GLEEPFNGLVERTEXATTRIBI2IVPROC) __GLeeGetProcAddress("glVertexAttribI2iv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttribI3iv = (GLEEPFNGLVERTEXATTRIBI3IVPROC) __GLeeGetProcAddress("glVertexAttribI3iv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttribI4iv = (GLEEPFNGLVERTEXATTRIBI4IVPROC) __GLeeGetProcAddress("glVertexAttribI4iv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttribI1uiv = (GLEEPFNGLVERTEXATTRIBI1UIVPROC) __GLeeGetProcAddress("glVertexAttribI1uiv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttribI2uiv = (GLEEPFNGLVERTEXATTRIBI2UIVPROC) __GLeeGetProcAddress("glVertexAttribI2uiv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttribI3uiv = (GLEEPFNGLVERTEXATTRIBI3UIVPROC) __GLeeGetProcAddress("glVertexAttribI3uiv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttribI4uiv = (GLEEPFNGLVERTEXATTRIBI4UIVPROC) __GLeeGetProcAddress("glVertexAttribI4uiv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttribI4bv = (GLEEPFNGLVERTEXATTRIBI4BVPROC) __GLeeGetProcAddress("glVertexAttribI4bv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttribI4sv = (GLEEPFNGLVERTEXATTRIBI4SVPROC) __GLeeGetProcAddress("glVertexAttribI4sv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttribI4ubv = (GLEEPFNGLVERTEXATTRIBI4UBVPROC) __GLeeGetProcAddress("glVertexAttribI4ubv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttribI4usv = (GLEEPFNGLVERTEXATTRIBI4USVPROC) __GLeeGetProcAddress("glVertexAttribI4usv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttribIPointer = (GLEEPFNGLVERTEXATTRIBIPOINTERPROC) __GLeeGetProcAddress("glVertexAttribIPointer"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetVertexAttribIiv = (GLEEPFNGLGETVERTEXATTRIBIIVPROC) __GLeeGetProcAddress("glGetVertexAttribIiv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetVertexAttribIuiv = (GLEEPFNGLGETVERTEXATTRIBIUIVPROC) __GLeeGetProcAddress("glGetVertexAttribIuiv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetUniformuiv = (GLEEPFNGLGETUNIFORMUIVPROC) __GLeeGetProcAddress("glGetUniformuiv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glBindFragDataLocation = (GLEEPFNGLBINDFRAGDATALOCATIONPROC) __GLeeGetProcAddress("glBindFragDataLocation"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetFragDataLocation = (GLEEPFNGLGETFRAGDATALOCATIONPROC) __GLeeGetProcAddress("glGetFragDataLocation"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUniform1ui = (GLEEPFNGLUNIFORM1UIPROC) __GLeeGetProcAddress("glUniform1ui"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUniform2ui = (GLEEPFNGLUNIFORM2UIPROC) __GLeeGetProcAddress("glUniform2ui"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUniform3ui = (GLEEPFNGLUNIFORM3UIPROC) __GLeeGetProcAddress("glUniform3ui"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUniform4ui = (GLEEPFNGLUNIFORM4UIPROC) __GLeeGetProcAddress("glUniform4ui"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUniform1uiv = (GLEEPFNGLUNIFORM1UIVPROC) __GLeeGetProcAddress("glUniform1uiv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUniform2uiv = (GLEEPFNGLUNIFORM2UIVPROC) __GLeeGetProcAddress("glUniform2uiv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUniform3uiv = (GLEEPFNGLUNIFORM3UIVPROC) __GLeeGetProcAddress("glUniform3uiv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUniform4uiv = (GLEEPFNGLUNIFORM4UIVPROC) __GLeeGetProcAddress("glUniform4uiv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTexParameterIiv = (GLEEPFNGLTEXPARAMETERIIVPROC) __GLeeGetProcAddress("glTexParameterIiv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTexParameterIuiv = (GLEEPFNGLTEXPARAMETERIUIVPROC) __GLeeGetProcAddress("glTexParameterIuiv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetTexParameterIiv = (GLEEPFNGLGETTEXPARAMETERIIVPROC) __GLeeGetProcAddress("glGetTexParameterIiv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetTexParameterIuiv = (GLEEPFNGLGETTEXPARAMETERIUIVPROC) __GLeeGetProcAddress("glGetTexParameterIuiv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glClearBufferiv = (GLEEPFNGLCLEARBUFFERIVPROC) __GLeeGetProcAddress("glClearBufferiv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glClearBufferuiv = (GLEEPFNGLCLEARBUFFERUIVPROC) __GLeeGetProcAddress("glClearBufferuiv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glClearBufferfv = (GLEEPFNGLCLEARBUFFERFVPROC) __GLeeGetProcAddress("glClearBufferfv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glClearBufferfi = (GLEEPFNGLCLEARBUFFERFIPROC) __GLeeGetProcAddress("glClearBufferfi"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetStringi = (GLEEPFNGLGETSTRINGIPROC) __GLeeGetProcAddress("glGetStringi"))!=0) nLinked++;
#endif
    if (nLinked==58) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_ARB_multitexture(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_ARB_multitexture
    if ((GLeeFuncPtr_glActiveTextureARB = (GLEEPFNGLACTIVETEXTUREARBPROC) __GLeeGetProcAddress("glActiveTextureARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glClientActiveTextureARB = (GLEEPFNGLCLIENTACTIVETEXTUREARBPROC) __GLeeGetProcAddress("glClientActiveTextureARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord1dARB = (GLEEPFNGLMULTITEXCOORD1DARBPROC) __GLeeGetProcAddress("glMultiTexCoord1dARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord1dvARB = (GLEEPFNGLMULTITEXCOORD1DVARBPROC) __GLeeGetProcAddress("glMultiTexCoord1dvARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord1fARB = (GLEEPFNGLMULTITEXCOORD1FARBPROC) __GLeeGetProcAddress("glMultiTexCoord1fARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord1fvARB = (GLEEPFNGLMULTITEXCOORD1FVARBPROC) __GLeeGetProcAddress("glMultiTexCoord1fvARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord1iARB = (GLEEPFNGLMULTITEXCOORD1IARBPROC) __GLeeGetProcAddress("glMultiTexCoord1iARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord1ivARB = (GLEEPFNGLMULTITEXCOORD1IVARBPROC) __GLeeGetProcAddress("glMultiTexCoord1ivARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord1sARB = (GLEEPFNGLMULTITEXCOORD1SARBPROC) __GLeeGetProcAddress("glMultiTexCoord1sARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord1svARB = (GLEEPFNGLMULTITEXCOORD1SVARBPROC) __GLeeGetProcAddress("glMultiTexCoord1svARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord2dARB = (GLEEPFNGLMULTITEXCOORD2DARBPROC) __GLeeGetProcAddress("glMultiTexCoord2dARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord2dvARB = (GLEEPFNGLMULTITEXCOORD2DVARBPROC) __GLeeGetProcAddress("glMultiTexCoord2dvARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord2fARB = (GLEEPFNGLMULTITEXCOORD2FARBPROC) __GLeeGetProcAddress("glMultiTexCoord2fARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord2fvARB = (GLEEPFNGLMULTITEXCOORD2FVARBPROC) __GLeeGetProcAddress("glMultiTexCoord2fvARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord2iARB = (GLEEPFNGLMULTITEXCOORD2IARBPROC) __GLeeGetProcAddress("glMultiTexCoord2iARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord2ivARB = (GLEEPFNGLMULTITEXCOORD2IVARBPROC) __GLeeGetProcAddress("glMultiTexCoord2ivARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord2sARB = (GLEEPFNGLMULTITEXCOORD2SARBPROC) __GLeeGetProcAddress("glMultiTexCoord2sARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord2svARB = (GLEEPFNGLMULTITEXCOORD2SVARBPROC) __GLeeGetProcAddress("glMultiTexCoord2svARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord3dARB = (GLEEPFNGLMULTITEXCOORD3DARBPROC) __GLeeGetProcAddress("glMultiTexCoord3dARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord3dvARB = (GLEEPFNGLMULTITEXCOORD3DVARBPROC) __GLeeGetProcAddress("glMultiTexCoord3dvARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord3fARB = (GLEEPFNGLMULTITEXCOORD3FARBPROC) __GLeeGetProcAddress("glMultiTexCoord3fARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord3fvARB = (GLEEPFNGLMULTITEXCOORD3FVARBPROC) __GLeeGetProcAddress("glMultiTexCoord3fvARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord3iARB = (GLEEPFNGLMULTITEXCOORD3IARBPROC) __GLeeGetProcAddress("glMultiTexCoord3iARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord3ivARB = (GLEEPFNGLMULTITEXCOORD3IVARBPROC) __GLeeGetProcAddress("glMultiTexCoord3ivARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord3sARB = (GLEEPFNGLMULTITEXCOORD3SARBPROC) __GLeeGetProcAddress("glMultiTexCoord3sARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord3svARB = (GLEEPFNGLMULTITEXCOORD3SVARBPROC) __GLeeGetProcAddress("glMultiTexCoord3svARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord4dARB = (GLEEPFNGLMULTITEXCOORD4DARBPROC) __GLeeGetProcAddress("glMultiTexCoord4dARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord4dvARB = (GLEEPFNGLMULTITEXCOORD4DVARBPROC) __GLeeGetProcAddress("glMultiTexCoord4dvARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord4fARB = (GLEEPFNGLMULTITEXCOORD4FARBPROC) __GLeeGetProcAddress("glMultiTexCoord4fARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord4fvARB = (GLEEPFNGLMULTITEXCOORD4FVARBPROC) __GLeeGetProcAddress("glMultiTexCoord4fvARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord4iARB = (GLEEPFNGLMULTITEXCOORD4IARBPROC) __GLeeGetProcAddress("glMultiTexCoord4iARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord4ivARB = (GLEEPFNGLMULTITEXCOORD4IVARBPROC) __GLeeGetProcAddress("glMultiTexCoord4ivARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord4sARB = (GLEEPFNGLMULTITEXCOORD4SARBPROC) __GLeeGetProcAddress("glMultiTexCoord4sARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord4svARB = (GLEEPFNGLMULTITEXCOORD4SVARBPROC) __GLeeGetProcAddress("glMultiTexCoord4svARB"))!=0) nLinked++;
#endif
    if (nLinked==34) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_ARB_transpose_matrix(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_ARB_transpose_matrix
    if ((GLeeFuncPtr_glLoadTransposeMatrixfARB = (GLEEPFNGLLOADTRANSPOSEMATRIXFARBPROC) __GLeeGetProcAddress("glLoadTransposeMatrixfARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glLoadTransposeMatrixdARB = (GLEEPFNGLLOADTRANSPOSEMATRIXDARBPROC) __GLeeGetProcAddress("glLoadTransposeMatrixdARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultTransposeMatrixfARB = (GLEEPFNGLMULTTRANSPOSEMATRIXFARBPROC) __GLeeGetProcAddress("glMultTransposeMatrixfARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultTransposeMatrixdARB = (GLEEPFNGLMULTTRANSPOSEMATRIXDARBPROC) __GLeeGetProcAddress("glMultTransposeMatrixdARB"))!=0) nLinked++;
#endif
    if (nLinked==4) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_ARB_multisample(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_ARB_multisample
    if ((GLeeFuncPtr_glSampleCoverageARB = (GLEEPFNGLSAMPLECOVERAGEARBPROC) __GLeeGetProcAddress("glSampleCoverageARB"))!=0) nLinked++;
#endif
    if (nLinked==1) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_ARB_texture_env_add(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_ARB_texture_cube_map(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_ARB_texture_compression(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_ARB_texture_compression
    if ((GLeeFuncPtr_glCompressedTexImage3DARB = (GLEEPFNGLCOMPRESSEDTEXIMAGE3DARBPROC) __GLeeGetProcAddress("glCompressedTexImage3DARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glCompressedTexImage2DARB = (GLEEPFNGLCOMPRESSEDTEXIMAGE2DARBPROC) __GLeeGetProcAddress("glCompressedTexImage2DARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glCompressedTexImage1DARB = (GLEEPFNGLCOMPRESSEDTEXIMAGE1DARBPROC) __GLeeGetProcAddress("glCompressedTexImage1DARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glCompressedTexSubImage3DARB = (GLEEPFNGLCOMPRESSEDTEXSUBIMAGE3DARBPROC) __GLeeGetProcAddress("glCompressedTexSubImage3DARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glCompressedTexSubImage2DARB = (GLEEPFNGLCOMPRESSEDTEXSUBIMAGE2DARBPROC) __GLeeGetProcAddress("glCompressedTexSubImage2DARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glCompressedTexSubImage1DARB = (GLEEPFNGLCOMPRESSEDTEXSUBIMAGE1DARBPROC) __GLeeGetProcAddress("glCompressedTexSubImage1DARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetCompressedTexImageARB = (GLEEPFNGLGETCOMPRESSEDTEXIMAGEARBPROC) __GLeeGetProcAddress("glGetCompressedTexImageARB"))!=0) nLinked++;
#endif
    if (nLinked==7) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_ARB_texture_border_clamp(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_ARB_point_parameters(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_ARB_point_parameters
    if ((GLeeFuncPtr_glPointParameterfARB = (GLEEPFNGLPOINTPARAMETERFARBPROC) __GLeeGetProcAddress("glPointParameterfARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glPointParameterfvARB = (GLEEPFNGLPOINTPARAMETERFVARBPROC) __GLeeGetProcAddress("glPointParameterfvARB"))!=0) nLinked++;
#endif
    if (nLinked==2) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_ARB_vertex_blend(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_ARB_vertex_blend
    if ((GLeeFuncPtr_glWeightbvARB = (GLEEPFNGLWEIGHTBVARBPROC) __GLeeGetProcAddress("glWeightbvARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glWeightsvARB = (GLEEPFNGLWEIGHTSVARBPROC) __GLeeGetProcAddress("glWeightsvARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glWeightivARB = (GLEEPFNGLWEIGHTIVARBPROC) __GLeeGetProcAddress("glWeightivARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glWeightfvARB = (GLEEPFNGLWEIGHTFVARBPROC) __GLeeGetProcAddress("glWeightfvARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glWeightdvARB = (GLEEPFNGLWEIGHTDVARBPROC) __GLeeGetProcAddress("glWeightdvARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glWeightubvARB = (GLEEPFNGLWEIGHTUBVARBPROC) __GLeeGetProcAddress("glWeightubvARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glWeightusvARB = (GLEEPFNGLWEIGHTUSVARBPROC) __GLeeGetProcAddress("glWeightusvARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glWeightuivARB = (GLEEPFNGLWEIGHTUIVARBPROC) __GLeeGetProcAddress("glWeightuivARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glWeightPointerARB = (GLEEPFNGLWEIGHTPOINTERARBPROC) __GLeeGetProcAddress("glWeightPointerARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexBlendARB = (GLEEPFNGLVERTEXBLENDARBPROC) __GLeeGetProcAddress("glVertexBlendARB"))!=0) nLinked++;
#endif
    if (nLinked==10) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_ARB_matrix_palette(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_ARB_matrix_palette
    if ((GLeeFuncPtr_glCurrentPaletteMatrixARB = (GLEEPFNGLCURRENTPALETTEMATRIXARBPROC) __GLeeGetProcAddress("glCurrentPaletteMatrixARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMatrixIndexubvARB = (GLEEPFNGLMATRIXINDEXUBVARBPROC) __GLeeGetProcAddress("glMatrixIndexubvARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMatrixIndexusvARB = (GLEEPFNGLMATRIXINDEXUSVARBPROC) __GLeeGetProcAddress("glMatrixIndexusvARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMatrixIndexuivARB = (GLEEPFNGLMATRIXINDEXUIVARBPROC) __GLeeGetProcAddress("glMatrixIndexuivARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMatrixIndexPointerARB = (GLEEPFNGLMATRIXINDEXPOINTERARBPROC) __GLeeGetProcAddress("glMatrixIndexPointerARB"))!=0) nLinked++;
#endif
    if (nLinked==5) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_ARB_texture_env_combine(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_ARB_texture_env_crossbar(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_ARB_texture_env_dot3(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_ARB_texture_mirrored_repeat(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_ARB_depth_texture(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_ARB_shadow(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_ARB_shadow_ambient(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_ARB_window_pos(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_ARB_window_pos
    if ((GLeeFuncPtr_glWindowPos2dARB = (GLEEPFNGLWINDOWPOS2DARBPROC) __GLeeGetProcAddress("glWindowPos2dARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glWindowPos2dvARB = (GLEEPFNGLWINDOWPOS2DVARBPROC) __GLeeGetProcAddress("glWindowPos2dvARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glWindowPos2fARB = (GLEEPFNGLWINDOWPOS2FARBPROC) __GLeeGetProcAddress("glWindowPos2fARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glWindowPos2fvARB = (GLEEPFNGLWINDOWPOS2FVARBPROC) __GLeeGetProcAddress("glWindowPos2fvARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glWindowPos2iARB = (GLEEPFNGLWINDOWPOS2IARBPROC) __GLeeGetProcAddress("glWindowPos2iARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glWindowPos2ivARB = (GLEEPFNGLWINDOWPOS2IVARBPROC) __GLeeGetProcAddress("glWindowPos2ivARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glWindowPos2sARB = (GLEEPFNGLWINDOWPOS2SARBPROC) __GLeeGetProcAddress("glWindowPos2sARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glWindowPos2svARB = (GLEEPFNGLWINDOWPOS2SVARBPROC) __GLeeGetProcAddress("glWindowPos2svARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glWindowPos3dARB = (GLEEPFNGLWINDOWPOS3DARBPROC) __GLeeGetProcAddress("glWindowPos3dARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glWindowPos3dvARB = (GLEEPFNGLWINDOWPOS3DVARBPROC) __GLeeGetProcAddress("glWindowPos3dvARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glWindowPos3fARB = (GLEEPFNGLWINDOWPOS3FARBPROC) __GLeeGetProcAddress("glWindowPos3fARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glWindowPos3fvARB = (GLEEPFNGLWINDOWPOS3FVARBPROC) __GLeeGetProcAddress("glWindowPos3fvARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glWindowPos3iARB = (GLEEPFNGLWINDOWPOS3IARBPROC) __GLeeGetProcAddress("glWindowPos3iARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glWindowPos3ivARB = (GLEEPFNGLWINDOWPOS3IVARBPROC) __GLeeGetProcAddress("glWindowPos3ivARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glWindowPos3sARB = (GLEEPFNGLWINDOWPOS3SARBPROC) __GLeeGetProcAddress("glWindowPos3sARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glWindowPos3svARB = (GLEEPFNGLWINDOWPOS3SVARBPROC) __GLeeGetProcAddress("glWindowPos3svARB"))!=0) nLinked++;
#endif
    if (nLinked==16) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_ARB_vertex_program(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_ARB_vertex_program
    if ((GLeeFuncPtr_glVertexAttrib1dARB = (GLEEPFNGLVERTEXATTRIB1DARBPROC) __GLeeGetProcAddress("glVertexAttrib1dARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib1dvARB = (GLEEPFNGLVERTEXATTRIB1DVARBPROC) __GLeeGetProcAddress("glVertexAttrib1dvARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib1fARB = (GLEEPFNGLVERTEXATTRIB1FARBPROC) __GLeeGetProcAddress("glVertexAttrib1fARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib1fvARB = (GLEEPFNGLVERTEXATTRIB1FVARBPROC) __GLeeGetProcAddress("glVertexAttrib1fvARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib1sARB = (GLEEPFNGLVERTEXATTRIB1SARBPROC) __GLeeGetProcAddress("glVertexAttrib1sARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib1svARB = (GLEEPFNGLVERTEXATTRIB1SVARBPROC) __GLeeGetProcAddress("glVertexAttrib1svARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib2dARB = (GLEEPFNGLVERTEXATTRIB2DARBPROC) __GLeeGetProcAddress("glVertexAttrib2dARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib2dvARB = (GLEEPFNGLVERTEXATTRIB2DVARBPROC) __GLeeGetProcAddress("glVertexAttrib2dvARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib2fARB = (GLEEPFNGLVERTEXATTRIB2FARBPROC) __GLeeGetProcAddress("glVertexAttrib2fARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib2fvARB = (GLEEPFNGLVERTEXATTRIB2FVARBPROC) __GLeeGetProcAddress("glVertexAttrib2fvARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib2sARB = (GLEEPFNGLVERTEXATTRIB2SARBPROC) __GLeeGetProcAddress("glVertexAttrib2sARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib2svARB = (GLEEPFNGLVERTEXATTRIB2SVARBPROC) __GLeeGetProcAddress("glVertexAttrib2svARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib3dARB = (GLEEPFNGLVERTEXATTRIB3DARBPROC) __GLeeGetProcAddress("glVertexAttrib3dARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib3dvARB = (GLEEPFNGLVERTEXATTRIB3DVARBPROC) __GLeeGetProcAddress("glVertexAttrib3dvARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib3fARB = (GLEEPFNGLVERTEXATTRIB3FARBPROC) __GLeeGetProcAddress("glVertexAttrib3fARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib3fvARB = (GLEEPFNGLVERTEXATTRIB3FVARBPROC) __GLeeGetProcAddress("glVertexAttrib3fvARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib3sARB = (GLEEPFNGLVERTEXATTRIB3SARBPROC) __GLeeGetProcAddress("glVertexAttrib3sARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib3svARB = (GLEEPFNGLVERTEXATTRIB3SVARBPROC) __GLeeGetProcAddress("glVertexAttrib3svARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib4NbvARB = (GLEEPFNGLVERTEXATTRIB4NBVARBPROC) __GLeeGetProcAddress("glVertexAttrib4NbvARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib4NivARB = (GLEEPFNGLVERTEXATTRIB4NIVARBPROC) __GLeeGetProcAddress("glVertexAttrib4NivARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib4NsvARB = (GLEEPFNGLVERTEXATTRIB4NSVARBPROC) __GLeeGetProcAddress("glVertexAttrib4NsvARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib4NubARB = (GLEEPFNGLVERTEXATTRIB4NUBARBPROC) __GLeeGetProcAddress("glVertexAttrib4NubARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib4NubvARB = (GLEEPFNGLVERTEXATTRIB4NUBVARBPROC) __GLeeGetProcAddress("glVertexAttrib4NubvARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib4NuivARB = (GLEEPFNGLVERTEXATTRIB4NUIVARBPROC) __GLeeGetProcAddress("glVertexAttrib4NuivARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib4NusvARB = (GLEEPFNGLVERTEXATTRIB4NUSVARBPROC) __GLeeGetProcAddress("glVertexAttrib4NusvARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib4bvARB = (GLEEPFNGLVERTEXATTRIB4BVARBPROC) __GLeeGetProcAddress("glVertexAttrib4bvARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib4dARB = (GLEEPFNGLVERTEXATTRIB4DARBPROC) __GLeeGetProcAddress("glVertexAttrib4dARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib4dvARB = (GLEEPFNGLVERTEXATTRIB4DVARBPROC) __GLeeGetProcAddress("glVertexAttrib4dvARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib4fARB = (GLEEPFNGLVERTEXATTRIB4FARBPROC) __GLeeGetProcAddress("glVertexAttrib4fARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib4fvARB = (GLEEPFNGLVERTEXATTRIB4FVARBPROC) __GLeeGetProcAddress("glVertexAttrib4fvARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib4ivARB = (GLEEPFNGLVERTEXATTRIB4IVARBPROC) __GLeeGetProcAddress("glVertexAttrib4ivARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib4sARB = (GLEEPFNGLVERTEXATTRIB4SARBPROC) __GLeeGetProcAddress("glVertexAttrib4sARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib4svARB = (GLEEPFNGLVERTEXATTRIB4SVARBPROC) __GLeeGetProcAddress("glVertexAttrib4svARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib4ubvARB = (GLEEPFNGLVERTEXATTRIB4UBVARBPROC) __GLeeGetProcAddress("glVertexAttrib4ubvARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib4uivARB = (GLEEPFNGLVERTEXATTRIB4UIVARBPROC) __GLeeGetProcAddress("glVertexAttrib4uivARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib4usvARB = (GLEEPFNGLVERTEXATTRIB4USVARBPROC) __GLeeGetProcAddress("glVertexAttrib4usvARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttribPointerARB = (GLEEPFNGLVERTEXATTRIBPOINTERARBPROC) __GLeeGetProcAddress("glVertexAttribPointerARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glEnableVertexAttribArrayARB = (GLEEPFNGLENABLEVERTEXATTRIBARRAYARBPROC) __GLeeGetProcAddress("glEnableVertexAttribArrayARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glDisableVertexAttribArrayARB = (GLEEPFNGLDISABLEVERTEXATTRIBARRAYARBPROC) __GLeeGetProcAddress("glDisableVertexAttribArrayARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramStringARB = (GLEEPFNGLPROGRAMSTRINGARBPROC) __GLeeGetProcAddress("glProgramStringARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glBindProgramARB = (GLEEPFNGLBINDPROGRAMARBPROC) __GLeeGetProcAddress("glBindProgramARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glDeleteProgramsARB = (GLEEPFNGLDELETEPROGRAMSARBPROC) __GLeeGetProcAddress("glDeleteProgramsARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGenProgramsARB = (GLEEPFNGLGENPROGRAMSARBPROC) __GLeeGetProcAddress("glGenProgramsARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramEnvParameter4dARB = (GLEEPFNGLPROGRAMENVPARAMETER4DARBPROC) __GLeeGetProcAddress("glProgramEnvParameter4dARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramEnvParameter4dvARB = (GLEEPFNGLPROGRAMENVPARAMETER4DVARBPROC) __GLeeGetProcAddress("glProgramEnvParameter4dvARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramEnvParameter4fARB = (GLEEPFNGLPROGRAMENVPARAMETER4FARBPROC) __GLeeGetProcAddress("glProgramEnvParameter4fARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramEnvParameter4fvARB = (GLEEPFNGLPROGRAMENVPARAMETER4FVARBPROC) __GLeeGetProcAddress("glProgramEnvParameter4fvARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramLocalParameter4dARB = (GLEEPFNGLPROGRAMLOCALPARAMETER4DARBPROC) __GLeeGetProcAddress("glProgramLocalParameter4dARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramLocalParameter4dvARB = (GLEEPFNGLPROGRAMLOCALPARAMETER4DVARBPROC) __GLeeGetProcAddress("glProgramLocalParameter4dvARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramLocalParameter4fARB = (GLEEPFNGLPROGRAMLOCALPARAMETER4FARBPROC) __GLeeGetProcAddress("glProgramLocalParameter4fARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramLocalParameter4fvARB = (GLEEPFNGLPROGRAMLOCALPARAMETER4FVARBPROC) __GLeeGetProcAddress("glProgramLocalParameter4fvARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetProgramEnvParameterdvARB = (GLEEPFNGLGETPROGRAMENVPARAMETERDVARBPROC) __GLeeGetProcAddress("glGetProgramEnvParameterdvARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetProgramEnvParameterfvARB = (GLEEPFNGLGETPROGRAMENVPARAMETERFVARBPROC) __GLeeGetProcAddress("glGetProgramEnvParameterfvARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetProgramLocalParameterdvARB = (GLEEPFNGLGETPROGRAMLOCALPARAMETERDVARBPROC) __GLeeGetProcAddress("glGetProgramLocalParameterdvARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetProgramLocalParameterfvARB = (GLEEPFNGLGETPROGRAMLOCALPARAMETERFVARBPROC) __GLeeGetProcAddress("glGetProgramLocalParameterfvARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetProgramivARB = (GLEEPFNGLGETPROGRAMIVARBPROC) __GLeeGetProcAddress("glGetProgramivARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetProgramStringARB = (GLEEPFNGLGETPROGRAMSTRINGARBPROC) __GLeeGetProcAddress("glGetProgramStringARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetVertexAttribdvARB = (GLEEPFNGLGETVERTEXATTRIBDVARBPROC) __GLeeGetProcAddress("glGetVertexAttribdvARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetVertexAttribfvARB = (GLEEPFNGLGETVERTEXATTRIBFVARBPROC) __GLeeGetProcAddress("glGetVertexAttribfvARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetVertexAttribivARB = (GLEEPFNGLGETVERTEXATTRIBIVARBPROC) __GLeeGetProcAddress("glGetVertexAttribivARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetVertexAttribPointervARB = (GLEEPFNGLGETVERTEXATTRIBPOINTERVARBPROC) __GLeeGetProcAddress("glGetVertexAttribPointervARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glIsProgramARB = (GLEEPFNGLISPROGRAMARBPROC) __GLeeGetProcAddress("glIsProgramARB"))!=0) nLinked++;
#endif
    if (nLinked==62) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_ARB_fragment_program(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_ARB_vertex_buffer_object(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_ARB_vertex_buffer_object
    if ((GLeeFuncPtr_glBindBufferARB = (GLEEPFNGLBINDBUFFERARBPROC) __GLeeGetProcAddress("glBindBufferARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glDeleteBuffersARB = (GLEEPFNGLDELETEBUFFERSARBPROC) __GLeeGetProcAddress("glDeleteBuffersARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGenBuffersARB = (GLEEPFNGLGENBUFFERSARBPROC) __GLeeGetProcAddress("glGenBuffersARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glIsBufferARB = (GLEEPFNGLISBUFFERARBPROC) __GLeeGetProcAddress("glIsBufferARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glBufferDataARB = (GLEEPFNGLBUFFERDATAARBPROC) __GLeeGetProcAddress("glBufferDataARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glBufferSubDataARB = (GLEEPFNGLBUFFERSUBDATAARBPROC) __GLeeGetProcAddress("glBufferSubDataARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetBufferSubDataARB = (GLEEPFNGLGETBUFFERSUBDATAARBPROC) __GLeeGetProcAddress("glGetBufferSubDataARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMapBufferARB = (GLEEPFNGLMAPBUFFERARBPROC) __GLeeGetProcAddress("glMapBufferARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUnmapBufferARB = (GLEEPFNGLUNMAPBUFFERARBPROC) __GLeeGetProcAddress("glUnmapBufferARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetBufferParameterivARB = (GLEEPFNGLGETBUFFERPARAMETERIVARBPROC) __GLeeGetProcAddress("glGetBufferParameterivARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetBufferPointervARB = (GLEEPFNGLGETBUFFERPOINTERVARBPROC) __GLeeGetProcAddress("glGetBufferPointervARB"))!=0) nLinked++;
#endif
    if (nLinked==11) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_ARB_occlusion_query(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_ARB_occlusion_query
    if ((GLeeFuncPtr_glGenQueriesARB = (GLEEPFNGLGENQUERIESARBPROC) __GLeeGetProcAddress("glGenQueriesARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glDeleteQueriesARB = (GLEEPFNGLDELETEQUERIESARBPROC) __GLeeGetProcAddress("glDeleteQueriesARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glIsQueryARB = (GLEEPFNGLISQUERYARBPROC) __GLeeGetProcAddress("glIsQueryARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glBeginQueryARB = (GLEEPFNGLBEGINQUERYARBPROC) __GLeeGetProcAddress("glBeginQueryARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glEndQueryARB = (GLEEPFNGLENDQUERYARBPROC) __GLeeGetProcAddress("glEndQueryARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetQueryivARB = (GLEEPFNGLGETQUERYIVARBPROC) __GLeeGetProcAddress("glGetQueryivARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetQueryObjectivARB = (GLEEPFNGLGETQUERYOBJECTIVARBPROC) __GLeeGetProcAddress("glGetQueryObjectivARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetQueryObjectuivARB = (GLEEPFNGLGETQUERYOBJECTUIVARBPROC) __GLeeGetProcAddress("glGetQueryObjectuivARB"))!=0) nLinked++;
#endif
    if (nLinked==8) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_ARB_shader_objects(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_ARB_shader_objects
    if ((GLeeFuncPtr_glDeleteObjectARB = (GLEEPFNGLDELETEOBJECTARBPROC) __GLeeGetProcAddress("glDeleteObjectARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetHandleARB = (GLEEPFNGLGETHANDLEARBPROC) __GLeeGetProcAddress("glGetHandleARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glDetachObjectARB = (GLEEPFNGLDETACHOBJECTARBPROC) __GLeeGetProcAddress("glDetachObjectARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glCreateShaderObjectARB = (GLEEPFNGLCREATESHADEROBJECTARBPROC) __GLeeGetProcAddress("glCreateShaderObjectARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glShaderSourceARB = (GLEEPFNGLSHADERSOURCEARBPROC) __GLeeGetProcAddress("glShaderSourceARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glCompileShaderARB = (GLEEPFNGLCOMPILESHADERARBPROC) __GLeeGetProcAddress("glCompileShaderARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glCreateProgramObjectARB = (GLEEPFNGLCREATEPROGRAMOBJECTARBPROC) __GLeeGetProcAddress("glCreateProgramObjectARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glAttachObjectARB = (GLEEPFNGLATTACHOBJECTARBPROC) __GLeeGetProcAddress("glAttachObjectARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glLinkProgramARB = (GLEEPFNGLLINKPROGRAMARBPROC) __GLeeGetProcAddress("glLinkProgramARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUseProgramObjectARB = (GLEEPFNGLUSEPROGRAMOBJECTARBPROC) __GLeeGetProcAddress("glUseProgramObjectARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glValidateProgramARB = (GLEEPFNGLVALIDATEPROGRAMARBPROC) __GLeeGetProcAddress("glValidateProgramARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUniform1fARB = (GLEEPFNGLUNIFORM1FARBPROC) __GLeeGetProcAddress("glUniform1fARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUniform2fARB = (GLEEPFNGLUNIFORM2FARBPROC) __GLeeGetProcAddress("glUniform2fARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUniform3fARB = (GLEEPFNGLUNIFORM3FARBPROC) __GLeeGetProcAddress("glUniform3fARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUniform4fARB = (GLEEPFNGLUNIFORM4FARBPROC) __GLeeGetProcAddress("glUniform4fARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUniform1iARB = (GLEEPFNGLUNIFORM1IARBPROC) __GLeeGetProcAddress("glUniform1iARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUniform2iARB = (GLEEPFNGLUNIFORM2IARBPROC) __GLeeGetProcAddress("glUniform2iARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUniform3iARB = (GLEEPFNGLUNIFORM3IARBPROC) __GLeeGetProcAddress("glUniform3iARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUniform4iARB = (GLEEPFNGLUNIFORM4IARBPROC) __GLeeGetProcAddress("glUniform4iARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUniform1fvARB = (GLEEPFNGLUNIFORM1FVARBPROC) __GLeeGetProcAddress("glUniform1fvARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUniform2fvARB = (GLEEPFNGLUNIFORM2FVARBPROC) __GLeeGetProcAddress("glUniform2fvARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUniform3fvARB = (GLEEPFNGLUNIFORM3FVARBPROC) __GLeeGetProcAddress("glUniform3fvARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUniform4fvARB = (GLEEPFNGLUNIFORM4FVARBPROC) __GLeeGetProcAddress("glUniform4fvARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUniform1ivARB = (GLEEPFNGLUNIFORM1IVARBPROC) __GLeeGetProcAddress("glUniform1ivARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUniform2ivARB = (GLEEPFNGLUNIFORM2IVARBPROC) __GLeeGetProcAddress("glUniform2ivARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUniform3ivARB = (GLEEPFNGLUNIFORM3IVARBPROC) __GLeeGetProcAddress("glUniform3ivARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUniform4ivARB = (GLEEPFNGLUNIFORM4IVARBPROC) __GLeeGetProcAddress("glUniform4ivARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUniformMatrix2fvARB = (GLEEPFNGLUNIFORMMATRIX2FVARBPROC) __GLeeGetProcAddress("glUniformMatrix2fvARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUniformMatrix3fvARB = (GLEEPFNGLUNIFORMMATRIX3FVARBPROC) __GLeeGetProcAddress("glUniformMatrix3fvARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUniformMatrix4fvARB = (GLEEPFNGLUNIFORMMATRIX4FVARBPROC) __GLeeGetProcAddress("glUniformMatrix4fvARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetObjectParameterfvARB = (GLEEPFNGLGETOBJECTPARAMETERFVARBPROC) __GLeeGetProcAddress("glGetObjectParameterfvARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetObjectParameterivARB = (GLEEPFNGLGETOBJECTPARAMETERIVARBPROC) __GLeeGetProcAddress("glGetObjectParameterivARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetInfoLogARB = (GLEEPFNGLGETINFOLOGARBPROC) __GLeeGetProcAddress("glGetInfoLogARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetAttachedObjectsARB = (GLEEPFNGLGETATTACHEDOBJECTSARBPROC) __GLeeGetProcAddress("glGetAttachedObjectsARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetUniformLocationARB = (GLEEPFNGLGETUNIFORMLOCATIONARBPROC) __GLeeGetProcAddress("glGetUniformLocationARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetActiveUniformARB = (GLEEPFNGLGETACTIVEUNIFORMARBPROC) __GLeeGetProcAddress("glGetActiveUniformARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetUniformfvARB = (GLEEPFNGLGETUNIFORMFVARBPROC) __GLeeGetProcAddress("glGetUniformfvARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetUniformivARB = (GLEEPFNGLGETUNIFORMIVARBPROC) __GLeeGetProcAddress("glGetUniformivARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetShaderSourceARB = (GLEEPFNGLGETSHADERSOURCEARBPROC) __GLeeGetProcAddress("glGetShaderSourceARB"))!=0) nLinked++;
#endif
    if (nLinked==39) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_ARB_vertex_shader(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_ARB_vertex_shader
    if ((GLeeFuncPtr_glBindAttribLocationARB = (GLEEPFNGLBINDATTRIBLOCATIONARBPROC) __GLeeGetProcAddress("glBindAttribLocationARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetActiveAttribARB = (GLEEPFNGLGETACTIVEATTRIBARBPROC) __GLeeGetProcAddress("glGetActiveAttribARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetAttribLocationARB = (GLEEPFNGLGETATTRIBLOCATIONARBPROC) __GLeeGetProcAddress("glGetAttribLocationARB"))!=0) nLinked++;
#endif
    if (nLinked==3) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_ARB_fragment_shader(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_ARB_shading_language_100(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_ARB_texture_non_power_of_two(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_ARB_point_sprite(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_ARB_fragment_program_shadow(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_ARB_draw_buffers(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_ARB_draw_buffers
    if ((GLeeFuncPtr_glDrawBuffersARB = (GLEEPFNGLDRAWBUFFERSARBPROC) __GLeeGetProcAddress("glDrawBuffersARB"))!=0) nLinked++;
#endif
    if (nLinked==1) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_ARB_texture_rectangle(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_ARB_color_buffer_float(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_ARB_color_buffer_float
    if ((GLeeFuncPtr_glClampColorARB = (GLEEPFNGLCLAMPCOLORARBPROC) __GLeeGetProcAddress("glClampColorARB"))!=0) nLinked++;
#endif
    if (nLinked==1) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_ARB_half_float_pixel(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_ARB_texture_float(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_ARB_pixel_buffer_object(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_ARB_depth_buffer_float(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_ARB_draw_instanced(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_ARB_draw_instanced
    if ((GLeeFuncPtr_glDrawArraysInstancedARB = (GLEEPFNGLDRAWARRAYSINSTANCEDARBPROC) __GLeeGetProcAddress("glDrawArraysInstancedARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glDrawElementsInstancedARB = (GLEEPFNGLDRAWELEMENTSINSTANCEDARBPROC) __GLeeGetProcAddress("glDrawElementsInstancedARB"))!=0) nLinked++;
#endif
    if (nLinked==2) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_ARB_framebuffer_object(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_ARB_framebuffer_object
    if ((GLeeFuncPtr_glIsRenderbuffer = (GLEEPFNGLISRENDERBUFFERPROC) __GLeeGetProcAddress("glIsRenderbuffer"))!=0) nLinked++;
    if ((GLeeFuncPtr_glBindRenderbuffer = (GLEEPFNGLBINDRENDERBUFFERPROC) __GLeeGetProcAddress("glBindRenderbuffer"))!=0) nLinked++;
    if ((GLeeFuncPtr_glDeleteRenderbuffers = (GLEEPFNGLDELETERENDERBUFFERSPROC) __GLeeGetProcAddress("glDeleteRenderbuffers"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGenRenderbuffers = (GLEEPFNGLGENRENDERBUFFERSPROC) __GLeeGetProcAddress("glGenRenderbuffers"))!=0) nLinked++;
    if ((GLeeFuncPtr_glRenderbufferStorage = (GLEEPFNGLRENDERBUFFERSTORAGEPROC) __GLeeGetProcAddress("glRenderbufferStorage"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetRenderbufferParameteriv = (GLEEPFNGLGETRENDERBUFFERPARAMETERIVPROC) __GLeeGetProcAddress("glGetRenderbufferParameteriv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glIsFramebuffer = (GLEEPFNGLISFRAMEBUFFERPROC) __GLeeGetProcAddress("glIsFramebuffer"))!=0) nLinked++;
    if ((GLeeFuncPtr_glBindFramebuffer = (GLEEPFNGLBINDFRAMEBUFFERPROC) __GLeeGetProcAddress("glBindFramebuffer"))!=0) nLinked++;
    if ((GLeeFuncPtr_glDeleteFramebuffers = (GLEEPFNGLDELETEFRAMEBUFFERSPROC) __GLeeGetProcAddress("glDeleteFramebuffers"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGenFramebuffers = (GLEEPFNGLGENFRAMEBUFFERSPROC) __GLeeGetProcAddress("glGenFramebuffers"))!=0) nLinked++;
    if ((GLeeFuncPtr_glCheckFramebufferStatus = (GLEEPFNGLCHECKFRAMEBUFFERSTATUSPROC) __GLeeGetProcAddress("glCheckFramebufferStatus"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFramebufferTexture1D = (GLEEPFNGLFRAMEBUFFERTEXTURE1DPROC) __GLeeGetProcAddress("glFramebufferTexture1D"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFramebufferTexture2D = (GLEEPFNGLFRAMEBUFFERTEXTURE2DPROC) __GLeeGetProcAddress("glFramebufferTexture2D"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFramebufferTexture3D = (GLEEPFNGLFRAMEBUFFERTEXTURE3DPROC) __GLeeGetProcAddress("glFramebufferTexture3D"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFramebufferRenderbuffer = (GLEEPFNGLFRAMEBUFFERRENDERBUFFERPROC) __GLeeGetProcAddress("glFramebufferRenderbuffer"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetFramebufferAttachmentParameteriv = (GLEEPFNGLGETFRAMEBUFFERATTACHMENTPARAMETERIVPROC) __GLeeGetProcAddress("glGetFramebufferAttachmentParameteriv"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGenerateMipmap = (GLEEPFNGLGENERATEMIPMAPPROC) __GLeeGetProcAddress("glGenerateMipmap"))!=0) nLinked++;
    if ((GLeeFuncPtr_glBlitFramebuffer = (GLEEPFNGLBLITFRAMEBUFFERPROC) __GLeeGetProcAddress("glBlitFramebuffer"))!=0) nLinked++;
    if ((GLeeFuncPtr_glRenderbufferStorageMultisample = (GLEEPFNGLRENDERBUFFERSTORAGEMULTISAMPLEPROC) __GLeeGetProcAddress("glRenderbufferStorageMultisample"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFramebufferTextureLayer = (GLEEPFNGLFRAMEBUFFERTEXTURELAYERPROC) __GLeeGetProcAddress("glFramebufferTextureLayer"))!=0) nLinked++;
#endif
    if (nLinked==20) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_ARB_framebuffer_sRGB(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_ARB_geometry_shader4(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_ARB_geometry_shader4
    if ((GLeeFuncPtr_glProgramParameteriARB = (GLEEPFNGLPROGRAMPARAMETERIARBPROC) __GLeeGetProcAddress("glProgramParameteriARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFramebufferTextureARB = (GLEEPFNGLFRAMEBUFFERTEXTUREARBPROC) __GLeeGetProcAddress("glFramebufferTextureARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFramebufferTextureLayerARB = (GLEEPFNGLFRAMEBUFFERTEXTURELAYERARBPROC) __GLeeGetProcAddress("glFramebufferTextureLayerARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFramebufferTextureFaceARB = (GLEEPFNGLFRAMEBUFFERTEXTUREFACEARBPROC) __GLeeGetProcAddress("glFramebufferTextureFaceARB"))!=0) nLinked++;
#endif
    if (nLinked==4) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_ARB_half_float_vertex(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_ARB_instanced_arrays(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_ARB_instanced_arrays
    if ((GLeeFuncPtr_glVertexAttribDivisor = (GLEEPFNGLVERTEXATTRIBDIVISORPROC) __GLeeGetProcAddress("glVertexAttribDivisor"))!=0) nLinked++;
#endif
    if (nLinked==1) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_ARB_map_buffer_range(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_ARB_map_buffer_range
    if ((GLeeFuncPtr_glMapBufferRange = (GLEEPFNGLMAPBUFFERRANGEPROC) __GLeeGetProcAddress("glMapBufferRange"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFlushMappedBufferRange = (GLEEPFNGLFLUSHMAPPEDBUFFERRANGEPROC) __GLeeGetProcAddress("glFlushMappedBufferRange"))!=0) nLinked++;
#endif
    if (nLinked==2) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_ARB_texture_buffer_object(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_ARB_texture_buffer_object
    if ((GLeeFuncPtr_glTexBufferARB = (GLEEPFNGLTEXBUFFERARBPROC) __GLeeGetProcAddress("glTexBufferARB"))!=0) nLinked++;
#endif
    if (nLinked==1) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_ARB_texture_compression_rgtc(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_ARB_texture_rg(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_ARB_vertex_array_object(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_ARB_vertex_array_object
    if ((GLeeFuncPtr_glBindVertexArray = (GLEEPFNGLBINDVERTEXARRAYPROC) __GLeeGetProcAddress("glBindVertexArray"))!=0) nLinked++;
    if ((GLeeFuncPtr_glDeleteVertexArrays = (GLEEPFNGLDELETEVERTEXARRAYSPROC) __GLeeGetProcAddress("glDeleteVertexArrays"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGenVertexArrays = (GLEEPFNGLGENVERTEXARRAYSPROC) __GLeeGetProcAddress("glGenVertexArrays"))!=0) nLinked++;
    if ((GLeeFuncPtr_glIsVertexArray = (GLEEPFNGLISVERTEXARRAYPROC) __GLeeGetProcAddress("glIsVertexArray"))!=0) nLinked++;
#endif
    if (nLinked==4) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_EXT_abgr(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_EXT_blend_color(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_EXT_blend_color
    if ((GLeeFuncPtr_glBlendColorEXT = (GLEEPFNGLBLENDCOLOREXTPROC) __GLeeGetProcAddress("glBlendColorEXT"))!=0) nLinked++;
#endif
    if (nLinked==1) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_EXT_polygon_offset(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_EXT_polygon_offset
    if ((GLeeFuncPtr_glPolygonOffsetEXT = (GLEEPFNGLPOLYGONOFFSETEXTPROC) __GLeeGetProcAddress("glPolygonOffsetEXT"))!=0) nLinked++;
#endif
    if (nLinked==1) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_EXT_texture(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_EXT_texture3D(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_EXT_texture3D
    if ((GLeeFuncPtr_glTexImage3DEXT = (GLEEPFNGLTEXIMAGE3DEXTPROC) __GLeeGetProcAddress("glTexImage3DEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTexSubImage3DEXT = (GLEEPFNGLTEXSUBIMAGE3DEXTPROC) __GLeeGetProcAddress("glTexSubImage3DEXT"))!=0) nLinked++;
#endif
    if (nLinked==2) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_SGIS_texture_filter4(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_SGIS_texture_filter4
    if ((GLeeFuncPtr_glGetTexFilterFuncSGIS = (GLEEPFNGLGETTEXFILTERFUNCSGISPROC) __GLeeGetProcAddress("glGetTexFilterFuncSGIS"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTexFilterFuncSGIS = (GLEEPFNGLTEXFILTERFUNCSGISPROC) __GLeeGetProcAddress("glTexFilterFuncSGIS"))!=0) nLinked++;
#endif
    if (nLinked==2) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_EXT_subtexture(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_EXT_subtexture
    if ((GLeeFuncPtr_glTexSubImage1DEXT = (GLEEPFNGLTEXSUBIMAGE1DEXTPROC) __GLeeGetProcAddress("glTexSubImage1DEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTexSubImage2DEXT = (GLEEPFNGLTEXSUBIMAGE2DEXTPROC) __GLeeGetProcAddress("glTexSubImage2DEXT"))!=0) nLinked++;
#endif
    if (nLinked==2) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_EXT_copy_texture(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_EXT_copy_texture
    if ((GLeeFuncPtr_glCopyTexImage1DEXT = (GLEEPFNGLCOPYTEXIMAGE1DEXTPROC) __GLeeGetProcAddress("glCopyTexImage1DEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glCopyTexImage2DEXT = (GLEEPFNGLCOPYTEXIMAGE2DEXTPROC) __GLeeGetProcAddress("glCopyTexImage2DEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glCopyTexSubImage1DEXT = (GLEEPFNGLCOPYTEXSUBIMAGE1DEXTPROC) __GLeeGetProcAddress("glCopyTexSubImage1DEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glCopyTexSubImage2DEXT = (GLEEPFNGLCOPYTEXSUBIMAGE2DEXTPROC) __GLeeGetProcAddress("glCopyTexSubImage2DEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glCopyTexSubImage3DEXT = (GLEEPFNGLCOPYTEXSUBIMAGE3DEXTPROC) __GLeeGetProcAddress("glCopyTexSubImage3DEXT"))!=0) nLinked++;
#endif
    if (nLinked==5) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_EXT_histogram(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_EXT_histogram
    if ((GLeeFuncPtr_glGetHistogramEXT = (GLEEPFNGLGETHISTOGRAMEXTPROC) __GLeeGetProcAddress("glGetHistogramEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetHistogramParameterfvEXT = (GLEEPFNGLGETHISTOGRAMPARAMETERFVEXTPROC) __GLeeGetProcAddress("glGetHistogramParameterfvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetHistogramParameterivEXT = (GLEEPFNGLGETHISTOGRAMPARAMETERIVEXTPROC) __GLeeGetProcAddress("glGetHistogramParameterivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetMinmaxEXT = (GLEEPFNGLGETMINMAXEXTPROC) __GLeeGetProcAddress("glGetMinmaxEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetMinmaxParameterfvEXT = (GLEEPFNGLGETMINMAXPARAMETERFVEXTPROC) __GLeeGetProcAddress("glGetMinmaxParameterfvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetMinmaxParameterivEXT = (GLEEPFNGLGETMINMAXPARAMETERIVEXTPROC) __GLeeGetProcAddress("glGetMinmaxParameterivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glHistogramEXT = (GLEEPFNGLHISTOGRAMEXTPROC) __GLeeGetProcAddress("glHistogramEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMinmaxEXT = (GLEEPFNGLMINMAXEXTPROC) __GLeeGetProcAddress("glMinmaxEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glResetHistogramEXT = (GLEEPFNGLRESETHISTOGRAMEXTPROC) __GLeeGetProcAddress("glResetHistogramEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glResetMinmaxEXT = (GLEEPFNGLRESETMINMAXEXTPROC) __GLeeGetProcAddress("glResetMinmaxEXT"))!=0) nLinked++;
#endif
    if (nLinked==10) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_EXT_convolution(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_EXT_convolution
    if ((GLeeFuncPtr_glConvolutionFilter1DEXT = (GLEEPFNGLCONVOLUTIONFILTER1DEXTPROC) __GLeeGetProcAddress("glConvolutionFilter1DEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glConvolutionFilter2DEXT = (GLEEPFNGLCONVOLUTIONFILTER2DEXTPROC) __GLeeGetProcAddress("glConvolutionFilter2DEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glConvolutionParameterfEXT = (GLEEPFNGLCONVOLUTIONPARAMETERFEXTPROC) __GLeeGetProcAddress("glConvolutionParameterfEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glConvolutionParameterfvEXT = (GLEEPFNGLCONVOLUTIONPARAMETERFVEXTPROC) __GLeeGetProcAddress("glConvolutionParameterfvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glConvolutionParameteriEXT = (GLEEPFNGLCONVOLUTIONPARAMETERIEXTPROC) __GLeeGetProcAddress("glConvolutionParameteriEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glConvolutionParameterivEXT = (GLEEPFNGLCONVOLUTIONPARAMETERIVEXTPROC) __GLeeGetProcAddress("glConvolutionParameterivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glCopyConvolutionFilter1DEXT = (GLEEPFNGLCOPYCONVOLUTIONFILTER1DEXTPROC) __GLeeGetProcAddress("glCopyConvolutionFilter1DEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glCopyConvolutionFilter2DEXT = (GLEEPFNGLCOPYCONVOLUTIONFILTER2DEXTPROC) __GLeeGetProcAddress("glCopyConvolutionFilter2DEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetConvolutionFilterEXT = (GLEEPFNGLGETCONVOLUTIONFILTEREXTPROC) __GLeeGetProcAddress("glGetConvolutionFilterEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetConvolutionParameterfvEXT = (GLEEPFNGLGETCONVOLUTIONPARAMETERFVEXTPROC) __GLeeGetProcAddress("glGetConvolutionParameterfvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetConvolutionParameterivEXT = (GLEEPFNGLGETCONVOLUTIONPARAMETERIVEXTPROC) __GLeeGetProcAddress("glGetConvolutionParameterivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetSeparableFilterEXT = (GLEEPFNGLGETSEPARABLEFILTEREXTPROC) __GLeeGetProcAddress("glGetSeparableFilterEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glSeparableFilter2DEXT = (GLEEPFNGLSEPARABLEFILTER2DEXTPROC) __GLeeGetProcAddress("glSeparableFilter2DEXT"))!=0) nLinked++;
#endif
    if (nLinked==13) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_SGI_color_matrix(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_SGI_color_table(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_SGI_color_table
    if ((GLeeFuncPtr_glColorTableSGI = (GLEEPFNGLCOLORTABLESGIPROC) __GLeeGetProcAddress("glColorTableSGI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glColorTableParameterfvSGI = (GLEEPFNGLCOLORTABLEPARAMETERFVSGIPROC) __GLeeGetProcAddress("glColorTableParameterfvSGI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glColorTableParameterivSGI = (GLEEPFNGLCOLORTABLEPARAMETERIVSGIPROC) __GLeeGetProcAddress("glColorTableParameterivSGI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glCopyColorTableSGI = (GLEEPFNGLCOPYCOLORTABLESGIPROC) __GLeeGetProcAddress("glCopyColorTableSGI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetColorTableSGI = (GLEEPFNGLGETCOLORTABLESGIPROC) __GLeeGetProcAddress("glGetColorTableSGI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetColorTableParameterfvSGI = (GLEEPFNGLGETCOLORTABLEPARAMETERFVSGIPROC) __GLeeGetProcAddress("glGetColorTableParameterfvSGI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetColorTableParameterivSGI = (GLEEPFNGLGETCOLORTABLEPARAMETERIVSGIPROC) __GLeeGetProcAddress("glGetColorTableParameterivSGI"))!=0) nLinked++;
#endif
    if (nLinked==7) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_SGIS_pixel_texture(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_SGIS_pixel_texture
    if ((GLeeFuncPtr_glPixelTexGenParameteriSGIS = (GLEEPFNGLPIXELTEXGENPARAMETERISGISPROC) __GLeeGetProcAddress("glPixelTexGenParameteriSGIS"))!=0) nLinked++;
    if ((GLeeFuncPtr_glPixelTexGenParameterivSGIS = (GLEEPFNGLPIXELTEXGENPARAMETERIVSGISPROC) __GLeeGetProcAddress("glPixelTexGenParameterivSGIS"))!=0) nLinked++;
    if ((GLeeFuncPtr_glPixelTexGenParameterfSGIS = (GLEEPFNGLPIXELTEXGENPARAMETERFSGISPROC) __GLeeGetProcAddress("glPixelTexGenParameterfSGIS"))!=0) nLinked++;
    if ((GLeeFuncPtr_glPixelTexGenParameterfvSGIS = (GLEEPFNGLPIXELTEXGENPARAMETERFVSGISPROC) __GLeeGetProcAddress("glPixelTexGenParameterfvSGIS"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetPixelTexGenParameterivSGIS = (GLEEPFNGLGETPIXELTEXGENPARAMETERIVSGISPROC) __GLeeGetProcAddress("glGetPixelTexGenParameterivSGIS"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetPixelTexGenParameterfvSGIS = (GLEEPFNGLGETPIXELTEXGENPARAMETERFVSGISPROC) __GLeeGetProcAddress("glGetPixelTexGenParameterfvSGIS"))!=0) nLinked++;
#endif
    if (nLinked==6) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_SGIX_pixel_texture(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_SGIX_pixel_texture
    if ((GLeeFuncPtr_glPixelTexGenSGIX = (GLEEPFNGLPIXELTEXGENSGIXPROC) __GLeeGetProcAddress("glPixelTexGenSGIX"))!=0) nLinked++;
#endif
    if (nLinked==1) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_SGIS_texture4D(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_SGIS_texture4D
    if ((GLeeFuncPtr_glTexImage4DSGIS = (GLEEPFNGLTEXIMAGE4DSGISPROC) __GLeeGetProcAddress("glTexImage4DSGIS"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTexSubImage4DSGIS = (GLEEPFNGLTEXSUBIMAGE4DSGISPROC) __GLeeGetProcAddress("glTexSubImage4DSGIS"))!=0) nLinked++;
#endif
    if (nLinked==2) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_SGI_texture_color_table(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_EXT_cmyka(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_EXT_texture_object(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_EXT_texture_object
    if ((GLeeFuncPtr_glAreTexturesResidentEXT = (GLEEPFNGLARETEXTURESRESIDENTEXTPROC) __GLeeGetProcAddress("glAreTexturesResidentEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glBindTextureEXT = (GLEEPFNGLBINDTEXTUREEXTPROC) __GLeeGetProcAddress("glBindTextureEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glDeleteTexturesEXT = (GLEEPFNGLDELETETEXTURESEXTPROC) __GLeeGetProcAddress("glDeleteTexturesEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGenTexturesEXT = (GLEEPFNGLGENTEXTURESEXTPROC) __GLeeGetProcAddress("glGenTexturesEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glIsTextureEXT = (GLEEPFNGLISTEXTUREEXTPROC) __GLeeGetProcAddress("glIsTextureEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glPrioritizeTexturesEXT = (GLEEPFNGLPRIORITIZETEXTURESEXTPROC) __GLeeGetProcAddress("glPrioritizeTexturesEXT"))!=0) nLinked++;
#endif
    if (nLinked==6) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_SGIS_detail_texture(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_SGIS_detail_texture
    if ((GLeeFuncPtr_glDetailTexFuncSGIS = (GLEEPFNGLDETAILTEXFUNCSGISPROC) __GLeeGetProcAddress("glDetailTexFuncSGIS"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetDetailTexFuncSGIS = (GLEEPFNGLGETDETAILTEXFUNCSGISPROC) __GLeeGetProcAddress("glGetDetailTexFuncSGIS"))!=0) nLinked++;
#endif
    if (nLinked==2) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_SGIS_sharpen_texture(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_SGIS_sharpen_texture
    if ((GLeeFuncPtr_glSharpenTexFuncSGIS = (GLEEPFNGLSHARPENTEXFUNCSGISPROC) __GLeeGetProcAddress("glSharpenTexFuncSGIS"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetSharpenTexFuncSGIS = (GLEEPFNGLGETSHARPENTEXFUNCSGISPROC) __GLeeGetProcAddress("glGetSharpenTexFuncSGIS"))!=0) nLinked++;
#endif
    if (nLinked==2) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_EXT_packed_pixels(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_SGIS_texture_lod(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_SGIS_multisample(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_SGIS_multisample
    if ((GLeeFuncPtr_glSampleMaskSGIS = (GLEEPFNGLSAMPLEMASKSGISPROC) __GLeeGetProcAddress("glSampleMaskSGIS"))!=0) nLinked++;
    if ((GLeeFuncPtr_glSamplePatternSGIS = (GLEEPFNGLSAMPLEPATTERNSGISPROC) __GLeeGetProcAddress("glSamplePatternSGIS"))!=0) nLinked++;
#endif
    if (nLinked==2) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_EXT_rescale_normal(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_EXT_vertex_array(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_EXT_vertex_array
    if ((GLeeFuncPtr_glArrayElementEXT = (GLEEPFNGLARRAYELEMENTEXTPROC) __GLeeGetProcAddress("glArrayElementEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glColorPointerEXT = (GLEEPFNGLCOLORPOINTEREXTPROC) __GLeeGetProcAddress("glColorPointerEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glDrawArraysEXT = (GLEEPFNGLDRAWARRAYSEXTPROC) __GLeeGetProcAddress("glDrawArraysEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glEdgeFlagPointerEXT = (GLEEPFNGLEDGEFLAGPOINTEREXTPROC) __GLeeGetProcAddress("glEdgeFlagPointerEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetPointervEXT = (GLEEPFNGLGETPOINTERVEXTPROC) __GLeeGetProcAddress("glGetPointervEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glIndexPointerEXT = (GLEEPFNGLINDEXPOINTEREXTPROC) __GLeeGetProcAddress("glIndexPointerEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glNormalPointerEXT = (GLEEPFNGLNORMALPOINTEREXTPROC) __GLeeGetProcAddress("glNormalPointerEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTexCoordPointerEXT = (GLEEPFNGLTEXCOORDPOINTEREXTPROC) __GLeeGetProcAddress("glTexCoordPointerEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexPointerEXT = (GLEEPFNGLVERTEXPOINTEREXTPROC) __GLeeGetProcAddress("glVertexPointerEXT"))!=0) nLinked++;
#endif
    if (nLinked==9) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_EXT_misc_attribute(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_SGIS_generate_mipmap(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_SGIX_clipmap(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_SGIX_shadow(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_SGIS_texture_edge_clamp(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_SGIS_texture_border_clamp(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_EXT_blend_minmax(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_EXT_blend_minmax
    if ((GLeeFuncPtr_glBlendEquationEXT = (GLEEPFNGLBLENDEQUATIONEXTPROC) __GLeeGetProcAddress("glBlendEquationEXT"))!=0) nLinked++;
#endif
    if (nLinked==1) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_EXT_blend_subtract(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_EXT_blend_logic_op(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_SGIX_interlace(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_SGIX_pixel_tiles(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_SGIS_texture_select(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_SGIX_sprite(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_SGIX_sprite
    if ((GLeeFuncPtr_glSpriteParameterfSGIX = (GLEEPFNGLSPRITEPARAMETERFSGIXPROC) __GLeeGetProcAddress("glSpriteParameterfSGIX"))!=0) nLinked++;
    if ((GLeeFuncPtr_glSpriteParameterfvSGIX = (GLEEPFNGLSPRITEPARAMETERFVSGIXPROC) __GLeeGetProcAddress("glSpriteParameterfvSGIX"))!=0) nLinked++;
    if ((GLeeFuncPtr_glSpriteParameteriSGIX = (GLEEPFNGLSPRITEPARAMETERISGIXPROC) __GLeeGetProcAddress("glSpriteParameteriSGIX"))!=0) nLinked++;
    if ((GLeeFuncPtr_glSpriteParameterivSGIX = (GLEEPFNGLSPRITEPARAMETERIVSGIXPROC) __GLeeGetProcAddress("glSpriteParameterivSGIX"))!=0) nLinked++;
#endif
    if (nLinked==4) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_SGIX_texture_multi_buffer(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_EXT_point_parameters(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_EXT_point_parameters
    if ((GLeeFuncPtr_glPointParameterfEXT = (GLEEPFNGLPOINTPARAMETERFEXTPROC) __GLeeGetProcAddress("glPointParameterfEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glPointParameterfvEXT = (GLEEPFNGLPOINTPARAMETERFVEXTPROC) __GLeeGetProcAddress("glPointParameterfvEXT"))!=0) nLinked++;
#endif
    if (nLinked==2) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_SGIS_point_parameters(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_SGIS_point_parameters
    if ((GLeeFuncPtr_glPointParameterfSGIS = (GLEEPFNGLPOINTPARAMETERFSGISPROC) __GLeeGetProcAddress("glPointParameterfSGIS"))!=0) nLinked++;
    if ((GLeeFuncPtr_glPointParameterfvSGIS = (GLEEPFNGLPOINTPARAMETERFVSGISPROC) __GLeeGetProcAddress("glPointParameterfvSGIS"))!=0) nLinked++;
#endif
    if (nLinked==2) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_SGIX_instruments(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_SGIX_instruments
    if ((GLeeFuncPtr_glGetInstrumentsSGIX = (GLEEPFNGLGETINSTRUMENTSSGIXPROC) __GLeeGetProcAddress("glGetInstrumentsSGIX"))!=0) nLinked++;
    if ((GLeeFuncPtr_glInstrumentsBufferSGIX = (GLEEPFNGLINSTRUMENTSBUFFERSGIXPROC) __GLeeGetProcAddress("glInstrumentsBufferSGIX"))!=0) nLinked++;
    if ((GLeeFuncPtr_glPollInstrumentsSGIX = (GLEEPFNGLPOLLINSTRUMENTSSGIXPROC) __GLeeGetProcAddress("glPollInstrumentsSGIX"))!=0) nLinked++;
    if ((GLeeFuncPtr_glReadInstrumentsSGIX = (GLEEPFNGLREADINSTRUMENTSSGIXPROC) __GLeeGetProcAddress("glReadInstrumentsSGIX"))!=0) nLinked++;
    if ((GLeeFuncPtr_glStartInstrumentsSGIX = (GLEEPFNGLSTARTINSTRUMENTSSGIXPROC) __GLeeGetProcAddress("glStartInstrumentsSGIX"))!=0) nLinked++;
    if ((GLeeFuncPtr_glStopInstrumentsSGIX = (GLEEPFNGLSTOPINSTRUMENTSSGIXPROC) __GLeeGetProcAddress("glStopInstrumentsSGIX"))!=0) nLinked++;
#endif
    if (nLinked==6) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_SGIX_texture_scale_bias(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_SGIX_framezoom(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_SGIX_framezoom
    if ((GLeeFuncPtr_glFrameZoomSGIX = (GLEEPFNGLFRAMEZOOMSGIXPROC) __GLeeGetProcAddress("glFrameZoomSGIX"))!=0) nLinked++;
#endif
    if (nLinked==1) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_SGIX_tag_sample_buffer(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_SGIX_tag_sample_buffer
    if ((GLeeFuncPtr_glTagSampleBufferSGIX = (GLEEPFNGLTAGSAMPLEBUFFERSGIXPROC) __GLeeGetProcAddress("glTagSampleBufferSGIX"))!=0) nLinked++;
#endif
    if (nLinked==1) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_FfdMaskSGIX(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_SGIX_polynomial_ffd(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_SGIX_polynomial_ffd
    if ((GLeeFuncPtr_glDeformationMap3dSGIX = (GLEEPFNGLDEFORMATIONMAP3DSGIXPROC) __GLeeGetProcAddress("glDeformationMap3dSGIX"))!=0) nLinked++;
    if ((GLeeFuncPtr_glDeformationMap3fSGIX = (GLEEPFNGLDEFORMATIONMAP3FSGIXPROC) __GLeeGetProcAddress("glDeformationMap3fSGIX"))!=0) nLinked++;
    if ((GLeeFuncPtr_glDeformSGIX = (GLEEPFNGLDEFORMSGIXPROC) __GLeeGetProcAddress("glDeformSGIX"))!=0) nLinked++;
    if ((GLeeFuncPtr_glLoadIdentityDeformationMapSGIX = (GLEEPFNGLLOADIDENTITYDEFORMATIONMAPSGIXPROC) __GLeeGetProcAddress("glLoadIdentityDeformationMapSGIX"))!=0) nLinked++;
#endif
    if (nLinked==4) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_SGIX_reference_plane(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_SGIX_reference_plane
    if ((GLeeFuncPtr_glReferencePlaneSGIX = (GLEEPFNGLREFERENCEPLANESGIXPROC) __GLeeGetProcAddress("glReferencePlaneSGIX"))!=0) nLinked++;
#endif
    if (nLinked==1) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_SGIX_flush_raster(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_SGIX_flush_raster
    if ((GLeeFuncPtr_glFlushRasterSGIX = (GLEEPFNGLFLUSHRASTERSGIXPROC) __GLeeGetProcAddress("glFlushRasterSGIX"))!=0) nLinked++;
#endif
    if (nLinked==1) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_SGIX_depth_texture(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_SGIS_fog_function(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_SGIS_fog_function
    if ((GLeeFuncPtr_glFogFuncSGIS = (GLEEPFNGLFOGFUNCSGISPROC) __GLeeGetProcAddress("glFogFuncSGIS"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetFogFuncSGIS = (GLEEPFNGLGETFOGFUNCSGISPROC) __GLeeGetProcAddress("glGetFogFuncSGIS"))!=0) nLinked++;
#endif
    if (nLinked==2) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_SGIX_fog_offset(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_HP_image_transform(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_HP_image_transform
    if ((GLeeFuncPtr_glImageTransformParameteriHP = (GLEEPFNGLIMAGETRANSFORMPARAMETERIHPPROC) __GLeeGetProcAddress("glImageTransformParameteriHP"))!=0) nLinked++;
    if ((GLeeFuncPtr_glImageTransformParameterfHP = (GLEEPFNGLIMAGETRANSFORMPARAMETERFHPPROC) __GLeeGetProcAddress("glImageTransformParameterfHP"))!=0) nLinked++;
    if ((GLeeFuncPtr_glImageTransformParameterivHP = (GLEEPFNGLIMAGETRANSFORMPARAMETERIVHPPROC) __GLeeGetProcAddress("glImageTransformParameterivHP"))!=0) nLinked++;
    if ((GLeeFuncPtr_glImageTransformParameterfvHP = (GLEEPFNGLIMAGETRANSFORMPARAMETERFVHPPROC) __GLeeGetProcAddress("glImageTransformParameterfvHP"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetImageTransformParameterivHP = (GLEEPFNGLGETIMAGETRANSFORMPARAMETERIVHPPROC) __GLeeGetProcAddress("glGetImageTransformParameterivHP"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetImageTransformParameterfvHP = (GLEEPFNGLGETIMAGETRANSFORMPARAMETERFVHPPROC) __GLeeGetProcAddress("glGetImageTransformParameterfvHP"))!=0) nLinked++;
#endif
    if (nLinked==6) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_HP_convolution_border_modes(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_INGR_palette_buffer(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_SGIX_texture_add_env(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_EXT_color_subtable(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_EXT_color_subtable
    if ((GLeeFuncPtr_glColorSubTableEXT = (GLEEPFNGLCOLORSUBTABLEEXTPROC) __GLeeGetProcAddress("glColorSubTableEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glCopyColorSubTableEXT = (GLEEPFNGLCOPYCOLORSUBTABLEEXTPROC) __GLeeGetProcAddress("glCopyColorSubTableEXT"))!=0) nLinked++;
#endif
    if (nLinked==2) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_PGI_vertex_hints(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_PGI_misc_hints(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_PGI_misc_hints
    if ((GLeeFuncPtr_glHintPGI = (GLEEPFNGLHINTPGIPROC) __GLeeGetProcAddress("glHintPGI"))!=0) nLinked++;
#endif
    if (nLinked==1) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_EXT_paletted_texture(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_EXT_paletted_texture
    if ((GLeeFuncPtr_glColorTableEXT = (GLEEPFNGLCOLORTABLEEXTPROC) __GLeeGetProcAddress("glColorTableEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetColorTableEXT = (GLEEPFNGLGETCOLORTABLEEXTPROC) __GLeeGetProcAddress("glGetColorTableEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetColorTableParameterivEXT = (GLEEPFNGLGETCOLORTABLEPARAMETERIVEXTPROC) __GLeeGetProcAddress("glGetColorTableParameterivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetColorTableParameterfvEXT = (GLEEPFNGLGETCOLORTABLEPARAMETERFVEXTPROC) __GLeeGetProcAddress("glGetColorTableParameterfvEXT"))!=0) nLinked++;
#endif
    if (nLinked==4) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_EXT_clip_volume_hint(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_SGIX_list_priority(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_SGIX_list_priority
    if ((GLeeFuncPtr_glGetListParameterfvSGIX = (GLEEPFNGLGETLISTPARAMETERFVSGIXPROC) __GLeeGetProcAddress("glGetListParameterfvSGIX"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetListParameterivSGIX = (GLEEPFNGLGETLISTPARAMETERIVSGIXPROC) __GLeeGetProcAddress("glGetListParameterivSGIX"))!=0) nLinked++;
    if ((GLeeFuncPtr_glListParameterfSGIX = (GLEEPFNGLLISTPARAMETERFSGIXPROC) __GLeeGetProcAddress("glListParameterfSGIX"))!=0) nLinked++;
    if ((GLeeFuncPtr_glListParameterfvSGIX = (GLEEPFNGLLISTPARAMETERFVSGIXPROC) __GLeeGetProcAddress("glListParameterfvSGIX"))!=0) nLinked++;
    if ((GLeeFuncPtr_glListParameteriSGIX = (GLEEPFNGLLISTPARAMETERISGIXPROC) __GLeeGetProcAddress("glListParameteriSGIX"))!=0) nLinked++;
    if ((GLeeFuncPtr_glListParameterivSGIX = (GLEEPFNGLLISTPARAMETERIVSGIXPROC) __GLeeGetProcAddress("glListParameterivSGIX"))!=0) nLinked++;
#endif
    if (nLinked==6) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_SGIX_ir_instrument1(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_SGIX_calligraphic_fragment(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_SGIX_texture_lod_bias(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_SGIX_shadow_ambient(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_EXT_index_texture(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_EXT_index_material(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_EXT_index_material
    if ((GLeeFuncPtr_glIndexMaterialEXT = (GLEEPFNGLINDEXMATERIALEXTPROC) __GLeeGetProcAddress("glIndexMaterialEXT"))!=0) nLinked++;
#endif
    if (nLinked==1) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_EXT_index_func(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_EXT_index_func
    if ((GLeeFuncPtr_glIndexFuncEXT = (GLEEPFNGLINDEXFUNCEXTPROC) __GLeeGetProcAddress("glIndexFuncEXT"))!=0) nLinked++;
#endif
    if (nLinked==1) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_EXT_index_array_formats(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_EXT_compiled_vertex_array(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_EXT_compiled_vertex_array
    if ((GLeeFuncPtr_glLockArraysEXT = (GLEEPFNGLLOCKARRAYSEXTPROC) __GLeeGetProcAddress("glLockArraysEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUnlockArraysEXT = (GLEEPFNGLUNLOCKARRAYSEXTPROC) __GLeeGetProcAddress("glUnlockArraysEXT"))!=0) nLinked++;
#endif
    if (nLinked==2) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_EXT_cull_vertex(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_EXT_cull_vertex
    if ((GLeeFuncPtr_glCullParameterdvEXT = (GLEEPFNGLCULLPARAMETERDVEXTPROC) __GLeeGetProcAddress("glCullParameterdvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glCullParameterfvEXT = (GLEEPFNGLCULLPARAMETERFVEXTPROC) __GLeeGetProcAddress("glCullParameterfvEXT"))!=0) nLinked++;
#endif
    if (nLinked==2) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_SGIX_ycrcb(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_SGIX_fragment_lighting(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_SGIX_fragment_lighting
    if ((GLeeFuncPtr_glFragmentColorMaterialSGIX = (GLEEPFNGLFRAGMENTCOLORMATERIALSGIXPROC) __GLeeGetProcAddress("glFragmentColorMaterialSGIX"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFragmentLightfSGIX = (GLEEPFNGLFRAGMENTLIGHTFSGIXPROC) __GLeeGetProcAddress("glFragmentLightfSGIX"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFragmentLightfvSGIX = (GLEEPFNGLFRAGMENTLIGHTFVSGIXPROC) __GLeeGetProcAddress("glFragmentLightfvSGIX"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFragmentLightiSGIX = (GLEEPFNGLFRAGMENTLIGHTISGIXPROC) __GLeeGetProcAddress("glFragmentLightiSGIX"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFragmentLightivSGIX = (GLEEPFNGLFRAGMENTLIGHTIVSGIXPROC) __GLeeGetProcAddress("glFragmentLightivSGIX"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFragmentLightModelfSGIX = (GLEEPFNGLFRAGMENTLIGHTMODELFSGIXPROC) __GLeeGetProcAddress("glFragmentLightModelfSGIX"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFragmentLightModelfvSGIX = (GLEEPFNGLFRAGMENTLIGHTMODELFVSGIXPROC) __GLeeGetProcAddress("glFragmentLightModelfvSGIX"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFragmentLightModeliSGIX = (GLEEPFNGLFRAGMENTLIGHTMODELISGIXPROC) __GLeeGetProcAddress("glFragmentLightModeliSGIX"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFragmentLightModelivSGIX = (GLEEPFNGLFRAGMENTLIGHTMODELIVSGIXPROC) __GLeeGetProcAddress("glFragmentLightModelivSGIX"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFragmentMaterialfSGIX = (GLEEPFNGLFRAGMENTMATERIALFSGIXPROC) __GLeeGetProcAddress("glFragmentMaterialfSGIX"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFragmentMaterialfvSGIX = (GLEEPFNGLFRAGMENTMATERIALFVSGIXPROC) __GLeeGetProcAddress("glFragmentMaterialfvSGIX"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFragmentMaterialiSGIX = (GLEEPFNGLFRAGMENTMATERIALISGIXPROC) __GLeeGetProcAddress("glFragmentMaterialiSGIX"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFragmentMaterialivSGIX = (GLEEPFNGLFRAGMENTMATERIALIVSGIXPROC) __GLeeGetProcAddress("glFragmentMaterialivSGIX"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetFragmentLightfvSGIX = (GLEEPFNGLGETFRAGMENTLIGHTFVSGIXPROC) __GLeeGetProcAddress("glGetFragmentLightfvSGIX"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetFragmentLightivSGIX = (GLEEPFNGLGETFRAGMENTLIGHTIVSGIXPROC) __GLeeGetProcAddress("glGetFragmentLightivSGIX"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetFragmentMaterialfvSGIX = (GLEEPFNGLGETFRAGMENTMATERIALFVSGIXPROC) __GLeeGetProcAddress("glGetFragmentMaterialfvSGIX"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetFragmentMaterialivSGIX = (GLEEPFNGLGETFRAGMENTMATERIALIVSGIXPROC) __GLeeGetProcAddress("glGetFragmentMaterialivSGIX"))!=0) nLinked++;
    if ((GLeeFuncPtr_glLightEnviSGIX = (GLEEPFNGLLIGHTENVISGIXPROC) __GLeeGetProcAddress("glLightEnviSGIX"))!=0) nLinked++;
#endif
    if (nLinked==18) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_IBM_rasterpos_clip(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_HP_texture_lighting(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_EXT_draw_range_elements(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_EXT_draw_range_elements
    if ((GLeeFuncPtr_glDrawRangeElementsEXT = (GLEEPFNGLDRAWRANGEELEMENTSEXTPROC) __GLeeGetProcAddress("glDrawRangeElementsEXT"))!=0) nLinked++;
#endif
    if (nLinked==1) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_WIN_phong_shading(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_WIN_specular_fog(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_EXT_light_texture(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_EXT_light_texture
    if ((GLeeFuncPtr_glApplyTextureEXT = (GLEEPFNGLAPPLYTEXTUREEXTPROC) __GLeeGetProcAddress("glApplyTextureEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTextureLightEXT = (GLEEPFNGLTEXTURELIGHTEXTPROC) __GLeeGetProcAddress("glTextureLightEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTextureMaterialEXT = (GLEEPFNGLTEXTUREMATERIALEXTPROC) __GLeeGetProcAddress("glTextureMaterialEXT"))!=0) nLinked++;
#endif
    if (nLinked==3) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_SGIX_blend_alpha_minmax(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_SGIX_impact_pixel_texture(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_EXT_bgra(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_SGIX_async(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_SGIX_async
    if ((GLeeFuncPtr_glAsyncMarkerSGIX = (GLEEPFNGLASYNCMARKERSGIXPROC) __GLeeGetProcAddress("glAsyncMarkerSGIX"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFinishAsyncSGIX = (GLEEPFNGLFINISHASYNCSGIXPROC) __GLeeGetProcAddress("glFinishAsyncSGIX"))!=0) nLinked++;
    if ((GLeeFuncPtr_glPollAsyncSGIX = (GLEEPFNGLPOLLASYNCSGIXPROC) __GLeeGetProcAddress("glPollAsyncSGIX"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGenAsyncMarkersSGIX = (GLEEPFNGLGENASYNCMARKERSSGIXPROC) __GLeeGetProcAddress("glGenAsyncMarkersSGIX"))!=0) nLinked++;
    if ((GLeeFuncPtr_glDeleteAsyncMarkersSGIX = (GLEEPFNGLDELETEASYNCMARKERSSGIXPROC) __GLeeGetProcAddress("glDeleteAsyncMarkersSGIX"))!=0) nLinked++;
    if ((GLeeFuncPtr_glIsAsyncMarkerSGIX = (GLEEPFNGLISASYNCMARKERSGIXPROC) __GLeeGetProcAddress("glIsAsyncMarkerSGIX"))!=0) nLinked++;
#endif
    if (nLinked==6) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_SGIX_async_pixel(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_SGIX_async_histogram(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_INTEL_texture_scissor(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_INTEL_parallel_arrays(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_INTEL_parallel_arrays
    if ((GLeeFuncPtr_glVertexPointervINTEL = (GLEEPFNGLVERTEXPOINTERVINTELPROC) __GLeeGetProcAddress("glVertexPointervINTEL"))!=0) nLinked++;
    if ((GLeeFuncPtr_glNormalPointervINTEL = (GLEEPFNGLNORMALPOINTERVINTELPROC) __GLeeGetProcAddress("glNormalPointervINTEL"))!=0) nLinked++;
    if ((GLeeFuncPtr_glColorPointervINTEL = (GLEEPFNGLCOLORPOINTERVINTELPROC) __GLeeGetProcAddress("glColorPointervINTEL"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTexCoordPointervINTEL = (GLEEPFNGLTEXCOORDPOINTERVINTELPROC) __GLeeGetProcAddress("glTexCoordPointervINTEL"))!=0) nLinked++;
#endif
    if (nLinked==4) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_HP_occlusion_test(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_EXT_pixel_transform(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_EXT_pixel_transform
    if ((GLeeFuncPtr_glPixelTransformParameteriEXT = (GLEEPFNGLPIXELTRANSFORMPARAMETERIEXTPROC) __GLeeGetProcAddress("glPixelTransformParameteriEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glPixelTransformParameterfEXT = (GLEEPFNGLPIXELTRANSFORMPARAMETERFEXTPROC) __GLeeGetProcAddress("glPixelTransformParameterfEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glPixelTransformParameterivEXT = (GLEEPFNGLPIXELTRANSFORMPARAMETERIVEXTPROC) __GLeeGetProcAddress("glPixelTransformParameterivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glPixelTransformParameterfvEXT = (GLEEPFNGLPIXELTRANSFORMPARAMETERFVEXTPROC) __GLeeGetProcAddress("glPixelTransformParameterfvEXT"))!=0) nLinked++;
#endif
    if (nLinked==4) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_EXT_pixel_transform_color_table(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_EXT_shared_texture_palette(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_EXT_separate_specular_color(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_EXT_secondary_color(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_EXT_secondary_color
    if ((GLeeFuncPtr_glSecondaryColor3bEXT = (GLEEPFNGLSECONDARYCOLOR3BEXTPROC) __GLeeGetProcAddress("glSecondaryColor3bEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glSecondaryColor3bvEXT = (GLEEPFNGLSECONDARYCOLOR3BVEXTPROC) __GLeeGetProcAddress("glSecondaryColor3bvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glSecondaryColor3dEXT = (GLEEPFNGLSECONDARYCOLOR3DEXTPROC) __GLeeGetProcAddress("glSecondaryColor3dEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glSecondaryColor3dvEXT = (GLEEPFNGLSECONDARYCOLOR3DVEXTPROC) __GLeeGetProcAddress("glSecondaryColor3dvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glSecondaryColor3fEXT = (GLEEPFNGLSECONDARYCOLOR3FEXTPROC) __GLeeGetProcAddress("glSecondaryColor3fEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glSecondaryColor3fvEXT = (GLEEPFNGLSECONDARYCOLOR3FVEXTPROC) __GLeeGetProcAddress("glSecondaryColor3fvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glSecondaryColor3iEXT = (GLEEPFNGLSECONDARYCOLOR3IEXTPROC) __GLeeGetProcAddress("glSecondaryColor3iEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glSecondaryColor3ivEXT = (GLEEPFNGLSECONDARYCOLOR3IVEXTPROC) __GLeeGetProcAddress("glSecondaryColor3ivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glSecondaryColor3sEXT = (GLEEPFNGLSECONDARYCOLOR3SEXTPROC) __GLeeGetProcAddress("glSecondaryColor3sEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glSecondaryColor3svEXT = (GLEEPFNGLSECONDARYCOLOR3SVEXTPROC) __GLeeGetProcAddress("glSecondaryColor3svEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glSecondaryColor3ubEXT = (GLEEPFNGLSECONDARYCOLOR3UBEXTPROC) __GLeeGetProcAddress("glSecondaryColor3ubEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glSecondaryColor3ubvEXT = (GLEEPFNGLSECONDARYCOLOR3UBVEXTPROC) __GLeeGetProcAddress("glSecondaryColor3ubvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glSecondaryColor3uiEXT = (GLEEPFNGLSECONDARYCOLOR3UIEXTPROC) __GLeeGetProcAddress("glSecondaryColor3uiEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glSecondaryColor3uivEXT = (GLEEPFNGLSECONDARYCOLOR3UIVEXTPROC) __GLeeGetProcAddress("glSecondaryColor3uivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glSecondaryColor3usEXT = (GLEEPFNGLSECONDARYCOLOR3USEXTPROC) __GLeeGetProcAddress("glSecondaryColor3usEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glSecondaryColor3usvEXT = (GLEEPFNGLSECONDARYCOLOR3USVEXTPROC) __GLeeGetProcAddress("glSecondaryColor3usvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glSecondaryColorPointerEXT = (GLEEPFNGLSECONDARYCOLORPOINTEREXTPROC) __GLeeGetProcAddress("glSecondaryColorPointerEXT"))!=0) nLinked++;
#endif
    if (nLinked==17) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_EXT_texture_perturb_normal(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_EXT_texture_perturb_normal
    if ((GLeeFuncPtr_glTextureNormalEXT = (GLEEPFNGLTEXTURENORMALEXTPROC) __GLeeGetProcAddress("glTextureNormalEXT"))!=0) nLinked++;
#endif
    if (nLinked==1) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_EXT_multi_draw_arrays(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_EXT_multi_draw_arrays
    if ((GLeeFuncPtr_glMultiDrawArraysEXT = (GLEEPFNGLMULTIDRAWARRAYSEXTPROC) __GLeeGetProcAddress("glMultiDrawArraysEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiDrawElementsEXT = (GLEEPFNGLMULTIDRAWELEMENTSEXTPROC) __GLeeGetProcAddress("glMultiDrawElementsEXT"))!=0) nLinked++;
#endif
    if (nLinked==2) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_EXT_fog_coord(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_EXT_fog_coord
    if ((GLeeFuncPtr_glFogCoordfEXT = (GLEEPFNGLFOGCOORDFEXTPROC) __GLeeGetProcAddress("glFogCoordfEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFogCoordfvEXT = (GLEEPFNGLFOGCOORDFVEXTPROC) __GLeeGetProcAddress("glFogCoordfvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFogCoorddEXT = (GLEEPFNGLFOGCOORDDEXTPROC) __GLeeGetProcAddress("glFogCoorddEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFogCoorddvEXT = (GLEEPFNGLFOGCOORDDVEXTPROC) __GLeeGetProcAddress("glFogCoorddvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFogCoordPointerEXT = (GLEEPFNGLFOGCOORDPOINTEREXTPROC) __GLeeGetProcAddress("glFogCoordPointerEXT"))!=0) nLinked++;
#endif
    if (nLinked==5) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_REND_screen_coordinates(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_EXT_coordinate_frame(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_EXT_coordinate_frame
    if ((GLeeFuncPtr_glTangent3bEXT = (GLEEPFNGLTANGENT3BEXTPROC) __GLeeGetProcAddress("glTangent3bEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTangent3bvEXT = (GLEEPFNGLTANGENT3BVEXTPROC) __GLeeGetProcAddress("glTangent3bvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTangent3dEXT = (GLEEPFNGLTANGENT3DEXTPROC) __GLeeGetProcAddress("glTangent3dEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTangent3dvEXT = (GLEEPFNGLTANGENT3DVEXTPROC) __GLeeGetProcAddress("glTangent3dvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTangent3fEXT = (GLEEPFNGLTANGENT3FEXTPROC) __GLeeGetProcAddress("glTangent3fEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTangent3fvEXT = (GLEEPFNGLTANGENT3FVEXTPROC) __GLeeGetProcAddress("glTangent3fvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTangent3iEXT = (GLEEPFNGLTANGENT3IEXTPROC) __GLeeGetProcAddress("glTangent3iEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTangent3ivEXT = (GLEEPFNGLTANGENT3IVEXTPROC) __GLeeGetProcAddress("glTangent3ivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTangent3sEXT = (GLEEPFNGLTANGENT3SEXTPROC) __GLeeGetProcAddress("glTangent3sEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTangent3svEXT = (GLEEPFNGLTANGENT3SVEXTPROC) __GLeeGetProcAddress("glTangent3svEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glBinormal3bEXT = (GLEEPFNGLBINORMAL3BEXTPROC) __GLeeGetProcAddress("glBinormal3bEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glBinormal3bvEXT = (GLEEPFNGLBINORMAL3BVEXTPROC) __GLeeGetProcAddress("glBinormal3bvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glBinormal3dEXT = (GLEEPFNGLBINORMAL3DEXTPROC) __GLeeGetProcAddress("glBinormal3dEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glBinormal3dvEXT = (GLEEPFNGLBINORMAL3DVEXTPROC) __GLeeGetProcAddress("glBinormal3dvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glBinormal3fEXT = (GLEEPFNGLBINORMAL3FEXTPROC) __GLeeGetProcAddress("glBinormal3fEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glBinormal3fvEXT = (GLEEPFNGLBINORMAL3FVEXTPROC) __GLeeGetProcAddress("glBinormal3fvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glBinormal3iEXT = (GLEEPFNGLBINORMAL3IEXTPROC) __GLeeGetProcAddress("glBinormal3iEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glBinormal3ivEXT = (GLEEPFNGLBINORMAL3IVEXTPROC) __GLeeGetProcAddress("glBinormal3ivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glBinormal3sEXT = (GLEEPFNGLBINORMAL3SEXTPROC) __GLeeGetProcAddress("glBinormal3sEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glBinormal3svEXT = (GLEEPFNGLBINORMAL3SVEXTPROC) __GLeeGetProcAddress("glBinormal3svEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTangentPointerEXT = (GLEEPFNGLTANGENTPOINTEREXTPROC) __GLeeGetProcAddress("glTangentPointerEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glBinormalPointerEXT = (GLEEPFNGLBINORMALPOINTEREXTPROC) __GLeeGetProcAddress("glBinormalPointerEXT"))!=0) nLinked++;
#endif
    if (nLinked==22) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_EXT_texture_env_combine(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_APPLE_specular_vector(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_APPLE_transform_hint(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_SGIX_fog_scale(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_SUNX_constant_data(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_SUNX_constant_data
    if ((GLeeFuncPtr_glFinishTextureSUNX = (GLEEPFNGLFINISHTEXTURESUNXPROC) __GLeeGetProcAddress("glFinishTextureSUNX"))!=0) nLinked++;
#endif
    if (nLinked==1) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_SUN_global_alpha(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_SUN_global_alpha
    if ((GLeeFuncPtr_glGlobalAlphaFactorbSUN = (GLEEPFNGLGLOBALALPHAFACTORBSUNPROC) __GLeeGetProcAddress("glGlobalAlphaFactorbSUN"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGlobalAlphaFactorsSUN = (GLEEPFNGLGLOBALALPHAFACTORSSUNPROC) __GLeeGetProcAddress("glGlobalAlphaFactorsSUN"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGlobalAlphaFactoriSUN = (GLEEPFNGLGLOBALALPHAFACTORISUNPROC) __GLeeGetProcAddress("glGlobalAlphaFactoriSUN"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGlobalAlphaFactorfSUN = (GLEEPFNGLGLOBALALPHAFACTORFSUNPROC) __GLeeGetProcAddress("glGlobalAlphaFactorfSUN"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGlobalAlphaFactordSUN = (GLEEPFNGLGLOBALALPHAFACTORDSUNPROC) __GLeeGetProcAddress("glGlobalAlphaFactordSUN"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGlobalAlphaFactorubSUN = (GLEEPFNGLGLOBALALPHAFACTORUBSUNPROC) __GLeeGetProcAddress("glGlobalAlphaFactorubSUN"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGlobalAlphaFactorusSUN = (GLEEPFNGLGLOBALALPHAFACTORUSSUNPROC) __GLeeGetProcAddress("glGlobalAlphaFactorusSUN"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGlobalAlphaFactoruiSUN = (GLEEPFNGLGLOBALALPHAFACTORUISUNPROC) __GLeeGetProcAddress("glGlobalAlphaFactoruiSUN"))!=0) nLinked++;
#endif
    if (nLinked==8) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_SUN_triangle_list(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_SUN_triangle_list
    if ((GLeeFuncPtr_glReplacementCodeuiSUN = (GLEEPFNGLREPLACEMENTCODEUISUNPROC) __GLeeGetProcAddress("glReplacementCodeuiSUN"))!=0) nLinked++;
    if ((GLeeFuncPtr_glReplacementCodeusSUN = (GLEEPFNGLREPLACEMENTCODEUSSUNPROC) __GLeeGetProcAddress("glReplacementCodeusSUN"))!=0) nLinked++;
    if ((GLeeFuncPtr_glReplacementCodeubSUN = (GLEEPFNGLREPLACEMENTCODEUBSUNPROC) __GLeeGetProcAddress("glReplacementCodeubSUN"))!=0) nLinked++;
    if ((GLeeFuncPtr_glReplacementCodeuivSUN = (GLEEPFNGLREPLACEMENTCODEUIVSUNPROC) __GLeeGetProcAddress("glReplacementCodeuivSUN"))!=0) nLinked++;
    if ((GLeeFuncPtr_glReplacementCodeusvSUN = (GLEEPFNGLREPLACEMENTCODEUSVSUNPROC) __GLeeGetProcAddress("glReplacementCodeusvSUN"))!=0) nLinked++;
    if ((GLeeFuncPtr_glReplacementCodeubvSUN = (GLEEPFNGLREPLACEMENTCODEUBVSUNPROC) __GLeeGetProcAddress("glReplacementCodeubvSUN"))!=0) nLinked++;
    if ((GLeeFuncPtr_glReplacementCodePointerSUN = (GLEEPFNGLREPLACEMENTCODEPOINTERSUNPROC) __GLeeGetProcAddress("glReplacementCodePointerSUN"))!=0) nLinked++;
#endif
    if (nLinked==7) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_SUN_vertex(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_SUN_vertex
    if ((GLeeFuncPtr_glColor4ubVertex2fSUN = (GLEEPFNGLCOLOR4UBVERTEX2FSUNPROC) __GLeeGetProcAddress("glColor4ubVertex2fSUN"))!=0) nLinked++;
    if ((GLeeFuncPtr_glColor4ubVertex2fvSUN = (GLEEPFNGLCOLOR4UBVERTEX2FVSUNPROC) __GLeeGetProcAddress("glColor4ubVertex2fvSUN"))!=0) nLinked++;
    if ((GLeeFuncPtr_glColor4ubVertex3fSUN = (GLEEPFNGLCOLOR4UBVERTEX3FSUNPROC) __GLeeGetProcAddress("glColor4ubVertex3fSUN"))!=0) nLinked++;
    if ((GLeeFuncPtr_glColor4ubVertex3fvSUN = (GLEEPFNGLCOLOR4UBVERTEX3FVSUNPROC) __GLeeGetProcAddress("glColor4ubVertex3fvSUN"))!=0) nLinked++;
    if ((GLeeFuncPtr_glColor3fVertex3fSUN = (GLEEPFNGLCOLOR3FVERTEX3FSUNPROC) __GLeeGetProcAddress("glColor3fVertex3fSUN"))!=0) nLinked++;
    if ((GLeeFuncPtr_glColor3fVertex3fvSUN = (GLEEPFNGLCOLOR3FVERTEX3FVSUNPROC) __GLeeGetProcAddress("glColor3fVertex3fvSUN"))!=0) nLinked++;
    if ((GLeeFuncPtr_glNormal3fVertex3fSUN = (GLEEPFNGLNORMAL3FVERTEX3FSUNPROC) __GLeeGetProcAddress("glNormal3fVertex3fSUN"))!=0) nLinked++;
    if ((GLeeFuncPtr_glNormal3fVertex3fvSUN = (GLEEPFNGLNORMAL3FVERTEX3FVSUNPROC) __GLeeGetProcAddress("glNormal3fVertex3fvSUN"))!=0) nLinked++;
    if ((GLeeFuncPtr_glColor4fNormal3fVertex3fSUN = (GLEEPFNGLCOLOR4FNORMAL3FVERTEX3FSUNPROC) __GLeeGetProcAddress("glColor4fNormal3fVertex3fSUN"))!=0) nLinked++;
    if ((GLeeFuncPtr_glColor4fNormal3fVertex3fvSUN = (GLEEPFNGLCOLOR4FNORMAL3FVERTEX3FVSUNPROC) __GLeeGetProcAddress("glColor4fNormal3fVertex3fvSUN"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTexCoord2fVertex3fSUN = (GLEEPFNGLTEXCOORD2FVERTEX3FSUNPROC) __GLeeGetProcAddress("glTexCoord2fVertex3fSUN"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTexCoord2fVertex3fvSUN = (GLEEPFNGLTEXCOORD2FVERTEX3FVSUNPROC) __GLeeGetProcAddress("glTexCoord2fVertex3fvSUN"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTexCoord4fVertex4fSUN = (GLEEPFNGLTEXCOORD4FVERTEX4FSUNPROC) __GLeeGetProcAddress("glTexCoord4fVertex4fSUN"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTexCoord4fVertex4fvSUN = (GLEEPFNGLTEXCOORD4FVERTEX4FVSUNPROC) __GLeeGetProcAddress("glTexCoord4fVertex4fvSUN"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTexCoord2fColor4ubVertex3fSUN = (GLEEPFNGLTEXCOORD2FCOLOR4UBVERTEX3FSUNPROC) __GLeeGetProcAddress("glTexCoord2fColor4ubVertex3fSUN"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTexCoord2fColor4ubVertex3fvSUN = (GLEEPFNGLTEXCOORD2FCOLOR4UBVERTEX3FVSUNPROC) __GLeeGetProcAddress("glTexCoord2fColor4ubVertex3fvSUN"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTexCoord2fColor3fVertex3fSUN = (GLEEPFNGLTEXCOORD2FCOLOR3FVERTEX3FSUNPROC) __GLeeGetProcAddress("glTexCoord2fColor3fVertex3fSUN"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTexCoord2fColor3fVertex3fvSUN = (GLEEPFNGLTEXCOORD2FCOLOR3FVERTEX3FVSUNPROC) __GLeeGetProcAddress("glTexCoord2fColor3fVertex3fvSUN"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTexCoord2fNormal3fVertex3fSUN = (GLEEPFNGLTEXCOORD2FNORMAL3FVERTEX3FSUNPROC) __GLeeGetProcAddress("glTexCoord2fNormal3fVertex3fSUN"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTexCoord2fNormal3fVertex3fvSUN = (GLEEPFNGLTEXCOORD2FNORMAL3FVERTEX3FVSUNPROC) __GLeeGetProcAddress("glTexCoord2fNormal3fVertex3fvSUN"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTexCoord2fColor4fNormal3fVertex3fSUN = (GLEEPFNGLTEXCOORD2FCOLOR4FNORMAL3FVERTEX3FSUNPROC) __GLeeGetProcAddress("glTexCoord2fColor4fNormal3fVertex3fSUN"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTexCoord2fColor4fNormal3fVertex3fvSUN = (GLEEPFNGLTEXCOORD2FCOLOR4FNORMAL3FVERTEX3FVSUNPROC) __GLeeGetProcAddress("glTexCoord2fColor4fNormal3fVertex3fvSUN"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTexCoord4fColor4fNormal3fVertex4fSUN = (GLEEPFNGLTEXCOORD4FCOLOR4FNORMAL3FVERTEX4FSUNPROC) __GLeeGetProcAddress("glTexCoord4fColor4fNormal3fVertex4fSUN"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTexCoord4fColor4fNormal3fVertex4fvSUN = (GLEEPFNGLTEXCOORD4FCOLOR4FNORMAL3FVERTEX4FVSUNPROC) __GLeeGetProcAddress("glTexCoord4fColor4fNormal3fVertex4fvSUN"))!=0) nLinked++;
    if ((GLeeFuncPtr_glReplacementCodeuiVertex3fSUN = (GLEEPFNGLREPLACEMENTCODEUIVERTEX3FSUNPROC) __GLeeGetProcAddress("glReplacementCodeuiVertex3fSUN"))!=0) nLinked++;
    if ((GLeeFuncPtr_glReplacementCodeuiVertex3fvSUN = (GLEEPFNGLREPLACEMENTCODEUIVERTEX3FVSUNPROC) __GLeeGetProcAddress("glReplacementCodeuiVertex3fvSUN"))!=0) nLinked++;
    if ((GLeeFuncPtr_glReplacementCodeuiColor4ubVertex3fSUN = (GLEEPFNGLREPLACEMENTCODEUICOLOR4UBVERTEX3FSUNPROC) __GLeeGetProcAddress("glReplacementCodeuiColor4ubVertex3fSUN"))!=0) nLinked++;
    if ((GLeeFuncPtr_glReplacementCodeuiColor4ubVertex3fvSUN = (GLEEPFNGLREPLACEMENTCODEUICOLOR4UBVERTEX3FVSUNPROC) __GLeeGetProcAddress("glReplacementCodeuiColor4ubVertex3fvSUN"))!=0) nLinked++;
    if ((GLeeFuncPtr_glReplacementCodeuiColor3fVertex3fSUN = (GLEEPFNGLREPLACEMENTCODEUICOLOR3FVERTEX3FSUNPROC) __GLeeGetProcAddress("glReplacementCodeuiColor3fVertex3fSUN"))!=0) nLinked++;
    if ((GLeeFuncPtr_glReplacementCodeuiColor3fVertex3fvSUN = (GLEEPFNGLREPLACEMENTCODEUICOLOR3FVERTEX3FVSUNPROC) __GLeeGetProcAddress("glReplacementCodeuiColor3fVertex3fvSUN"))!=0) nLinked++;
    if ((GLeeFuncPtr_glReplacementCodeuiNormal3fVertex3fSUN = (GLEEPFNGLREPLACEMENTCODEUINORMAL3FVERTEX3FSUNPROC) __GLeeGetProcAddress("glReplacementCodeuiNormal3fVertex3fSUN"))!=0) nLinked++;
    if ((GLeeFuncPtr_glReplacementCodeuiNormal3fVertex3fvSUN = (GLEEPFNGLREPLACEMENTCODEUINORMAL3FVERTEX3FVSUNPROC) __GLeeGetProcAddress("glReplacementCodeuiNormal3fVertex3fvSUN"))!=0) nLinked++;
    if ((GLeeFuncPtr_glReplacementCodeuiColor4fNormal3fVertex3fSUN = (GLEEPFNGLREPLACEMENTCODEUICOLOR4FNORMAL3FVERTEX3FSUNPROC) __GLeeGetProcAddress("glReplacementCodeuiColor4fNormal3fVertex3fSUN"))!=0) nLinked++;
    if ((GLeeFuncPtr_glReplacementCodeuiColor4fNormal3fVertex3fvSUN = (GLEEPFNGLREPLACEMENTCODEUICOLOR4FNORMAL3FVERTEX3FVSUNPROC) __GLeeGetProcAddress("glReplacementCodeuiColor4fNormal3fVertex3fvSUN"))!=0) nLinked++;
    if ((GLeeFuncPtr_glReplacementCodeuiTexCoord2fVertex3fSUN = (GLEEPFNGLREPLACEMENTCODEUITEXCOORD2FVERTEX3FSUNPROC) __GLeeGetProcAddress("glReplacementCodeuiTexCoord2fVertex3fSUN"))!=0) nLinked++;
    if ((GLeeFuncPtr_glReplacementCodeuiTexCoord2fVertex3fvSUN = (GLEEPFNGLREPLACEMENTCODEUITEXCOORD2FVERTEX3FVSUNPROC) __GLeeGetProcAddress("glReplacementCodeuiTexCoord2fVertex3fvSUN"))!=0) nLinked++;
    if ((GLeeFuncPtr_glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN = (GLEEPFNGLREPLACEMENTCODEUITEXCOORD2FNORMAL3FVERTEX3FSUNPROC) __GLeeGetProcAddress("glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN"))!=0) nLinked++;
    if ((GLeeFuncPtr_glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN = (GLEEPFNGLREPLACEMENTCODEUITEXCOORD2FNORMAL3FVERTEX3FVSUNPROC) __GLeeGetProcAddress("glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN"))!=0) nLinked++;
    if ((GLeeFuncPtr_glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN = (GLEEPFNGLREPLACEMENTCODEUITEXCOORD2FCOLOR4FNORMAL3FVERTEX3FSUNPROC) __GLeeGetProcAddress("glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN"))!=0) nLinked++;
    if ((GLeeFuncPtr_glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN = (GLEEPFNGLREPLACEMENTCODEUITEXCOORD2FCOLOR4FNORMAL3FVERTEX3FVSUNPROC) __GLeeGetProcAddress("glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN"))!=0) nLinked++;
#endif
    if (nLinked==40) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_EXT_blend_func_separate(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_EXT_blend_func_separate
    if ((GLeeFuncPtr_glBlendFuncSeparateEXT = (GLEEPFNGLBLENDFUNCSEPARATEEXTPROC) __GLeeGetProcAddress("glBlendFuncSeparateEXT"))!=0) nLinked++;
#endif
    if (nLinked==1) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_INGR_color_clamp(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_INGR_interlace_read(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_EXT_stencil_wrap(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_EXT_422_pixels(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_NV_texgen_reflection(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_EXT_texture_cube_map(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_SUN_convolution_border_modes(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_EXT_texture_env_add(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_EXT_texture_lod_bias(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_EXT_texture_filter_anisotropic(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_EXT_vertex_weighting(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_EXT_vertex_weighting
    if ((GLeeFuncPtr_glVertexWeightfEXT = (GLEEPFNGLVERTEXWEIGHTFEXTPROC) __GLeeGetProcAddress("glVertexWeightfEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexWeightfvEXT = (GLEEPFNGLVERTEXWEIGHTFVEXTPROC) __GLeeGetProcAddress("glVertexWeightfvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexWeightPointerEXT = (GLEEPFNGLVERTEXWEIGHTPOINTEREXTPROC) __GLeeGetProcAddress("glVertexWeightPointerEXT"))!=0) nLinked++;
#endif
    if (nLinked==3) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_NV_light_max_exponent(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_NV_vertex_array_range(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_NV_vertex_array_range
    if ((GLeeFuncPtr_glFlushVertexArrayRangeNV = (GLEEPFNGLFLUSHVERTEXARRAYRANGENVPROC) __GLeeGetProcAddress("glFlushVertexArrayRangeNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexArrayRangeNV = (GLEEPFNGLVERTEXARRAYRANGENVPROC) __GLeeGetProcAddress("glVertexArrayRangeNV"))!=0) nLinked++;
#endif
    if (nLinked==2) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_NV_register_combiners(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_NV_register_combiners
    if ((GLeeFuncPtr_glCombinerParameterfvNV = (GLEEPFNGLCOMBINERPARAMETERFVNVPROC) __GLeeGetProcAddress("glCombinerParameterfvNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glCombinerParameterfNV = (GLEEPFNGLCOMBINERPARAMETERFNVPROC) __GLeeGetProcAddress("glCombinerParameterfNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glCombinerParameterivNV = (GLEEPFNGLCOMBINERPARAMETERIVNVPROC) __GLeeGetProcAddress("glCombinerParameterivNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glCombinerParameteriNV = (GLEEPFNGLCOMBINERPARAMETERINVPROC) __GLeeGetProcAddress("glCombinerParameteriNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glCombinerInputNV = (GLEEPFNGLCOMBINERINPUTNVPROC) __GLeeGetProcAddress("glCombinerInputNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glCombinerOutputNV = (GLEEPFNGLCOMBINEROUTPUTNVPROC) __GLeeGetProcAddress("glCombinerOutputNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFinalCombinerInputNV = (GLEEPFNGLFINALCOMBINERINPUTNVPROC) __GLeeGetProcAddress("glFinalCombinerInputNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetCombinerInputParameterfvNV = (GLEEPFNGLGETCOMBINERINPUTPARAMETERFVNVPROC) __GLeeGetProcAddress("glGetCombinerInputParameterfvNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetCombinerInputParameterivNV = (GLEEPFNGLGETCOMBINERINPUTPARAMETERIVNVPROC) __GLeeGetProcAddress("glGetCombinerInputParameterivNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetCombinerOutputParameterfvNV = (GLEEPFNGLGETCOMBINEROUTPUTPARAMETERFVNVPROC) __GLeeGetProcAddress("glGetCombinerOutputParameterfvNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetCombinerOutputParameterivNV = (GLEEPFNGLGETCOMBINEROUTPUTPARAMETERIVNVPROC) __GLeeGetProcAddress("glGetCombinerOutputParameterivNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetFinalCombinerInputParameterfvNV = (GLEEPFNGLGETFINALCOMBINERINPUTPARAMETERFVNVPROC) __GLeeGetProcAddress("glGetFinalCombinerInputParameterfvNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetFinalCombinerInputParameterivNV = (GLEEPFNGLGETFINALCOMBINERINPUTPARAMETERIVNVPROC) __GLeeGetProcAddress("glGetFinalCombinerInputParameterivNV"))!=0) nLinked++;
#endif
    if (nLinked==13) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_NV_fog_distance(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_NV_texgen_emboss(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_NV_blend_square(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_NV_texture_env_combine4(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_MESA_resize_buffers(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_MESA_resize_buffers
    if ((GLeeFuncPtr_glResizeBuffersMESA = (GLEEPFNGLRESIZEBUFFERSMESAPROC) __GLeeGetProcAddress("glResizeBuffersMESA"))!=0) nLinked++;
#endif
    if (nLinked==1) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_MESA_window_pos(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_MESA_window_pos
    if ((GLeeFuncPtr_glWindowPos2dMESA = (GLEEPFNGLWINDOWPOS2DMESAPROC) __GLeeGetProcAddress("glWindowPos2dMESA"))!=0) nLinked++;
    if ((GLeeFuncPtr_glWindowPos2dvMESA = (GLEEPFNGLWINDOWPOS2DVMESAPROC) __GLeeGetProcAddress("glWindowPos2dvMESA"))!=0) nLinked++;
    if ((GLeeFuncPtr_glWindowPos2fMESA = (GLEEPFNGLWINDOWPOS2FMESAPROC) __GLeeGetProcAddress("glWindowPos2fMESA"))!=0) nLinked++;
    if ((GLeeFuncPtr_glWindowPos2fvMESA = (GLEEPFNGLWINDOWPOS2FVMESAPROC) __GLeeGetProcAddress("glWindowPos2fvMESA"))!=0) nLinked++;
    if ((GLeeFuncPtr_glWindowPos2iMESA = (GLEEPFNGLWINDOWPOS2IMESAPROC) __GLeeGetProcAddress("glWindowPos2iMESA"))!=0) nLinked++;
    if ((GLeeFuncPtr_glWindowPos2ivMESA = (GLEEPFNGLWINDOWPOS2IVMESAPROC) __GLeeGetProcAddress("glWindowPos2ivMESA"))!=0) nLinked++;
    if ((GLeeFuncPtr_glWindowPos2sMESA = (GLEEPFNGLWINDOWPOS2SMESAPROC) __GLeeGetProcAddress("glWindowPos2sMESA"))!=0) nLinked++;
    if ((GLeeFuncPtr_glWindowPos2svMESA = (GLEEPFNGLWINDOWPOS2SVMESAPROC) __GLeeGetProcAddress("glWindowPos2svMESA"))!=0) nLinked++;
    if ((GLeeFuncPtr_glWindowPos3dMESA = (GLEEPFNGLWINDOWPOS3DMESAPROC) __GLeeGetProcAddress("glWindowPos3dMESA"))!=0) nLinked++;
    if ((GLeeFuncPtr_glWindowPos3dvMESA = (GLEEPFNGLWINDOWPOS3DVMESAPROC) __GLeeGetProcAddress("glWindowPos3dvMESA"))!=0) nLinked++;
    if ((GLeeFuncPtr_glWindowPos3fMESA = (GLEEPFNGLWINDOWPOS3FMESAPROC) __GLeeGetProcAddress("glWindowPos3fMESA"))!=0) nLinked++;
    if ((GLeeFuncPtr_glWindowPos3fvMESA = (GLEEPFNGLWINDOWPOS3FVMESAPROC) __GLeeGetProcAddress("glWindowPos3fvMESA"))!=0) nLinked++;
    if ((GLeeFuncPtr_glWindowPos3iMESA = (GLEEPFNGLWINDOWPOS3IMESAPROC) __GLeeGetProcAddress("glWindowPos3iMESA"))!=0) nLinked++;
    if ((GLeeFuncPtr_glWindowPos3ivMESA = (GLEEPFNGLWINDOWPOS3IVMESAPROC) __GLeeGetProcAddress("glWindowPos3ivMESA"))!=0) nLinked++;
    if ((GLeeFuncPtr_glWindowPos3sMESA = (GLEEPFNGLWINDOWPOS3SMESAPROC) __GLeeGetProcAddress("glWindowPos3sMESA"))!=0) nLinked++;
    if ((GLeeFuncPtr_glWindowPos3svMESA = (GLEEPFNGLWINDOWPOS3SVMESAPROC) __GLeeGetProcAddress("glWindowPos3svMESA"))!=0) nLinked++;
    if ((GLeeFuncPtr_glWindowPos4dMESA = (GLEEPFNGLWINDOWPOS4DMESAPROC) __GLeeGetProcAddress("glWindowPos4dMESA"))!=0) nLinked++;
    if ((GLeeFuncPtr_glWindowPos4dvMESA = (GLEEPFNGLWINDOWPOS4DVMESAPROC) __GLeeGetProcAddress("glWindowPos4dvMESA"))!=0) nLinked++;
    if ((GLeeFuncPtr_glWindowPos4fMESA = (GLEEPFNGLWINDOWPOS4FMESAPROC) __GLeeGetProcAddress("glWindowPos4fMESA"))!=0) nLinked++;
    if ((GLeeFuncPtr_glWindowPos4fvMESA = (GLEEPFNGLWINDOWPOS4FVMESAPROC) __GLeeGetProcAddress("glWindowPos4fvMESA"))!=0) nLinked++;
    if ((GLeeFuncPtr_glWindowPos4iMESA = (GLEEPFNGLWINDOWPOS4IMESAPROC) __GLeeGetProcAddress("glWindowPos4iMESA"))!=0) nLinked++;
    if ((GLeeFuncPtr_glWindowPos4ivMESA = (GLEEPFNGLWINDOWPOS4IVMESAPROC) __GLeeGetProcAddress("glWindowPos4ivMESA"))!=0) nLinked++;
    if ((GLeeFuncPtr_glWindowPos4sMESA = (GLEEPFNGLWINDOWPOS4SMESAPROC) __GLeeGetProcAddress("glWindowPos4sMESA"))!=0) nLinked++;
    if ((GLeeFuncPtr_glWindowPos4svMESA = (GLEEPFNGLWINDOWPOS4SVMESAPROC) __GLeeGetProcAddress("glWindowPos4svMESA"))!=0) nLinked++;
#endif
    if (nLinked==24) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_EXT_texture_compression_s3tc(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_IBM_cull_vertex(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_IBM_multimode_draw_arrays(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_IBM_multimode_draw_arrays
    if ((GLeeFuncPtr_glMultiModeDrawArraysIBM = (GLEEPFNGLMULTIMODEDRAWARRAYSIBMPROC) __GLeeGetProcAddress("glMultiModeDrawArraysIBM"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiModeDrawElementsIBM = (GLEEPFNGLMULTIMODEDRAWELEMENTSIBMPROC) __GLeeGetProcAddress("glMultiModeDrawElementsIBM"))!=0) nLinked++;
#endif
    if (nLinked==2) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_IBM_vertex_array_lists(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_IBM_vertex_array_lists
    if ((GLeeFuncPtr_glColorPointerListIBM = (GLEEPFNGLCOLORPOINTERLISTIBMPROC) __GLeeGetProcAddress("glColorPointerListIBM"))!=0) nLinked++;
    if ((GLeeFuncPtr_glSecondaryColorPointerListIBM = (GLEEPFNGLSECONDARYCOLORPOINTERLISTIBMPROC) __GLeeGetProcAddress("glSecondaryColorPointerListIBM"))!=0) nLinked++;
    if ((GLeeFuncPtr_glEdgeFlagPointerListIBM = (GLEEPFNGLEDGEFLAGPOINTERLISTIBMPROC) __GLeeGetProcAddress("glEdgeFlagPointerListIBM"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFogCoordPointerListIBM = (GLEEPFNGLFOGCOORDPOINTERLISTIBMPROC) __GLeeGetProcAddress("glFogCoordPointerListIBM"))!=0) nLinked++;
    if ((GLeeFuncPtr_glIndexPointerListIBM = (GLEEPFNGLINDEXPOINTERLISTIBMPROC) __GLeeGetProcAddress("glIndexPointerListIBM"))!=0) nLinked++;
    if ((GLeeFuncPtr_glNormalPointerListIBM = (GLEEPFNGLNORMALPOINTERLISTIBMPROC) __GLeeGetProcAddress("glNormalPointerListIBM"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTexCoordPointerListIBM = (GLEEPFNGLTEXCOORDPOINTERLISTIBMPROC) __GLeeGetProcAddress("glTexCoordPointerListIBM"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexPointerListIBM = (GLEEPFNGLVERTEXPOINTERLISTIBMPROC) __GLeeGetProcAddress("glVertexPointerListIBM"))!=0) nLinked++;
#endif
    if (nLinked==8) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_SGIX_subsample(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_SGIX_ycrcb_subsample(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_SGIX_ycrcba(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_SGI_depth_pass_instrument(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_3DFX_texture_compression_FXT1(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_3DFX_multisample(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_3DFX_tbuffer(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_3DFX_tbuffer
    if ((GLeeFuncPtr_glTbufferMask3DFX = (GLEEPFNGLTBUFFERMASK3DFXPROC) __GLeeGetProcAddress("glTbufferMask3DFX"))!=0) nLinked++;
#endif
    if (nLinked==1) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_EXT_multisample(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_EXT_multisample
    if ((GLeeFuncPtr_glSampleMaskEXT = (GLEEPFNGLSAMPLEMASKEXTPROC) __GLeeGetProcAddress("glSampleMaskEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glSamplePatternEXT = (GLEEPFNGLSAMPLEPATTERNEXTPROC) __GLeeGetProcAddress("glSamplePatternEXT"))!=0) nLinked++;
#endif
    if (nLinked==2) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_SGIX_vertex_preclip(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_SGIX_convolution_accuracy(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_SGIX_resample(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_SGIS_point_line_texgen(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_SGIS_texture_color_mask(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_SGIS_texture_color_mask
    if ((GLeeFuncPtr_glTextureColorMaskSGIS = (GLEEPFNGLTEXTURECOLORMASKSGISPROC) __GLeeGetProcAddress("glTextureColorMaskSGIS"))!=0) nLinked++;
#endif
    if (nLinked==1) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_EXT_texture_env_dot3(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_ATI_texture_mirror_once(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_NV_fence(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_NV_fence
    if ((GLeeFuncPtr_glDeleteFencesNV = (GLEEPFNGLDELETEFENCESNVPROC) __GLeeGetProcAddress("glDeleteFencesNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGenFencesNV = (GLEEPFNGLGENFENCESNVPROC) __GLeeGetProcAddress("glGenFencesNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glIsFenceNV = (GLEEPFNGLISFENCENVPROC) __GLeeGetProcAddress("glIsFenceNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTestFenceNV = (GLEEPFNGLTESTFENCENVPROC) __GLeeGetProcAddress("glTestFenceNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetFenceivNV = (GLEEPFNGLGETFENCEIVNVPROC) __GLeeGetProcAddress("glGetFenceivNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFinishFenceNV = (GLEEPFNGLFINISHFENCENVPROC) __GLeeGetProcAddress("glFinishFenceNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glSetFenceNV = (GLEEPFNGLSETFENCENVPROC) __GLeeGetProcAddress("glSetFenceNV"))!=0) nLinked++;
#endif
    if (nLinked==7) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_IBM_texture_mirrored_repeat(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_NV_evaluators(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_NV_evaluators
    if ((GLeeFuncPtr_glMapControlPointsNV = (GLEEPFNGLMAPCONTROLPOINTSNVPROC) __GLeeGetProcAddress("glMapControlPointsNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMapParameterivNV = (GLEEPFNGLMAPPARAMETERIVNVPROC) __GLeeGetProcAddress("glMapParameterivNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMapParameterfvNV = (GLEEPFNGLMAPPARAMETERFVNVPROC) __GLeeGetProcAddress("glMapParameterfvNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetMapControlPointsNV = (GLEEPFNGLGETMAPCONTROLPOINTSNVPROC) __GLeeGetProcAddress("glGetMapControlPointsNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetMapParameterivNV = (GLEEPFNGLGETMAPPARAMETERIVNVPROC) __GLeeGetProcAddress("glGetMapParameterivNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetMapParameterfvNV = (GLEEPFNGLGETMAPPARAMETERFVNVPROC) __GLeeGetProcAddress("glGetMapParameterfvNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetMapAttribParameterivNV = (GLEEPFNGLGETMAPATTRIBPARAMETERIVNVPROC) __GLeeGetProcAddress("glGetMapAttribParameterivNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetMapAttribParameterfvNV = (GLEEPFNGLGETMAPATTRIBPARAMETERFVNVPROC) __GLeeGetProcAddress("glGetMapAttribParameterfvNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glEvalMapsNV = (GLEEPFNGLEVALMAPSNVPROC) __GLeeGetProcAddress("glEvalMapsNV"))!=0) nLinked++;
#endif
    if (nLinked==9) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_NV_packed_depth_stencil(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_NV_register_combiners2(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_NV_register_combiners2
    if ((GLeeFuncPtr_glCombinerStageParameterfvNV = (GLEEPFNGLCOMBINERSTAGEPARAMETERFVNVPROC) __GLeeGetProcAddress("glCombinerStageParameterfvNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetCombinerStageParameterfvNV = (GLEEPFNGLGETCOMBINERSTAGEPARAMETERFVNVPROC) __GLeeGetProcAddress("glGetCombinerStageParameterfvNV"))!=0) nLinked++;
#endif
    if (nLinked==2) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_NV_texture_compression_vtc(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_NV_texture_rectangle(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_NV_texture_shader(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_NV_texture_shader2(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_NV_vertex_array_range2(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_NV_vertex_program(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_NV_vertex_program
    if ((GLeeFuncPtr_glAreProgramsResidentNV = (GLEEPFNGLAREPROGRAMSRESIDENTNVPROC) __GLeeGetProcAddress("glAreProgramsResidentNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glBindProgramNV = (GLEEPFNGLBINDPROGRAMNVPROC) __GLeeGetProcAddress("glBindProgramNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glDeleteProgramsNV = (GLEEPFNGLDELETEPROGRAMSNVPROC) __GLeeGetProcAddress("glDeleteProgramsNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glExecuteProgramNV = (GLEEPFNGLEXECUTEPROGRAMNVPROC) __GLeeGetProcAddress("glExecuteProgramNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGenProgramsNV = (GLEEPFNGLGENPROGRAMSNVPROC) __GLeeGetProcAddress("glGenProgramsNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetProgramParameterdvNV = (GLEEPFNGLGETPROGRAMPARAMETERDVNVPROC) __GLeeGetProcAddress("glGetProgramParameterdvNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetProgramParameterfvNV = (GLEEPFNGLGETPROGRAMPARAMETERFVNVPROC) __GLeeGetProcAddress("glGetProgramParameterfvNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetProgramivNV = (GLEEPFNGLGETPROGRAMIVNVPROC) __GLeeGetProcAddress("glGetProgramivNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetProgramStringNV = (GLEEPFNGLGETPROGRAMSTRINGNVPROC) __GLeeGetProcAddress("glGetProgramStringNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetTrackMatrixivNV = (GLEEPFNGLGETTRACKMATRIXIVNVPROC) __GLeeGetProcAddress("glGetTrackMatrixivNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetVertexAttribdvNV = (GLEEPFNGLGETVERTEXATTRIBDVNVPROC) __GLeeGetProcAddress("glGetVertexAttribdvNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetVertexAttribfvNV = (GLEEPFNGLGETVERTEXATTRIBFVNVPROC) __GLeeGetProcAddress("glGetVertexAttribfvNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetVertexAttribivNV = (GLEEPFNGLGETVERTEXATTRIBIVNVPROC) __GLeeGetProcAddress("glGetVertexAttribivNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetVertexAttribPointervNV = (GLEEPFNGLGETVERTEXATTRIBPOINTERVNVPROC) __GLeeGetProcAddress("glGetVertexAttribPointervNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glIsProgramNV = (GLEEPFNGLISPROGRAMNVPROC) __GLeeGetProcAddress("glIsProgramNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glLoadProgramNV = (GLEEPFNGLLOADPROGRAMNVPROC) __GLeeGetProcAddress("glLoadProgramNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramParameter4dNV = (GLEEPFNGLPROGRAMPARAMETER4DNVPROC) __GLeeGetProcAddress("glProgramParameter4dNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramParameter4dvNV = (GLEEPFNGLPROGRAMPARAMETER4DVNVPROC) __GLeeGetProcAddress("glProgramParameter4dvNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramParameter4fNV = (GLEEPFNGLPROGRAMPARAMETER4FNVPROC) __GLeeGetProcAddress("glProgramParameter4fNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramParameter4fvNV = (GLEEPFNGLPROGRAMPARAMETER4FVNVPROC) __GLeeGetProcAddress("glProgramParameter4fvNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramParameters4dvNV = (GLEEPFNGLPROGRAMPARAMETERS4DVNVPROC) __GLeeGetProcAddress("glProgramParameters4dvNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramParameters4fvNV = (GLEEPFNGLPROGRAMPARAMETERS4FVNVPROC) __GLeeGetProcAddress("glProgramParameters4fvNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glRequestResidentProgramsNV = (GLEEPFNGLREQUESTRESIDENTPROGRAMSNVPROC) __GLeeGetProcAddress("glRequestResidentProgramsNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTrackMatrixNV = (GLEEPFNGLTRACKMATRIXNVPROC) __GLeeGetProcAddress("glTrackMatrixNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttribPointerNV = (GLEEPFNGLVERTEXATTRIBPOINTERNVPROC) __GLeeGetProcAddress("glVertexAttribPointerNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib1dNV = (GLEEPFNGLVERTEXATTRIB1DNVPROC) __GLeeGetProcAddress("glVertexAttrib1dNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib1dvNV = (GLEEPFNGLVERTEXATTRIB1DVNVPROC) __GLeeGetProcAddress("glVertexAttrib1dvNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib1fNV = (GLEEPFNGLVERTEXATTRIB1FNVPROC) __GLeeGetProcAddress("glVertexAttrib1fNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib1fvNV = (GLEEPFNGLVERTEXATTRIB1FVNVPROC) __GLeeGetProcAddress("glVertexAttrib1fvNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib1sNV = (GLEEPFNGLVERTEXATTRIB1SNVPROC) __GLeeGetProcAddress("glVertexAttrib1sNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib1svNV = (GLEEPFNGLVERTEXATTRIB1SVNVPROC) __GLeeGetProcAddress("glVertexAttrib1svNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib2dNV = (GLEEPFNGLVERTEXATTRIB2DNVPROC) __GLeeGetProcAddress("glVertexAttrib2dNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib2dvNV = (GLEEPFNGLVERTEXATTRIB2DVNVPROC) __GLeeGetProcAddress("glVertexAttrib2dvNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib2fNV = (GLEEPFNGLVERTEXATTRIB2FNVPROC) __GLeeGetProcAddress("glVertexAttrib2fNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib2fvNV = (GLEEPFNGLVERTEXATTRIB2FVNVPROC) __GLeeGetProcAddress("glVertexAttrib2fvNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib2sNV = (GLEEPFNGLVERTEXATTRIB2SNVPROC) __GLeeGetProcAddress("glVertexAttrib2sNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib2svNV = (GLEEPFNGLVERTEXATTRIB2SVNVPROC) __GLeeGetProcAddress("glVertexAttrib2svNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib3dNV = (GLEEPFNGLVERTEXATTRIB3DNVPROC) __GLeeGetProcAddress("glVertexAttrib3dNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib3dvNV = (GLEEPFNGLVERTEXATTRIB3DVNVPROC) __GLeeGetProcAddress("glVertexAttrib3dvNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib3fNV = (GLEEPFNGLVERTEXATTRIB3FNVPROC) __GLeeGetProcAddress("glVertexAttrib3fNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib3fvNV = (GLEEPFNGLVERTEXATTRIB3FVNVPROC) __GLeeGetProcAddress("glVertexAttrib3fvNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib3sNV = (GLEEPFNGLVERTEXATTRIB3SNVPROC) __GLeeGetProcAddress("glVertexAttrib3sNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib3svNV = (GLEEPFNGLVERTEXATTRIB3SVNVPROC) __GLeeGetProcAddress("glVertexAttrib3svNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib4dNV = (GLEEPFNGLVERTEXATTRIB4DNVPROC) __GLeeGetProcAddress("glVertexAttrib4dNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib4dvNV = (GLEEPFNGLVERTEXATTRIB4DVNVPROC) __GLeeGetProcAddress("glVertexAttrib4dvNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib4fNV = (GLEEPFNGLVERTEXATTRIB4FNVPROC) __GLeeGetProcAddress("glVertexAttrib4fNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib4fvNV = (GLEEPFNGLVERTEXATTRIB4FVNVPROC) __GLeeGetProcAddress("glVertexAttrib4fvNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib4sNV = (GLEEPFNGLVERTEXATTRIB4SNVPROC) __GLeeGetProcAddress("glVertexAttrib4sNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib4svNV = (GLEEPFNGLVERTEXATTRIB4SVNVPROC) __GLeeGetProcAddress("glVertexAttrib4svNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib4ubNV = (GLEEPFNGLVERTEXATTRIB4UBNVPROC) __GLeeGetProcAddress("glVertexAttrib4ubNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib4ubvNV = (GLEEPFNGLVERTEXATTRIB4UBVNVPROC) __GLeeGetProcAddress("glVertexAttrib4ubvNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttribs1dvNV = (GLEEPFNGLVERTEXATTRIBS1DVNVPROC) __GLeeGetProcAddress("glVertexAttribs1dvNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttribs1fvNV = (GLEEPFNGLVERTEXATTRIBS1FVNVPROC) __GLeeGetProcAddress("glVertexAttribs1fvNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttribs1svNV = (GLEEPFNGLVERTEXATTRIBS1SVNVPROC) __GLeeGetProcAddress("glVertexAttribs1svNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttribs2dvNV = (GLEEPFNGLVERTEXATTRIBS2DVNVPROC) __GLeeGetProcAddress("glVertexAttribs2dvNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttribs2fvNV = (GLEEPFNGLVERTEXATTRIBS2FVNVPROC) __GLeeGetProcAddress("glVertexAttribs2fvNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttribs2svNV = (GLEEPFNGLVERTEXATTRIBS2SVNVPROC) __GLeeGetProcAddress("glVertexAttribs2svNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttribs3dvNV = (GLEEPFNGLVERTEXATTRIBS3DVNVPROC) __GLeeGetProcAddress("glVertexAttribs3dvNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttribs3fvNV = (GLEEPFNGLVERTEXATTRIBS3FVNVPROC) __GLeeGetProcAddress("glVertexAttribs3fvNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttribs3svNV = (GLEEPFNGLVERTEXATTRIBS3SVNVPROC) __GLeeGetProcAddress("glVertexAttribs3svNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttribs4dvNV = (GLEEPFNGLVERTEXATTRIBS4DVNVPROC) __GLeeGetProcAddress("glVertexAttribs4dvNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttribs4fvNV = (GLEEPFNGLVERTEXATTRIBS4FVNVPROC) __GLeeGetProcAddress("glVertexAttribs4fvNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttribs4svNV = (GLEEPFNGLVERTEXATTRIBS4SVNVPROC) __GLeeGetProcAddress("glVertexAttribs4svNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttribs4ubvNV = (GLEEPFNGLVERTEXATTRIBS4UBVNVPROC) __GLeeGetProcAddress("glVertexAttribs4ubvNV"))!=0) nLinked++;
#endif
    if (nLinked==64) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_SGIX_texture_coordinate_clamp(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_SGIX_scalebias_hint(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_OML_interlace(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_OML_subsample(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_OML_resample(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_NV_copy_depth_to_color(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_ATI_envmap_bumpmap(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_ATI_envmap_bumpmap
    if ((GLeeFuncPtr_glTexBumpParameterivATI = (GLEEPFNGLTEXBUMPPARAMETERIVATIPROC) __GLeeGetProcAddress("glTexBumpParameterivATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTexBumpParameterfvATI = (GLEEPFNGLTEXBUMPPARAMETERFVATIPROC) __GLeeGetProcAddress("glTexBumpParameterfvATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetTexBumpParameterivATI = (GLEEPFNGLGETTEXBUMPPARAMETERIVATIPROC) __GLeeGetProcAddress("glGetTexBumpParameterivATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetTexBumpParameterfvATI = (GLEEPFNGLGETTEXBUMPPARAMETERFVATIPROC) __GLeeGetProcAddress("glGetTexBumpParameterfvATI"))!=0) nLinked++;
#endif
    if (nLinked==4) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_ATI_fragment_shader(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_ATI_fragment_shader
    if ((GLeeFuncPtr_glGenFragmentShadersATI = (GLEEPFNGLGENFRAGMENTSHADERSATIPROC) __GLeeGetProcAddress("glGenFragmentShadersATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glBindFragmentShaderATI = (GLEEPFNGLBINDFRAGMENTSHADERATIPROC) __GLeeGetProcAddress("glBindFragmentShaderATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glDeleteFragmentShaderATI = (GLEEPFNGLDELETEFRAGMENTSHADERATIPROC) __GLeeGetProcAddress("glDeleteFragmentShaderATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glBeginFragmentShaderATI = (GLEEPFNGLBEGINFRAGMENTSHADERATIPROC) __GLeeGetProcAddress("glBeginFragmentShaderATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glEndFragmentShaderATI = (GLEEPFNGLENDFRAGMENTSHADERATIPROC) __GLeeGetProcAddress("glEndFragmentShaderATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glPassTexCoordATI = (GLEEPFNGLPASSTEXCOORDATIPROC) __GLeeGetProcAddress("glPassTexCoordATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glSampleMapATI = (GLEEPFNGLSAMPLEMAPATIPROC) __GLeeGetProcAddress("glSampleMapATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glColorFragmentOp1ATI = (GLEEPFNGLCOLORFRAGMENTOP1ATIPROC) __GLeeGetProcAddress("glColorFragmentOp1ATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glColorFragmentOp2ATI = (GLEEPFNGLCOLORFRAGMENTOP2ATIPROC) __GLeeGetProcAddress("glColorFragmentOp2ATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glColorFragmentOp3ATI = (GLEEPFNGLCOLORFRAGMENTOP3ATIPROC) __GLeeGetProcAddress("glColorFragmentOp3ATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glAlphaFragmentOp1ATI = (GLEEPFNGLALPHAFRAGMENTOP1ATIPROC) __GLeeGetProcAddress("glAlphaFragmentOp1ATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glAlphaFragmentOp2ATI = (GLEEPFNGLALPHAFRAGMENTOP2ATIPROC) __GLeeGetProcAddress("glAlphaFragmentOp2ATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glAlphaFragmentOp3ATI = (GLEEPFNGLALPHAFRAGMENTOP3ATIPROC) __GLeeGetProcAddress("glAlphaFragmentOp3ATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glSetFragmentShaderConstantATI = (GLEEPFNGLSETFRAGMENTSHADERCONSTANTATIPROC) __GLeeGetProcAddress("glSetFragmentShaderConstantATI"))!=0) nLinked++;
#endif
    if (nLinked==14) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_ATI_pn_triangles(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_ATI_pn_triangles
    if ((GLeeFuncPtr_glPNTrianglesiATI = (GLEEPFNGLPNTRIANGLESIATIPROC) __GLeeGetProcAddress("glPNTrianglesiATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glPNTrianglesfATI = (GLEEPFNGLPNTRIANGLESFATIPROC) __GLeeGetProcAddress("glPNTrianglesfATI"))!=0) nLinked++;
#endif
    if (nLinked==2) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_ATI_vertex_array_object(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_ATI_vertex_array_object
    if ((GLeeFuncPtr_glNewObjectBufferATI = (GLEEPFNGLNEWOBJECTBUFFERATIPROC) __GLeeGetProcAddress("glNewObjectBufferATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glIsObjectBufferATI = (GLEEPFNGLISOBJECTBUFFERATIPROC) __GLeeGetProcAddress("glIsObjectBufferATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUpdateObjectBufferATI = (GLEEPFNGLUPDATEOBJECTBUFFERATIPROC) __GLeeGetProcAddress("glUpdateObjectBufferATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetObjectBufferfvATI = (GLEEPFNGLGETOBJECTBUFFERFVATIPROC) __GLeeGetProcAddress("glGetObjectBufferfvATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetObjectBufferivATI = (GLEEPFNGLGETOBJECTBUFFERIVATIPROC) __GLeeGetProcAddress("glGetObjectBufferivATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFreeObjectBufferATI = (GLEEPFNGLFREEOBJECTBUFFERATIPROC) __GLeeGetProcAddress("glFreeObjectBufferATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glArrayObjectATI = (GLEEPFNGLARRAYOBJECTATIPROC) __GLeeGetProcAddress("glArrayObjectATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetArrayObjectfvATI = (GLEEPFNGLGETARRAYOBJECTFVATIPROC) __GLeeGetProcAddress("glGetArrayObjectfvATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetArrayObjectivATI = (GLEEPFNGLGETARRAYOBJECTIVATIPROC) __GLeeGetProcAddress("glGetArrayObjectivATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVariantArrayObjectATI = (GLEEPFNGLVARIANTARRAYOBJECTATIPROC) __GLeeGetProcAddress("glVariantArrayObjectATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetVariantArrayObjectfvATI = (GLEEPFNGLGETVARIANTARRAYOBJECTFVATIPROC) __GLeeGetProcAddress("glGetVariantArrayObjectfvATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetVariantArrayObjectivATI = (GLEEPFNGLGETVARIANTARRAYOBJECTIVATIPROC) __GLeeGetProcAddress("glGetVariantArrayObjectivATI"))!=0) nLinked++;
#endif
    if (nLinked==12) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_EXT_vertex_shader(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_EXT_vertex_shader
    if ((GLeeFuncPtr_glBeginVertexShaderEXT = (GLEEPFNGLBEGINVERTEXSHADEREXTPROC) __GLeeGetProcAddress("glBeginVertexShaderEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glEndVertexShaderEXT = (GLEEPFNGLENDVERTEXSHADEREXTPROC) __GLeeGetProcAddress("glEndVertexShaderEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glBindVertexShaderEXT = (GLEEPFNGLBINDVERTEXSHADEREXTPROC) __GLeeGetProcAddress("glBindVertexShaderEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGenVertexShadersEXT = (GLEEPFNGLGENVERTEXSHADERSEXTPROC) __GLeeGetProcAddress("glGenVertexShadersEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glDeleteVertexShaderEXT = (GLEEPFNGLDELETEVERTEXSHADEREXTPROC) __GLeeGetProcAddress("glDeleteVertexShaderEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glShaderOp1EXT = (GLEEPFNGLSHADEROP1EXTPROC) __GLeeGetProcAddress("glShaderOp1EXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glShaderOp2EXT = (GLEEPFNGLSHADEROP2EXTPROC) __GLeeGetProcAddress("glShaderOp2EXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glShaderOp3EXT = (GLEEPFNGLSHADEROP3EXTPROC) __GLeeGetProcAddress("glShaderOp3EXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glSwizzleEXT = (GLEEPFNGLSWIZZLEEXTPROC) __GLeeGetProcAddress("glSwizzleEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glWriteMaskEXT = (GLEEPFNGLWRITEMASKEXTPROC) __GLeeGetProcAddress("glWriteMaskEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glInsertComponentEXT = (GLEEPFNGLINSERTCOMPONENTEXTPROC) __GLeeGetProcAddress("glInsertComponentEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glExtractComponentEXT = (GLEEPFNGLEXTRACTCOMPONENTEXTPROC) __GLeeGetProcAddress("glExtractComponentEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGenSymbolsEXT = (GLEEPFNGLGENSYMBOLSEXTPROC) __GLeeGetProcAddress("glGenSymbolsEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glSetInvariantEXT = (GLEEPFNGLSETINVARIANTEXTPROC) __GLeeGetProcAddress("glSetInvariantEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glSetLocalConstantEXT = (GLEEPFNGLSETLOCALCONSTANTEXTPROC) __GLeeGetProcAddress("glSetLocalConstantEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVariantbvEXT = (GLEEPFNGLVARIANTBVEXTPROC) __GLeeGetProcAddress("glVariantbvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVariantsvEXT = (GLEEPFNGLVARIANTSVEXTPROC) __GLeeGetProcAddress("glVariantsvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVariantivEXT = (GLEEPFNGLVARIANTIVEXTPROC) __GLeeGetProcAddress("glVariantivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVariantfvEXT = (GLEEPFNGLVARIANTFVEXTPROC) __GLeeGetProcAddress("glVariantfvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVariantdvEXT = (GLEEPFNGLVARIANTDVEXTPROC) __GLeeGetProcAddress("glVariantdvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVariantubvEXT = (GLEEPFNGLVARIANTUBVEXTPROC) __GLeeGetProcAddress("glVariantubvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVariantusvEXT = (GLEEPFNGLVARIANTUSVEXTPROC) __GLeeGetProcAddress("glVariantusvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVariantuivEXT = (GLEEPFNGLVARIANTUIVEXTPROC) __GLeeGetProcAddress("glVariantuivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVariantPointerEXT = (GLEEPFNGLVARIANTPOINTEREXTPROC) __GLeeGetProcAddress("glVariantPointerEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glEnableVariantClientStateEXT = (GLEEPFNGLENABLEVARIANTCLIENTSTATEEXTPROC) __GLeeGetProcAddress("glEnableVariantClientStateEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glDisableVariantClientStateEXT = (GLEEPFNGLDISABLEVARIANTCLIENTSTATEEXTPROC) __GLeeGetProcAddress("glDisableVariantClientStateEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glBindLightParameterEXT = (GLEEPFNGLBINDLIGHTPARAMETEREXTPROC) __GLeeGetProcAddress("glBindLightParameterEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glBindMaterialParameterEXT = (GLEEPFNGLBINDMATERIALPARAMETEREXTPROC) __GLeeGetProcAddress("glBindMaterialParameterEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glBindTexGenParameterEXT = (GLEEPFNGLBINDTEXGENPARAMETEREXTPROC) __GLeeGetProcAddress("glBindTexGenParameterEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glBindTextureUnitParameterEXT = (GLEEPFNGLBINDTEXTUREUNITPARAMETEREXTPROC) __GLeeGetProcAddress("glBindTextureUnitParameterEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glBindParameterEXT = (GLEEPFNGLBINDPARAMETEREXTPROC) __GLeeGetProcAddress("glBindParameterEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glIsVariantEnabledEXT = (GLEEPFNGLISVARIANTENABLEDEXTPROC) __GLeeGetProcAddress("glIsVariantEnabledEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetVariantBooleanvEXT = (GLEEPFNGLGETVARIANTBOOLEANVEXTPROC) __GLeeGetProcAddress("glGetVariantBooleanvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetVariantIntegervEXT = (GLEEPFNGLGETVARIANTINTEGERVEXTPROC) __GLeeGetProcAddress("glGetVariantIntegervEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetVariantFloatvEXT = (GLEEPFNGLGETVARIANTFLOATVEXTPROC) __GLeeGetProcAddress("glGetVariantFloatvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetVariantPointervEXT = (GLEEPFNGLGETVARIANTPOINTERVEXTPROC) __GLeeGetProcAddress("glGetVariantPointervEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetInvariantBooleanvEXT = (GLEEPFNGLGETINVARIANTBOOLEANVEXTPROC) __GLeeGetProcAddress("glGetInvariantBooleanvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetInvariantIntegervEXT = (GLEEPFNGLGETINVARIANTINTEGERVEXTPROC) __GLeeGetProcAddress("glGetInvariantIntegervEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetInvariantFloatvEXT = (GLEEPFNGLGETINVARIANTFLOATVEXTPROC) __GLeeGetProcAddress("glGetInvariantFloatvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetLocalConstantBooleanvEXT = (GLEEPFNGLGETLOCALCONSTANTBOOLEANVEXTPROC) __GLeeGetProcAddress("glGetLocalConstantBooleanvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetLocalConstantIntegervEXT = (GLEEPFNGLGETLOCALCONSTANTINTEGERVEXTPROC) __GLeeGetProcAddress("glGetLocalConstantIntegervEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetLocalConstantFloatvEXT = (GLEEPFNGLGETLOCALCONSTANTFLOATVEXTPROC) __GLeeGetProcAddress("glGetLocalConstantFloatvEXT"))!=0) nLinked++;
#endif
    if (nLinked==42) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_ATI_vertex_streams(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_ATI_vertex_streams
    if ((GLeeFuncPtr_glVertexStream1sATI = (GLEEPFNGLVERTEXSTREAM1SATIPROC) __GLeeGetProcAddress("glVertexStream1sATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexStream1svATI = (GLEEPFNGLVERTEXSTREAM1SVATIPROC) __GLeeGetProcAddress("glVertexStream1svATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexStream1iATI = (GLEEPFNGLVERTEXSTREAM1IATIPROC) __GLeeGetProcAddress("glVertexStream1iATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexStream1ivATI = (GLEEPFNGLVERTEXSTREAM1IVATIPROC) __GLeeGetProcAddress("glVertexStream1ivATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexStream1fATI = (GLEEPFNGLVERTEXSTREAM1FATIPROC) __GLeeGetProcAddress("glVertexStream1fATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexStream1fvATI = (GLEEPFNGLVERTEXSTREAM1FVATIPROC) __GLeeGetProcAddress("glVertexStream1fvATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexStream1dATI = (GLEEPFNGLVERTEXSTREAM1DATIPROC) __GLeeGetProcAddress("glVertexStream1dATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexStream1dvATI = (GLEEPFNGLVERTEXSTREAM1DVATIPROC) __GLeeGetProcAddress("glVertexStream1dvATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexStream2sATI = (GLEEPFNGLVERTEXSTREAM2SATIPROC) __GLeeGetProcAddress("glVertexStream2sATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexStream2svATI = (GLEEPFNGLVERTEXSTREAM2SVATIPROC) __GLeeGetProcAddress("glVertexStream2svATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexStream2iATI = (GLEEPFNGLVERTEXSTREAM2IATIPROC) __GLeeGetProcAddress("glVertexStream2iATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexStream2ivATI = (GLEEPFNGLVERTEXSTREAM2IVATIPROC) __GLeeGetProcAddress("glVertexStream2ivATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexStream2fATI = (GLEEPFNGLVERTEXSTREAM2FATIPROC) __GLeeGetProcAddress("glVertexStream2fATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexStream2fvATI = (GLEEPFNGLVERTEXSTREAM2FVATIPROC) __GLeeGetProcAddress("glVertexStream2fvATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexStream2dATI = (GLEEPFNGLVERTEXSTREAM2DATIPROC) __GLeeGetProcAddress("glVertexStream2dATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexStream2dvATI = (GLEEPFNGLVERTEXSTREAM2DVATIPROC) __GLeeGetProcAddress("glVertexStream2dvATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexStream3sATI = (GLEEPFNGLVERTEXSTREAM3SATIPROC) __GLeeGetProcAddress("glVertexStream3sATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexStream3svATI = (GLEEPFNGLVERTEXSTREAM3SVATIPROC) __GLeeGetProcAddress("glVertexStream3svATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexStream3iATI = (GLEEPFNGLVERTEXSTREAM3IATIPROC) __GLeeGetProcAddress("glVertexStream3iATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexStream3ivATI = (GLEEPFNGLVERTEXSTREAM3IVATIPROC) __GLeeGetProcAddress("glVertexStream3ivATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexStream3fATI = (GLEEPFNGLVERTEXSTREAM3FATIPROC) __GLeeGetProcAddress("glVertexStream3fATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexStream3fvATI = (GLEEPFNGLVERTEXSTREAM3FVATIPROC) __GLeeGetProcAddress("glVertexStream3fvATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexStream3dATI = (GLEEPFNGLVERTEXSTREAM3DATIPROC) __GLeeGetProcAddress("glVertexStream3dATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexStream3dvATI = (GLEEPFNGLVERTEXSTREAM3DVATIPROC) __GLeeGetProcAddress("glVertexStream3dvATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexStream4sATI = (GLEEPFNGLVERTEXSTREAM4SATIPROC) __GLeeGetProcAddress("glVertexStream4sATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexStream4svATI = (GLEEPFNGLVERTEXSTREAM4SVATIPROC) __GLeeGetProcAddress("glVertexStream4svATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexStream4iATI = (GLEEPFNGLVERTEXSTREAM4IATIPROC) __GLeeGetProcAddress("glVertexStream4iATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexStream4ivATI = (GLEEPFNGLVERTEXSTREAM4IVATIPROC) __GLeeGetProcAddress("glVertexStream4ivATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexStream4fATI = (GLEEPFNGLVERTEXSTREAM4FATIPROC) __GLeeGetProcAddress("glVertexStream4fATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexStream4fvATI = (GLEEPFNGLVERTEXSTREAM4FVATIPROC) __GLeeGetProcAddress("glVertexStream4fvATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexStream4dATI = (GLEEPFNGLVERTEXSTREAM4DATIPROC) __GLeeGetProcAddress("glVertexStream4dATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexStream4dvATI = (GLEEPFNGLVERTEXSTREAM4DVATIPROC) __GLeeGetProcAddress("glVertexStream4dvATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glNormalStream3bATI = (GLEEPFNGLNORMALSTREAM3BATIPROC) __GLeeGetProcAddress("glNormalStream3bATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glNormalStream3bvATI = (GLEEPFNGLNORMALSTREAM3BVATIPROC) __GLeeGetProcAddress("glNormalStream3bvATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glNormalStream3sATI = (GLEEPFNGLNORMALSTREAM3SATIPROC) __GLeeGetProcAddress("glNormalStream3sATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glNormalStream3svATI = (GLEEPFNGLNORMALSTREAM3SVATIPROC) __GLeeGetProcAddress("glNormalStream3svATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glNormalStream3iATI = (GLEEPFNGLNORMALSTREAM3IATIPROC) __GLeeGetProcAddress("glNormalStream3iATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glNormalStream3ivATI = (GLEEPFNGLNORMALSTREAM3IVATIPROC) __GLeeGetProcAddress("glNormalStream3ivATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glNormalStream3fATI = (GLEEPFNGLNORMALSTREAM3FATIPROC) __GLeeGetProcAddress("glNormalStream3fATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glNormalStream3fvATI = (GLEEPFNGLNORMALSTREAM3FVATIPROC) __GLeeGetProcAddress("glNormalStream3fvATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glNormalStream3dATI = (GLEEPFNGLNORMALSTREAM3DATIPROC) __GLeeGetProcAddress("glNormalStream3dATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glNormalStream3dvATI = (GLEEPFNGLNORMALSTREAM3DVATIPROC) __GLeeGetProcAddress("glNormalStream3dvATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glClientActiveVertexStreamATI = (GLEEPFNGLCLIENTACTIVEVERTEXSTREAMATIPROC) __GLeeGetProcAddress("glClientActiveVertexStreamATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexBlendEnviATI = (GLEEPFNGLVERTEXBLENDENVIATIPROC) __GLeeGetProcAddress("glVertexBlendEnviATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexBlendEnvfATI = (GLEEPFNGLVERTEXBLENDENVFATIPROC) __GLeeGetProcAddress("glVertexBlendEnvfATI"))!=0) nLinked++;
#endif
    if (nLinked==45) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_ATI_element_array(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_ATI_element_array
    if ((GLeeFuncPtr_glElementPointerATI = (GLEEPFNGLELEMENTPOINTERATIPROC) __GLeeGetProcAddress("glElementPointerATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glDrawElementArrayATI = (GLEEPFNGLDRAWELEMENTARRAYATIPROC) __GLeeGetProcAddress("glDrawElementArrayATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glDrawRangeElementArrayATI = (GLEEPFNGLDRAWRANGEELEMENTARRAYATIPROC) __GLeeGetProcAddress("glDrawRangeElementArrayATI"))!=0) nLinked++;
#endif
    if (nLinked==3) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_SUN_mesh_array(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_SUN_mesh_array
    if ((GLeeFuncPtr_glDrawMeshArraysSUN = (GLEEPFNGLDRAWMESHARRAYSSUNPROC) __GLeeGetProcAddress("glDrawMeshArraysSUN"))!=0) nLinked++;
#endif
    if (nLinked==1) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_SUN_slice_accum(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_NV_multisample_filter_hint(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_NV_depth_clamp(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_NV_occlusion_query(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_NV_occlusion_query
    if ((GLeeFuncPtr_glGenOcclusionQueriesNV = (GLEEPFNGLGENOCCLUSIONQUERIESNVPROC) __GLeeGetProcAddress("glGenOcclusionQueriesNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glDeleteOcclusionQueriesNV = (GLEEPFNGLDELETEOCCLUSIONQUERIESNVPROC) __GLeeGetProcAddress("glDeleteOcclusionQueriesNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glIsOcclusionQueryNV = (GLEEPFNGLISOCCLUSIONQUERYNVPROC) __GLeeGetProcAddress("glIsOcclusionQueryNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glBeginOcclusionQueryNV = (GLEEPFNGLBEGINOCCLUSIONQUERYNVPROC) __GLeeGetProcAddress("glBeginOcclusionQueryNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glEndOcclusionQueryNV = (GLEEPFNGLENDOCCLUSIONQUERYNVPROC) __GLeeGetProcAddress("glEndOcclusionQueryNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetOcclusionQueryivNV = (GLEEPFNGLGETOCCLUSIONQUERYIVNVPROC) __GLeeGetProcAddress("glGetOcclusionQueryivNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetOcclusionQueryuivNV = (GLEEPFNGLGETOCCLUSIONQUERYUIVNVPROC) __GLeeGetProcAddress("glGetOcclusionQueryuivNV"))!=0) nLinked++;
#endif
    if (nLinked==7) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_NV_point_sprite(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_NV_point_sprite
    if ((GLeeFuncPtr_glPointParameteriNV = (GLEEPFNGLPOINTPARAMETERINVPROC) __GLeeGetProcAddress("glPointParameteriNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glPointParameterivNV = (GLEEPFNGLPOINTPARAMETERIVNVPROC) __GLeeGetProcAddress("glPointParameterivNV"))!=0) nLinked++;
#endif
    if (nLinked==2) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_NV_texture_shader3(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_NV_vertex_program1_1(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_EXT_shadow_funcs(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_EXT_stencil_two_side(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_EXT_stencil_two_side
    if ((GLeeFuncPtr_glActiveStencilFaceEXT = (GLEEPFNGLACTIVESTENCILFACEEXTPROC) __GLeeGetProcAddress("glActiveStencilFaceEXT"))!=0) nLinked++;
#endif
    if (nLinked==1) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_ATI_text_fragment_shader(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_APPLE_client_storage(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_APPLE_element_array(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_APPLE_element_array
    if ((GLeeFuncPtr_glElementPointerAPPLE = (GLEEPFNGLELEMENTPOINTERAPPLEPROC) __GLeeGetProcAddress("glElementPointerAPPLE"))!=0) nLinked++;
    if ((GLeeFuncPtr_glDrawElementArrayAPPLE = (GLEEPFNGLDRAWELEMENTARRAYAPPLEPROC) __GLeeGetProcAddress("glDrawElementArrayAPPLE"))!=0) nLinked++;
    if ((GLeeFuncPtr_glDrawRangeElementArrayAPPLE = (GLEEPFNGLDRAWRANGEELEMENTARRAYAPPLEPROC) __GLeeGetProcAddress("glDrawRangeElementArrayAPPLE"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiDrawElementArrayAPPLE = (GLEEPFNGLMULTIDRAWELEMENTARRAYAPPLEPROC) __GLeeGetProcAddress("glMultiDrawElementArrayAPPLE"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiDrawRangeElementArrayAPPLE = (GLEEPFNGLMULTIDRAWRANGEELEMENTARRAYAPPLEPROC) __GLeeGetProcAddress("glMultiDrawRangeElementArrayAPPLE"))!=0) nLinked++;
#endif
    if (nLinked==5) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_APPLE_fence(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_APPLE_fence
    if ((GLeeFuncPtr_glGenFencesAPPLE = (GLEEPFNGLGENFENCESAPPLEPROC) __GLeeGetProcAddress("glGenFencesAPPLE"))!=0) nLinked++;
    if ((GLeeFuncPtr_glDeleteFencesAPPLE = (GLEEPFNGLDELETEFENCESAPPLEPROC) __GLeeGetProcAddress("glDeleteFencesAPPLE"))!=0) nLinked++;
    if ((GLeeFuncPtr_glSetFenceAPPLE = (GLEEPFNGLSETFENCEAPPLEPROC) __GLeeGetProcAddress("glSetFenceAPPLE"))!=0) nLinked++;
    if ((GLeeFuncPtr_glIsFenceAPPLE = (GLEEPFNGLISFENCEAPPLEPROC) __GLeeGetProcAddress("glIsFenceAPPLE"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTestFenceAPPLE = (GLEEPFNGLTESTFENCEAPPLEPROC) __GLeeGetProcAddress("glTestFenceAPPLE"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFinishFenceAPPLE = (GLEEPFNGLFINISHFENCEAPPLEPROC) __GLeeGetProcAddress("glFinishFenceAPPLE"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTestObjectAPPLE = (GLEEPFNGLTESTOBJECTAPPLEPROC) __GLeeGetProcAddress("glTestObjectAPPLE"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFinishObjectAPPLE = (GLEEPFNGLFINISHOBJECTAPPLEPROC) __GLeeGetProcAddress("glFinishObjectAPPLE"))!=0) nLinked++;
#endif
    if (nLinked==8) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_APPLE_vertex_array_object(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_APPLE_vertex_array_object
    if ((GLeeFuncPtr_glBindVertexArrayAPPLE = (GLEEPFNGLBINDVERTEXARRAYAPPLEPROC) __GLeeGetProcAddress("glBindVertexArrayAPPLE"))!=0) nLinked++;
    if ((GLeeFuncPtr_glDeleteVertexArraysAPPLE = (GLEEPFNGLDELETEVERTEXARRAYSAPPLEPROC) __GLeeGetProcAddress("glDeleteVertexArraysAPPLE"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGenVertexArraysAPPLE = (GLEEPFNGLGENVERTEXARRAYSAPPLEPROC) __GLeeGetProcAddress("glGenVertexArraysAPPLE"))!=0) nLinked++;
    if ((GLeeFuncPtr_glIsVertexArrayAPPLE = (GLEEPFNGLISVERTEXARRAYAPPLEPROC) __GLeeGetProcAddress("glIsVertexArrayAPPLE"))!=0) nLinked++;
#endif
    if (nLinked==4) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_APPLE_vertex_array_range(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_APPLE_vertex_array_range
    if ((GLeeFuncPtr_glVertexArrayRangeAPPLE = (GLEEPFNGLVERTEXARRAYRANGEAPPLEPROC) __GLeeGetProcAddress("glVertexArrayRangeAPPLE"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFlushVertexArrayRangeAPPLE = (GLEEPFNGLFLUSHVERTEXARRAYRANGEAPPLEPROC) __GLeeGetProcAddress("glFlushVertexArrayRangeAPPLE"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexArrayParameteriAPPLE = (GLEEPFNGLVERTEXARRAYPARAMETERIAPPLEPROC) __GLeeGetProcAddress("glVertexArrayParameteriAPPLE"))!=0) nLinked++;
#endif
    if (nLinked==3) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_APPLE_ycbcr_422(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_S3_s3tc(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_ATI_draw_buffers(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_ATI_draw_buffers
    if ((GLeeFuncPtr_glDrawBuffersATI = (GLEEPFNGLDRAWBUFFERSATIPROC) __GLeeGetProcAddress("glDrawBuffersATI"))!=0) nLinked++;
#endif
    if (nLinked==1) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_ATI_pixel_format_float(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_ATI_texture_env_combine3(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_ATI_texture_float(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_NV_float_buffer(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_NV_fragment_program(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_NV_fragment_program
    if ((GLeeFuncPtr_glProgramNamedParameter4fNV = (GLEEPFNGLPROGRAMNAMEDPARAMETER4FNVPROC) __GLeeGetProcAddress("glProgramNamedParameter4fNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramNamedParameter4dNV = (GLEEPFNGLPROGRAMNAMEDPARAMETER4DNVPROC) __GLeeGetProcAddress("glProgramNamedParameter4dNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramNamedParameter4fvNV = (GLEEPFNGLPROGRAMNAMEDPARAMETER4FVNVPROC) __GLeeGetProcAddress("glProgramNamedParameter4fvNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramNamedParameter4dvNV = (GLEEPFNGLPROGRAMNAMEDPARAMETER4DVNVPROC) __GLeeGetProcAddress("glProgramNamedParameter4dvNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetProgramNamedParameterfvNV = (GLEEPFNGLGETPROGRAMNAMEDPARAMETERFVNVPROC) __GLeeGetProcAddress("glGetProgramNamedParameterfvNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetProgramNamedParameterdvNV = (GLEEPFNGLGETPROGRAMNAMEDPARAMETERDVNVPROC) __GLeeGetProcAddress("glGetProgramNamedParameterdvNV"))!=0) nLinked++;
#endif
    if (nLinked==6) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_NV_half_float(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_NV_half_float
    if ((GLeeFuncPtr_glVertex2hNV = (GLEEPFNGLVERTEX2HNVPROC) __GLeeGetProcAddress("glVertex2hNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertex2hvNV = (GLEEPFNGLVERTEX2HVNVPROC) __GLeeGetProcAddress("glVertex2hvNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertex3hNV = (GLEEPFNGLVERTEX3HNVPROC) __GLeeGetProcAddress("glVertex3hNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertex3hvNV = (GLEEPFNGLVERTEX3HVNVPROC) __GLeeGetProcAddress("glVertex3hvNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertex4hNV = (GLEEPFNGLVERTEX4HNVPROC) __GLeeGetProcAddress("glVertex4hNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertex4hvNV = (GLEEPFNGLVERTEX4HVNVPROC) __GLeeGetProcAddress("glVertex4hvNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glNormal3hNV = (GLEEPFNGLNORMAL3HNVPROC) __GLeeGetProcAddress("glNormal3hNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glNormal3hvNV = (GLEEPFNGLNORMAL3HVNVPROC) __GLeeGetProcAddress("glNormal3hvNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glColor3hNV = (GLEEPFNGLCOLOR3HNVPROC) __GLeeGetProcAddress("glColor3hNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glColor3hvNV = (GLEEPFNGLCOLOR3HVNVPROC) __GLeeGetProcAddress("glColor3hvNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glColor4hNV = (GLEEPFNGLCOLOR4HNVPROC) __GLeeGetProcAddress("glColor4hNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glColor4hvNV = (GLEEPFNGLCOLOR4HVNVPROC) __GLeeGetProcAddress("glColor4hvNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTexCoord1hNV = (GLEEPFNGLTEXCOORD1HNVPROC) __GLeeGetProcAddress("glTexCoord1hNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTexCoord1hvNV = (GLEEPFNGLTEXCOORD1HVNVPROC) __GLeeGetProcAddress("glTexCoord1hvNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTexCoord2hNV = (GLEEPFNGLTEXCOORD2HNVPROC) __GLeeGetProcAddress("glTexCoord2hNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTexCoord2hvNV = (GLEEPFNGLTEXCOORD2HVNVPROC) __GLeeGetProcAddress("glTexCoord2hvNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTexCoord3hNV = (GLEEPFNGLTEXCOORD3HNVPROC) __GLeeGetProcAddress("glTexCoord3hNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTexCoord3hvNV = (GLEEPFNGLTEXCOORD3HVNVPROC) __GLeeGetProcAddress("glTexCoord3hvNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTexCoord4hNV = (GLEEPFNGLTEXCOORD4HNVPROC) __GLeeGetProcAddress("glTexCoord4hNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTexCoord4hvNV = (GLEEPFNGLTEXCOORD4HVNVPROC) __GLeeGetProcAddress("glTexCoord4hvNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord1hNV = (GLEEPFNGLMULTITEXCOORD1HNVPROC) __GLeeGetProcAddress("glMultiTexCoord1hNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord1hvNV = (GLEEPFNGLMULTITEXCOORD1HVNVPROC) __GLeeGetProcAddress("glMultiTexCoord1hvNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord2hNV = (GLEEPFNGLMULTITEXCOORD2HNVPROC) __GLeeGetProcAddress("glMultiTexCoord2hNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord2hvNV = (GLEEPFNGLMULTITEXCOORD2HVNVPROC) __GLeeGetProcAddress("glMultiTexCoord2hvNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord3hNV = (GLEEPFNGLMULTITEXCOORD3HNVPROC) __GLeeGetProcAddress("glMultiTexCoord3hNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord3hvNV = (GLEEPFNGLMULTITEXCOORD3HVNVPROC) __GLeeGetProcAddress("glMultiTexCoord3hvNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord4hNV = (GLEEPFNGLMULTITEXCOORD4HNVPROC) __GLeeGetProcAddress("glMultiTexCoord4hNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoord4hvNV = (GLEEPFNGLMULTITEXCOORD4HVNVPROC) __GLeeGetProcAddress("glMultiTexCoord4hvNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFogCoordhNV = (GLEEPFNGLFOGCOORDHNVPROC) __GLeeGetProcAddress("glFogCoordhNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFogCoordhvNV = (GLEEPFNGLFOGCOORDHVNVPROC) __GLeeGetProcAddress("glFogCoordhvNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glSecondaryColor3hNV = (GLEEPFNGLSECONDARYCOLOR3HNVPROC) __GLeeGetProcAddress("glSecondaryColor3hNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glSecondaryColor3hvNV = (GLEEPFNGLSECONDARYCOLOR3HVNVPROC) __GLeeGetProcAddress("glSecondaryColor3hvNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexWeighthNV = (GLEEPFNGLVERTEXWEIGHTHNVPROC) __GLeeGetProcAddress("glVertexWeighthNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexWeighthvNV = (GLEEPFNGLVERTEXWEIGHTHVNVPROC) __GLeeGetProcAddress("glVertexWeighthvNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib1hNV = (GLEEPFNGLVERTEXATTRIB1HNVPROC) __GLeeGetProcAddress("glVertexAttrib1hNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib1hvNV = (GLEEPFNGLVERTEXATTRIB1HVNVPROC) __GLeeGetProcAddress("glVertexAttrib1hvNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib2hNV = (GLEEPFNGLVERTEXATTRIB2HNVPROC) __GLeeGetProcAddress("glVertexAttrib2hNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib2hvNV = (GLEEPFNGLVERTEXATTRIB2HVNVPROC) __GLeeGetProcAddress("glVertexAttrib2hvNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib3hNV = (GLEEPFNGLVERTEXATTRIB3HNVPROC) __GLeeGetProcAddress("glVertexAttrib3hNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib3hvNV = (GLEEPFNGLVERTEXATTRIB3HVNVPROC) __GLeeGetProcAddress("glVertexAttrib3hvNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib4hNV = (GLEEPFNGLVERTEXATTRIB4HNVPROC) __GLeeGetProcAddress("glVertexAttrib4hNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttrib4hvNV = (GLEEPFNGLVERTEXATTRIB4HVNVPROC) __GLeeGetProcAddress("glVertexAttrib4hvNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttribs1hvNV = (GLEEPFNGLVERTEXATTRIBS1HVNVPROC) __GLeeGetProcAddress("glVertexAttribs1hvNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttribs2hvNV = (GLEEPFNGLVERTEXATTRIBS2HVNVPROC) __GLeeGetProcAddress("glVertexAttribs2hvNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttribs3hvNV = (GLEEPFNGLVERTEXATTRIBS3HVNVPROC) __GLeeGetProcAddress("glVertexAttribs3hvNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttribs4hvNV = (GLEEPFNGLVERTEXATTRIBS4HVNVPROC) __GLeeGetProcAddress("glVertexAttribs4hvNV"))!=0) nLinked++;
#endif
    if (nLinked==46) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_NV_pixel_data_range(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_NV_pixel_data_range
    if ((GLeeFuncPtr_glPixelDataRangeNV = (GLEEPFNGLPIXELDATARANGENVPROC) __GLeeGetProcAddress("glPixelDataRangeNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFlushPixelDataRangeNV = (GLEEPFNGLFLUSHPIXELDATARANGENVPROC) __GLeeGetProcAddress("glFlushPixelDataRangeNV"))!=0) nLinked++;
#endif
    if (nLinked==2) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_NV_primitive_restart(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_NV_primitive_restart
    if ((GLeeFuncPtr_glPrimitiveRestartNV = (GLEEPFNGLPRIMITIVERESTARTNVPROC) __GLeeGetProcAddress("glPrimitiveRestartNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glPrimitiveRestartIndexNV = (GLEEPFNGLPRIMITIVERESTARTINDEXNVPROC) __GLeeGetProcAddress("glPrimitiveRestartIndexNV"))!=0) nLinked++;
#endif
    if (nLinked==2) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_NV_texture_expand_normal(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_NV_vertex_program2(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_ATI_map_object_buffer(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_ATI_map_object_buffer
    if ((GLeeFuncPtr_glMapObjectBufferATI = (GLEEPFNGLMAPOBJECTBUFFERATIPROC) __GLeeGetProcAddress("glMapObjectBufferATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUnmapObjectBufferATI = (GLEEPFNGLUNMAPOBJECTBUFFERATIPROC) __GLeeGetProcAddress("glUnmapObjectBufferATI"))!=0) nLinked++;
#endif
    if (nLinked==2) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_ATI_separate_stencil(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_ATI_separate_stencil
    if ((GLeeFuncPtr_glStencilOpSeparateATI = (GLEEPFNGLSTENCILOPSEPARATEATIPROC) __GLeeGetProcAddress("glStencilOpSeparateATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glStencilFuncSeparateATI = (GLEEPFNGLSTENCILFUNCSEPARATEATIPROC) __GLeeGetProcAddress("glStencilFuncSeparateATI"))!=0) nLinked++;
#endif
    if (nLinked==2) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_ATI_vertex_attrib_array_object(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_ATI_vertex_attrib_array_object
    if ((GLeeFuncPtr_glVertexAttribArrayObjectATI = (GLEEPFNGLVERTEXATTRIBARRAYOBJECTATIPROC) __GLeeGetProcAddress("glVertexAttribArrayObjectATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetVertexAttribArrayObjectfvATI = (GLEEPFNGLGETVERTEXATTRIBARRAYOBJECTFVATIPROC) __GLeeGetProcAddress("glGetVertexAttribArrayObjectfvATI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetVertexAttribArrayObjectivATI = (GLEEPFNGLGETVERTEXATTRIBARRAYOBJECTIVATIPROC) __GLeeGetProcAddress("glGetVertexAttribArrayObjectivATI"))!=0) nLinked++;
#endif
    if (nLinked==3) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_OES_read_format(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_EXT_depth_bounds_test(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_EXT_depth_bounds_test
    if ((GLeeFuncPtr_glDepthBoundsEXT = (GLEEPFNGLDEPTHBOUNDSEXTPROC) __GLeeGetProcAddress("glDepthBoundsEXT"))!=0) nLinked++;
#endif
    if (nLinked==1) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_EXT_texture_mirror_clamp(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_EXT_blend_equation_separate(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_EXT_blend_equation_separate
    if ((GLeeFuncPtr_glBlendEquationSeparateEXT = (GLEEPFNGLBLENDEQUATIONSEPARATEEXTPROC) __GLeeGetProcAddress("glBlendEquationSeparateEXT"))!=0) nLinked++;
#endif
    if (nLinked==1) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_MESA_pack_invert(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_MESA_ycbcr_texture(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_EXT_pixel_buffer_object(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_NV_fragment_program_option(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_NV_fragment_program2(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_NV_vertex_program2_option(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_NV_vertex_program3(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_EXT_framebuffer_object(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_EXT_framebuffer_object
    if ((GLeeFuncPtr_glIsRenderbufferEXT = (GLEEPFNGLISRENDERBUFFEREXTPROC) __GLeeGetProcAddress("glIsRenderbufferEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glBindRenderbufferEXT = (GLEEPFNGLBINDRENDERBUFFEREXTPROC) __GLeeGetProcAddress("glBindRenderbufferEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glDeleteRenderbuffersEXT = (GLEEPFNGLDELETERENDERBUFFERSEXTPROC) __GLeeGetProcAddress("glDeleteRenderbuffersEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGenRenderbuffersEXT = (GLEEPFNGLGENRENDERBUFFERSEXTPROC) __GLeeGetProcAddress("glGenRenderbuffersEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glRenderbufferStorageEXT = (GLEEPFNGLRENDERBUFFERSTORAGEEXTPROC) __GLeeGetProcAddress("glRenderbufferStorageEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetRenderbufferParameterivEXT = (GLEEPFNGLGETRENDERBUFFERPARAMETERIVEXTPROC) __GLeeGetProcAddress("glGetRenderbufferParameterivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glIsFramebufferEXT = (GLEEPFNGLISFRAMEBUFFEREXTPROC) __GLeeGetProcAddress("glIsFramebufferEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glBindFramebufferEXT = (GLEEPFNGLBINDFRAMEBUFFEREXTPROC) __GLeeGetProcAddress("glBindFramebufferEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glDeleteFramebuffersEXT = (GLEEPFNGLDELETEFRAMEBUFFERSEXTPROC) __GLeeGetProcAddress("glDeleteFramebuffersEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGenFramebuffersEXT = (GLEEPFNGLGENFRAMEBUFFERSEXTPROC) __GLeeGetProcAddress("glGenFramebuffersEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glCheckFramebufferStatusEXT = (GLEEPFNGLCHECKFRAMEBUFFERSTATUSEXTPROC) __GLeeGetProcAddress("glCheckFramebufferStatusEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFramebufferTexture1DEXT = (GLEEPFNGLFRAMEBUFFERTEXTURE1DEXTPROC) __GLeeGetProcAddress("glFramebufferTexture1DEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFramebufferTexture2DEXT = (GLEEPFNGLFRAMEBUFFERTEXTURE2DEXTPROC) __GLeeGetProcAddress("glFramebufferTexture2DEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFramebufferTexture3DEXT = (GLEEPFNGLFRAMEBUFFERTEXTURE3DEXTPROC) __GLeeGetProcAddress("glFramebufferTexture3DEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFramebufferRenderbufferEXT = (GLEEPFNGLFRAMEBUFFERRENDERBUFFEREXTPROC) __GLeeGetProcAddress("glFramebufferRenderbufferEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetFramebufferAttachmentParameterivEXT = (GLEEPFNGLGETFRAMEBUFFERATTACHMENTPARAMETERIVEXTPROC) __GLeeGetProcAddress("glGetFramebufferAttachmentParameterivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGenerateMipmapEXT = (GLEEPFNGLGENERATEMIPMAPEXTPROC) __GLeeGetProcAddress("glGenerateMipmapEXT"))!=0) nLinked++;
#endif
    if (nLinked==17) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_GREMEDY_string_marker(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_GREMEDY_string_marker
    if ((GLeeFuncPtr_glStringMarkerGREMEDY = (GLEEPFNGLSTRINGMARKERGREMEDYPROC) __GLeeGetProcAddress("glStringMarkerGREMEDY"))!=0) nLinked++;
#endif
    if (nLinked==1) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_EXT_packed_depth_stencil(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_EXT_stencil_clear_tag(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_EXT_stencil_clear_tag
    if ((GLeeFuncPtr_glStencilClearTagEXT = (GLEEPFNGLSTENCILCLEARTAGEXTPROC) __GLeeGetProcAddress("glStencilClearTagEXT"))!=0) nLinked++;
#endif
    if (nLinked==1) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_EXT_texture_sRGB(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_EXT_framebuffer_blit(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_EXT_framebuffer_blit
    if ((GLeeFuncPtr_glBlitFramebufferEXT = (GLEEPFNGLBLITFRAMEBUFFEREXTPROC) __GLeeGetProcAddress("glBlitFramebufferEXT"))!=0) nLinked++;
#endif
    if (nLinked==1) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_EXT_framebuffer_multisample(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_EXT_framebuffer_multisample
    if ((GLeeFuncPtr_glRenderbufferStorageMultisampleEXT = (GLEEPFNGLRENDERBUFFERSTORAGEMULTISAMPLEEXTPROC) __GLeeGetProcAddress("glRenderbufferStorageMultisampleEXT"))!=0) nLinked++;
#endif
    if (nLinked==1) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_MESAX_texture_stack(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_EXT_timer_query(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_EXT_timer_query
    if ((GLeeFuncPtr_glGetQueryObjecti64vEXT = (GLEEPFNGLGETQUERYOBJECTI64VEXTPROC) __GLeeGetProcAddress("glGetQueryObjecti64vEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetQueryObjectui64vEXT = (GLEEPFNGLGETQUERYOBJECTUI64VEXTPROC) __GLeeGetProcAddress("glGetQueryObjectui64vEXT"))!=0) nLinked++;
#endif
    if (nLinked==2) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_EXT_gpu_program_parameters(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_EXT_gpu_program_parameters
    if ((GLeeFuncPtr_glProgramEnvParameters4fvEXT = (GLEEPFNGLPROGRAMENVPARAMETERS4FVEXTPROC) __GLeeGetProcAddress("glProgramEnvParameters4fvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramLocalParameters4fvEXT = (GLEEPFNGLPROGRAMLOCALPARAMETERS4FVEXTPROC) __GLeeGetProcAddress("glProgramLocalParameters4fvEXT"))!=0) nLinked++;
#endif
    if (nLinked==2) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_APPLE_flush_buffer_range(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_APPLE_flush_buffer_range
    if ((GLeeFuncPtr_glBufferParameteriAPPLE = (GLEEPFNGLBUFFERPARAMETERIAPPLEPROC) __GLeeGetProcAddress("glBufferParameteriAPPLE"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFlushMappedBufferRangeAPPLE = (GLEEPFNGLFLUSHMAPPEDBUFFERRANGEAPPLEPROC) __GLeeGetProcAddress("glFlushMappedBufferRangeAPPLE"))!=0) nLinked++;
#endif
    if (nLinked==2) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_EXT_gpu_shader4(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_EXT_gpu_shader4
    if ((GLeeFuncPtr_glGetUniformuivEXT = (GLEEPFNGLGETUNIFORMUIVEXTPROC) __GLeeGetProcAddress("glGetUniformuivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glBindFragDataLocationEXT = (GLEEPFNGLBINDFRAGDATALOCATIONEXTPROC) __GLeeGetProcAddress("glBindFragDataLocationEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetFragDataLocationEXT = (GLEEPFNGLGETFRAGDATALOCATIONEXTPROC) __GLeeGetProcAddress("glGetFragDataLocationEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUniform1uiEXT = (GLEEPFNGLUNIFORM1UIEXTPROC) __GLeeGetProcAddress("glUniform1uiEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUniform2uiEXT = (GLEEPFNGLUNIFORM2UIEXTPROC) __GLeeGetProcAddress("glUniform2uiEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUniform3uiEXT = (GLEEPFNGLUNIFORM3UIEXTPROC) __GLeeGetProcAddress("glUniform3uiEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUniform4uiEXT = (GLEEPFNGLUNIFORM4UIEXTPROC) __GLeeGetProcAddress("glUniform4uiEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUniform1uivEXT = (GLEEPFNGLUNIFORM1UIVEXTPROC) __GLeeGetProcAddress("glUniform1uivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUniform2uivEXT = (GLEEPFNGLUNIFORM2UIVEXTPROC) __GLeeGetProcAddress("glUniform2uivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUniform3uivEXT = (GLEEPFNGLUNIFORM3UIVEXTPROC) __GLeeGetProcAddress("glUniform3uivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUniform4uivEXT = (GLEEPFNGLUNIFORM4UIVEXTPROC) __GLeeGetProcAddress("glUniform4uivEXT"))!=0) nLinked++;
#endif
    if (nLinked==11) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_EXT_draw_instanced(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_EXT_draw_instanced
    if ((GLeeFuncPtr_glDrawArraysInstancedEXT = (GLEEPFNGLDRAWARRAYSINSTANCEDEXTPROC) __GLeeGetProcAddress("glDrawArraysInstancedEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glDrawElementsInstancedEXT = (GLEEPFNGLDRAWELEMENTSINSTANCEDEXTPROC) __GLeeGetProcAddress("glDrawElementsInstancedEXT"))!=0) nLinked++;
#endif
    if (nLinked==2) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_EXT_packed_float(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_EXT_texture_array(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_EXT_texture_buffer_object(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_EXT_texture_buffer_object
    if ((GLeeFuncPtr_glTexBufferEXT = (GLEEPFNGLTEXBUFFEREXTPROC) __GLeeGetProcAddress("glTexBufferEXT"))!=0) nLinked++;
#endif
    if (nLinked==1) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_EXT_texture_compression_latc(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_EXT_texture_compression_rgtc(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_EXT_texture_shared_exponent(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_NV_depth_buffer_float(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_NV_depth_buffer_float
    if ((GLeeFuncPtr_glDepthRangedNV = (GLEEPFNGLDEPTHRANGEDNVPROC) __GLeeGetProcAddress("glDepthRangedNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glClearDepthdNV = (GLEEPFNGLCLEARDEPTHDNVPROC) __GLeeGetProcAddress("glClearDepthdNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glDepthBoundsdNV = (GLEEPFNGLDEPTHBOUNDSDNVPROC) __GLeeGetProcAddress("glDepthBoundsdNV"))!=0) nLinked++;
#endif
    if (nLinked==3) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_NV_framebuffer_multisample_coverage(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_NV_framebuffer_multisample_coverage
    if ((GLeeFuncPtr_glRenderbufferStorageMultisampleCoverageNV = (GLEEPFNGLRENDERBUFFERSTORAGEMULTISAMPLECOVERAGENVPROC) __GLeeGetProcAddress("glRenderbufferStorageMultisampleCoverageNV"))!=0) nLinked++;
#endif
    if (nLinked==1) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_EXT_framebuffer_sRGB(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_NV_geometry_shader4(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_NV_parameter_buffer_object(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_NV_parameter_buffer_object
    if ((GLeeFuncPtr_glProgramBufferParametersfvNV = (GLEEPFNGLPROGRAMBUFFERPARAMETERSFVNVPROC) __GLeeGetProcAddress("glProgramBufferParametersfvNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramBufferParametersIivNV = (GLEEPFNGLPROGRAMBUFFERPARAMETERSIIVNVPROC) __GLeeGetProcAddress("glProgramBufferParametersIivNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramBufferParametersIuivNV = (GLEEPFNGLPROGRAMBUFFERPARAMETERSIUIVNVPROC) __GLeeGetProcAddress("glProgramBufferParametersIuivNV"))!=0) nLinked++;
#endif
    if (nLinked==3) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_EXT_draw_buffers2(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_EXT_draw_buffers2
    if ((GLeeFuncPtr_glColorMaskIndexedEXT = (GLEEPFNGLCOLORMASKINDEXEDEXTPROC) __GLeeGetProcAddress("glColorMaskIndexedEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetBooleanIndexedvEXT = (GLEEPFNGLGETBOOLEANINDEXEDVEXTPROC) __GLeeGetProcAddress("glGetBooleanIndexedvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetIntegerIndexedvEXT = (GLEEPFNGLGETINTEGERINDEXEDVEXTPROC) __GLeeGetProcAddress("glGetIntegerIndexedvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glEnableIndexedEXT = (GLEEPFNGLENABLEINDEXEDEXTPROC) __GLeeGetProcAddress("glEnableIndexedEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glDisableIndexedEXT = (GLEEPFNGLDISABLEINDEXEDEXTPROC) __GLeeGetProcAddress("glDisableIndexedEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glIsEnabledIndexedEXT = (GLEEPFNGLISENABLEDINDEXEDEXTPROC) __GLeeGetProcAddress("glIsEnabledIndexedEXT"))!=0) nLinked++;
#endif
    if (nLinked==6) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_NV_transform_feedback(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_NV_transform_feedback
    if ((GLeeFuncPtr_glBeginTransformFeedbackNV = (GLEEPFNGLBEGINTRANSFORMFEEDBACKNVPROC) __GLeeGetProcAddress("glBeginTransformFeedbackNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glEndTransformFeedbackNV = (GLEEPFNGLENDTRANSFORMFEEDBACKNVPROC) __GLeeGetProcAddress("glEndTransformFeedbackNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTransformFeedbackAttribsNV = (GLEEPFNGLTRANSFORMFEEDBACKATTRIBSNVPROC) __GLeeGetProcAddress("glTransformFeedbackAttribsNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glBindBufferRangeNV = (GLEEPFNGLBINDBUFFERRANGENVPROC) __GLeeGetProcAddress("glBindBufferRangeNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glBindBufferOffsetNV = (GLEEPFNGLBINDBUFFEROFFSETNVPROC) __GLeeGetProcAddress("glBindBufferOffsetNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glBindBufferBaseNV = (GLEEPFNGLBINDBUFFERBASENVPROC) __GLeeGetProcAddress("glBindBufferBaseNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTransformFeedbackVaryingsNV = (GLEEPFNGLTRANSFORMFEEDBACKVARYINGSNVPROC) __GLeeGetProcAddress("glTransformFeedbackVaryingsNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glActiveVaryingNV = (GLEEPFNGLACTIVEVARYINGNVPROC) __GLeeGetProcAddress("glActiveVaryingNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetVaryingLocationNV = (GLEEPFNGLGETVARYINGLOCATIONNVPROC) __GLeeGetProcAddress("glGetVaryingLocationNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetActiveVaryingNV = (GLEEPFNGLGETACTIVEVARYINGNVPROC) __GLeeGetProcAddress("glGetActiveVaryingNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetTransformFeedbackVaryingNV = (GLEEPFNGLGETTRANSFORMFEEDBACKVARYINGNVPROC) __GLeeGetProcAddress("glGetTransformFeedbackVaryingNV"))!=0) nLinked++;
#endif
    if (nLinked==11) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_EXT_bindable_uniform(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_EXT_bindable_uniform
    if ((GLeeFuncPtr_glUniformBufferEXT = (GLEEPFNGLUNIFORMBUFFEREXTPROC) __GLeeGetProcAddress("glUniformBufferEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetUniformBufferSizeEXT = (GLEEPFNGLGETUNIFORMBUFFERSIZEEXTPROC) __GLeeGetProcAddress("glGetUniformBufferSizeEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetUniformOffsetEXT = (GLEEPFNGLGETUNIFORMOFFSETEXTPROC) __GLeeGetProcAddress("glGetUniformOffsetEXT"))!=0) nLinked++;
#endif
    if (nLinked==3) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_EXT_texture_integer(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_EXT_texture_integer
    if ((GLeeFuncPtr_glTexParameterIivEXT = (GLEEPFNGLTEXPARAMETERIIVEXTPROC) __GLeeGetProcAddress("glTexParameterIivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTexParameterIuivEXT = (GLEEPFNGLTEXPARAMETERIUIVEXTPROC) __GLeeGetProcAddress("glTexParameterIuivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetTexParameterIivEXT = (GLEEPFNGLGETTEXPARAMETERIIVEXTPROC) __GLeeGetProcAddress("glGetTexParameterIivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetTexParameterIuivEXT = (GLEEPFNGLGETTEXPARAMETERIUIVEXTPROC) __GLeeGetProcAddress("glGetTexParameterIuivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glClearColorIiEXT = (GLEEPFNGLCLEARCOLORIIEXTPROC) __GLeeGetProcAddress("glClearColorIiEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glClearColorIuiEXT = (GLEEPFNGLCLEARCOLORIUIEXTPROC) __GLeeGetProcAddress("glClearColorIuiEXT"))!=0) nLinked++;
#endif
    if (nLinked==6) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_GREMEDY_frame_terminator(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_GREMEDY_frame_terminator
    if ((GLeeFuncPtr_glFrameTerminatorGREMEDY = (GLEEPFNGLFRAMETERMINATORGREMEDYPROC) __GLeeGetProcAddress("glFrameTerminatorGREMEDY"))!=0) nLinked++;
#endif
    if (nLinked==1) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_NV_conditional_render(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_NV_conditional_render
    if ((GLeeFuncPtr_glBeginConditionalRenderNV = (GLEEPFNGLBEGINCONDITIONALRENDERNVPROC) __GLeeGetProcAddress("glBeginConditionalRenderNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glEndConditionalRenderNV = (GLEEPFNGLENDCONDITIONALRENDERNVPROC) __GLeeGetProcAddress("glEndConditionalRenderNV"))!=0) nLinked++;
#endif
    if (nLinked==2) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_NV_present_video(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_EXT_transform_feedback(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_EXT_transform_feedback
    if ((GLeeFuncPtr_glBeginTransformFeedbackEXT = (GLEEPFNGLBEGINTRANSFORMFEEDBACKEXTPROC) __GLeeGetProcAddress("glBeginTransformFeedbackEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glEndTransformFeedbackEXT = (GLEEPFNGLENDTRANSFORMFEEDBACKEXTPROC) __GLeeGetProcAddress("glEndTransformFeedbackEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glBindBufferRangeEXT = (GLEEPFNGLBINDBUFFERRANGEEXTPROC) __GLeeGetProcAddress("glBindBufferRangeEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glBindBufferOffsetEXT = (GLEEPFNGLBINDBUFFEROFFSETEXTPROC) __GLeeGetProcAddress("glBindBufferOffsetEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glBindBufferBaseEXT = (GLEEPFNGLBINDBUFFERBASEEXTPROC) __GLeeGetProcAddress("glBindBufferBaseEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTransformFeedbackVaryingsEXT = (GLEEPFNGLTRANSFORMFEEDBACKVARYINGSEXTPROC) __GLeeGetProcAddress("glTransformFeedbackVaryingsEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetTransformFeedbackVaryingEXT = (GLEEPFNGLGETTRANSFORMFEEDBACKVARYINGEXTPROC) __GLeeGetProcAddress("glGetTransformFeedbackVaryingEXT"))!=0) nLinked++;
#endif
    if (nLinked==7) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_EXT_direct_state_access(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_EXT_direct_state_access
    if ((GLeeFuncPtr_glClientAttribDefaultEXT = (GLEEPFNGLCLIENTATTRIBDEFAULTEXTPROC) __GLeeGetProcAddress("glClientAttribDefaultEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glPushClientAttribDefaultEXT = (GLEEPFNGLPUSHCLIENTATTRIBDEFAULTEXTPROC) __GLeeGetProcAddress("glPushClientAttribDefaultEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMatrixLoadfEXT = (GLEEPFNGLMATRIXLOADFEXTPROC) __GLeeGetProcAddress("glMatrixLoadfEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMatrixLoaddEXT = (GLEEPFNGLMATRIXLOADDEXTPROC) __GLeeGetProcAddress("glMatrixLoaddEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMatrixMultfEXT = (GLEEPFNGLMATRIXMULTFEXTPROC) __GLeeGetProcAddress("glMatrixMultfEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMatrixMultdEXT = (GLEEPFNGLMATRIXMULTDEXTPROC) __GLeeGetProcAddress("glMatrixMultdEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMatrixLoadIdentityEXT = (GLEEPFNGLMATRIXLOADIDENTITYEXTPROC) __GLeeGetProcAddress("glMatrixLoadIdentityEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMatrixRotatefEXT = (GLEEPFNGLMATRIXROTATEFEXTPROC) __GLeeGetProcAddress("glMatrixRotatefEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMatrixRotatedEXT = (GLEEPFNGLMATRIXROTATEDEXTPROC) __GLeeGetProcAddress("glMatrixRotatedEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMatrixScalefEXT = (GLEEPFNGLMATRIXSCALEFEXTPROC) __GLeeGetProcAddress("glMatrixScalefEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMatrixScaledEXT = (GLEEPFNGLMATRIXSCALEDEXTPROC) __GLeeGetProcAddress("glMatrixScaledEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMatrixTranslatefEXT = (GLEEPFNGLMATRIXTRANSLATEFEXTPROC) __GLeeGetProcAddress("glMatrixTranslatefEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMatrixTranslatedEXT = (GLEEPFNGLMATRIXTRANSLATEDEXTPROC) __GLeeGetProcAddress("glMatrixTranslatedEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMatrixFrustumEXT = (GLEEPFNGLMATRIXFRUSTUMEXTPROC) __GLeeGetProcAddress("glMatrixFrustumEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMatrixOrthoEXT = (GLEEPFNGLMATRIXORTHOEXTPROC) __GLeeGetProcAddress("glMatrixOrthoEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMatrixPopEXT = (GLEEPFNGLMATRIXPOPEXTPROC) __GLeeGetProcAddress("glMatrixPopEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMatrixPushEXT = (GLEEPFNGLMATRIXPUSHEXTPROC) __GLeeGetProcAddress("glMatrixPushEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMatrixLoadTransposefEXT = (GLEEPFNGLMATRIXLOADTRANSPOSEFEXTPROC) __GLeeGetProcAddress("glMatrixLoadTransposefEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMatrixLoadTransposedEXT = (GLEEPFNGLMATRIXLOADTRANSPOSEDEXTPROC) __GLeeGetProcAddress("glMatrixLoadTransposedEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMatrixMultTransposefEXT = (GLEEPFNGLMATRIXMULTTRANSPOSEFEXTPROC) __GLeeGetProcAddress("glMatrixMultTransposefEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMatrixMultTransposedEXT = (GLEEPFNGLMATRIXMULTTRANSPOSEDEXTPROC) __GLeeGetProcAddress("glMatrixMultTransposedEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTextureParameterfEXT = (GLEEPFNGLTEXTUREPARAMETERFEXTPROC) __GLeeGetProcAddress("glTextureParameterfEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTextureParameterfvEXT = (GLEEPFNGLTEXTUREPARAMETERFVEXTPROC) __GLeeGetProcAddress("glTextureParameterfvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTextureParameteriEXT = (GLEEPFNGLTEXTUREPARAMETERIEXTPROC) __GLeeGetProcAddress("glTextureParameteriEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTextureParameterivEXT = (GLEEPFNGLTEXTUREPARAMETERIVEXTPROC) __GLeeGetProcAddress("glTextureParameterivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTextureImage1DEXT = (GLEEPFNGLTEXTUREIMAGE1DEXTPROC) __GLeeGetProcAddress("glTextureImage1DEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTextureImage2DEXT = (GLEEPFNGLTEXTUREIMAGE2DEXTPROC) __GLeeGetProcAddress("glTextureImage2DEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTextureSubImage1DEXT = (GLEEPFNGLTEXTURESUBIMAGE1DEXTPROC) __GLeeGetProcAddress("glTextureSubImage1DEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTextureSubImage2DEXT = (GLEEPFNGLTEXTURESUBIMAGE2DEXTPROC) __GLeeGetProcAddress("glTextureSubImage2DEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glCopyTextureImage1DEXT = (GLEEPFNGLCOPYTEXTUREIMAGE1DEXTPROC) __GLeeGetProcAddress("glCopyTextureImage1DEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glCopyTextureImage2DEXT = (GLEEPFNGLCOPYTEXTUREIMAGE2DEXTPROC) __GLeeGetProcAddress("glCopyTextureImage2DEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glCopyTextureSubImage1DEXT = (GLEEPFNGLCOPYTEXTURESUBIMAGE1DEXTPROC) __GLeeGetProcAddress("glCopyTextureSubImage1DEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glCopyTextureSubImage2DEXT = (GLEEPFNGLCOPYTEXTURESUBIMAGE2DEXTPROC) __GLeeGetProcAddress("glCopyTextureSubImage2DEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetTextureImageEXT = (GLEEPFNGLGETTEXTUREIMAGEEXTPROC) __GLeeGetProcAddress("glGetTextureImageEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetTextureParameterfvEXT = (GLEEPFNGLGETTEXTUREPARAMETERFVEXTPROC) __GLeeGetProcAddress("glGetTextureParameterfvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetTextureParameterivEXT = (GLEEPFNGLGETTEXTUREPARAMETERIVEXTPROC) __GLeeGetProcAddress("glGetTextureParameterivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetTextureLevelParameterfvEXT = (GLEEPFNGLGETTEXTURELEVELPARAMETERFVEXTPROC) __GLeeGetProcAddress("glGetTextureLevelParameterfvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetTextureLevelParameterivEXT = (GLEEPFNGLGETTEXTURELEVELPARAMETERIVEXTPROC) __GLeeGetProcAddress("glGetTextureLevelParameterivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTextureImage3DEXT = (GLEEPFNGLTEXTUREIMAGE3DEXTPROC) __GLeeGetProcAddress("glTextureImage3DEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTextureSubImage3DEXT = (GLEEPFNGLTEXTURESUBIMAGE3DEXTPROC) __GLeeGetProcAddress("glTextureSubImage3DEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glCopyTextureSubImage3DEXT = (GLEEPFNGLCOPYTEXTURESUBIMAGE3DEXTPROC) __GLeeGetProcAddress("glCopyTextureSubImage3DEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexParameterfEXT = (GLEEPFNGLMULTITEXPARAMETERFEXTPROC) __GLeeGetProcAddress("glMultiTexParameterfEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexParameterfvEXT = (GLEEPFNGLMULTITEXPARAMETERFVEXTPROC) __GLeeGetProcAddress("glMultiTexParameterfvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexParameteriEXT = (GLEEPFNGLMULTITEXPARAMETERIEXTPROC) __GLeeGetProcAddress("glMultiTexParameteriEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexParameterivEXT = (GLEEPFNGLMULTITEXPARAMETERIVEXTPROC) __GLeeGetProcAddress("glMultiTexParameterivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexImage1DEXT = (GLEEPFNGLMULTITEXIMAGE1DEXTPROC) __GLeeGetProcAddress("glMultiTexImage1DEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexImage2DEXT = (GLEEPFNGLMULTITEXIMAGE2DEXTPROC) __GLeeGetProcAddress("glMultiTexImage2DEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexSubImage1DEXT = (GLEEPFNGLMULTITEXSUBIMAGE1DEXTPROC) __GLeeGetProcAddress("glMultiTexSubImage1DEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexSubImage2DEXT = (GLEEPFNGLMULTITEXSUBIMAGE2DEXTPROC) __GLeeGetProcAddress("glMultiTexSubImage2DEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glCopyMultiTexImage1DEXT = (GLEEPFNGLCOPYMULTITEXIMAGE1DEXTPROC) __GLeeGetProcAddress("glCopyMultiTexImage1DEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glCopyMultiTexImage2DEXT = (GLEEPFNGLCOPYMULTITEXIMAGE2DEXTPROC) __GLeeGetProcAddress("glCopyMultiTexImage2DEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glCopyMultiTexSubImage1DEXT = (GLEEPFNGLCOPYMULTITEXSUBIMAGE1DEXTPROC) __GLeeGetProcAddress("glCopyMultiTexSubImage1DEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glCopyMultiTexSubImage2DEXT = (GLEEPFNGLCOPYMULTITEXSUBIMAGE2DEXTPROC) __GLeeGetProcAddress("glCopyMultiTexSubImage2DEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetMultiTexImageEXT = (GLEEPFNGLGETMULTITEXIMAGEEXTPROC) __GLeeGetProcAddress("glGetMultiTexImageEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetMultiTexParameterfvEXT = (GLEEPFNGLGETMULTITEXPARAMETERFVEXTPROC) __GLeeGetProcAddress("glGetMultiTexParameterfvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetMultiTexParameterivEXT = (GLEEPFNGLGETMULTITEXPARAMETERIVEXTPROC) __GLeeGetProcAddress("glGetMultiTexParameterivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetMultiTexLevelParameterfvEXT = (GLEEPFNGLGETMULTITEXLEVELPARAMETERFVEXTPROC) __GLeeGetProcAddress("glGetMultiTexLevelParameterfvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetMultiTexLevelParameterivEXT = (GLEEPFNGLGETMULTITEXLEVELPARAMETERIVEXTPROC) __GLeeGetProcAddress("glGetMultiTexLevelParameterivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexImage3DEXT = (GLEEPFNGLMULTITEXIMAGE3DEXTPROC) __GLeeGetProcAddress("glMultiTexImage3DEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexSubImage3DEXT = (GLEEPFNGLMULTITEXSUBIMAGE3DEXTPROC) __GLeeGetProcAddress("glMultiTexSubImage3DEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glCopyMultiTexSubImage3DEXT = (GLEEPFNGLCOPYMULTITEXSUBIMAGE3DEXTPROC) __GLeeGetProcAddress("glCopyMultiTexSubImage3DEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glBindMultiTextureEXT = (GLEEPFNGLBINDMULTITEXTUREEXTPROC) __GLeeGetProcAddress("glBindMultiTextureEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glEnableClientStateIndexedEXT = (GLEEPFNGLENABLECLIENTSTATEINDEXEDEXTPROC) __GLeeGetProcAddress("glEnableClientStateIndexedEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glDisableClientStateIndexedEXT = (GLEEPFNGLDISABLECLIENTSTATEINDEXEDEXTPROC) __GLeeGetProcAddress("glDisableClientStateIndexedEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexCoordPointerEXT = (GLEEPFNGLMULTITEXCOORDPOINTEREXTPROC) __GLeeGetProcAddress("glMultiTexCoordPointerEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexEnvfEXT = (GLEEPFNGLMULTITEXENVFEXTPROC) __GLeeGetProcAddress("glMultiTexEnvfEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexEnvfvEXT = (GLEEPFNGLMULTITEXENVFVEXTPROC) __GLeeGetProcAddress("glMultiTexEnvfvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexEnviEXT = (GLEEPFNGLMULTITEXENVIEXTPROC) __GLeeGetProcAddress("glMultiTexEnviEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexEnvivEXT = (GLEEPFNGLMULTITEXENVIVEXTPROC) __GLeeGetProcAddress("glMultiTexEnvivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexGendEXT = (GLEEPFNGLMULTITEXGENDEXTPROC) __GLeeGetProcAddress("glMultiTexGendEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexGendvEXT = (GLEEPFNGLMULTITEXGENDVEXTPROC) __GLeeGetProcAddress("glMultiTexGendvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexGenfEXT = (GLEEPFNGLMULTITEXGENFEXTPROC) __GLeeGetProcAddress("glMultiTexGenfEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexGenfvEXT = (GLEEPFNGLMULTITEXGENFVEXTPROC) __GLeeGetProcAddress("glMultiTexGenfvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexGeniEXT = (GLEEPFNGLMULTITEXGENIEXTPROC) __GLeeGetProcAddress("glMultiTexGeniEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexGenivEXT = (GLEEPFNGLMULTITEXGENIVEXTPROC) __GLeeGetProcAddress("glMultiTexGenivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetMultiTexEnvfvEXT = (GLEEPFNGLGETMULTITEXENVFVEXTPROC) __GLeeGetProcAddress("glGetMultiTexEnvfvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetMultiTexEnvivEXT = (GLEEPFNGLGETMULTITEXENVIVEXTPROC) __GLeeGetProcAddress("glGetMultiTexEnvivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetMultiTexGendvEXT = (GLEEPFNGLGETMULTITEXGENDVEXTPROC) __GLeeGetProcAddress("glGetMultiTexGendvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetMultiTexGenfvEXT = (GLEEPFNGLGETMULTITEXGENFVEXTPROC) __GLeeGetProcAddress("glGetMultiTexGenfvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetMultiTexGenivEXT = (GLEEPFNGLGETMULTITEXGENIVEXTPROC) __GLeeGetProcAddress("glGetMultiTexGenivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetFloatIndexedvEXT = (GLEEPFNGLGETFLOATINDEXEDVEXTPROC) __GLeeGetProcAddress("glGetFloatIndexedvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetDoubleIndexedvEXT = (GLEEPFNGLGETDOUBLEINDEXEDVEXTPROC) __GLeeGetProcAddress("glGetDoubleIndexedvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetPointerIndexedvEXT = (GLEEPFNGLGETPOINTERINDEXEDVEXTPROC) __GLeeGetProcAddress("glGetPointerIndexedvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glCompressedTextureImage3DEXT = (GLEEPFNGLCOMPRESSEDTEXTUREIMAGE3DEXTPROC) __GLeeGetProcAddress("glCompressedTextureImage3DEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glCompressedTextureImage2DEXT = (GLEEPFNGLCOMPRESSEDTEXTUREIMAGE2DEXTPROC) __GLeeGetProcAddress("glCompressedTextureImage2DEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glCompressedTextureImage1DEXT = (GLEEPFNGLCOMPRESSEDTEXTUREIMAGE1DEXTPROC) __GLeeGetProcAddress("glCompressedTextureImage1DEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glCompressedTextureSubImage3DEXT = (GLEEPFNGLCOMPRESSEDTEXTURESUBIMAGE3DEXTPROC) __GLeeGetProcAddress("glCompressedTextureSubImage3DEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glCompressedTextureSubImage2DEXT = (GLEEPFNGLCOMPRESSEDTEXTURESUBIMAGE2DEXTPROC) __GLeeGetProcAddress("glCompressedTextureSubImage2DEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glCompressedTextureSubImage1DEXT = (GLEEPFNGLCOMPRESSEDTEXTURESUBIMAGE1DEXTPROC) __GLeeGetProcAddress("glCompressedTextureSubImage1DEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetCompressedTextureImageEXT = (GLEEPFNGLGETCOMPRESSEDTEXTUREIMAGEEXTPROC) __GLeeGetProcAddress("glGetCompressedTextureImageEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glCompressedMultiTexImage3DEXT = (GLEEPFNGLCOMPRESSEDMULTITEXIMAGE3DEXTPROC) __GLeeGetProcAddress("glCompressedMultiTexImage3DEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glCompressedMultiTexImage2DEXT = (GLEEPFNGLCOMPRESSEDMULTITEXIMAGE2DEXTPROC) __GLeeGetProcAddress("glCompressedMultiTexImage2DEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glCompressedMultiTexImage1DEXT = (GLEEPFNGLCOMPRESSEDMULTITEXIMAGE1DEXTPROC) __GLeeGetProcAddress("glCompressedMultiTexImage1DEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glCompressedMultiTexSubImage3DEXT = (GLEEPFNGLCOMPRESSEDMULTITEXSUBIMAGE3DEXTPROC) __GLeeGetProcAddress("glCompressedMultiTexSubImage3DEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glCompressedMultiTexSubImage2DEXT = (GLEEPFNGLCOMPRESSEDMULTITEXSUBIMAGE2DEXTPROC) __GLeeGetProcAddress("glCompressedMultiTexSubImage2DEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glCompressedMultiTexSubImage1DEXT = (GLEEPFNGLCOMPRESSEDMULTITEXSUBIMAGE1DEXTPROC) __GLeeGetProcAddress("glCompressedMultiTexSubImage1DEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetCompressedMultiTexImageEXT = (GLEEPFNGLGETCOMPRESSEDMULTITEXIMAGEEXTPROC) __GLeeGetProcAddress("glGetCompressedMultiTexImageEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glNamedProgramStringEXT = (GLEEPFNGLNAMEDPROGRAMSTRINGEXTPROC) __GLeeGetProcAddress("glNamedProgramStringEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glNamedProgramLocalParameter4dEXT = (GLEEPFNGLNAMEDPROGRAMLOCALPARAMETER4DEXTPROC) __GLeeGetProcAddress("glNamedProgramLocalParameter4dEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glNamedProgramLocalParameter4dvEXT = (GLEEPFNGLNAMEDPROGRAMLOCALPARAMETER4DVEXTPROC) __GLeeGetProcAddress("glNamedProgramLocalParameter4dvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glNamedProgramLocalParameter4fEXT = (GLEEPFNGLNAMEDPROGRAMLOCALPARAMETER4FEXTPROC) __GLeeGetProcAddress("glNamedProgramLocalParameter4fEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glNamedProgramLocalParameter4fvEXT = (GLEEPFNGLNAMEDPROGRAMLOCALPARAMETER4FVEXTPROC) __GLeeGetProcAddress("glNamedProgramLocalParameter4fvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetNamedProgramLocalParameterdvEXT = (GLEEPFNGLGETNAMEDPROGRAMLOCALPARAMETERDVEXTPROC) __GLeeGetProcAddress("glGetNamedProgramLocalParameterdvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetNamedProgramLocalParameterfvEXT = (GLEEPFNGLGETNAMEDPROGRAMLOCALPARAMETERFVEXTPROC) __GLeeGetProcAddress("glGetNamedProgramLocalParameterfvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetNamedProgramivEXT = (GLEEPFNGLGETNAMEDPROGRAMIVEXTPROC) __GLeeGetProcAddress("glGetNamedProgramivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetNamedProgramStringEXT = (GLEEPFNGLGETNAMEDPROGRAMSTRINGEXTPROC) __GLeeGetProcAddress("glGetNamedProgramStringEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glNamedProgramLocalParameters4fvEXT = (GLEEPFNGLNAMEDPROGRAMLOCALPARAMETERS4FVEXTPROC) __GLeeGetProcAddress("glNamedProgramLocalParameters4fvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glNamedProgramLocalParameterI4iEXT = (GLEEPFNGLNAMEDPROGRAMLOCALPARAMETERI4IEXTPROC) __GLeeGetProcAddress("glNamedProgramLocalParameterI4iEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glNamedProgramLocalParameterI4ivEXT = (GLEEPFNGLNAMEDPROGRAMLOCALPARAMETERI4IVEXTPROC) __GLeeGetProcAddress("glNamedProgramLocalParameterI4ivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glNamedProgramLocalParametersI4ivEXT = (GLEEPFNGLNAMEDPROGRAMLOCALPARAMETERSI4IVEXTPROC) __GLeeGetProcAddress("glNamedProgramLocalParametersI4ivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glNamedProgramLocalParameterI4uiEXT = (GLEEPFNGLNAMEDPROGRAMLOCALPARAMETERI4UIEXTPROC) __GLeeGetProcAddress("glNamedProgramLocalParameterI4uiEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glNamedProgramLocalParameterI4uivEXT = (GLEEPFNGLNAMEDPROGRAMLOCALPARAMETERI4UIVEXTPROC) __GLeeGetProcAddress("glNamedProgramLocalParameterI4uivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glNamedProgramLocalParametersI4uivEXT = (GLEEPFNGLNAMEDPROGRAMLOCALPARAMETERSI4UIVEXTPROC) __GLeeGetProcAddress("glNamedProgramLocalParametersI4uivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetNamedProgramLocalParameterIivEXT = (GLEEPFNGLGETNAMEDPROGRAMLOCALPARAMETERIIVEXTPROC) __GLeeGetProcAddress("glGetNamedProgramLocalParameterIivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetNamedProgramLocalParameterIuivEXT = (GLEEPFNGLGETNAMEDPROGRAMLOCALPARAMETERIUIVEXTPROC) __GLeeGetProcAddress("glGetNamedProgramLocalParameterIuivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTextureParameterIivEXT = (GLEEPFNGLTEXTUREPARAMETERIIVEXTPROC) __GLeeGetProcAddress("glTextureParameterIivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTextureParameterIuivEXT = (GLEEPFNGLTEXTUREPARAMETERIUIVEXTPROC) __GLeeGetProcAddress("glTextureParameterIuivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetTextureParameterIivEXT = (GLEEPFNGLGETTEXTUREPARAMETERIIVEXTPROC) __GLeeGetProcAddress("glGetTextureParameterIivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetTextureParameterIuivEXT = (GLEEPFNGLGETTEXTUREPARAMETERIUIVEXTPROC) __GLeeGetProcAddress("glGetTextureParameterIuivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexParameterIivEXT = (GLEEPFNGLMULTITEXPARAMETERIIVEXTPROC) __GLeeGetProcAddress("glMultiTexParameterIivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexParameterIuivEXT = (GLEEPFNGLMULTITEXPARAMETERIUIVEXTPROC) __GLeeGetProcAddress("glMultiTexParameterIuivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetMultiTexParameterIivEXT = (GLEEPFNGLGETMULTITEXPARAMETERIIVEXTPROC) __GLeeGetProcAddress("glGetMultiTexParameterIivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetMultiTexParameterIuivEXT = (GLEEPFNGLGETMULTITEXPARAMETERIUIVEXTPROC) __GLeeGetProcAddress("glGetMultiTexParameterIuivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramUniform1fEXT = (GLEEPFNGLPROGRAMUNIFORM1FEXTPROC) __GLeeGetProcAddress("glProgramUniform1fEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramUniform2fEXT = (GLEEPFNGLPROGRAMUNIFORM2FEXTPROC) __GLeeGetProcAddress("glProgramUniform2fEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramUniform3fEXT = (GLEEPFNGLPROGRAMUNIFORM3FEXTPROC) __GLeeGetProcAddress("glProgramUniform3fEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramUniform4fEXT = (GLEEPFNGLPROGRAMUNIFORM4FEXTPROC) __GLeeGetProcAddress("glProgramUniform4fEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramUniform1iEXT = (GLEEPFNGLPROGRAMUNIFORM1IEXTPROC) __GLeeGetProcAddress("glProgramUniform1iEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramUniform2iEXT = (GLEEPFNGLPROGRAMUNIFORM2IEXTPROC) __GLeeGetProcAddress("glProgramUniform2iEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramUniform3iEXT = (GLEEPFNGLPROGRAMUNIFORM3IEXTPROC) __GLeeGetProcAddress("glProgramUniform3iEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramUniform4iEXT = (GLEEPFNGLPROGRAMUNIFORM4IEXTPROC) __GLeeGetProcAddress("glProgramUniform4iEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramUniform1fvEXT = (GLEEPFNGLPROGRAMUNIFORM1FVEXTPROC) __GLeeGetProcAddress("glProgramUniform1fvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramUniform2fvEXT = (GLEEPFNGLPROGRAMUNIFORM2FVEXTPROC) __GLeeGetProcAddress("glProgramUniform2fvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramUniform3fvEXT = (GLEEPFNGLPROGRAMUNIFORM3FVEXTPROC) __GLeeGetProcAddress("glProgramUniform3fvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramUniform4fvEXT = (GLEEPFNGLPROGRAMUNIFORM4FVEXTPROC) __GLeeGetProcAddress("glProgramUniform4fvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramUniform1ivEXT = (GLEEPFNGLPROGRAMUNIFORM1IVEXTPROC) __GLeeGetProcAddress("glProgramUniform1ivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramUniform2ivEXT = (GLEEPFNGLPROGRAMUNIFORM2IVEXTPROC) __GLeeGetProcAddress("glProgramUniform2ivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramUniform3ivEXT = (GLEEPFNGLPROGRAMUNIFORM3IVEXTPROC) __GLeeGetProcAddress("glProgramUniform3ivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramUniform4ivEXT = (GLEEPFNGLPROGRAMUNIFORM4IVEXTPROC) __GLeeGetProcAddress("glProgramUniform4ivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramUniformMatrix2fvEXT = (GLEEPFNGLPROGRAMUNIFORMMATRIX2FVEXTPROC) __GLeeGetProcAddress("glProgramUniformMatrix2fvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramUniformMatrix3fvEXT = (GLEEPFNGLPROGRAMUNIFORMMATRIX3FVEXTPROC) __GLeeGetProcAddress("glProgramUniformMatrix3fvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramUniformMatrix4fvEXT = (GLEEPFNGLPROGRAMUNIFORMMATRIX4FVEXTPROC) __GLeeGetProcAddress("glProgramUniformMatrix4fvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramUniformMatrix2x3fvEXT = (GLEEPFNGLPROGRAMUNIFORMMATRIX2X3FVEXTPROC) __GLeeGetProcAddress("glProgramUniformMatrix2x3fvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramUniformMatrix3x2fvEXT = (GLEEPFNGLPROGRAMUNIFORMMATRIX3X2FVEXTPROC) __GLeeGetProcAddress("glProgramUniformMatrix3x2fvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramUniformMatrix2x4fvEXT = (GLEEPFNGLPROGRAMUNIFORMMATRIX2X4FVEXTPROC) __GLeeGetProcAddress("glProgramUniformMatrix2x4fvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramUniformMatrix4x2fvEXT = (GLEEPFNGLPROGRAMUNIFORMMATRIX4X2FVEXTPROC) __GLeeGetProcAddress("glProgramUniformMatrix4x2fvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramUniformMatrix3x4fvEXT = (GLEEPFNGLPROGRAMUNIFORMMATRIX3X4FVEXTPROC) __GLeeGetProcAddress("glProgramUniformMatrix3x4fvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramUniformMatrix4x3fvEXT = (GLEEPFNGLPROGRAMUNIFORMMATRIX4X3FVEXTPROC) __GLeeGetProcAddress("glProgramUniformMatrix4x3fvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramUniform1uiEXT = (GLEEPFNGLPROGRAMUNIFORM1UIEXTPROC) __GLeeGetProcAddress("glProgramUniform1uiEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramUniform2uiEXT = (GLEEPFNGLPROGRAMUNIFORM2UIEXTPROC) __GLeeGetProcAddress("glProgramUniform2uiEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramUniform3uiEXT = (GLEEPFNGLPROGRAMUNIFORM3UIEXTPROC) __GLeeGetProcAddress("glProgramUniform3uiEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramUniform4uiEXT = (GLEEPFNGLPROGRAMUNIFORM4UIEXTPROC) __GLeeGetProcAddress("glProgramUniform4uiEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramUniform1uivEXT = (GLEEPFNGLPROGRAMUNIFORM1UIVEXTPROC) __GLeeGetProcAddress("glProgramUniform1uivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramUniform2uivEXT = (GLEEPFNGLPROGRAMUNIFORM2UIVEXTPROC) __GLeeGetProcAddress("glProgramUniform2uivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramUniform3uivEXT = (GLEEPFNGLPROGRAMUNIFORM3UIVEXTPROC) __GLeeGetProcAddress("glProgramUniform3uivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramUniform4uivEXT = (GLEEPFNGLPROGRAMUNIFORM4UIVEXTPROC) __GLeeGetProcAddress("glProgramUniform4uivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glNamedBufferDataEXT = (GLEEPFNGLNAMEDBUFFERDATAEXTPROC) __GLeeGetProcAddress("glNamedBufferDataEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glNamedBufferSubDataEXT = (GLEEPFNGLNAMEDBUFFERSUBDATAEXTPROC) __GLeeGetProcAddress("glNamedBufferSubDataEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMapNamedBufferEXT = (GLEEPFNGLMAPNAMEDBUFFEREXTPROC) __GLeeGetProcAddress("glMapNamedBufferEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glUnmapNamedBufferEXT = (GLEEPFNGLUNMAPNAMEDBUFFEREXTPROC) __GLeeGetProcAddress("glUnmapNamedBufferEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetNamedBufferParameterivEXT = (GLEEPFNGLGETNAMEDBUFFERPARAMETERIVEXTPROC) __GLeeGetProcAddress("glGetNamedBufferParameterivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetNamedBufferPointervEXT = (GLEEPFNGLGETNAMEDBUFFERPOINTERVEXTPROC) __GLeeGetProcAddress("glGetNamedBufferPointervEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetNamedBufferSubDataEXT = (GLEEPFNGLGETNAMEDBUFFERSUBDATAEXTPROC) __GLeeGetProcAddress("glGetNamedBufferSubDataEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTextureBufferEXT = (GLEEPFNGLTEXTUREBUFFEREXTPROC) __GLeeGetProcAddress("glTextureBufferEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexBufferEXT = (GLEEPFNGLMULTITEXBUFFEREXTPROC) __GLeeGetProcAddress("glMultiTexBufferEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glNamedRenderbufferStorageEXT = (GLEEPFNGLNAMEDRENDERBUFFERSTORAGEEXTPROC) __GLeeGetProcAddress("glNamedRenderbufferStorageEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetNamedRenderbufferParameterivEXT = (GLEEPFNGLGETNAMEDRENDERBUFFERPARAMETERIVEXTPROC) __GLeeGetProcAddress("glGetNamedRenderbufferParameterivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glCheckNamedFramebufferStatusEXT = (GLEEPFNGLCHECKNAMEDFRAMEBUFFERSTATUSEXTPROC) __GLeeGetProcAddress("glCheckNamedFramebufferStatusEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glNamedFramebufferTexture1DEXT = (GLEEPFNGLNAMEDFRAMEBUFFERTEXTURE1DEXTPROC) __GLeeGetProcAddress("glNamedFramebufferTexture1DEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glNamedFramebufferTexture2DEXT = (GLEEPFNGLNAMEDFRAMEBUFFERTEXTURE2DEXTPROC) __GLeeGetProcAddress("glNamedFramebufferTexture2DEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glNamedFramebufferTexture3DEXT = (GLEEPFNGLNAMEDFRAMEBUFFERTEXTURE3DEXTPROC) __GLeeGetProcAddress("glNamedFramebufferTexture3DEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glNamedFramebufferRenderbufferEXT = (GLEEPFNGLNAMEDFRAMEBUFFERRENDERBUFFEREXTPROC) __GLeeGetProcAddress("glNamedFramebufferRenderbufferEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetNamedFramebufferAttachmentParameterivEXT = (GLEEPFNGLGETNAMEDFRAMEBUFFERATTACHMENTPARAMETERIVEXTPROC) __GLeeGetProcAddress("glGetNamedFramebufferAttachmentParameterivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGenerateTextureMipmapEXT = (GLEEPFNGLGENERATETEXTUREMIPMAPEXTPROC) __GLeeGetProcAddress("glGenerateTextureMipmapEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGenerateMultiTexMipmapEXT = (GLEEPFNGLGENERATEMULTITEXMIPMAPEXTPROC) __GLeeGetProcAddress("glGenerateMultiTexMipmapEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFramebufferDrawBufferEXT = (GLEEPFNGLFRAMEBUFFERDRAWBUFFEREXTPROC) __GLeeGetProcAddress("glFramebufferDrawBufferEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFramebufferDrawBuffersEXT = (GLEEPFNGLFRAMEBUFFERDRAWBUFFERSEXTPROC) __GLeeGetProcAddress("glFramebufferDrawBuffersEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFramebufferReadBufferEXT = (GLEEPFNGLFRAMEBUFFERREADBUFFEREXTPROC) __GLeeGetProcAddress("glFramebufferReadBufferEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetFramebufferParameterivEXT = (GLEEPFNGLGETFRAMEBUFFERPARAMETERIVEXTPROC) __GLeeGetProcAddress("glGetFramebufferParameterivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glNamedRenderbufferStorageMultisampleEXT = (GLEEPFNGLNAMEDRENDERBUFFERSTORAGEMULTISAMPLEEXTPROC) __GLeeGetProcAddress("glNamedRenderbufferStorageMultisampleEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glNamedRenderbufferStorageMultisampleCoverageEXT = (GLEEPFNGLNAMEDRENDERBUFFERSTORAGEMULTISAMPLECOVERAGEEXTPROC) __GLeeGetProcAddress("glNamedRenderbufferStorageMultisampleCoverageEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glNamedFramebufferTextureEXT = (GLEEPFNGLNAMEDFRAMEBUFFERTEXTUREEXTPROC) __GLeeGetProcAddress("glNamedFramebufferTextureEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glNamedFramebufferTextureLayerEXT = (GLEEPFNGLNAMEDFRAMEBUFFERTEXTURELAYEREXTPROC) __GLeeGetProcAddress("glNamedFramebufferTextureLayerEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glNamedFramebufferTextureFaceEXT = (GLEEPFNGLNAMEDFRAMEBUFFERTEXTUREFACEEXTPROC) __GLeeGetProcAddress("glNamedFramebufferTextureFaceEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTextureRenderbufferEXT = (GLEEPFNGLTEXTURERENDERBUFFEREXTPROC) __GLeeGetProcAddress("glTextureRenderbufferEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glMultiTexRenderbufferEXT = (GLEEPFNGLMULTITEXRENDERBUFFEREXTPROC) __GLeeGetProcAddress("glMultiTexRenderbufferEXT"))!=0) nLinked++;
#endif
    if (nLinked==186) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_EXT_vertex_array_bgra(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_EXT_texture_swizzle(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_NV_explicit_multisample(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_NV_explicit_multisample
    if ((GLeeFuncPtr_glGetMultisamplefvNV = (GLEEPFNGLGETMULTISAMPLEFVNVPROC) __GLeeGetProcAddress("glGetMultisamplefvNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glSampleMaskIndexedNV = (GLEEPFNGLSAMPLEMASKINDEXEDNVPROC) __GLeeGetProcAddress("glSampleMaskIndexedNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glTexRenderbufferNV = (GLEEPFNGLTEXRENDERBUFFERNVPROC) __GLeeGetProcAddress("glTexRenderbufferNV"))!=0) nLinked++;
#endif
    if (nLinked==3) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_NV_transform_feedback2(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_NV_transform_feedback2
    if ((GLeeFuncPtr_glBindTransformFeedbackNV = (GLEEPFNGLBINDTRANSFORMFEEDBACKNVPROC) __GLeeGetProcAddress("glBindTransformFeedbackNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glDeleteTransformFeedbacksNV = (GLEEPFNGLDELETETRANSFORMFEEDBACKSNVPROC) __GLeeGetProcAddress("glDeleteTransformFeedbacksNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGenTransformFeedbacksNV = (GLEEPFNGLGENTRANSFORMFEEDBACKSNVPROC) __GLeeGetProcAddress("glGenTransformFeedbacksNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glIsTransformFeedbackNV = (GLEEPFNGLISTRANSFORMFEEDBACKNVPROC) __GLeeGetProcAddress("glIsTransformFeedbackNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glPauseTransformFeedbackNV = (GLEEPFNGLPAUSETRANSFORMFEEDBACKNVPROC) __GLeeGetProcAddress("glPauseTransformFeedbackNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glResumeTransformFeedbackNV = (GLEEPFNGLRESUMETRANSFORMFEEDBACKNVPROC) __GLeeGetProcAddress("glResumeTransformFeedbackNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glDrawTransformFeedbackNV = (GLEEPFNGLDRAWTRANSFORMFEEDBACKNVPROC) __GLeeGetProcAddress("glDrawTransformFeedbackNV"))!=0) nLinked++;
#endif
    if (nLinked==7) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_SGIX_texture_select(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_INGR_blend_func_separate(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_INGR_blend_func_separate
    if ((GLeeFuncPtr_glBlendFuncSeparateINGR = (GLEEPFNGLBLENDFUNCSEPARATEINGRPROC) __GLeeGetProcAddress("glBlendFuncSeparateINGR"))!=0) nLinked++;
#endif
    if (nLinked==1) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_SGIX_depth_pass_instrument(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_SGIX_igloo_interface(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_SGIX_igloo_interface
    if ((GLeeFuncPtr_glIglooInterfaceSGIX = (GLEEPFNGLIGLOOINTERFACESGIXPROC) __GLeeGetProcAddress("glIglooInterfaceSGIX"))!=0) nLinked++;
#endif
    if (nLinked==1) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_EXT_fragment_lighting(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_EXT_fragment_lighting
    if ((GLeeFuncPtr_glFragmentLightModeliEXT = (GLEEPFNGLFRAGMENTLIGHTMODELIEXTPROC) __GLeeGetProcAddress("glFragmentLightModeliEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFragmentLightModelfEXT = (GLEEPFNGLFRAGMENTLIGHTMODELFEXTPROC) __GLeeGetProcAddress("glFragmentLightModelfEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFragmentLightModelivEXT = (GLEEPFNGLFRAGMENTLIGHTMODELIVEXTPROC) __GLeeGetProcAddress("glFragmentLightModelivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFragmentLightModelfvEXT = (GLEEPFNGLFRAGMENTLIGHTMODELFVEXTPROC) __GLeeGetProcAddress("glFragmentLightModelfvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFragmentLightiEXT = (GLEEPFNGLFRAGMENTLIGHTIEXTPROC) __GLeeGetProcAddress("glFragmentLightiEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFragmentLightfEXT = (GLEEPFNGLFRAGMENTLIGHTFEXTPROC) __GLeeGetProcAddress("glFragmentLightfEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFragmentLightivEXT = (GLEEPFNGLFRAGMENTLIGHTIVEXTPROC) __GLeeGetProcAddress("glFragmentLightivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFragmentLightfvEXT = (GLEEPFNGLFRAGMENTLIGHTFVEXTPROC) __GLeeGetProcAddress("glFragmentLightfvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetFragmentLightivEXT = (GLEEPFNGLGETFRAGMENTLIGHTIVEXTPROC) __GLeeGetProcAddress("glGetFragmentLightivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetFragmentLightfvEXT = (GLEEPFNGLGETFRAGMENTLIGHTFVEXTPROC) __GLeeGetProcAddress("glGetFragmentLightfvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFragmentMaterialfEXT = (GLEEPFNGLFRAGMENTMATERIALFEXTPROC) __GLeeGetProcAddress("glFragmentMaterialfEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFragmentMaterialiEXT = (GLEEPFNGLFRAGMENTMATERIALIEXTPROC) __GLeeGetProcAddress("glFragmentMaterialiEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFragmentMaterialfvEXT = (GLEEPFNGLFRAGMENTMATERIALFVEXTPROC) __GLeeGetProcAddress("glFragmentMaterialfvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFragmentMaterialivEXT = (GLEEPFNGLFRAGMENTMATERIALIVEXTPROC) __GLeeGetProcAddress("glFragmentMaterialivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFragmentColorMaterialEXT = (GLEEPFNGLFRAGMENTCOLORMATERIALEXTPROC) __GLeeGetProcAddress("glFragmentColorMaterialEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetFragmentMaterialfvEXT = (GLEEPFNGLGETFRAGMENTMATERIALFVEXTPROC) __GLeeGetProcAddress("glGetFragmentMaterialfvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetFragmentMaterialivEXT = (GLEEPFNGLGETFRAGMENTMATERIALIVEXTPROC) __GLeeGetProcAddress("glGetFragmentMaterialivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glLightEnviEXT = (GLEEPFNGLLIGHTENVIEXTPROC) __GLeeGetProcAddress("glLightEnviEXT"))!=0) nLinked++;
#endif
    if (nLinked==18) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_EXT_geometry_shader4(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_EXT_geometry_shader4
    if ((GLeeFuncPtr_glProgramParameteriEXT = (GLEEPFNGLPROGRAMPARAMETERIEXTPROC) __GLeeGetProcAddress("glProgramParameteriEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFramebufferTextureEXT = (GLEEPFNGLFRAMEBUFFERTEXTUREEXTPROC) __GLeeGetProcAddress("glFramebufferTextureEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFramebufferTextureLayerEXT = (GLEEPFNGLFRAMEBUFFERTEXTURELAYEREXTPROC) __GLeeGetProcAddress("glFramebufferTextureLayerEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFramebufferTextureFaceEXT = (GLEEPFNGLFRAMEBUFFERTEXTUREFACEEXTPROC) __GLeeGetProcAddress("glFramebufferTextureFaceEXT"))!=0) nLinked++;
#endif
    if (nLinked==4) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_EXT_scene_marker(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_EXT_scene_marker
    if ((GLeeFuncPtr_glBeginSceneEXT = (GLEEPFNGLBEGINSCENEEXTPROC) __GLeeGetProcAddress("glBeginSceneEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glEndSceneEXT = (GLEEPFNGLENDSCENEEXTPROC) __GLeeGetProcAddress("glEndSceneEXT"))!=0) nLinked++;
#endif
    if (nLinked==2) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_EXT_texture_compression_dxt1(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_EXT_texture_env(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_IBM_static_data(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_NV_gpu_program4(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_NV_gpu_program4
    if ((GLeeFuncPtr_glProgramLocalParameterI4iNV = (GLEEPFNGLPROGRAMLOCALPARAMETERI4INVPROC) __GLeeGetProcAddress("glProgramLocalParameterI4iNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramLocalParameterI4ivNV = (GLEEPFNGLPROGRAMLOCALPARAMETERI4IVNVPROC) __GLeeGetProcAddress("glProgramLocalParameterI4ivNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramLocalParametersI4ivNV = (GLEEPFNGLPROGRAMLOCALPARAMETERSI4IVNVPROC) __GLeeGetProcAddress("glProgramLocalParametersI4ivNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramLocalParameterI4uiNV = (GLEEPFNGLPROGRAMLOCALPARAMETERI4UINVPROC) __GLeeGetProcAddress("glProgramLocalParameterI4uiNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramLocalParameterI4uivNV = (GLEEPFNGLPROGRAMLOCALPARAMETERI4UIVNVPROC) __GLeeGetProcAddress("glProgramLocalParameterI4uivNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramLocalParametersI4uivNV = (GLEEPFNGLPROGRAMLOCALPARAMETERSI4UIVNVPROC) __GLeeGetProcAddress("glProgramLocalParametersI4uivNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramEnvParameterI4iNV = (GLEEPFNGLPROGRAMENVPARAMETERI4INVPROC) __GLeeGetProcAddress("glProgramEnvParameterI4iNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramEnvParameterI4ivNV = (GLEEPFNGLPROGRAMENVPARAMETERI4IVNVPROC) __GLeeGetProcAddress("glProgramEnvParameterI4ivNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramEnvParametersI4ivNV = (GLEEPFNGLPROGRAMENVPARAMETERSI4IVNVPROC) __GLeeGetProcAddress("glProgramEnvParametersI4ivNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramEnvParameterI4uiNV = (GLEEPFNGLPROGRAMENVPARAMETERI4UINVPROC) __GLeeGetProcAddress("glProgramEnvParameterI4uiNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramEnvParameterI4uivNV = (GLEEPFNGLPROGRAMENVPARAMETERI4UIVNVPROC) __GLeeGetProcAddress("glProgramEnvParameterI4uivNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glProgramEnvParametersI4uivNV = (GLEEPFNGLPROGRAMENVPARAMETERSI4UIVNVPROC) __GLeeGetProcAddress("glProgramEnvParametersI4uivNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetProgramLocalParameterIivNV = (GLEEPFNGLGETPROGRAMLOCALPARAMETERIIVNVPROC) __GLeeGetProcAddress("glGetProgramLocalParameterIivNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetProgramLocalParameterIuivNV = (GLEEPFNGLGETPROGRAMLOCALPARAMETERIUIVNVPROC) __GLeeGetProcAddress("glGetProgramLocalParameterIuivNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetProgramEnvParameterIivNV = (GLEEPFNGLGETPROGRAMENVPARAMETERIIVNVPROC) __GLeeGetProcAddress("glGetProgramEnvParameterIivNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetProgramEnvParameterIuivNV = (GLEEPFNGLGETPROGRAMENVPARAMETERIUIVNVPROC) __GLeeGetProcAddress("glGetProgramEnvParameterIuivNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFramebufferTextureEXT = (GLEEPFNGLFRAMEBUFFERTEXTUREEXTPROC) __GLeeGetProcAddress("glFramebufferTextureEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFramebufferTextureLayerEXT = (GLEEPFNGLFRAMEBUFFERTEXTURELAYEREXTPROC) __GLeeGetProcAddress("glFramebufferTextureLayerEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFramebufferTextureFaceEXT = (GLEEPFNGLFRAMEBUFFERTEXTUREFACEEXTPROC) __GLeeGetProcAddress("glFramebufferTextureFaceEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttribI2iEXT = (GLEEPFNGLVERTEXATTRIBI2IEXTPROC) __GLeeGetProcAddress("glVertexAttribI2iEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttribI3iEXT = (GLEEPFNGLVERTEXATTRIBI3IEXTPROC) __GLeeGetProcAddress("glVertexAttribI3iEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttribI4iEXT = (GLEEPFNGLVERTEXATTRIBI4IEXTPROC) __GLeeGetProcAddress("glVertexAttribI4iEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttribI1uiEXT = (GLEEPFNGLVERTEXATTRIBI1UIEXTPROC) __GLeeGetProcAddress("glVertexAttribI1uiEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttribI2uiEXT = (GLEEPFNGLVERTEXATTRIBI2UIEXTPROC) __GLeeGetProcAddress("glVertexAttribI2uiEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttribI3uiEXT = (GLEEPFNGLVERTEXATTRIBI3UIEXTPROC) __GLeeGetProcAddress("glVertexAttribI3uiEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttribI4uiEXT = (GLEEPFNGLVERTEXATTRIBI4UIEXTPROC) __GLeeGetProcAddress("glVertexAttribI4uiEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttribI1ivEXT = (GLEEPFNGLVERTEXATTRIBI1IVEXTPROC) __GLeeGetProcAddress("glVertexAttribI1ivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttribI2ivEXT = (GLEEPFNGLVERTEXATTRIBI2IVEXTPROC) __GLeeGetProcAddress("glVertexAttribI2ivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttribI3ivEXT = (GLEEPFNGLVERTEXATTRIBI3IVEXTPROC) __GLeeGetProcAddress("glVertexAttribI3ivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttribI4ivEXT = (GLEEPFNGLVERTEXATTRIBI4IVEXTPROC) __GLeeGetProcAddress("glVertexAttribI4ivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttribI1uivEXT = (GLEEPFNGLVERTEXATTRIBI1UIVEXTPROC) __GLeeGetProcAddress("glVertexAttribI1uivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttribI2uivEXT = (GLEEPFNGLVERTEXATTRIBI2UIVEXTPROC) __GLeeGetProcAddress("glVertexAttribI2uivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttribI3uivEXT = (GLEEPFNGLVERTEXATTRIBI3UIVEXTPROC) __GLeeGetProcAddress("glVertexAttribI3uivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttribI4uivEXT = (GLEEPFNGLVERTEXATTRIBI4UIVEXTPROC) __GLeeGetProcAddress("glVertexAttribI4uivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttribI4bvEXT = (GLEEPFNGLVERTEXATTRIBI4BVEXTPROC) __GLeeGetProcAddress("glVertexAttribI4bvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttribI4svEXT = (GLEEPFNGLVERTEXATTRIBI4SVEXTPROC) __GLeeGetProcAddress("glVertexAttribI4svEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttribI4ubvEXT = (GLEEPFNGLVERTEXATTRIBI4UBVEXTPROC) __GLeeGetProcAddress("glVertexAttribI4ubvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttribI4usvEXT = (GLEEPFNGLVERTEXATTRIBI4USVEXTPROC) __GLeeGetProcAddress("glVertexAttribI4usvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glVertexAttribIPointerEXT = (GLEEPFNGLVERTEXATTRIBIPOINTEREXTPROC) __GLeeGetProcAddress("glVertexAttribIPointerEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetVertexAttribIivEXT = (GLEEPFNGLGETVERTEXATTRIBIIVEXTPROC) __GLeeGetProcAddress("glGetVertexAttribIivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetVertexAttribIuivEXT = (GLEEPFNGLGETVERTEXATTRIBIUIVEXTPROC) __GLeeGetProcAddress("glGetVertexAttribIuivEXT"))!=0) nLinked++;
#endif
    if (nLinked==41) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_OES_byte_coordinates(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_OES_compressed_paletted_texture(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_OES_single_precision(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GL_OES_single_precision
    if ((GLeeFuncPtr_glDepthRangefOES = (GLEEPFNGLDEPTHRANGEFOESPROC) __GLeeGetProcAddress("glDepthRangefOES"))!=0) nLinked++;
    if ((GLeeFuncPtr_glFrustumfOES = (GLEEPFNGLFRUSTUMFOESPROC) __GLeeGetProcAddress("glFrustumfOES"))!=0) nLinked++;
    if ((GLeeFuncPtr_glOrthofOES = (GLEEPFNGLORTHOFOESPROC) __GLeeGetProcAddress("glOrthofOES"))!=0) nLinked++;
    if ((GLeeFuncPtr_glClipPlanefOES = (GLEEPFNGLCLIPPLANEFOESPROC) __GLeeGetProcAddress("glClipPlanefOES"))!=0) nLinked++;
    if ((GLeeFuncPtr_glGetClipPlanefOES = (GLEEPFNGLGETCLIPPLANEFOESPROC) __GLeeGetProcAddress("glGetClipPlanefOES"))!=0) nLinked++;
#ifndef GL_VERSION_ES_CM_1_1
    if ((GLeeFuncPtr_glClearDepthfOES = (GLEEPFNGLCLEARDEPTHFOESPROC) __GLeeGetProcAddress("glClearDepthfOES"))!=0) nLinked++;
#endif
#endif
    if (nLinked==6) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GL_SGIX_pixel_texture_bits(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GL_SGIX_texture_range(void) {return GLEE_LINK_COMPLETE;}

GLEE_LINK_FUNCTION __GLeeGLLoadFunction[322];

void initGLLoadFunctions(void)
{
    __GLeeGLLoadFunction[0]=__GLeeLink_GL_VERSION_1_2;
    __GLeeGLLoadFunction[1]=__GLeeLink_GL_ARB_imaging;
    __GLeeGLLoadFunction[2]=__GLeeLink_GL_VERSION_1_3;
    __GLeeGLLoadFunction[3]=__GLeeLink_GL_VERSION_1_4;
    __GLeeGLLoadFunction[4]=__GLeeLink_GL_VERSION_1_5;
    __GLeeGLLoadFunction[5]=__GLeeLink_GL_VERSION_2_0;
    __GLeeGLLoadFunction[6]=__GLeeLink_GL_VERSION_2_1;
    __GLeeGLLoadFunction[7]=__GLeeLink_GL_VERSION_3_0;
    __GLeeGLLoadFunction[8]=__GLeeLink_GL_ARB_multitexture;
    __GLeeGLLoadFunction[9]=__GLeeLink_GL_ARB_transpose_matrix;
    __GLeeGLLoadFunction[10]=__GLeeLink_GL_ARB_multisample;
    __GLeeGLLoadFunction[11]=__GLeeLink_GL_ARB_texture_env_add;
    __GLeeGLLoadFunction[12]=__GLeeLink_GL_ARB_texture_cube_map;
    __GLeeGLLoadFunction[13]=__GLeeLink_GL_ARB_texture_compression;
    __GLeeGLLoadFunction[14]=__GLeeLink_GL_ARB_texture_border_clamp;
    __GLeeGLLoadFunction[15]=__GLeeLink_GL_ARB_point_parameters;
    __GLeeGLLoadFunction[16]=__GLeeLink_GL_ARB_vertex_blend;
    __GLeeGLLoadFunction[17]=__GLeeLink_GL_ARB_matrix_palette;
    __GLeeGLLoadFunction[18]=__GLeeLink_GL_ARB_texture_env_combine;
    __GLeeGLLoadFunction[19]=__GLeeLink_GL_ARB_texture_env_crossbar;
    __GLeeGLLoadFunction[20]=__GLeeLink_GL_ARB_texture_env_dot3;
    __GLeeGLLoadFunction[21]=__GLeeLink_GL_ARB_texture_mirrored_repeat;
    __GLeeGLLoadFunction[22]=__GLeeLink_GL_ARB_depth_texture;
    __GLeeGLLoadFunction[23]=__GLeeLink_GL_ARB_shadow;
    __GLeeGLLoadFunction[24]=__GLeeLink_GL_ARB_shadow_ambient;
    __GLeeGLLoadFunction[25]=__GLeeLink_GL_ARB_window_pos;
    __GLeeGLLoadFunction[26]=__GLeeLink_GL_ARB_vertex_program;
    __GLeeGLLoadFunction[27]=__GLeeLink_GL_ARB_fragment_program;
    __GLeeGLLoadFunction[28]=__GLeeLink_GL_ARB_vertex_buffer_object;
    __GLeeGLLoadFunction[29]=__GLeeLink_GL_ARB_occlusion_query;
    __GLeeGLLoadFunction[30]=__GLeeLink_GL_ARB_shader_objects;
    __GLeeGLLoadFunction[31]=__GLeeLink_GL_ARB_vertex_shader;
    __GLeeGLLoadFunction[32]=__GLeeLink_GL_ARB_fragment_shader;
    __GLeeGLLoadFunction[33]=__GLeeLink_GL_ARB_shading_language_100;
    __GLeeGLLoadFunction[34]=__GLeeLink_GL_ARB_texture_non_power_of_two;
    __GLeeGLLoadFunction[35]=__GLeeLink_GL_ARB_point_sprite;
    __GLeeGLLoadFunction[36]=__GLeeLink_GL_ARB_fragment_program_shadow;
    __GLeeGLLoadFunction[37]=__GLeeLink_GL_ARB_draw_buffers;
    __GLeeGLLoadFunction[38]=__GLeeLink_GL_ARB_texture_rectangle;
    __GLeeGLLoadFunction[39]=__GLeeLink_GL_ARB_color_buffer_float;
    __GLeeGLLoadFunction[40]=__GLeeLink_GL_ARB_half_float_pixel;
    __GLeeGLLoadFunction[41]=__GLeeLink_GL_ARB_texture_float;
    __GLeeGLLoadFunction[42]=__GLeeLink_GL_ARB_pixel_buffer_object;
    __GLeeGLLoadFunction[43]=__GLeeLink_GL_ARB_depth_buffer_float;
    __GLeeGLLoadFunction[44]=__GLeeLink_GL_ARB_draw_instanced;
    __GLeeGLLoadFunction[45]=__GLeeLink_GL_ARB_framebuffer_object;
    __GLeeGLLoadFunction[46]=__GLeeLink_GL_ARB_framebuffer_sRGB;
    __GLeeGLLoadFunction[47]=__GLeeLink_GL_ARB_geometry_shader4;
    __GLeeGLLoadFunction[48]=__GLeeLink_GL_ARB_half_float_vertex;
    __GLeeGLLoadFunction[49]=__GLeeLink_GL_ARB_instanced_arrays;
    __GLeeGLLoadFunction[50]=__GLeeLink_GL_ARB_map_buffer_range;
    __GLeeGLLoadFunction[51]=__GLeeLink_GL_ARB_texture_buffer_object;
    __GLeeGLLoadFunction[52]=__GLeeLink_GL_ARB_texture_compression_rgtc;
    __GLeeGLLoadFunction[53]=__GLeeLink_GL_ARB_texture_rg;
    __GLeeGLLoadFunction[54]=__GLeeLink_GL_ARB_vertex_array_object;
    __GLeeGLLoadFunction[55]=__GLeeLink_GL_EXT_abgr;
    __GLeeGLLoadFunction[56]=__GLeeLink_GL_EXT_blend_color;
    __GLeeGLLoadFunction[57]=__GLeeLink_GL_EXT_polygon_offset;
    __GLeeGLLoadFunction[58]=__GLeeLink_GL_EXT_texture;
    __GLeeGLLoadFunction[59]=__GLeeLink_GL_EXT_texture3D;
    __GLeeGLLoadFunction[60]=__GLeeLink_GL_SGIS_texture_filter4;
    __GLeeGLLoadFunction[61]=__GLeeLink_GL_EXT_subtexture;
    __GLeeGLLoadFunction[62]=__GLeeLink_GL_EXT_copy_texture;
    __GLeeGLLoadFunction[63]=__GLeeLink_GL_EXT_histogram;
    __GLeeGLLoadFunction[64]=__GLeeLink_GL_EXT_convolution;
    __GLeeGLLoadFunction[65]=__GLeeLink_GL_SGI_color_matrix;
    __GLeeGLLoadFunction[66]=__GLeeLink_GL_SGI_color_table;
    __GLeeGLLoadFunction[67]=__GLeeLink_GL_SGIS_pixel_texture;
    __GLeeGLLoadFunction[68]=__GLeeLink_GL_SGIX_pixel_texture;
    __GLeeGLLoadFunction[69]=__GLeeLink_GL_SGIS_texture4D;
    __GLeeGLLoadFunction[70]=__GLeeLink_GL_SGI_texture_color_table;
    __GLeeGLLoadFunction[71]=__GLeeLink_GL_EXT_cmyka;
    __GLeeGLLoadFunction[72]=__GLeeLink_GL_EXT_texture_object;
    __GLeeGLLoadFunction[73]=__GLeeLink_GL_SGIS_detail_texture;
    __GLeeGLLoadFunction[74]=__GLeeLink_GL_SGIS_sharpen_texture;
    __GLeeGLLoadFunction[75]=__GLeeLink_GL_EXT_packed_pixels;
    __GLeeGLLoadFunction[76]=__GLeeLink_GL_SGIS_texture_lod;
    __GLeeGLLoadFunction[77]=__GLeeLink_GL_SGIS_multisample;
    __GLeeGLLoadFunction[78]=__GLeeLink_GL_EXT_rescale_normal;
    __GLeeGLLoadFunction[79]=__GLeeLink_GL_EXT_vertex_array;
    __GLeeGLLoadFunction[80]=__GLeeLink_GL_EXT_misc_attribute;
    __GLeeGLLoadFunction[81]=__GLeeLink_GL_SGIS_generate_mipmap;
    __GLeeGLLoadFunction[82]=__GLeeLink_GL_SGIX_clipmap;
    __GLeeGLLoadFunction[83]=__GLeeLink_GL_SGIX_shadow;
    __GLeeGLLoadFunction[84]=__GLeeLink_GL_SGIS_texture_edge_clamp;
    __GLeeGLLoadFunction[85]=__GLeeLink_GL_SGIS_texture_border_clamp;
    __GLeeGLLoadFunction[86]=__GLeeLink_GL_EXT_blend_minmax;
    __GLeeGLLoadFunction[87]=__GLeeLink_GL_EXT_blend_subtract;
    __GLeeGLLoadFunction[88]=__GLeeLink_GL_EXT_blend_logic_op;
    __GLeeGLLoadFunction[89]=__GLeeLink_GL_SGIX_interlace;
    __GLeeGLLoadFunction[90]=__GLeeLink_GL_SGIX_pixel_tiles;
    __GLeeGLLoadFunction[91]=__GLeeLink_GL_SGIS_texture_select;
    __GLeeGLLoadFunction[92]=__GLeeLink_GL_SGIX_sprite;
    __GLeeGLLoadFunction[93]=__GLeeLink_GL_SGIX_texture_multi_buffer;
    __GLeeGLLoadFunction[94]=__GLeeLink_GL_EXT_point_parameters;
    __GLeeGLLoadFunction[95]=__GLeeLink_GL_SGIS_point_parameters;
    __GLeeGLLoadFunction[96]=__GLeeLink_GL_SGIX_instruments;
    __GLeeGLLoadFunction[97]=__GLeeLink_GL_SGIX_texture_scale_bias;
    __GLeeGLLoadFunction[98]=__GLeeLink_GL_SGIX_framezoom;
    __GLeeGLLoadFunction[99]=__GLeeLink_GL_SGIX_tag_sample_buffer;
    __GLeeGLLoadFunction[100]=__GLeeLink_GL_FfdMaskSGIX;
    __GLeeGLLoadFunction[101]=__GLeeLink_GL_SGIX_polynomial_ffd;
    __GLeeGLLoadFunction[102]=__GLeeLink_GL_SGIX_reference_plane;
    __GLeeGLLoadFunction[103]=__GLeeLink_GL_SGIX_flush_raster;
    __GLeeGLLoadFunction[104]=__GLeeLink_GL_SGIX_depth_texture;
    __GLeeGLLoadFunction[105]=__GLeeLink_GL_SGIS_fog_function;
    __GLeeGLLoadFunction[106]=__GLeeLink_GL_SGIX_fog_offset;
    __GLeeGLLoadFunction[107]=__GLeeLink_GL_HP_image_transform;
    __GLeeGLLoadFunction[108]=__GLeeLink_GL_HP_convolution_border_modes;
    __GLeeGLLoadFunction[109]=__GLeeLink_GL_INGR_palette_buffer;
    __GLeeGLLoadFunction[110]=__GLeeLink_GL_SGIX_texture_add_env;
    __GLeeGLLoadFunction[111]=__GLeeLink_GL_EXT_color_subtable;
    __GLeeGLLoadFunction[112]=__GLeeLink_GL_PGI_vertex_hints;
    __GLeeGLLoadFunction[113]=__GLeeLink_GL_PGI_misc_hints;
    __GLeeGLLoadFunction[114]=__GLeeLink_GL_EXT_paletted_texture;
    __GLeeGLLoadFunction[115]=__GLeeLink_GL_EXT_clip_volume_hint;
    __GLeeGLLoadFunction[116]=__GLeeLink_GL_SGIX_list_priority;
    __GLeeGLLoadFunction[117]=__GLeeLink_GL_SGIX_ir_instrument1;
    __GLeeGLLoadFunction[118]=__GLeeLink_GL_SGIX_calligraphic_fragment;
    __GLeeGLLoadFunction[119]=__GLeeLink_GL_SGIX_texture_lod_bias;
    __GLeeGLLoadFunction[120]=__GLeeLink_GL_SGIX_shadow_ambient;
    __GLeeGLLoadFunction[121]=__GLeeLink_GL_EXT_index_texture;
    __GLeeGLLoadFunction[122]=__GLeeLink_GL_EXT_index_material;
    __GLeeGLLoadFunction[123]=__GLeeLink_GL_EXT_index_func;
    __GLeeGLLoadFunction[124]=__GLeeLink_GL_EXT_index_array_formats;
    __GLeeGLLoadFunction[125]=__GLeeLink_GL_EXT_compiled_vertex_array;
    __GLeeGLLoadFunction[126]=__GLeeLink_GL_EXT_cull_vertex;
    __GLeeGLLoadFunction[127]=__GLeeLink_GL_SGIX_ycrcb;
    __GLeeGLLoadFunction[128]=__GLeeLink_GL_SGIX_fragment_lighting;
    __GLeeGLLoadFunction[129]=__GLeeLink_GL_IBM_rasterpos_clip;
    __GLeeGLLoadFunction[130]=__GLeeLink_GL_HP_texture_lighting;
    __GLeeGLLoadFunction[131]=__GLeeLink_GL_EXT_draw_range_elements;
    __GLeeGLLoadFunction[132]=__GLeeLink_GL_WIN_phong_shading;
    __GLeeGLLoadFunction[133]=__GLeeLink_GL_WIN_specular_fog;
    __GLeeGLLoadFunction[134]=__GLeeLink_GL_EXT_light_texture;
    __GLeeGLLoadFunction[135]=__GLeeLink_GL_SGIX_blend_alpha_minmax;
    __GLeeGLLoadFunction[136]=__GLeeLink_GL_SGIX_impact_pixel_texture;
    __GLeeGLLoadFunction[137]=__GLeeLink_GL_EXT_bgra;
    __GLeeGLLoadFunction[138]=__GLeeLink_GL_SGIX_async;
    __GLeeGLLoadFunction[139]=__GLeeLink_GL_SGIX_async_pixel;
    __GLeeGLLoadFunction[140]=__GLeeLink_GL_SGIX_async_histogram;
    __GLeeGLLoadFunction[141]=__GLeeLink_GL_INTEL_texture_scissor;
    __GLeeGLLoadFunction[142]=__GLeeLink_GL_INTEL_parallel_arrays;
    __GLeeGLLoadFunction[143]=__GLeeLink_GL_HP_occlusion_test;
    __GLeeGLLoadFunction[144]=__GLeeLink_GL_EXT_pixel_transform;
    __GLeeGLLoadFunction[145]=__GLeeLink_GL_EXT_pixel_transform_color_table;
    __GLeeGLLoadFunction[146]=__GLeeLink_GL_EXT_shared_texture_palette;
    __GLeeGLLoadFunction[147]=__GLeeLink_GL_EXT_separate_specular_color;
    __GLeeGLLoadFunction[148]=__GLeeLink_GL_EXT_secondary_color;
    __GLeeGLLoadFunction[149]=__GLeeLink_GL_EXT_texture_perturb_normal;
    __GLeeGLLoadFunction[150]=__GLeeLink_GL_EXT_multi_draw_arrays;
    __GLeeGLLoadFunction[151]=__GLeeLink_GL_EXT_fog_coord;
    __GLeeGLLoadFunction[152]=__GLeeLink_GL_REND_screen_coordinates;
    __GLeeGLLoadFunction[153]=__GLeeLink_GL_EXT_coordinate_frame;
    __GLeeGLLoadFunction[154]=__GLeeLink_GL_EXT_texture_env_combine;
    __GLeeGLLoadFunction[155]=__GLeeLink_GL_APPLE_specular_vector;
    __GLeeGLLoadFunction[156]=__GLeeLink_GL_APPLE_transform_hint;
    __GLeeGLLoadFunction[157]=__GLeeLink_GL_SGIX_fog_scale;
    __GLeeGLLoadFunction[158]=__GLeeLink_GL_SUNX_constant_data;
    __GLeeGLLoadFunction[159]=__GLeeLink_GL_SUN_global_alpha;
    __GLeeGLLoadFunction[160]=__GLeeLink_GL_SUN_triangle_list;
    __GLeeGLLoadFunction[161]=__GLeeLink_GL_SUN_vertex;
    __GLeeGLLoadFunction[162]=__GLeeLink_GL_EXT_blend_func_separate;
    __GLeeGLLoadFunction[163]=__GLeeLink_GL_INGR_color_clamp;
    __GLeeGLLoadFunction[164]=__GLeeLink_GL_INGR_interlace_read;
    __GLeeGLLoadFunction[165]=__GLeeLink_GL_EXT_stencil_wrap;
    __GLeeGLLoadFunction[166]=__GLeeLink_GL_EXT_422_pixels;
    __GLeeGLLoadFunction[167]=__GLeeLink_GL_NV_texgen_reflection;
    __GLeeGLLoadFunction[168]=__GLeeLink_GL_EXT_texture_cube_map;
    __GLeeGLLoadFunction[169]=__GLeeLink_GL_SUN_convolution_border_modes;
    __GLeeGLLoadFunction[170]=__GLeeLink_GL_EXT_texture_env_add;
    __GLeeGLLoadFunction[171]=__GLeeLink_GL_EXT_texture_lod_bias;
    __GLeeGLLoadFunction[172]=__GLeeLink_GL_EXT_texture_filter_anisotropic;
    __GLeeGLLoadFunction[173]=__GLeeLink_GL_EXT_vertex_weighting;
    __GLeeGLLoadFunction[174]=__GLeeLink_GL_NV_light_max_exponent;
    __GLeeGLLoadFunction[175]=__GLeeLink_GL_NV_vertex_array_range;
    __GLeeGLLoadFunction[176]=__GLeeLink_GL_NV_register_combiners;
    __GLeeGLLoadFunction[177]=__GLeeLink_GL_NV_fog_distance;
    __GLeeGLLoadFunction[178]=__GLeeLink_GL_NV_texgen_emboss;
    __GLeeGLLoadFunction[179]=__GLeeLink_GL_NV_blend_square;
    __GLeeGLLoadFunction[180]=__GLeeLink_GL_NV_texture_env_combine4;
    __GLeeGLLoadFunction[181]=__GLeeLink_GL_MESA_resize_buffers;
    __GLeeGLLoadFunction[182]=__GLeeLink_GL_MESA_window_pos;
    __GLeeGLLoadFunction[183]=__GLeeLink_GL_EXT_texture_compression_s3tc;
    __GLeeGLLoadFunction[184]=__GLeeLink_GL_IBM_cull_vertex;
    __GLeeGLLoadFunction[185]=__GLeeLink_GL_IBM_multimode_draw_arrays;
    __GLeeGLLoadFunction[186]=__GLeeLink_GL_IBM_vertex_array_lists;
    __GLeeGLLoadFunction[187]=__GLeeLink_GL_SGIX_subsample;
    __GLeeGLLoadFunction[188]=__GLeeLink_GL_SGIX_ycrcb_subsample;
    __GLeeGLLoadFunction[189]=__GLeeLink_GL_SGIX_ycrcba;
    __GLeeGLLoadFunction[190]=__GLeeLink_GL_SGI_depth_pass_instrument;
    __GLeeGLLoadFunction[191]=__GLeeLink_GL_3DFX_texture_compression_FXT1;
    __GLeeGLLoadFunction[192]=__GLeeLink_GL_3DFX_multisample;
    __GLeeGLLoadFunction[193]=__GLeeLink_GL_3DFX_tbuffer;
    __GLeeGLLoadFunction[194]=__GLeeLink_GL_EXT_multisample;
    __GLeeGLLoadFunction[195]=__GLeeLink_GL_SGIX_vertex_preclip;
    __GLeeGLLoadFunction[196]=__GLeeLink_GL_SGIX_convolution_accuracy;
    __GLeeGLLoadFunction[197]=__GLeeLink_GL_SGIX_resample;
    __GLeeGLLoadFunction[198]=__GLeeLink_GL_SGIS_point_line_texgen;
    __GLeeGLLoadFunction[199]=__GLeeLink_GL_SGIS_texture_color_mask;
    __GLeeGLLoadFunction[200]=__GLeeLink_GL_EXT_texture_env_dot3;
    __GLeeGLLoadFunction[201]=__GLeeLink_GL_ATI_texture_mirror_once;
    __GLeeGLLoadFunction[202]=__GLeeLink_GL_NV_fence;
    __GLeeGLLoadFunction[203]=__GLeeLink_GL_IBM_texture_mirrored_repeat;
    __GLeeGLLoadFunction[204]=__GLeeLink_GL_NV_evaluators;
    __GLeeGLLoadFunction[205]=__GLeeLink_GL_NV_packed_depth_stencil;
    __GLeeGLLoadFunction[206]=__GLeeLink_GL_NV_register_combiners2;
    __GLeeGLLoadFunction[207]=__GLeeLink_GL_NV_texture_compression_vtc;
    __GLeeGLLoadFunction[208]=__GLeeLink_GL_NV_texture_rectangle;
    __GLeeGLLoadFunction[209]=__GLeeLink_GL_NV_texture_shader;
    __GLeeGLLoadFunction[210]=__GLeeLink_GL_NV_texture_shader2;
    __GLeeGLLoadFunction[211]=__GLeeLink_GL_NV_vertex_array_range2;
    __GLeeGLLoadFunction[212]=__GLeeLink_GL_NV_vertex_program;
    __GLeeGLLoadFunction[213]=__GLeeLink_GL_SGIX_texture_coordinate_clamp;
    __GLeeGLLoadFunction[214]=__GLeeLink_GL_SGIX_scalebias_hint;
    __GLeeGLLoadFunction[215]=__GLeeLink_GL_OML_interlace;
    __GLeeGLLoadFunction[216]=__GLeeLink_GL_OML_subsample;
    __GLeeGLLoadFunction[217]=__GLeeLink_GL_OML_resample;
    __GLeeGLLoadFunction[218]=__GLeeLink_GL_NV_copy_depth_to_color;
    __GLeeGLLoadFunction[219]=__GLeeLink_GL_ATI_envmap_bumpmap;
    __GLeeGLLoadFunction[220]=__GLeeLink_GL_ATI_fragment_shader;
    __GLeeGLLoadFunction[221]=__GLeeLink_GL_ATI_pn_triangles;
    __GLeeGLLoadFunction[222]=__GLeeLink_GL_ATI_vertex_array_object;
    __GLeeGLLoadFunction[223]=__GLeeLink_GL_EXT_vertex_shader;
    __GLeeGLLoadFunction[224]=__GLeeLink_GL_ATI_vertex_streams;
    __GLeeGLLoadFunction[225]=__GLeeLink_GL_ATI_element_array;
    __GLeeGLLoadFunction[226]=__GLeeLink_GL_SUN_mesh_array;
    __GLeeGLLoadFunction[227]=__GLeeLink_GL_SUN_slice_accum;
    __GLeeGLLoadFunction[228]=__GLeeLink_GL_NV_multisample_filter_hint;
    __GLeeGLLoadFunction[229]=__GLeeLink_GL_NV_depth_clamp;
    __GLeeGLLoadFunction[230]=__GLeeLink_GL_NV_occlusion_query;
    __GLeeGLLoadFunction[231]=__GLeeLink_GL_NV_point_sprite;
    __GLeeGLLoadFunction[232]=__GLeeLink_GL_NV_texture_shader3;
    __GLeeGLLoadFunction[233]=__GLeeLink_GL_NV_vertex_program1_1;
    __GLeeGLLoadFunction[234]=__GLeeLink_GL_EXT_shadow_funcs;
    __GLeeGLLoadFunction[235]=__GLeeLink_GL_EXT_stencil_two_side;
    __GLeeGLLoadFunction[236]=__GLeeLink_GL_ATI_text_fragment_shader;
    __GLeeGLLoadFunction[237]=__GLeeLink_GL_APPLE_client_storage;
    __GLeeGLLoadFunction[238]=__GLeeLink_GL_APPLE_element_array;
    __GLeeGLLoadFunction[239]=__GLeeLink_GL_APPLE_fence;
    __GLeeGLLoadFunction[240]=__GLeeLink_GL_APPLE_vertex_array_object;
    __GLeeGLLoadFunction[241]=__GLeeLink_GL_APPLE_vertex_array_range;
    __GLeeGLLoadFunction[242]=__GLeeLink_GL_APPLE_ycbcr_422;
    __GLeeGLLoadFunction[243]=__GLeeLink_GL_S3_s3tc;
    __GLeeGLLoadFunction[244]=__GLeeLink_GL_ATI_draw_buffers;
    __GLeeGLLoadFunction[245]=__GLeeLink_GL_ATI_pixel_format_float;
    __GLeeGLLoadFunction[246]=__GLeeLink_GL_ATI_texture_env_combine3;
    __GLeeGLLoadFunction[247]=__GLeeLink_GL_ATI_texture_float;
    __GLeeGLLoadFunction[248]=__GLeeLink_GL_NV_float_buffer;
    __GLeeGLLoadFunction[249]=__GLeeLink_GL_NV_fragment_program;
    __GLeeGLLoadFunction[250]=__GLeeLink_GL_NV_half_float;
    __GLeeGLLoadFunction[251]=__GLeeLink_GL_NV_pixel_data_range;
    __GLeeGLLoadFunction[252]=__GLeeLink_GL_NV_primitive_restart;
    __GLeeGLLoadFunction[253]=__GLeeLink_GL_NV_texture_expand_normal;
    __GLeeGLLoadFunction[254]=__GLeeLink_GL_NV_vertex_program2;
    __GLeeGLLoadFunction[255]=__GLeeLink_GL_ATI_map_object_buffer;
    __GLeeGLLoadFunction[256]=__GLeeLink_GL_ATI_separate_stencil;
    __GLeeGLLoadFunction[257]=__GLeeLink_GL_ATI_vertex_attrib_array_object;
    __GLeeGLLoadFunction[258]=__GLeeLink_GL_OES_read_format;
    __GLeeGLLoadFunction[259]=__GLeeLink_GL_EXT_depth_bounds_test;
    __GLeeGLLoadFunction[260]=__GLeeLink_GL_EXT_texture_mirror_clamp;
    __GLeeGLLoadFunction[261]=__GLeeLink_GL_EXT_blend_equation_separate;
    __GLeeGLLoadFunction[262]=__GLeeLink_GL_MESA_pack_invert;
    __GLeeGLLoadFunction[263]=__GLeeLink_GL_MESA_ycbcr_texture;
    __GLeeGLLoadFunction[264]=__GLeeLink_GL_EXT_pixel_buffer_object;
    __GLeeGLLoadFunction[265]=__GLeeLink_GL_NV_fragment_program_option;
    __GLeeGLLoadFunction[266]=__GLeeLink_GL_NV_fragment_program2;
    __GLeeGLLoadFunction[267]=__GLeeLink_GL_NV_vertex_program2_option;
    __GLeeGLLoadFunction[268]=__GLeeLink_GL_NV_vertex_program3;
    __GLeeGLLoadFunction[269]=__GLeeLink_GL_EXT_framebuffer_object;
    __GLeeGLLoadFunction[270]=__GLeeLink_GL_GREMEDY_string_marker;
    __GLeeGLLoadFunction[271]=__GLeeLink_GL_EXT_packed_depth_stencil;
    __GLeeGLLoadFunction[272]=__GLeeLink_GL_EXT_stencil_clear_tag;
    __GLeeGLLoadFunction[273]=__GLeeLink_GL_EXT_texture_sRGB;
    __GLeeGLLoadFunction[274]=__GLeeLink_GL_EXT_framebuffer_blit;
    __GLeeGLLoadFunction[275]=__GLeeLink_GL_EXT_framebuffer_multisample;
    __GLeeGLLoadFunction[276]=__GLeeLink_GL_MESAX_texture_stack;
    __GLeeGLLoadFunction[277]=__GLeeLink_GL_EXT_timer_query;
    __GLeeGLLoadFunction[278]=__GLeeLink_GL_EXT_gpu_program_parameters;
    __GLeeGLLoadFunction[279]=__GLeeLink_GL_APPLE_flush_buffer_range;
    __GLeeGLLoadFunction[280]=__GLeeLink_GL_EXT_gpu_shader4;
    __GLeeGLLoadFunction[281]=__GLeeLink_GL_EXT_draw_instanced;
    __GLeeGLLoadFunction[282]=__GLeeLink_GL_EXT_packed_float;
    __GLeeGLLoadFunction[283]=__GLeeLink_GL_EXT_texture_array;
    __GLeeGLLoadFunction[284]=__GLeeLink_GL_EXT_texture_buffer_object;
    __GLeeGLLoadFunction[285]=__GLeeLink_GL_EXT_texture_compression_latc;
    __GLeeGLLoadFunction[286]=__GLeeLink_GL_EXT_texture_compression_rgtc;
    __GLeeGLLoadFunction[287]=__GLeeLink_GL_EXT_texture_shared_exponent;
    __GLeeGLLoadFunction[288]=__GLeeLink_GL_NV_depth_buffer_float;
    __GLeeGLLoadFunction[289]=__GLeeLink_GL_NV_framebuffer_multisample_coverage;
    __GLeeGLLoadFunction[290]=__GLeeLink_GL_EXT_framebuffer_sRGB;
    __GLeeGLLoadFunction[291]=__GLeeLink_GL_NV_geometry_shader4;
    __GLeeGLLoadFunction[292]=__GLeeLink_GL_NV_parameter_buffer_object;
    __GLeeGLLoadFunction[293]=__GLeeLink_GL_EXT_draw_buffers2;
    __GLeeGLLoadFunction[294]=__GLeeLink_GL_NV_transform_feedback;
    __GLeeGLLoadFunction[295]=__GLeeLink_GL_EXT_bindable_uniform;
    __GLeeGLLoadFunction[296]=__GLeeLink_GL_EXT_texture_integer;
    __GLeeGLLoadFunction[297]=__GLeeLink_GL_GREMEDY_frame_terminator;
    __GLeeGLLoadFunction[298]=__GLeeLink_GL_NV_conditional_render;
    __GLeeGLLoadFunction[299]=__GLeeLink_GL_NV_present_video;
    __GLeeGLLoadFunction[300]=__GLeeLink_GL_EXT_transform_feedback;
    __GLeeGLLoadFunction[301]=__GLeeLink_GL_EXT_direct_state_access;
    __GLeeGLLoadFunction[302]=__GLeeLink_GL_EXT_vertex_array_bgra;
    __GLeeGLLoadFunction[303]=__GLeeLink_GL_EXT_texture_swizzle;
    __GLeeGLLoadFunction[304]=__GLeeLink_GL_NV_explicit_multisample;
    __GLeeGLLoadFunction[305]=__GLeeLink_GL_NV_transform_feedback2;
    __GLeeGLLoadFunction[306]=__GLeeLink_GL_SGIX_texture_select;
    __GLeeGLLoadFunction[307]=__GLeeLink_GL_INGR_blend_func_separate;
    __GLeeGLLoadFunction[308]=__GLeeLink_GL_SGIX_depth_pass_instrument;
    __GLeeGLLoadFunction[309]=__GLeeLink_GL_SGIX_igloo_interface;
    __GLeeGLLoadFunction[310]=__GLeeLink_GL_EXT_fragment_lighting;
    __GLeeGLLoadFunction[311]=__GLeeLink_GL_EXT_geometry_shader4;
    __GLeeGLLoadFunction[312]=__GLeeLink_GL_EXT_scene_marker;
    __GLeeGLLoadFunction[313]=__GLeeLink_GL_EXT_texture_compression_dxt1;
    __GLeeGLLoadFunction[314]=__GLeeLink_GL_EXT_texture_env;
    __GLeeGLLoadFunction[315]=__GLeeLink_GL_IBM_static_data;
    __GLeeGLLoadFunction[316]=__GLeeLink_GL_NV_gpu_program4;
    __GLeeGLLoadFunction[317]=__GLeeLink_GL_OES_byte_coordinates;
    __GLeeGLLoadFunction[318]=__GLeeLink_GL_OES_compressed_paletted_texture;
    __GLeeGLLoadFunction[319]=__GLeeLink_GL_OES_single_precision;
    __GLeeGLLoadFunction[320]=__GLeeLink_GL_SGIX_pixel_texture_bits;
    __GLeeGLLoadFunction[321]=__GLeeLink_GL_SGIX_texture_range;
}

#ifdef WIN32
GLuint __GLeeLink_WGL_ARB_buffer_region(void)
{
    GLint nLinked=0;
#ifdef __GLEE_WGL_ARB_buffer_region
    if ((GLeeFuncPtr_wglCreateBufferRegionARB = (GLEEPFNWGLCREATEBUFFERREGIONARBPROC) __GLeeGetProcAddress("wglCreateBufferRegionARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglDeleteBufferRegionARB = (GLEEPFNWGLDELETEBUFFERREGIONARBPROC) __GLeeGetProcAddress("wglDeleteBufferRegionARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglSaveBufferRegionARB = (GLEEPFNWGLSAVEBUFFERREGIONARBPROC) __GLeeGetProcAddress("wglSaveBufferRegionARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglRestoreBufferRegionARB = (GLEEPFNWGLRESTOREBUFFERREGIONARBPROC) __GLeeGetProcAddress("wglRestoreBufferRegionARB"))!=0) nLinked++;
#endif
    if (nLinked==4) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_WGL_ARB_multisample(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_WGL_ARB_extensions_string(void)
{
    GLint nLinked=0;
#ifdef __GLEE_WGL_ARB_extensions_string
    if ((GLeeFuncPtr_wglGetExtensionsStringARB = (GLEEPFNWGLGETEXTENSIONSSTRINGARBPROC) __GLeeGetProcAddress("wglGetExtensionsStringARB"))!=0) nLinked++;
#endif
    if (nLinked==1) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_WGL_ARB_pixel_format(void)
{
    GLint nLinked=0;
#ifdef __GLEE_WGL_ARB_pixel_format
    if ((GLeeFuncPtr_wglGetPixelFormatAttribivARB = (GLEEPFNWGLGETPIXELFORMATATTRIBIVARBPROC) __GLeeGetProcAddress("wglGetPixelFormatAttribivARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglGetPixelFormatAttribfvARB = (GLEEPFNWGLGETPIXELFORMATATTRIBFVARBPROC) __GLeeGetProcAddress("wglGetPixelFormatAttribfvARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglChoosePixelFormatARB = (GLEEPFNWGLCHOOSEPIXELFORMATARBPROC) __GLeeGetProcAddress("wglChoosePixelFormatARB"))!=0) nLinked++;
#endif
    if (nLinked==3) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_WGL_ARB_make_current_read(void)
{
    GLint nLinked=0;
#ifdef __GLEE_WGL_ARB_make_current_read
    if ((GLeeFuncPtr_wglMakeContextCurrentARB = (GLEEPFNWGLMAKECONTEXTCURRENTARBPROC) __GLeeGetProcAddress("wglMakeContextCurrentARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglGetCurrentReadDCARB = (GLEEPFNWGLGETCURRENTREADDCARBPROC) __GLeeGetProcAddress("wglGetCurrentReadDCARB"))!=0) nLinked++;
#endif
    if (nLinked==2) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_WGL_ARB_pbuffer(void)
{
    GLint nLinked=0;
#ifdef __GLEE_WGL_ARB_pbuffer
    if ((GLeeFuncPtr_wglCreatePbufferARB = (GLEEPFNWGLCREATEPBUFFERARBPROC) __GLeeGetProcAddress("wglCreatePbufferARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglGetPbufferDCARB = (GLEEPFNWGLGETPBUFFERDCARBPROC) __GLeeGetProcAddress("wglGetPbufferDCARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglReleasePbufferDCARB = (GLEEPFNWGLRELEASEPBUFFERDCARBPROC) __GLeeGetProcAddress("wglReleasePbufferDCARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglDestroyPbufferARB = (GLEEPFNWGLDESTROYPBUFFERARBPROC) __GLeeGetProcAddress("wglDestroyPbufferARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglQueryPbufferARB = (GLEEPFNWGLQUERYPBUFFERARBPROC) __GLeeGetProcAddress("wglQueryPbufferARB"))!=0) nLinked++;
#endif
    if (nLinked==5) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_WGL_ARB_render_texture(void)
{
    GLint nLinked=0;
#ifdef __GLEE_WGL_ARB_render_texture
    if ((GLeeFuncPtr_wglBindTexImageARB = (GLEEPFNWGLBINDTEXIMAGEARBPROC) __GLeeGetProcAddress("wglBindTexImageARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglReleaseTexImageARB = (GLEEPFNWGLRELEASETEXIMAGEARBPROC) __GLeeGetProcAddress("wglReleaseTexImageARB"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglSetPbufferAttribARB = (GLEEPFNWGLSETPBUFFERATTRIBARBPROC) __GLeeGetProcAddress("wglSetPbufferAttribARB"))!=0) nLinked++;
#endif
    if (nLinked==3) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_WGL_ARB_pixel_format_float(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_WGL_ARB_create_context(void)
{
    GLint nLinked=0;
#ifdef __GLEE_WGL_ARB_create_context
    if ((GLeeFuncPtr_wglCreateContextAttribsARB = (GLEEPFNWGLCREATECONTEXTATTRIBSARBPROC) __GLeeGetProcAddress("wglCreateContextAttribsARB"))!=0) nLinked++;
#endif
    if (nLinked==1) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_WGL_EXT_make_current_read(void)
{
    GLint nLinked=0;
#ifdef __GLEE_WGL_EXT_make_current_read
    if ((GLeeFuncPtr_wglMakeContextCurrentEXT = (GLEEPFNWGLMAKECONTEXTCURRENTEXTPROC) __GLeeGetProcAddress("wglMakeContextCurrentEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglGetCurrentReadDCEXT = (GLEEPFNWGLGETCURRENTREADDCEXTPROC) __GLeeGetProcAddress("wglGetCurrentReadDCEXT"))!=0) nLinked++;
#endif
    if (nLinked==2) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_WGL_EXT_pixel_format(void)
{
    GLint nLinked=0;
#ifdef __GLEE_WGL_EXT_pixel_format
    if ((GLeeFuncPtr_wglGetPixelFormatAttribivEXT = (GLEEPFNWGLGETPIXELFORMATATTRIBIVEXTPROC) __GLeeGetProcAddress("wglGetPixelFormatAttribivEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglGetPixelFormatAttribfvEXT = (GLEEPFNWGLGETPIXELFORMATATTRIBFVEXTPROC) __GLeeGetProcAddress("wglGetPixelFormatAttribfvEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglChoosePixelFormatEXT = (GLEEPFNWGLCHOOSEPIXELFORMATEXTPROC) __GLeeGetProcAddress("wglChoosePixelFormatEXT"))!=0) nLinked++;
#endif
    if (nLinked==3) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_WGL_EXT_pbuffer(void)
{
    GLint nLinked=0;
#ifdef __GLEE_WGL_EXT_pbuffer
    if ((GLeeFuncPtr_wglCreatePbufferEXT = (GLEEPFNWGLCREATEPBUFFEREXTPROC) __GLeeGetProcAddress("wglCreatePbufferEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglGetPbufferDCEXT = (GLEEPFNWGLGETPBUFFERDCEXTPROC) __GLeeGetProcAddress("wglGetPbufferDCEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglReleasePbufferDCEXT = (GLEEPFNWGLRELEASEPBUFFERDCEXTPROC) __GLeeGetProcAddress("wglReleasePbufferDCEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglDestroyPbufferEXT = (GLEEPFNWGLDESTROYPBUFFEREXTPROC) __GLeeGetProcAddress("wglDestroyPbufferEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglQueryPbufferEXT = (GLEEPFNWGLQUERYPBUFFEREXTPROC) __GLeeGetProcAddress("wglQueryPbufferEXT"))!=0) nLinked++;
#endif
    if (nLinked==5) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_WGL_EXT_depth_float(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_WGL_3DFX_multisample(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_WGL_EXT_multisample(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_WGL_I3D_digital_video_control(void)
{
    GLint nLinked=0;
#ifdef __GLEE_WGL_I3D_digital_video_control
    if ((GLeeFuncPtr_wglGetDigitalVideoParametersI3D = (GLEEPFNWGLGETDIGITALVIDEOPARAMETERSI3DPROC) __GLeeGetProcAddress("wglGetDigitalVideoParametersI3D"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglSetDigitalVideoParametersI3D = (GLEEPFNWGLSETDIGITALVIDEOPARAMETERSI3DPROC) __GLeeGetProcAddress("wglSetDigitalVideoParametersI3D"))!=0) nLinked++;
#endif
    if (nLinked==2) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_WGL_I3D_gamma(void)
{
    GLint nLinked=0;
#ifdef __GLEE_WGL_I3D_gamma
    if ((GLeeFuncPtr_wglGetGammaTableParametersI3D = (GLEEPFNWGLGETGAMMATABLEPARAMETERSI3DPROC) __GLeeGetProcAddress("wglGetGammaTableParametersI3D"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglSetGammaTableParametersI3D = (GLEEPFNWGLSETGAMMATABLEPARAMETERSI3DPROC) __GLeeGetProcAddress("wglSetGammaTableParametersI3D"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglGetGammaTableI3D = (GLEEPFNWGLGETGAMMATABLEI3DPROC) __GLeeGetProcAddress("wglGetGammaTableI3D"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglSetGammaTableI3D = (GLEEPFNWGLSETGAMMATABLEI3DPROC) __GLeeGetProcAddress("wglSetGammaTableI3D"))!=0) nLinked++;
#endif
    if (nLinked==4) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_WGL_I3D_genlock(void)
{
    GLint nLinked=0;
#ifdef __GLEE_WGL_I3D_genlock
    if ((GLeeFuncPtr_wglEnableGenlockI3D = (GLEEPFNWGLENABLEGENLOCKI3DPROC) __GLeeGetProcAddress("wglEnableGenlockI3D"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglDisableGenlockI3D = (GLEEPFNWGLDISABLEGENLOCKI3DPROC) __GLeeGetProcAddress("wglDisableGenlockI3D"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglIsEnabledGenlockI3D = (GLEEPFNWGLISENABLEDGENLOCKI3DPROC) __GLeeGetProcAddress("wglIsEnabledGenlockI3D"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglGenlockSourceI3D = (GLEEPFNWGLGENLOCKSOURCEI3DPROC) __GLeeGetProcAddress("wglGenlockSourceI3D"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglGetGenlockSourceI3D = (GLEEPFNWGLGETGENLOCKSOURCEI3DPROC) __GLeeGetProcAddress("wglGetGenlockSourceI3D"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglGenlockSourceEdgeI3D = (GLEEPFNWGLGENLOCKSOURCEEDGEI3DPROC) __GLeeGetProcAddress("wglGenlockSourceEdgeI3D"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglGetGenlockSourceEdgeI3D = (GLEEPFNWGLGETGENLOCKSOURCEEDGEI3DPROC) __GLeeGetProcAddress("wglGetGenlockSourceEdgeI3D"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglGenlockSampleRateI3D = (GLEEPFNWGLGENLOCKSAMPLERATEI3DPROC) __GLeeGetProcAddress("wglGenlockSampleRateI3D"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglGetGenlockSampleRateI3D = (GLEEPFNWGLGETGENLOCKSAMPLERATEI3DPROC) __GLeeGetProcAddress("wglGetGenlockSampleRateI3D"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglGenlockSourceDelayI3D = (GLEEPFNWGLGENLOCKSOURCEDELAYI3DPROC) __GLeeGetProcAddress("wglGenlockSourceDelayI3D"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglGetGenlockSourceDelayI3D = (GLEEPFNWGLGETGENLOCKSOURCEDELAYI3DPROC) __GLeeGetProcAddress("wglGetGenlockSourceDelayI3D"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglQueryGenlockMaxSourceDelayI3D = (GLEEPFNWGLQUERYGENLOCKMAXSOURCEDELAYI3DPROC) __GLeeGetProcAddress("wglQueryGenlockMaxSourceDelayI3D"))!=0) nLinked++;
#endif
    if (nLinked==12) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_WGL_I3D_image_buffer(void)
{
    GLint nLinked=0;
#ifdef __GLEE_WGL_I3D_image_buffer
    if ((GLeeFuncPtr_wglCreateImageBufferI3D = (GLEEPFNWGLCREATEIMAGEBUFFERI3DPROC) __GLeeGetProcAddress("wglCreateImageBufferI3D"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglDestroyImageBufferI3D = (GLEEPFNWGLDESTROYIMAGEBUFFERI3DPROC) __GLeeGetProcAddress("wglDestroyImageBufferI3D"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglAssociateImageBufferEventsI3D = (GLEEPFNWGLASSOCIATEIMAGEBUFFEREVENTSI3DPROC) __GLeeGetProcAddress("wglAssociateImageBufferEventsI3D"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglReleaseImageBufferEventsI3D = (GLEEPFNWGLRELEASEIMAGEBUFFEREVENTSI3DPROC) __GLeeGetProcAddress("wglReleaseImageBufferEventsI3D"))!=0) nLinked++;
#endif
    if (nLinked==4) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_WGL_I3D_swap_frame_lock(void)
{
    GLint nLinked=0;
#ifdef __GLEE_WGL_I3D_swap_frame_lock
    if ((GLeeFuncPtr_wglEnableFrameLockI3D = (GLEEPFNWGLENABLEFRAMELOCKI3DPROC) __GLeeGetProcAddress("wglEnableFrameLockI3D"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglDisableFrameLockI3D = (GLEEPFNWGLDISABLEFRAMELOCKI3DPROC) __GLeeGetProcAddress("wglDisableFrameLockI3D"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglIsEnabledFrameLockI3D = (GLEEPFNWGLISENABLEDFRAMELOCKI3DPROC) __GLeeGetProcAddress("wglIsEnabledFrameLockI3D"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglQueryFrameLockMasterI3D = (GLEEPFNWGLQUERYFRAMELOCKMASTERI3DPROC) __GLeeGetProcAddress("wglQueryFrameLockMasterI3D"))!=0) nLinked++;
#endif
    if (nLinked==4) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_WGL_NV_render_depth_texture(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_WGL_NV_render_texture_rectangle(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_WGL_ATI_pixel_format_float(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_WGL_NV_float_buffer(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_WGL_3DL_stereo_control(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_WGL_EXT_pixel_format_packed_float(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_WGL_EXT_framebuffer_sRGB(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_WGL_NV_present_video(void)
{
    GLint nLinked=0;
#ifdef __GLEE_WGL_NV_present_video
    if ((GLeeFuncPtr_wglEnumerateVideoDevicesNV = (GLEEPFNWGLENUMERATEVIDEODEVICESNVPROC) __GLeeGetProcAddress("wglEnumerateVideoDevicesNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglBindVideoDeviceNV = (GLEEPFNWGLBINDVIDEODEVICENVPROC) __GLeeGetProcAddress("wglBindVideoDeviceNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglQueryCurrentContextNV = (GLEEPFNWGLQUERYCURRENTCONTEXTNVPROC) __GLeeGetProcAddress("wglQueryCurrentContextNV"))!=0) nLinked++;
#endif
    if (nLinked==3) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_WGL_NV_swap_group(void)
{
    GLint nLinked=0;
#ifdef __GLEE_WGL_NV_swap_group
    if ((GLeeFuncPtr_wglJoinSwapGroupNV = (GLEEPFNWGLJOINSWAPGROUPNVPROC) __GLeeGetProcAddress("wglJoinSwapGroupNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglBindSwapBarrierNV = (GLEEPFNWGLBINDSWAPBARRIERNVPROC) __GLeeGetProcAddress("wglBindSwapBarrierNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglQuerySwapGroupNV = (GLEEPFNWGLQUERYSWAPGROUPNVPROC) __GLeeGetProcAddress("wglQuerySwapGroupNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglQueryMaxSwapGroupsNV = (GLEEPFNWGLQUERYMAXSWAPGROUPSNVPROC) __GLeeGetProcAddress("wglQueryMaxSwapGroupsNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglQueryFrameCountNV = (GLEEPFNWGLQUERYFRAMECOUNTNVPROC) __GLeeGetProcAddress("wglQueryFrameCountNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglResetFrameCountNV = (GLEEPFNWGLRESETFRAMECOUNTNVPROC) __GLeeGetProcAddress("wglResetFrameCountNV"))!=0) nLinked++;
#endif
    if (nLinked==6) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_WGL_NV_gpu_affinity(void)
{
    GLint nLinked=0;
#ifdef __GLEE_WGL_NV_gpu_affinity
    if ((GLeeFuncPtr_wglEnumGpusNV = (GLEEPFNWGLENUMGPUSNVPROC) __GLeeGetProcAddress("wglEnumGpusNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglEnumGpuDevicesNV = (GLEEPFNWGLENUMGPUDEVICESNVPROC) __GLeeGetProcAddress("wglEnumGpuDevicesNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglCreateAffinityDCNV = (GLEEPFNWGLCREATEAFFINITYDCNVPROC) __GLeeGetProcAddress("wglCreateAffinityDCNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglEnumGpusFromAffinityDCNV = (GLEEPFNWGLENUMGPUSFROMAFFINITYDCNVPROC) __GLeeGetProcAddress("wglEnumGpusFromAffinityDCNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglDeleteDCNV = (GLEEPFNWGLDELETEDCNVPROC) __GLeeGetProcAddress("wglDeleteDCNV"))!=0) nLinked++;
#endif
    if (nLinked==5) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_WGL_EXT_display_color_table(void)
{
    GLint nLinked=0;
#ifdef __GLEE_WGL_EXT_display_color_table
    if ((GLeeFuncPtr_wglCreateDisplayColorTableEXT = (GLEEPFNWGLCREATEDISPLAYCOLORTABLEEXTPROC) __GLeeGetProcAddress("wglCreateDisplayColorTableEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglLoadDisplayColorTableEXT = (GLEEPFNWGLLOADDISPLAYCOLORTABLEEXTPROC) __GLeeGetProcAddress("wglLoadDisplayColorTableEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglBindDisplayColorTableEXT = (GLEEPFNWGLBINDDISPLAYCOLORTABLEEXTPROC) __GLeeGetProcAddress("wglBindDisplayColorTableEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglDestroyDisplayColorTableEXT = (GLEEPFNWGLDESTROYDISPLAYCOLORTABLEEXTPROC) __GLeeGetProcAddress("wglDestroyDisplayColorTableEXT"))!=0) nLinked++;
#endif
    if (nLinked==4) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_WGL_EXT_extensions_string(void)
{
    GLint nLinked=0;
#ifdef __GLEE_WGL_EXT_extensions_string
    if ((GLeeFuncPtr_wglGetExtensionsStringEXT = (GLEEPFNWGLGETEXTENSIONSSTRINGEXTPROC) __GLeeGetProcAddress("wglGetExtensionsStringEXT"))!=0) nLinked++;
#endif
    if (nLinked==1) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_WGL_EXT_swap_control(void)
{
    GLint nLinked=0;
#ifdef __GLEE_WGL_EXT_swap_control
    if ((GLeeFuncPtr_wglSwapIntervalEXT = (GLEEPFNWGLSWAPINTERVALEXTPROC) __GLeeGetProcAddress("wglSwapIntervalEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglGetSwapIntervalEXT = (GLEEPFNWGLGETSWAPINTERVALEXTPROC) __GLeeGetProcAddress("wglGetSwapIntervalEXT"))!=0) nLinked++;
#endif
    if (nLinked==2) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_WGL_NV_vertex_array_range(void)
{
    GLint nLinked=0;
#ifdef __GLEE_WGL_NV_vertex_array_range
    if ((GLeeFuncPtr_wglAllocateMemoryNV = (GLEEPFNWGLALLOCATEMEMORYNVPROC) __GLeeGetProcAddress("wglAllocateMemoryNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglFreeMemoryNV = (GLEEPFNWGLFREEMEMORYNVPROC) __GLeeGetProcAddress("wglFreeMemoryNV"))!=0) nLinked++;
#endif
    if (nLinked==2) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_WGL_OML_sync_control(void)
{
    GLint nLinked=0;
#ifdef __GLEE_WGL_OML_sync_control
    if ((GLeeFuncPtr_wglGetSyncValuesOML = (GLEEPFNWGLGETSYNCVALUESOMLPROC) __GLeeGetProcAddress("wglGetSyncValuesOML"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglGetMscRateOML = (GLEEPFNWGLGETMSCRATEOMLPROC) __GLeeGetProcAddress("wglGetMscRateOML"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglSwapBuffersMscOML = (GLEEPFNWGLSWAPBUFFERSMSCOMLPROC) __GLeeGetProcAddress("wglSwapBuffersMscOML"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglSwapLayerBuffersMscOML = (GLEEPFNWGLSWAPLAYERBUFFERSMSCOMLPROC) __GLeeGetProcAddress("wglSwapLayerBuffersMscOML"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglWaitForMscOML = (GLEEPFNWGLWAITFORMSCOMLPROC) __GLeeGetProcAddress("wglWaitForMscOML"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglWaitForSbcOML = (GLEEPFNWGLWAITFORSBCOMLPROC) __GLeeGetProcAddress("wglWaitForSbcOML"))!=0) nLinked++;
#endif
    if (nLinked==6) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_WGL_I3D_swap_frame_usage(void)
{
    GLint nLinked=0;
#ifdef __GLEE_WGL_I3D_swap_frame_usage
    if ((GLeeFuncPtr_wglGetFrameUsageI3D = (GLEEPFNWGLGETFRAMEUSAGEI3DPROC) __GLeeGetProcAddress("wglGetFrameUsageI3D"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglBeginFrameTrackingI3D = (GLEEPFNWGLBEGINFRAMETRACKINGI3DPROC) __GLeeGetProcAddress("wglBeginFrameTrackingI3D"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglEndFrameTrackingI3D = (GLEEPFNWGLENDFRAMETRACKINGI3DPROC) __GLeeGetProcAddress("wglEndFrameTrackingI3D"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglQueryFrameTrackingI3D = (GLEEPFNWGLQUERYFRAMETRACKINGI3DPROC) __GLeeGetProcAddress("wglQueryFrameTrackingI3D"))!=0) nLinked++;
#endif
    if (nLinked==4) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_WGL_NV_video_output(void)
{
    GLint nLinked=0;
#ifdef __GLEE_WGL_NV_video_output
    if ((GLeeFuncPtr_wglGetVideoDeviceNV = (GLEEPFNWGLGETVIDEODEVICENVPROC) __GLeeGetProcAddress("wglGetVideoDeviceNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglReleaseVideoDeviceNV = (GLEEPFNWGLRELEASEVIDEODEVICENVPROC) __GLeeGetProcAddress("wglReleaseVideoDeviceNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglBindVideoImageNV = (GLEEPFNWGLBINDVIDEOIMAGENVPROC) __GLeeGetProcAddress("wglBindVideoImageNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglReleaseVideoImageNV = (GLEEPFNWGLRELEASEVIDEOIMAGENVPROC) __GLeeGetProcAddress("wglReleaseVideoImageNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglSendPbufferToVideoNV = (GLEEPFNWGLSENDPBUFFERTOVIDEONVPROC) __GLeeGetProcAddress("wglSendPbufferToVideoNV"))!=0) nLinked++;
    if ((GLeeFuncPtr_wglGetVideoInfoNV = (GLEEPFNWGLGETVIDEOINFONVPROC) __GLeeGetProcAddress("wglGetVideoInfoNV"))!=0) nLinked++;
#endif
    if (nLinked==6) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLEE_LINK_FUNCTION __GLeeWGLLoadFunction[37];

void initWGLLoadFunctions(void)
{
    __GLeeWGLLoadFunction[0]=__GLeeLink_WGL_ARB_buffer_region;
    __GLeeWGLLoadFunction[1]=__GLeeLink_WGL_ARB_multisample;
    __GLeeWGLLoadFunction[2]=__GLeeLink_WGL_ARB_extensions_string;
    __GLeeWGLLoadFunction[3]=__GLeeLink_WGL_ARB_pixel_format;
    __GLeeWGLLoadFunction[4]=__GLeeLink_WGL_ARB_make_current_read;
    __GLeeWGLLoadFunction[5]=__GLeeLink_WGL_ARB_pbuffer;
    __GLeeWGLLoadFunction[6]=__GLeeLink_WGL_ARB_render_texture;
    __GLeeWGLLoadFunction[7]=__GLeeLink_WGL_ARB_pixel_format_float;
    __GLeeWGLLoadFunction[8]=__GLeeLink_WGL_ARB_create_context;
    __GLeeWGLLoadFunction[9]=__GLeeLink_WGL_EXT_make_current_read;
    __GLeeWGLLoadFunction[10]=__GLeeLink_WGL_EXT_pixel_format;
    __GLeeWGLLoadFunction[11]=__GLeeLink_WGL_EXT_pbuffer;
    __GLeeWGLLoadFunction[12]=__GLeeLink_WGL_EXT_depth_float;
    __GLeeWGLLoadFunction[13]=__GLeeLink_WGL_3DFX_multisample;
    __GLeeWGLLoadFunction[14]=__GLeeLink_WGL_EXT_multisample;
    __GLeeWGLLoadFunction[15]=__GLeeLink_WGL_I3D_digital_video_control;
    __GLeeWGLLoadFunction[16]=__GLeeLink_WGL_I3D_gamma;
    __GLeeWGLLoadFunction[17]=__GLeeLink_WGL_I3D_genlock;
    __GLeeWGLLoadFunction[18]=__GLeeLink_WGL_I3D_image_buffer;
    __GLeeWGLLoadFunction[19]=__GLeeLink_WGL_I3D_swap_frame_lock;
    __GLeeWGLLoadFunction[20]=__GLeeLink_WGL_NV_render_depth_texture;
    __GLeeWGLLoadFunction[21]=__GLeeLink_WGL_NV_render_texture_rectangle;
    __GLeeWGLLoadFunction[22]=__GLeeLink_WGL_ATI_pixel_format_float;
    __GLeeWGLLoadFunction[23]=__GLeeLink_WGL_NV_float_buffer;
    __GLeeWGLLoadFunction[24]=__GLeeLink_WGL_3DL_stereo_control;
    __GLeeWGLLoadFunction[25]=__GLeeLink_WGL_EXT_pixel_format_packed_float;
    __GLeeWGLLoadFunction[26]=__GLeeLink_WGL_EXT_framebuffer_sRGB;
    __GLeeWGLLoadFunction[27]=__GLeeLink_WGL_NV_present_video;
    __GLeeWGLLoadFunction[28]=__GLeeLink_WGL_NV_swap_group;
    __GLeeWGLLoadFunction[29]=__GLeeLink_WGL_NV_gpu_affinity;
    __GLeeWGLLoadFunction[30]=__GLeeLink_WGL_EXT_display_color_table;
    __GLeeWGLLoadFunction[31]=__GLeeLink_WGL_EXT_extensions_string;
    __GLeeWGLLoadFunction[32]=__GLeeLink_WGL_EXT_swap_control;
    __GLeeWGLLoadFunction[33]=__GLeeLink_WGL_NV_vertex_array_range;
    __GLeeWGLLoadFunction[34]=__GLeeLink_WGL_OML_sync_control;
    __GLeeWGLLoadFunction[35]=__GLeeLink_WGL_I3D_swap_frame_usage;
    __GLeeWGLLoadFunction[36]=__GLeeLink_WGL_NV_video_output;
}

#elif defined(__APPLE__) || defined(__APPLE_CC__)
#else /* Linux */
GLuint __GLeeLink_GLX_VERSION_1_3(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GLX_VERSION_1_3
    if ((GLeeFuncPtr_glXGetFBConfigs = (GLEEPFNGLXGETFBCONFIGSPROC) __GLeeGetProcAddress("glXGetFBConfigs"))!=0) nLinked++;
    if ((GLeeFuncPtr_glXChooseFBConfig = (GLEEPFNGLXCHOOSEFBCONFIGPROC) __GLeeGetProcAddress("glXChooseFBConfig"))!=0) nLinked++;
    if ((GLeeFuncPtr_glXGetFBConfigAttrib = (GLEEPFNGLXGETFBCONFIGATTRIBPROC) __GLeeGetProcAddress("glXGetFBConfigAttrib"))!=0) nLinked++;
    if ((GLeeFuncPtr_glXGetVisualFromFBConfig = (GLEEPFNGLXGETVISUALFROMFBCONFIGPROC) __GLeeGetProcAddress("glXGetVisualFromFBConfig"))!=0) nLinked++;
    if ((GLeeFuncPtr_glXCreateWindow = (GLEEPFNGLXCREATEWINDOWPROC) __GLeeGetProcAddress("glXCreateWindow"))!=0) nLinked++;
    if ((GLeeFuncPtr_glXDestroyWindow = (GLEEPFNGLXDESTROYWINDOWPROC) __GLeeGetProcAddress("glXDestroyWindow"))!=0) nLinked++;
    if ((GLeeFuncPtr_glXCreatePixmap = (GLEEPFNGLXCREATEPIXMAPPROC) __GLeeGetProcAddress("glXCreatePixmap"))!=0) nLinked++;
    if ((GLeeFuncPtr_glXDestroyPixmap = (GLEEPFNGLXDESTROYPIXMAPPROC) __GLeeGetProcAddress("glXDestroyPixmap"))!=0) nLinked++;
    if ((GLeeFuncPtr_glXCreatePbuffer = (GLEEPFNGLXCREATEPBUFFERPROC) __GLeeGetProcAddress("glXCreatePbuffer"))!=0) nLinked++;
    if ((GLeeFuncPtr_glXDestroyPbuffer = (GLEEPFNGLXDESTROYPBUFFERPROC) __GLeeGetProcAddress("glXDestroyPbuffer"))!=0) nLinked++;
    if ((GLeeFuncPtr_glXQueryDrawable = (GLEEPFNGLXQUERYDRAWABLEPROC) __GLeeGetProcAddress("glXQueryDrawable"))!=0) nLinked++;
    if ((GLeeFuncPtr_glXCreateNewContext = (GLEEPFNGLXCREATENEWCONTEXTPROC) __GLeeGetProcAddress("glXCreateNewContext"))!=0) nLinked++;
    if ((GLeeFuncPtr_glXMakeContextCurrent = (GLEEPFNGLXMAKECONTEXTCURRENTPROC) __GLeeGetProcAddress("glXMakeContextCurrent"))!=0) nLinked++;
    if ((GLeeFuncPtr_glXGetCurrentReadDrawable = (GLEEPFNGLXGETCURRENTREADDRAWABLEPROC) __GLeeGetProcAddress("glXGetCurrentReadDrawable"))!=0) nLinked++;
    if ((GLeeFuncPtr_glXGetCurrentDisplay = (GLEEPFNGLXGETCURRENTDISPLAYPROC) __GLeeGetProcAddress("glXGetCurrentDisplay"))!=0) nLinked++;
    if ((GLeeFuncPtr_glXQueryContext = (GLEEPFNGLXQUERYCONTEXTPROC) __GLeeGetProcAddress("glXQueryContext"))!=0) nLinked++;
    if ((GLeeFuncPtr_glXSelectEvent = (GLEEPFNGLXSELECTEVENTPROC) __GLeeGetProcAddress("glXSelectEvent"))!=0) nLinked++;
    if ((GLeeFuncPtr_glXGetSelectedEvent = (GLEEPFNGLXGETSELECTEDEVENTPROC) __GLeeGetProcAddress("glXGetSelectedEvent"))!=0) nLinked++;
#endif
    if (nLinked==18) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GLX_VERSION_1_4(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GLX_VERSION_1_4
    if ((GLeeFuncPtr_glXGetProcAddress = (GLEEPFNGLXGETPROCADDRESSPROC) __GLeeGetProcAddress("glXGetProcAddress"))!=0) nLinked++;
#endif
    if (nLinked==1) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GLX_ARB_multisample(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GLX_ARB_fbconfig_float(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GLX_ARB_create_context(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GLX_ARB_create_context
    if ((GLeeFuncPtr_glXCreateContextAttribsARB = (GLEEPFNGLXCREATECONTEXTATTRIBSARBPROC) __GLeeGetProcAddress("glXCreateContextAttribsARB"))!=0) nLinked++;
#endif
    if (nLinked==1) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GLX_SGIS_multisample(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GLX_EXT_visual_info(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GLX_SGI_swap_control(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GLX_SGI_swap_control
    if ((GLeeFuncPtr_glXSwapIntervalSGI = (GLEEPFNGLXSWAPINTERVALSGIPROC) __GLeeGetProcAddress("glXSwapIntervalSGI"))!=0) nLinked++;
#endif
    if (nLinked==1) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GLX_SGI_video_sync(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GLX_SGI_video_sync
    if ((GLeeFuncPtr_glXGetVideoSyncSGI = (GLEEPFNGLXGETVIDEOSYNCSGIPROC) __GLeeGetProcAddress("glXGetVideoSyncSGI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glXWaitVideoSyncSGI = (GLEEPFNGLXWAITVIDEOSYNCSGIPROC) __GLeeGetProcAddress("glXWaitVideoSyncSGI"))!=0) nLinked++;
#endif
    if (nLinked==2) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GLX_SGI_make_current_read(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GLX_SGI_make_current_read
    if ((GLeeFuncPtr_glXMakeCurrentReadSGI = (GLEEPFNGLXMAKECURRENTREADSGIPROC) __GLeeGetProcAddress("glXMakeCurrentReadSGI"))!=0) nLinked++;
    if ((GLeeFuncPtr_glXGetCurrentReadDrawableSGI = (GLEEPFNGLXGETCURRENTREADDRAWABLESGIPROC) __GLeeGetProcAddress("glXGetCurrentReadDrawableSGI"))!=0) nLinked++;
#endif
    if (nLinked==2) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GLX_EXT_visual_rating(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GLX_EXT_import_context(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GLX_EXT_import_context
    if ((GLeeFuncPtr_glXGetCurrentDisplayEXT = (GLEEPFNGLXGETCURRENTDISPLAYEXTPROC) __GLeeGetProcAddress("glXGetCurrentDisplayEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glXQueryContextInfoEXT = (GLEEPFNGLXQUERYCONTEXTINFOEXTPROC) __GLeeGetProcAddress("glXQueryContextInfoEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glXGetContextIDEXT = (GLEEPFNGLXGETCONTEXTIDEXTPROC) __GLeeGetProcAddress("glXGetContextIDEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glXImportContextEXT = (GLEEPFNGLXIMPORTCONTEXTEXTPROC) __GLeeGetProcAddress("glXImportContextEXT"))!=0) nLinked++;
    if ((GLeeFuncPtr_glXFreeContextEXT = (GLEEPFNGLXFREECONTEXTEXTPROC) __GLeeGetProcAddress("glXFreeContextEXT"))!=0) nLinked++;
#endif
    if (nLinked==5) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GLX_SGIX_fbconfig(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GLX_SGIX_fbconfig
    if ((GLeeFuncPtr_glXGetFBConfigAttribSGIX = (GLEEPFNGLXGETFBCONFIGATTRIBSGIXPROC) __GLeeGetProcAddress("glXGetFBConfigAttribSGIX"))!=0) nLinked++;
    if ((GLeeFuncPtr_glXChooseFBConfigSGIX = (GLEEPFNGLXCHOOSEFBCONFIGSGIXPROC) __GLeeGetProcAddress("glXChooseFBConfigSGIX"))!=0) nLinked++;
    if ((GLeeFuncPtr_glXCreateGLXPixmapWithConfigSGIX = (GLEEPFNGLXCREATEGLXPIXMAPWITHCONFIGSGIXPROC) __GLeeGetProcAddress("glXCreateGLXPixmapWithConfigSGIX"))!=0) nLinked++;
    if ((GLeeFuncPtr_glXCreateContextWithConfigSGIX = (GLEEPFNGLXCREATECONTEXTWITHCONFIGSGIXPROC) __GLeeGetProcAddress("glXCreateContextWithConfigSGIX"))!=0) nLinked++;
    if ((GLeeFuncPtr_glXGetVisualFromFBConfigSGIX = (GLEEPFNGLXGETVISUALFROMFBCONFIGSGIXPROC) __GLeeGetProcAddress("glXGetVisualFromFBConfigSGIX"))!=0) nLinked++;
    if ((GLeeFuncPtr_glXGetFBConfigFromVisualSGIX = (GLEEPFNGLXGETFBCONFIGFROMVISUALSGIXPROC) __GLeeGetProcAddress("glXGetFBConfigFromVisualSGIX"))!=0) nLinked++;
#endif
    if (nLinked==6) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GLX_SGIX_pbuffer(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GLX_SGIX_pbuffer
    if ((GLeeFuncPtr_glXCreateGLXPbufferSGIX = (GLEEPFNGLXCREATEGLXPBUFFERSGIXPROC) __GLeeGetProcAddress("glXCreateGLXPbufferSGIX"))!=0) nLinked++;
    if ((GLeeFuncPtr_glXDestroyGLXPbufferSGIX = (GLEEPFNGLXDESTROYGLXPBUFFERSGIXPROC) __GLeeGetProcAddress("glXDestroyGLXPbufferSGIX"))!=0) nLinked++;
    if ((GLeeFuncPtr_glXQueryGLXPbufferSGIX = (GLEEPFNGLXQUERYGLXPBUFFERSGIXPROC) __GLeeGetProcAddress("glXQueryGLXPbufferSGIX"))!=0) nLinked++;
    if ((GLeeFuncPtr_glXSelectEventSGIX = (GLEEPFNGLXSELECTEVENTSGIXPROC) __GLeeGetProcAddress("glXSelectEventSGIX"))!=0) nLinked++;
    if ((GLeeFuncPtr_glXGetSelectedEventSGIX = (GLEEPFNGLXGETSELECTEDEVENTSGIXPROC) __GLeeGetProcAddress("glXGetSelectedEventSGIX"))!=0) nLinked++;
#endif
    if (nLinked==5) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GLX_SGI_cushion(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GLX_SGI_cushion
    if ((GLeeFuncPtr_glXCushionSGI = (GLEEPFNGLXCUSHIONSGIPROC) __GLeeGetProcAddress("glXCushionSGI"))!=0) nLinked++;
#endif
    if (nLinked==1) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GLX_SGIX_video_resize(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GLX_SGIX_video_resize
    if ((GLeeFuncPtr_glXBindChannelToWindowSGIX = (GLEEPFNGLXBINDCHANNELTOWINDOWSGIXPROC) __GLeeGetProcAddress("glXBindChannelToWindowSGIX"))!=0) nLinked++;
    if ((GLeeFuncPtr_glXChannelRectSGIX = (GLEEPFNGLXCHANNELRECTSGIXPROC) __GLeeGetProcAddress("glXChannelRectSGIX"))!=0) nLinked++;
    if ((GLeeFuncPtr_glXQueryChannelRectSGIX = (GLEEPFNGLXQUERYCHANNELRECTSGIXPROC) __GLeeGetProcAddress("glXQueryChannelRectSGIX"))!=0) nLinked++;
    if ((GLeeFuncPtr_glXQueryChannelDeltasSGIX = (GLEEPFNGLXQUERYCHANNELDELTASSGIXPROC) __GLeeGetProcAddress("glXQueryChannelDeltasSGIX"))!=0) nLinked++;
    if ((GLeeFuncPtr_glXChannelRectSyncSGIX = (GLEEPFNGLXCHANNELRECTSYNCSGIXPROC) __GLeeGetProcAddress("glXChannelRectSyncSGIX"))!=0) nLinked++;
#endif
    if (nLinked==5) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GLX_SGIX_swap_group(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GLX_SGIX_swap_group
    if ((GLeeFuncPtr_glXJoinSwapGroupSGIX = (GLEEPFNGLXJOINSWAPGROUPSGIXPROC) __GLeeGetProcAddress("glXJoinSwapGroupSGIX"))!=0) nLinked++;
#endif
    if (nLinked==1) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GLX_SGIX_swap_barrier(void)
{
    GLint nLinked=0;
#ifdef __GLEE_GLX_SGIX_swap_barrier
    if ((GLeeFuncPtr_glXBindSwapBarrierSGIX = (GLEEPFNGLXBINDSWAPBARRIERSGIXPROC) __GLeeGetProcAddress("glXBindSwapBarrierSGIX"))!=0) nLinked++;
    if ((GLeeFuncPtr_glXQueryMaxSwapBarriersSGIX = (GLEEPFNGLXQUERYMAXSWAPBARRIERSSGIXPROC) __GLeeGetProcAddress("glXQueryMaxSwapBarriersSGIX"))!=0) nLinked++;
#endif
    if (nLinked==2) return GLEE_LINK_COMPLETE;
    if (nLinked==0) return GLEE_LINK_FAIL;
    return GLEE_LINK_PARTIAL;
}

GLuint __GLeeLink_GLX_SGIS_blended_overlay(void) {return GLEE_LINK_COMPLETE;}

GLuint __GLeeLink_GLX_SGIS_shared_multisample(voi