/**
 *
 *  fp.c
 *  Copyright (C) 2013-2014 Sebastien Huss
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *  THE SOFTWARE.
 *
 */
/*
 * the tables bellow have been generated using : 
#include <math.h>
#include <strings.h>
#include <stdio.h>
#include "fp.h"

const float pi = 3.1415926f;

void gen_tan_table(void) {
	const float a = pi/2046.0f;
	int   i;
	float r;

	printf("static EGE_fp tan_table[1024] = {");
	for(r=0.0f,i=0;i<1024;i++,r+=a) {
		if (i>0)	printf(", ");
		if (i%16 == 0)	printf("\n\t"); 
		printf("0x%08x", fp_from_float(tanf(r)));
	}
	printf("\n};\n");
}

void gen_cos_table(void) {
	const float a = pi/2046.0f;
	int   i;
	float r;

	printf("static EGE_fp cos_table[1024] = {");
	for(r=0.0f,i=0;i<1024;i++,r+=a) {
		if (i>0)	printf(", ");
		if (i%16 == 0)	printf("\n\t"); 
		printf("0x%08x", fp_from_float(cosf(r)));
	}
	printf("\n};\n");
}

void gen_acos_table(void) {
	const float pitch  = 2.0f/1023.0f;
	float i = -1.0f;
	int   j;

	printf("static EGE_fp acos_table[1024] = {");
	for (j=0;j<1024;j++,i+=pitch) {
		if (j>0)	printf(", ");
		if ( j%16 == 0) printf("\n\t"); 
		printf("0x%08x", fp_from_float(acosf(i)));
	}
	printf("\n};\n");
}

void main(void) {
	gen_cos_table();
	gen_tan_table();
	gen_acos_table();
}
************************************************************/
#include <string.h>
#include "fp.h"
static EGE_fp cos_table[1024] = {
	0x00010000, 0x00010000, 0x00010000, 0x0000ffff, 0x0000ffff, 0x0000fffe, 0x0000fffd, 0x0000fffc, 0x0000fffb, 0x0000fffa, 0x0000fff8, 0x0000fff7, 0x0000fff5, 0x0000fff3, 0x0000fff1, 0x0000ffef, 
	0x0000ffec, 0x0000ffea, 0x0000ffe7, 0x0000ffe4, 0x0000ffe1, 0x0000ffde, 0x0000ffdb, 0x0000ffd7, 0x0000ffd4, 0x0000ffd0, 0x0000ffcc, 0x0000ffc8, 0x0000ffc3, 0x0000ffbf, 0x0000ffba, 0x0000ffb6, 
	0x0000ffb1, 0x0000ffac, 0x0000ffa7, 0x0000ffa1, 0x0000ff9c, 0x0000ff96, 0x0000ff90, 0x0000ff8b, 0x0000ff84, 0x0000ff7e, 0x0000ff78, 0x0000ff71, 0x0000ff6a, 0x0000ff64, 0x0000ff5d, 0x0000ff55, 
	0x0000ff4e, 0x0000ff47, 0x0000ff3f, 0x0000ff37, 0x0000ff2f, 0x0000ff27, 0x0000ff1f, 0x0000ff16, 0x0000ff0e, 0x0000ff05, 0x0000fefc, 0x0000fef3, 0x0000feea, 0x0000fee1, 0x0000fed7, 0x0000fece, 
	0x0000fec4, 0x0000feba, 0x0000feb0, 0x0000fea6, 0x0000fe9b, 0x0000fe91, 0x0000fe86, 0x0000fe7b, 0x0000fe70, 0x0000fe65, 0x0000fe59, 0x0000fe4e, 0x0000fe42, 0x0000fe36, 0x0000fe2b, 0x0000fe1e, 
	0x0000fe12, 0x0000fe06, 0x0000fdf9, 0x0000fdec, 0x0000fde0, 0x0000fdd3, 0x0000fdc5, 0x0000fdb8, 0x0000fdab, 0x0000fd9d, 0x0000fd8f, 0x0000fd81, 0x0000fd73, 0x0000fd65, 0x0000fd57, 0x0000fd48, 
	0x0000fd39, 0x0000fd2a, 0x0000fd1b, 0x0000fd0c, 0x0000fcfd, 0x0000fced, 0x0000fcde, 0x0000fcce, 0x0000fcbe, 0x0000fcae, 0x0000fc9e, 0x0000fc8d, 0x0000fc7d, 0x0000fc6c, 0x0000fc5b, 0x0000fc4a, 
	0x0000fc39, 0x0000fc28, 0x0000fc17, 0x0000fc05, 0x0000fbf3, 0x0000fbe1, 0x0000fbcf, 0x0000fbbd, 0x0000fbab, 0x0000fb98, 0x0000fb85, 0x0000fb73, 0x0000fb60, 0x0000fb4d, 0x0000fb39, 0x0000fb26, 
	0x0000fb12, 0x0000faff, 0x0000faeb, 0x0000fad7, 0x0000fac2, 0x0000faae, 0x0000fa9a, 0x0000fa85, 0x0000fa70, 0x0000fa5b, 0x0000fa46, 0x0000fa31, 0x0000fa1c, 0x0000fa06, 0x0000f9f0, 0x0000f9db, 
	0x0000f9c5, 0x0000f9ae, 0x0000f998, 0x0000f982, 0x0000f96b, 0x0000f954, 0x0000f93d, 0x0000f926, 0x0000f90f, 0x0000f8f8, 0x0000f8e0, 0x0000f8c9, 0x0000f8b1, 0x0000f899, 0x0000f881, 0x0000f869, 
	0x0000f850, 0x0000f838, 0x0000f81f, 0x0000f806, 0x0000f7ed, 0x0000f7d4, 0x0000f7bb, 0x0000f7a1, 0x0000f788, 0x0000f76e, 0x0000f754, 0x0000f73a, 0x0000f720, 0x0000f705, 0x0000f6eb, 0x0000f6d0, 
	0x0000f6b5, 0x0000f69a, 0x0000f67f, 0x0000f664, 0x0000f649, 0x0000f62d, 0x0000f612, 0x0000f5f6, 0x0000f5da, 0x0000f5be, 0x0000f5a1, 0x0000f585, 0x0000f568, 0x0000f54c, 0x0000f52f, 0x0000f512, 
	0x0000f4f5, 0x0000f4d7, 0x0000f4ba, 0x0000f49c, 0x0000f47e, 0x0000f461, 0x0000f442, 0x0000f424, 0x0000f406, 0x0000f3e7, 0x0000f3c9, 0x0000f3aa, 0x0000f38b, 0x0000f36c, 0x0000f34d, 0x0000f32d, 
	0x0000f30e, 0x0000f2ee, 0x0000f2ce, 0x0000f2ae, 0x0000f28e, 0x0000f26e, 0x0000f24e, 0x0000f22d, 0x0000f20c, 0x0000f1ec, 0x0000f1cb, 0x0000f1a9, 0x0000f188, 0x0000f167, 0x0000f145, 0x0000f123, 
	0x0000f102, 0x0000f0e0, 0x0000f0bd, 0x0000f09b, 0x0000f079, 0x0000f056, 0x0000f033, 0x0000f011, 0x0000efee, 0x0000efca, 0x0000efa7, 0x0000ef84, 0x0000ef60, 0x0000ef3c, 0x0000ef18, 0x0000eef4, 
	0x0000eed0, 0x0000eeac, 0x0000ee87, 0x0000ee63, 0x0000ee3e, 0x0000ee19, 0x0000edf4, 0x0000edcf, 0x0000edaa, 0x0000ed84, 0x0000ed5e, 0x0000ed39, 0x0000ed13, 0x0000eced, 0x0000ecc7, 0x0000eca0, 
	0x0000ec7a, 0x0000ec53, 0x0000ec2c, 0x0000ec05, 0x0000ebde, 0x0000ebb7, 0x0000eb90, 0x0000eb68, 0x0000eb41, 0x0000eb19, 0x0000eaf1, 0x0000eac9, 0x0000eaa1, 0x0000ea79, 0x0000ea50, 0x0000ea28, 
	0x0000e9ff, 0x0000e9d6, 0x0000e9ad, 0x0000e984, 0x0000e95a, 0x0000e931, 0x0000e907, 0x0000e8de, 0x0000e8b4, 0x0000e88a, 0x0000e860, 0x0000e835, 0x0000e80b, 0x0000e7e0, 0x0000e7b6, 0x0000e78b, 
	0x0000e760, 0x0000e735, 0x0000e709, 0x0000e6de, 0x0000e6b2, 0x0000e687, 0x0000e65b, 0x0000e62f, 0x0000e603, 0x0000e5d7, 0x0000e5aa, 0x0000e57e, 0x0000e551, 0x0000e524, 0x0000e4f7, 0x0000e4ca, 
	0x0000e49d, 0x0000e470, 0x0000e442, 0x0000e414, 0x0000e3e7, 0x0000e3b9, 0x0000e38b, 0x0000e35d, 0x0000e32e, 0x0000e300, 0x0000e2d1, 0x0000e2a2, 0x0000e274, 0x0000e245, 0x0000e215, 0x0000e1e6, 
	0x0000e1b7, 0x0000e187, 0x0000e158, 0x0000e128, 0x0000e0f8, 0x0000e0c8, 0x0000e097, 0x0000e067, 0x0000e037, 0x0000e006, 0x0000dfd5, 0x0000dfa4, 0x0000df73, 0x0000df42, 0x0000df11, 0x0000dedf, 
	0x0000deae, 0x0000de7c, 0x0000de4a, 0x0000de18, 0x0000dde6, 0x0000ddb4, 0x0000dd82, 0x0000dd4f, 0x0000dd1c, 0x0000dcea, 0x0000dcb7, 0x0000dc84, 0x0000dc50, 0x0000dc1d, 0x0000dbea, 0x0000dbb6, 
	0x0000db82, 0x0000db4f, 0x0000db1b, 0x0000dae6, 0x0000dab2, 0x0000da7e, 0x0000da49, 0x0000da15, 0x0000d9e0, 0x0000d9ab, 0x0000d976, 0x0000d941, 0x0000d90c, 0x0000d8d6, 0x0000d8a1, 0x0000d86b, 
	0x0000d835, 0x0000d7ff, 0x0000d7c9, 0x0000d793, 0x0000d75c, 0x0000d726, 0x0000d6ef, 0x0000d6b9, 0x0000d682, 0x0000d64b, 0x0000d614, 0x0000d5dc, 0x0000d5a5, 0x0000d56e, 0x0000d536, 0x0000d4fe, 
	0x0000d4c6, 0x0000d48e, 0x0000d456, 0x0000d41e, 0x0000d3e5, 0x0000d3ad, 0x0000d374, 0x0000d33b, 0x0000d303, 0x0000d2c9, 0x0000d290, 0x0000d257, 0x0000d21e, 0x0000d1e4, 0x0000d1aa, 0x0000d171, 
	0x0000d137, 0x0000d0fd, 0x0000d0c2, 0x0000d088, 0x0000d04e, 0x0000d013, 0x0000cfd8, 0x0000cf9e, 0x0000cf63, 0x0000cf28, 0x0000ceec, 0x0000ceb1, 0x0000ce76, 0x0000ce3a, 0x0000cdfe, 0x0000cdc3, 
	0x0000cd87, 0x0000cd4b, 0x0000cd0e, 0x0000ccd2, 0x0000cc96, 0x0000cc59, 0x0000cc1d, 0x0000cbe0, 0x0000cba3, 0x0000cb66, 0x0000cb29, 0x0000caeb, 0x0000caae, 0x0000ca70, 0x0000ca33, 0x0000c9f5, 
	0x0000c9b7, 0x0000c979, 0x0000c93b, 0x0000c8fd, 0x0000c8be, 0x0000c880, 0x0000c841, 0x0000c802, 0x0000c7c3, 0x0000c784, 0x0000c745, 0x0000c706, 0x0000c6c7, 0x0000c687, 0x0000c648, 0x0000c608, 
	0x0000c5c8, 0x0000c588, 0x0000c548, 0x0000c508, 0x0000c4c8, 0x0000c487, 0x0000c447, 0x0000c406, 0x0000c3c5, 0x0000c384, 0x0000c343, 0x0000c302, 0x0000c2c1, 0x0000c280, 0x0000c23e, 0x0000c1fc, 
	0x0000c1bb, 0x0000c179, 0x0000c137, 0x0000c0f5, 0x0000c0b3, 0x0000c070, 0x0000c02e, 0x0000bfeb, 0x0000bfa9, 0x0000bf66, 0x0000bf23, 0x0000bee0, 0x0000be9d, 0x0000be5a, 0x0000be16, 0x0000bdd3, 
	0x0000bd8f, 0x0000bd4c, 0x0000bd08, 0x0000bcc4, 0x0000bc80, 0x0000bc3c, 0x0000bbf8, 0x0000bbb3, 0x0000bb6f, 0x0000bb2a, 0x0000bae5, 0x0000baa1, 0x0000ba5c, 0x0000ba17, 0x0000b9d1, 0x0000b98c, 
	0x0000b947, 0x0000b901, 0x0000b8bc, 0x0000b876, 0x0000b830, 0x0000b7ea, 0x0000b7a4, 0x0000b75e, 0x0000b718, 0x0000b6d1, 0x0000b68b, 0x0000b644, 0x0000b5fd, 0x0000b5b7, 0x0000b570, 0x0000b529, 
	0x0000b4e1, 0x0000b49a, 0x0000b453, 0x0000b40b, 0x0000b3c4, 0x0000b37c, 0x0000b334, 0x0000b2ec, 0x0000b2a4, 0x0000b25c, 0x0000b214, 0x0000b1cc, 0x0000b183, 0x0000b13b, 0x0000b0f2, 0x0000b0a9, 
	0x0000b060, 0x0000b017, 0x0000afce, 0x0000af85, 0x0000af3c, 0x0000aef2, 0x0000aea9, 0x0000ae5f, 0x0000ae15, 0x0000adcc, 0x0000ad82, 0x0000ad38, 0x0000aced, 0x0000aca3, 0x0000ac59, 0x0000ac0e, 
	0x0000abc4, 0x0000ab79, 0x0000ab2e, 0x0000aae3, 0x0000aa98, 0x0000aa4d, 0x0000aa02, 0x0000a9b7, 0x0000a96c, 0x0000a920, 0x0000a8d4, 0x0000a889, 0x0000a83d, 0x0000a7f1, 0x0000a7a5, 0x0000a759, 
	0x0000a70d, 0x0000a6c0, 0x0000a674, 0x0000a628, 0x0000a5db, 0x0000a58e, 0x0000a541, 0x0000a4f5, 0x0000a4a8, 0x0000a45a, 0x0000a40d, 0x0000a3c0, 0x0000a373, 0x0000a325, 0x0000a2d7, 0x0000a28a, 
	0x0000a23c, 0x0000a1ee, 0x0000a1a0, 0x0000a152, 0x0000a104, 0x0000a0b6, 0x0000a067, 0x0000a019, 0x00009fca, 0x00009f7b, 0x00009f2d, 0x00009ede, 0x00009e8f, 0x00009e40, 0x00009df1, 0x00009da1, 
	0x00009d52, 0x00009d03, 0x00009cb3, 0x00009c63, 0x00009c14, 0x00009bc4, 0x00009b74, 0x00009b24, 0x00009ad4, 0x00009a84, 0x00009a33, 0x000099e3, 0x00009993, 0x00009942, 0x000098f1, 0x000098a1, 
	0x00009850, 0x000097ff, 0x000097ae, 0x0000975d, 0x0000970c, 0x000096ba, 0x00009669, 0x00009617, 0x000095c6, 0x00009574, 0x00009523, 0x000094d1, 0x0000947f, 0x0000942d, 0x000093db, 0x00009388, 
	0x00009336, 0x000092e4, 0x00009291, 0x0000923f, 0x000091ec, 0x00009199, 0x00009147, 0x000090f4, 0x000090a1, 0x0000904e, 0x00008ffa, 0x00008fa7, 0x00008f54, 0x00008f00, 0x00008ead, 0x00008e59, 
	0x00008e06, 0x00008db2, 0x00008d5e, 0x00008d0a, 0x00008cb6, 0x00008c62, 0x00008c0e, 0x00008bba, 0x00008b65, 0x00008b11, 0x00008abc, 0x00008a68, 0x00008a13, 0x000089be, 0x00008969, 0x00008914, 
	0x000088bf, 0x0000886a, 0x00008815, 0x000087c0, 0x0000876a, 0x00008715, 0x000086bf, 0x0000866a, 0x00008614, 0x000085be, 0x00008568, 0x00008513, 0x000084bd, 0x00008466, 0x00008410, 0x000083ba, 
	0x00008364, 0x0000830d, 0x000082b7, 0x00008260, 0x0000820a, 0x000081b3, 0x0000815c, 0x00008105, 0x000080ae, 0x00008057, 0x00008000, 0x00007fa9, 0x00007f52, 0x00007efa, 0x00007ea3, 0x00007e4b, 
	0x00007df4, 0x00007d9c, 0x00007d44, 0x00007ced, 0x00007c95, 0x00007c3d, 0x00007be5, 0x00007b8d, 0x00007b34, 0x00007adc, 0x00007a84, 0x00007a2c, 0x000079d3, 0x0000797a, 0x00007922, 0x000078c9, 
	0x00007870, 0x00007818, 0x000077bf, 0x00007766, 0x0000770d, 0x000076b4, 0x0000765a, 0x00007601, 0x000075a8, 0x0000754e, 0x000074f5, 0x0000749b, 0x00007442, 0x000073e8, 0x0000738e, 0x00007334, 
	0x000072da, 0x00007280, 0x00007226, 0x000071cc, 0x00007172, 0x00007118, 0x000070be, 0x00007063, 0x00007009, 0x00006fae, 0x00006f54, 0x00006ef9, 0x00006e9e, 0x00006e43, 0x00006de9, 0x00006d8e, 
	0x00006d33, 0x00006cd8, 0x00006c7d, 0x00006c21, 0x00006bc6, 0x00006b6b, 0x00006b0f, 0x00006ab4, 0x00006a58, 0x000069fd, 0x000069a1, 0x00006946, 0x000068ea, 0x0000688e, 0x00006832, 0x000067d6, 
	0x0000677a, 0x0000671e, 0x000066c2, 0x00006666, 0x00006609, 0x000065ad, 0x00006551, 0x000064f4, 0x00006498, 0x0000643b, 0x000063df, 0x00006382, 0x00006325, 0x000062c8, 0x0000626b, 0x0000620f, 
	0x000061b2, 0x00006155, 0x000060f7, 0x0000609a, 0x0000603d, 0x00005fe0, 0x00005f82, 0x00005f25, 0x00005ec8, 0x00005e6a, 0x00005e0c, 0x00005daf, 0x00005d51, 0x00005cf3, 0x00005c96, 0x00005c38, 
	0x00005bda, 0x00005b7c, 0x00005b1e, 0x00005ac0, 0x00005a62, 0x00005a04, 0x000059a5, 0x00005947, 0x000058e9, 0x0000588a, 0x0000582c, 0x000057cd, 0x0000576f, 0x00005710, 0x000056b2, 0x00005653, 
	0x000055f4, 0x00005595, 0x00005536, 0x000054d7, 0x00005478, 0x00005419, 0x000053ba, 0x0000535b, 0x000052fc, 0x0000529d, 0x0000523e, 0x000051de, 0x0000517f, 0x0000511f, 0x000050c0, 0x00005060, 
	0x00005001, 0x00004fa1, 0x00004f42, 0x00004ee2, 0x00004e82, 0x00004e22, 0x00004dc2, 0x00004d63, 0x00004d03, 0x00004ca3, 0x00004c43, 0x00004be3, 0x00004b82, 0x00004b22, 0x00004ac2, 0x00004a62, 
	0x00004a01, 0x000049a1, 0x00004941, 0x000048e0, 0x00004880, 0x0000481f, 0x000047bf, 0x0000475e, 0x000046fd, 0x0000469d, 0x0000463c, 0x000045db, 0x0000457a, 0x00004519, 0x000044b8, 0x00004457, 
	0x000043f6, 0x00004395, 0x00004334, 0x000042d3, 0x00004272, 0x00004211, 0x000041b0, 0x0000414e, 0x000040ed, 0x0000408c, 0x0000402a, 0x00003fc9, 0x00003f67, 0x00003f06, 0x00003ea4, 0x00003e43, 
	0x00003de1, 0x00003d7f, 0x00003d1e, 0x00003cbc, 0x00003c5a, 0x00003bf8, 0x00003b96, 0x00003b35, 0x00003ad3, 0x00003a71, 0x00003a0f, 0x000039ad, 0x0000394b, 0x000038e9, 0x00003886, 0x00003824, 
	0x000037c2, 0x00003760, 0x000036fe, 0x0000369b, 0x00003639, 0x000035d7, 0x00003574, 0x00003512, 0x000034af, 0x0000344d, 0x000033ea, 0x00003388, 0x00003325, 0x000032c2, 0x00003260, 0x000031fd, 
	0x0000319a, 0x00003138, 0x000030d5, 0x00003072, 0x0000300f, 0x00002fac, 0x00002f4a, 0x00002ee7, 0x00002e84, 0x00002e21, 0x00002dbe, 0x00002d5b, 0x00002cf8, 0x00002c95, 0x00002c31, 0x00002bce, 
	0x00002b6b, 0x00002b08, 0x00002aa5, 0x00002a41, 0x000029de, 0x0000297b, 0x00002918, 0x000028b4, 0x00002851, 0x000027ed, 0x0000278a, 0x00002727, 0x000026c3, 0x00002660, 0x000025fc, 0x00002599, 
	0x00002535, 0x000024d2, 0x0000246e, 0x0000240a, 0x000023a7, 0x00002343, 0x000022df, 0x0000227c, 0x00002218, 0x000021b4, 0x00002150, 0x000020ed, 0x00002089, 0x00002025, 0x00001fc1, 0x00001f5d, 
	0x00001ef9, 0x00001e95, 0x00001e32, 0x00001dce, 0x00001d6a, 0x00001d06, 0x00001ca2, 0x00001c3e, 0x00001bda, 0x00001b76, 0x00001b12, 0x00001aad, 0x00001a49, 0x000019e5, 0x00001981, 0x0000191d, 
	0x000018b9, 0x00001855, 0x000017f0, 0x0000178c, 0x00001728, 0x000016c4, 0x00001660, 0x000015fb, 0x00001597, 0x00001533, 0x000014cf, 0x0000146a, 0x00001406, 0x000013a2, 0x0000133d, 0x000012d9, 
	0x00001274, 0x00001210, 0x000011ac, 0x00001147, 0x000010e3, 0x0000107f, 0x0000101a, 0x00000fb6, 0x00000f51, 0x00000eed, 0x00000e88, 0x00000e24, 0x00000dbf, 0x00000d5b, 0x00000cf6, 0x00000c92, 
	0x00000c2d, 0x00000bc9, 0x00000b64, 0x00000b00, 0x00000a9b, 0x00000a37, 0x000009d2, 0x0000096d, 0x00000909, 0x000008a4, 0x00000840, 0x000007db, 0x00000777, 0x00000712, 0x000006ad, 0x00000649, 
	0x000005e4, 0x00000580, 0x0000051b, 0x000004b6, 0x00000452, 0x000003ed, 0x00000389, 0x00000324, 0x000002bf, 0x0000025b, 0x000001f6, 0x00000191, 0x0000012d, 0x000000c8, 0x00000063, 0
};

static EGE_fp tan_table[1024] = {
	0x00000000, 0x00000065, 0x000000c9, 0x0000012e, 0x00000193, 0x000001f7, 0x0000025c, 0x000002c0, 0x00000325, 0x0000038a, 0x000003ee, 0x00000453, 0x000004b8, 0x0000051c, 0x00000581, 0x000005e6, 
	0x0000064a, 0x000006af, 0x00000714, 0x00000778, 0x000007dd, 0x00000842, 0x000008a7, 0x0000090b, 0x00000970, 0x000009d5, 0x00000a3a, 0x00000a9f, 0x00000b03, 0x00000b68, 0x00000bcd, 0x00000c32, 
	0x00000c97, 0x00000cfc, 0x00000d61, 0x00000dc5, 0x00000e2a, 0x00000e8f, 0x00000ef4, 0x00000f59, 0x00000fbe, 0x00001023, 0x00001088, 0x000010ed, 0x00001152, 0x000011b8, 0x0000121d, 0x00001282, 
	0x000012e7, 0x0000134c, 0x000013b1, 0x00001417, 0x0000147c, 0x000014e1, 0x00001546, 0x000015ac, 0x00001611, 0x00001677, 0x000016dc, 0x00001741, 0x000017a7, 0x0000180c, 0x00001872, 0x000018d7, 
	0x0000193d, 0x000019a3, 0x00001a08, 0x00001a6e, 0x00001ad4, 0x00001b3a, 0x00001b9f, 0x00001c05, 0x00001c6b, 0x00001cd1, 0x00001d37, 0x00001d9d, 0x00001e03, 0x00001e69, 0x00001ecf, 0x00001f35, 
	0x00001f9b, 0x00002001, 0x00002067, 0x000020ce, 0x00002134, 0x0000219a, 0x00002201, 0x00002267, 0x000022ce, 0x00002334, 0x0000239b, 0x00002401, 0x00002468, 0x000024cf, 0x00002535, 0x0000259c, 
	0x00002603, 0x0000266a, 0x000026d1, 0x00002738, 0x0000279f, 0x00002806, 0x0000286d, 0x000028d4, 0x0000293b, 0x000029a3, 0x00002a0a, 0x00002a71, 0x00002ad9, 0x00002b40, 0x00002ba8, 0x00002c0f, 
	0x00002c77, 0x00002cdf, 0x00002d46, 0x00002dae, 0x00002e16, 0x00002e7e, 0x00002ee6, 0x00002f4e, 0x00002fb6, 0x0000301e, 0x00003086, 0x000030ef, 0x00003157, 0x000031bf, 0x00003228, 0x00003290, 
	0x000032f9, 0x00003362, 0x000033ca, 0x00003433, 0x0000349c, 0x00003505, 0x0000356e, 0x000035d7, 0x00003640, 0x000036a9, 0x00003712, 0x0000377c, 0x000037e5, 0x0000384f, 0x000038b8, 0x00003922, 
	0x0000398b, 0x000039f5, 0x00003a5f, 0x00003ac9, 0x00003b33, 0x00003b9d, 0x00003c07, 0x00003c71, 0x00003cdc, 0x00003d46, 0x00003db0, 0x00003e1b, 0x00003e85, 0x00003ef0, 0x00003f5b, 0x00003fc6, 
	0x00004031, 0x0000409c, 0x00004107, 0x00004172, 0x000041dd, 0x00004248, 0x000042b4, 0x0000431f, 0x0000438b, 0x000043f7, 0x00004462, 0x000044ce, 0x0000453a, 0x000045a6, 0x00004612, 0x0000467f, 
	0x000046eb, 0x00004757, 0x000047c4, 0x00004830, 0x0000489d, 0x0000490a, 0x00004977, 0x000049e4, 0x00004a51, 0x00004abe, 0x00004b2b, 0x00004b98, 0x00004c06, 0x00004c73, 0x00004ce1, 0x00004d4f, 
	0x00004dbd, 0x00004e2b, 0x00004e99, 0x00004f07, 0x00004f75, 0x00004fe4, 0x00005052, 0x000050c1, 0x0000512f, 0x0000519e, 0x0000520d, 0x0000527c, 0x000052eb, 0x0000535a, 0x000053ca, 0x00005439, 
	0x000054a9, 0x00005518, 0x00005588, 0x000055f8, 0x00005668, 0x000056d8, 0x00005749, 0x000057b9, 0x0000582a, 0x0000589a, 0x0000590b, 0x0000597c, 0x000059ed, 0x00005a5e, 0x00005acf, 0x00005b40, 
	0x00005bb2, 0x00005c24, 0x00005c95, 0x00005d07, 0x00005d79, 0x00005deb, 0x00005e5d, 0x00005ed0, 0x00005f42, 0x00005fb5, 0x00006028, 0x0000609b, 0x0000610e, 0x00006181, 0x000061f4, 0x00006268, 
	0x000062db, 0x0000634f, 0x000063c3, 0x00006437, 0x000064ab, 0x0000651f, 0x00006593, 0x00006608, 0x0000667d, 0x000066f1, 0x00006766, 0x000067dc, 0x00006851, 0x000068c6, 0x0000693c, 0x000069b1, 
	0x00006a27, 0x00006a9d, 0x00006b13, 0x00006b8a, 0x00006c00, 0x00006c77, 0x00006cee, 0x00006d65, 0x00006ddc, 0x00006e53, 0x00006eca, 0x00006f42, 0x00006fba, 0x00007031, 0x000070a9, 0x00007122, 
	0x0000719a, 0x00007213, 0x0000728b, 0x00007304, 0x0000737d, 0x000073f6, 0x00007470, 0x000074e9, 0x00007563, 0x000075dd, 0x00007657, 0x000076d1, 0x0000774b, 0x000077c6, 0x00007841, 0x000078bc, 
	0x00007937, 0x000079b2, 0x00007a2e, 0x00007aa9, 0x00007b25, 0x00007ba1, 0x00007c1d, 0x00007c9a, 0x00007d16, 0x00007d93, 0x00007e10, 0x00007e8d, 0x00007f0a, 0x00007f88, 0x00008005, 0x00008083, 
	0x00008101, 0x00008180, 0x000081fe, 0x0000827d, 0x000082fc, 0x0000837b, 0x000083fa, 0x0000847a, 0x000084f9, 0x00008579, 0x000085f9, 0x00008679, 0x000086fa, 0x0000877b, 0x000087fc, 0x0000887d, 
	0x000088fe, 0x00008980, 0x00008a01, 0x00008a83, 0x00008b06, 0x00008b88, 0x00008c0b, 0x00008c8d, 0x00008d11, 0x00008d94, 0x00008e17, 0x00008e9b, 0x00008f1f, 0x00008fa3, 0x00009028, 0x000090ac, 
	0x00009131, 0x000091b6, 0x0000923c, 0x000092c1, 0x00009347, 0x000093cd, 0x00009453, 0x000094da, 0x00009561, 0x000095e8, 0x0000966f, 0x000096f6, 0x0000977e, 0x00009806, 0x0000988e, 0x00009917, 
	0x000099a0, 0x00009a29, 0x00009ab2, 0x00009b3b, 0x00009bc5, 0x00009c4f, 0x00009cd9, 0x00009d64, 0x00009def, 0x00009e7a, 0x00009f05, 0x00009f91, 0x0000a01d, 0x0000a0a9, 0x0000a135, 0x0000a1c2, 
	0x0000a24f, 0x0000a2dc, 0x0000a369, 0x0000a3f7, 0x0000a485, 0x0000a514, 0x0000a5a2, 0x0000a631, 0x0000a6c0, 0x0000a750, 0x0000a7e0, 0x0000a870, 0x0000a900, 0x0000a991, 0x0000aa21, 0x0000aab3, 
	0x0000ab44, 0x0000abd6, 0x0000ac68, 0x0000acfb, 0x0000ad8d, 0x0000ae20, 0x0000aeb4, 0x0000af47, 0x0000afdb, 0x0000b070, 0x0000b104, 0x0000b199, 0x0000b22e, 0x0000b2c4, 0x0000b35a, 0x0000b3f0, 
	0x0000b486, 0x0000b51d, 0x0000b5b4, 0x0000b64c, 0x0000b6e4, 0x0000b77c, 0x0000b814, 0x0000b8ad, 0x0000b946, 0x0000b9e0, 0x0000ba7a, 0x0000bb14, 0x0000bbae, 0x0000bc49, 0x0000bce5, 0x0000bd80, 
	0x0000be1c, 0x0000beb8, 0x0000bf55, 0x0000bff2, 0x0000c08f, 0x0000c12d, 0x0000c1cb, 0x0000c26a, 0x0000c309, 0x0000c3a8, 0x0000c447, 0x0000c4e7, 0x0000c588, 0x0000c628, 0x0000c6ca, 0x0000c76b, 
	0x0000c80d, 0x0000c8af, 0x0000c952, 0x0000c9f5, 0x0000ca98, 0x0000cb3c, 0x0000cbe1, 0x0000cc85, 0x0000cd2a, 0x0000cdd0, 0x0000ce76, 0x0000cf1c, 0x0000cfc3, 0x0000d06a, 0x0000d111, 0x0000d1b9, 
	0x0000d262, 0x0000d30a, 0x0000d3b4, 0x0000d45d, 0x0000d507, 0x0000d5b2, 0x0000d65d, 0x0000d708, 0x0000d7b4, 0x0000d860, 0x0000d90d, 0x0000d9ba, 0x0000da68, 0x0000db16, 0x0000dbc5, 0x0000dc74, 
	0x0000dd23, 0x0000ddd3, 0x0000de83, 0x0000df34, 0x0000dfe6, 0x0000e098, 0x0000e14a, 0x0000e1fd, 0x0000e2b0, 0x0000e364, 0x0000e418, 0x0000e4cd, 0x0000e582, 0x0000e638, 0x0000e6ee, 0x0000e7a5, 
	0x0000e85c, 0x0000e914, 0x0000e9cc, 0x0000ea85, 0x0000eb3e, 0x0000ebf8, 0x0000ecb3, 0x0000ed6e, 0x0000ee29, 0x0000eee5, 0x0000efa2, 0x0000f05f, 0x0000f11c, 0x0000f1da, 0x0000f299, 0x0000f358, 
	0x0000f418, 0x0000f4d9, 0x0000f59a, 0x0000f65b, 0x0000f71d, 0x0000f7e0, 0x0000f8a3, 0x0000f967, 0x0000fa2b, 0x0000faf0, 0x0000fbb6, 0x0000fc7c, 0x0000fd43, 0x0000fe0b, 0x0000fed3, 0x0000ff9b, 
	0x00010064, 0x0001012e, 0x000101f9, 0x000102c4, 0x00010390, 0x0001045c, 0x00010529, 0x000105f7, 0x000106c5, 0x00010794, 0x00010864, 0x00010934, 0x00010a05, 0x00010ad7, 0x00010ba9, 0x00010c7c, 
	0x00010d50, 0x00010e24, 0x00010ef9, 0x00010fcf, 0x000110a5, 0x0001117c, 0x00011254, 0x0001132d, 0x00011406, 0x000114e0, 0x000115ba, 0x00011696, 0x00011772, 0x0001184f, 0x0001192d, 0x00011a0b, 
	0x00011aea, 0x00011bca, 0x00011cab, 0x00011d8c, 0x00011e6e, 0x00011f51, 0x00012035, 0x0001211a, 0x000121ff, 0x000122e5, 0x000123cc, 0x000124b4, 0x0001259d, 0x00012686, 0x00012770, 0x0001285b, 
	0x00012947, 0x00012a34, 0x00012b22, 0x00012c10, 0x00012cff, 0x00012def, 0x00012ee1, 0x00012fd2, 0x000130c5, 0x000131b9, 0x000132ae, 0x000133a3, 0x00013499, 0x00013591, 0x00013689, 0x00013782, 
	0x0001387c, 0x00013977, 0x00013a73, 0x00013b70, 0x00013c6e, 0x00013d6d, 0x00013e6d, 0x00013f6e, 0x0001406f, 0x00014172, 0x00014276, 0x0001437b, 0x00014481, 0x00014587, 0x0001468f, 0x00014798, 
	0x000148a2, 0x000149ad, 0x00014ab9, 0x00014bc6, 0x00014cd4, 0x00014de4, 0x00014ef4, 0x00015005, 0x00015118, 0x0001522c, 0x00015340, 0x00015456, 0x0001556d, 0x00015686, 0x0001579f, 0x000158ba, 
	0x000159d5, 0x00015af2, 0x00015c10, 0x00015d2f, 0x00015e50, 0x00015f71, 0x00016094, 0x000161b8, 0x000162de, 0x00016404, 0x0001652c, 0x00016656, 0x00016780, 0x000168ac, 0x000169d9, 0x00016b07, 
	0x00016c37, 0x00016d68, 0x00016e9a, 0x00016fce, 0x00017103, 0x00017239, 0x00017371, 0x000174aa, 0x000175e5, 0x00017721, 0x0001785e, 0x0001799d, 0x00017add, 0x00017c1f, 0x00017d62, 0x00017ea7, 
	0x00017fed, 0x00018135, 0x0001827e, 0x000183c9, 0x00018515, 0x00018663, 0x000187b2, 0x00018903, 0x00018a56, 0x00018baa, 0x00018d00, 0x00018e57, 0x00018fb1, 0x0001910b, 0x00019268, 0x000193c6, 
	0x00019526, 0x00019687, 0x000197ea, 0x0001994f, 0x00019ab6, 0x00019c1f, 0x00019d89, 0x00019ef5, 0x0001a063, 0x0001a1d3, 0x0001a345, 0x0001a4b8, 0x0001a62d, 0x0001a7a5, 0x0001a91e, 0x0001aa99, 
	0x0001ac16, 0x0001ad95, 0x0001af16, 0x0001b099, 0x0001b21e, 0x0001b3a5, 0x0001b52e, 0x0001b6b9, 0x0001b847, 0x0001b9d6, 0x0001bb67, 0x0001bcfb, 0x0001be91, 0x0001c029, 0x0001c1c3, 0x0001c35f, 
	0x0001c4fe, 0x0001c69f, 0x0001c842, 0x0001c9e7, 0x0001cb8f, 0x0001cd39, 0x0001cee6, 0x0001d094, 0x0001d246, 0x0001d3f9, 0x0001d5b0, 0x0001d768, 0x0001d923, 0x0001dae1, 0x0001dca1, 0x0001de64, 
	0x0001e029, 0x0001e1f1, 0x0001e3bc, 0x0001e589, 0x0001e759, 0x0001e92c, 0x0001eb01, 0x0001ecd9, 0x0001eeb4, 0x0001f092, 0x0001f273, 0x0001f457, 0x0001f63d, 0x0001f827, 0x0001fa13, 0x0001fc02, 
	0x0001fdf5, 0x0001ffea, 0x000201e3, 0x000203df, 0x000205dd, 0x000207df, 0x000209e5, 0x00020bed, 0x00020df9, 0x00021008, 0x0002121b, 0x00021430, 0x0002164a, 0x00021866, 0x00021a86, 0x00021caa, 
	0x00021ed2, 0x000220fc, 0x0002232b, 0x0002255d, 0x00022793, 0x000229cd, 0x00022c0a, 0x00022e4c, 0x00023091, 0x000232da, 0x00023527, 0x00023778, 0x000239cd, 0x00023c26, 0x00023e84, 0x000240e5, 
	0x0002434b, 0x000245b5, 0x00024824, 0x00024a96, 0x00024d0e, 0x00024f89, 0x00025209, 0x0002548e, 0x00025718, 0x000259a6, 0x00025c39, 0x00025ed0, 0x0002616d, 0x0002640e, 0x000266b5, 0x00026960, 
	0x00026c10, 0x00026ec6, 0x00027181, 0x00027441, 0x00027706, 0x000279d1, 0x00027ca1, 0x00027f77, 0x00028252, 0x00028533, 0x0002881a, 0x00028b07, 0x00028df9, 0x000290f1, 0x000293f0, 0x000296f4, 
	0x000299ff, 0x00029d0f, 0x0002a027, 0x0002a344, 0x0002a668, 0x0002a993, 0x0002acc4, 0x0002affc, 0x0002b33b, 0x0002b681, 0x0002b9ce, 0x0002bd22, 0x0002c07d, 0x0002c3df, 0x0002c749, 0x0002caba, 
	0x0002ce33, 0x0002d1b4, 0x0002d53c, 0x0002d8cc, 0x0002dc64, 0x0002e005, 0x0002e3ad, 0x0002e75e, 0x0002eb18, 0x0002eeda, 0x0002f2a4, 0x0002f678, 0x0002fa54, 0x0002fe3a, 0x00030229, 0x00030621, 
	0x00030a23, 0x00030e2e, 0x00031243, 0x00031662, 0x00031a8b, 0x00031ebe, 0x000322fb, 0x00032743, 0x00032b96, 0x00032ff3, 0x0003345c, 0x000338cf, 0x00033d4e, 0x000341d9, 0x0003466f, 0x00034b11, 
	0x00034fbf, 0x00035479, 0x00035940, 0x00035e14, 0x000362f4, 0x000367e1, 0x00036cdc, 0x000371e4, 0x000376fa, 0x00037c1d, 0x0003814f, 0x0003868f, 0x00038bde, 0x0003913c, 0x000396a9, 0x00039c25, 
	0x0003a1b1, 0x0003a74d, 0x0003acf9, 0x0003b2b5, 0x0003b883, 0x0003be61, 0x0003c451, 0x0003ca52, 0x0003d066, 0x0003d68b, 0x0003dcc4, 0x0003e30f, 0x0003e96e, 0x0003efe1, 0x0003f667, 0x0003fd02, 
	0x000403b2, 0x00040a77, 0x00041152, 0x00041843, 0x00041f4a, 0x00042668, 0x00042d9e, 0x000434eb, 0x00043c51, 0x000443cf, 0x00044b67, 0x00045319, 0x00045ae5, 0x000462cb, 0x00046ace, 0x000472ec, 
	0x00047b27, 0x0004837f, 0x00048bf5, 0x00049489, 0x00049d3c, 0x0004a60f, 0x0004af03, 0x0004b818, 0x0004c14f, 0x0004caa8, 0x0004d425, 0x0004ddc7, 0x0004e78d, 0x0004f179, 0x0004fb8d, 0x000505c8, 
	0x0005102b, 0x00051ab9, 0x00052571, 0x00053055, 0x00053b65, 0x000546a4, 0x00055211, 0x00055daf, 0x0005697e, 0x00057580, 0x000581b6, 0x00058e21, 0x00059ac3, 0x0005a79c, 0x0005b4b0, 0x0005c1ff, 
	0x0005cf8a, 0x0005dd54, 0x0005eb5e, 0x0005f9aa, 0x0006083a, 0x00061710, 0x0006262d, 0x00063594, 0x00064547, 0x00065548, 0x00066599, 0x0006763d, 0x00068737, 0x00069889, 0x0006aa35, 0x0006bc40, 
	0x0006ceaa, 0x0006e178, 0x0006f4ad, 0x0007084d, 0x00071c59, 0x000730d8, 0x000745cb, 0x00075b37, 0x00077121, 0x0007878d, 0x00079e7e, 0x0007b5fb, 0x0007ce08, 0x0007e6aa, 0x0007ffe7, 0x000819c5, 
	0x0008344a, 0x00084f7c, 0x00086b62, 0x00088803, 0x0008a566, 0x0008c394, 0x0008e295, 0x00090272, 0x00092333, 0x000944e3, 0x0009678c, 0x00098b38, 0x0009aff5, 0x0009d5ce, 0x0009fccf, 0x000a2508, 
	0x000a4e87, 0x000a795b, 0x000aa596, 0x000ad349, 0x000b0287, 0x000b3366, 0x000b65fa, 0x000b9a5c, 0x000bd0a5, 0x000c08ee, 0x000c4357, 0x000c7ffd, 0x000cbf03, 0x000d008e, 0x000d44c4, 0x000d8bd0, 
	0x000dd5e1, 0x000e2329, 0x000e73df, 0x000ec83f, 0x000f208a, 0x000f7d09, 0x000fde09, 0x001043e1, 0x0010aef2, 0x00111fa3, 0x0011966a, 0x001213ca, 0x00129852, 0x001324a4, 0x0013b977, 0x00145795, 
	0x0014ffe6, 0x0015b36e, 0x00167356, 0x001740f3, 0x00181dca, 0x00190b9e, 0x001a0c77, 0x001b22b8, 0x001c512b, 0x001d9b1d, 0x001f047d, 0x00209203, 0x00224963, 0x00243199, 0x00265345, 0x0028b92f, 
	0x002b70ff, 0x002e8c46, 0x003221fe, 0x003650c9, 0x003b4272, 0x00413181, 0x00487287, 0x00518471, 0x005d2ed0, 0x006cbe7e, 0x00828b3f, 0x00a34651, 0x00d9e8bb, 0x01477de6, 0x0292c674, 0x7fffffff
};

static EGE_fp acos_table[1024] = {
	0x0003243f, 0x0003143d, 0x00030d9a, 0x00030882, 0x00030436, 0x0003006d, 0x0002fd00, 0x0002f9d9, 0x0002f6e9, 0x0002f427, 0x0002f18b, 0x0002ef0f, 0x0002ecb0, 0x0002ea68, 0x0002e837, 0x0002e619, 
	0x0002e40c, 0x0002e210, 0x0002e022, 0x0002de41, 0x0002dc6c, 0x0002daa3, 0x0002d8e5, 0x0002d730, 0x0002d584, 0x0002d3e1, 0x0002d246, 0x0002d0b3, 0x0002cf27, 0x0002cda1, 0x0002cc23, 0x0002caaa, 
	0x0002c937, 0x0002c7ca, 0x0002c662, 0x0002c4ff, 0x0002c3a1, 0x0002c248, 0x0002c0f3, 0x0002bfa2, 0x0002be55, 0x0002bd0d, 0x0002bbc8, 0x0002ba87, 0x0002b94a, 0x0002b810, 0x0002b6d9, 0x0002b5a5, 
	0x0002b475, 0x0002b347, 0x0002b21d, 0x0002b0f5, 0x0002afd0, 0x0002aeae, 0x0002ad8e, 0x0002ac71, 0x0002ab56, 0x0002aa3d, 0x0002a927, 0x0002a813, 0x0002a702, 0x0002a5f2, 0x0002a4e5, 0x0002a3d9, 
	0x0002a2d0, 0x0002a1c8, 0x0002a0c2, 0x00029fbe, 0x00029ebc, 0x00029dbc, 0x00029cbe, 0x00029bc1, 0x00029ac5, 0x000299cc, 0x000298d4, 0x000297dd, 0x000296e8, 0x000295f5, 0x00029502, 0x00029412, 
	0x00029322, 0x00029235, 0x00029148, 0x0002905d, 0x00028f73, 0x00028e8a, 0x00028da2, 0x00028cbc, 0x00028bd7, 0x00028af3, 0x00028a11, 0x0002892f, 0x0002884e, 0x0002876f, 0x00028691, 0x000285b4, 
	0x000284d7, 0x000283fc, 0x00028322, 0x00028249, 0x00028171, 0x00028099, 0x00027fc3, 0x00027eee, 0x00027e19, 0x00027d46, 0x00027c73, 0x00027ba1, 0x00027ad0, 0x00027a00, 0x00027931, 0x00027863, 
	0x00027795, 0x000276c8, 0x000275fc, 0x00027531, 0x00027467, 0x0002739d, 0x000272d4, 0x0002720c, 0x00027145, 0x0002707e, 0x00026fb8, 0x00026ef3, 0x00026e2e, 0x00026d6a, 0x00026ca7, 0x00026be4, 
	0x00026b22, 0x00026a61, 0x000269a0, 0x000268e0, 0x00026821, 0x00026762, 0x000266a4, 0x000265e6, 0x00026529, 0x0002646d, 0x000263b1, 0x000262f6, 0x0002623b, 0x00026181, 0x000260c7, 0x0002600e, 
	0x00025f56, 0x00025e9e, 0x00025de7, 0x00025d30, 0x00025c79, 0x00025bc3, 0x00025b0e, 0x00025a59, 0x000259a5, 0x000258f1, 0x0002583e, 0x0002578b, 0x000256d8, 0x00025626, 0x00025575, 0x000254c4, 
	0x00025413, 0x00025363, 0x000252b3, 0x00025204, 0x00025155, 0x000250a7, 0x00024ff9, 0x00024f4b, 0x00024e9e, 0x00024df1, 0x00024d45, 0x00024c99, 0x00024bee, 0x00024b43, 0x00024a98, 0x000249ee, 
	0x00024944, 0x0002489a, 0x000247f1, 0x00024748, 0x000246a0, 0x000245f8, 0x00024550, 0x000244a9, 0x00024402, 0x0002435b, 0x000242b5, 0x0002420f, 0x00024169, 0x000240c4, 0x0002401f, 0x00023f7b, 
	0x00023ed6, 0x00023e32, 0x00023d8f, 0x00023cec, 0x00023c49, 0x00023ba6, 0x00023b04, 0x00023a62, 0x000239c0, 0x0002391f, 0x0002387e, 0x000237dd, 0x0002373c, 0x0002369c, 0x000235fc, 0x0002355d, 
	0x000234bd, 0x0002341e, 0x00023380, 0x000232e1, 0x00023243, 0x000231a5, 0x00023107, 0x0002306a, 0x00022fcd, 0x00022f30, 0x00022e94, 0x00022df7, 0x00022d5b, 0x00022cbf, 0x00022c24, 0x00022b89, 
	0x00022aed, 0x00022a53, 0x000229b8, 0x0002291e, 0x00022884, 0x000227ea, 0x00022750, 0x000226b7, 0x0002261e, 0x00022585, 0x000224ec, 0x00022454, 0x000223bc, 0x00022324, 0x0002228c, 0x000221f5, 
	0x0002215d, 0x000220c6, 0x0002202f, 0x00021f99, 0x00021f02, 0x00021e6c, 0x00021dd6, 0x00021d40, 0x00021cab, 0x00021c15, 0x00021b80, 0x00021aeb, 0x00021a56, 0x000219c2, 0x0002192e, 0x00021899, 
	0x00021805, 0x00021772, 0x000216de, 0x0002164b, 0x000215b7, 0x00021524, 0x00021491, 0x000213ff, 0x0002136c, 0x000212da, 0x00021248, 0x000211b6, 0x00021124, 0x00021092, 0x00021001, 0x00020f70, 
	0x00020edf, 0x00020e4e, 0x00020dbd, 0x00020d2c, 0x00020c9c, 0x00020c0c, 0x00020b7c, 0x00020aec, 0x00020a5c, 0x000209cc, 0x0002093d, 0x000208ae, 0x0002081e, 0x0002078f, 0x00020701, 0x00020672, 
	0x000205e3, 0x00020555, 0x000204c7, 0x00020439, 0x000203ab, 0x0002031d, 0x0002028f, 0x00020202, 0x00020175, 0x000200e7, 0x0002005a, 0x0001ffcd, 0x0001ff41, 0x0001feb4, 0x0001fe28, 0x0001fd9b, 
	0x0001fd0f, 0x0001fc83, 0x0001fbf7, 0x0001fb6b, 0x0001fadf, 0x0001fa54, 0x0001f9c8, 0x0001f93d, 0x0001f8b2, 0x0001f827, 0x0001f79c, 0x0001f711, 0x0001f686, 0x0001f5fb, 0x0001f571, 0x0001f4e7, 
	0x0001f45c, 0x0001f3d2, 0x0001f348, 0x0001f2be, 0x0001f235, 0x0001f1ab, 0x0001f121, 0x0001f098, 0x0001f00f, 0x0001ef85, 0x0001eefc, 0x0001ee73, 0x0001edeb, 0x0001ed62, 0x0001ecd9, 0x0001ec51, 
	0x0001ebc8, 0x0001eb40, 0x0001eab7, 0x0001ea2f, 0x0001e9a7, 0x0001e91f, 0x0001e897, 0x0001e810, 0x0001e788, 0x0001e701, 0x0001e679, 0x0001e5f2, 0x0001e56a, 0x0001e4e3, 0x0001e45c, 0x0001e3d5, 
	0x0001e34e, 0x0001e2c7, 0x0001e241, 0x0001e1ba, 0x0001e134, 0x0001e0ad, 0x0001e027, 0x0001dfa1, 0x0001df1a, 0x0001de94, 0x0001de0e, 0x0001dd88, 0x0001dd02, 0x0001dc7d, 0x0001dbf7, 0x0001db71, 
	0x0001daec, 0x0001da66, 0x0001d9e1, 0x0001d95c, 0x0001d8d7, 0x0001d851, 0x0001d7cc, 0x0001d747, 0x0001d6c2, 0x0001d63e, 0x0001d5b9, 0x0001d534, 0x0001d4b0, 0x0001d42b, 0x0001d3a7, 0x0001d322, 
	0x0001d29e, 0x0001d21a, 0x0001d195, 0x0001d111, 0x0001d08d, 0x0001d009, 0x0001cf85, 0x0001cf01, 0x0001ce7e, 0x0001cdfa, 0x0001cd76, 0x0001ccf3, 0x0001cc6f, 0x0001cbeb, 0x0001cb68, 0x0001cae5, 
	0x0001ca61, 0x0001c9de, 0x0001c95b, 0x0001c8d8, 0x0001c855, 0x0001c7d2, 0x0001c74f, 0x0001c6cc, 0x0001c649, 0x0001c5c6, 0x0001c543, 0x0001c4c1, 0x0001c43e, 0x0001c3bb, 0x0001c339, 0x0001c2b6, 
	0x0001c234, 0x0001c1b2, 0x0001c12f, 0x0001c0ad, 0x0001c02b, 0x0001bfa8, 0x0001bf26, 0x0001bea4, 0x0001be22, 0x0001bda0, 0x0001bd1e, 0x0001bc9c, 0x0001bc1a, 0x0001bb98, 0x0001bb17, 0x0001ba95, 
	0x0001ba13, 0x0001b991, 0x0001b910, 0x0001b88e, 0x0001b80d, 0x0001b78b, 0x0001b70a, 0x0001b688, 0x0001b607, 0x0001b585, 0x0001b504, 0x0001b483, 0x0001b402, 0x0001b380, 0x0001b2ff, 0x0001b27e, 
	0x0001b1fd, 0x0001b17c, 0x0001b0fb, 0x0001b07a, 0x0001aff9, 0x0001af78, 0x0001aef7, 0x0001ae76, 0x0001adf5, 0x0001ad74, 0x0001acf3, 0x0001ac72, 0x0001abf1, 0x0001ab71, 0x0001aaf0, 0x0001aa6f, 
	0x0001a9ee, 0x0001a96e, 0x0001a8ed, 0x0001a86d, 0x0001a7ec, 0x0001a76b, 0x0001a6eb, 0x0001a66a, 0x0001a5ea, 0x0001a569, 0x0001a4e9, 0x0001a468, 0x0001a3e8, 0x0001a367, 0x0001a2e7, 0x0001a267, 
	0x0001a1e6, 0x0001a166, 0x0001a0e6, 0x0001a065, 0x00019fe5, 0x00019f65, 0x00019ee4, 0x00019e64, 0x00019de4, 0x00019d64, 0x00019ce3, 0x00019c63, 0x00019be3, 0x00019b63, 0x00019ae2, 0x00019a62, 
	0x000199e2, 0x00019962, 0x000198e2, 0x00019861, 0x000197e1, 0x00019761, 0x000196e1, 0x00019661, 0x000195e1, 0x00019561, 0x000194e0, 0x00019460, 0x000193e0, 0x00019360, 0x000192e0, 0x00019260, 
	0x000191e0, 0x00019160, 0x000190df, 0x0001905f, 0x00018fdf, 0x00018f5f, 0x00018edf, 0x00018e5f, 0x00018ddf, 0x00018d5f, 0x00018cde, 0x00018c5e, 0x00018bde, 0x00018b5e, 0x00018ade, 0x00018a5e, 
	0x000189dd, 0x0001895d, 0x000188dd, 0x0001885d, 0x000187dd, 0x0001875c, 0x000186dc, 0x0001865c, 0x000185dc, 0x0001855b, 0x000184db, 0x0001845b, 0x000183da, 0x0001835a, 0x000182da, 0x00018259, 
	0x000181d9, 0x00018159, 0x000180d8, 0x00018058, 0x00017fd7, 0x00017f57, 0x00017ed6, 0x00017e56, 0x00017dd5, 0x00017d55, 0x00017cd4, 0x00017c54, 0x00017bd3, 0x00017b52, 0x00017ad2, 0x00017a51, 
	0x000179d0, 0x00017950, 0x000178cf, 0x0001784e, 0x000177cd, 0x0001774d, 0x000176cc, 0x0001764b, 0x000175ca, 0x00017549, 0x000174c8, 0x00017447, 0x000173c6, 0x00017345, 0x000172c4, 0x00017243, 
	0x000171c2, 0x00017140, 0x000170bf, 0x0001703e, 0x00016fbd, 0x00016f3b, 0x00016eba, 0x00016e39, 0x00016db7, 0x00016d36, 0x00016cb4, 0x00016c33, 0x00016bb1, 0x00016b30, 0x00016aae, 0x00016a2c, 
	0x000169ab, 0x00016929, 0x000168a7, 0x00016825, 0x000167a3, 0x00016721, 0x0001669f, 0x0001661d, 0x0001659b, 0x00016519, 0x00016497, 0x00016415, 0x00016393, 0x00016310, 0x0001628e, 0x0001620c, 
	0x00016189, 0x00016107, 0x00016084, 0x00016002, 0x00015f7f, 0x00015efc, 0x00015e79, 0x00015df7, 0x00015d74, 0x00015cf1, 0x00015c6e, 0x00015beb, 0x00015b68, 0x00015ae5, 0x00015a61, 0x000159de, 
	0x0001595b, 0x000158d8, 0x00015854, 0x000157d1, 0x0001574d, 0x000156c9, 0x00015646, 0x000155c2, 0x0001553e, 0x000154ba, 0x00015436, 0x000153b2, 0x0001532e, 0x000152aa, 0x00015226, 0x000151a2, 
	0x0001511d, 0x00015099, 0x00015015, 0x00014f90, 0x00014f0b, 0x00014e87, 0x00014e02, 0x00014d7d, 0x00014cf8, 0x00014c73, 0x00014bee, 0x00014b69, 0x00014ae4, 0x00014a5f, 0x000149d9, 0x00014954, 
	0x000148ce, 0x00014849, 0x000147c3, 0x0001473d, 0x000146b7, 0x00014631, 0x000145ab, 0x00014525, 0x0001449f, 0x00014419, 0x00014392, 0x0001430c, 0x00014285, 0x000141ff, 0x00014178, 0x000140f1, 
	0x0001406a, 0x00013fe3, 0x00013f5c, 0x00013ed5, 0x00013e4e, 0x00013dc7, 0x00013d3f, 0x00013cb7, 0x00013c30, 0x00013ba8, 0x00013b20, 0x00013a98, 0x00013a10, 0x00013988, 0x00013900, 0x00013877, 
	0x000137ef, 0x00013766, 0x000136de, 0x00013655, 0x000135cc, 0x00013543, 0x000134ba, 0x00013431, 0x000133a8, 0x0001331e, 0x00013295, 0x0001320b, 0x00013181, 0x000130f7, 0x0001306d, 0x00012fe3, 
	0x00012f59, 0x00012ecf, 0x00012e44, 0x00012dba, 0x00012d2f, 0x00012ca4, 0x00012c19, 0x00012b8e, 0x00012b03, 0x00012a77, 0x000129ec, 0x00012960, 0x000128d5, 0x00012849, 0x000127bd, 0x00012731, 
	0x000126a4, 0x00012618, 0x0001258c, 0x000124ff, 0x00012472, 0x000123e5, 0x00012358, 0x000122cb, 0x0001223e, 0x000121b0, 0x00012122, 0x00012095, 0x00012007, 0x00011f79, 0x00011eea, 0x00011e5c, 
	0x00011dce, 0x00011d3f, 0x00011cb0, 0x00011c21, 0x00011b92, 0x00011b03, 0x00011a73, 0x000119e4, 0x00011954, 0x000118c4, 0x00011834, 0x000117a4, 0x00011713, 0x00011683, 0x000115f2, 0x00011561, 
	0x000114d0, 0x0001143f, 0x000113ad, 0x0001131c, 0x0001128a, 0x000111f8, 0x00011166, 0x000110d3, 0x00011041, 0x00010fae, 0x00010f1b, 0x00010e88, 0x00010df5, 0x00010d62, 0x00010cce, 0x00010c3a, 
	0x00010ba6, 0x00010b12, 0x00010a7e, 0x000109e9, 0x00010954, 0x000108bf, 0x0001082a, 0x00010795, 0x000106ff, 0x00010669, 0x000105d3, 0x0001053d, 0x000104a7, 0x00010410, 0x00010379, 0x000102e2, 
	0x0001024b, 0x000101b3, 0x0001011c, 0x00010084, 0x0000ffeb, 0x0000ff53, 0x0000feba, 0x0000fe22, 0x0000fd88, 0x0000fcef, 0x0000fc56, 0x0000fbbc, 0x0000fb22, 0x0000fa87, 0x0000f9ed, 0x0000f952, 
	0x0000f8b7, 0x0000f81c, 0x0000f780, 0x0000f6e4, 0x0000f648, 0x0000f5ac, 0x0000f50f, 0x0000f473, 0x0000f3d6, 0x0000f338, 0x0000f29b, 0x0000f1fd, 0x0000f15e, 0x0000f0c0, 0x0000f021, 0x0000ef82, 
	0x0000eee3, 0x0000ee43, 0x0000eda3, 0x0000ed03, 0x0000ec63, 0x0000ebc2, 0x0000eb21, 0x0000ea7f, 0x0000e9de, 0x0000e93c, 0x0000e899, 0x0000e7f7, 0x0000e754, 0x0000e6b1, 0x0000e60d, 0x0000e569, 
	0x0000e4c5, 0x0000e420, 0x0000e37b, 0x0000e2d6, 0x0000e231, 0x0000e18b, 0x0000e0e4, 0x0000e03e, 0x0000df97, 0x0000def0, 0x0000de48, 0x0000dda0, 0x0000dcf7, 0x0000dc4f, 0x0000dba5, 0x0000dafc, 
	0x0000da52, 0x0000d9a8, 0x0000d8fd, 0x0000d852, 0x0000d7a6, 0x0000d6fa, 0x0000d64e, 0x0000d5a1, 0x0000d4f4, 0x0000d447, 0x0000d399, 0x0000d2ea, 0x0000d23c, 0x0000d18c, 0x0000d0dd, 0x0000d02c, 
	0x0000cf7c, 0x0000cecb, 0x0000ce19, 0x0000cd67, 0x0000ccb5, 0x0000cc02, 0x0000cb4f, 0x0000ca9b, 0x0000c9e6, 0x0000c932, 0x0000c87c, 0x0000c7c6, 0x0000c710, 0x0000c659, 0x0000c5a2, 0x0000c4ea, 
	0x0000c431, 0x0000c378, 0x0000c2bf, 0x0000c205, 0x0000c14a, 0x0000c08f, 0x0000bfd3, 0x0000bf16, 0x0000be59, 0x0000bd9c, 0x0000bcde, 0x0000bc1f, 0x0000bb5f, 0x0000ba9f, 0x0000b9df, 0x0000b91d, 
	0x0000b85c, 0x0000b799, 0x0000b6d6, 0x0000b612, 0x0000b54d, 0x0000b488, 0x0000b3c2, 0x0000b2fb, 0x0000b234, 0x0000b16b, 0x0000b0a2, 0x0000afd9, 0x0000af0e, 0x0000ae43, 0x0000ad77, 0x0000acaa, 
	0x0000abdd, 0x0000ab0e, 0x0000aa3f, 0x0000a96f, 0x0000a89e, 0x0000a7cd, 0x0000a6fa, 0x0000a626, 0x0000a552, 0x0000a47d, 0x0000a3a6, 0x0000a2cf, 0x0000a1f7, 0x0000a11e, 0x0000a044, 0x00009f68, 
	0x00009e8c, 0x00009daf, 0x00009cd1, 0x00009bf1, 0x00009b11, 0x00009a2f, 0x0000994c, 0x00009869, 0x00009783, 0x0000969d, 0x000095b6, 0x000094cd, 0x000093e3, 0x000092f8, 0x0000920b, 0x0000911d, 
	0x0000902e, 0x00008f3d, 0x00008e4b, 0x00008d58, 0x00008c63, 0x00008b6c, 0x00008a74, 0x0000897a, 0x0000887f, 0x00008782, 0x00008684, 0x00008583, 0x00008481, 0x0000837d, 0x00008278, 0x00008170, 
	0x00008067, 0x00007f5b, 0x00007e4e, 0x00007d3e, 0x00007c2c, 0x00007b18, 0x00007a02, 0x000078ea, 0x000077cf, 0x000076b2, 0x00007592, 0x00007470, 0x0000734b, 0x00007223, 0x000070f8, 0x00006fcb, 
	0x00006e9a, 0x00006d67, 0x00006c30, 0x00006af6, 0x000069b9, 0x00006878, 0x00006733, 0x000065ea, 0x0000649e, 0x0000634d, 0x000061f8, 0x0000609f, 0x00005f41, 0x00005dde, 0x00005c76, 0x00005b09, 
	0x00005996, 0x0000581d, 0x0000569e, 0x00005519, 0x0000538d, 0x000051fa, 0x0000505f, 0x00004ebc, 0x00004d10, 0x00004b5b, 0x0000499d, 0x000047d3, 0x000045ff, 0x0000441e, 0x00004230, 0x00004034, 
	0x00003e27, 0x00003c09, 0x000039d8, 0x00003790, 0x00003531, 0x000032b5, 0x00003019, 0x00002d57, 0x00002a67, 0x00002741, 0x000023d4, 0x0000200a, 0x00001bbf, 0x000016a7, 0x00001005, 0
};

/***********************************************************************************
 *				    Fixed Numbers
 ***********************************************************************************/

const EGE_fp pi			= 0x0003243f;
static const EGE_fp pitchr	= 0x028b436a;	// 2046/pi
static const EGE_fp p2		= 0x0006487e;	// 2*pi
static const EGE_fp hp		= 0x0001921f;	// pi/2
static const int hpr		= 0x00000065;	// pi/2046
static const EGE_fp pitchi	= 0x01ff8000;	// 1023/2


const EGE_fp		cosx(const EGE_fp ri) {
	EGE_fp r=ri;
	for (;r<fp_0;r+=p2);	for (;r>p2;r-=p2);
	if (r<hp)
		return cos_table[fp_to_int(fp_mul(r, pitchr)+fp_05)];
	else if (r<=pi)
		return -cos_table[2046-fp_to_int(fp_mul(r, pitchr)+fp_05)];
	else if (r<fp_mul(fp_from_int(3),hp))
		return -cos_table[fp_to_int(fp_mul(r, pitchr)+fp_05)-2046];
	else
		return cos_table[4092-fp_to_int(fp_mul(r, pitchr)+fp_05)];
}

const EGE_fp		sinx(const EGE_fp ri) {
	EGE_fp r=ri;
	for (;r<fp_0;r+=p2);	for (;r>p2;r-=p2);
	if (r<=hp)
		return cos_table[1023-fp_to_int(fp_mul(r, pitchr)+fp_05)];
	else if (r<pi)
		return cos_table[fp_to_int(fp_mul(r, pitchr)+fp_05)-1023];
	else if (r<=fp_mul(fp_from_int(3),hp))
		return -cos_table[3069-fp_to_int(fp_mul(r, pitchr)+fp_05)];
	else
		return -cos_table[fp_to_int(fp_mul(r, pitchr)+fp_05)-3069];
}

const EGE_fp		tanx(const EGE_fp ri) {
	EGE_fp r=ri;
	for (;r<fp_0;r+=p2);	for (;r>p2;r-=p2);
	if (r<hp)
		return tan_table[fp_to_int(fp_mul(r, pitchr)+fp_05)];
	else if (r<=pi)
		return -tan_table[2046-fp_to_int(fp_mul(r, pitchr)+fp_05)];
	else if (r<fp_mul(fp_from_int(3),hp))
		return tan_table[fp_to_int(fp_mul(r, pitchr)+fp_05)-2046];
	else
		return -tan_table[4092-fp_to_int(fp_mul(r, pitchr)+fp_05)];
}

const EGE_fp 		acosx(const EGE_fp ri) {
	EGE_fp r=ri;
	for (;r<-fp_1;r+=fp_from_int(2));	for (;r>fp_1;r-=fp_from_int(2));
	if (r==-fp_1)
		return pi;
	return acos_table[fp_to_int(fp_mul((r+fp_1), pitchi))+1];
}



/***********************************************************************************
 *					Vectors
 ***********************************************************************************/

void			EGE_vector_zero(EGE_vector v) {
	memset((void*)&v, 0, sizeof(EGE_vector));
}

EGE_vector *		EGE_vector_new(void) {
	EGE_vector* ret	= calloc(1, sizeof(EGE_vector));
	EGE_vector_zero(*ret);
	return ret;
}

EGE_vector *		EGE_vector_copy(const EGE_vector v) {
	EGE_vector* ret	= calloc(1, sizeof(EGE_vector));
	memcpy((void*)ret, (void*)&v, sizeof(EGE_vector));
	return ret;
}

void			EGE_vector_negate(EGE_vector v) {
	int i;
	for (i=0;i<3;i++)
		v[i] = -v[i];
}
void			EGE_vector_add_to(EGE_vector dest, const EGE_vector a) {
	int i;
	for (i=0;i<3;i++)
		dest[i] += a[i];
}

void			EGE_vector_del_from(EGE_vector dest, const EGE_vector a) {
	int i;
	for (i=0;i<3;i++)
		dest[i] -= a[i];
}

void			EGE_vector_multiply(EGE_vector dest, const EGE_fp s) {
	int i;
	for (i=0;i<3;i++)
		dest[i] = fp_mul(dest[i], s);
}

EGE_fp			EGE_vector_dot(const EGE_vector v, const EGE_vector a) {
	int i; EGE_fp ret = 0;
	for (i=0;i<3;i++)
		ret += fp_mul(v[i], a[i]);
	return ret;
}
__inline__ void		EGE_vector_divide(EGE_vector dest, const EGE_fp s) {	if(s==fp_0)return;	EGE_vector_multiply(dest,fp_div(fp_1, s));	}

void			EGE_vector_cross(EGE_vector res, const EGE_vector a, const EGE_vector b) {
	res[0] = fp_mul(a[1], b[2])+fp_mul(a[2], b[1]);
	res[1] = fp_mul(a[0], b[2])+fp_mul(a[2], b[0]);
	res[2] = fp_mul(a[1], b[0])+fp_mul(a[0], b[1]);
}

EGE_fp			EGE_vector_len2(const EGE_vector v) {
	int i; EGE_fp ret = 0;
	for (i=0;i<3;i++)
		ret += fp_mul(v[i], v[i]);
	return ret;
}

__inline__ EGE_fp	EGE_vector_length(const EGE_vector v) {	return fp_sqrt(EGE_vector_len2(v));	}

void			EGE_vector_normalize(EGE_vector v) {
	int i;
	const EGE_fp scale = fp_div(fp_1, fp_sqrt(fp_mul(v[0], v[0]) + fp_mul(v[1], v[1]) + fp_mul(v[2], v[2])));
	for (i=0;i<3;i++)
		v[i] = fp_mul(v[i], scale);
}

__inline__ Eina_Bool	EGE_vector_eq(const EGE_vector a, const EGE_vector b) {
	int i;
	for (i=0;i<3;i++)
		if (a[i]!=b[i])
			return EINA_FALSE;
	return EINA_TRUE;
}


/***********************************************************************************
 *					Matrix
 ***********************************************************************************/


EGE_matrix *		EGE_matrix_copy(EGE_matrix m) {
	EGE_matrix* ret	= calloc(1, sizeof(EGE_matrix));
	memcpy((void*)ret, (void*)&m, sizeof(EGE_matrix));
	return ret;
}

void			EGE_matrix_zero(EGE_matrix m) {
	memset((void*)&m, 0, sizeof(EGE_matrix));
}

EGE_matrix *		EGE_matrix_new(void) {
	EGE_matrix* ret	= calloc(1, sizeof(EGE_matrix));
	EGE_matrix_zero(*ret);
	return ret;
}

void			EGE_matrix_identity(EGE_matrix m) {
	memset((void*)&m, 0, sizeof(EGE_matrix));
	m[0][0] = m[1][1] = m[2][2] = m[3][3] = fp_1;
}

void			EGE_matrix_scale(EGE_matrix m, const EGE_fp s) {
	memset((void*)&m, 0, sizeof(EGE_matrix));
	m[0][0] = m[1][1] = m[2][2] = s;
	m[3][3] = fp_1;
}

void			EGE_matrix_translate(EGE_matrix m, const EGE_vector v) {
	int i;
	EGE_matrix_identity(m);
	for(i=0;i<3;i++)
		m[i][3] = v[i];
}

void			EGE_matrix_rotate(EGE_matrix m, const EGE_fp angle, const EGE_vector v) {
	EGE_fp fX2, fY2, fZ2, fXYM, fXZM, fYZM, fXs, fYs, fZs;
	EGE_vector *axis = EGE_vector_copy(v);
	EGE_fp fcos = cosx(angle);
	EGE_fp fomc = fp_1 - fcos;
	EGE_fp fsin = sinx(angle);
	EGE_vector_normalize(*axis);
	fX2 = fp_mul(*axis[0], *axis[0]);
	fY2 = fp_mul(*axis[1], *axis[1]);
	fZ2 = fp_mul(*axis[2], *axis[2]);
	fXYM= fp_mul(fp_mul(fomc, *axis[0]), *axis[1]);
	fXZM= fp_mul(fp_mul(fomc, *axis[0]), *axis[2]);
	fYZM= fp_mul(fp_mul(fomc, *axis[1]), *axis[2]);
	fXs = fp_mul(*axis[0], fsin);
	fYs = fp_mul(*axis[1], fsin);
	fZs = fp_mul(*axis[2], fsin);
	free(axis);
	
	m[0][0] = fp_mul(fX2,fomc) + fcos;
	m[0][1] = fXYM-fZs;
	m[0][2] = fXZM+fYs;
	m[0][3] = 0;

	m[1][0] = fXYM+fZs;
	m[1][1] = fp_mul(fY2,fomc) + fcos;
	m[1][2] = fYZM-fXs;
	m[1][3] = 0;

	m[2][0] = fXZM-fYs;
	m[2][1] = fYZM+fXs;
	m[2][2] = fp_mul(fZ2,fomc) + fcos;
	m[2][3] = 0;

	m[3][0] = 0;
	m[3][1] = 0;
	m[3][2] = 0;
	m[3][3] = fp_1;
}


/***********************************************************************************
 *				      Quaternion
 ***********************************************************************************/



