/** @file racer_editor/main.cpp
 * @brief Main function for the Racer editor.
 * @author James Legg
 */
/* Copyright © 2009 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but without any warranty; without even the implied warranty of
    merchantability or fitness for a particular purpose.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "RacerEditorApp.h"
#include "Debug.h"
#include <iostream>

#include <SDL.h>

///Main function. Just creates a RacerEditorApp object and returns.
int main(int argc, char **argv)
{
#ifdef NDEBUG
    std::cout << "Starting release build...\n";
#else
    std::cout << "Starting debug build...\n";
#endif
    SDL_Init(SDL_INIT_NOPARACHUTE);
    RacerEditorApp(argc, argv);
    DEBUG_MESSAGE("RacerEditorApp constructor returned.");
    SDL_Quit();
    return 0;
}
