/** @file EditorGuide.h
 *  @brief Declare the EditorGuide class. 
 *  @author James Legg
 */
/* Copyright © 2010 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/

#ifndef RACER_EDITOR_EDITOR_GUIDE_H
#define RACER_EDITOR_EDITOR_GUIDE_H

#include <gtkmm/infobar.h>
#include <gtkmm/label.h>
#include <gtkmm/box.h>

/** A widget which sits near the top of the editor and shows usage hints.
 */
class EditorGuide
    :   public Gtk::InfoBar
{
    public:
        EditorGuide();
    protected:
        /** Show one of the tips.
         * Sets the label's text, m_message_index, and sensitivity of buttons.
         * @param index Index of tip to show. 0 is the first tip.
         */
        void show_message(unsigned int index);
        
        virtual void on_response (int response_id);
        
        /// The label displaying the tip.
        Gtk::Label m_label;
        
        /** Index of displayed hint.
         * 0 is the first hint.
         */
        unsigned int m_message_index;
};

#endif // RACER_EDITOR_EDITOR_GUIDE_H
