/** @file EditorGuide.cpp
 *  @brief Implement the EditorGuide class. 
 *  @author James Legg
 */
/* Copyright © 2010 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/

#include "EditorGuide.h"

#include <string>

std::string _tips[] = {
    "Right click on empty space and select 'Insert vertex' to add a vertex.",
    "Use Best Fit on the View menu or tool bar to see the entire track. You can also zoom in and out and scroll manually.",
    "Drag a yellow cursor to move a vertex.",
    "Right click a yellow cursor to change a vertex's segment.\nThe available segments depend on theme.",
    "Right click a yellow cursor and press 'Delete vertex' to remove a vertex.",
    "You can undo your actions one at a time using Undo from the edit menu or tool bar.",
    "Use a green point to pick a vertex's forward direction.\nDragging it far away from the yellow cursor points it at the horizon.\nDragging it towards the yellow cursor points it above the horizon.",
    "Use a red point to pick a vertex's up direction.",
    "Drag a pink point to another to create an edge connecting two vertices.\nThe pink dots attach to specific points on the vertex's segment.\nThe order is important. Drag from where the cars enter the edge to where they leave it.\nRemember the green lines point forward.",
    "Right click a white line to change an edge's segment. Some segments are not suitable for use on edges.",
    "Right click a white line and press 'Make starting positions' to select the edge where the cars start the game. The end of the edge will become the start/finish line.\nIt is insensitive on the edge that already has the start positions.",
    "Drag the blue dots to change how the strong the curve is at each end of an edge.",
    "Right click a white line and press 'Delete edge' to remove an edge.",
    "Use Front and side view to change the height of vertices (drag yellow cursors up and down). It can also make setting the up direction easier (drag red dots).",
    "Right click a white line and press 'Add booster' to add a booster in the middle of an edge.",
    "You can move a booster along an edge by dragging its base.",
    "To delete a booster, right click the base and press 'Delete Attachment'.",
    "Once you have made a complete loop, use Test on the File menu or tool bar to race on your track.",
    };

const int _RI_show_previous = 1;
const int _RI_show_next = 2;

EditorGuide::EditorGuide()
{
    set_message_type(Gtk::MESSAGE_INFO);
    
    Gtk::Container* container = dynamic_cast<Gtk::Container*>(get_content_area());
    if (container)
    {
        container->add(m_label);
        m_label.set_line_wrap();
        m_label.show();
    }
    
    add_button("Previous tip", _RI_show_previous);
    add_button("Next tip", _RI_show_next);
    
    show_message(0);
}

void EditorGuide::show_message(unsigned int index)
{
    m_message_index = index;
    set_response_sensitive(_RI_show_previous, m_message_index > 0);
    set_response_sensitive(_RI_show_next, m_message_index < sizeof(_tips) / sizeof(std::string) - 1);
    m_label.set_text(_tips[m_message_index]);
}

void EditorGuide::on_response (int response_id)
{
    switch (response_id)
    {
        case _RI_show_previous:
            show_message(m_message_index - 1);
            break;
        case _RI_show_next:
            show_message(m_message_index + 1);
            break;
    }

}
