/** @file racer/main.cpp
 * Main function for the Racer game.
 * Just create a RacerApp object and return.
 * @author James Legg
 */
/* Copyright © 2009 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but without any warranty; without even the implied warranty of
    merchantability or fitness for a particular purpose.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
 
#include "RacerApp.h"
#include <Debug.h>
#include <iostream>

int main(int argc, char **argv)
{
#ifdef NDEBUG
    std::cout << "Starting release build...\n";
#else
    std::cout << "Starting debug build...\n";
#endif
    RacerApp(argc, argv);
    DEBUG_MESSAGE("RacerApp constructor returned.");
    return 0;
}

/** @mainpage
  * \section introduction Introduction
  * This website contains the developer documentation for Racer. For other 
  * articles, please visit the Racer wiki:
  * http://sourceforge.net/apps/mediawiki/racer/index.php?title=Main_Page
  * 
  * The wiki contains some more information about developing racer, as well as
  * usage, building, and track editing documentation.
  * 
  * You can join the Racer development mailing list if you want to help or ask
  * questions:
  * http://groups.google.co.uk/group/racer-dev/
  *
  * There is also also a notification mailing list for subversion commits
  * https://lists.sourceforge.net/lists/listinfo/racer-svn
  * 
  * You can also visit the sourceforge project page at
  * http://sourceforge.net/projects/racer
  * and file bugs on
  * http://sourceforge.net/apps/trac/racer/
  * 
  * 
  * \section overview Overview
  * The racer code is divided into several (mostly c++) components:
  * -# libtrack Is a statically linked library used by both the game and the
  *    editor to handle Tracks and their Themes.
  * -# racer is the game itself. It is divided into smaller components with
  *    multiple directories.
  * -# racer_editor is what you use to edit tracks.
  * -# There are also a couple of Blender python scripts used to export themes
  *    and cars created in Blender.
  */

