/** @file TitleScene.h
 *  @brief Declare the UI::TitleScene class.
 *  @author James Legg
 */
/* Copyright © 2009 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/
#ifndef TITLESCENE_H_
#define TITLESCENE_H_

#include "../Engine/Scene.h"
#include "../MainLoop.h"
#include <libtrack/Texture.h>
#include "MenuItem.h"
#include "SubMenuItem.h"
#include "GameStartMenuItem.h"
#include "ReplayStartMenuItem.h"

/// Menus and similar user interface for the game.
namespace UI
{

class Menu;

/** The scene that shows the main menu and logos.
 * This is the first Engine::Scene to be created. It provides acess to the main
 * menu.
 */
class TitleScene : public Engine::Scene
{
public:
    TitleScene();
    virtual ~TitleScene();
    void take_input(Engine::InputReport & report);
    void update_logic(unsigned int milliseconds_elapsed);
    void draw();
    void do_sound();
    virtual void attach_main_loop(MainLoop & main_loop);
private:
    float t;
    Track::Texture logo_texture;
    float fps;
    
    // menu stuff
    Menu * main_menu;
    // main menu items
    SubMenuItem mi_single_player;
    SubMenuItem mi_multiplayer;
    ReplayStartMenuItem mi_replay;
    MenuItem mi_options;
    MenuItem mi_quit;
    // single player submenu
    MenuItem mi_sp_grand_prix;
    MenuItem mi_sp_time_trial;
    MenuItem mi_sp_practice;
    // multiplayer submenu
    GameStartMenuItem mi_mp_c0;
    GameStartMenuItem mi_mp_c1;
    GameStartMenuItem mi_mp_c2;
    GameStartMenuItem mi_mp_c3;
    GameStartMenuItem mi_mp_c4;
};

}

#endif /*TITLESCENE_H_*/
