/** @file TitleScene.cpp
 *  @brief Implement the UI::TitleScene class.
 *  @author James Legg
 */
/* Copyright © 2009, 2010 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/
//#include <config.h>
#include "TitleScene.h"
#include "../Graphics/Window.h"
#include "BasicFonts.h"
#include "Menu.h"
#include "SubMenuItem.h"

#include <GL/gl.h>
#include <cmath>
#include <sstream>
#include <iostream>


namespace UI
{

TitleScene::TitleScene()
    :   t(0),
        logo_texture("data/icons/r512.png"),
        fps(0),
        main_menu(new Menu()),
        // main menu items
        mi_single_player(L"Single player"),
        mi_multiplayer(L"Play"),
        mi_replay(L"Watch Replay"),
        mi_options(L"Options"),
        mi_quit(L"Quit"),
        // single player submenu items
        mi_sp_grand_prix(L"Grand Prix"),
        mi_sp_time_trial(L"Time Trial"),
        mi_sp_practice(L"Practice"),
        // multiplayer submenu items
        mi_mp_c0(L"Track 0", "data/tracks/0")
    ,   mi_mp_c1(L"Track 1", "data/tracks/1")
    ,   mi_mp_c2(L"Track 2", "data/tracks/2")
    ,   mi_mp_c3(L"Track 3", "data/tracks/3")
    ,   mi_mp_c4(L"Track 4", "data/tracks/4")
{
    // add items to the main menu
    //main_menu->insert_item(&mi_single_player);
    main_menu->insert_item(&mi_multiplayer);
    main_menu->insert_item(&mi_replay);
    //main_menu->insert_item(&mi_options);
    //main_menu->insert_item(&mi_quit);
    
    // add items to the single player submenu
    Menu * single_player_menu = mi_single_player.get_menu();
    single_player_menu->insert_item(&mi_sp_grand_prix);
    single_player_menu->insert_item(&mi_sp_time_trial);
    single_player_menu->insert_item(&mi_sp_practice);
    
    // add items to the multiplayer menu
    Menu * multiplayer_menu = mi_multiplayer.get_menu();
    multiplayer_menu->insert_item(&mi_mp_c0);
    multiplayer_menu->insert_item(&mi_mp_c1);
    multiplayer_menu->insert_item(&mi_mp_c2);
    multiplayer_menu->insert_item(&mi_mp_c3);
    multiplayer_menu->insert_item(&mi_mp_c4);
}

TitleScene::~TitleScene()
{
}

void TitleScene::take_input(Engine::InputReport & report)
{
    // Menu interaction
    main_menu->take_input(report);
}

void TitleScene::update_logic(unsigned int milliseconds_elapsed)
{
    t += float(milliseconds_elapsed) * 0.0001;
    fps = 1000.0 / float(milliseconds_elapsed);
    if (main_menu->want_to_quit())
    {
        main_loop->pop_scene();
    }
}

void TitleScene::draw()
{
    glClearColor(sin(-t) * 0.5 + 0.5,
                 sin(-t + 2.0 * M_PI / 3.0) * 0.5 + 0.5,
                 sin(-t + 4.0 * M_PI / 3.0) * 0.5 + 0.5,
                 0.0);
    glClear(GL_COLOR_BUFFER_BIT);
    Graphics::Window::get_instance().set_ortho_projection();
    
    glEnable(GL_TEXTURE_2D);
    glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
    
    // draw logo in the middle.
    logo_texture.bind();
    glLoadIdentity();
    glTranslatef((float) Graphics::Window::get_instance().get_width() / 2.0,
                 (float) Graphics::Window::get_instance().get_height() / 2.0,
                 0.0 );
    float scale = 1.0 / (t * 5.0) + 1.0;
    glScalef(scale, scale, scale);
    glColor4f(1.0, 1.0, 1.0, 1.0 / scale);  
#if 0 //defined(HAVE_GLES)
    glBegin(GL_QUADS);
        glTexCoord2i(0, 1); glVertex2i(-256, -256);
        glTexCoord2i(0, 0); glVertex2i(-256, 256);
        glTexCoord2i(1, 0); glVertex2i(256, 256);
        glTexCoord2i(1, 1); glVertex2i(256, -256);
    glEnd();
#else
	GLshort vtx1[] = {	-256, -256,	-256, 256,	256, 256,	256, -256	};
	GLshort tex1[] = {	0, 1,		0, 0,		1, 0,		1, 1		};
	glEnableClientState(GL_VERTEX_ARRAY);
	glEnableClientState(GL_TEXTURE_COORD_ARRAY);
 
	glVertexPointer(2, GL_SHORT, 0, vtx1);
	glTexCoordPointer(2, GL_SHORT, 0, tex1);
	glDrawArrays(GL_TRIANGLE_FAN,0,4);
 
	glDisableClientState(GL_VERTEX_ARRAY);
	glDisableClientState(GL_TEXTURE_COORD_ARRAY);

#endif
    glLoadIdentity();
    
    // write build information in lower right corner.
#ifdef NDEBUG
#define build_message "Built on " __DATE__ " at " __TIME__ " in release mode."
#else
#define build_message "Built on " __DATE__ " at " __TIME__ " in debug mode."
#endif
    // shadow
    glColor4f(0, 0, 0, 0);
#ifdef HAVE_FTGL_2_1_3
    FTTextureFont & font = BasicFonts::get_instance().small_font;
    #define push
    #define pop
#else
    // old ftgl uses a different name and it messes with the matrix.
    FTGLTextureFont & font = BasicFonts::get_instance().small_font;
    #define push glPushMatrix();
    #define pop glPopMatrix();
#endif
    glTranslatef(8.0, 15.0, 0.0); push; font.Render(build_message); pop;
    glTranslatef(-2.0, 0.0, 0.0); push; font.Render(build_message); pop;
    glTranslatef(1.0, 1.0, 0.0); push; font.Render(build_message); pop;
    glTranslatef(0.0, -2.0, 0.0); push; font.Render(build_message); pop;
    // text
    glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
    glTranslatef(0.0, 1.0, 0.0);
    font.Render(build_message);
    glLoadIdentity();
#undef build_message    
#undef push
#undef pop

    // show the fps counter in adebug build.
#ifndef NDEBUG
    char msg[10] = "f/s: 000";
    int fpsi = fps > 999 ? 999 : int(fps); 
    msg[5] = fpsi / 100 + '0';
    msg[6] = (fpsi / 10) % 10 + '0';
    msg[7] = fpsi % 10 + '0';
    glTranslatef(Graphics::Window::get_instance().get_width() - 150, 15, 0);
    font.Render(msg);
    glLoadIdentity();
#endif
    
    // move to middle & draw menu there.
    glTranslatef(float (Graphics::Window::get_instance().get_width() / 2),
                 float (Graphics::Window::get_instance().get_height() / 2),
                 0.0 );
    main_menu->draw();
    glLoadIdentity();
}

void TitleScene::do_sound()
{
}

void TitleScene::attach_main_loop(MainLoop & main_loop)
{
    Scene::attach_main_loop(main_loop);
    // also tell the GameStartMenuItems to use this main loop.
    mi_mp_c0.set_main_loop(main_loop);
    mi_mp_c1.set_main_loop(main_loop);
    mi_mp_c2.set_main_loop(main_loop);
    mi_mp_c3.set_main_loop(main_loop);
    mi_mp_c4.set_main_loop(main_loop);
    mi_replay.set_main_loop(main_loop);
}

}
