/** @file SubMenuItem.cpp
 *  @brief Implement the UI::SubMenuItem class.
 *  @author James Legg
 */
/* Copyright © 2009 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/
#include "SubMenuItem.h"
#include "UITextures.h"

#include <GL/gl.h>

namespace UI
{

SubMenuItem::SubMenuItem(std::wstring label)
    :   MenuItem(label) 
{
}

SubMenuItem::~SubMenuItem()
{
}

void SubMenuItem::draw()
{
    // this will do most of the work
    MenuItem::draw();
    // now we just need the 3 small arrow heads
    get_menu_texture().bind();
#if 0 //defined(HAVE_GLES)
    glBegin(GL_QUADS);
        glTexCoord2f(0.65625, tex_coord_y_start); glVertex2i(105 + width, -32);
        glTexCoord2f(0.65625, tex_coord_y_end); glVertex2i(105 + width, 31);
        glTexCoord2f(1.0, tex_coord_y_end); glVertex2i(193 + width , 31);
        glTexCoord2f(1.0, tex_coord_y_start); glVertex2i(193 + width, -32);
    glEnd();
#else
	GLshort vtx1[] = {	105 + width, -32,		105 + width, 31,		193 + width , 31,		193 + width, -32	};
	GLfloat tex1[] = {	0.65625, tex_coord_y_start,	0.65625, tex_coord_y_end,	1.0, tex_coord_y_end,		1.0, tex_coord_y_start	};
	glEnableClientState(GL_VERTEX_ARRAY);
	glEnableClientState(GL_TEXTURE_COORD_ARRAY);
 
	glVertexPointer(2, GL_SHORT, 0, vtx1);
	glTexCoordPointer(2, GL_FLOAT, 0, tex1);
	glDrawArrays(GL_TRIANGLE_FAN,0,4);
 
	glDisableClientState(GL_VERTEX_ARRAY);
	glDisableClientState(GL_TEXTURE_COORD_ARRAY);
#endif
    // The parent menu will now draw with the right offset.
}

Menu * SubMenuItem::get_menu()
{
    return &menu;
}

}
