/** @file ReplayStartMenuItem.h
 *  @brief Declare the UI::ReplayStartMenuItem class.
 *  @author James Legg
 */
/* Copyright © 2009, 2010 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/

#include "GameStartMenuItem.h"
#include "../Engine/ReplayReader.h"

namespace UI
{

/* A MenuItem that starts a replay of the last game when activated.
 */
class ReplayStartMenuItem : public GameStartMenuItem
{
public:
    /** Create with the given label.
     * @param label The caption to display on the menu item.
     */
    ReplayStartMenuItem(std::wstring label);
    virtual ~ReplayStartMenuItem();
    virtual void activate();
};

}
