/** @file ReplayStartMenuItem.cpp
 *  @brief Implement the UI::ReplayStartMenuItem class.
 *  @author James Legg
 */
/* Copyright © 2009, 2010 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/

#include <fstream>
#include <iostream>
#include <GL/gl.h>
#include <glibmm/miscutils.h>

#include "ReplayStartMenuItem.h"
#include "../Engine/ReplayReader.h"
#include "../Graphics/Window.h"
#include <Debug.h>

#ifdef HAVE_GLES
#include "../Graphics/eglport.h"
#endif

namespace UI
{

ReplayStartMenuItem::ReplayStartMenuItem(std::wstring label)
    :   GameStartMenuItem(label, "")
{
}

ReplayStartMenuItem::~ReplayStartMenuItem()
{
}

void ReplayStartMenuItem::activate()
{
    assert(main_loop);
    DEBUG_MESSAGE("Replaying from a file.");
    std::ifstream replay_file((Glib::get_user_config_dir() + "/racer_last_replay").c_str());
    if (replay_file.fail())
    {
        // cannot load file
        std::cerr << "Unable to access the last replay. Perhaps it was never recorded?"
                  << std::endl;
        return;
    }
    glPushAttrib(GL_ALL_ATTRIB_BITS);
        Engine::ReplayReader replay(replay_file);
        main_loop->push_scene(*(replay.get_scene()));
    glPopAttrib();
    // reset viewport incase the window was resized during the game.
    glViewport(0, 0, Graphics::Window::get_instance().get_width(),
                     Graphics::Window::get_instance().get_height());
}


}
