/** @file UI/PauseMenu.h
 *  @brief Declare the UI::PauseMenu, UI::ContinueButton, and UI::QuitButton
 *  classes.
 *  @author James Legg
 */
/* Copyright © 2010 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/

#ifndef UI_PAUSE_MENU_H_
#define UI_PAUSE_MENU_H_

#include "Menu.h"

namespace UI
{

class PauseMenu;

/// A MenuItem for continuing a paused game.
class ContinueButton
    :   public MenuItem
{
    public:
        ContinueButton(PauseMenu & menu);
        virtual void activate();
    protected:
        PauseMenu & m_menu;
};

/// A MenuItem for abandoning a paused game.
class QuitButton
    :   public MenuItem
{
    public:
        QuitButton(PauseMenu & menu);
        virtual void activate();
    protected:
        PauseMenu & m_menu;
};

class PauseMenu
    :   public Menu
{
    public:
        /// User's choice on the pause menu.
        enum Response {
            /// No action confirmed yet.
            R_NONE,
            /// Continue the game
            R_CONTINUE,
            /// Quit the game
            R_QUIT};
        PauseMenu();
        /// Set the response to the given action
        void set_response(Response response);
        /// Return the user's choosen action.
        Response get_response() const;
        /// Reset the response so the menu can be used again.
        void reset();
    protected:
        ContinueButton m_continue_item;
        QuitButton m_quit_item;
        Response m_response;
};

} // namespace UI

#endif // UI_PAUSE_MENU_H_
