/** @file UI/PauseMenu.cpp
 *  @brief Implement the UI::PauseMenu, UI::ContinueButton, and UI::QuitButton
 *  classes.
 *  @author James Legg
 */
/* Copyright © 2010 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/

#include "PauseMenu.h"

namespace UI
{

ContinueButton::ContinueButton(PauseMenu & menu)
    :   MenuItem(L"Continue")
    ,   m_menu(menu)
{
}

void ContinueButton::activate()
{
    m_menu.set_response(PauseMenu::R_CONTINUE);
}

QuitButton::QuitButton(PauseMenu & menu)
    :   MenuItem(L"Quit")
    ,   m_menu(menu)
{
}

void QuitButton::activate()
{
    m_menu.set_response(PauseMenu::R_QUIT);
}

PauseMenu::PauseMenu()
    :   m_continue_item(*this)
    ,   m_quit_item(*this)
    ,   m_response(R_NONE)
{
    insert_item(&m_continue_item);
    insert_item(&m_quit_item);
}

void PauseMenu::set_response(Response response)
{
    m_response = response;
}
 
 
PauseMenu::Response PauseMenu::get_response() const
{
    return m_response;
}

void PauseMenu::reset()
{
    m_response = R_NONE;
    quit = false;
}

} // namespace UI
