/** @file MenuItem.cpp
 *  @brief Implement the UI::MenuItem class.
 *  @author James Legg
 */
/* Copyright © 2009 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/
#include "MenuItem.h"
#include "BasicFonts.h"
#include "UITextures.h"

#include <GL/gl.h>

namespace UI
{

MenuItem::MenuItem(std::wstring label)
    : label(label)
{
    set_state(S_NORMAL);
}

MenuItem::~MenuItem()
{
}

void MenuItem::draw()
{
    get_menu_texture().bind();
#if 0 //defined(HAVE_GLES)
    glBegin(GL_QUADS);
        // the inward pointy bit on the left
        glTexCoord2f(0.0, tex_coord_y_start); glVertex2i(0, -32);
        glTexCoord2f(0.0, tex_coord_y_end); glVertex2i(0, 31);
        glTexCoord2f(0.40625, tex_coord_y_end); glVertex2i(103, 31);
        glTexCoord2f(0.40625, tex_coord_y_start); glVertex2i(103, -32);
        // body background
        glTexCoord2f(0.40625, tex_coord_y_start); glVertex2i(103, -32);
        glTexCoord2f(0.40625, tex_coord_y_end); glVertex2i(103, 31);
        glTexCoord2f(0.4765625, tex_coord_y_end); glVertex2i(103 + width, 31);
        glTexCoord2f(0.4765625, tex_coord_y_start); glVertex2i(103 + width, -32);
        // the pointy bit on the right.
        glTexCoord2f(0.4765625, tex_coord_y_start); glVertex2i(103 + width, -32);
        glTexCoord2f(0.4765625, tex_coord_y_end); glVertex2i(103 + width, 31);
        glTexCoord2f(0.625, tex_coord_y_end); glVertex2i(141 + width , 31);
        glTexCoord2f(0.625, tex_coord_y_start); glVertex2i(141 + width, -32);
    glEnd();
#else
	GLshort vtx1[] = {	0, -32,				0, 31,				103, 31,			103, -32			};
	GLfloat tex1[] = {	0.0, tex_coord_y_start,		0.0, tex_coord_y_end,		0.40625, tex_coord_y_end,	0.40625, tex_coord_y_start	};
	GLshort vtx2[] = {	103, -32,			103, 31,			103 + width, 31,		103 + width, -32		};
	GLfloat tex2[] = {	0.40625, tex_coord_y_start,	0.40625, tex_coord_y_end,	0.4765625, tex_coord_y_end,	0.4765625, tex_coord_y_start	};
	GLshort vtx3[] = {	103 + width, -32,		103 + width, 31,		141 + width , 31,		141 + width, -32		};
	GLfloat tex3[] = {	0.4765625, tex_coord_y_start,	0.4765625, tex_coord_y_end,	0.625, tex_coord_y_end,		0.625, tex_coord_y_start	};

	glEnableClientState(GL_VERTEX_ARRAY);
	glEnableClientState(GL_TEXTURE_COORD_ARRAY);

	glVertexPointer(2, GL_SHORT, 0, vtx1);
	glTexCoordPointer(2, GL_FLOAT, 0, tex1);
	glDrawArrays(GL_TRIANGLE_FAN,0,4);

	glVertexPointer(2, GL_SHORT, 0, vtx2);
	glTexCoordPointer(2, GL_FLOAT, 0, tex2);
	glDrawArrays(GL_TRIANGLE_FAN,0,4);

	glVertexPointer(2, GL_SHORT, 0, vtx3);
	glTexCoordPointer(2, GL_FLOAT, 0, tex3);
	glDrawArrays(GL_TRIANGLE_FAN,0,4);

	glDisableClientState(GL_VERTEX_ARRAY);
	glDisableClientState(GL_TEXTURE_COORD_ARRAY);
#endif
    // now draw the text
    glPushMatrix();
        glTranslatef(100.0, 0.0, 0.0);
        // shadow
        glColor4f(0, 0, 0, 63.0/255.0);
        glPushMatrix();
            glTranslatef(1.0, 0.0, 0.0);
#ifdef HAVE_FTGL_2_1_2
            // old version of ftgl messes with the matrix.
# define push glPushMatrix()
# define pop glPopMatrix()
#else
# define push
# define pop
#endif
            push;
            BasicFonts::get_instance().big_font.Render(label.c_str());
            pop; glTranslatef(-3.0, 0.0, 0.0); push;
            BasicFonts::get_instance().big_font.Render(label.c_str());
            pop; glTranslatef(1.0, -1.0, 0.0); push;
            BasicFonts::get_instance().big_font.Render(label.c_str());
            pop; glTranslatef(0.0, 3.0, 0.0); push;
            BasicFonts::get_instance().big_font.Render(label.c_str());
            pop;
#undef push
#undef pop
        glPopMatrix();
        glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        BasicFonts::get_instance().big_font.Render(label.c_str());
    glPopMatrix();
}

void MenuItem::activate()
{
    set_state(S_ACTIVE);
}

void MenuItem::set_state(State state_in)
{
    state = state_in;
    tex_coord_y_start = float(state) * 0.25;
    tex_coord_y_end = tex_coord_y_start + 0.25;
}

MenuItem::State MenuItem::get_state()
{
    return state;
}

unsigned int MenuItem::get_min_width()
{
    width = BasicFonts::get_instance().big_font.Advance(label.c_str());
    return width + 193;
}

void MenuItem::set_width(unsigned int width_in)
{
    // we use width to determine the width of the text block, so deduct the frame
    width = width_in - 193;
}

}
