/** @file Menu.h
 *  @brief Declare the UI::Menu class.
 *  @author James Legg
 */
/* Copyright © 2009 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/
#ifndef MENU_H_
#define MENU_H_

#include "../Engine/InputReport.h"
#include "MenuItem.h"

#include <vector>

namespace UI
{

/** A graphical menu for the game.
 */
class Menu
{
public:
    Menu();
    virtual ~Menu();
    /** Add an item to those shown on the menu.
     * @param item The MenuItem to add. It must remain alive until draw and
     * take_input are no longer called.
     */
    void insert_item(MenuItem * item);
    /// Draw the menu on the screen
    void draw();
    /// Update the menu when input devices report menu events.
    void take_input(Engine::InputReport & report);
    /** return true if we would like the menu to close.
     * This occurs when the user tries back out of the menu.
     */
    bool want_to_quit();
protected:
    unsigned int get_total_width();
    std::vector<MenuItem *> items;
    unsigned int max_width;
    std::size_t selected_item; 
    Menu * active_sub_menu;
    Menu * parent;
    bool quit;
};

}

#endif /*MENU_H_*/
