/** @file GameStartMenuItem.h
 *  @brief Declare the UI::GameStartMenuItem class.
 *  @author James Legg
 */
/* Copyright © 2009, 2010 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/

#ifndef  GAME_START_MENU_ITEM_H
#define  GAME_START_MENU_ITEM_H

#include <vector>

#include "MenuItem.h"
#include "../MainLoop.h"
#include "../Engine/LoadScene.h"

namespace UI
{

/** A Menu item that starts a game when activated.
 */
class GameStartMenuItem : public MenuItem
{
public:
    /** Create with specified label to start specified track.
     * @param label The caption displayed on the menu item.
     * @param filename The filename of the track to load.
     */
    GameStartMenuItem(std::wstring label, std::string filename);
    
    virtual ~GameStartMenuItem();
    
    /** Start the game.
     * This is called when this menu item is selected from the menu.
     * set_main_loop() must have been called before activate().
     */
    virtual void activate();
    
    /** Set the main loop to use to start the game going.
     * @param main_loop The MainLoop to switch the scene of when activated.
     */
    void set_main_loop(MainLoop & main_loop);
protected:
    std::string filename;
    MainLoop * main_loop;
};

}

#endif // GAME_START_MENU_ITEM_H
