/** @file GameStartMenuItem.cpp
 *  @brief Implement the UI::GameStartMenuItem class.
 *  @author James Legg
 */
/* Copyright © 2009, 2010 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/

#include "GameStartMenuItem.h"

#include <fstream>
#include <GL/gl.h>

#include "../Engine/LoadScene.h"
#include "CarSelectScene.h"
#include "../Engine/InputHandler.h"
#include "../Graphics/Window.h"
#include <Debug.h>

#ifdef HAVE_GLES
#include "../Graphics/eglport.h"
#endif


namespace UI
{

GameStartMenuItem::GameStartMenuItem(std::wstring label,
                                     std::string filename)
    :   MenuItem(label)
    ,   filename(filename)
    ,   main_loop(0)
{
}

GameStartMenuItem::~GameStartMenuItem()
{
}

void GameStartMenuItem::activate()
{
    assert(main_loop);
    glPushAttrib(GL_ALL_ATTRIB_BITS);
        // select cars
        CarSelectScene car_select_scene;
        main_loop->push_scene(car_select_scene);
        // If that was not cancelled, start the game now?
        if (!car_select_scene.get_canceled())
        {
            Engine::LoadScene<> load_scene(car_select_scene.get_choice(),
                                           filename,
                                           1);
            main_loop->push_scene(load_scene);
        }
    glPopAttrib();
    // reset viewport incase the window was resized during the game.
    glViewport(0, 0, Graphics::Window::get_instance().get_width(),
                     Graphics::Window::get_instance().get_height());
}

void GameStartMenuItem::set_main_loop(MainLoop & main_loop_in)
{
    main_loop = &main_loop_in;
}

}
