/** @file BasicFonts.h
 *  @brief Declare the UI::BasicFonts class.
 *  @author James Legg
 */
/* Copyright © 2009 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/
#ifndef BASICFONTS_H_
#define BASICFONTS_H_

//#include <config.h> // to find out which headers to use for ftgl.

#define FT_FREETYPE_H <freetype/freetype.h>
#define FT_GLYPH_H <freetype/ftglyph.h>
#define FT_OUTLINE_H <freetype/ftoutln.h>
#ifdef HAVE_FTGL_2_1_2
# include <FTGL/FTGL.h>
# include <FTGL/FTGLTextureFont.h>
#else
# include <FTGL/ftgl.h>
#endif
#undef FT_FREETYPE_H
#undef FT_GLYPH_H
#undef FT_OUTLINE_H

namespace UI
{

/** A class that provides access to commonly used interface fonts.
 * Warning: FTGL 2.1.2 uses FTGLTextureFont instead of FTTextureFont, and
 * changes the OpenGL matrix when text is drawn. Check for FTGL versions with
 * config.h's HAVE_FTGL_2_1_2 for 2.1.2 and earlier versions, or
 * HAVE_FTGL_2_1_3 for 2.1.3 and later versions.
 */
class BasicFonts
{
public:
    ~BasicFonts();
    static BasicFonts & get_instance();
#ifdef HAVE_FTGL_2_1_3
    FTTextureFont small_font;
    FTTextureFont big_font;
#else
    FTGLTextureFont small_font;
    FTGLTextureFont big_font;
#endif
private:
    BasicFonts();
};

}

#endif /*BASICFONTS_H_*/
