/** @file BasicFonts.cpp
 *  @brief Implement the UI::BasicFonts class.
 *  @author James Legg
 */
/* Copyright © 2009 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/
#include "BasicFonts.h"

#include <iostream>

namespace UI
{

BasicFonts::~BasicFonts()
{
}
BasicFonts::BasicFonts()
:       /// @todo not hardcode font paths.
        small_font("data/ui/FreeSans.ttf"),
        big_font("data/ui/FreeSans.ttf")
{
    if (small_font.Error() || big_font.Error())
    {
        // Font didn't load properly.
        std::cerr << "Cannot load font data/ui/FreeSans.ttf\n";
        throw;
    }
    small_font.FaceSize(14);
    small_font.UseDisplayList(true);
    small_font.CharMap(ft_encoding_unicode);
    
    big_font.FaceSize(24);
    big_font.UseDisplayList(true);
    big_font.CharMap(ft_encoding_unicode);
}

BasicFonts & BasicFonts::get_instance()
{
    static BasicFonts * fonts = new BasicFonts;
    return *fonts;
}

}
