/** @file RacerApp.h
 *  @brief Declare the RacerApp class. 
 *  @author James Legg
 */
/* Copyright © 2009 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/

#ifndef RACERAPP_H_
#define RACERAPP_H_

#include "MainLoop.h"
#include "Engine/Scene.h"
#include "Engine/ReplayReader.h"
#include "Engine/GameScene.h"
#include <vector>

/* Class to handle command line arguments and start the game.
 */
class RacerApp
{
    public:
        /** constructor: When the constructor returns, the application
         *  shuts down.
         * @param argc Input to main function: number of parameters
         * @param argv Input to main function: parameters
         */
        RacerApp(int argc, char ** argv);
        /// Destuctor: do some final clearing up.
        ~RacerApp();
        
        /// Set the scene.
        void operator ()(Engine::GameScene * new_scene);
    private:
        void parse_arguments(int argc, char ** argv);
        void show_usage();
        Engine::Scene * title_scene;
        MainLoop * main_loop;
        Engine::ReplayReader * replay;
};

#endif /*RACERAPP_H_*/
