/** @file Window.h
 *  @brief Declare the Graphics::Window class.
 *  @author James Legg
 */
/* Copyright © 2009 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/
#ifndef WINDOW_H_
#define WINDOW_H_

#include "SDL.h"

/** The game's graphical objects.
 * Objects which have a graphical representation but also have relevance to
 * something else are generally in Engine, though they may inherit or contain
 * objects in Graphics.
 */
namespace Graphics
{

class Window
{
    public:
        static Window & get_instance();
        virtual ~Window();
        
        void swap_buffers();
        /// Set OpenGL to have 1 pixel = 1 spatial unit.
        void set_ortho_projection();
        unsigned int get_width() const;
        unsigned int get_height() const;
        void set_size(unsigned int width, unsigned int height, bool fullscreen = false);
    private:
        Window();
        bool created;
        unsigned int width;
        unsigned int height;
        bool fullscreen;
        int bpp;
        int flags;
};

}

#endif /*WINDOW_H_*/
