/** @file racer/Graphics/SkyParticles.h
 *  @brief Declare the Graphics::SkyParticles class.
 *  @author James Legg
 */
/* Copyright © 2010 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/

#ifndef GRAPHICS_SKY_PARTICLES_H_
#define GRAPHICS_SKY_PARTICLES_H_

#include <LinearMath/btVector3.h>
#include <libtrack/Texture.h>
#include "../Engine/CarCamera.h"

namespace Graphics
{

/// Particles that float in the sky (rain, snow, dust, ...).
class SkyParticles
{
    public:
        /// Initialise, placing the particles in a random place.
        SkyParticles();
        /** Simulate the particles over the given time period
         * @param milliseconds_elapsed The number of milliseconds to simulate.
         * Should be less than 16000.
         */
        void update(unsigned milliseconds_elapsed);
        /// Draw the particles around the given camera.
        void draw(const Engine::CarCamera & camera);
    private:
        const static int m_num_particles = 1024;
        /// The positions of the particles in the origin cube.
        btVector3 particles[m_num_particles];
        /// The texture the particles are drawn with.
        Track::Texture * m_texture;
        /// The phase of the spiral effect.
        float phase;
};

} // namespace Graphics

#endif // GRAPHICS_SKY_PARTICLES_H_
