/** @file SkyBox.h
 *  @brief Declare the Graphics::SkyBox class.
 *  @author James Legg
 */
/* Copyright © 2009 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/
#ifndef SKYBOX_H_
#define SKYBOX_H_

#include <string>

#include <libtrack/Texture.h>
#include <libtrack/Skybox.h>

namespace Graphics
{

class SkyBox : public Track::Skybox
{
private:
    /// cannot be copied as it could delete the OpenGL display list.
    SkyBox(const SkyBox & sky_box);
    SkyBox & operator=(const SkyBox & skybox);
public:
    SkyBox(std::string filename_base);
    /// construct from the skybox found in a theme
    SkyBox(const Track::Skybox & source);
    virtual ~SkyBox();
    void draw();
protected:
    void make_list();
    unsigned int display_list;
};

}

#endif /*SKYBOX_H_*/
