/** @file SkyBox.cpp
 *  @brief Implement the Graphics::SkyBox class.
 *  @author James Legg
 */
/* Copyright © 2009 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/
#include "SkyBox.h"

#include <GL/gl.h>
#include <stdio.h>

#ifdef HAVE_GLES
#define GL_CLAMP     GL_CLAMP_TO_EDGE
#endif

namespace Graphics
{

SkyBox::SkyBox(std::string filename_base)
{
    const std::string extensions[6] = {".+z", ".-z", ".-x", ".+x", ".-y", ".+y"};
    textures.reserve(6);
    for (unsigned int face = 0; face < 6; face++)
    {
        std::string filename = filename_base + extensions[face];
        textures.push_back(boost::shared_ptr<Track::Texture>(new Track::Texture(filename)));
        glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
        glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
    }
    make_list();
}

void SkyBox::make_list()
{
#if 0 // !defined(HAVE_GLES)
    display_list = glGenLists(1);
    glNewList(display_list, GL_COMPILE);
        // l is the scale for the skybox vertex coordinates. 
        const float l = 577.35026919;
        const float cmz[6][4][3] = {{{-l, l, -l}, {l, l, -l}, {l, -l, -l}, {-l, -l, -l}}, // -z
                                  {{-l, -l, l}, {l, -l, l}, {l, l, l}, {-l, l, l}}, // +z
                                  {{-l, -l, l}, {-l, l, l}, {-l, l, -l}, {-l, -l, -l}}, // -x
                                  {{l, l, l}, {l, -l, l}, {l, -l, -l}, {l, l, -l}}, // +x
                                  {{l, -l, l}, {-l, -l, l}, {-l, -l, -l}, {l, -l, -l}}, // -y
                                  {{-l, l, l}, {l, l, l}, {l, l, -l}, {-l, l, -l}}}; // +y
        const float coord[4][2] = {{0.0, 0.0}, {1.0, 0.0}, {1.0, 1.0}, {0.0, 1.0}};                       
        for (unsigned int face = 0; face < 6; face++)
        {
            textures[face]->bind();
            glBegin(GL_QUADS);
                for (int vertex = 3; vertex >= 0; vertex--)
                {
                    glTexCoord2f(coord[vertex][0], coord[vertex][1]);
                    glVertex3f(cmz[face][vertex][0], cmz[face][vertex][1], cmz[face][vertex][2]);
                } 
            glEnd();
        }
    glEndList();
#endif
}

SkyBox::SkyBox(const Track::Skybox & source)
    :   Track::Skybox(source)
{
    for (unsigned int face = 0; face < 6; face++)
    {
        textures[face]->bind();
        glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
        glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
    }
    make_list();
}

SkyBox::~SkyBox()
{
#if 0 //!defined(HAVE_GLES)
    glDeleteLists(display_list, 1);
#endif
}

void SkyBox::draw()
{
#if 0 //!defined(HAVE_GLES)
    glCallList(display_list);
#else
	const GLfloat l = 577.35026919;
	const GLfloat vtx[6][12] = {	{-l, -l, -l,	l, -l, -l,	l, l, -l,	-l, l, -l},	// -z
					{-l, l, l,	l, l, l,	l, -l, l,	-l, -l, l},	// +z
					{-l, -l, -l,	-l, l, -l,	-l, l, l,	-l, -l, l},	// -x
					{l, l, -l,	l, -l, -l,	l, -l, l,	l, l, l},	// +x
					{l, -l, -l,	-l, -l, -l,	-l, -l, l,	l, -l, l},	// -y
					{-l, l, -l,	l, l, -l,	l, l, l,	-l, l, l}};	// +y
	const GLfloat tex[] = {		0.0, 0.0, 	1.0, 0.0,	1.0, 1.0,	0.0, 1.0};

	glEnableClientState(GL_VERTEX_ARRAY);
	glEnableClientState(GL_TEXTURE_COORD_ARRAY);
	glTexCoordPointer(2, GL_FLOAT, 0, tex);
	for (unsigned int face = 0; face < 6; face++) {
		textures[face]->bind();
		glVertexPointer(3, GL_FLOAT, 0, vtx[face]);
		glDrawArrays(GL_TRIANGLE_FAN,0,4);
	}
	glDisableClientState(GL_VERTEX_ARRAY);
	glDisableClientState(GL_TEXTURE_COORD_ARRAY);

#endif
}

}
