/** @file CubeMap.h
 *  @brief Declare the Graphics::CubeMap class.
 *  @author James Legg
 */
/* Copyright © 2009 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/
#ifndef CUBEMAP_H_
#define CUBEMAP_H_

#include <libtrack/Texture.h>

namespace Graphics
{

/** Cubemap for shiny things. My system thinks I would rather have my X server
 * frozen than display shiny things, so it is currently unused. :-(
 */
class CubeMap : public Track::Texture
{
public:
    /** @param filename_base path and beginning of filename. Must be able to get
     * the files for each face by adding digits 0 to 5.
     */
    CubeMap(std::string filename_base);
    
    virtual ~CubeMap();
    
    void draw_sky_box();
};

}

#endif /*CUBEMAP_H_*/
