/** @file TickObserver.h
 *  @brief Declare the Engine::Physics::TickObserver class.
 *  @author James Legg
 */
/* Copyright © 2009 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/
#ifndef TICKOBSERVER_H_
#define TICKOBSERVER_H_

namespace Engine
{

namespace Physics
{

/** Abstract base class for anything that needs to be notifed when the physics
 * engine ticks.
 * 
 * Generally used for physics objects that react to things and apply forces.
 * Can also be used for various triggers.
 */
class TickObserver
{
public:
    /// evaluate forces, state, etc.
    virtual void posttick() = 0;
    /// use bullet's applyForces function on some objects
    virtual void set_forces(){};
};

}

}

#endif /*TICKOBSERVER_H_*/
