/** @file InputReport.cpp
 *  @brief Implement the Engine::InputReport class.
 *  @author James Legg
 */
/* Copyright © 2009, 2010 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/
#include "InputReport.h"
#include "InputDevice.h"
#include "InputHandler.h"

namespace Engine
{

InputReport::InputReport(const InputDevice * const input_device, ReportType type, int value)
    :   input_device(input_device->get_handle()),
        type(type),
        value(value)
{
}

InputReport::~InputReport()
{
}

InputReport::ReportType InputReport::get_report_type() const
{
    return type;
}

int InputReport::get_value() const
{
    return value;
}

std::set<InputDevice *>::iterator InputReport::get_input_device() const
{
    return input_device;
}

}
