/** @file InputDeviceReplay.h
 *  @brief Declare the Engine::InputDeviceReplay class.
 *  @author James Legg
 */
/* Copyright © 2009 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/
#ifndef INPUT_DEVICE_REPLAY_H_
#define INPUT_DEVICE_REPLAY_H_

#include "InputDevice.h"
#include <SDL.h>

namespace Engine
{

/** A input device that repeats a recording.
 * This is generally used to repeat what a different input device once did.
 * AI should be deterministic, so that they don't need to be recorded. This
 * should make the replays take less space.
 * 
 * The InputDeviceReplay doesn't do much work, since the ReplayReader reads
 * events off a file and handles the timing and device identification stuff.
 */
class InputDeviceReplay : public Engine::InputDevice
{
public:
    InputDeviceReplay();
    ~InputDeviceReplay();
    int get_acceleration();
    int get_slide();
    int get_steering();
    /// Make an input report.
    void relay(InputReport::ReportType report_type, unsigned int value);
private:
    int steering, acceleration, slide;
};

}

#endif
