/** @file InputDeviceReplay.cpp
 *  @brief Implement the Engine::InputDeviceReplay class.
 *  @author James Legg
 */
/* Copyright © 2009 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/

#include "InputDeviceReplay.h"
#include <Debug.h>
#include "GameObjects/Car.h"

namespace Engine
{

InputDeviceReplay::InputDeviceReplay()
    :   steering(0)
    ,   acceleration(0)
    ,   slide(0)
{
}

InputDeviceReplay::~InputDeviceReplay()
{
}

int InputDeviceReplay::get_steering()
{
    return steering;
}

int InputDeviceReplay::get_acceleration()
{
    return acceleration;
}

int InputDeviceReplay::get_slide()
{
    return slide;
}

void InputDeviceReplay::relay(InputReport::ReportType report_type,
                              unsigned int value)
{
    InputReport report(this, report_type, value);
    if(scene)
    {
        scene->take_input(report);
    }
    if (car)
    {
        car->take_input(report);
    }
}
 

}
