/** @file InputDeviceKeyboard.h
 *  @brief Declare the Engine::InputDeviceKeyboard class.
 *  @author James Legg
 */
/* Copyright © 2009 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/
#ifndef INPUTDEVICEKEYBOARD_H_
#define INPUTDEVICEKEYBOARD_H_

#include "InputDevice.h"

namespace Engine
{

/** A input device that handles keyboard input:
 * -WASD is used for stearing
 * -Q/W is for sliding
 * -arrow keys for the menu
 * -enter / space select
 * -Escape / backspace back
 * 
 * @todo make keys configurable.
 * @todo Allow also WASD for the menu and arrow keys for steering.
 * 
 * Must be polled for SDL to work.
 */
class InputDeviceKeyboard : public Engine::InputDevice
{
public:
    InputDeviceKeyboard();
    ~InputDeviceKeyboard();
    int get_acceleration();
    int get_slide();
    int get_steering();
    void poll();
private:
    bool accelerate_down, break_down, steer_left_down, steer_right_down,
        slide_left_down, slide_right_down;
};

}

#endif /*INPUTDEVICEKEYBOARD_H_*/
