/** @file InputDeviceJoystick.h
 *  @brief Declare the Engine::InputDeviceJoystick class.
 *  @author James Legg
 */
/* Copyright © 2009 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/
#ifndef INPUT_DEVICE_JOYSTICK_H_
#define INPUT_DEVICE_JOYSTICK_H_

#include "InputDevice.h"
#include <SDL.h>

namespace Engine
{

/** A input device that handles joystick input:
 * - The Y axis is used for acceleration.
 * - The X axis is used for stearing.
 * - Buttons 4 and 5 are used for sliding.
 * @todo Add support for horizontal menus.
 */
class InputDeviceJoystick : public Engine::InputDevice
{
public:
    /// Process the input of one joystick detected by SDL.
    /// @param index The index SDL uses for the joystick.
    InputDeviceJoystick(int index);
    ~InputDeviceJoystick();
    int get_acceleration();
    int get_slide();
    int get_steering();
    void poll();
private:
    /// The index SDL uses for the joystick.
    int joystick_index;
    SDL_Joystick *sdl_joystick_handle;
    int steering, acceleration, slide;
    bool slide_left_down, slide_right_down;
};

}

#endif /*INPUT_DEVICE_JOYSTICK_H_*/
