/** @file InputDeviceAI.h
 *  @brief Declare the Engine::InputDeviceAI class.
 *  @author James Legg
 */
/* Copyright © 2010 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/
#ifndef INPUT_DEVICE_AI_H
#define INPUT_DEVICE_AI_H

#include "InputDevice.h"
#include "floatfann.h"

namespace Engine
{

/** A input device for a computer player.
 * Simulated events occur when an AI decides.
 */
class InputDeviceAI : public Engine::InputDevice
{
public:
    InputDeviceAI();
    virtual ~InputDeviceAI();
    virtual int get_acceleration();
    virtual int get_slide();
    virtual int get_steering();
    virtual void poll();
    /// Write the neural network to a file.
    void save();
    /// Add some random variance to the neural network
    void mutate();
    /// Set neural network weights that combine those of another two InputDeviceAIs.
    void cross(const InputDeviceAI & p1, const InputDeviceAI & p2);
private:
    int acceleration, slide, steering;
    fann * ann;
};

} // namespace Engine

#endif // INPUT_DEVICE_AI_H
