/** @file InputDevice.cpp
 *  @brief Implement the Engine::InputDevice class. 
 *  @author James Legg
 */
/* Copyright © 2009, 2010 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/
#include "InputDevice.h"
#include "GameObjects/Car.h"
#include "InputHandler.h"

namespace Engine
{

InputDevice::InputDevice()
    : scene(0),
      car(0)
{
    handler_reference = InputHandler::get_instance().add_device(*this);
}

InputDevice::~InputDevice()
{
    InputHandler::get_instance().remove_device(InputHandler::iterator(handler_reference));
}

void InputDevice::set_scene(Scene & scene_in)
{
    scene = &scene_in;
}

void InputDevice::set_car(GameObjects::Car * car_in)
{
    car = car_in;
}

std::set<InputDevice *>::iterator InputDevice::get_handle() const
{
    return handler_reference;
}

void InputDevice::report(InputReport::ReportType type, int value)
{
    InputReport report(this, type, value);
    if(scene)
    {
        scene->take_input(report);
    }
    if (car)
    {
        car->take_input(report);
    }   
}

}
