/** @file CarCamera.h
 *  @brief Declare the Engine::CarCamera class. 
 *  @author James Legg
 */
/* Copyright © 2009, 2010 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/
#ifndef CARCAMERA_H_
#define CARCAMERA_H_

#include "GameObjects/Car.h"
#include "Physics/TickObserver.h"
#include "Physics/World.h"
#include "Audio.h"

namespace Engine
{

class CarCamera : public Physics::TickObserver
{
public:
    CarCamera(GameObjects::Car & car, Physics::World & world);
    virtual ~CarCamera();
    void full_transform();
    void rotation_transform();
    
    virtual void posttick() ;
    virtual void set_forces() {};
    
    /** Set the view frustrum in an occlusion_tester.
     * Sets the occlusion_tester to occlude objects behind the camera, or off
     * any side of the display.
     * @param occlusion_tester the occlusion_tester to give the view frustrum too.
     * @param aspect the ratio between width and height of the display region.
     */
    void update_occlusion_tester(Track::OcclusionTester & occlusion_tester, btScalar aspect) const;
    
    /// Get the location of the camera in world space.
    const btVector3 & get_location() const;
    /// Get the movement of the camera over the last physics tick.
    const btVector3 & get_velocity() const;
private:
    GameObjects::Car & car;
    Physics::World & world;
    btVector3 location;
    btVector3 up;
    btVector3 centre;
    btVector3 m_velocity;
    SoundListener m_listener;
};

}

#endif /*CARCAMERA_H_*/
