#!BPY
# This Python file uses the following encoding: utf-8

"""
Name: 'Racer Mesh Exporter'
Blender: 244
Group: 'Export'
Tooltip: 'Export meshes to the racer game'
"""

##@file python/racer_mesh_export.py
#@brief Provide a Blender exporter for mesh objects.
#@author James Legg

# Copyright © 2009, 2010 James Legg.
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

## @package racer_mesh_export
#  Export a single mesh for the racer game.
# This is used for cars and the track boosters for example.
#
# For more information about making cars see
# http://sourceforge.net/apps/mediawiki/racer/index.php?title=Making_cars.

import Blender
import bpy
import racer_theme_export

## Write a mesh file to the given filename.
#@param filename The filename to write the mesh to.
def write(filename):
    out = file(filename, "w")
    sce= bpy.data.scenes.active
    for ob in Blender.Object.GetSelected():
        print ob.getType()
        if ob.getType() == 'Mesh':
            racer_theme_export.write_mesh(out, ob)

Blender.Window.FileSelector(write, "Export")

