/** @file libtrack/path/PathEdgeEnd.cpp
 *  @brief Implement the Track::PathEdgeEnd class.
 *  @author James Legg
 */
/* Copyright © 2009 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/

#include "PathEdgeEnd.h"
#include "../stream_loader.h"
#include "../FormErrors.h"

namespace Track
{

const unsigned int path_edge_end_newest_version = 1;

PathEdgeEnd::PathEdgeEnd(std::size_t edge_index, EditAssist::EdgeStrengthHandle::EdgeEnd end)
    :   file_version(0)
    ,   gradient_strength(10.0)
    ,   handle(edge_index, end)
{
}

PathEdgeEnd::PathEdgeEnd(std::istream & source, std::size_t edge_index,
                         EditAssist::EdgeStrengthHandle::EdgeEnd end)
    :   file_version(int_from_stream(source))
    ,   handle(edge_index, end)
{
    if (file_version == 0) throw CorruptedError();
    if (file_version > path_edge_end_newest_version) throw NewVersionError();
    source >> gradient_strength >> segment_connection_index;
}

PathEdgeEnd::~PathEdgeEnd()
{
    
}

std::ostream & operator<<(std::ostream & destination, const PathEdgeEnd & path_edge_end)
{
    destination << path_edge_end_newest_version << ' '
                << path_edge_end.gradient_strength << ' '
                << path_edge_end.segment_connection_index;
    return destination;
}

}
