/** @file libtrack/edit_base/TrackAttachmentHandle.h
 *  @brief Declare the Track::EditAssist::TrackAttachmentHandle class. 
 *  @author James Legg
 */
/* Copyright © 2010 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/
#ifndef LIBTRACK_EDIT_BASE_TRACK_ATTACHMENT_HANDLE_H
#define LIBTRACK_EDIT_BASE_TRACK_ATTACHMENT_HANDLE_H

#include "ControlPoint.h"

namespace Track
{

class PathEdge;

namespace EditAssist
{

/** Control point for an object which can be dragged along an edge.
 */
class TrackAttachmentHandle
    :   public ControlPoint
{
public:
    TrackAttachmentHandle(const PathEdge & edge, std::size_t attachment_index);
    virtual void draw() const;
    
    virtual void snap(btVector3 & position, btVector3 normal) const;
    
    virtual boost::shared_ptr<Document::DocumentDelta> make_delta(btVector3 position) const;
    /// Make a delta which will remove the TrackAttachment from the edge.
    boost::shared_ptr<Document::DocumentDelta> make_remove_delta() const;
protected:
    const PathEdge & m_edge;
    std::size_t m_attachment_index;
};

}

}

#endif // LIBTRACK_EDIT_BASE_TRACK_ATTACHMENT_HANDLE_H
