/** @file libtrack/edit_base/Selectable.h
 *  @brief Declare the Track::EditAssist::Selectable class. 
 *  @author James Legg
 */
/* Copyright © 2009 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/
#ifndef LIBTRACK_SELECTABLE_H_
#define LIBTRACK_SELECTABLE_H_

#include <LinearMath/btVector3.h>

namespace Track
{

namespace EditAssist
{

/** Object that reacts to mouse clicks in an editor's view of the track.
 * A Selectable can be selected by clicking on it.
 */
class Selectable
{
public:
    /** Check if the object lies along a given line segment
     * @param start The start position of the line in world space.
     * @param stop The end position of the line in world space
     * @param radius to consider points near the line
     * @return true if it is on or near the line, false otherwise.
     */
    virtual bool is_here(btVector3 start, btVector3 stop, btScalar radius) const = 0;
};

}

}

#endif
