/** @file libtrack/edit_base/SegmentConnectionHandle.h
 *  @brief Declare the Track::EditAssist::SegmentConnectionHandle class. 
 *  @author James Legg
 */
/* Copyright © 2009 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/

#ifndef LIBTRACK_EDIT_BASE_SEGMENT_CONNECTION_HANDLE_H
#define LIBTRACK_EDIT_BASE_SEGMENT_CONNECTION_HANDLE_H

#include "ControlPoint.h"
#include "../SegmentConnection.h"

namespace Track
{

namespace EditAssist
{

class SegmentConnectionHandle
    :   public ControlPoint
{
public:
    /* Create for a specific connection.
     * @param track The track this applies to.
     * @param vertex_name The name of the vertex the handle is attached to.
     * @param  connection_index The index of the Track::SegmentConnection in
     * its Track::Segment.
     * @param segment_connection A pointer to the segment connection used.
     */
    SegmentConnectionHandle(const Track & track,
                            std::size_t vertex_name,
                            std::size_t connection_index,
                            const SegmentConnection * segment_connection);
    virtual ~SegmentConnectionHandle();
    virtual void draw() const ;
    virtual void snap(btVector3 & position, btVector3 normal) const;
    virtual boost::shared_ptr<Document::DocumentDelta> make_delta(btVector3 position) const;
protected:
    /// The track this applies to.
    const Track & track;
    /// The name of the vertex the handle is on.
    const std::size_t vertex_name;
    /// The index Track::Segment gives for the SegmentConnection the handle is on.
    const std::size_t connection_index;
    /// Pointer to the segment_connection used for this vertex.
    const SegmentConnection * segment_connection;
};

} // namespace EditAssist

} // namespace Track

#endif // LIBTRACK_EDIT_BASE_SEGMENT_CONNECTION_HANDLE_H
