/** @file libtrack/edit_base/RotationHandle.h
 *  @brief Declare the Track::EditAssist::RotationHandle class. 
 *  @author James Legg
 */
/* Copyright © 2009 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/
#ifndef ROTATION_HANDLE_H_
#define ROTATION_HANDLE_H_

#include "ControlPoint.h"

namespace Track
{

namespace EditAssist
{

/** A ControlPoint that stays a fixed distance from another point.
 * The distance doesn't really mean anything, but the direction does.
 */
class RotationHandle
    :   public ControlPoint
{
public:
    /** Snap a position to a valid location.
     * If the position is outside of the allowed radius, it is moved to the 
     * nearest position on the circle around the normal.
     * If it is less than the allowed radius, it is moved along normal until
     * it reaches the sphere.
     * @param position position to adjust.
     * @param normal unit vector pointing into the user's view.
     */
    virtual void snap(btVector3 & position, btVector3 normal) const;
    
    virtual void draw() const;
    
    /** Set the distance between the centre point and the control point.
     * This does not affect the direction.
     */ 
    void set_length(btScalar new_length);    
    
    /** Set the point where the RotationHandle moves around.
     */
    void set_centre(btVector3 new_centre);
protected:
    btVector3 centre;
    btScalar length;
};

}

}

#endif // ROTATION_HANDLE_H_
