/** @file libtrack/edit_base/LineConstrainedControlPoint.h
 *  @brief Declare the Track::EditAssist::LineConstrainedControlPoint class. 
 *  @author James Legg
 */
/* Copyright © 2009 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/
#ifndef LIBTRACK_EDIT_BASE_LINE_CONSTRAINED_CONTROL_POINT_H
#define LIBTRACK_EDIT_BASE_LINE_CONSTRAINED_CONTROL_POINT_H

#include "ControlPoint.h"

namespace Track
{

namespace EditAssist
{

/** A handle constrained to a line, half line, or line segment.
 */
class LineConstrainedControlPoint
    :   public ControlPoint
{
public:
    /** Create using a line
     *  You must specify start and stop points before using snap.
     */
    LineConstrainedControlPoint();
    
    virtual ~LineConstrainedControlPoint();
    
    /** Snap to the nearest screen space position along the line.
     * The line should have been previously specified using start and stop.
     * allow_before_start and allow_after_end control weather to use a line,
     * half line, or line segment.
     * @param position The position to snap to the line.
     * @param normal A unit vector pointing into the screen.
     */
    virtual void snap(btVector3 & position, btVector3 normal) const;
    
    virtual void draw() const;
protected:
    /** Create specifying snap limits.
     * You must specify start and stop points before using snap.
     * With both parameters false, you get a line segment. Both true is a line.
     * One true and one false gives you a half line.
     * @param allow_before_start true to allow positions that are behind the starting vertex.
     * @param allow_after_end true to allow positions that are infront of the ending vertex.
     */
    LineConstrainedControlPoint(bool allow_before_start, bool allow_after_end);
    
    /// The starting vertex of the line to constrain to.
    btVector3 start;
    /// The ending vertex of the line to constrain to.
    btVector3 stop;
    /// set true to accept positions behind the starting vertex
    bool allow_before_start;
    /// set true to accept positions after the stop vertex.
    bool allow_after_end;
};

} // EditAssist namespace

} // Track namespace

#endif // LIBTRACK_EDIT_BASE_LINE_CONSTRAINED_CONTROL_POINT_H
