/** @file libtrack/edit_base/Dragable.h
 *  @brief Declare the Track::EditAssist::Dragable class. 
 *  @author James Legg
 */
/* Copyright © 2009 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/
#ifndef LIBTRACK_DRAGABLE_H_
#define LIBTRACK_DRAGABLE_H_

#include "Selectable.h"
#include <boost/shared_ptr.hpp>
#include <LinearMath/btVector3.h>
#include "../document/DocumentDelta.h"

namespace Track
{

namespace EditAssist
{

/** A Selectable which can be dragged.
 * This is a base class for objects that can be moved by dragging them across
 * a view in the editor.
 */
class Dragable
    :   public Selectable
{
public:
    /** Adjust a position the object was dragged to to the nearest valid
     * location.
     * @param position to adjust.
     * @param normal direction which the user cannot see as their view
     * is looking down it.
     */
    virtual void snap(btVector3 & position, btVector3 normal) const;
    
    /** Make a DocumentDelta that moves the object to a new position.
     * @param position the desired position of the Selectable after the
     * DocumentDelta is applied.
     * @return A shared pointer to a DocumentDelta which moves the
     * selectable from its current position to the requested position.
     */
    virtual boost::shared_ptr<Document::DocumentDelta> make_delta(btVector3 position) const = 0;
};

}

}

#endif // LIBTRACk_DRAGABLE_H_
