/** @file libtrack/edit_base/ControlPoint.h
 *  @brief Declare the Track::EditAssist::ControlPoint class. 
 *  @author James Legg
 */
/* Copyright © 2009 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/
#ifndef CONTROL_POINT_H_
#define CONTROL_POINT_H_

#include "Dragable.h"

#include <LinearMath/btVector3.h>

namespace Track
{

/** Features for that mostly make sense for an editor.
 * This is the ideal namespace for things which are built in to elements of
 * the Track namespace, but are only used for the editor. Its contents is
 * independent of any user interface library.
 */
namespace EditAssist
{

/** A Dragable point.
 */
class ControlPoint
    :   public Dragable
{
public:
    // from Track::Selectable
    virtual bool is_here(btVector3 start, btVector3 stop, btScalar radius) const;
    
    /** Get the posistion of the point.
     * The handle should be drawn here for is_here to match up.
     */
    const btVector3 & get_position() const;
    
    /** Set the posistion of the point.
     */
    virtual void set_position(const btVector3 & new_position);
    
    /** Draw the control point for the editor.
     * May draw additional lines to show bounds or to indicate what it relates
     * to.
     * 
     * Uses OpenGL commands. It expects the modelview matrix to translate
     * points from world space. Point and line primitives may be drawn.
     * After calling, the current OpenGL colour could be anything.
     */
    virtual void draw() const = 0;
protected:
    btVector3 position;
};

}

}

#endif // CONTROL_POINT_H_
