/** @file libtrack/edit_base/ControlPoint.cpp
 *  @brief Implement the Track::EditAssist::ControlPoint class. 
 *  @author James Legg
 */
/* Copyright © 2009 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/

#include "ControlPoint.h"

namespace Track
{

namespace EditAssist
{

bool ControlPoint::is_here(btVector3 start, btVector3 stop, btScalar radius) const
{
    btVector3 line = stop - start;
    btVector3 to_start = position - start;
    btScalar u = to_start.dot(line) / line.length2();
    // Is it behind or infront of visible depth range?
    if (u < 0.0 || u > 1.0)
    {
        return false;
    }
    btScalar distance2 = (u * line).distance2(to_start);
    if (distance2 < radius * radius)
    {
        return true;
    }
    return false;
}
    
const btVector3 & ControlPoint::get_position() const
{
    return position;
}

void ControlPoint::set_position(const btVector3 & new_position)
{
    position = new_position;
}

}

}

