/** @file document/SymmetricDelta.h
 *  @brief Declare the Document::SymmetricDelta class. 
 *  @author James Legg
 */
/* Copyright © 2009 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/
#ifndef LIBTRACK_DOCUMENT_SYMMETRIC_DELTA_H_
#define LIBTRACK_DOCUMENT_SYMMETRIC_DELTA_H_

#include "DocumentDelta.h"


namespace Document
{

/** A DocumentDelta where apply and unapply are the same thing.
 * This is used where apply reverses something, so that unapply can use
 * exactly the same code to end up in the original state.
 */
class SymmetricDelta
    :   public DocumentDelta
{
public:
    SymmetricDelta();
    virtual ~SymmetricDelta();
    
    /** Reverse the change by using apply again.
     */
    void unapply(Track::Track & track);
};

} // namespace Document

#endif // LIBTRACK_DOCUMENT_SYMMETRIC_DELTA_H_
