/** @file document/StackableDelta.cpp
 *  @brief Implement the Document::StackableDelta class. 
 *  @author James Legg
 */
/* Copyright © 2009 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/

#include "StackableDelta.h"

namespace Document
{

StackableDelta::StackableDelta()
{
}

StackableDelta::~StackableDelta()
{
}

void StackableDelta::unapply(Track::Track & track)
{
    while (!delta_stack.empty())
    {
        delta_stack.back()->unapply(track);
        delta_stack.pop_back();
    }
}

void StackableDelta::add_to_stack(boost::shared_ptr<DocumentDelta> delta, Track::Track & track)
{
    delta_stack.push_back(delta);
    delta->apply(track);
}

} // Document namespace
