/** @file document/SetStartEdgeDelta.h
 *  @brief Declare the Document::SetStartEdgeDelta, Document::StartEdgeFinder,
 *  and Document::SetStartPositionsDelta classes.
 *  @author James Legg
 */
/* Copyright © 2009, 2010 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/

#ifndef LIBTRACK_DOCUMENT_SET_START_EDGE_DELTA_H
#define LIBTRACK_DOCUMENT_SET_START_EDGE_DELTA_H

#include "ChangePropertyDelta.h"
#include "StackableDelta.h"

namespace Document
{

/** Find a path's starting edge.
 */
class StartEdgeFinder : public PropertyDeltaIdentifier<unsigned long int>
{
public:
    StartEdgeFinder();
    virtual void read(const Track::Track & track, unsigned long int & edge_name);
    virtual void write(Track::Track & track, const unsigned long int & new_edge_name);
};

/** Command for changing the starting edge of the path.
 */
typedef ChangePropertyDelta<StartEdgeFinder, unsigned long int> SetStartEdgeDelta;

/** Command for creating start positions and other related tasks.
 * Changes the starting edge, removes old start markers, and adds new start
 * markers.
 */
class SetStartPositionsDelta
    :   public StackableDelta
{
public:
    /** Create command to make the given edge contain the start positions
     * @param edge_name The name of the edge you wish to make the start edge
     * in the track's path. This edge will contain the Track::StartMarkers,
     * and the edge's end controls the start/finish disk.
     */
    SetStartPositionsDelta(const unsigned int edge_name);
    virtual void apply(Track::Track & track);
protected:
    /// The name 
    unsigned int m_edge_name;
};

} // namespace Document

#endif // LIBTRACK_DOCUMENT_SET_START_EDGE_DELTA_H
