/** @file document/SetEdgeStrengthDelta.h
 *  @brief Declare the Document::SetEdgeStrengthDelta and Document::EdgeStrengthFinder class. 
 *  @author James Legg
 */
/* Copyright © 2009 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/

#ifndef LIBTRACK_DOCUMENT_SET_EDGE_STRENGTH_DELTA_H
#define LIBTRACK_DOCUMENT_SET_EDGE_STRENGTH_DELTA_H

#include "ChangePropertyDelta.h"

#include <LinearMath/btVector3.h>

#include "../edit_base/EdgeStrengthHandle.h"

namespace Document
{

/** Find or set the edge gradient strength at an end of an edge edge.
 */
class EdgeStrengthFinder : public PropertyDeltaIdentifier<btScalar>
{
public:
    typedef Track::EditAssist::EdgeStrengthHandle::EdgeEnd EdgeEndEnum;
    /** Create, associating with an end of an edge.
     * @param edge_index The name of the edge to associate with.
     * @param end The end of the edge to associate with.
     */
    EdgeStrengthFinder(std::size_t edge_index, EdgeEndEnum end);
    
    /** Get the gradient strength of the associate edge end.
     * @param track The Track the associated edge is in.
     * @param strength Variable to set to the current gradient strength.
     */
    virtual void read(const Track::Track & track, btScalar & strength);
    
    /** Set the strength of the assoicated edge end.
     * @param track The Track the associated edge is in.
     * @param new_strength The location to move the associated vertex to.
     */
    virtual void write(Track::Track & track, const btScalar & new_strength);
protected:
    /// The name of the associated edge.
    std::size_t edge_index;
    /// The end of the edge to use.
    EdgeEndEnum end;
};

/** Command for changing the edge gradient strength at one end of an edge.
*/
typedef ChangePropertyDelta<EdgeStrengthFinder, btScalar> SetEdgeStrengthDelta;

}

#endif // LIBTRACK_DOCUMENT_SET_EDGE_STRENGTH_DELTA_H
