/** @file document/SetEdgeStrengthDelta.cpp
 *  @brief Implement the Document::SetEdgeStrengthDelta and Document::EdgeStrengthFinder class. 
 *  @author James Legg
 */
/* Copyright © 2009 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/

#include "SetEdgeStrengthDelta.h"
#include "../Track.h"

namespace Document
{

EdgeStrengthFinder::EdgeStrengthFinder(std::size_t edge_index, EdgeEndEnum end)
    :   edge_index(edge_index)
    ,   end(end)
{
}

void EdgeStrengthFinder::read(const Track::Track & track, btScalar & strength)
{
    const Track::PathEdge & edge = track.get_path().get_edge(edge_index);
    const Track::PathEdgeEnd & edge_end = end == Track::EditAssist::EdgeStrengthHandle::EE_SOURCE ? edge.start : edge.finish;
    strength = edge_end.gradient_strength;
}

void EdgeStrengthFinder::write(Track::Track & track, const btScalar & new_strength)
{
    Track::Path & path = track.get_path();
    Track::Path::Graph::edge_descriptor edge_descriptor = path.get_edge_descriptor(edge_index);
    Track::PathEdge & edge = path.graph[edge_descriptor];
    Track::PathEdgeEnd & edge_end = end == Track::EditAssist::EdgeStrengthHandle::EE_SOURCE ? edge.start : edge.finish;
    edge_end.gradient_strength = new_strength;
    edge.update();
}

}
