/** @file document/RotateVertexDelta.cpp
 *  @brief Implement the Document::RotateVertexDelta and Document::VertexAngleFinder classes.
 *  @author James Legg
 */
/* Copyright © 2009 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/

#include "RotateVertexDelta.h"
#include "../Track.h"

namespace Document
{

VertexAngleFinder::VertexAngleFinder(std::size_t vertex_id)
    :   vertex_id(vertex_id)
{
}

void VertexAngleFinder::read(const Track::Track & track, btQuaternion & angle)
{
    angle = track.get_path().get_node(vertex_id).get_angle();
}

void VertexAngleFinder::write(Track::Track & track, const btQuaternion & new_angle)
{
    Track::Path & path = track.get_path();
    Track::Path::Graph::vertex_descriptor vertex_descriptor = path.get_node_descriptor(vertex_id);
    Track::PathVertex & vertex = path.graph[vertex_descriptor];
    vertex.set_angle(new_angle);
    path.update_connected_edges(vertex_descriptor);
}

}
